/* backend.c generated by valac 0.18.0.110-5650, the Vala compiler
 * generated from backend.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libedataserver/libedataserver.h>
#include <stdlib.h>
#include <string.h>
#include <libebook/libebook.h>
#include <gee.h>
#include <folks/folks-eds.h>
#include <folks/folks.h>
#include <gobject/gvaluecollector.h>


#define EDS_TEST_TYPE_BACKEND (eds_test_backend_get_type ())
#define EDS_TEST_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackend))
#define EDS_TEST_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))
#define EDS_TEST_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))

typedef struct _EdsTestBackend EdsTestBackend;
typedef struct _EdsTestBackendClass EdsTestBackendClass;
typedef struct _EdsTestBackendPrivate EdsTestBackendPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _eds_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (eds_test_backend_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _EdsTestBackendUpdateContactData EdsTestBackendUpdateContactData;
typedef struct _EdsTestBackendRemoveContactData EdsTestBackendRemoveContactData;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _EdsTestBackendPrepareSourceAsyncData EdsTestBackendPrepareSourceAsyncData;
typedef struct _EdsTestBackendCommitContactsToAddressbookData EdsTestBackendCommitContactsToAddressbookData;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define __vala_EContactPhoto_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactPhoto_free (var), NULL)))
#define __vala_EContactName_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactName_free (var), NULL)))
#define __vala_EContactAddress_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactAddress_free (var), NULL)))
typedef struct _EdsTestParamSpecBackend EdsTestParamSpecBackend;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	EDS_TEST_BACKEND_SETUP_ERROR_FETCH_SOURCE_GROUP_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_OPENING_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_ADD_TO_SOURCE_GROUP_FAILED
} EdsTestBackendSetupError;
#define EDS_TEST_BACKEND_SETUP_ERROR eds_test_backend_setup_error_quark ()
struct _EdsTestBackend {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EdsTestBackendPrivate * priv;
};

struct _EdsTestBackendClass {
	GTypeClass parent_class;
	void (*finalize) (EdsTestBackend *self);
};

struct _EdsTestBackendPrivate {
	gchar* _addressbook_name;
	EBookClient* _addressbook;
	GList* _e_contacts;
	GList* _contacts;
	ESourceRegistry* _source_registry;
	ESource* _source;
	GFile* _source_file;
};

struct _EdsTestBackendUpdateContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gint contact_pos;
	GeeHashMap* updated_data;
	GList* _tmp0_;
	gint _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	gchar* uid;
	EContact* contact;
	EBookClient* _tmp4_;
	const gchar* _tmp5_;
	EContact* _tmp6_;
	EContact* _tmp7_;
	GeeHashMap* _tmp8_;
	EBookClient* _tmp9_;
	EContact* _tmp10_;
	GError* e;
	GError * _inner_error_;
};

struct _EdsTestBackendRemoveContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gint contact_pos;
	GList* _tmp0_;
	gint _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	gchar* uid;
	EContact* contact;
	EBookClient* _tmp4_;
	const gchar* _tmp5_;
	EContact* _tmp6_;
	EBookClient* _tmp7_;
	EContact* _tmp8_;
	GError* e;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	EdsTestBackend * self;
	GMainLoop* mainloop;
};

struct _Block2Data {
	int _ref_count_;
	EdsTestBackend * self;
	gpointer _async_data_;
};

struct _EdsTestBackendPrepareSourceAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gboolean is_default;
	Block2Data* _data2_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* source_file_name;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* config_dir;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* source_file;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* source_file_content;
	ESourceRegistry* _tmp14_;
	ESourceRegistry* _tmp15_;
	ESourceRegistry* _tmp16_;
	gulong _tmp17_;
	gulong signal_id;
	GFile* _tmp18_;
	const gchar* _tmp19_;
	guint8* _tmp20_;
	gint _tmp20__length1;
	guint8* _tmp21_;
	gint _tmp21__length1;
	ESourceRegistry* _tmp22_;
	const gchar* _tmp23_;
	ESource* _tmp24_;
	ESource* _tmp25_;
	ESource* _tmp26_;
	ESourceRegistry* _tmp27_;
	gulong _tmp28_;
	GFile* _tmp29_;
	GFile* _tmp30_;
	gboolean _tmp31_;
	GError * _inner_error_;
};

struct _EdsTestBackendCommitContactsToAddressbookData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	GList* _tmp0_;
	GList* c_collection;
	GList* c_it;
	GeeHashMap* _tmp1_;
	GeeHashMap* c;
	EContact* _tmp2_;
	EContact* contact;
	EContact* _tmp3_;
	GeeHashMap* _tmp4_;
	gchar* added_uid;
	EBookClient* _tmp5_;
	EContact* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError * _inner_error_;
};

struct _EdsTestParamSpecBackend {
	GParamSpec parent_instance;
};


static gpointer eds_test_backend_parent_class = NULL;

void e_source_registry_new (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
ESourceRegistry* e_source_registry_new_finish (GAsyncResult* _res_, GError** error);
GQuark eds_test_backend_setup_error_quark (void);
gpointer eds_test_backend_ref (gpointer instance);
void eds_test_backend_unref (gpointer instance);
GParamSpec* eds_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void eds_test_value_set_backend (GValue* value, gpointer v_object);
void eds_test_value_take_backend (GValue* value, gpointer v_object);
gpointer eds_test_value_get_backend (const GValue* value);
GType eds_test_backend_get_type (void) G_GNUC_CONST;
#define EDS_TEST_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EDS_TEST_TYPE_BACKEND, EdsTestBackendPrivate))
enum  {
	EDS_TEST_BACKEND_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
EdsTestBackend* eds_test_backend_new (void);
EdsTestBackend* eds_test_backend_construct (GType object_type);
void eds_test_backend_add_contact (EdsTestBackend* self, GeeHashMap* c);
static void eds_test_backend_update_contact_data_free (gpointer _data);
void eds_test_backend_update_contact (EdsTestBackend* self, gint contact_pos, GeeHashMap* updated_data, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_update_contact_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_update_contact_co (EdsTestBackendUpdateContactData* _data_);
static void eds_test_backend_update_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _eds_test_backend_set_contact_fields (EdsTestBackend* self, EContact* contact, GeeHashMap* c);
static void eds_test_backend_remove_contact_data_free (gpointer _data);
void eds_test_backend_remove_contact (EdsTestBackend* self, gint contact_pos, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_remove_contact_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_remove_contact_co (EdsTestBackendRemoveContactData* _data_);
static void eds_test_backend_remove_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void eds_test_backend_reset (EdsTestBackend* self);
void eds_test_backend_set_up (EdsTestBackend* self, gboolean source_is_default, const gchar* name);
static void _eds_test_backend_prepare_source (EdsTestBackend* self, gboolean is_default);
void eds_test_backend_set_as_default (EdsTestBackend* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _eds_test_backend_prepare_source_async (EdsTestBackend* self, gboolean is_default, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _eds_test_backend_prepare_source_finish (EdsTestBackend* self, GAsyncResult* _res_, GError** error);
static void __lambda3_ (Block1Data* _data1_, GObject* obj, GAsyncResult* async_res);
static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _eds_test_backend_prepare_source_async_data_free (gpointer _data);
static gboolean _eds_test_backend_prepare_source_async_co (EdsTestBackendPrepareSourceAsyncData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _eds_test_backend_prepare_source_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda2_ (Block2Data* _data2_, ESourceRegistry* r, ESource* s);
static void ___lambda2__e_source_registry_source_added (ESourceRegistry* _sender, ESource* source, gpointer self);
static void eds_test_backend_commit_contacts_to_addressbook_data_free (gpointer _data);
void eds_test_backend_commit_contacts_to_addressbook (EdsTestBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_commit_contacts_to_addressbook_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_commit_contacts_to_addressbook_co (EdsTestBackendCommitContactsToAddressbookData* _data_);
static void eds_test_backend_commit_contacts_to_addressbook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_GValue_free (GValue* self);
static void _vala_EContactPhoto_free (EContactPhoto* self);
static void _vala_EContactName_free (EContactName* self);
static GeeHashMap* _eds_test_backend_parse_im_addrs (EdsTestBackend* self, const gchar* addr_str);
static void _vala_EContactAddress_free (EContactAddress* self);
void eds_test_backend_tear_down (EdsTestBackend* self);
const gchar* eds_test_backend_get_address_book_uid (EdsTestBackend* self);
static void eds_test_backend_finalize (EdsTestBackend* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark eds_test_backend_setup_error_quark (void) {
	return g_quark_from_static_string ("eds_test_backend_setup_error-quark");
}


static void _g_free0_ (gpointer var) {
#line 42 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	var = (g_free (var), NULL);
#line 313 "backend.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 42 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 42 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_list_free (self);
#line 322 "backend.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 43 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 329 "backend.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 43 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 43 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_list_free (self);
#line 338 "backend.c"
}


EdsTestBackend* eds_test_backend_construct (GType object_type) {
	EdsTestBackend* self = NULL;
#line 53 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self = (EdsTestBackend*) g_type_create_instance (object_type);
#line 55 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 55 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = NULL;
#line 56 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_free0_0 (self->priv->_e_contacts);
#line 56 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = NULL;
#line 53 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return self;
#line 356 "backend.c"
}


EdsTestBackend* eds_test_backend_new (void) {
#line 53 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return eds_test_backend_construct (EDS_TEST_TYPE_BACKEND);
#line 363 "backend.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 61 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 370 "backend.c"
}


void eds_test_backend_add_contact (EdsTestBackend* self, GeeHashMap* c) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
#line 59 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 59 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (c != NULL);
#line 61 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = c;
#line 61 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 61 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = g_list_prepend (self->priv->_contacts, _tmp1_);
#line 59 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (c);
#line 389 "backend.c"
}


static void eds_test_backend_update_contact_data_free (gpointer _data) {
	EdsTestBackendUpdateContactData* _data_;
	_data_ = _data;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendUpdateContactData, _data_);
#line 402 "backend.c"
}


static gpointer _eds_test_backend_ref0 (gpointer self) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return self ? eds_test_backend_ref (self) : NULL;
#line 409 "backend.c"
}


void eds_test_backend_update_contact (EdsTestBackend* self, gint contact_pos, GeeHashMap* updated_data, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendUpdateContactData* _data_;
	EdsTestBackend* _tmp0_;
	gint _tmp1_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendUpdateContactData);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_update_contact);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_update_contact_data_free);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = contact_pos;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->contact_pos = _tmp1_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->updated_data = updated_data;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	eds_test_backend_update_contact_co (_data_);
#line 437 "backend.c"
}


void eds_test_backend_update_contact_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendUpdateContactData* _data_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 445 "backend.c"
}


static void eds_test_backend_update_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendUpdateContactData* _data_;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	eds_test_backend_update_contact_co (_data_);
#line 459 "backend.c"
}


static gboolean eds_test_backend_update_contact_co (EdsTestBackendUpdateContactData* _data_) {
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 0:
#line 468 "backend.c"
		goto _state_0;
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 1:
#line 472 "backend.c"
		goto _state_1;
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 2:
#line 476 "backend.c"
		goto _state_2;
		default:
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 481 "backend.c"
	}
	_state_0:
#line 67 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_e_contacts;
#line 67 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = _data_->contact_pos;
#line 67 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = NULL;
#line 67 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = g_list_nth_data (_data_->_tmp0_, (guint) _data_->_tmp1_);
#line 67 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = g_strdup ((const gchar*) _data_->_tmp2_);
#line 67 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->uid = _data_->_tmp3_;
#line 496 "backend.c"
	{
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp4_ = _data_->self->priv->_addressbook;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp5_ = _data_->uid;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp6_ = NULL;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 1;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact (_data_->_tmp4_, _data_->_tmp5_, NULL, eds_test_backend_update_contact_ready, _data_);
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 510 "backend.c"
		_state_1:
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->contact = _data_->_tmp6_;
#line 71 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 520 "backend.c"
			goto __catch0_g_error;
		}
#line 72 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = _data_->contact;
#line 72 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = _data_->updated_data;
#line 72 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_set_contact_fields (_data_->self, _data_->_tmp7_, _data_->_tmp8_);
#line 73 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp9_ = _data_->self->priv->_addressbook;
#line 73 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp10_ = _data_->contact;
#line 73 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 2;
#line 73 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_modify_contact (_data_->_tmp9_, _data_->_tmp10_, NULL, eds_test_backend_update_contact_ready, _data_);
#line 73 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 539 "backend.c"
		_state_2:
#line 73 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_modify_contact_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
#line 73 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 545 "backend.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->e = _data_->_inner_error_;
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_inner_error_ = NULL;
#line 77 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:77: Couldn't update contact\n");
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (_data_->e);
#line 560 "backend.c"
	}
	__finally0:
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->uid);
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->updated_data);
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_data_->_inner_error_);
#line 69 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 577 "backend.c"
	}
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->contact);
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->uid);
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 589 "backend.c"
	} else {
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 593 "backend.c"
	}
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 64 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 599 "backend.c"
}


static void eds_test_backend_remove_contact_data_free (gpointer _data) {
	EdsTestBackendRemoveContactData* _data_;
	_data_ = _data;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendRemoveContactData, _data_);
#line 610 "backend.c"
}


void eds_test_backend_remove_contact (EdsTestBackend* self, gint contact_pos, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendRemoveContactData* _data_;
	EdsTestBackend* _tmp0_;
	gint _tmp1_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendRemoveContactData);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_remove_contact);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_remove_contact_data_free);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = contact_pos;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->contact_pos = _tmp1_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	eds_test_backend_remove_contact_co (_data_);
#line 634 "backend.c"
}


void eds_test_backend_remove_contact_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendRemoveContactData* _data_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 642 "backend.c"
}


static void eds_test_backend_remove_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendRemoveContactData* _data_;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	eds_test_backend_remove_contact_co (_data_);
#line 656 "backend.c"
}


static gboolean eds_test_backend_remove_contact_co (EdsTestBackendRemoveContactData* _data_) {
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 0:
#line 665 "backend.c"
		goto _state_0;
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 1:
#line 669 "backend.c"
		goto _state_1;
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 2:
#line 673 "backend.c"
		goto _state_2;
		default:
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 678 "backend.c"
	}
	_state_0:
#line 83 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_e_contacts;
#line 83 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = _data_->contact_pos;
#line 83 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = NULL;
#line 83 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = g_list_nth_data (_data_->_tmp0_, (guint) _data_->_tmp1_);
#line 83 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = g_strdup ((const gchar*) _data_->_tmp2_);
#line 83 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->uid = _data_->_tmp3_;
#line 693 "backend.c"
	{
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp4_ = _data_->self->priv->_addressbook;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp5_ = _data_->uid;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp6_ = NULL;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 1;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact (_data_->_tmp4_, _data_->_tmp5_, NULL, eds_test_backend_remove_contact_ready, _data_);
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 707 "backend.c"
		_state_1:
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->contact = _data_->_tmp6_;
#line 87 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 717 "backend.c"
			goto __catch1_g_error;
		}
#line 88 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = _data_->self->priv->_addressbook;
#line 88 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = _data_->contact;
#line 88 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 2;
#line 88 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_remove_contact (_data_->_tmp7_, _data_->_tmp8_, NULL, eds_test_backend_remove_contact_ready, _data_);
#line 88 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 730 "backend.c"
		_state_2:
#line 88 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_book_client_remove_contact_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 88 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 736 "backend.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->e = _data_->_inner_error_;
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_inner_error_ = NULL;
#line 92 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:92: Couldn't remove contact\n");
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (_data_->e);
#line 751 "backend.c"
	}
	__finally1:
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->uid);
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_data_->_inner_error_);
#line 85 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 766 "backend.c"
	}
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->contact);
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->uid);
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 776 "backend.c"
	} else {
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 780 "backend.c"
	}
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 81 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 786 "backend.c"
}


void eds_test_backend_reset (EdsTestBackend* self) {
#line 96 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 98 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 98 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = NULL;
#line 99 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_free0_0 (self->priv->_e_contacts);
#line 99 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = NULL;
#line 801 "backend.c"
}


void eds_test_backend_set_up (EdsTestBackend* self, gboolean source_is_default, const gchar* name) {
	GError * _inner_error_ = NULL;
#line 103 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 103 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (name != NULL);
#line 811 "backend.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gboolean _tmp2_;
		ESource* _tmp3_;
		EBookClient* _tmp4_;
		EBookClient* _tmp5_;
		EBookClient* _tmp6_;
		const gchar* _tmp7_;
#line 108 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp0_ = name;
#line 108 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 108 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_free0 (self->priv->_addressbook_name);
#line 108 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		self->priv->_addressbook_name = _tmp1_;
#line 110 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp2_ = source_is_default;
#line 110 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_prepare_source (self, _tmp2_);
#line 111 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp3_ = self->priv->_source;
#line 111 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp4_ = e_book_client_new (_tmp3_, &_inner_error_);
#line 111 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp5_ = _tmp4_;
#line 111 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_inner_error_ != NULL) {
#line 841 "backend.c"
			goto __catch2_g_error;
		}
#line 111 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_addressbook);
#line 111 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		self->priv->_addressbook = _tmp5_;
#line 112 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp6_ = self->priv->_addressbook;
#line 112 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_client_open_sync ((EClient*) _tmp6_, FALSE, NULL, &_inner_error_);
#line 112 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_inner_error_ != NULL) {
#line 854 "backend.c"
			goto __catch2_g_error;
		}
#line 113 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp7_ = self->priv->_addressbook_name;
#line 113 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_setenv ("FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS", _tmp7_, TRUE);
#line 861 "backend.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
#line 105 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 105 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 118 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp8_ = e;
#line 118 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp9_ = _tmp8_->message;
#line 118 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:118: Unable to create test data: %s\n", _tmp9_);
#line 105 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 881 "backend.c"
	}
	__finally2:
#line 105 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_inner_error_ != NULL) {
#line 105 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 105 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 105 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return;
#line 892 "backend.c"
	}
}


void eds_test_backend_set_as_default (EdsTestBackend* self) {
	ESourceRegistry* _tmp0_;
	ESource* _tmp1_;
#line 122 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 124 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = self->priv->_source_registry;
#line 124 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = self->priv->_source;
#line 124 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	e_source_registry_set_default_address_book (_tmp0_, _tmp1_);
#line 908 "backend.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return _data1_;
#line 917 "backend.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 926 "backend.c"
		EdsTestBackend * self;
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		self = _data1_->self;
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_main_loop_unref0 (_data1_->mainloop);
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_unref0 (self);
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_slice_free (Block1Data, _data1_);
#line 936 "backend.c"
	}
}


static void __lambda3_ (Block1Data* _data1_, GObject* obj, GAsyncResult* async_res) {
	EdsTestBackend * self;
	GError * _inner_error_ = NULL;
#line 131 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self = _data1_->self;
#line 131 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (async_res != NULL);
#line 948 "backend.c"
	{
		GAsyncResult* _tmp0_;
#line 135 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp0_ = async_res;
#line 135 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_prepare_source_finish (self, _tmp0_, &_inner_error_);
#line 135 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_inner_error_ != NULL) {
#line 957 "backend.c"
			goto __catch3_g_error;
		}
#line 136 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_main_loop_quit (_data1_->mainloop);
#line 962 "backend.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 133 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 133 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 140 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp1_ = e;
#line 140 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp2_ = _tmp1_->message;
#line 140 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_critical ("backend.vala:140: %s", _tmp2_);
#line 133 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 982 "backend.c"
	}
	__finally3:
#line 133 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_inner_error_ != NULL) {
#line 133 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 133 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 133 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return;
#line 993 "backend.c"
	}
}


static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 131 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	__lambda3_ (self, source_object, res);
#line 131 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	block1_data_unref (self);
#line 1003 "backend.c"
}


static void _eds_test_backend_prepare_source (EdsTestBackend* self, gboolean is_default) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_;
	gboolean _tmp1_;
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data1_->_ref_count_ = 1;
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data1_->self = eds_test_backend_ref (self);
#line 129 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 129 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data1_->mainloop = _tmp0_;
#line 131 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = is_default;
#line 131 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_prepare_source_async (self, _tmp1_, ___lambda3__gasync_ready_callback, block1_data_ref (_data1_));
#line 144 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_main_loop_run (_data1_->mainloop);
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	block1_data_unref (_data1_);
#line 127 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data1_ = NULL;
#line 1033 "backend.c"
}


static void _eds_test_backend_prepare_source_async_data_free (gpointer _data) {
	EdsTestBackendPrepareSourceAsyncData* _data_;
	_data_ = _data;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendPrepareSourceAsyncData, _data_);
#line 1044 "backend.c"
}


static void _eds_test_backend_prepare_source_async (EdsTestBackend* self, gboolean is_default, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendPrepareSourceAsyncData* _data_;
	EdsTestBackend* _tmp0_;
	gboolean _tmp1_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendPrepareSourceAsyncData);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, _eds_test_backend_prepare_source_async);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _eds_test_backend_prepare_source_async_data_free);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = is_default;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->is_default = _tmp1_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_prepare_source_async_co (_data_);
#line 1068 "backend.c"
}


static void _eds_test_backend_prepare_source_finish (EdsTestBackend* self, GAsyncResult* _res_, GError** error) {
	EdsTestBackendPrepareSourceAsyncData* _data_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return;
#line 1078 "backend.c"
	}
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1082 "backend.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return _data2_;
#line 1091 "backend.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1100 "backend.c"
		EdsTestBackend * self;
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		self = _data2_->self;
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_unref0 (self);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_slice_free (Block2Data, _data2_);
#line 1108 "backend.c"
	}
}


static void _eds_test_backend_prepare_source_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendPrepareSourceAsyncData* _data_;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_prepare_source_async_co (_data_);
#line 1123 "backend.c"
}


static void __lambda2_ (Block2Data* _data2_, ESourceRegistry* r, ESource* s) {
	EdsTestBackend * self;
	ESource* _tmp0_;
	ESource* _tmp1_;
#line 166 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self = _data2_->self;
#line 166 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (r != NULL);
#line 166 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (s != NULL);
#line 168 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = s;
#line 168 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 168 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source);
#line 168 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_source = _tmp1_;
#line 169 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_prepare_source_async_co (_data2_->_async_data_);
#line 1147 "backend.c"
}


static void ___lambda2__e_source_registry_source_added (ESourceRegistry* _sender, ESource* source, gpointer self) {
#line 166 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	__lambda2_ (self, _sender, source);
#line 1154 "backend.c"
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
#line 1250 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1251 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1251 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1251 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1252 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1252 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1252 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1252 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1253 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1253 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1253 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1253 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1253 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1253 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 1198 "backend.c"
	}
#line 1253 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1253 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 1204 "backend.c"
}


static gboolean _eds_test_backend_prepare_source_async_co (EdsTestBackendPrepareSourceAsyncData* _data_) {
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 0:
#line 1213 "backend.c"
		goto _state_0;
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 1:
#line 1217 "backend.c"
		goto _state_1;
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 2:
#line 1221 "backend.c"
		goto _state_2;
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 3:
#line 1225 "backend.c"
		goto _state_3;
		default:
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 1230 "backend.c"
	}
	_state_0:
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_data2_->self = eds_test_backend_ref (_data_->self);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 150 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_addressbook_name;
#line 150 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = g_strconcat (_data_->_tmp0_, ".source", NULL);
#line 150 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->source_file_name = _data_->_tmp1_;
#line 152 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = NULL;
#line 152 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = g_get_user_config_dir ();
#line 152 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = NULL;
#line 152 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = g_file_new_for_path (_data_->_tmp2_);
#line 152 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->config_dir = _data_->_tmp3_;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp4_ = _data_->config_dir;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp5_ = NULL;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp5_ = g_file_get_child (_data_->_tmp4_, "evolution");
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp7_ = NULL;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp7_ = g_file_get_child (_data_->_tmp6_, "sources");
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp9_ = _data_->source_file_name;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp10_ = NULL;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp10_ = g_file_get_child (_data_->_tmp8_, _data_->_tmp9_);
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->_tmp8_);
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->_tmp6_);
#line 153 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->source_file = _data_->_tmp11_;
#line 156 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp12_ = _data_->self->priv->_addressbook_name;
#line 156 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp13_ = NULL;
#line 156 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp13_ = g_strdup_printf ("[Data Source]\n" "DisplayName=%s\n" "Enabled=true\n" "Parent=local-stub\n" "\n" "[Address Book]\n" "BackendName=local\n", _data_->_tmp12_);
#line 156 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->source_file_content = _data_->_tmp13_;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_state_ = 1;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	e_source_registry_new (NULL, _eds_test_backend_prepare_source_async_ready, _data_);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1299 "backend.c"
	_state_1:
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp14_ = NULL;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp14_ = e_source_registry_new_finish (_data_->_res_, &_data_->_inner_error_);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp15_ = _data_->_tmp14_;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_error_free (_data_->_inner_error_);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->source_file_content);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->source_file);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->config_dir);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->source_file_name);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		block2_data_unref (_data_->_data2_);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_data2_ = NULL;
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_data_->_state_ == 0) {
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1329 "backend.c"
		} else {
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1333 "backend.c"
		}
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_object_unref (_data_->_async_result);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1339 "backend.c"
	}
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->self->priv->_source_registry);
#line 165 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_source_registry = _data_->_tmp15_;
#line 166 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp16_ = _data_->self->priv->_source_registry;
#line 166 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp17_ = 0UL;
#line 166 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp17_ = g_signal_connect_data (_data_->_tmp16_, "source-added", (GCallback) ___lambda2__e_source_registry_source_added, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
#line 166 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->signal_id = _data_->_tmp17_;
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp18_ = _data_->source_file;
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp19_ = _data_->source_file_content;
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp20_ = string_get_data (_data_->_tmp19_, &_data_->_tmp20__length1);
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp21_ = _data_->_tmp20_;
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp21__length1 = _data_->_tmp20__length1;
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_state_ = 2;
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_file_replace_contents_async (_data_->_tmp18_, _data_->_tmp21_, (gsize) _data_->_tmp21__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, _eds_test_backend_prepare_source_async_ready, _data_);
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1369 "backend.c"
	_state_2:
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_file_replace_contents_finish (_data_->_tmp18_, _data_->_res_, NULL, &_data_->_inner_error_);
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_error_free (_data_->_inner_error_);
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->source_file_content);
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->source_file);
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->config_dir);
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->source_file_name);
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		block2_data_unref (_data_->_data2_);
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_data2_ = NULL;
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_data_->_state_ == 0) {
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1395 "backend.c"
		} else {
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1399 "backend.c"
		}
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_object_unref (_data_->_async_result);
#line 173 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1405 "backend.c"
	}
#line 175 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp22_ = _data_->self->priv->_source_registry;
#line 175 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp23_ = _data_->self->priv->_addressbook_name;
#line 175 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp24_ = NULL;
#line 175 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp24_ = e_source_registry_ref_source (_data_->_tmp22_, _data_->_tmp23_);
#line 175 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->self->priv->_source);
#line 175 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_source = _data_->_tmp24_;
#line 176 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp25_ = _data_->self->priv->_source;
#line 176 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_tmp25_ == NULL) {
#line 178 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 3;
#line 178 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1427 "backend.c"
		_state_3:
		;
	}
#line 182 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp26_ = _data_->self->priv->_source;
#line 182 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_vala_assert (_data_->_tmp26_ != NULL, "this._source != null");
#line 183 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp27_ = _data_->self->priv->_source_registry;
#line 183 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp28_ = _data_->signal_id;
#line 183 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_signal_handler_disconnect ((GObject*) _data_->_tmp27_, _data_->_tmp28_);
#line 185 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp29_ = _data_->source_file;
#line 185 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp30_ = _g_object_ref0 (_data_->_tmp29_);
#line 185 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->self->priv->_source_file);
#line 185 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_source_file = _data_->_tmp30_;
#line 187 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp31_ = _data_->is_default;
#line 187 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_tmp31_) {
#line 189 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		eds_test_backend_set_as_default (_data_->self);
#line 1455 "backend.c"
	}
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->source_file_content);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->source_file);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->config_dir);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->source_file_name);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	block2_data_unref (_data_->_data2_);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_data2_ = NULL;
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1473 "backend.c"
	} else {
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1477 "backend.c"
	}
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 147 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1483 "backend.c"
}


static void eds_test_backend_commit_contacts_to_addressbook_data_free (gpointer _data) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
	_data_ = _data;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendCommitContactsToAddressbookData, _data_);
#line 1494 "backend.c"
}


void eds_test_backend_commit_contacts_to_addressbook (EdsTestBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
	EdsTestBackend* _tmp0_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendCommitContactsToAddressbookData);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_commit_contacts_to_addressbook);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_commit_contacts_to_addressbook_data_free);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	eds_test_backend_commit_contacts_to_addressbook_co (_data_);
#line 1513 "backend.c"
}


void eds_test_backend_commit_contacts_to_addressbook_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1521 "backend.c"
}


static void eds_test_backend_commit_contacts_to_addressbook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
#line 205 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 205 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 205 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 205 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	eds_test_backend_commit_contacts_to_addressbook_co (_data_);
#line 1535 "backend.c"
}


static gboolean eds_test_backend_commit_contacts_to_addressbook_co (EdsTestBackendCommitContactsToAddressbookData* _data_) {
#line 193 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 193 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 0:
#line 1544 "backend.c"
		goto _state_0;
#line 193 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		case 1:
#line 1548 "backend.c"
		goto _state_1;
		default:
#line 193 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 1553 "backend.c"
	}
	_state_0:
#line 195 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_contacts = g_list_reverse (_data_->self->priv->_contacts);
#line 196 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_contacts;
#line 1560 "backend.c"
	{
#line 196 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_data_->c_collection = _data_->_tmp0_;
#line 196 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		for (_data_->c_it = _data_->c_collection; _data_->c_it != NULL; _data_->c_it = _data_->c_it->next) {
#line 196 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_data_->_tmp1_ = _g_object_ref0 ((GeeHashMap*) _data_->c_it->data);
#line 196 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_data_->c = _data_->_tmp1_;
#line 1570 "backend.c"
			{
#line 198 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_data_->_tmp2_ = e_contact_new ();
#line 198 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_data_->contact = _data_->_tmp2_;
#line 200 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_data_->_tmp3_ = _data_->contact;
#line 200 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_data_->_tmp4_ = _data_->c;
#line 200 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_eds_test_backend_set_contact_fields (_data_->self, _data_->_tmp3_, _data_->_tmp4_);
#line 1582 "backend.c"
				{
#line 205 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_data_->_tmp5_ = _data_->self->priv->_addressbook;
#line 205 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_data_->_tmp6_ = _data_->contact;
#line 205 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_data_->_tmp7_ = NULL;
#line 205 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_data_->_state_ = 1;
#line 205 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					e_book_client_add_contact (_data_->_tmp5_, _data_->_tmp6_, NULL, eds_test_backend_commit_contacts_to_addressbook_ready, _data_);
#line 205 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					return FALSE;
#line 1596 "backend.c"
					_state_1:
#line 205 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					e_book_client_add_contact_finish (_data_->_tmp5_, _data_->_res_, &_data_->_tmp7_, &_data_->_inner_error_);
#line 205 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_g_free0 (_data_->added_uid);
#line 205 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_data_->added_uid = _data_->_tmp7_;
#line 205 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					if (_data_->_inner_error_ != NULL) {
#line 205 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_free0 (_data_->added_uid);
#line 1608 "backend.c"
						goto __catch4_g_error;
					}
#line 207 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_data_->_tmp8_ = _data_->added_uid;
#line 207 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_data_->added_uid = NULL;
#line 207 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_data_->self->priv->_e_contacts = g_list_prepend (_data_->self->priv->_e_contacts, _data_->_tmp8_);
#line 202 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_g_free0 (_data_->added_uid);
#line 1619 "backend.c"
				}
				goto __finally4;
				__catch4_g_error:
				{
#line 202 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_data_->e = _data_->_inner_error_;
#line 202 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_data_->_inner_error_ = NULL;
#line 211 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_data_->_tmp9_ = _data_->e;
#line 211 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_data_->_tmp10_ = _data_->_tmp9_->message;
#line 211 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					g_warning ("backend.vala:211: Couldn't add contact: %s\n", _data_->_tmp10_);
#line 202 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_g_error_free0 (_data_->e);
#line 1636 "backend.c"
				}
				__finally4:
#line 202 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				if (_data_->_inner_error_ != NULL) {
#line 202 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_g_object_unref0 (_data_->contact);
#line 202 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_g_object_unref0 (_data_->c);
#line 202 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 202 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					g_clear_error (&_data_->_inner_error_);
#line 202 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					return FALSE;
#line 1651 "backend.c"
				}
#line 196 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_object_unref0 (_data_->contact);
#line 196 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_object_unref0 (_data_->c);
#line 1657 "backend.c"
			}
		}
	}
#line 215 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_e_contacts = g_list_reverse (_data_->self->priv->_e_contacts);
#line 193 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 193 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1667 "backend.c"
	} else {
#line 193 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1671 "backend.c"
	}
#line 193 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 193 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1677 "backend.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1180 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1181 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1181 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1181 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1182 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1182 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1712 "backend.c"
		glong _tmp3_;
		glong _tmp4_;
#line 1183 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1183 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1183 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1721 "backend.c"
	}
#line 1185 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1185 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1727 "backend.c"
		glong _tmp6_;
		glong _tmp7_;
#line 1186 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1186 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1186 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1736 "backend.c"
	}
#line 1188 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1188 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1742 "backend.c"
		glong _tmp10_;
		glong _tmp11_;
#line 1188 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1188 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1188 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1751 "backend.c"
	} else {
#line 1188 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1755 "backend.c"
	}
#line 1188 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1188 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1189 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1189 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 1765 "backend.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1189 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1189 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1189 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 1774 "backend.c"
	} else {
#line 1189 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 1778 "backend.c"
	}
#line 1189 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1189 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1190 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1190 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1190 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1191 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1191 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1191 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1191 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1191 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1191 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 1802 "backend.c"
}


static void _vala_GValue_free (GValue* self) {
#line 230 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_value_unset (self);
#line 230 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_free (self);
#line 1811 "backend.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
#line 888 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 888 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 889 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 889 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 889 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 889 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 891 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 891 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1838 "backend.c"
		gchar* _tmp4_;
#line 892 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 892 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 892 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1846 "backend.c"
	} else {
#line 894 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		result = -1;
#line 894 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1852 "backend.c"
	}
}


static void _vala_EContactPhoto_free (EContactPhoto* self) {
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_photo_get_type (), self);
#line 1860 "backend.c"
}


static void _vala_EContactName_free (EContactName* self) {
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_name_get_type (), self);
#line 1867 "backend.c"
}


static void _vala_EContactAddress_free (EContactAddress* self) {
#line 296 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_address_get_type (), self);
#line 1874 "backend.c"
}


static void _eds_test_backend_set_contact_fields (EdsTestBackend* self, EContact* contact, GeeHashMap* c) {
	gboolean added_contact_name;
	EContactName* _tmp0_;
	EContactName* contact_name;
	gchar* _tmp1_;
	gchar* contact_field_name;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint min_len;
	gboolean _tmp193_;
	GError * _inner_error_ = NULL;
#line 218 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 218 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (contact != NULL);
#line 218 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (c != NULL);
#line 221 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	added_contact_name = FALSE;
#line 222 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = e_contact_name_new ();
#line 222 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	contact_name = _tmp0_;
#line 223 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = g_strdup ("contact_name");
#line 223 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	contact_field_name = _tmp1_;
#line 224 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp2_ = contact_field_name;
#line 224 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp3_ = strlen (_tmp2_);
#line 224 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp4_ = _tmp3_;
#line 224 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	min_len = _tmp4_;
#line 1914 "backend.c"
	{
		GeeHashMap* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _tmp10_;
		GeeIterator* _k_it;
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp5_ = c;
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp7_ = _tmp6_;
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp8_ = _tmp7_;
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp10_ = _tmp9_;
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_tmp8_);
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_k_it = _tmp10_;
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		while (TRUE) {
#line 1941 "backend.c"
			GeeIterator* _tmp11_;
			gboolean _tmp12_ = FALSE;
			GeeIterator* _tmp13_;
			gpointer _tmp14_ = NULL;
			gchar* k;
			gboolean _tmp15_ = FALSE;
			const gchar* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gboolean _tmp25_;
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp11_ = _k_it;
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp12_ = gee_iterator_next (_tmp11_);
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			if (!_tmp12_) {
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				break;
#line 1961 "backend.c"
			}
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp13_ = _k_it;
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp14_ = gee_iterator_get (_tmp13_);
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			k = (gchar*) _tmp14_;
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp16_ = k;
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp17_ = strlen (_tmp16_);
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp18_ = _tmp17_;
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp19_ = min_len;
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			if (_tmp18_ > _tmp19_) {
#line 1979 "backend.c"
				const gchar* _tmp20_;
				gint _tmp21_;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				const gchar* _tmp24_;
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp20_ = k;
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp21_ = min_len;
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp22_ = string_slice (_tmp20_, (glong) 0, (glong) _tmp21_);
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp23_ = _tmp22_;
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp24_ = contact_field_name;
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp15_ = g_strcmp0 (_tmp23_, _tmp24_) == 0;
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp23_);
#line 1999 "backend.c"
			} else {
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp15_ = FALSE;
#line 2003 "backend.c"
			}
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp25_ = _tmp15_;
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			if (_tmp25_) {
#line 2009 "backend.c"
				GeeHashMap* _tmp26_;
				const gchar* _tmp27_;
				gpointer _tmp28_ = NULL;
				GValue* _tmp29_;
				const gchar* _tmp30_ = NULL;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* v;
				const gchar* _tmp33_;
				gint _tmp34_ = 0;
#line 230 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp26_ = c;
#line 230 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp27_ = k;
#line 230 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp28_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp26_, _tmp27_);
#line 230 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp29_ = (GValue*) _tmp28_;
#line 230 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp30_ = g_value_get_string (_tmp29_);
#line 230 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp31_ = g_strdup (_tmp30_);
#line 230 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp32_ = _tmp31_;
#line 230 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				__vala_GValue_free0 (_tmp29_);
#line 230 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				v = _tmp32_;
#line 231 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp33_ = k;
#line 231 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp34_ = string_index_of (_tmp33_, "family", 0);
#line 231 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				if (_tmp34_ >= 0) {
#line 2044 "backend.c"
					EContactName* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_;
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp35_ = contact_name;
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp36_ = v;
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp37_ = g_strdup (_tmp36_);
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_g_free0 (_tmp35_->family);
#line 233 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp35_->family = _tmp37_;
#line 2058 "backend.c"
				} else {
					const gchar* _tmp38_;
					gint _tmp39_ = 0;
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp38_ = k;
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp39_ = string_index_of (_tmp38_, "given", 0);
#line 235 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					if (_tmp39_ >= 0) {
#line 2068 "backend.c"
						EContactName* _tmp40_;
						const gchar* _tmp41_;
						gchar* _tmp42_;
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp40_ = contact_name;
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp41_ = v;
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp42_ = g_strdup (_tmp41_);
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_free0 (_tmp40_->given);
#line 237 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp40_->given = _tmp42_;
#line 2082 "backend.c"
					} else {
						const gchar* _tmp43_;
						gint _tmp44_ = 0;
#line 239 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp43_ = k;
#line 239 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp44_ = string_index_of (_tmp43_, "additional", 0);
#line 239 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						if (_tmp44_ >= 0) {
#line 2092 "backend.c"
							EContactName* _tmp45_;
							const gchar* _tmp46_;
							gchar* _tmp47_;
#line 241 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp45_ = contact_name;
#line 241 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp46_ = v;
#line 241 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp47_ = g_strdup (_tmp46_);
#line 241 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp45_->additional);
#line 241 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp45_->additional = _tmp47_;
#line 2106 "backend.c"
						} else {
							const gchar* _tmp48_;
							gint _tmp49_ = 0;
#line 243 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp48_ = k;
#line 243 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp49_ = string_index_of (_tmp48_, "prefixes", 0);
#line 243 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							if (_tmp49_ >= 0) {
#line 2116 "backend.c"
								EContactName* _tmp50_;
								const gchar* _tmp51_;
								gchar* _tmp52_;
#line 245 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp50_ = contact_name;
#line 245 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp51_ = v;
#line 245 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp52_ = g_strdup (_tmp51_);
#line 245 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp50_->prefixes);
#line 245 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp50_->prefixes = _tmp52_;
#line 2130 "backend.c"
							} else {
								const gchar* _tmp53_;
								gint _tmp54_ = 0;
#line 247 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp53_ = k;
#line 247 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp54_ = string_index_of (_tmp53_, "suffixes", 0);
#line 247 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								if (_tmp54_ >= 0) {
#line 2140 "backend.c"
									EContactName* _tmp55_;
									const gchar* _tmp56_;
									gchar* _tmp57_;
#line 249 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp55_ = contact_name;
#line 249 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp56_ = v;
#line 249 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp57_ = g_strdup (_tmp56_);
#line 249 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_g_free0 (_tmp55_->suffixes);
#line 249 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp55_->suffixes = _tmp57_;
#line 2154 "backend.c"
								}
							}
						}
					}
				}
#line 252 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				added_contact_name = TRUE;
#line 228 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_free0 (v);
#line 2164 "backend.c"
			} else {
				const gchar* _tmp58_;
#line 254 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp58_ = k;
#line 254 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				if (g_strcmp0 (_tmp58_, "avatar") == 0) {
#line 2171 "backend.c"
					GeeHashMap* _tmp59_;
					const gchar* _tmp60_;
					gpointer _tmp61_ = NULL;
					GValue* _tmp62_;
					const gchar* _tmp63_ = NULL;
					gchar* _tmp64_;
					gchar* _tmp65_;
					gchar* v;
					guint8* photo_content = NULL;
					gint photo_content_length1 = 0;
					gint _photo_content_size_ = 0;
					const gchar* _tmp66_;
					GFile* _tmp67_ = NULL;
					GFile* file;
#line 256 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp59_ = c;
#line 256 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp60_ = k;
#line 256 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp61_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp59_, _tmp60_);
#line 256 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp62_ = (GValue*) _tmp61_;
#line 256 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp63_ = g_value_get_string (_tmp62_);
#line 256 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp64_ = g_strdup (_tmp63_);
#line 256 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp65_ = _tmp64_;
#line 256 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					__vala_GValue_free0 (_tmp62_);
#line 256 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					v = _tmp65_;
#line 258 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp66_ = v;
#line 258 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp67_ = g_file_new_for_path (_tmp66_);
#line 258 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					file = _tmp67_;
#line 2210 "backend.c"
					{
						GFile* _tmp68_;
						guint8* _tmp69_ = NULL;
						gsize _tmp70_;
						EContactPhoto* _tmp71_;
						EContactPhoto* cp;
						EContactPhoto* _tmp72_;
						EContactPhoto* _tmp73_;
						guint8* _tmp74_;
						gint _tmp74__length1;
						EContact* _tmp75_;
						EContactField _tmp76_ = 0;
						EContactPhoto* _tmp77_;
#line 262 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp68_ = file;
#line 262 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						g_file_load_contents (_tmp68_, NULL, &_tmp69_, &_tmp70_, NULL, &_inner_error_);
#line 262 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						photo_content = (g_free (photo_content), NULL);
#line 262 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						photo_content = _tmp69_;
#line 262 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						photo_content_length1 = _tmp70_;
#line 262 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_photo_content_size_ = photo_content_length1;
#line 262 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						if (_inner_error_ != NULL) {
#line 2238 "backend.c"
							goto __catch5_g_error;
						}
#line 264 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp71_ = e_contact_photo_new ();
#line 264 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						cp = _tmp71_;
#line 265 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp72_ = cp;
#line 265 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp72_->type = E_CONTACT_PHOTO_TYPE_INLINED;
#line 266 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp73_ = cp;
#line 266 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp74_ = photo_content;
#line 266 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp74__length1 = photo_content_length1;
#line 266 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						e_contact_photo_set_inlined (_tmp73_, _tmp74_, (gsize) _tmp74__length1);
#line 268 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp75_ = contact;
#line 268 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp76_ = e_contact_field_id ("photo");
#line 268 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp77_ = cp;
#line 268 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						e_contact_set (_tmp75_, _tmp76_, _tmp77_);
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						__vala_EContactPhoto_free0 (cp);
#line 2267 "backend.c"
					}
					goto __finally5;
					__catch5_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp78_;
						GError* _tmp79_;
						const gchar* _tmp80_;
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						e = _inner_error_;
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_inner_error_ = NULL;
#line 272 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp78_ = v;
#line 272 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp79_ = e;
#line 272 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp80_ = _tmp79_->message;
#line 272 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						g_warning ("backend.vala:272: \n\nCan't load avatar %s: %s\n\n", _tmp78_, _tmp80_);
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_error_free0 (e);
#line 2290 "backend.c"
					}
					__finally5:
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					if (_inner_error_ != NULL) {
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_object_unref0 (file);
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						photo_content = (g_free (photo_content), NULL);
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_free0 (v);
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_free0 (k);
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_object_unref0 (_k_it);
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_free0 (contact_field_name);
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						__vala_EContactName_free0 (contact_name);
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						g_clear_error (&_inner_error_);
#line 260 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						return;
#line 2315 "backend.c"
					}
#line 254 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_g_object_unref0 (file);
#line 254 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					photo_content = (g_free (photo_content), NULL);
#line 254 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_g_free0 (v);
#line 2323 "backend.c"
				} else {
					const gchar* _tmp81_;
#line 276 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					_tmp81_ = k;
#line 276 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
					if (g_strcmp0 (_tmp81_, "email_addresses") == 0) {
#line 2330 "backend.c"
						GeeHashMap* _tmp82_;
						const gchar* _tmp83_;
						gpointer _tmp84_ = NULL;
						GValue* _tmp85_;
						const gchar* _tmp86_ = NULL;
						gchar* _tmp87_;
						gchar* _tmp88_;
						gchar* v;
						const gchar* _tmp89_;
						gchar** _tmp90_;
						gchar** _tmp91_ = NULL;
						gchar** addresses;
						gint addresses_length1;
						gint _addresses_size_;
						gchar** _tmp92_;
						gint _tmp92__length1;
#line 278 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp82_ = c;
#line 278 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp83_ = k;
#line 278 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp84_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp82_, _tmp83_);
#line 278 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp85_ = (GValue*) _tmp84_;
#line 278 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp86_ = g_value_get_string (_tmp85_);
#line 278 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp87_ = g_strdup (_tmp86_);
#line 278 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp88_ = _tmp87_;
#line 278 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						__vala_GValue_free0 (_tmp85_);
#line 278 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						v = _tmp88_;
#line 279 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp89_ = v;
#line 279 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp91_ = _tmp90_ = g_strsplit (_tmp89_, ",", 0);
#line 279 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						addresses = _tmp91_;
#line 279 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						addresses_length1 = _vala_array_length (_tmp90_);
#line 279 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_addresses_size_ = addresses_length1;
#line 281 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp92_ = addresses;
#line 281 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp92__length1 = addresses_length1;
#line 2379 "backend.c"
						{
							gchar** addr_collection = NULL;
							gint addr_collection_length1 = 0;
							gint _addr_collection_size_ = 0;
							gint addr_it = 0;
#line 281 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							addr_collection = _tmp92_;
#line 281 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							addr_collection_length1 = _tmp92__length1;
#line 281 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							for (addr_it = 0; addr_it < _tmp92__length1; addr_it = addr_it + 1) {
#line 2391 "backend.c"
								gchar* _tmp93_;
								gchar* addr = NULL;
#line 281 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp93_ = g_strdup (addr_collection[addr_it]);
#line 281 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								addr = _tmp93_;
#line 2398 "backend.c"
								{
									EContact* _tmp94_;
									EContactField _tmp95_ = 0;
									const gchar* _tmp96_;
#line 283 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp94_ = contact;
#line 283 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp95_ = e_contact_field_id ("email");
#line 283 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp96_ = addr;
#line 283 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									e_contact_set (_tmp94_, _tmp95_, _tmp96_);
#line 281 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_g_free0 (addr);
#line 2413 "backend.c"
								}
							}
						}
#line 276 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						addresses = (_vala_array_free (addresses, addresses_length1, (GDestroyNotify) g_free), NULL);
#line 276 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_g_free0 (v);
#line 2421 "backend.c"
					} else {
						const gchar* _tmp97_;
#line 286 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						_tmp97_ = k;
#line 286 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
						if (g_strcmp0 (_tmp97_, "im_addresses") == 0) {
#line 2428 "backend.c"
							GeeHashMap* _tmp98_;
							const gchar* _tmp99_;
							gpointer _tmp100_ = NULL;
							GValue* _tmp101_;
							const gchar* _tmp102_ = NULL;
							gchar* _tmp103_;
							gchar* _tmp104_;
							gchar* v;
							const gchar* _tmp105_;
							GeeHashMap* _tmp106_ = NULL;
							GeeHashMap* addresses;
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp98_ = c;
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp99_ = k;
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp100_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp98_, _tmp99_);
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp101_ = (GValue*) _tmp100_;
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp102_ = g_value_get_string (_tmp101_);
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp103_ = g_strdup (_tmp102_);
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp104_ = _tmp103_;
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							__vala_GValue_free0 (_tmp101_);
#line 288 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							v = _tmp104_;
#line 289 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp105_ = v;
#line 289 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp106_ = _eds_test_backend_parse_im_addrs (self, _tmp105_);
#line 289 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							addresses = _tmp106_;
#line 2464 "backend.c"
							{
								GeeHashMap* _tmp107_;
								GeeSet* _tmp108_;
								GeeSet* _tmp109_;
								GeeSet* _tmp110_;
								GeeIterator* _tmp111_ = NULL;
								GeeIterator* _tmp112_;
								GeeIterator* _addr_it;
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp107_ = addresses;
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp108_ = gee_abstract_map_get_keys ((GeeMap*) _tmp107_);
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp109_ = _tmp108_;
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp110_ = _tmp109_;
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp111_ = gee_iterable_iterator ((GeeIterable*) _tmp110_);
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp112_ = _tmp111_;
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_object_unref0 (_tmp110_);
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_addr_it = _tmp112_;
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								while (TRUE) {
#line 2491 "backend.c"
									GeeIterator* _tmp113_;
									gboolean _tmp114_ = FALSE;
									GeeIterator* _tmp115_;
									gpointer _tmp116_ = NULL;
									gchar* addr;
									GeeHashMap* _tmp117_;
									const gchar* _tmp118_;
									gpointer _tmp119_ = NULL;
									gchar* proto;
									EContact* _tmp120_;
									const gchar* _tmp121_;
									EContactField _tmp122_ = 0;
									const gchar* _tmp123_;
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp113_ = _addr_it;
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp114_ = gee_iterator_next (_tmp113_);
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									if (!_tmp114_) {
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
										break;
#line 2513 "backend.c"
									}
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp115_ = _addr_it;
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp116_ = gee_iterator_get (_tmp115_);
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									addr = (gchar*) _tmp116_;
#line 292 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp117_ = addresses;
#line 292 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp118_ = addr;
#line 292 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp119_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp117_, _tmp118_);
#line 292 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									proto = (gchar*) _tmp119_;
#line 293 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp120_ = contact;
#line 293 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp121_ = proto;
#line 293 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp122_ = e_contact_field_id (_tmp121_);
#line 293 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_tmp123_ = addr;
#line 293 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									e_contact_set (_tmp120_, _tmp122_, _tmp123_);
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_g_free0 (proto);
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
									_g_free0 (addr);
#line 2543 "backend.c"
								}
#line 290 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_object_unref0 (_addr_it);
#line 2547 "backend.c"
							}
#line 286 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_g_object_unref0 (addresses);
#line 286 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_g_free0 (v);
#line 2553 "backend.c"
						} else {
							const gchar* _tmp124_;
							const gchar* _tmp125_;
#line 296 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp124_ = k;
#line 296 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							_tmp125_ = EDSF_PERSONA_address_fields[0];
#line 296 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
							if (g_strcmp0 (_tmp124_, _tmp125_) == 0) {
#line 2563 "backend.c"
								GeeHashMap* _tmp126_;
								const gchar* _tmp127_;
								gpointer _tmp128_ = NULL;
								GValue* _tmp129_;
								GObject* _tmp130_ = NULL;
								FolksPostalAddressFieldDetails* _tmp131_;
								FolksPostalAddressFieldDetails* _tmp132_;
								FolksPostalAddressFieldDetails* pa_fd;
								FolksPostalAddressFieldDetails* _tmp133_;
								gconstpointer _tmp134_;
								FolksPostalAddress* _tmp135_;
								FolksPostalAddress* _tmp136_;
								FolksPostalAddress* pa;
								EContactAddress* _tmp137_;
								EContactAddress* address;
								EContactAddress* _tmp138_;
								FolksPostalAddress* _tmp139_;
								const gchar* _tmp140_;
								const gchar* _tmp141_;
								gchar* _tmp142_;
								EContactAddress* _tmp143_;
								FolksPostalAddress* _tmp144_;
								const gchar* _tmp145_;
								const gchar* _tmp146_;
								gchar* _tmp147_;
								EContactAddress* _tmp148_;
								FolksPostalAddress* _tmp149_;
								const gchar* _tmp150_;
								const gchar* _tmp151_;
								gchar* _tmp152_;
								EContactAddress* _tmp153_;
								FolksPostalAddress* _tmp154_;
								const gchar* _tmp155_;
								const gchar* _tmp156_;
								gchar* _tmp157_;
								EContactAddress* _tmp158_;
								FolksPostalAddress* _tmp159_;
								const gchar* _tmp160_;
								const gchar* _tmp161_;
								gchar* _tmp162_;
								EContactAddress* _tmp163_;
								FolksPostalAddress* _tmp164_;
								const gchar* _tmp165_;
								const gchar* _tmp166_;
								gchar* _tmp167_;
								EContactAddress* _tmp168_;
								FolksPostalAddress* _tmp169_;
								const gchar* _tmp170_;
								const gchar* _tmp171_;
								gchar* _tmp172_;
								EContactAddress* _tmp173_;
								FolksPostalAddress* _tmp174_;
								const gchar* _tmp175_;
								const gchar* _tmp176_;
								gchar* _tmp177_;
								EContact* _tmp178_;
								const gchar* _tmp179_;
								EContactField _tmp180_ = 0;
								EContactAddress* _tmp181_;
#line 298 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp126_ = c;
#line 298 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp127_ = k;
#line 298 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp128_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp126_, _tmp127_);
#line 298 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp129_ = (GValue*) _tmp128_;
#line 298 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp130_ = g_value_get_object (_tmp129_);
#line 298 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp131_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp130_, FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetails));
#line 298 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp132_ = _tmp131_;
#line 298 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								__vala_GValue_free0 (_tmp129_);
#line 298 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								pa_fd = _tmp132_;
#line 299 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp133_ = pa_fd;
#line 299 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp134_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp133_);
#line 299 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp135_ = _tmp134_;
#line 299 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp136_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((FolksPostalAddress*) _tmp135_, FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddress));
#line 299 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								pa = _tmp136_;
#line 300 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp137_ = e_contact_address_new ();
#line 300 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								address = _tmp137_;
#line 301 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp138_ = address;
#line 301 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp139_ = pa;
#line 301 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp140_ = folks_postal_address_get_po_box (_tmp139_);
#line 301 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp141_ = _tmp140_;
#line 301 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp142_ = g_strdup (_tmp141_);
#line 301 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp138_->po);
#line 301 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp138_->po = _tmp142_;
#line 302 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp143_ = address;
#line 302 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp144_ = pa;
#line 302 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp145_ = folks_postal_address_get_extension (_tmp144_);
#line 302 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp146_ = _tmp145_;
#line 302 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp147_ = g_strdup (_tmp146_);
#line 302 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp143_->ext);
#line 302 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp143_->ext = _tmp147_;
#line 303 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp148_ = address;
#line 303 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp149_ = pa;
#line 303 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp150_ = folks_postal_address_get_street (_tmp149_);
#line 303 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp151_ = _tmp150_;
#line 303 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp152_ = g_strdup (_tmp151_);
#line 303 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp148_->street);
#line 303 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp148_->street = _tmp152_;
#line 304 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp153_ = address;
#line 304 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp154_ = pa;
#line 304 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp155_ = folks_postal_address_get_locality (_tmp154_);
#line 304 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp156_ = _tmp155_;
#line 304 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp157_ = g_strdup (_tmp156_);
#line 304 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp153_->locality);
#line 304 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp153_->locality = _tmp157_;
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp158_ = address;
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp159_ = pa;
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp160_ = folks_postal_address_get_region (_tmp159_);
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp161_ = _tmp160_;
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp162_ = g_strdup (_tmp161_);
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp158_->region);
#line 305 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp158_->region = _tmp162_;
#line 306 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp163_ = address;
#line 306 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp164_ = pa;
#line 306 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp165_ = folks_postal_address_get_postal_code (_tmp164_);
#line 306 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp166_ = _tmp165_;
#line 306 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp167_ = g_strdup (_tmp166_);
#line 306 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp163_->code);
#line 306 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp163_->code = _tmp167_;
#line 307 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp168_ = address;
#line 307 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp169_ = pa;
#line 307 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp170_ = folks_postal_address_get_country (_tmp169_);
#line 307 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp171_ = _tmp170_;
#line 307 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp172_ = g_strdup (_tmp171_);
#line 307 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp168_->country);
#line 307 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp168_->country = _tmp172_;
#line 308 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp173_ = address;
#line 308 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp174_ = pa;
#line 308 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp175_ = folks_postal_address_get_address_format (_tmp174_);
#line 308 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp176_ = _tmp175_;
#line 308 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp177_ = g_strdup (_tmp176_);
#line 308 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp173_->address_format);
#line 308 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp173_->address_format = _tmp177_;
#line 310 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp178_ = contact;
#line 310 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp179_ = k;
#line 310 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp180_ = e_contact_field_id (_tmp179_);
#line 310 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp181_ = address;
#line 310 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								e_contact_set (_tmp178_, _tmp180_, _tmp181_);
#line 296 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								__vala_EContactAddress_free0 (address);
#line 296 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_object_unref0 (pa);
#line 296 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_object_unref0 (pa_fd);
#line 2783 "backend.c"
							} else {
								GeeHashMap* _tmp182_;
								const gchar* _tmp183_;
								gpointer _tmp184_ = NULL;
								GValue* _tmp185_;
								const gchar* _tmp186_ = NULL;
								gchar* _tmp187_;
								gchar* _tmp188_;
								gchar* v;
								EContact* _tmp189_;
								const gchar* _tmp190_;
								EContactField _tmp191_ = 0;
								const gchar* _tmp192_;
#line 314 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp182_ = c;
#line 314 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp183_ = k;
#line 314 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp184_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp182_, _tmp183_);
#line 314 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp185_ = (GValue*) _tmp184_;
#line 314 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp186_ = g_value_get_string (_tmp185_);
#line 314 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp187_ = g_strdup (_tmp186_);
#line 314 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp188_ = _tmp187_;
#line 314 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								__vala_GValue_free0 (_tmp185_);
#line 314 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								v = _tmp188_;
#line 315 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp189_ = contact;
#line 315 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp190_ = k;
#line 315 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp191_ = e_contact_field_id (_tmp190_);
#line 315 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_tmp192_ = v;
#line 315 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								e_contact_set (_tmp189_, _tmp191_, _tmp192_);
#line 296 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
								_g_free0 (v);
#line 2827 "backend.c"
							}
						}
					}
				}
			}
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_g_free0 (k);
#line 2835 "backend.c"
		}
#line 226 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_k_it);
#line 2839 "backend.c"
	}
#line 318 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp193_ = added_contact_name;
#line 318 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_tmp193_) {
#line 2845 "backend.c"
		EContact* _tmp194_;
		EContactField _tmp195_ = 0;
		EContactName* _tmp196_;
#line 320 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp194_ = contact;
#line 320 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp195_ = e_contact_field_id ("name");
#line 320 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp196_ = contact_name;
#line 320 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e_contact_set (_tmp194_, _tmp195_, _tmp196_);
#line 2857 "backend.c"
	}
#line 218 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_free0 (contact_field_name);
#line 218 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	__vala_EContactName_free0 (contact_name);
#line 2863 "backend.c"
}


void eds_test_backend_tear_down (EdsTestBackend* self) {
	GError * _inner_error_ = NULL;
#line 324 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 326 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_setenv ("FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS", "", TRUE);
#line 2873 "backend.c"
	{
		GFile* _tmp0_;
#line 331 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp0_ = self->priv->_source_file;
#line 331 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (_tmp0_ != NULL) {
#line 2880 "backend.c"
			GFile* _tmp1_;
#line 333 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp1_ = self->priv->_source_file;
#line 333 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			g_file_delete (_tmp1_, NULL, &_inner_error_);
#line 333 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			if (_inner_error_ != NULL) {
#line 2888 "backend.c"
				goto __catch6_g_error;
			}
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 329 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 329 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 338 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp2_ = self->priv->_addressbook_name;
#line 338 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp3_ = e;
#line 338 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_tmp4_ = _tmp3_->message;
#line 338 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:338: Unable to remove addressbook ‘%s’: %s", _tmp2_, _tmp4_);
#line 329 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 2914 "backend.c"
	}
	__finally6:
	{
#line 343 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_source_file);
#line 343 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		self->priv->_source_file = NULL;
#line 344 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_source);
#line 344 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		self->priv->_source = NULL;
#line 345 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_addressbook);
#line 345 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		self->priv->_addressbook = NULL;
#line 2930 "backend.c"
	}
#line 329 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (_inner_error_ != NULL) {
#line 329 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 329 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 329 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return;
#line 2940 "backend.c"
	}
}


static GeeHashMap* _eds_test_backend_parse_im_addrs (EdsTestBackend* self, const gchar* addr_str) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* ret;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** im_addrs;
	gint im_addrs_length1;
	gint _im_addrs_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
#line 349 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 349 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (addr_str != NULL, NULL);
#line 351 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 351 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	ret = _tmp0_;
#line 352 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = addr_str;
#line 352 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
#line 352 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	im_addrs = _tmp3_;
#line 352 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	im_addrs_length1 = _vala_array_length (_tmp2_);
#line 352 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_im_addrs_size_ = im_addrs_length1;
#line 354 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp4_ = im_addrs;
#line 354 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp4__length1 = im_addrs_length1;
#line 2979 "backend.c"
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
#line 354 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		a_collection = _tmp4_;
#line 354 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		a_collection_length1 = _tmp4__length1;
#line 354 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		for (a_it = 0; a_it < _tmp4__length1; a_it = a_it + 1) {
#line 2991 "backend.c"
			gchar* _tmp5_;
			gchar* a = NULL;
#line 354 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			_tmp5_ = g_strdup (a_collection[a_it]);
#line 354 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			a = _tmp5_;
#line 2998 "backend.c"
			{
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_ = NULL;
				gchar** info;
				gint info_length1;
				gint _info_size_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* proto;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* addr;
				GeeHashMap* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
#line 356 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp6_ = a;
#line 356 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "#", 0);
#line 356 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				info = _tmp8_;
#line 356 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				info_length1 = _vala_array_length (_tmp7_);
#line 356 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_info_size_ = info_length1;
#line 357 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp9_ = info;
#line 357 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp9__length1 = info_length1;
#line 357 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp10_ = _tmp9_[0];
#line 357 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp11_ = g_strdup (_tmp10_);
#line 357 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				proto = _tmp11_;
#line 358 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp12_ = info;
#line 358 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp12__length1 = info_length1;
#line 358 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp13_ = _tmp12_[1];
#line 358 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp14_ = g_strdup (_tmp13_);
#line 358 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				addr = _tmp14_;
#line 360 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp15_ = ret;
#line 360 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp16_ = addr;
#line 360 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				addr = NULL;
#line 360 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp17_ = _tmp16_;
#line 360 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp18_ = proto;
#line 360 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				proto = NULL;
#line 360 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_tmp19_ = _tmp18_;
#line 360 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp17_, _tmp19_);
#line 360 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp19_);
#line 360 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp17_);
#line 354 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_free0 (addr);
#line 354 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_free0 (proto);
#line 354 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
#line 354 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
				_g_free0 (a);
#line 3079 "backend.c"
			}
		}
	}
#line 363 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	result = ret;
#line 363 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	im_addrs = (_vala_array_free (im_addrs, im_addrs_length1, (GDestroyNotify) g_free), NULL);
#line 363 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return result;
#line 3089 "backend.c"
}


const gchar* eds_test_backend_get_address_book_uid (EdsTestBackend* self) {
	const gchar* result;
	EBookClient* _tmp0_;
	ESource* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 50 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp0_ = self->priv->_addressbook;
#line 50 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp1_ = e_client_get_source ((EClient*) _tmp0_);
#line 50 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_tmp2_ = e_source_get_uid (_tmp1_);
#line 50 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	result = _tmp2_;
#line 50 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return result;
#line 3110 "backend.c"
}


static void eds_test_value_backend_init (GValue* value) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	value->data[0].v_pointer = NULL;
#line 3117 "backend.c"
}


static void eds_test_value_backend_free_value (GValue* value) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (value->data[0].v_pointer) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (value->data[0].v_pointer);
#line 3126 "backend.c"
	}
}


static void eds_test_value_backend_copy_value (const GValue* src_value, GValue* dest_value) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (src_value->data[0].v_pointer) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		dest_value->data[0].v_pointer = eds_test_backend_ref (src_value->data[0].v_pointer);
#line 3136 "backend.c"
	} else {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3140 "backend.c"
	}
}


static gpointer eds_test_value_backend_peek_pointer (const GValue* value) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return value->data[0].v_pointer;
#line 3148 "backend.c"
}


static gchar* eds_test_value_backend_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (collect_values[0].v_pointer) {
#line 3155 "backend.c"
		EdsTestBackend* object;
		object = collect_values[0].v_pointer;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		if (object->parent_instance.g_class == NULL) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3162 "backend.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3166 "backend.c"
		}
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = eds_test_backend_ref (object);
#line 3170 "backend.c"
	} else {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3174 "backend.c"
	}
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return NULL;
#line 3178 "backend.c"
}


static gchar* eds_test_value_backend_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	EdsTestBackend** object_p;
	object_p = collect_values[0].v_pointer;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (!object_p) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3189 "backend.c"
	}
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (!value->data[0].v_pointer) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		*object_p = NULL;
#line 3195 "backend.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		*object_p = value->data[0].v_pointer;
#line 3199 "backend.c"
	} else {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		*object_p = eds_test_backend_ref (value->data[0].v_pointer);
#line 3203 "backend.c"
	}
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return NULL;
#line 3207 "backend.c"
}


GParamSpec* eds_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	EdsTestParamSpecBackend* spec;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (g_type_is_a (object_type, EDS_TEST_TYPE_BACKEND), NULL);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return G_PARAM_SPEC (spec);
#line 3221 "backend.c"
}


gpointer eds_test_value_get_backend (const GValue* value) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND), NULL);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return value->data[0].v_pointer;
#line 3230 "backend.c"
}


void eds_test_value_set_backend (GValue* value, gpointer v_object) {
	EdsTestBackend* old;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND));
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	old = value->data[0].v_pointer;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (v_object) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EDS_TEST_TYPE_BACKEND));
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = v_object;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		eds_test_backend_ref (value->data[0].v_pointer);
#line 3250 "backend.c"
	} else {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3254 "backend.c"
	}
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (old) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (old);
#line 3260 "backend.c"
	}
}


void eds_test_value_take_backend (GValue* value, gpointer v_object) {
	EdsTestBackend* old;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND));
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	old = value->data[0].v_pointer;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (v_object) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EDS_TEST_TYPE_BACKEND));
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = v_object;
#line 3279 "backend.c"
	} else {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3283 "backend.c"
	}
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (old) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (old);
#line 3289 "backend.c"
	}
}


static void eds_test_backend_class_init (EdsTestBackendClass * klass) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	eds_test_backend_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	EDS_TEST_BACKEND_CLASS (klass)->finalize = eds_test_backend_finalize;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_type_class_add_private (klass, sizeof (EdsTestBackendPrivate));
#line 3301 "backend.c"
}


static void eds_test_backend_instance_init (EdsTestBackend * self) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv = EDS_TEST_BACKEND_GET_PRIVATE (self);
#line 41 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_addressbook = NULL;
#line 45 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_source = NULL;
#line 46 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->priv->_source_file = NULL;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self->ref_count = 1;
#line 3316 "backend.c"
}


static void eds_test_backend_finalize (EdsTestBackend* obj) {
	EdsTestBackend * self;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDS_TEST_TYPE_BACKEND, EdsTestBackend);
#line 40 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_free0 (self->priv->_addressbook_name);
#line 41 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_addressbook);
#line 42 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_free0_0 (self->priv->_e_contacts);
#line 43 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 44 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source_registry);
#line 45 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source);
#line 46 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source_file);
#line 3338 "backend.c"
}


GType eds_test_backend_get_type (void) {
	static volatile gsize eds_test_backend_type_id__volatile = 0;
	if (g_once_init_enter (&eds_test_backend_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { eds_test_value_backend_init, eds_test_value_backend_free_value, eds_test_value_backend_copy_value, eds_test_value_backend_peek_pointer, "p", eds_test_value_backend_collect_value, "p", eds_test_value_backend_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EdsTestBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) eds_test_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EdsTestBackend), 0, (GInstanceInitFunc) eds_test_backend_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType eds_test_backend_type_id;
		eds_test_backend_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EdsTestBackend", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&eds_test_backend_type_id__volatile, eds_test_backend_type_id);
	}
	return eds_test_backend_type_id__volatile;
}


gpointer eds_test_backend_ref (gpointer instance) {
	EdsTestBackend* self;
	self = instance;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&self->ref_count);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	return instance;
#line 3363 "backend.c"
}


void eds_test_backend_unref (gpointer instance) {
	EdsTestBackend* self;
	self = instance;
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		EDS_TEST_BACKEND_GET_CLASS (self)->finalize (self);
#line 38 "/home/treitter/collabora/folks/tests/lib/eds/backend.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3376 "backend.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



