/* ai.c generated by valac 0.39.92, the Vala compiler
 * generated from ai.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 *
 * This file is part of Four-in-a-row.
 *
 * Four-in-a-row is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * Four-in-a-row is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Four-in-a-row.  If not, see <http://www.gnu.org/licenses/>. */
/* Here NEG_INF is supposed to be the lowest possible int value. int.MIN
MAX_HEURIST_VALUE is the maximum value that the heuristic functions can return.
It is returned when AI wins. -1*MAX_HEURIST_VALUE is returned when Human wins
MAX_HEURIST_VALUE < NEG_INF/plies */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "ai.h"
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PLAYER (player_get_type ())

#define TYPE_DIFFICULTY (difficulty_get_type ())
#define _decision_tree_unref0(var) ((var == NULL) ? NULL : (var = (decision_tree_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecDecisionTree ParamSpecDecisionTree;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	PLAYER_NONE,
	PLAYER_HUMAN,
	PLAYER_AI
} Player;

typedef enum  {
	DIFFICULTY_EASY,
	DIFFICULTY_MEDIUM,
	DIFFICULTY_HARD
} Difficulty;

struct _DecisionTreePrivate {
	Player* board;
	gint board_length1;
	gint board_length2;
	gint plies;
	Player last_moving_player;
	gint next_move_in_column;
	Difficulty level;
};

struct _ParamSpecDecisionTree {
	GParamSpec parent_instance;
};


static gpointer decision_tree_parent_class = NULL;

#define NEG_INF -100000
#define MAX_HEURIST_VALUE 10000
#define BOARD_ROWS 6
#define BOARD_COLUMNS 7
GType player_get_type (void) G_GNUC_CONST;
GType difficulty_get_type (void) G_GNUC_CONST;
gint playgame (const gchar* moves_until_now);
#define DECISION_TREE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DECISION_TREE, DecisionTreePrivate))
static gint decision_tree_negamax (DecisionTree* self,
                            gint height,
                            gint alpha,
                            gint beta);
static gboolean decision_tree_board_full (DecisionTree* self);
static gint decision_tree_heurist (DecisionTree* self);
static gboolean decision_tree_move (DecisionTree* self,
                             gint column);
static gboolean decision_tree_victory (DecisionTree* self,
                                gint column);
static void decision_tree_unmove (DecisionTree* self,
                           gint column);
static gboolean decision_tree_vertical_win (DecisionTree* self,
                                     gint i,
                                     gint j);
static gboolean decision_tree_horizontal_win (DecisionTree* self,
                                       gint i,
                                       gint j);
static gboolean decision_tree_forward_diagonal_win (DecisionTree* self,
                                             gint i,
                                             gint j);
static gboolean decision_tree_backward_diagonal_win (DecisionTree* self,
                                              gint i,
                                              gint j);
static gint decision_tree_immediate_win (DecisionTree* self,
                                  Player p);
static void decision_tree_set_level (DecisionTree* self,
                              const gchar* vstr);
static gint decision_tree_heurist_easy (DecisionTree* self);
static gint decision_tree_heurist_medium (DecisionTree* self);
static gint decision_tree_heurist_hard (DecisionTree* self);
static gint decision_tree_count_3_in_a_row (DecisionTree* self,
                                     Player p);
static gboolean decision_tree_all_adjacent_empty (DecisionTree* self,
                                           gint i,
                                           gint j);
static void decision_tree_finalize (DecisionTree * obj);


GType
player_get_type (void)
{
	static volatile gsize player_type_id__volatile = 0;
	if (g_once_init_enter (&player_type_id__volatile)) {
		static const GEnumValue values[] = {{PLAYER_NONE, "PLAYER_NONE", "none"}, {PLAYER_HUMAN, "PLAYER_HUMAN", "human"}, {PLAYER_AI, "PLAYER_AI", "ai"}, {0, NULL, NULL}};
		GType player_type_id;
		player_type_id = g_enum_register_static ("Player", values);
		g_once_init_leave (&player_type_id__volatile, player_type_id);
	}
	return player_type_id__volatile;
}


GType
difficulty_get_type (void)
{
	static volatile gsize difficulty_type_id__volatile = 0;
	if (g_once_init_enter (&difficulty_type_id__volatile)) {
		static const GEnumValue values[] = {{DIFFICULTY_EASY, "DIFFICULTY_EASY", "easy"}, {DIFFICULTY_MEDIUM, "DIFFICULTY_MEDIUM", "medium"}, {DIFFICULTY_HARD, "DIFFICULTY_HARD", "hard"}, {0, NULL, NULL}};
		GType difficulty_type_id;
		difficulty_type_id = g_enum_register_static ("Difficulty", values);
		g_once_init_leave (&difficulty_type_id__volatile, difficulty_type_id);
	}
	return difficulty_type_id__volatile;
}


gint
playgame (const gchar* moves_until_now)
{
	gint result = 0;
	DecisionTree* t = NULL;
	DecisionTree* _tmp0_;
	g_return_val_if_fail (moves_until_now != NULL, 0);
	_tmp0_ = decision_tree_new ();
	t = _tmp0_;
	result = decision_tree_playgame (t, moves_until_now);
	_decision_tree_unref0 (t);
	return result;
}


DecisionTree*
decision_tree_construct (GType object_type)
{
	DecisionTree* self = NULL;
	self = (DecisionTree*) g_type_create_instance (object_type);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < BOARD_ROWS)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Player* _tmp6_;
							gint _tmp6__length1;
							gint _tmp6__length2;
							gint _tmp7_;
							gint _tmp8_;
							Player _tmp9_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = j;
								j = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = j;
							if (!(_tmp5_ < BOARD_COLUMNS)) {
								break;
							}
							_tmp6_ = self->priv->board;
							_tmp6__length1 = self->priv->board_length1;
							_tmp6__length2 = self->priv->board_length2;
							_tmp7_ = i;
							_tmp8_ = j;
							_tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_] = PLAYER_NONE;
							_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
						}
					}
				}
			}
		}
	}
	return self;
}


DecisionTree*
decision_tree_new (void)
{
	return decision_tree_construct (TYPE_DECISION_TREE);
}


void
decision_tree_print_board (DecisionTree* self)
{
	FILE* _tmp12_;
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				FILE* _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < BOARD_ROWS)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							FILE* _tmp6_;
							Player* _tmp7_;
							gint _tmp7__length1;
							gint _tmp7__length2;
							gint _tmp8_;
							gint _tmp9_;
							Player _tmp10_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = j;
								j = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = j;
							if (!(_tmp5_ < BOARD_COLUMNS)) {
								break;
							}
							_tmp6_ = stdout;
							_tmp7_ = self->priv->board;
							_tmp7__length1 = self->priv->board_length1;
							_tmp7__length2 = self->priv->board_length2;
							_tmp8_ = i;
							_tmp9_ = j;
							_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
							fprintf (_tmp6_, "%d\t", (gint) _tmp10_);
						}
					}
				}
				_tmp11_ = stdout;
				fprintf (_tmp11_, "\n");
			}
		}
	}
	_tmp12_ = stdout;
	fprintf (_tmp12_, "\n");
}


static gint
decision_tree_negamax (DecisionTree* self,
                       gint height,
                       gint alpha,
                       gint beta)
{
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gint max = 0;
	gint next = 0;
	gint _tmp16_;
	g_return_val_if_fail (self != NULL, 0);
	if (height == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = decision_tree_board_full (self);
	}
	if (_tmp0_) {
		Player _tmp1_;
		_tmp1_ = self->priv->last_moving_player;
		if (_tmp1_ == PLAYER_HUMAN) {
			result = decision_tree_heurist (self);
			return result;
		} else {
			Player _tmp2_;
			_tmp2_ = self->priv->last_moving_player;
			if (_tmp2_ == PLAYER_AI) {
				result = -1 * decision_tree_heurist (self);
				return result;
			} else {
				result = 0;
				return result;
			}
		}
	}
	max = NEG_INF;
	next = -1;
	{
		gint column = 0;
		column = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_ = 0;
				gint _tmp8_;
				gint temp = 0;
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp14_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = column;
					column = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = column;
				if (!(_tmp5_ < BOARD_COLUMNS)) {
					break;
				}
				_tmp6_ = column;
				if (!decision_tree_move (self, _tmp6_)) {
					continue;
				}
				_tmp8_ = column;
				if (decision_tree_victory (self, _tmp8_)) {
					_tmp7_ = MAX_HEURIST_VALUE * height;
				} else {
					_tmp7_ = -1 * decision_tree_negamax (self, height - 1, -1 * beta, -1 * alpha);
				}
				temp = _tmp7_;
				_tmp9_ = column;
				decision_tree_unmove (self, _tmp9_);
				_tmp10_ = temp;
				_tmp11_ = max;
				if (_tmp10_ > _tmp11_) {
					gint _tmp12_;
					gint _tmp13_;
					_tmp12_ = column;
					next = _tmp12_;
					_tmp13_ = temp;
					max = _tmp13_;
				}
				_tmp14_ = temp;
				if (_tmp14_ > alpha) {
					gint _tmp15_;
					_tmp15_ = temp;
					alpha = _tmp15_;
				}
				if (alpha >= beta) {
					break;
				}
			}
		}
	}
	_tmp16_ = self->priv->plies;
	if (height == _tmp16_) {
		gint _tmp17_;
		_tmp17_ = next;
		self->priv->next_move_in_column = _tmp17_;
	}
	result = max;
	return result;
}


static gboolean
decision_tree_victory (DecisionTree* self,
                       gint column)
{
	gboolean result = FALSE;
	gint row = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		row = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gint _tmp3_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = row;
				row = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = row;
			if (_tmp3_ < BOARD_ROWS) {
				Player* _tmp4_;
				gint _tmp4__length1;
				gint _tmp4__length2;
				gint _tmp5_;
				Player _tmp6_;
				_tmp4_ = self->priv->board;
				_tmp4__length1 = self->priv->board_length1;
				_tmp4__length2 = self->priv->board_length2;
				_tmp5_ = row;
				_tmp6_ = _tmp4_[(_tmp5_ * _tmp4__length2) + column];
				_tmp2_ = _tmp6_ == PLAYER_NONE;
			} else {
				_tmp2_ = FALSE;
			}
			if (!_tmp2_) {
				break;
			}
		}
	}
	_tmp10_ = row;
	if (decision_tree_vertical_win (self, _tmp10_, column)) {
		_tmp9_ = TRUE;
	} else {
		gint _tmp11_;
		_tmp11_ = row;
		_tmp9_ = decision_tree_horizontal_win (self, _tmp11_, column);
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		gint _tmp12_;
		_tmp12_ = row;
		_tmp8_ = decision_tree_forward_diagonal_win (self, _tmp12_, column);
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		gint _tmp13_;
		_tmp13_ = row;
		_tmp7_ = decision_tree_backward_diagonal_win (self, _tmp13_, column);
	}
	result = _tmp7_;
	return result;
}


static gboolean
decision_tree_forward_diagonal_win (DecisionTree* self,
                                    gint i,
                                    gint j)
{
	gboolean result = FALSE;
	gint count = 0;
	gint _tmp26_;
	g_return_val_if_fail (self != NULL, FALSE);
	count = 0;
	{
		gint k = 0;
		gint l = 0;
		k = i;
		l = j;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				gint _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					gint _tmp2_;
					gint _tmp3_;
					_tmp1_ = k;
					k = _tmp1_ - 1;
					_tmp2_ = l;
					l = _tmp2_ + 1;
					_tmp3_ = count;
					count = _tmp3_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp6_ = k;
				if (_tmp6_ >= 0) {
					gint _tmp7_;
					_tmp7_ = l;
					_tmp5_ = _tmp7_ < BOARD_COLUMNS;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					Player* _tmp8_;
					gint _tmp8__length1;
					gint _tmp8__length2;
					gint _tmp9_;
					gint _tmp10_;
					Player _tmp11_;
					Player _tmp12_;
					_tmp8_ = self->priv->board;
					_tmp8__length1 = self->priv->board_length1;
					_tmp8__length2 = self->priv->board_length2;
					_tmp9_ = k;
					_tmp10_ = l;
					_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
					_tmp12_ = self->priv->last_moving_player;
					_tmp4_ = _tmp11_ == _tmp12_;
				} else {
					_tmp4_ = FALSE;
				}
				if (!_tmp4_) {
					break;
				}
			}
		}
	}
	{
		gint k = 0;
		gint l = 0;
		k = i + 1;
		l = j - 1;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				gint _tmp19_;
				if (!_tmp13_) {
					gint _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					_tmp14_ = k;
					k = _tmp14_ + 1;
					_tmp15_ = l;
					l = _tmp15_ - 1;
					_tmp16_ = count;
					count = _tmp16_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp19_ = k;
				if (_tmp19_ < BOARD_ROWS) {
					gint _tmp20_;
					_tmp20_ = l;
					_tmp18_ = _tmp20_ >= 0;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					Player* _tmp21_;
					gint _tmp21__length1;
					gint _tmp21__length2;
					gint _tmp22_;
					gint _tmp23_;
					Player _tmp24_;
					Player _tmp25_;
					_tmp21_ = self->priv->board;
					_tmp21__length1 = self->priv->board_length1;
					_tmp21__length2 = self->priv->board_length2;
					_tmp22_ = k;
					_tmp23_ = l;
					_tmp24_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
					_tmp25_ = self->priv->last_moving_player;
					_tmp17_ = _tmp24_ == _tmp25_;
				} else {
					_tmp17_ = FALSE;
				}
				if (!_tmp17_) {
					break;
				}
			}
		}
	}
	_tmp26_ = count;
	result = _tmp26_ >= 4;
	return result;
}


static gboolean
decision_tree_backward_diagonal_win (DecisionTree* self,
                                     gint i,
                                     gint j)
{
	gboolean result = FALSE;
	gint count = 0;
	gint _tmp26_;
	g_return_val_if_fail (self != NULL, FALSE);
	count = 0;
	{
		gint k = 0;
		gint l = 0;
		k = i;
		l = j;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				gint _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					gint _tmp2_;
					gint _tmp3_;
					_tmp1_ = k;
					k = _tmp1_ - 1;
					_tmp2_ = l;
					l = _tmp2_ - 1;
					_tmp3_ = count;
					count = _tmp3_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp6_ = k;
				if (_tmp6_ >= 0) {
					gint _tmp7_;
					_tmp7_ = l;
					_tmp5_ = _tmp7_ >= 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					Player* _tmp8_;
					gint _tmp8__length1;
					gint _tmp8__length2;
					gint _tmp9_;
					gint _tmp10_;
					Player _tmp11_;
					Player _tmp12_;
					_tmp8_ = self->priv->board;
					_tmp8__length1 = self->priv->board_length1;
					_tmp8__length2 = self->priv->board_length2;
					_tmp9_ = k;
					_tmp10_ = l;
					_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
					_tmp12_ = self->priv->last_moving_player;
					_tmp4_ = _tmp11_ == _tmp12_;
				} else {
					_tmp4_ = FALSE;
				}
				if (!_tmp4_) {
					break;
				}
			}
		}
	}
	{
		gint k = 0;
		gint l = 0;
		k = i + 1;
		l = j + 1;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				gint _tmp19_;
				if (!_tmp13_) {
					gint _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					_tmp14_ = k;
					k = _tmp14_ + 1;
					_tmp15_ = l;
					l = _tmp15_ + 1;
					_tmp16_ = count;
					count = _tmp16_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp19_ = k;
				if (_tmp19_ < BOARD_ROWS) {
					gint _tmp20_;
					_tmp20_ = l;
					_tmp18_ = _tmp20_ < BOARD_COLUMNS;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					Player* _tmp21_;
					gint _tmp21__length1;
					gint _tmp21__length2;
					gint _tmp22_;
					gint _tmp23_;
					Player _tmp24_;
					Player _tmp25_;
					_tmp21_ = self->priv->board;
					_tmp21__length1 = self->priv->board_length1;
					_tmp21__length2 = self->priv->board_length2;
					_tmp22_ = k;
					_tmp23_ = l;
					_tmp24_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
					_tmp25_ = self->priv->last_moving_player;
					_tmp17_ = _tmp24_ == _tmp25_;
				} else {
					_tmp17_ = FALSE;
				}
				if (!_tmp17_) {
					break;
				}
			}
		}
	}
	_tmp26_ = count;
	result = _tmp26_ >= 4;
	return result;
}


static gboolean
decision_tree_horizontal_win (DecisionTree* self,
                              gint i,
                              gint j)
{
	gboolean result = FALSE;
	gint count = 0;
	gint _tmp18_;
	g_return_val_if_fail (self != NULL, FALSE);
	count = 0;
	{
		gint k = 0;
		k = j;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gint _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					gint _tmp2_;
					_tmp1_ = k;
					k = _tmp1_ - 1;
					_tmp2_ = count;
					count = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp4_ = k;
				if (_tmp4_ >= 0) {
					Player* _tmp5_;
					gint _tmp5__length1;
					gint _tmp5__length2;
					gint _tmp6_;
					Player _tmp7_;
					Player _tmp8_;
					_tmp5_ = self->priv->board;
					_tmp5__length1 = self->priv->board_length1;
					_tmp5__length2 = self->priv->board_length2;
					_tmp6_ = k;
					_tmp7_ = _tmp5_[(i * _tmp5__length2) + _tmp6_];
					_tmp8_ = self->priv->last_moving_player;
					_tmp3_ = _tmp7_ == _tmp8_;
				} else {
					_tmp3_ = FALSE;
				}
				if (!_tmp3_) {
					break;
				}
			}
		}
	}
	{
		gint k = 0;
		k = j + 1;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp12_ = FALSE;
				gint _tmp13_;
				if (!_tmp9_) {
					gint _tmp10_;
					gint _tmp11_;
					_tmp10_ = k;
					k = _tmp10_ + 1;
					_tmp11_ = count;
					count = _tmp11_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = k;
				if (_tmp13_ < BOARD_COLUMNS) {
					Player* _tmp14_;
					gint _tmp14__length1;
					gint _tmp14__length2;
					gint _tmp15_;
					Player _tmp16_;
					Player _tmp17_;
					_tmp14_ = self->priv->board;
					_tmp14__length1 = self->priv->board_length1;
					_tmp14__length2 = self->priv->board_length2;
					_tmp15_ = k;
					_tmp16_ = _tmp14_[(i * _tmp14__length2) + _tmp15_];
					_tmp17_ = self->priv->last_moving_player;
					_tmp12_ = _tmp16_ == _tmp17_;
				} else {
					_tmp12_ = FALSE;
				}
				if (!_tmp12_) {
					break;
				}
			}
		}
	}
	_tmp18_ = count;
	result = _tmp18_ >= 4;
	return result;
}


static gboolean
decision_tree_vertical_win (DecisionTree* self,
                            gint i,
                            gint j)
{
	gboolean result = FALSE;
	gint count = 0;
	gint _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	count = 0;
	{
		gint k = 0;
		k = i;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gint _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					gint _tmp2_;
					_tmp1_ = k;
					k = _tmp1_ + 1;
					_tmp2_ = count;
					count = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp4_ = k;
				if (_tmp4_ < BOARD_ROWS) {
					Player* _tmp5_;
					gint _tmp5__length1;
					gint _tmp5__length2;
					gint _tmp6_;
					Player _tmp7_;
					Player _tmp8_;
					_tmp5_ = self->priv->board;
					_tmp5__length1 = self->priv->board_length1;
					_tmp5__length2 = self->priv->board_length2;
					_tmp6_ = k;
					_tmp7_ = _tmp5_[(_tmp6_ * _tmp5__length2) + j];
					_tmp8_ = self->priv->last_moving_player;
					_tmp3_ = _tmp7_ == _tmp8_;
				} else {
					_tmp3_ = FALSE;
				}
				if (!_tmp3_) {
					break;
				}
			}
		}
	}
	_tmp9_ = count;
	result = _tmp9_ >= 4;
	return result;
}


static gboolean
decision_tree_board_full (DecisionTree* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Player* _tmp3_;
				gint _tmp3__length1;
				gint _tmp3__length2;
				gint _tmp4_;
				Player _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < BOARD_COLUMNS)) {
					break;
				}
				_tmp3_ = self->priv->board;
				_tmp3__length1 = self->priv->board_length1;
				_tmp3__length2 = self->priv->board_length2;
				_tmp4_ = i;
				_tmp5_ = _tmp3_[(0 * _tmp3__length2) + _tmp4_];
				if (_tmp5_ == PLAYER_NONE) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean
decision_tree_move (DecisionTree* self,
                    gint column)
{
	gboolean result = FALSE;
	gint row = 0;
	gint _tmp7_;
	Player _tmp8_ = 0;
	Player _tmp9_;
	Player player = 0;
	Player* _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	gint _tmp11_;
	Player _tmp12_;
	Player _tmp13_;
	Player _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		row = BOARD_ROWS - 1;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gint _tmp3_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = row;
				row = _tmp1_ - 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = row;
			if (_tmp3_ >= 0) {
				Player* _tmp4_;
				gint _tmp4__length1;
				gint _tmp4__length2;
				gint _tmp5_;
				Player _tmp6_;
				_tmp4_ = self->priv->board;
				_tmp4__length1 = self->priv->board_length1;
				_tmp4__length2 = self->priv->board_length2;
				_tmp5_ = row;
				_tmp6_ = _tmp4_[(_tmp5_ * _tmp4__length2) + column];
				_tmp2_ = _tmp6_ != PLAYER_NONE;
			} else {
				_tmp2_ = FALSE;
			}
			if (!_tmp2_) {
				break;
			}
		}
	}
	_tmp7_ = row;
	if (_tmp7_ < 0) {
		result = FALSE;
		return result;
	}
	_tmp9_ = self->priv->last_moving_player;
	if (_tmp9_ != PLAYER_AI) {
		_tmp8_ = PLAYER_AI;
	} else {
		_tmp8_ = PLAYER_HUMAN;
	}
	player = _tmp8_;
	_tmp10_ = self->priv->board;
	_tmp10__length1 = self->priv->board_length1;
	_tmp10__length2 = self->priv->board_length2;
	_tmp11_ = row;
	_tmp12_ = player;
	_tmp10_[(_tmp11_ * _tmp10__length2) + column] = _tmp12_;
	_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + column];
	_tmp14_ = player;
	self->priv->last_moving_player = _tmp14_;
	result = TRUE;
	return result;
}


static void
decision_tree_unmove (DecisionTree* self,
                      gint column)
{
	Player _tmp0_;
	gint row = 0;
	Player* _tmp8_;
	gint _tmp8__length1;
	gint _tmp8__length2;
	gint _tmp9_;
	Player _tmp10_;
	Player _tmp11_ = 0;
	Player _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->last_moving_player;
	_vala_return_if_fail (_tmp0_ != PLAYER_NONE, "last_moving_player != Player.NONE");
	{
		gboolean _tmp1_ = FALSE;
		row = 0;
		_tmp1_ = TRUE;
		while (TRUE) {
			gboolean _tmp3_ = FALSE;
			gint _tmp4_;
			if (!_tmp1_) {
				gint _tmp2_;
				_tmp2_ = row;
				row = _tmp2_ + 1;
			}
			_tmp1_ = FALSE;
			_tmp4_ = row;
			if (_tmp4_ < BOARD_ROWS) {
				Player* _tmp5_;
				gint _tmp5__length1;
				gint _tmp5__length2;
				gint _tmp6_;
				Player _tmp7_;
				_tmp5_ = self->priv->board;
				_tmp5__length1 = self->priv->board_length1;
				_tmp5__length2 = self->priv->board_length2;
				_tmp6_ = row;
				_tmp7_ = _tmp5_[(_tmp6_ * _tmp5__length2) + column];
				_tmp3_ = _tmp7_ == PLAYER_NONE;
			} else {
				_tmp3_ = FALSE;
			}
			if (!_tmp3_) {
				break;
			}
		}
	}
	_tmp8_ = self->priv->board;
	_tmp8__length1 = self->priv->board_length1;
	_tmp8__length2 = self->priv->board_length2;
	_tmp9_ = row;
	_tmp8_[(_tmp9_ * _tmp8__length2) + column] = PLAYER_NONE;
	_tmp10_ = _tmp8_[(_tmp9_ * _tmp8__length2) + column];
	_tmp12_ = self->priv->last_moving_player;
	if (_tmp12_ == PLAYER_AI) {
		_tmp11_ = PLAYER_HUMAN;
	} else {
		_tmp11_ = PLAYER_AI;
	}
	self->priv->last_moving_player = _tmp11_;
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


void
decision_tree_update_board (DecisionTree* self,
                            const gchar* vstr)
{
	gint _tmp0_;
	gint _tmp1_;
	Player _tmp2_ = 0;
	gint _tmp3_;
	gint _tmp4_;
	Player move = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vstr != NULL);
	self->priv->next_move_in_column = -1;
	_tmp0_ = strlen (vstr);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 2) {
		return;
	}
	_tmp3_ = strlen (vstr);
	_tmp4_ = _tmp3_;
	if ((_tmp4_ % 2) == 0) {
		_tmp2_ = PLAYER_AI;
	} else {
		_tmp2_ = PLAYER_HUMAN;
	}
	move = _tmp2_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				gint column = 0;
				gint _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gint _tmp13_;
				gint row = 0;
				Player* _tmp22_;
				gint _tmp22__length1;
				gint _tmp22__length2;
				gint _tmp23_;
				gint _tmp24_;
				Player _tmp25_;
				Player _tmp26_;
				Player _tmp27_ = 0;
				Player _tmp28_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = strlen (vstr);
				_tmp9_ = _tmp8_;
				if (!(_tmp7_ < (_tmp9_ - 1))) {
					break;
				}
				_tmp10_ = i;
				_tmp11_ = g_strdup_printf ("%c", string_get (vstr, (glong) _tmp10_));
				_tmp12_ = _tmp11_;
				_tmp13_ = atoi (_tmp12_) - 1;
				_g_free0 (_tmp12_);
				column = _tmp13_;
				{
					gboolean _tmp14_ = FALSE;
					row = BOARD_ROWS - 1;
					_tmp14_ = TRUE;
					while (TRUE) {
						gboolean _tmp16_ = FALSE;
						gint _tmp17_;
						if (!_tmp14_) {
							gint _tmp15_;
							_tmp15_ = row;
							row = _tmp15_ - 1;
						}
						_tmp14_ = FALSE;
						_tmp17_ = row;
						if (_tmp17_ >= 0) {
							Player* _tmp18_;
							gint _tmp18__length1;
							gint _tmp18__length2;
							gint _tmp19_;
							gint _tmp20_;
							Player _tmp21_;
							_tmp18_ = self->priv->board;
							_tmp18__length1 = self->priv->board_length1;
							_tmp18__length2 = self->priv->board_length2;
							_tmp19_ = row;
							_tmp20_ = column;
							_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
							_tmp16_ = _tmp21_ != PLAYER_NONE;
						} else {
							_tmp16_ = FALSE;
						}
						if (!_tmp16_) {
							break;
						}
					}
				}
				_tmp22_ = self->priv->board;
				_tmp22__length1 = self->priv->board_length1;
				_tmp22__length2 = self->priv->board_length2;
				_tmp23_ = row;
				_tmp24_ = column;
				_tmp25_ = move;
				_tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_] = _tmp25_;
				_tmp26_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
				_tmp28_ = move;
				if (_tmp28_ == PLAYER_HUMAN) {
					_tmp27_ = PLAYER_AI;
				} else {
					_tmp27_ = PLAYER_HUMAN;
				}
				move = _tmp27_;
			}
		}
	}
	self->priv->last_moving_player = PLAYER_HUMAN;
}


static gint
decision_tree_immediate_win (DecisionTree* self,
                             Player p)
{
	gint result = 0;
	Player old_last_moving_player = 0;
	Player _tmp0_;
	Player _tmp1_ = 0;
	gboolean player_wins = FALSE;
	gint i = 0;
	Player _tmp9_;
	gint _tmp10_ = 0;
	gboolean _tmp11_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->last_moving_player;
	old_last_moving_player = _tmp0_;
	if (p == PLAYER_AI) {
		_tmp1_ = PLAYER_HUMAN;
	} else {
		_tmp1_ = PLAYER_AI;
	}
	self->priv->last_moving_player = _tmp1_;
	player_wins = FALSE;
	{
		gboolean _tmp2_ = FALSE;
		i = 0;
		_tmp2_ = TRUE;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gboolean _tmp8_;
			if (!_tmp2_) {
				gint _tmp3_;
				_tmp3_ = i;
				i = _tmp3_ + 1;
			}
			_tmp2_ = FALSE;
			_tmp4_ = i;
			if (!(_tmp4_ < BOARD_COLUMNS)) {
				break;
			}
			_tmp5_ = i;
			if (!decision_tree_move (self, _tmp5_)) {
				continue;
			}
			_tmp6_ = i;
			player_wins = decision_tree_victory (self, _tmp6_);
			_tmp7_ = i;
			decision_tree_unmove (self, _tmp7_);
			_tmp8_ = player_wins;
			if (_tmp8_) {
				break;
			}
		}
	}
	_tmp9_ = old_last_moving_player;
	self->priv->last_moving_player = _tmp9_;
	_tmp11_ = player_wins;
	if (_tmp11_) {
		gint _tmp12_;
		_tmp12_ = i;
		_tmp10_ = _tmp12_;
	} else {
		_tmp10_ = -1;
	}
	result = _tmp10_;
	return result;
}


gint
decision_tree_playgame (DecisionTree* self,
                        const gchar* vstr)
{
	gint result = 0;
	gint temp = 0;
	gint _tmp0_;
	gint _tmp2_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (vstr != NULL, 0);
	decision_tree_set_level (self, vstr);
	decision_tree_update_board (self, vstr);
	temp = decision_tree_immediate_win (self, PLAYER_AI);
	_tmp0_ = temp;
	if (_tmp0_ != -1) {
		gint _tmp1_;
		_tmp1_ = temp;
		result = _tmp1_ + 1;
		return result;
	}
	temp = decision_tree_immediate_win (self, PLAYER_HUMAN);
	_tmp2_ = temp;
	if (_tmp2_ != -1) {
		gint _tmp3_;
		_tmp3_ = temp;
		result = _tmp3_ + 1;
		return result;
	}
	_tmp4_ = self->priv->plies;
	decision_tree_negamax (self, _tmp4_, NEG_INF, -1 * NEG_INF);
	_tmp5_ = self->priv->next_move_in_column;
	result = _tmp5_ + 1;
	return result;
}


static gint
decision_tree_heurist (DecisionTree* self)
{
	gint result = 0;
	Difficulty _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->level;
	if (_tmp0_ == DIFFICULTY_EASY) {
		result = decision_tree_heurist_easy (self);
		return result;
	} else {
		Difficulty _tmp1_;
		_tmp1_ = self->priv->level;
		if (_tmp1_ == DIFFICULTY_MEDIUM) {
			result = decision_tree_heurist_medium (self);
			return result;
		} else {
			result = decision_tree_heurist_hard (self);
			return result;
		}
	}
}


static gint
decision_tree_heurist_easy (DecisionTree* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = -1 * decision_tree_heurist_hard (self);
	return result;
}


static gint
decision_tree_heurist_medium (DecisionTree* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) g_random_int_range ((gint32) 1, (gint32) 49);
	return result;
}


static gint
decision_tree_heurist_hard (DecisionTree* self)
{
	gint result = 0;
	gint count = 0;
	gint32 _tmp0_ = 0;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	count = decision_tree_count_3_in_a_row (self, PLAYER_AI) - decision_tree_count_3_in_a_row (self, PLAYER_HUMAN);
	_tmp1_ = count;
	if (_tmp1_ == 0) {
		_tmp0_ = g_random_int_range ((gint32) 1, (gint32) 49);
	} else {
		gint _tmp2_;
		_tmp2_ = count;
		_tmp0_ = (gint32) (_tmp2_ * 100);
	}
	result = (gint) _tmp0_;
	return result;
}


static gint
decision_tree_count_3_in_a_row (DecisionTree* self,
                                Player p)
{
	gint result = 0;
	gint count = 0;
	Player old_last_moving_player = 0;
	Player _tmp0_;
	Player _tmp23_;
	g_return_val_if_fail (self != NULL, 0);
	count = 0;
	_tmp0_ = self->priv->last_moving_player;
	old_last_moving_player = _tmp0_;
	self->priv->last_moving_player = p;
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = j;
					j = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = j;
				if (!(_tmp3_ < BOARD_COLUMNS)) {
					break;
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							Player* _tmp7_;
							gint _tmp7__length1;
							gint _tmp7__length2;
							gint _tmp8_;
							gint _tmp9_;
							Player _tmp10_;
							gint _tmp11_;
							gint _tmp12_;
							Player* _tmp13_;
							gint _tmp13__length1;
							gint _tmp13__length2;
							gint _tmp14_;
							gint _tmp15_;
							Player _tmp16_;
							gint _tmp17_;
							Player* _tmp19_;
							gint _tmp19__length1;
							gint _tmp19__length2;
							gint _tmp20_;
							gint _tmp21_;
							Player _tmp22_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = i;
								i = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = i;
							if (!(_tmp6_ < BOARD_ROWS)) {
								break;
							}
							_tmp7_ = self->priv->board;
							_tmp7__length1 = self->priv->board_length1;
							_tmp7__length2 = self->priv->board_length2;
							_tmp8_ = i;
							_tmp9_ = j;
							_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
							if (_tmp10_ != PLAYER_NONE) {
								break;
							}
							_tmp11_ = i;
							_tmp12_ = j;
							if (decision_tree_all_adjacent_empty (self, _tmp11_, _tmp12_)) {
								continue;
							}
							_tmp13_ = self->priv->board;
							_tmp13__length1 = self->priv->board_length1;
							_tmp13__length2 = self->priv->board_length2;
							_tmp14_ = i;
							_tmp15_ = j;
							_tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_] = p;
							_tmp16_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
							_tmp17_ = j;
							if (decision_tree_victory (self, _tmp17_)) {
								gint _tmp18_;
								_tmp18_ = count;
								count = _tmp18_ + 1;
							}
							_tmp19_ = self->priv->board;
							_tmp19__length1 = self->priv->board_length1;
							_tmp19__length2 = self->priv->board_length2;
							_tmp20_ = i;
							_tmp21_ = j;
							_tmp19_[(_tmp20_ * _tmp19__length2) + _tmp21_] = PLAYER_NONE;
							_tmp22_ = _tmp19_[(_tmp20_ * _tmp19__length2) + _tmp21_];
						}
					}
				}
			}
		}
	}
	_tmp23_ = old_last_moving_player;
	self->priv->last_moving_player = _tmp23_;
	result = count;
	return result;
}


static gboolean
decision_tree_all_adjacent_empty (DecisionTree* self,
                                  gint i,
                                  gint j)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint k = 0;
		k = -1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = k;
					k = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = k;
				if (!(_tmp2_ <= 1)) {
					break;
				}
				{
					gint l = 0;
					l = -1;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							gboolean _tmp6_ = FALSE;
							gint _tmp7_;
							gboolean _tmp9_ = FALSE;
							gboolean _tmp10_ = FALSE;
							gboolean _tmp11_ = FALSE;
							gboolean _tmp12_ = FALSE;
							gint _tmp13_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = l;
								l = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = l;
							if (!(_tmp5_ <= 1)) {
								break;
							}
							_tmp7_ = k;
							if (_tmp7_ == 0) {
								gint _tmp8_;
								_tmp8_ = l;
								_tmp6_ = _tmp8_ == 0;
							} else {
								_tmp6_ = FALSE;
							}
							if (_tmp6_) {
								continue;
							}
							_tmp13_ = k;
							if ((i + _tmp13_) >= 0) {
								gint _tmp14_;
								_tmp14_ = k;
								_tmp12_ = (i + _tmp14_) < BOARD_ROWS;
							} else {
								_tmp12_ = FALSE;
							}
							if (_tmp12_) {
								gint _tmp15_;
								_tmp15_ = l;
								_tmp11_ = (j + _tmp15_) >= 0;
							} else {
								_tmp11_ = FALSE;
							}
							if (_tmp11_) {
								gint _tmp16_;
								_tmp16_ = l;
								_tmp10_ = (j + _tmp16_) < BOARD_COLUMNS;
							} else {
								_tmp10_ = FALSE;
							}
							if (_tmp10_) {
								Player* _tmp17_;
								gint _tmp17__length1;
								gint _tmp17__length2;
								gint _tmp18_;
								gint _tmp19_;
								Player _tmp20_;
								_tmp17_ = self->priv->board;
								_tmp17__length1 = self->priv->board_length1;
								_tmp17__length2 = self->priv->board_length2;
								_tmp18_ = k;
								_tmp19_ = l;
								_tmp20_ = _tmp17_[((i + _tmp18_) * _tmp17__length2) + (j + _tmp19_)];
								_tmp9_ = _tmp20_ != PLAYER_NONE;
							} else {
								_tmp9_ = FALSE;
							}
							if (_tmp9_) {
								result = FALSE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void
decision_tree_set_level (DecisionTree* self,
                         const gchar* vstr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (vstr != NULL);
	if (string_get (vstr, (glong) 0) == 'a') {
		self->priv->level = DIFFICULTY_EASY;
		self->priv->plies = 4;
	} else {
		if (string_get (vstr, (glong) 0) == 'b') {
			self->priv->level = DIFFICULTY_MEDIUM;
			self->priv->plies = 7;
		} else {
			self->priv->level = DIFFICULTY_HARD;
			self->priv->plies = 7;
		}
	}
}


gint
decision_tree_playandcheck (DecisionTree* self,
                            const gchar* vstr)
{
	gint result = 0;
	gint temp = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (vstr != NULL, 0);
	decision_tree_set_level (self, vstr);
	decision_tree_update_board (self, vstr);
	temp = decision_tree_immediate_win (self, PLAYER_AI);
	_tmp0_ = temp;
	if (_tmp0_ != -1) {
		result = 1000;
		return result;
	}
	temp = decision_tree_immediate_win (self, PLAYER_HUMAN);
	_tmp1_ = temp;
	if (_tmp1_ != -1) {
		gint _tmp2_;
		_tmp2_ = temp;
		result = _tmp2_ + 1;
		return result;
	}
	_tmp3_ = self->priv->plies;
	decision_tree_negamax (self, _tmp3_, NEG_INF, -1 * NEG_INF);
	_tmp4_ = self->priv->next_move_in_column;
	result = _tmp4_ + 1;
	return result;
}


static void
value_decision_tree_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
value_decision_tree_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		decision_tree_unref (value->data[0].v_pointer);
	}
}


static void
value_decision_tree_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = decision_tree_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
value_decision_tree_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
value_decision_tree_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DecisionTree * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = decision_tree_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
value_decision_tree_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	DecisionTree ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = decision_tree_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
param_spec_decision_tree (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ParamSpecDecisionTree* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DECISION_TREE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
value_get_decision_tree (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DECISION_TREE), NULL);
	return value->data[0].v_pointer;
}


void
value_set_decision_tree (GValue* value,
                         gpointer v_object)
{
	DecisionTree * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DECISION_TREE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DECISION_TREE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		decision_tree_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		decision_tree_unref (old);
	}
}


void
value_take_decision_tree (GValue* value,
                          gpointer v_object)
{
	DecisionTree * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DECISION_TREE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DECISION_TREE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		decision_tree_unref (old);
	}
}


static void
decision_tree_class_init (DecisionTreeClass * klass)
{
	decision_tree_parent_class = g_type_class_peek_parent (klass);
	((DecisionTreeClass *) klass)->finalize = decision_tree_finalize;
	g_type_class_add_private (klass, sizeof (DecisionTreePrivate));
}


static void
decision_tree_instance_init (DecisionTree * self)
{
	Player* _tmp0_;
	self->priv = DECISION_TREE_GET_PRIVATE (self);
	_tmp0_ = g_new0 (Player, BOARD_ROWS * BOARD_COLUMNS);
	self->priv->board = _tmp0_;
	self->priv->board_length1 = BOARD_ROWS;
	self->priv->board_length2 = BOARD_COLUMNS;
	self->priv->plies = 8;
	self->priv->last_moving_player = PLAYER_NONE;
	self->priv->next_move_in_column = -1;
	self->ref_count = 1;
}


static void
decision_tree_finalize (DecisionTree * obj)
{
	DecisionTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DECISION_TREE, DecisionTree);
	g_signal_handlers_destroy (self);
	self->priv->board = (g_free (self->priv->board), NULL);
}


GType
decision_tree_get_type (void)
{
	static volatile gsize decision_tree_type_id__volatile = 0;
	if (g_once_init_enter (&decision_tree_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_decision_tree_init, value_decision_tree_free_value, value_decision_tree_copy_value, value_decision_tree_peek_pointer, "p", value_decision_tree_collect_value, "p", value_decision_tree_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DecisionTreeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) decision_tree_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DecisionTree), 0, (GInstanceInitFunc) decision_tree_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType decision_tree_type_id;
		decision_tree_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DecisionTree", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&decision_tree_type_id__volatile, decision_tree_type_id);
	}
	return decision_tree_type_id__volatile;
}


gpointer
decision_tree_ref (gpointer instance)
{
	DecisionTree * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
decision_tree_unref (gpointer instance)
{
	DecisionTree * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DECISION_TREE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



