/* test-ai.c generated by valac 0.39.92, the Vala compiler
 * generated from test-ai.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Michael Catanzaro
 * Copyright © 2014 Nikhar Agrawal
 *
 * This file is part of Four-in-a-row.
 *
 * Four-in-a-row is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * Four-in-a-row is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Four-in-a-row.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_DECISION_TREE (decision_tree_get_type ())
#define DECISION_TREE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DECISION_TREE, DecisionTree))
#define DECISION_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DECISION_TREE, DecisionTreeClass))
#define IS_DECISION_TREE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DECISION_TREE))
#define IS_DECISION_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DECISION_TREE))
#define DECISION_TREE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DECISION_TREE, DecisionTreeClass))

typedef struct _DecisionTree DecisionTree;
typedef struct _DecisionTreeClass DecisionTreeClass;
#define _decision_tree_unref0(var) ((var == NULL) ? NULL : (var = (decision_tree_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);



#define NUMBER_GAMES 5
#define MAXIMUM_GAMES 100
#define THRESHOLD_DENOMINATOR 4
void test_horizontal_win (void);
gint playgame (const gchar* moves_until_now);
void test_vertical_win (void);
void test_forward_diagonal_win (void);
void test_backward_diagonal_win (void);
void test_avoid_vertical_loss (void);
void test_avoid_forward_diagonal_loss (void);
void test_avoid_backward_diagonal_loss (void);
void test_avoid_horizontal_loss (void);
void test_draw (void);
void test_random (void);
gint test_ai_vs_ai (const gchar* easier,
                    const gchar* harder);
gpointer decision_tree_ref (gpointer instance);
void decision_tree_unref (gpointer instance);
GParamSpec* param_spec_decision_tree (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void value_set_decision_tree (GValue* value,
                              gpointer v_object);
void value_take_decision_tree (GValue* value,
                               gpointer v_object);
gpointer value_get_decision_tree (const GValue* value);
GType decision_tree_get_type (void) G_GNUC_CONST;
DecisionTree* decision_tree_new (void);
DecisionTree* decision_tree_construct (GType object_type);
gint decision_tree_playandcheck (DecisionTree* self,
                                 const gchar* vstr);
void repeat_contests (const gchar* easier,
                      const gchar* harder,
                      gint* games_contested,
                      gint* easy_wins);
void test_easy_vs_medium (void);
void test_easy_vs_hard (void);
void test_medium_vs_hard (void);
gint _vala_main (gchar** args,
                 int args_length1);
static void _test_horizontal_win_gtest_func (void);
static void _test_vertical_win_gtest_func (void);
static void _test_forward_diagonal_win_gtest_func (void);
static void _test_backward_diagonal_win_gtest_func (void);
static void _test_avoid_horizontal_loss_gtest_func (void);
static void _test_avoid_vertical_loss_gtest_func (void);
static void _test_avoid_forward_diagonal_loss_gtest_func (void);
static void _test_avoid_backward_diagonal_loss_gtest_func (void);
static void _test_easy_vs_medium_gtest_func (void);
static void _test_easy_vs_hard_gtest_func (void);
static void _test_medium_vs_hard_gtest_func (void);
static void _test_draw_gtest_func (void);
static void _test_random_gtest_func (void);


void
test_horizontal_win (void)
{
	_vala_assert (playgame ("a1727370") == 4, "playgame (\"a1727370\") == 4");
	_vala_assert (playgame ("a7315651311324420") == 6, "playgame (\"a7315651311324420\") == 6");
	_vala_assert (playgame ("a232225657223561611133440") == 4, "playgame (\"a232225657223561611133440\") == 4");
	_vala_assert (playgame ("a242215322574255543341746677453337710") == 1, "playgame (\"a242215322574255543341746677453337710\") == 1");
}


void
test_vertical_win (void)
{
	_vala_assert (playgame ("a1213140") == 1, "playgame (\"a1213140\") == 1");
	_vala_assert (playgame ("a14456535526613130") == 1, "playgame (\"a14456535526613130\") == 1");
	_vala_assert (playgame ("a432334277752576710") == 7, "playgame (\"a432334277752576710\") == 7");
	_vala_assert (playgame ("a547477454544323321712116260") == 2, "playgame (\"a547477454544323321712116260\") == 2");
}


void
test_forward_diagonal_win (void)
{
	_vala_assert (playgame ("a54221164712446211622157570") == 7, "playgame (\"a54221164712446211622157570\") == 7");
	_vala_assert (playgame ("a4256424426621271412117175776343330") == 3, "playgame (\"a4256424426621271412117175776343330\") == 3");
	_vala_assert (playgame ("a132565522322662666775443351131113540") == 4, "playgame (\"a132565522322662666775443351131113540\") == 4");
	_vala_assert (playgame ("a4571311334541225544112245262577767733360") == 6, "playgame (\"a4571311334541225544112245262577767733360\") == 6");
}


void
test_backward_diagonal_win (void)
{
	_vala_assert (playgame ("5422327343142110") == 1, "playgame (\"5422327343142110\") == 1");
	_vala_assert (playgame ("a1415113315143220") == 2, "playgame (\"a1415113315143220\") == 2");
	_vala_assert (playgame ("a547323452213345110") == 1, "playgame (\"a547323452213345110\") == 1");
	_vala_assert (playgame ("a4256424426621271412117175776343330") == 3, "playgame (\"a4256424426621271412117175776343330\") == 3");
}


void
test_avoid_vertical_loss (void)
{
	_vala_assert (playgame ("a42563117273430") == 3, "playgame (\"a42563117273430\") == 3");
	_vala_assert (playgame ("a3642571541322340") == 4, "playgame (\"a3642571541322340\") == 4");
	_vala_assert (playgame ("a144566264475171137750") == 5, "playgame (\"a144566264475171137750\") == 5");
	_vala_assert (playgame ("a54747745454432332171210") == 1, "playgame (\"a54747745454432332171210\") == 1");
}


void
test_avoid_forward_diagonal_loss (void)
{
	_vala_assert (playgame ("a34256477331566570") == 7, "playgame (\"a34256477331566570\") == 7");
	_vala_assert (playgame ("a1445662644751711370") == 7, "playgame (\"a1445662644751711370\") == 7");
	_vala_assert (playgame ("a43442235372115113340") == 4, "playgame (\"a43442235372115113340\") == 4");
	_vala_assert (playgame ("a4143525567766443543125411170") == 7, "playgame (\"a4143525567766443543125411170\") == 7");
}


void
test_avoid_backward_diagonal_loss (void)
{
	_vala_assert (playgame ("a47465234222530") == 3, "playgame (\"a47465234222530\") == 3");
	_vala_assert (playgame ("a4344223537211510") == 1, "playgame (\"a4344223537211510\") == 1");
	_vala_assert (playgame ("a4141311525513520") == 2, "playgame (\"a4141311525513520\") == 2");
	_vala_assert (playgame ("a1445662644751711377553330") == 3, "playgame (\"a1445662644751711377553330\") == 3");
}


void
test_avoid_horizontal_loss (void)
{
	_vala_assert (playgame ("a445360") == 7, "playgame (\"a445360\") == 7");
	_vala_assert (playgame ("a745534131117114777720") == 2, "playgame (\"a745534131117114777720\") == 2");
	_vala_assert (playgame ("a243466431217112323350") == 5, "playgame (\"a243466431217112323350\") == 5");
	_vala_assert (playgame ("a24147356465355111336631615240") == 4, "playgame (\"a24147356465355111336631615240\") == 4");
}


void
test_draw (void)
{
	_vala_assert (playgame ("a1311313113652226667224247766737374455445550") == 0, "playgame (\"a1311313113652226667224247766737374455445550\") == 0");
	_vala_assert (playgame ("a6121151135432322433425566474425617635677770") == 0, "playgame (\"a6121151135432322433425566474425617635677770\") == 0");
	_vala_assert (playgame ("a4226111412113275256335534443264375577676670") == 0, "playgame (\"a4226111412113275256335534443264375577676670\") == 0");
	_vala_assert (playgame ("a4212116575717754775221133434432366655342660") == 0, "playgame (\"a4212116575717754775221133434432366655342660\") == 0");
}


void
test_random (void)
{
	gint x = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_;
	x = playgame ("a443256214350");
	_tmp1_ = x;
	if (_tmp1_ >= 1) {
		gint _tmp2_;
		_tmp2_ = x;
		_tmp0_ = _tmp2_ <= 7;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "x >= 1 && x <= 7");
	x = playgame ("a241473564653551113366316150");
	_tmp4_ = x;
	if (_tmp4_ >= 1) {
		gint _tmp5_;
		_tmp5_ = x;
		_tmp3_ = _tmp5_ <= 7;
	} else {
		_tmp3_ = FALSE;
	}
	_vala_assert (_tmp3_, "x >= 1 && x <= 7");
	x = playgame ("a24357315461711177416622623350");
	_tmp7_ = x;
	if (_tmp7_ >= 1) {
		gint _tmp8_;
		_tmp8_ = x;
		_tmp6_ = _tmp8_ <= 7;
	} else {
		_tmp6_ = FALSE;
	}
	_vala_assert (_tmp6_, "x >= 1 && x <= 7");
	x = playgame ("a1445662644751711377553333665775446110");
	_tmp10_ = x;
	if (_tmp10_ >= 1) {
		gint _tmp11_;
		_tmp11_ = x;
		_tmp9_ = _tmp11_ <= 7;
	} else {
		_tmp9_ = FALSE;
	}
	_vala_assert (_tmp9_, "x >= 1 && x <= 7");
}


gint
test_ai_vs_ai (const gchar* easier,
               const gchar* harder)
{
	gint result = 0;
	gint easier_wins = 0;
	gint draw = 0;
	gint harder_wins = 0;
	g_return_val_if_fail (easier != NULL, 0);
	g_return_val_if_fail (harder != NULL, 0);
	easier_wins = 0;
	draw = 0;
	harder_wins = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GString* e = NULL;
				GString* _tmp3_;
				GString* _tmp4_;
				GString* m = NULL;
				GString* _tmp5_;
				GString* _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < NUMBER_GAMES)) {
					break;
				}
				_tmp3_ = g_string_new ("");
				e = _tmp3_;
				_tmp4_ = e;
				g_string_append (_tmp4_, easier);
				_tmp5_ = g_string_new ("");
				m = _tmp5_;
				_tmp6_ = m;
				g_string_append (_tmp6_, harder);
				while (TRUE) {
					gint move = 0;
					DecisionTree* t = NULL;
					DecisionTree* _tmp7_;
					DecisionTree* _tmp8_;
					GString* _tmp9_;
					const gchar* _tmp10_;
					gint _tmp11_;
					gint _tmp13_;
					GString* _tmp15_;
					GString* _tmp16_;
					const gchar* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					GString* _tmp23_;
					GString* _tmp24_;
					const gchar* _tmp25_;
					gint _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					DecisionTree* d = NULL;
					DecisionTree* _tmp31_;
					DecisionTree* _tmp32_;
					GString* _tmp33_;
					const gchar* _tmp34_;
					gint _tmp35_;
					gint _tmp37_;
					GString* _tmp39_;
					GString* _tmp40_;
					const gchar* _tmp41_;
					gint _tmp42_;
					gint _tmp43_;
					gint _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					GString* _tmp47_;
					GString* _tmp48_;
					const gchar* _tmp49_;
					gint _tmp50_;
					gint _tmp51_;
					gint _tmp52_;
					gchar* _tmp53_;
					gchar* _tmp54_;
					_tmp7_ = decision_tree_new ();
					t = _tmp7_;
					_tmp8_ = t;
					_tmp9_ = e;
					_tmp10_ = _tmp9_->str;
					move = decision_tree_playandcheck (_tmp8_, _tmp10_);
					_tmp11_ = move;
					if (_tmp11_ == 0) {
						gint _tmp12_;
						_tmp12_ = draw;
						draw = _tmp12_ + 1;
						_decision_tree_unref0 (t);
						break;
					}
					_tmp13_ = move;
					if (_tmp13_ == 1000) {
						gint _tmp14_;
						_tmp14_ = easier_wins;
						easier_wins = _tmp14_ + 1;
						_decision_tree_unref0 (t);
						break;
					}
					_tmp15_ = e;
					_tmp16_ = e;
					_tmp17_ = _tmp16_->str;
					_tmp18_ = strlen (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = move;
					_tmp21_ = g_strdup_printf ("%i", _tmp20_);
					_tmp22_ = _tmp21_;
					g_string_insert (_tmp15_, (gssize) (_tmp19_ - 1), _tmp22_);
					_g_free0 (_tmp22_);
					_tmp23_ = m;
					_tmp24_ = m;
					_tmp25_ = _tmp24_->str;
					_tmp26_ = strlen (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = move;
					_tmp29_ = g_strdup_printf ("%i", _tmp28_);
					_tmp30_ = _tmp29_;
					g_string_insert (_tmp23_, (gssize) (_tmp27_ - 1), _tmp30_);
					_g_free0 (_tmp30_);
					_tmp31_ = decision_tree_new ();
					d = _tmp31_;
					_tmp32_ = d;
					_tmp33_ = m;
					_tmp34_ = _tmp33_->str;
					move = decision_tree_playandcheck (_tmp32_, _tmp34_);
					_tmp35_ = move;
					if (_tmp35_ == 0) {
						gint _tmp36_;
						_tmp36_ = draw;
						draw = _tmp36_ + 1;
						_decision_tree_unref0 (d);
						_decision_tree_unref0 (t);
						break;
					}
					_tmp37_ = move;
					if (_tmp37_ == 1000) {
						gint _tmp38_;
						_tmp38_ = harder_wins;
						harder_wins = _tmp38_ + 1;
						_decision_tree_unref0 (d);
						_decision_tree_unref0 (t);
						break;
					}
					_tmp39_ = e;
					_tmp40_ = e;
					_tmp41_ = _tmp40_->str;
					_tmp42_ = strlen (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = move;
					_tmp45_ = g_strdup_printf ("%i", _tmp44_);
					_tmp46_ = _tmp45_;
					g_string_insert (_tmp39_, (gssize) (_tmp43_ - 1), _tmp46_);
					_g_free0 (_tmp46_);
					_tmp47_ = m;
					_tmp48_ = m;
					_tmp49_ = _tmp48_->str;
					_tmp50_ = strlen (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = move;
					_tmp53_ = g_strdup_printf ("%i", _tmp52_);
					_tmp54_ = _tmp53_;
					g_string_insert (_tmp47_, (gssize) (_tmp51_ - 1), _tmp54_);
					_g_free0 (_tmp54_);
					_decision_tree_unref0 (d);
					_decision_tree_unref0 (t);
				}
				_g_string_free0 (m);
				_g_string_free0 (e);
			}
		}
	}
	result = easier_wins;
	return result;
}


void
repeat_contests (const gchar* easier,
                 const gchar* harder,
                 gint* games_contested,
                 gint* easy_wins)
{
	gint _vala_games_contested = 0;
	gint _vala_easy_wins = 0;
	g_return_if_fail (easier != NULL);
	g_return_if_fail (harder != NULL);
	_vala_easy_wins = test_ai_vs_ai (easier, harder);
	_vala_games_contested = NUMBER_GAMES;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gint _tmp1_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp1_ = _vala_games_contested;
		if (_tmp1_ <= MAXIMUM_GAMES) {
			gint _tmp2_;
			gint _tmp3_;
			_tmp2_ = _vala_easy_wins;
			_tmp3_ = _vala_games_contested;
			_tmp0_ = _tmp2_ > (_tmp3_ / THRESHOLD_DENOMINATOR);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp4_ = _vala_easy_wins;
		_vala_easy_wins = _tmp4_ + test_ai_vs_ai (easier, harder);
		_tmp5_ = _vala_games_contested;
		_vala_games_contested = _tmp5_ + NUMBER_GAMES;
	}
	if (games_contested) {
		*games_contested = _vala_games_contested;
	}
	if (easy_wins) {
		*easy_wins = _vala_easy_wins;
	}
}


void
test_easy_vs_medium (void)
{
	gint easy_wins = 0;
	gint games_contested = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	repeat_contests ("a0", "b0", &_tmp0_, &_tmp1_);
	games_contested = _tmp0_;
	easy_wins = _tmp1_;
	_vala_assert (easy_wins <= (games_contested / THRESHOLD_DENOMINATOR), "easy_wins <= games_contested/THRESHOLD_DENOMINATOR");
}


void
test_easy_vs_hard (void)
{
	gint easy_wins = 0;
	gint games_contested = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	repeat_contests ("a0", "c0", &_tmp0_, &_tmp1_);
	games_contested = _tmp0_;
	easy_wins = _tmp1_;
	_vala_assert (easy_wins <= (games_contested / THRESHOLD_DENOMINATOR), "easy_wins <= games_contested/THRESHOLD_DENOMINATOR");
}


void
test_medium_vs_hard (void)
{
	gint medium_wins = 0;
	gint games_contested = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	repeat_contests ("b0", "c0", &_tmp0_, &_tmp1_);
	games_contested = _tmp0_;
	medium_wins = _tmp1_;
	_vala_assert (medium_wins <= (games_contested / THRESHOLD_DENOMINATOR), "medium_wins <= games_contested/THRESHOLD_DENOMINATOR");
}


static void
_test_horizontal_win_gtest_func (void)
{
	test_horizontal_win ();
}


static void
_test_vertical_win_gtest_func (void)
{
	test_vertical_win ();
}


static void
_test_forward_diagonal_win_gtest_func (void)
{
	test_forward_diagonal_win ();
}


static void
_test_backward_diagonal_win_gtest_func (void)
{
	test_backward_diagonal_win ();
}


static void
_test_avoid_horizontal_loss_gtest_func (void)
{
	test_avoid_horizontal_loss ();
}


static void
_test_avoid_vertical_loss_gtest_func (void)
{
	test_avoid_vertical_loss ();
}


static void
_test_avoid_forward_diagonal_loss_gtest_func (void)
{
	test_avoid_forward_diagonal_loss ();
}


static void
_test_avoid_backward_diagonal_loss_gtest_func (void)
{
	test_avoid_backward_diagonal_loss ();
}


static void
_test_easy_vs_medium_gtest_func (void)
{
	test_easy_vs_medium ();
}


static void
_test_easy_vs_hard_gtest_func (void)
{
	test_easy_vs_hard ();
}


static void
_test_medium_vs_hard_gtest_func (void)
{
	test_medium_vs_hard ();
}


static void
_test_draw_gtest_func (void)
{
	test_draw ();
}


static void
_test_random_gtest_func (void)
{
	test_random ();
}


gint
_vala_main (gchar** args,
            int args_length1)
{
	gint result = 0;
	g_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/AI/Take Win/Horizontal Win", _test_horizontal_win_gtest_func);
	g_test_add_func ("/AI/Take Win/Vertical Win", _test_vertical_win_gtest_func);
	g_test_add_func ("/AI/Take Win/Forward Diagonal Win", _test_forward_diagonal_win_gtest_func);
	g_test_add_func ("/AI/Take Win/Backward Diagonal Win", _test_backward_diagonal_win_gtest_func);
	g_test_add_func ("/AI/Avoid Loss/Horizontal Loss", _test_avoid_horizontal_loss_gtest_func);
	g_test_add_func ("/AI/Avoid Loss/Vertical Loss", _test_avoid_vertical_loss_gtest_func);
	g_test_add_func ("/AI/Avoid Loss/Forward Diagonal Loss", _test_avoid_forward_diagonal_loss_gtest_func);
	g_test_add_func ("/AI/Avoid Loss/Backward Diagonal Loss", _test_avoid_backward_diagonal_loss_gtest_func);
	g_test_add_func ("/AI/AI vs AI/Easy vs Medium", _test_easy_vs_medium_gtest_func);
	g_test_add_func ("/AI/AI vs AI/Easy vs Hard", _test_easy_vs_hard_gtest_func);
	g_test_add_func ("/AI/AI vs AI/Medium vs Hard", _test_medium_vs_hard_gtest_func);
	g_test_add_func ("/AI/Draw", _test_draw_gtest_func);
	g_test_add_func ("/AI/Random", _test_random_gtest_func);
	result = g_test_run ();
	return result;
}


int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}



