/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GALEON_WRAPPER_H
#define GALEON_WRAPPER_H

#include "nsIContentViewer.h"
#include "nsIDOMDocument.h"
#include "nsIWebNavigation.h"
#include "nsISHistory.h"
#include "nsIDocShell.h"
#include "nsIDOMEventTarget.h"
#include "nsIDOMMouseEvent.h"
#include "nsIDOMKeyEvent.h"
#include "nsIDOMEventListener.h"
#include "nsIDOMDragListener.h"
#include "nsIWebBrowser.h"
#include "nsITextServicesDocument.h"
#include "nsCOMPtr.h"
#include "nsIDOMEventReceiver.h"
#include "nsIPrintOptions.h"
#include "nsICookieManager.h"
#include "nsICookie.h"
#include "nsIPermissionManager.h"
#include "nsIPermission.h"
#include "nsIImgManager.h"
#include "nsPIDOMWindow.h"

#include <gtkmozembed.h>

#define COOKIEMANAGER_ID "@mozilla.org/cookiemanager;1"
#define PERMISSIONMANAGER_ID "@mozilla.org/permissionmanager;1"
#define IMAGEMANAGER_ID "@mozilla.org/imgmanager;1"
#define CACHESERVICE_ID "@mozilla.org/network/cache-service;1"

class GaleonWrapper;

class GaleonEventListener : public nsIDOMDragListener
{
public:
	GaleonEventListener();
	virtual ~GaleonEventListener();

	void Init (GaleonWrapper *embed);
  
	NS_DECL_ISUPPORTS

	// nsIDOMEventListener
	
	NS_IMETHOD HandleEvent(nsIDOMEvent* aEvent);

	// nsIDOMDragListener

	NS_IMETHOD DragEnter(nsIDOMEvent* aMouseEvent);
	NS_IMETHOD DragExit(nsIDOMEvent* aMouseEvent);
	NS_IMETHOD DragDrop(nsIDOMEvent* aMouseEvent);
	NS_IMETHOD DragGesture(nsIDOMEvent* aMouseEvent);
	NS_IMETHOD DragOver(nsIDOMEvent* aMouseEvent);

private:
	GaleonWrapper *wrapper;
};

class GaleonWrapper
{
public:
	GaleonWrapper();
	~GaleonWrapper();

	nsresult Init (GaleonEmbed *galeon_embed);
	nsresult Destroy (void);
	nsresult AddListener (void);
	nsresult RemoveListener (void);
	nsresult AddEventListener (void);
	nsresult RemoveEventListener (void);

	nsresult SetZoom (float aTextZoom);
	nsresult GetZoom (float *aTextZoom);

	nsresult SaveURI (const char *url, char *filename, int action);
	nsresult SaveLink (const char *url);

	nsresult Print (nsIPrintOptions *options);

	nsresult Find (const PRUnichar *search_string, PRBool matchcase, 
		       PRBool search_backwards, PRBool *didFind);

	nsresult GetMainDocumentUrl (char **url);
	nsresult GetDocumentUrl (char **url);

	nsresult ReloadDocument ();

	nsresult GetSHInfo (PRInt32 *count, PRInt32 *index);
	nsresult GetSHTitleAtIndex (PRInt32 index, PRUnichar **title);
	nsresult GetSHUrlAtIndex (PRInt32 index, char **url);

	nsresult GetEventContext (nsIDOMEventTarget *EventTarget, WrapperContextInfo *info);
	nsresult GetKeyEventContext (nsIDOMKeyEvent *keyEvent, WrapperKeyEventInfo *info);
	nsresult GetMouseEventContext (nsIDOMMouseEvent *event, WrapperMouseEventInfo *info);
	nsresult ScrollbarClicked (nsIDOMMouseEvent *aMouseEvent);

	nsresult CopyHistoryTo (GaleonWrapper *embed);

	nsresult GoToHistoryIndex (PRInt16 index);

	nsresult SetSitePermission( PRBool permission, PRInt32 type );

	nsresult ForceCharacterSet (char *charset);

	nsresult IsPageFramed (nsIDOMNode *node, PRBool *Framed);
	
	nsresult GetFaviconURL (char **favicon_url);
	
	nsresult SetOffline(PRBool aOffline);

	nsresult CanCutSelection(PRBool *result);

	nsresult CanCopySelection(PRBool *result);

	nsresult CanPaste(PRBool *result);

	nsresult CutSelection(void);

	nsresult CopySelection(void);

	nsresult Paste(void);

	nsresult Activate ();
	nsresult Deactivate ();

	nsCOMPtr<nsIWebBrowser>           mWebBrowser;

	nsCOMPtr<GaleonEventListener> mEventListener;
        nsCOMPtr<nsIDOMEventReceiver> mEventReceiver;

	nsCOMPtr<nsIWebNavigation>        mChromeNav;

	GtkMozEmbed *mGtkMozEmbed;
	GaleonEmbed *embed;
	PRBool attachListener;

private:
	nsresult GetDOMAttribute (nsIDOMNode *node, const char *tag,
				  char **attribute);
	nsresult GetDOMDocument (nsIDOMDocument **aDOMDocument);
	nsresult GetMainDOMDocument (nsIDOMDocument **aDOMDocument);
	nsresult GetDocShell (nsIDocShell **aDocShell);
	nsresult GetSHistory (nsISHistory **aSHistory);
	nsresult GetPIDOMWindow(nsPIDOMWindow **aPIWin);
};

#endif
