/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtkclist.h>
#include <gtk/gtkctree.h>
#include <gtk/gtkmenuitem.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtktooltips.h>
#include <gtk/gtkentry.h>

#define BOOKMARKS_MENU_MAX_LENGTH 40 /** Max length of a bookmark menu item */
#define BOOKMARKS_TOOLTIP_MAX_LENGTH 30 /** Max length of a bookmark url tooltip */
void bookmarks_init (void);
void bookmarks_exit (void);
BookmarkItem * bookmarks_new_bookmark (BookmarkType type, gboolean escape_name,
					const char *name, const char *url, 
					const char *nick, const char *notes, 
					const char *pixmap_file);
BookmarkItem *bookmarks_new_alias (BookmarkItem *b);
void bookmarks_update_alias (BookmarkItem *b);
void bookmarks_set_visited (BookmarkItem *b);
BookmarkItem *bookmarks_find_real_bookmark (BookmarkItem *b);
BookmarkItem *bookmarks_copy_bookmark (BookmarkItem *b);
void bookmarks_free_bookmark (BookmarkItem *b);
void bookmarks_load (void);
BookmarkItem *bookmarks_load_from (char *file);
void bookmarks_updated (void);
void bookmarks_smart_bm_dialog (GaleonEmbed *embed, GaleonEmbed **newembed,
				BookmarkItem *b, LinkState state);
gint bookmarks_move_bookmark (BookmarksEditorControls *controls,
			      BookmarkItem *b, int where);
void bookmarks_insert_bookmark (BookmarkItem *b, BookmarkItem *near,
				GtkCListDragPos insert_pos);
void bookmarks_remove_recursively (BookmarkItem *b);
void bookmarks_string_request_callback (gchar *string, BookmarkItem *new_item);
BookmarkItem *add_bookmark_default (BookmarkType type, const gchar *name,
				    const gchar *url, BookmarkItem *parent);
BookmarkItem *add_temp_link_bookmark (const gchar *name, const gchar *url,
				      BookmarkItem *parent);
GSList *bookmarks_list_all_urls(BookmarkItem *bookmark);
GSList *bookmarks_list_all_folders(BookmarkItem *bookmark);
gchar *bookmarks_parse_nick (gchar *text, BookmarkItem *root);
gchar *bookmarks_substitute_argument (BookmarkItem *b, const gchar *arguments);
void bookmarks_editor_place_tree_item (BookmarksEditorControls *controls,
				       BookmarkItem *b);
void bookmarks_editor_place_tree_items (BookmarkItem *b);
void bookmarks_editor_update_tree_item (BookmarksEditorControls *controls,
					BookmarkItem *b);
void bookmarks_editor_update_tree_items (BookmarkItem *b);
void bookmarks_editor_remove_tree_item (BookmarksEditorControls *controls,
					BookmarkItem *b);
void bookmarks_editor_remove_tree_items (BookmarkItem *b);
void bookmarks_editor_select_bookmark (BookmarksEditorControls *controls,
				       BookmarkItem *b);
gchar *bookmarks_item_to_string (BookmarkItem *root);
BookmarkItem *bookmarks_item_from_string (char *string);
BookmarksEditorControls *bookmarks_editor_show_dialog (GaleonWindow *window);
void bookmarks_editor_hide_dialog (BookmarksEditorControls *controls);
BookmarksEditorControls *bookmarks_editor_show_dock (GaleonWindow *window);
void bookmarks_import_netscape_activate_cb (GtkMenuItem *menuitem,
					    GaleonWindow *window);
void bookmarks_import_mozilla_activate_cb (GtkMenuItem *menuitem,
					   GaleonWindow *window);
GList *bookmarks_get_selections_sorted (GtkCList *clist);
gchar *bookmarks_translate_string (gchar *smart_bm_string);
void bookmarks_folder_open_all_items (GaleonEmbed *embed, BookmarkItem *bi,
				      gboolean new_window, gboolean reuse);
const PixmapData *bookmarks_get_siteicon (const gchar *url);
GtkCTreeNode *bookmarks_get_tree_item (BookmarkItem *b, BookmarksEditorControls *c);
void bookmarks_set_tree_item (BookmarkItem *b, BookmarksEditorControls *c, GtkCTreeNode *n);
void bookmarks_create_edit_items (GtkMenu *popup,
				  BookmarksEditorControls *controls);
void bookmarks_editor_set_root (BookmarksEditorControls *controls, 
		BookmarkItem *b);
gboolean bookmarks_is_ancestor (BookmarkItem *a, BookmarkItem *b);
BookmarkItem *bookmarks_find_by_nick (const gchar *nick, BookmarkItem *root,
				      gboolean wantsmart);
void bookmarks_editors_refresh (void);
void bookmarks_merge_trees (BookmarkItem *root1, BookmarkItem *root2);
void bookmarks_save_as (const gchar *file);
void bookmarks_set_root (BookmarkItem *new_root);
void bookmarks_sort_norec (BookmarkItem *b, gboolean update_edit);
void bookmarks_sort_rec (BookmarkItem *b, gboolean update_edit);
void bookmarks_editor_popup_menu (BookmarksEditorControls *controls);

/* bookmarks_menus.c */
void bookmarks_menu_create (GaleonWindow *window);
void bookmarks_menu_recreate (GaleonWindow *window);
/* FIXME: dont export the next two? */
GtkMenu *bookmarks_create_copy_menu (BookmarkItem *source);
void bookmarks_menu_create_recursively (BookmarkItem *bookmark, GtkMenu *menu, 
					GtkMenuItem *file_menuitem,
					GtkTooltips *tooltips, 
					gboolean options, 
					gboolean disable_tearoffs);
void bookmarks_menu_create_extra_items (GtkMenu *menu,
					BookmarkItem *bookmark,
					ExtraItemsLocation opts_location);
void bookmarks_menu_create_base_extra_items (GtkMenu *menu,
					     BookmarkItem *bookmark);
void bookmarks_item_create_extra_items (GtkMenu *extra_menu, 
					BookmarkItem *bookmark);
void bookmarks_item_create_base_extra_items (GtkMenu *menu,
					     BookmarkItem *bookmark);

/* bookmarks_menus_callbacks.c */
void bookmarks_export_other_activate_cb (GtkMenuItem *menuitem,
					 BookmarksEditorControls *controls);
void bookmarks_export_xbel_activate_cb (GtkMenuItem *menuitem,
					BookmarksEditorControls *controls);
void bookmarks_import_other_activate_cb (GtkMenuItem *menuitem, 
					 BookmarksEditorControls *controls);
void bookmarks_import_xbel_activate_cb (GtkMenuItem *menuitem, 
					 BookmarksEditorControls *controls);
void bookmarks_import_mozilla_activate_cb (GtkMenuItem *menuitem,
                                           GaleonWindow *window);
void bookmarks_export_netscape_activate_cb (GtkMenuItem *menuitem,
                                            GtkWidget *widget);
void bookmarks_export_mozilla_activate_cb (GtkMenuItem *menuitem,
                                           GtkWidget *widget); 
gboolean bookmarks_button_press_event_cb (GtkWidget *widget,
					  GdkEventButton *event,
					  BookmarkItem *bi);
gboolean bookmarks_button_release_event_cb (GtkWidget *widget, 
					    GdkEventButton *event,
					    BookmarkItem *bi);
void bookmarks_activate_cb (GtkWidget *widget, BookmarkItem *bi);
void bookmarks_open_in_new_tab_activate_cb (GtkWidget *widget,
					    BookmarkItem *bi);
void bookmarks_open_in_new_window_activate_cb (GtkWidget *widget,
					       BookmarkItem *bi);
void bookmarks_copy_link_activate_cb (GtkWidget *widget, BookmarkItem *bi);
void bookmarks_add_activate_cb (GtkWidget *widget, BookmarkItem *bi);
void bookmarks_open_all_activate_cb (GtkWidget *widget, BookmarkItem *bi);
void bookmarks_open_all_in_wins_activate_cb (GtkWidget *widget,
					     BookmarkItem *bi);
void bookmarks_create_toolbar_activate_cb (GtkWidget *widget, BookmarkItem *bi);
void bookmarks_set_as_default_activate_cb (GtkWidget *widget, BookmarkItem *bi);
void bookmarks_edit_activate_cb (GtkWidget *menuitem, BookmarkItem *bm);
void bookmarks_remove_activate_cb (GtkWidget *menuitem, BookmarkItem *bm);
void bookmarks_file_bookmark_cb (GtkWidget *widget, BookmarkItem *parent);
void bookmarks_editor_bookmark_copy_cb (GtkMenuItem *menuitem,
					BookmarkItem *parent);
void bookmarks_nick_entry_activate (GtkEntry *entry, BookmarkItem *b);
void bookmarks_editor_show_attach_cb (GtkWidget *toggle, 
				      BookmarksEditorControls *controls);

/* bookmarks_toolbar.c */
void bookmarks_toolbars_create (GaleonWindow *window);
void bookmarks_toolbars_recreate (GaleonWindow *window);
void bookmarks_toolbars_set_visibility (GaleonWindow *window, 
					gboolean visible);

/* xbel.c */
gboolean xbel_export_bookmarks (const gchar *filename, BookmarkItem *root);
BookmarkItem *xbel_import_bookmarks (const gchar *filename);

