/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include <gtk/gtkwidget.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkmenuitem.h>
#include <gtk/gtkctree.h>
#include <gtk/gtkradiomenuitem.h>
#include <gtk/gtkradiobutton.h>
#include <libgnomeui/gnome-client.h>
#include <glade/glade-xml.h>
#include <gnome-xml/xmlmemory.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>

/* misc.c */
void launch_external_viewer (const gchar *filename);
gchar *user_file (gchar *fname, gboolean critical);
void label_set_accel_text (const gchar *text, GtkWidget *label,
			   GtkWidget *menu, GtkWidget *item);
gchar *strip_uline_accel (const gchar *text);
gchar *escape_uline_accel (const gchar *text);
GtkWidget *new_num_accel_label (int num, gchar *origtext, gboolean lettersok,
				GtkWidget *menu, GtkWidget *item);
void menu_position_under_widget(GtkMenu *menu, gint *x, gint *y,
				gpointer user_data);
void copy_to_clipboard (gchar *text, GaleonEmbed *embed);
gchar *shorten_name (const gchar *name, gint target_length);
void initialise_colours (void);
gchar *read_line_from_file (FILE *f);
const gchar *g_strcasestr (const gchar *a, const gchar *b);
void create_charset_submenus (GtkMenuItem *encoding_menu_item, 
			GList *charset_titles, GaleonWindow *window);
gchar* get_mozilla_prefs_directory (void); 
char *locale_to_utf8 (const char *locstr);
char *utf8_to_locale (const char *utfstr);
xmlAttrPtr xmlSetPropLocale (xmlNodePtr node, 
			     const xmlChar *name, 
			     const xmlChar *value);
xmlChar *xmlGetPropLocale (xmlNodePtr node, const xmlChar *name);
xmlAttrPtr xmlSetRawPropLocale (xmlNodePtr node, 
				const xmlChar *name, 
				const xmlChar *value);
xmlChar *xmlGetRawPropLocale (xmlNodePtr node, const xmlChar *name);
xmlAttrPtr xmlSetRawProp (xmlNodePtr node, 
			  const xmlChar *name, 
			  const xmlChar *value);
xmlChar *xmlGetRawProp (xmlNodePtr node, const xmlChar *name);
gchar *escape_xml_prop (const gchar *text);
gchar *escape_path (const gchar *text);
gchar *unescape_hexed_string (const gchar *text);
LinkState key_state_to_link_state (guint evstate);
LinkState mouse_state_to_link_state (guint button, guint evstate);
PixmapData *pixmap_data_new_from_file (const gchar *file);
void store_time_in_string (GTime t, gchar *str);
void store_full_time_in_string (GTime t, gchar *str);
gchar *time_to_string (GTime t);
gint xmlGetIntProp (xmlNodePtr node, const gchar *attribute);
gint gtk_radio_button_get (GtkRadioButton *radio_button);
void gtk_radio_button_set (GtkRadioButton *radio_button, gint index);
void gtk_ctree_link (GtkCTree *ctree, GtkCTreeNode *node, GtkCTreeNode *parent,
		     GtkCTreeNode *sibling, gboolean update_focus_row);
void gtk_ctree_unlink (GtkCTree *ctree, GtkCTreeNode *node,
		       gboolean update_focus_row);
gchar *new_num_accel_str (gint num, gchar *text, gboolean lettersok);
gchar *misc_parse_nautilus_uri (const gchar *uri);

/* misc_callbacks.c */
void mozembed_destroy_cb (GtkObject *object, GaleonEmbed *embed);
void window_spinner_button_clicked_cb(GtkButton *button, GaleonWindow *window);
void history_menu_menuitem_activate_cb (GtkMenuItem *menuitem, 
					gpointer user_data);
gboolean history_menu_menuitem_button_release_cb (GtkMenuItem *menuitem,
				GdkEventButton *event, gpointer user_data);
void up_menu_menuitem_activate_cb (GtkMenuItem *menuitem, gpointer user_data);
gboolean up_menu_menuitem_button_release_cb (GtkMenuItem *menuitem,
				GdkEventButton *event, gpointer user_data);
gboolean client_save_yourself_cb (GnomeClient *client, gint phase, 
				  GnomeSaveStyle save_style, gint shutdown,
				  GnomeInteractStyle interact_style,
				  gint fast);
gint popup_selection_done_cb (GtkMenuShell *menushell, GtkWidget *popup);
void free_string_array (char *array[], int size);
void context_bm_toolbar_appearance_menu_cb (GtkRadioMenuItem *menuitem, 
					    BookmarkItem *bm);
void context_main_toolbar_appearance_menu_cb (GtkRadioMenuItem *menuitem, 
					      BookmarkItem *bm);
void context_main_toolbar_icons_menu_cb (GtkRadioMenuItem *menuitem,
					 gpointer user_data);
void context_main_toolbar_edit_toolbar_cb (GtkMenuItem *menuitem, 
					   GaleonWindow *window);
#ifdef __cplusplus
}
#endif
