/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include <gtk/gtkbutton.h>
#include <gtk/gtkeditable.h>
#include <gdk/gdktypes.h>

/* window.c */
GaleonWindow *window_create (guint32 chrome_mask);
void window_add_embed (GaleonWindow *window, GaleonEmbed *embed,
		       gboolean force_jump);
void window_clear_url_entry (GaleonWindow *window);
void window_set_url_entry (GaleonWindow *window, const gchar *location);
void window_toggle_fullscreen_mode (GaleonWindow *window);
void window_set_fullscreen_mode (GaleonWindow *window, gboolean active);
void window_show_open_dialog (GaleonWindow *window);
void window_show_openurl_dialog (GaleonWindow *window);
void window_toolbars_recreate (GaleonWindow *window);
void window_save_layout (GaleonWindow *window);
void window_restore_layout (GaleonWindow *window);
void window_show_one_embed (GaleonWindow *window);
void window_hide_one_embed (GaleonWindow *window);
void window_menubar_show (GaleonWindow *window);
void window_menubar_hide (GaleonWindow *window);
void window_toolbar_show (GaleonWindow *window);
void window_toolbar_hide (GaleonWindow *window);
void window_statusbar_show (GaleonWindow *window);
void window_statusbar_hide (GaleonWindow *window);
void window_close (GaleonWindow *window);
void window_load_url (GaleonWindow *window, const gchar *url);
void window_update_temp_message (GaleonWindow *window, const char *message);
void window_update_tab_controls (GaleonWindow *window);
void window_update_nav_controls (GaleonWindow *window);
void window_update_status_bar (GaleonWindow *window);
void window_update_zoom (GaleonWindow *window);
void window_set_visibility (GaleonWindow *window, gboolean visible);
void window_show_error (GaleonWindow *window, char *errormsg);
void window_close (GaleonWindow *window);
void window_go_home (GaleonWindow *window, LinkState state);
void window_reload_all (GaleonWindow *window);
void window_undock (GaleonWindow *window);
void window_dock (GaleonWindow *window, GtkWidget *widget,
		  const gchar *width_pref);
GaleonWindow *window_from_widget (GtkWidget *widget);
void window_create_charset_submenus (GaleonWindow *window, 
				     GList *charset_titles);
void window_session_history_menu_create (GaleonWindow *window);
void window_session_history_update_all (void);
void window_update_bm_and_hist_buttons (GaleonWindow *window, gboolean bm,
				     	gboolean hist);

/* window_callbacks.c */
gboolean window_back_forward_button_press_cb (GtkButton *button,
					      GdkEventButton *event,
					      GaleonWindow *window);
gboolean window_back_forward_button_release_cb (GtkButton *button,
					        GdkEventButton *event,
						GaleonWindow *window);
gboolean window_new_button_press_cb (GtkButton *button, GdkEventButton *event,
				     GaleonWindow *window);
gboolean window_new_button_release_cb (GtkButton *button,
				       GdkEventButton *event,
				       GaleonWindow *window);
void window_new_button_drag_data_received_cb (GtkWidget *widget, 
					      GdkDragContext *drag_context,
					      gint x, gint y,
					      GtkSelectionData *selection_data,
					      guint info, guint time,
					      GaleonWindow *window);
gboolean window_up_button_release_event_cb (GtkButton *button, 
					    GdkEventButton *event,
					    GaleonWindow *window);
gboolean window_up_button_press_event_cb (GtkButton *button, 
					  GdkEventButton *event,
					  GaleonWindow *window);
void window_refresh_button_clicked_cb (GtkButton *button, 
				       GaleonWindow *window);
gboolean window_refresh_button_press_event_cb (GtkButton *button,
					       GdkEventButton *event,
					       GaleonWindow *window);
gboolean window_home_button_press_event_cb (GtkButton *button,
					    GdkEventButton *event,
					    GaleonWindow *window);
gboolean window_home_button_release_event_cb (GtkButton *button,
					      GdkEventButton *event,
					      GaleonWindow *window);
void window_stop_button_clicked_cb (GtkButton *button, GaleonWindow *window);
void window_zoom_spin_changed_cb (GtkEditable *editable, GaleonWindow *window);
gboolean window_zoom_spin_key_press_cb (GtkWidget *widget, GdkEventKey *event,
					GaleonWindow *window);
gboolean window_zoom_spin_button_press_cb (GtkButton *button, 
					   GdkEventButton *event,
					   GaleonWindow *window);
gboolean window_go_button_release_cb (GtkButton *button, GdkEventButton *event,
				      GaleonWindow *window);
void window_drag_pixmap_drag_data_get_cb (GtkWidget *widget, 
					  GdkDragContext *context,
					  GtkSelectionData *selection_data, 
					  guint info, guint time, 
					  GaleonWindow *window);
void window_drag_data_get_cb (GtkWidget *widget, GdkDragContext *context,
			      GtkSelectionData *selection_data, 
			      guint info, guint time, 
			      GaleonWindow *window);
void window_selection_get_cb (GtkWidget *widget, 
			      GtkSelectionData *selection_data,
			      guint info, guint time_stamp, gpointer data);
void window_selection_received_cb (GtkWidget *widget, 
				   GtkSelectionData *selection_data,
				   guint time, GaleonWindow *window);
void open_url_handle_link (GaleonWindow *window, LinkState state);
gboolean open_url_ok_button_release_event_cb (GtkButton *button,
					      GdkEventButton *event,
					      GaleonWindow *window);
void open_url_clear_button_clicked_cb (GtkButton *button, 
				       GaleonWindow *window);
void open_url_cancel_button_clicked_cb (GtkButton *button,
					GaleonWindow *window);
gboolean window_location_entry_key_press_cb (GtkWidget *widget, 
					     GdkEventKey *event,
					     GaleonWindow *window);
void window_location_entry_drag_data_received_cb (GtkWidget *widget, 
						  GdkDragContext *drag_context,
						  gint x, gint y,
						  GtkSelectionData *sel_data, 
						  guint info,
						  guint time, 
						  GaleonWindow *window);
gboolean window_location_entry_button_press_cb (GtkWidget *entry, 
						GdkEventButton *event, 
						GaleonWindow *window);
gboolean window_progress_action (GaleonWindow *window);
void window_location_gnomeentry_popwin_cb (GtkWidget *widget, 
					   GaleonWindow *window);
gboolean window_generic_button_press_event_cb (GtkButton *button, 
					       GdkEventButton *event,
					       GaleonWindow *window);
void window_drag_data_received_cb (GtkWidget *widget, GdkDragContext *context,
				   gint x, gint y,
				   GtkSelectionData *selection_data,
				   guint info, guint time,
				   GaleonWindow *window);
void window_find_button_clicked_cb (GtkButton *button,
				    GaleonWindow *window);
void window_history_button_clicked_cb (GtkButton *button, 
				       GaleonWindow *window);
void window_bookmarks_button_clicked_cb (GtkButton *button, 
					 GaleonWindow *window);
void window_print_button_clicked_cb (GtkButton *button, GaleonWindow *window);
void window_session_history_menuitem_activate_cb (GtkMenuItem *menuitem, 
						  gint index);

#ifdef __cplusplus
}
#endif
