/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <libgnomeui/gnome-file-entry.h>

void
bookmarks_editor_ctree_tree_select_row_cb (GtkCTree *ctree, GList *node,
					   gint column,
					   BookmarksEditorControls *controls);
void
bookmarks_editor_ctree_tree_unselect_row_cb (GtkCTree *ctree, GList *node,
					     gint column,
					     BookmarksEditorControls *controls);
void bookmarks_editor_edited_cb (GtkEditable *editable,
				 BookmarksEditorControls *controls);
void bookmarks_editor_revert_clicked_cb (GtkWidget *widget,
					 BookmarksEditorControls *controls);
void bookmarks_editor_apply_clicked_cb (GtkButton *button,
					BookmarksEditorControls *controls);
void bookmarks_editor_accept_clicked_cb (GtkButton *button,
					 BookmarksEditorControls *controls);
void bookmarks_editor_remove_clicked_cb (GtkButton *button,
					 BookmarksEditorControls *controls);
void bookmarks_editor_move_up_clicked_cb (GtkButton *button,
					  BookmarksEditorControls *controls);
void bookmarks_editor_move_down_clicked_cb (GtkButton *button,
					    BookmarksEditorControls *controls);
void bookmarks_editor_add_alias_cb (GtkButton *button,
				    BookmarksEditorControls *controls);
void bookmarks_editor_fetch_icon_clicked_cb (GtkButton *button,
					     BookmarksEditorControls *controls);
void bookmarks_editor_new_item_clicked_cb (GtkButton *button,
					   BookmarksEditorControls *controls);
void
bookmarks_editor_new_folder_clicked_cb (GtkButton *button,
					  BookmarksEditorControls *controls);
void
bookmarks_editor_new_separator_clicked_cb (GtkButton *button, 
					   BookmarksEditorControls *controls);
gboolean bookmarks_editor_delete_event_cb (GtkWidget *widget, GdkEvent *event,
					   BookmarksEditorControls *controls);
void
bookmarks_editor_edit_toggled_cb (GtkWidget *toggle, 
				  BookmarksEditorControls *controls);
void
bookmarks_editor_set_default_folder_cb (GtkWidget *control, 
					BookmarksEditorControls *controls);

void
bookmarks_editor_go_clicked_cb (GtkButton *button,
				BookmarksEditorControls *controls);

void bookmarks_editor_copy_clicked_cb (GtkButton *button,
				       BookmarksEditorControls *controls);
gboolean
bookmarks_editor_copy_button_press_cb (GtkWidget *widget, GdkEventButton  *event,
				       BookmarksEditorControls *controls);

gboolean 
bookmarks_editor_ctree_button_press_event_cb (GtkWidget *widget,
					      GdkEventButton *event, 
					      BookmarksEditorControls *controls);
gboolean
bookmarks_editor_ctree_key_press_event_cb (GtkWidget *widget,
					   GdkEventKey *event,
					   BookmarksEditorControls *controls);
void bookmarks_editor_ctree_tree_move_cb (GtkCTree *ctree, GtkCTreeNode *node,
					  GtkCTreeNode *new_parent_node, 
					  GtkCTreeNode *new_sibling_node,
					  BookmarksEditorControls *controls);
void bookmarks_editor_tree_expand_cb (GtkCTree *ctree, GtkCTreeNode *node, 
				      BookmarksEditorControls *controls);
void bookmarks_editor_tree_collapse_cb (GtkCTree *ctree, GtkCTreeNode *node, 
					BookmarksEditorControls *controls);

void bookmarks_editor_collapse_all_clicked_cb (GtkButton *button, 
					       BookmarksEditorControls *controls);
void bookmarks_editor_expand_all_cb (GtkButton *button, 
				     BookmarksEditorControls *controls);
void bookmarks_editor_add_alias_root_cb (GtkButton *button,
					 BookmarksEditorControls *controls);
void bookmarks_editor_show_only_this_folder_cb (GtkButton *button,
						  BookmarksEditorControls *controls);

void bookmarks_editor_show_all_bookmarks_cb (GtkButton *button,
					     BookmarksEditorControls *controls);
void bookmarks_editor_copy_cb (GtkButton *button,
			       BookmarksEditorControls *controls);
void bookmarks_editor_cut_cb (GtkButton *button,
			      BookmarksEditorControls *controls);
void bookmarks_editor_paste_cb (GtkButton *button,
				BookmarksEditorControls *controls);
void bookmarks_editor_selection_get_cb (GtkWidget *widget, 
					GtkSelectionData *selection_data,
					guint info, guint time_stamp,
					BookmarksEditorControls *controls);
void bookmarks_editor_browse_clicked_cb (GnomeFileEntry *fileentry,
  					BookmarksEditorControls *controls);
void bookmarks_editor_selection_received_cb (GtkWidget *widget, 
					     GtkSelectionData *selection_data,
					     guint time);
void bookmarks_dock_close_clicked_cb (GtkWidget *button, 
				      BookmarksEditorControls *controls);
void bookmarks_dock_destroy_cb (GtkWidget *dialog, 
				BookmarksEditorControls *controls);
void bookmarks_dock_detach_button_clicked_cb (GtkButton *button,
					      BookmarksEditorControls *controls);					      
gboolean bookmarks_editor_toolbar_button_press_event_cb (GtkWidget *tb_event_box,
							 GdkEventButton *event,
							 BookmarksEditorControls *controls);
void bookmarks_editor_save_as_clicked_cb (GtkWidget *widget,
					  BookmarksEditorControls *controls);
void bookmarks_editor_open_clicked_cb (GtkWidget *widget, 
				       BookmarksEditorControls *controls);
void
bookmarks_editor_sort_norec_clicked_cb (GtkWidget *widget, 
					BookmarksEditorControls *controls);
void
bookmarks_editor_sort_rec_clicked_cb (GtkWidget *widget, 
				      BookmarksEditorControls *controls);
void
bookmarks_editor_sort_ff_norec_clicked_cb (GtkWidget *widget, 
					BookmarksEditorControls *controls);
void
bookmarks_editor_sort_ff_rec_clicked_cb (GtkWidget *widget, 
				      BookmarksEditorControls *controls);
void bookmarks_dock_menu_button_clicked_cb (GtkButton *button,
					    BookmarksEditorControls *controls);
void bookmarks_editor_destroy_cb (GtkWidget *widget, 
				  BookmarksEditorControls *controls);
void bookmarks_dock_search_entry_activate_cb (GtkWidget *widget,
					    BookmarksEditorControls *controls);
void bookmarks_editor_find_bookmarks_cb (GtkWidget *widget,
					 BookmarksEditorControls *controls);
