/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <libgnome/gnome-help.h>

#include "nsIFactory.h"
#include "nsXPComFactory.h"
#include "nsIServiceManager.h"
#include "nsIIOService.h"
#include "nsNetCID.h"

#include "GHelpProtocolHandler.h"

static NS_DEFINE_CID(kIOServiceCID, NS_IOSERVICE_CID);

/* Implementation file */
NS_IMPL_ISUPPORTS1 (GGHelpProtocolHandler, nsIProtocolHandler)

/* nsIChannel newChannel (in nsIURI aURI); */
NS_IMETHODIMP GGHelpProtocolHandler::NewChannel(nsIURI *aURI,
						    nsIChannel **_retval)
{
	nsresult rv;
	mURI = aURI;

	nsXPIDLCString host;
	rv = aURI->GetHost (getter_Copies(host));
	if (NS_FAILED(rv)) return rv;

	nsXPIDLCString path;
	rv = aURI->GetPath (getter_Copies(path));
	if (NS_FAILED(rv)) return rv;

	mDocName = NS_LITERAL_CSTRING ("file:///"); 

	if (strstr(path.get(), ".html"))
	{
		mDocName += (host + path);
	}
	else
	{
		char *helpPath = gnome_help_file_find_file (
					const_cast<char *>(host.get()),
					"index.html");
		if (!helpPath) return NS_ERROR_FAILURE;
		mDocName += helpPath;
		g_free (helpPath);
	}

	nsCOMPtr<nsIIOService> ioService = do_GetService (kIOServiceCID, &rv);
	if (NS_FAILED(rv) || !ioService) return rv;

	rv = ioService->NewChannel(mDocName.get(), nsnull,
				   getter_AddRefs(mChannel));

	NS_IF_ADDREF (*_retval = mChannel);
	return rv;
}

#ifndef XPCOM_SHARED_LIB
NS_DEF_FACTORY (GGHelpProtocolHandler, GGHelpProtocolHandler);

/**
 * NS_NewGHelpProtocolHandlerFactory:
 */ 
nsresult NS_NewGHelpHandlerFactory(nsIFactory** aFactory)
{
	NS_ENSURE_ARG_POINTER(aFactory);
	*aFactory = nsnull;

	nsGGHelpProtocolHandlerFactory *result = 
					new nsGGHelpProtocolHandlerFactory;
	if (result == NULL)
	{
		return NS_ERROR_OUT_OF_MEMORY;
	}
    
	NS_ADDREF(result);
	*aFactory = result;

	return NS_OK;
}
#endif
////////////////////////////////////////////////////////////////////////////////

