/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"
#include "mozilla.h"
#include "GaleonWrapper.h"
#include <time.h>

/* type of drag and drop for links */
static const GtkTargetEntry link_drag_types[] =
{
        { "GALEON_URL",    0, DND_TARGET_GALEON_URL   },
        { "_NETSCAPE_URL", 0, DND_TARGET_NETSCAPE_URL },
        { "STRING",        0, DND_TARGET_STRING       }
};
static const gint link_drag_types_num_items = (sizeof (link_drag_types) / 
					       sizeof (GtkTargetEntry));
static GtkTargetList *link_drag_types_tl = NULL;

GaleonEventListener::GaleonEventListener(void)
{
	NS_INIT_REFCNT();
	wrapper = NULL;
}

GaleonEventListener::~GaleonEventListener(void)
{
}


NS_IMPL_ADDREF(GaleonEventListener)
NS_IMPL_RELEASE(GaleonEventListener)
NS_INTERFACE_MAP_BEGIN(GaleonEventListener)
  NS_INTERFACE_MAP_ENTRY_AMBIGUOUS(nsISupports, nsIDOMDragListener)
  NS_INTERFACE_MAP_ENTRY_AMBIGUOUS(nsIDOMEventListener, nsIDOMDragListener)
  NS_INTERFACE_MAP_ENTRY(nsIDOMDragListener)
NS_INTERFACE_MAP_END

void
GaleonEventListener::Init(GaleonWrapper *galeon_wrapper)
{
	wrapper = galeon_wrapper;
}

NS_IMETHODIMP
GaleonEventListener::HandleEvent(nsIDOMEvent* aEvent)
{
	return NS_OK;
}

NS_IMETHODIMP GaleonEventListener::DragEnter(nsIDOMEvent* aMouseEvent)
{
	return NS_OK;
}
NS_IMETHODIMP GaleonEventListener::DragExit(nsIDOMEvent* aMouseEvent)
{
	return NS_OK;
}
NS_IMETHODIMP GaleonEventListener::DragDrop(nsIDOMEvent* aMouseEvent)
{
	return NS_OK;
}
NS_IMETHODIMP GaleonEventListener::DragGesture(nsIDOMEvent* aMouseEvent)
{
	gchar *old_dragging_link;
	WrapperMouseEventInfo *info;
	gchar *url = NULL;

	info = g_new0 (WrapperMouseEventInfo,1);

	mozilla_get_mouse_event_info(wrapper->embed, aMouseEvent, info);


	if (info->ctx.context & CONTEXT_LINK)
	{
		url = info->ctx.link;
	}
	else if (info->ctx.context & CONTEXT_IMAGE)
	{	
		url = info->ctx.img;
	}
	
	if (url)
	{
		if (!link_drag_types_tl)
			link_drag_types_tl = gtk_target_list_new 
				(link_drag_types, link_drag_types_num_items);

		old_dragging_link = (gchar*)gtk_object_get_data (
					GTK_OBJECT (wrapper->mGtkMozEmbed),
					"dragging_link");
		if (old_dragging_link) g_free (old_dragging_link);
		gtk_object_set_data (GTK_OBJECT(wrapper->mGtkMozEmbed),
				     "dragging_link", g_strdup (url));


		GdkEvent gdk_event;
		gdk_event.type = GDK_BUTTON_PRESS;
		gdk_event.button.window = NULL;
		gdk_event.button.send_event = 0;
		gdk_event.button.time = time (NULL);
		gdk_event.button.x = 0;
		gdk_event.button.y = 0;
		gdk_event.button.pressure = 0;
		gdk_event.button.xtilt = 0;
		gdk_event.button.ytilt = 0;
		gdk_event.button.state = 0;
		gdk_event.button.button = 0;
		gdk_event.button.source = (GdkInputSource)0;
		gdk_event.button.deviceid = 0;
		gdk_event.button.x_root = 0;
		gdk_event.button.y_root = 0;

		gtk_drag_begin (GTK_WIDGET(wrapper->mGtkMozEmbed),
				link_drag_types_tl, 
				(GdkDragAction)(GDK_ACTION_COPY | 
						GDK_ACTION_LINK),
				1, &gdk_event);
	}

	mozilla_free_context_info_sub (&info->ctx);
	g_free (info);

	return NS_OK;
}

NS_IMETHODIMP GaleonEventListener::DragOver(nsIDOMEvent* aMouseEvent)
{
	return NS_OK;
}
