/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GALEON_WRAPPER_H
#define GALEON_WRAPPER_H

#include "nsIDocShell.h"
#include "nsIWebNavigation.h"
#include "nsISHistory.h"
#include "nsIWebBrowser.h"
#include "nsIWebProgressListener.h"
#include "nsCOMPtr.h"
#include "nsIDOMEventReceiver.h"
#include "nsIPrintOptions.h"
#include "nsPIDOMWindow.h"
#include <gtkmozembed.h>

#include "GaleonEventListener.h"

class GaleonWrapper
{
public:
	GaleonWrapper();
	~GaleonWrapper();

	nsresult Init (GaleonEmbed *galeon_embed);
	nsresult Destroy (void);
	nsresult AddListener (void);
	nsresult RemoveListener (void);
	nsresult AddEventListener (void);
	nsresult RemoveEventListener (void);

	nsresult SetZoom (float aTextZoom);
	nsresult GetZoom (float *aTextZoom);

	nsresult SaveURI (const char *url, char *filename, int action);
	nsresult SaveLink (const char *url);
	nsresult SaveDocument (char *filename, const char *datapath,
			       int action, PRBool mainDoc);

	nsresult Print (nsIPrintOptions *options, PRBool preview);

	nsresult Find (const PRUnichar *search_string, PRBool matchcase,
		       PRBool search_backwards, PRBool search_wrap_around,
		       PRBool search_for_entire_word, PRBool search_in_frames,
		       PRBool *didFind);

	nsresult GetMainDocumentUrl (char **url);
	nsresult GetDocumentUrl (char **url);

	nsresult ReloadDocument ();

	nsresult GetSHInfo (PRInt32 *count, PRInt32 *index);
	nsresult GetSHTitleAtIndex (PRInt32 index, PRUnichar **title);
	nsresult GetSHUrlAtIndex (PRInt32 index, char **url);

	nsresult CopyHistoryTo (GaleonWrapper *embed);

	nsresult GoToHistoryIndex (PRInt16 index);

	nsresult SetSitePermission( PRBool permission, PRInt32 type );

	nsresult ForceCharacterSet (char *charset);

	nsresult GetFaviconURL (char **favicon_url);
	
	nsresult SetOffline(PRBool aOffline);

	nsresult CanCutSelection(PRBool *result);

	nsresult CanCopySelection(PRBool *result);

	nsresult CanPaste(PRBool *result);

	nsresult CutSelection(void);

	nsresult CopySelection(void);

	nsresult Paste(void);

	nsresult Activate ();
	nsresult Deactivate ();

	nsresult GetStyleSheets (nsIDOMStyleSheetList **list);

	nsresult GetMainDOMDocument (nsIDOMDocument **aDOMDocument);

	nsresult LoadOverrideStyleSheet (char *css,
					 nsIStyleSheet **return_sheet);
	nsresult RemoveOverrideStyleSheet (nsIStyleSheet *remove);

	nsCOMPtr<nsIWebBrowser>           mWebBrowser;

	nsCOMPtr<GaleonEventListener> mEventListener;
        nsCOMPtr<nsIDOMEventReceiver> mEventReceiver;

	nsCOMPtr<nsIWebNavigation>        mChromeNav;

	GtkMozEmbed *mGtkMozEmbed;
	GaleonEmbed *embed;

private:
	nsresult GetDocShell (nsIDocShell **aDocShell);
	nsresult GetCSSBackground (nsIDOMNode *node, nsAutoString& url);
	nsresult GetDOMWindow (nsIDOMWindow **aDOMWindow);
	nsresult GetMainDOMWindow (nsIDOMWindow **aDOMWindow);
	nsresult GetDOMDocument (nsIDOMDocument **aDOMDocument);
	nsresult GetSHistory (nsISHistory **aSHistory);
	nsresult GetPIDOMWindow(nsPIDOMWindow **aPIWin);
	nsCOMPtr<nsIWebProgressListener> mProgress;
};

#endif
