/* ***** BEGIN LICENSE BLOCK *****
 * Version: NPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * New code Copyright (C) 2001 Philip Langdale
 *
 * This code is based on Original Code from nsISimpleURI.cpp
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Pierre Phaneuf <pp@ludusdesign.com>
 *   Gagan Saksena <gagan@netscape.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "mozilla_version.h"

#include "gGnomeHelpUrl.h"
#include "gNplCID.h"
#include "nscore.h"
#include "nsCRT.h"
#include "nsString.h"
#include "nsURLHelper.h"
#include "prmem.h"
#include "prprf.h"
#include "nsNetCID.h"
#include "nsIObjectInputStream.h"
#include "nsIObjectOutputStream.h"
#if MOZILLA_VERSION > VERSION3(0,9,4)
#include "nsReadableUtils.h"
#else
#include "mozilla/gStringHelper.h"
#endif

static NS_DEFINE_CID(kGnomeHelpURLCID, G_GNOMEHELPURL_CID);
static NS_DEFINE_CID(kThisSimpleURIImplementationCID,
                     NS_THIS_SIMPLEURI_IMPLEMENTATION_CID);

static NS_DEFINE_IID(kISupportsIID, NS_ISUPPORTS_IID);

////////////////////////////////////////////////////////////////////////////////
// gGnomeHelpUrl methods:

gGnomeHelpUrl::gGnomeHelpUrl(nsISupports* outer)
    : mScheme(nsnull), mPath(nsnull), mFilePath(nsnull), mQuery(nsnull), mRef(nsnull)
{
    NS_INIT_AGGREGATED(outer);
}

gGnomeHelpUrl::~gGnomeHelpUrl()
{
    if (mScheme) nsCRT::free(mScheme);
    if (mPath)   nsCRT::free(mPath);
    if (mFilePath) nsCRT::free(mFilePath);
    if (mQuery)  nsCRT::free(mQuery);
    if (mRef)    nsCRT::free(mRef);
}

NS_IMPL_AGGREGATED(gGnomeHelpUrl);

NS_IMETHODIMP
gGnomeHelpUrl::AggregatedQueryInterface(const nsIID& aIID, void** aInstancePtr)
{
    NS_ENSURE_ARG_POINTER(aInstancePtr);

    if (aIID.Equals(kISupportsIID)) {
        *aInstancePtr = GetInner();
    } else if (aIID.Equals(kThisSimpleURIImplementationCID) || // used by Equals
               aIID.Equals(NS_GET_IID(nsIURI))) {
        *aInstancePtr = NS_STATIC_CAST(nsIURI*, this);
    } else if (aIID.Equals(NS_GET_IID(nsISerializable))) {
        *aInstancePtr = NS_STATIC_CAST(nsISerializable*, this);
    } else if (aIID.Equals(NS_GET_IID(nsIURL))) {
        *aInstancePtr = NS_STATIC_CAST(nsIURL*, this);
    } else {
        *aInstancePtr = nsnull;
        return NS_NOINTERFACE;
    }
    NS_ADDREF((nsISupports*)*aInstancePtr);
    return NS_OK;
}

////////////////////////////////////////////////////////////////////////////////
// nsISerializable methods:

NS_IMETHODIMP
gGnomeHelpUrl::Read(nsIObjectInputStream* aStream)
{
    nsresult rv;

    rv = aStream->ReadStringZ(&mScheme);
    if (NS_FAILED(rv)) return rv;

    rv = aStream->ReadStringZ(&mPath);
    if (NS_FAILED(rv)) return rv;

    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::Write(nsIObjectOutputStream* aStream)
{
    nsresult rv;

    rv = aStream->WriteStringZ(mScheme);
    if (NS_FAILED(rv)) return rv;

    rv = aStream->WriteStringZ(mPath);
    if (NS_FAILED(rv)) return rv;

    return NS_OK;
}

////////////////////////////////////////////////////////////////////////////////
// nsIURI methods:

NS_IMETHODIMP
gGnomeHelpUrl::GetSpec(char* *result)
{
    nsAutoString string;
//    NS_LOCK_INSTANCE();

      // STRING USE WARNING: perhaps |string| should be |nsCAutoString|? -- scc
    string.AssignWithConversion(mScheme);
    string.AppendWithConversion(':');
    string.AppendWithConversion(mPath);

//    NS_UNLOCK_INSTANCE();
    *result = ToNewCString(string);
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetSpec(const char* aSpec)
{
    nsAutoString spec;
    spec.AssignWithConversion(aSpec);

    PRInt32 posSpec = spec.Find(":");
    if (posSpec == -1)
        return NS_ERROR_FAILURE;
    nsAutoString scheme;
    PRInt32 n = spec.Left(scheme, posSpec);
    NS_ASSERTION(n == posSpec, "Left failed");

    nsAutoString fullPath;
    PRInt32 end = spec.Length() - posSpec - 1;
    n = spec.Mid(fullPath, posSpec + 1, end);
    NS_ASSERTION(n == end, "Mid failed");

    PRInt32 posQuery = fullPath.Find("?");
    PRInt32 posRef = fullPath.Find("#");
    nsString path, query, ref;
    if (posQuery != -1 && posRef == -1)
    {
        n = fullPath.Left(path, posQuery);
	NS_ASSERTION(n == posQuery, "Left failed");
	end = fullPath.Length() - posQuery - 1;
	n = fullPath.Mid(query, posQuery +1, end);
        NS_ASSERTION(n == end, "Mid failed");
    }
    else if (posRef != -1 && posQuery == -1)
    {
        n = fullPath.Left(path, posRef);
	NS_ASSERTION(n == posRef, "Left failed");
	end = fullPath.Length() - posRef - 1;
	n = fullPath.Mid(ref, posRef +1, end);
        NS_ASSERTION(n == end, "Mid failed");
    }
    else if (posRef != -1 && posQuery != -1)
    {
        n = fullPath.Left(path, posQuery);
	NS_ASSERTION(n == posQuery, "Left failed");
	end = posRef -posQuery -1;
        n = fullPath.Mid(query, posQuery +1, end);
	NS_ASSERTION(n == end, "Mid failed");
	end = fullPath.Length() - posRef - 1;
	n = fullPath.Mid(ref, posRef +1, end);
        NS_ASSERTION(n == end, "Mid failed");
    }
    else
    {
        path = fullPath;
    }

    if(mScheme)
        nsCRT::free(mScheme);
    mScheme = ToNewCString(scheme);
    if(mPath)
        nsCRT::free(mPath);
    mPath = ToNewCString(fullPath);
    if(mFilePath)
        nsCRT::free(mFilePath);        
    mFilePath = ToNewCString(path);
    if(mQuery)
        nsCRT::free(mQuery);
    mQuery = ToNewCString(query);
    if(mRef)
        nsCRT::free(mRef);
    mRef = ToNewCString(ref);

    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetScheme(char* *result)
{
    *result = nsCRT::strdup(mScheme);
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetScheme(const char* scheme)
{
    if (mScheme) nsCRT::free(mScheme);
    mScheme = nsCRT::strdup(scheme);
    ToLowerCase(mScheme);
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetPrePath(char* *result)
{
    nsCAutoString prePath(mScheme);
    prePath += ":";
    *result = ToNewCString(prePath);
    return *result ? NS_OK : NS_ERROR_OUT_OF_MEMORY;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetPrePath(const char* scheme)
{
    NS_NOTREACHED("gGnomeHelpUrl::SetPrePath");
    return NS_ERROR_NOT_IMPLEMENTED; 
}

NS_IMETHODIMP
gGnomeHelpUrl::GetPreHost(char* *result)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetPreHost(const char* preHost)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetUsername(char* *result)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetUsername(const char* userName)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetPassword(char* *result)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetPassword(const char* password)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetHost(char* *result)
{
    nsCAutoString filePath(mFilePath);
    nsCAutoString host;
    PRInt32 posSlash = filePath.Find("/");
    PRInt32 n = filePath.Left(host, posSlash);
    NS_ASSERTION(n == posSlash, "Left failed");
    *result = ToNewCString(host);
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetHost(const char* host)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetPort(PRInt32 *result)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetPort(PRInt32 port)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetPath(char* *result)
{
    *result = nsCRT::strdup(mPath);
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetPath(const char* path)
{
    if (mPath) nsCRT::free(mPath);
    mPath = nsCRT::strdup(path);
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::Equals(nsIURI* other, PRBool *result)
{
    PRBool eq = PR_FALSE;
    if (other) {
//        NS_LOCK_INSTANCE();
        gGnomeHelpUrl* otherUrl;
        nsresult rv =
            other->QueryInterface(kThisSimpleURIImplementationCID,
                                  (void**)&otherUrl);
        if (NS_SUCCEEDED(rv)) {
            eq = PRBool((0 == PL_strcmp(mScheme, otherUrl->mScheme)) && 
                        (0 == PL_strcmp(mPath, otherUrl->mPath)));
            NS_RELEASE(otherUrl);
        }
//        NS_UNLOCK_INSTANCE();
    }
    *result = eq;
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::SchemeIs(const char *i_Scheme, PRBool *o_Equals)
{
    NS_ENSURE_ARG_POINTER(o_Equals);
    if (!i_Scheme) return NS_ERROR_NULL_POINTER;

    // mScheme is guaranteed to be lower case.
    if (*i_Scheme == *mScheme || *i_Scheme == (*mScheme - ('a' - 'A')) ) {
        *o_Equals = PL_strcasecmp(mScheme, i_Scheme) ? PR_FALSE : PR_TRUE;
    } else {
        *o_Equals = PR_FALSE;
    }

    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::Clone(nsIURI* *result)
{
    gGnomeHelpUrl* url = new gGnomeHelpUrl(nsnull);     // XXX outer?
    if (url == nsnull)
        return NS_ERROR_OUT_OF_MEMORY;
    url->mScheme = nsCRT::strdup(mScheme);
    if (url->mScheme == nsnull)
        return NS_ERROR_OUT_OF_MEMORY;
    url->mPath = nsCRT::strdup(mPath);
    if (url->mPath == nsnull)
        return NS_ERROR_OUT_OF_MEMORY;
    *result = url;
    NS_ADDREF(url);
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::Resolve(const char *relativePath, char **result) 
{
    return DupString(result,(char*)relativePath);
}

////////////////////////////////////////////////////////////////////////////////

NS_METHOD
gGnomeHelpUrl::Create(nsISupports *aOuter, REFNSIID aIID, void **aResult)
{
    NS_ENSURE_ARG_POINTER(aResult);
     NS_ENSURE_PROPER_AGGREGATION(aOuter, aIID);

    gGnomeHelpUrl* url = new gGnomeHelpUrl(aOuter);
    if (url == nsnull)
        return NS_ERROR_OUT_OF_MEMORY;

    nsresult rv = url->AggregatedQueryInterface(aIID, aResult);

     if (NS_FAILED(rv))
         delete url;
    return rv;
}

////////////////////////////////////////////////////////////////////////////////
// nsIURL methods:

/* attribute string filePath; */
NS_IMETHODIMP gGnomeHelpUrl::GetFilePath(char * *result)
{
    *result = nsCRT::strdup(mFilePath);
    return NS_OK;
}
NS_IMETHODIMP gGnomeHelpUrl::SetFilePath(const char * aFilePath)
{
    if (mFilePath) nsCRT::free(mFilePath);
    mFilePath = nsCRT::strdup(aFilePath);
    return NS_OK;
}

/* attribute string param; */
NS_IMETHODIMP gGnomeHelpUrl::GetParam(char * *result)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP gGnomeHelpUrl::SetParam(const char * aParam)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string query; */
NS_IMETHODIMP gGnomeHelpUrl::GetQuery(char * *result)
{
    *result = nsCRT::strdup(mQuery);
    return NS_OK;
}
NS_IMETHODIMP gGnomeHelpUrl::SetQuery(const char * aQuery)
{
    if (mQuery) nsCRT::free(mQuery);
    mQuery = nsCRT::strdup(aQuery);
    return NS_OK;
}

/* attribute string ref; */
NS_IMETHODIMP gGnomeHelpUrl::GetRef(char * *result)
{
    *result = nsCRT::strdup(mRef);
    return NS_OK;
}
NS_IMETHODIMP gGnomeHelpUrl::SetRef(const char * aRef)
{
    if (mRef) nsCRT::free(mRef);
    mRef = nsCRT::strdup(aRef);
    return NS_OK;
}

/* attribute string directory; */
NS_IMETHODIMP gGnomeHelpUrl::GetDirectory(char * *result)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP gGnomeHelpUrl::SetDirectory(const char * aDirectory)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string fileName; */
NS_IMETHODIMP gGnomeHelpUrl::GetFileName(char * *result)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP gGnomeHelpUrl::SetFileName(const char * aFileName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string fileBaseName; */
NS_IMETHODIMP gGnomeHelpUrl::GetFileBaseName(char * *result)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP gGnomeHelpUrl::SetFileBaseName(const char * aFileBaseName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string fileExtension; */
NS_IMETHODIMP gGnomeHelpUrl::GetFileExtension(char * *result)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP gGnomeHelpUrl::SetFileExtension(const char * aFileExtension)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string escapedQuery; */
NS_IMETHODIMP gGnomeHelpUrl::GetEscapedQuery(char * *result)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

////////////////////////////////////////////////////////////////////////////////

