/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"

#include "nsCOMPtr.h"
#include "nsXPIDLString.h"
#include "nsIFactory.h"
#include "nsXPComFactory.h"
#include "nsIComponentManager.h"
#include "nsIURI.h"
#include "nsIURL.h"
#include "nsIChannel.h"
#include "nsIStorageStream.h"
#include "nsIInputStream.h"
#include "nsNetCID.h"
#include "nsNetUtil.h"

#include "ExternalProtocolService.h"
#include "BaseProtocolContentHandler.h"

static NS_DEFINE_CID(kSimpleURICID,     NS_SIMPLEURI_CID);

/* Implementation file */
NS_IMPL_ISUPPORTS2 (GBaseProtocolContentHandler, nsIProtocolHandler, nsIContentHandler)

GBaseProtocolContentHandler::GBaseProtocolContentHandler(const char *aScheme) :
		      GBaseProtocolHandler(aScheme)
{
	NS_INIT_ISUPPORTS();
	/* member initializers and constructor code */
	mMimeType = NS_LITERAL_CSTRING("application-x-gnome-") + mScheme;
}

GBaseProtocolContentHandler::~GBaseProtocolContentHandler()
{
	/* destructor code */
}

/* nsIChannel newChannel (in nsIURI aURI); */
NS_IMETHODIMP GBaseProtocolContentHandler::NewChannel(nsIURI *aURI,
						      nsIChannel **_retval)
{
	nsCOMPtr<nsIStorageStream> sStream;
	nsresult rv = NS_NewStorageStream(1, 0, getter_AddRefs(sStream));
	if (NS_FAILED(rv)) return rv;

	nsCOMPtr<nsIInputStream> iStream;
	rv = sStream->NewInputStream(0, getter_AddRefs(iStream));
	if (NS_FAILED(rv)) return rv;

	nsCOMPtr<nsIChannel> aChannel;
	rv = NS_NewInputStreamChannel(getter_AddRefs(aChannel), aURI,
				      iStream, mMimeType.get(), 0);
	if (NS_FAILED(rv)) return rv;

	NS_IF_ADDREF (*_retval = aChannel);
	return rv;
}

NS_IMETHODIMP GBaseProtocolContentHandler::HandleContent (
					const char * aContentType,
					const char * aCommand,
					nsISupports * aWindowContext,
					nsIRequest *aRequest)
{
	nsresult rv = NS_OK;
	if (!aRequest)
		return NS_ERROR_NULL_POINTER;
  	// First of all, get the content type and make sure it is a 
  	// content type we know how to handle!
	if (nsCRT::strcasecmp(aContentType, mMimeType.get()) == 0)
	{
		nsCOMPtr<nsIChannel> aChannel = do_QueryInterface(aRequest);
		if(!aChannel) return NS_ERROR_FAILURE;

		nsCOMPtr<nsIURI> aUri;
		rv = aChannel->GetURI(getter_AddRefs(aUri));
		if (NS_FAILED(rv)) return rv;

		aRequest->Cancel(NS_BINDING_ABORTED);
		if (aUri)
		{
			GExternalProtocolService *pS = 
						new GExternalProtocolService;
			pS->LoadUrl (aUri);
			delete pS;
		}
	}
	return rv;
}
