/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "nsCOMPtr.h"
#include "nsIFactory.h"
#include "nsIURI.h"
#include "PersistProgress.h"
#include "glib.h"
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-exec.h>

/* FIXME duplicate from mozilla.h */
#define ACTION_NONE 0
#define ACTION_VIEWSOURCE 1
#define ACTION_SETBACKGROUND 2 

extern "C" void launch_external_viewer (const char *filename);

NS_IMPL_ISUPPORTS1 (PersistProgress, nsIWebBrowserPersistProgress)

/**
 * PersistProgress::PersistProgress: constructor
 */
PersistProgress::PersistProgress ()
{
	NS_INIT_REFCNT();
}

/**
 * PersistProgress::PersistProgress: constructor
 */
PersistProgress::PersistProgress (char *Filename, int Action)
{
	PersistProgress ();
	mFilename = g_strdup (Filename);
	mAction = Action;
}

/**
 * PersistProgress::~PersistProgress: destructor
 */
PersistProgress::~PersistProgress ()
{
}

/* void OnProgress (in unsigned long aStatus, in nsIURI aURI, out boolean aAbort); */
NS_IMETHODIMP PersistProgress::OnProgress(PRUint32 aStatus, nsIURI *aURI, PRBool *aAbort)
{
	if (aStatus == PROGRESS_FINISHED)
	{
		switch (mAction)
		{
		case ACTION_VIEWSOURCE:
			launch_external_viewer (mFilename);
			break;
		case ACTION_SETBACKGROUND:
			gchar *command;

			/* build command */
			command = g_strconcat ("background-properties-capplet "
					       "--init-session-settings --ignore "
					       "--background-image=",
					       mFilename, NULL);

			/* execute it synchronously */
			gnome_execute_shell (NULL, command);

			/* free */
			g_free (command);
			g_free (mFilename);
			break;
		}
	}
	return NS_OK;
}
