/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"
#include "menubar.h"
#include "bookmarks.h"

#include <libgnomeui/gnome-stock.h>
#include <libgnome/gnome-i18n.h>
#include <gdk/gdkkeysyms.h>

/* 
 * a nonsense needed to get some of the GNOMEUINFO defined strings translated 
 * blame xgettext 
 */
#if 0
static char *ugh[] = {
	/* File */
		N_("_Open..."), N_("Open a file"),
		N_("E_xit"), N_("Exit the program"),
	/* Edit */
		N_("C_ut"), N_("Cut the selection"),
		N_("_Copy"), N_("Copy the selection"),
		N_("_Paste"), N_("Paste the clipboard"),
	/* Settings */
		N_("_Preferences..."), N_("Configure the application"),
	/* Help */
		N_("_About..."), N_("About this application")
}
#endif

/* The menubar GnomeUIInfo structs */ 
GnomeUIInfo file_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_New window"), NULL,
	  window_menu_new_window_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
	  GDK_n, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("New _tab"), NULL,
	  window_menu_new_tab_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
	  GDK_T, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_MENU_OPEN_ITEM (window_menu_open_activate_cb, NULL),
	{ GNOME_APP_UI_ITEM, N_("Open _URL..."), N_("Open a new URL"),
	  window_menu_open_url_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
	  GDK_o, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("Save _As..."),
	  N_("Save the current page with a different name"),
	  window_menu_save_as_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE_AS,
	  GDK_S, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_Print..."), NULL,
	  window_menu_print_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PRINT,
	  GDK_P, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_TOGGLEITEM, N_("Work O_ffline"), NULL,
	  window_menu_offline_mode_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Sa_ve session as..."),
	  N_("Save the location of each open window to a file"),
	  window_menu_save_session_as_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Op_en session..."),
	  N_("Restore a previous browsing session from a file"),
	  window_menu_open_session_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_Close"), N_("Close the current browser"),
	  window_menu_close_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
	  GDK_w, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("Exit with _session"),
	  N_("Exit the program, saving the location of each open window"),
	  window_menu_exit_with_session_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
	GNOMEUIINFO_MENU_EXIT_ITEM (window_menu_exit_activate_cb, NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo edit_menu_uiinfo[] =
{
	GNOMEUIINFO_MENU_CUT_ITEM (window_menu_edit_cut_cb, NULL),
	GNOMEUIINFO_MENU_COPY_ITEM (window_menu_edit_copy_cb, NULL),
	GNOMEUIINFO_MENU_PASTE_ITEM (window_menu_edit_paste_cb, NULL),

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, N_("_Find..."),
	  N_("Search for a word or phrase in the current page"),
	  window_menu_find_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SEARCH,
	  GDK_F, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo zoom_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_In"), NULL,
	  window_menu_zoom_in_activate_cb, NULL, NULL,
 	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_equal, GDK_CONTROL_MASK, NULL },
	  /* xgettext:no-c-format */
	{ GNOME_APP_UI_ITEM, N_("_100%"), NULL,
	  window_menu_zoom_100_activate_cb, NULL, NULL,
 	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_0, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Out"), NULL,
	  window_menu_zoom_out_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_minus, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo view_menu_uiinfo[] =
{
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Menubar"), NULL,
	  window_menu_menubar_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_M, GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Toolbar"), NULL,
	  window_menu_toolbar_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_T, GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Bookmarks toolbars"), NULL,
	  window_menu_bookmarks_toolbars_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_B, GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Statusbar"), NULL,
	  window_menu_statusbar_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_S, GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Full screen"), NULL,
	  window_menu_fullscreen_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_F11, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_SUBTREE, N_("_Zoom"), NULL,
	  zoom_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Encoding"), NULL,
	  NULL, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_Page source"), NULL,
	  window_menu_view_source_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_U, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo tab_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Detach tab"), NULL,
	  window_menu_detach_tab_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_I, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Move tab to another window"), NULL,
	  NULL, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_Previous tab"), NULL,
	  window_menu_prev_tab_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_UNDO,
	  GDK_comma, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Next tab"), NULL,
	  window_menu_next_tab_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REDO,
	  GDK_period, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Move tab _left / up"), NULL,
	  window_menu_shift_tab_left_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BACK, GDK_less,
	  GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("Move tab _right / down"), NULL,
	  window_menu_shift_tab_right_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_FORWARD, GDK_greater,
	  GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo load_images_always_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Always"), NULL,
	  window_menu_images_always_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("From _current server only"), NULL,
	  window_menu_images_current_server_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Never"), NULL,
	  window_menu_images_never_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo load_images_menu_uiinfo[] =
{
	{ GNOME_APP_UI_RADIOITEMS, NULL, NULL, load_images_always_uiinfo,
	  NULL, NULL, 0, NULL, 0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("A_llow images from this site"), NULL,
	  window_allow_images_from_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Block images from this site"), NULL,
	  window_block_images_from_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_View image sites..."), NULL,
	  window_view_image_sites_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo animate_always_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Continuously"), NULL,
	  window_menu_animate_always_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Once"), NULL,
	  window_menu_animate_once_through_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Never"), NULL,
	  window_menu_animate_never_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo animate_images_menu_uiinfo[] =
{
	{ GNOME_APP_UI_RADIOITEMS, NULL, NULL, animate_always_uiinfo,
	  NULL, NULL, 0, NULL, 0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo cookies_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("View _cookies..."), NULL,
	  window_view_cookies_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("View cookie _sites..."), NULL,
	  window_view_cookie_sites_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_Allow cookies from this site"), NULL,
	  window_allow_cookies_from_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Block cookies from this site"), NULL,
	  window_block_cookies_from_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo passwords_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("View _passwords..."), NULL,
	  window_view_passwords_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("View password _sites..."), NULL,
	  window_view_password_sites_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo settings_menu_uiinfo[] =
{
	{ GNOME_APP_UI_SUBTREE, N_("_Load images"),
	  N_("Display the images of the document"),
	  load_images_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_SUBTREE, N_("_Animate images"), NULL,
	  animate_images_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_TOGGLEITEM, N_("Use own _fonts"),
	  N_("Use own fonts instead of document provided fonts"),
	  window_menu_own_fonts_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Use own c_olors"),
	  N_("Use own colors instead of document provided colors"),
	  window_menu_own_colors_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Enable _Java"), NULL,
	  window_menu_enable_java_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Enable Java_Script"), NULL,
	  window_menu_enable_javascript_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
        { GNOME_APP_UI_TOGGLEITEM, N_("Enable pro_xy"), NULL,
          window_menu_enable_proxy_activate_cb, NULL, NULL,
          GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Auto-jump to new _tabs"), NULL,
	  window_menu_autojump_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
          0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_PREFERENCES_ITEM (window_menu_prefs_activate_cb, NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo bookmarks_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("Add _bookmark"), NULL,
	  window_menu_add_bookmark_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_D, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Add bookmark to"), NULL,
	  NULL, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_INDEX,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Edit bookmarks..."), NULL,
	  window_menu_bookmarks_edit_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_OPEN,
	  GDK_B, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_END
};

GnomeUIInfo go_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Back"), NULL,
	  window_menu_back_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BACK,
	  GDK_Left, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Forward"), NULL,
	  window_menu_forward_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_FORWARD,
	  GDK_Right, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Up"), NULL,
	  window_menu_up_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_UP,
	  GDK_Up, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Reload"), NULL,
	  window_menu_reload_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REFRESH,
	  GDK_r, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("H_ome page"), NULL,
	  window_menu_home_page_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_HOME,
	  GDK_Home, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Stop"), NULL,
	  window_menu_stop_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_STOP,
	  GDK_Escape, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_END
};

GnomeUIInfo tools_menu_uiinfo[] =
{
	{ GNOME_APP_UI_SUBTREE, N_("_Cookies"), NULL,
	  cookies_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_SUBTREE, N_("_Passwords"), NULL,
	  passwords_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_History..."),
	  N_("Log of visited pages"),
	  window_menu_history_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_H, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SEPARATOR, 
	{ GNOME_APP_UI_ITEM, N_("_Java Console..."),
	  N_("Show the Java Console"),
	  window_menu_show_java_console_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Javascript Console..."),
	  N_("Show the Javascript Console"),
	  window_menu_show_javascript_console_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR, 
	{ GNOME_APP_UI_ITEM, N_("_Rerun first time druid..."),
	  N_("Lets run the first time druid again"),
	  window_run_first_time_druid_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};	

GnomeUIInfo help_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Galeon manual"), NULL,
	  window_menu_help_manual_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_BLUE,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Galeon _homepage"), NULL,
	  window_menu_help_homepage_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_HOME,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Report a bug"), NULL,
	  window_menu_help_bugreport_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_MENU_ABOUT_ITEM (window_menu_help_about_activate_cb, NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo menubar_uiinfo[] =
{
	GNOMEUIINFO_SUBTREE (N_("_File"), file_menu_uiinfo),
	GNOMEUIINFO_SUBTREE (N_("_Edit"), edit_menu_uiinfo),
	GNOMEUIINFO_SUBTREE (N_("_View"), view_menu_uiinfo),
	GNOMEUIINFO_SUBTREE (N_("_Tab"), tab_menu_uiinfo),
	GNOMEUIINFO_SUBTREE (N_("_Settings"), settings_menu_uiinfo),
	GNOMEUIINFO_SUBTREE (N_("_Bookmarks"), bookmarks_menu_uiinfo),
	GNOMEUIINFO_SUBTREE (N_("_Go"), go_menu_uiinfo),
	GNOMEUIINFO_SUBTREE (N_("T_ools"), tools_menu_uiinfo),
	GNOMEUIINFO_SUBTREE (N_("_Help"), help_menu_uiinfo),
	GNOMEUIINFO_END
};

GnomeUIInfo *all_menus[] =
{
	file_menu_uiinfo,
	edit_menu_uiinfo,
	zoom_menu_uiinfo,
	view_menu_uiinfo,
	tab_menu_uiinfo,
	load_images_always_uiinfo,
	load_images_menu_uiinfo,
	animate_always_uiinfo,
	animate_images_menu_uiinfo,
	cookies_menu_uiinfo,
	passwords_menu_uiinfo,
	settings_menu_uiinfo,
	bookmarks_menu_uiinfo,
	go_menu_uiinfo,
	tools_menu_uiinfo,
	help_menu_uiinfo
};

gint menus_num_items[] =
{
	sizeof(file_menu_uiinfo)           / sizeof(GnomeUIInfo),
	sizeof(edit_menu_uiinfo)           / sizeof(GnomeUIInfo),
	sizeof(zoom_menu_uiinfo)           / sizeof(GnomeUIInfo),
	sizeof(view_menu_uiinfo)           / sizeof(GnomeUIInfo),
	sizeof(tab_menu_uiinfo)            / sizeof(GnomeUIInfo),
	sizeof(load_images_always_uiinfo)  / sizeof(GnomeUIInfo),
	sizeof(load_images_menu_uiinfo)    / sizeof(GnomeUIInfo),
	sizeof(animate_always_uiinfo)      / sizeof(GnomeUIInfo),
	sizeof(animate_images_menu_uiinfo) / sizeof(GnomeUIInfo),
	sizeof(cookies_menu_uiinfo)        / sizeof(GnomeUIInfo),
	sizeof(passwords_menu_uiinfo)	   / sizeof(GnomeUIInfo),
	sizeof(settings_menu_uiinfo)       / sizeof(GnomeUIInfo),
	sizeof(bookmarks_menu_uiinfo)      / sizeof(GnomeUIInfo),
	sizeof(go_menu_uiinfo)             / sizeof(GnomeUIInfo),
	sizeof(tools_menu_uiinfo)          / sizeof(GnomeUIInfo),
	sizeof(help_menu_uiinfo)           / sizeof(GnomeUIInfo)
};

gint num_menus = sizeof(all_menus) / sizeof(GnomeUIInfo *);

