/*
 *  Copyright (C) 2001 Matthew Mueller
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "state.h"
#include "prefs.h"

#include <stdlib.h>
#include <string.h>
#include <gtk/gtkpaned.h>
#include <gtk/gtkwindow.h>
#include <gtk/gtkclist.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-config.h>
#include <libgnome/gnome-util.h>
#include <libgnome/gnome-i18n.h>
#include <libgnomeui/gnome-dialog-util.h>
#include <libgnomeui/gnome-file-entry.h>


void
state_save_window_state (GdkWindow *window, const gchar *name)
{
	gint x, y, width, height;
	gchar *buf = NULL;

	gdk_window_get_root_origin (window, &x, &y);
	gdk_window_get_size (window, &width, &height);

	buf = g_strdup_printf (CONF_STATE_PATH"/%s/x",name);
	eel_gconf_set_integer (buf, x);
	g_free(buf);

	buf = g_strdup_printf (CONF_STATE_PATH"/%s/y",name);
	eel_gconf_set_integer (buf, y);
	g_free(buf);

	buf = g_strdup_printf (CONF_STATE_PATH"/%s/width",name);
        eel_gconf_set_integer (buf, width);
	g_free(buf);

	buf = g_strdup_printf (CONF_STATE_PATH"/%s/height",name);
	eel_gconf_set_integer (buf, height);
	g_free(buf);
}

void
state_load_window_state (GtkWidget *window, const gchar *name)
{
	gchar *buf;
	gint x, y, width, height;
	
	buf = g_strdup_printf (CONF_STATE_PATH"/%s/x",name);
	x = eel_gconf_get_integer (buf);
	g_free(buf);

	buf = g_strdup_printf (CONF_STATE_PATH"/%s/y",name);
	y = eel_gconf_get_integer (buf);
	g_free(buf);

	buf = g_strdup_printf (CONF_STATE_PATH"/%s/width",name);
        width = eel_gconf_get_integer (buf);
	g_free(buf);

	buf = g_strdup_printf (CONF_STATE_PATH"/%s/height",name);
	height = eel_gconf_get_integer (buf);
	g_free(buf);


	if (!(x == -1 && y == -1))
		gtk_widget_set_uposition (window, x, y);

	if (!(width == -1 && height == -1))
		gtk_window_set_default_size (GTK_WINDOW (window),
					     width, height);

}

void
state_save_column_widths (GtkWidget *w, const gchar *name)
{
	gint i;
	GtkCList *clist = GTK_CLIST (w);
	GString *cwidths = g_string_sized_new (32);
	

	gchar *buf = g_strdup_printf (CONF_STATE_PATH"/%s/cwidths", name);


	g_string_sprintf (cwidths, "%i", clist->column[0].width);
	for (i=1; i < clist->columns; i++)
	{
		g_string_sprintfa (cwidths, ",%i", clist->column[i].width);
	}
	
	eel_gconf_set_string (buf, cwidths->str);
	g_string_free (cwidths, TRUE);

	g_free (buf);
}

void
state_load_column_widths (GtkWidget *w, const gchar *name)
{
	int i;
	gchar *cwidths, *cp;

	gchar *buf = g_strdup_printf (CONF_STATE_PATH"/%s/cwidths", name);
	cp = cwidths = eel_gconf_get_string (buf);

	for (i=0; cp != NULL && *cp != '\0'; i++)
	{
		gtk_clist_set_column_width (GTK_CLIST (w), i, atoi(cp));
		cp = strchr (cp, ',');
		if (cp) cp++;
	}
	g_free (cwidths);
	g_free(buf);
}

void state_load_pane_pos (GtkWidget *pane, const gchar *name)
{
	if (pane != NULL)
	{
		gint pane_pos;
		gchar *buf = g_strdup_printf (CONF_STATE_PATH"/%s", name);
		pane_pos = eel_gconf_get_integer (buf);
		g_free (buf);

		if (pane_pos != -1)
			gtk_paned_set_position (GTK_PANED (pane), pane_pos);
	}
}

void state_save_pane_pos (GtkWidget *pane, const gchar *name)
{
	if (pane != NULL)
	{
		gchar *buf = g_strdup_printf (CONF_STATE_PATH"/%s", name);
		eel_gconf_set_integer (buf, GTK_PANED (pane)->child1_size);
		g_free (buf);
	}
}
