/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"

#define CONTEXT_MENU_ITEM(label, stock_id) \
 { GNOME_APP_UI_ITEM, label, NULL, NULL, NULL, NULL,  \
 GNOME_APP_PIXMAP_STOCK, stock_id, 0, 0, NULL}
#define CONTEXT_MENU_TOGGLEITEM(label, stock_id) \
 { GNOME_APP_UI_TOGGLEITEM, label, NULL, NULL, NULL, NULL, \
 GNOME_APP_PIXMAP_STOCK, stock_id, 0, 0, NULL}
 
static GnomeUIInfo contextual_link_menu_uiinfo[] =
{
  CONTEXT_MENU_ITEM(N_("Open"), GNOME_STOCK_MENU_OPEN),
  CONTEXT_MENU_ITEM(N_("Open in a new window"), GNOME_STOCK_MENU_NEW),
  CONTEXT_MENU_ITEM(N_("Download file"), GNOME_STOCK_MENU_SAVE),
  CONTEXT_MENU_ITEM(N_("Copy link location"), GNOME_STOCK_MENU_COPY),
  CONTEXT_MENU_ITEM(N_("Add temporary bookmark"), GNOME_STOCK_MENU_BLANK),
  GNOMEUIINFO_END
};

static GnomeUIInfo contextual_img_menu_uiinfo[] =
{
  CONTEXT_MENU_ITEM(N_("Open image"), GNOME_STOCK_MENU_OPEN),
  CONTEXT_MENU_ITEM(N_("Open image in a new window"), GNOME_STOCK_MENU_NEW),
  CONTEXT_MENU_ITEM(N_("Download image"), GNOME_STOCK_MENU_SAVE),
  CONTEXT_MENU_ITEM(N_("Copy image location"), GNOME_STOCK_MENU_COPY),
  GNOMEUIINFO_END
};

/* index of the "Full Screen View" item in contextual_doc_menu */
#define FULL_SCREEN_VIEW 7

static GnomeUIInfo contextual_doc_menu_uiinfo[] =
{
  CONTEXT_MENU_ITEM(N_("Back"), GNOME_STOCK_MENU_BACK),
  CONTEXT_MENU_ITEM(N_("Forward"), GNOME_STOCK_MENU_FORWARD),
  CONTEXT_MENU_ITEM(N_("Reload"), GNOME_STOCK_MENU_REFRESH),
  GNOMEUIINFO_SEPARATOR,
  CONTEXT_MENU_ITEM(N_("View Source"), GNOME_STOCK_MENU_BLANK),
  CONTEXT_MENU_ITEM(N_("Save "), GNOME_STOCK_MENU_SAVE),
  CONTEXT_MENU_ITEM(N_("Find"), GNOME_STOCK_MENU_SEARCH),
  CONTEXT_MENU_TOGGLEITEM(N_("Full Screen View"), GNOME_STOCK_MENU_BLANK),
  CONTEXT_MENU_ITEM(N_("Add temporary bookmark"), GNOME_STOCK_MENU_BLANK),
  GNOMEUIINFO_SEPARATOR,
  CONTEXT_MENU_ITEM(N_("Open frame in window"), GNOME_STOCK_MENU_OPEN),
  CONTEXT_MENU_ITEM(N_("Open frame in new window"), GNOME_STOCK_MENU_OPEN),
  CONTEXT_MENU_ITEM(N_("Reload frame"), GNOME_STOCK_MENU_REFRESH),
  CONTEXT_MENU_ITEM(N_("Copy frame location"), GNOME_STOCK_MENU_COPY),
  CONTEXT_MENU_ITEM(N_("Add temporary bookmark for frame"), GNOME_STOCK_MENU_BLANK),
  GNOMEUIINFO_END
};

/* This positions are used later to set the sensitiviness of the menu entries */
#define CONTEXTUAL_DOC_MENU_GO_BACK_POS 0
#define CONTEXTUAL_DOC_MENU_GO_FORWARD_POS 1

static GnomeUIInfo contextual_minimal_doc_menu_uiinfo[] =
{
  CONTEXT_MENU_ITEM(N_("View Source"), GNOME_STOCK_MENU_BLANK),
  CONTEXT_MENU_ITEM(N_("Save "), GNOME_STOCK_MENU_SAVE),
  CONTEXT_MENU_ITEM(N_("Find"), GNOME_STOCK_MENU_SEARCH),
  CONTEXT_MENU_ITEM(N_("Add temporary bookmark"), GNOME_STOCK_MENU_BLANK),
  GNOMEUIINFO_END
};
static GnomeUIInfo contextual_link_img_menu_uiinfo[] =
{
  CONTEXT_MENU_ITEM(N_("Open image"), GNOME_STOCK_MENU_OPEN),
  CONTEXT_MENU_ITEM(N_("Open image in a new window"), GNOME_STOCK_MENU_NEW),
  CONTEXT_MENU_ITEM(N_("Download image"), GNOME_STOCK_MENU_SAVE),
  CONTEXT_MENU_ITEM(N_("Copy image location"), GNOME_STOCK_MENU_COPY),
  GNOMEUIINFO_SEPARATOR,
  CONTEXT_MENU_ITEM(N_("Open"), GNOME_STOCK_MENU_OPEN),
  CONTEXT_MENU_ITEM(N_("Open in a new window"), GNOME_STOCK_MENU_NEW),
  CONTEXT_MENU_ITEM(N_("Download file"), GNOME_STOCK_MENU_SAVE),
  CONTEXT_MENU_ITEM(N_("Copy link location"), GNOME_STOCK_MENU_COPY),
  CONTEXT_MENU_ITEM(N_("Add temporary bookmark"), GNOME_STOCK_MENU_BLANK),
  GNOMEUIINFO_END
};

/**
 * context_show_link_menu: show a popup menu when a link is clicked
 **/
void context_show_link_menu (GaleonBrowser *browser, char *href)
{
	int selected;
	GtkWidget *popup;

	popup = gnome_popup_menu_new (contextual_link_menu_uiinfo);
	selected = gnome_popup_menu_do_popup_modal (popup, NULL, NULL,
							    NULL , NULL);

	switch (selected) {
	case 0: /* open */
		browser_load_url(browser, href);
		break;
	case 1: /* open in new window */
		browser_create_from_url (href);
		break;	
	case 2: /* save */
		save_url (href);
		break;
	case 3: /* copy link */
		copy_to_clipboard (href, browser);
		break;
	case 4: /* add temp bookmark */
		add_temp_bookmark (SITE, NULL, href, NULL);
		break;
	default:
		break;
	}

	gtk_widget_destroy(popup);
}

/**
 * context_show_doc_menu: show a popup menu when a document is clicked
 **/
void context_show_doc_menu (GaleonBrowser *browser, gpointer target)
{
    	int selected;
	GtkWidget *popup;
	gchar *name, *url;
	gboolean can_go_back, can_go_forward;
	GtkMenu *menu_back,*menu_forward;

	popup = gnome_popup_menu_new (contextual_doc_menu_uiinfo);

	/* sync the state of the fullscreen checkbox to the "View" menu */
	if (GTK_CHECK_MENU_ITEM(browser->view_fullscreen)->active)
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(
			contextual_doc_menu_uiinfo[FULL_SCREEN_VIEW].widget),
			TRUE);
	else
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(
	                contextual_doc_menu_uiinfo[FULL_SCREEN_VIEW].widget),
		  	FALSE);
	
	/* query mozilla */
	can_go_back = gtk_moz_embed_can_go_back (browser->mozEmbed);
	can_go_forward = gtk_moz_embed_can_go_forward (browser->mozEmbed);

	/* set widget status appropriately */
	gtk_widget_set_sensitive 
		(contextual_doc_menu_uiinfo[CONTEXTUAL_DOC_MENU_GO_BACK_POS].widget,
		 can_go_back);
	gtk_widget_set_sensitive 
		(contextual_doc_menu_uiinfo[CONTEXTUAL_DOC_MENU_GO_FORWARD_POS].widget,
		 can_go_forward);
	
	if (gnome_config_get_bool("/galeon/Mouse/history_popup=FALSE")) {
		if(can_go_back) {
			menu_back = create_back_menu(browser);
			gtk_signal_connect(GTK_OBJECT(menu_back), "selection-done",
					   (GtkSignalFunc)history_popup_selection_done_cb, popup);
			gnome_popup_menu_attach
				((GtkWidget*)menu_back,
				 contextual_doc_menu_uiinfo[CONTEXTUAL_DOC_MENU_GO_BACK_POS].widget,
				 NULL);
		}      
		if(can_go_forward) {
			menu_forward = create_forward_menu(browser);
			gtk_signal_connect(GTK_OBJECT(menu_forward),"selection-done",
					   (GtkSignalFunc)history_popup_selection_done_cb, popup);
			gnome_popup_menu_attach
				((GtkWidget*)menu_forward,
				 contextual_doc_menu_uiinfo[CONTEXTUAL_DOC_MENU_GO_FORWARD_POS].widget,
				 NULL);
		}	
	}
	selected = gnome_popup_menu_do_popup_modal (popup, NULL, NULL,
							    NULL , NULL);
	switch (selected) {
	case 0: /* back */
		gtk_moz_embed_go_back (browser->mozEmbed);
		break;
	case 1: /* forward */
		gtk_moz_embed_go_forward (browser->mozEmbed);
		break;
	case 2: /* reload */
		browser_reload (browser);
		break;
	case 4: /* view source */
		browser_view_source (browser, target);
		break;
	case 5: /* save */
		browser_show_save_dialog (browser, target);
		break;
	case 6: /* find */
		browser_show_find_dialog (browser, target);
		break;
	case 7: /* toggle full screen view */
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(browser->view_fullscreen),
				!(GTK_CHECK_MENU_ITEM(browser->view_fullscreen))->active);
		break;
	case 8: /* Add temp bookmark */
		name = g_strdup (gtk_moz_embed_get_title (browser->mozEmbed));
		url = gtk_editable_get_chars (GTK_EDITABLE (browser->toolbar_entry), 0, -1);
		if ( !name || strlen (name) == 0) {
			if (name) g_free (name);
			name = g_strdup (url);
		}
		add_temp_bookmark (SITE, name, url, NULL);
		g_free (url);
		g_free (name);
		break;
	case 10: /* open frame */
		browser_open_frame (browser, target, TRUE);
		break;
	case 11: /* open frame in new window */
		browser_open_frame (browser, target, FALSE);
		break;
	case 12: /* reload frame */
		mozilla_reload_docshell (browser, target);
		break;
	case 13: /* copy frame location */
		copy_to_clipboard (mozilla_get_eventtarget_url (browser, target), browser);
		break;
	case 14: /* add temp bookmark for frame */
		url = mozilla_get_eventtarget_url (browser, target);
		if (url) {
			add_temp_bookmark (SITE, NULL, url, NULL);
			g_free (url);
		}
		break;
	default:
		break;
	}

	gtk_widget_destroy(popup);
}

/**
 * context_show_doc_menu: show a popup menu when a document is clicked
 **/
void context_show_minimal_doc_menu (GaleonBrowser *browser, gpointer target)
{
    	int selected;
	GtkWidget *popup;
	gchar *name, *url;

	popup = gnome_popup_menu_new (contextual_minimal_doc_menu_uiinfo);
	selected = gnome_popup_menu_do_popup_modal (popup, NULL, NULL,
							    NULL , NULL);
	switch (selected) {
	case 0: /* view source */
		browser_view_source (browser, target);
		break;
	case 1: /* save */
		browser_show_save_dialog (browser, target);
		break;
	case 2: /* find */
		browser_show_find_dialog (browser, target);
		break;
	case 3: /* Add temp bookmark */
		name = g_strdup (gtk_moz_embed_get_title (browser->mozEmbed));
		url = gtk_editable_get_chars (GTK_EDITABLE (browser->toolbar_entry), 0, -1);
		if ( !name || strlen (name) == 0) {
			if (name) g_free (name);
			name = g_strdup (url);
		}
		add_temp_bookmark (SITE, name, url, NULL);
		g_free (url);
		g_free (name);
		break;
	default:
		break;
	}

	gtk_widget_destroy(popup);
}

/**
 * context_show_limg_menu: show a popup menu when an image is clicked
 **/
void context_show_img_menu (GaleonBrowser *browser, char *img)
{
	int selected;
	GtkWidget *popup;

	popup = gnome_popup_menu_new (contextual_img_menu_uiinfo);
	selected = gnome_popup_menu_do_popup_modal (popup, NULL, NULL,
						    NULL , NULL);

	switch (selected) {
	case 0: /* open image */
		browser_load_url(browser, img);
		break;
	case 1: /* open image in new window */
		browser_create_from_url (img);
		break;	
	case 2: /* save image */
		save_url (img);
		break;
	case 3: /* copy image location */
		copy_to_clipboard (g_strdup (img), browser);
		break;
	default:
		break;
	}

	gtk_widget_destroy(popup);
}

/**
 * context_show_link_menu: show a popup menu when a linked image is clicked
 **/
void context_show_link_img_menu (GaleonBrowser *browser, char *img, char *href)
{
	int selected;
	GtkWidget *popup;

	popup = gnome_popup_menu_new (contextual_link_img_menu_uiinfo);
	selected = gnome_popup_menu_do_popup_modal (popup, NULL, NULL,
							    NULL , NULL);

	switch (selected) {
	case 0: /* open image */
		browser_load_url(browser, img);
		break;
	case 1: /* open image in new window */
		browser_create_from_url (img);
		break;	
	case 2: /* save image */
		save_url (img);
		break;
	case 3: /* copy image location */
		copy_to_clipboard (img, browser);
		break;
	case 5: /* open */
		browser_load_url(browser, href);
		break;
	case 6: /* open in new window */
		browser_create_from_url (href);
		break;	
	case 7: /* save */
		save_url (href);
		break;
	case 8: /* copy link */
		copy_to_clipboard (href, browser);
		break;
	case 9: /* add temp bookmark */
		add_temp_bookmark (SITE, NULL, href, NULL);
		break;
	default:
		break;
	}

	gtk_widget_destroy(popup);
}

/**
 * context_show_bookmark_menu: show a bookmarks popup menu 
 **/
void
context_show_bookmark_menu (GaleonBrowser *browser) 
{
	GtkWidget *menu = gtk_menu_new();
	GtkTooltips *tips = gtk_tooltips_new ();
	bookmarks_create_menu_recursively (bookmarks_root, GTK_MENU (menu), NULL,
					   tips);
	/* warning: ugly code */
	gtk_object_set_data (GTK_OBJECT (menu), "widget_tree", 
			     glade_get_widget_tree (browser->WMain)); 
	gnome_popup_menu_do_popup_modal (menu, NULL, NULL,
					 NULL , NULL);
	gtk_widget_destroy (menu);
	gtk_object_destroy (GTK_OBJECT (tips));
}

