/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"

/**
 * spinner_create: create a spinner and add it to an hbox
 */
GtkWidget *
spinner_create (GtkWidget *hbox)
{
	GtkWidget *spinner_button;
	GtkWidget *spinner;
	int toolbar, size, i;
	gchar *anim_dir;

	/* set the size of the pixmap appropriately to whether 
	 * text is turned on in the toolbars, so it resizes okay */
	toolbar = gnome_config_get_int("/galeon/Appearance/toolbar_type=2");
	size = (toolbar == 2 ? 36 : 24);

	/* get the directory of the animations from configuration space,
 	 * default to installed share directory */
	anim_dir = gnome_config_get_string("/galeon/Appearance/spinner_dir="
					   SHARE_DIR);
	if (anim_dir == NULL || strlen(anim_dir) == 0)
	{
		anim_dir = g_strdup(SHARE_DIR);
	}
	
	/* FIXME Changing from big toolbar (Both) and small 
	 * (Icons or Text) it does not resize */

	/* build a button to hold the spinner */
	spinner_button = gtk_button_new();	
	gtk_button_set_relief (GTK_BUTTON(spinner_button), GTK_RELIEF_NONE);

	/* build the spinner and insert it into the button */
	spinner = gnome_animator_new_with_size(size, size);
	gtk_container_add(GTK_CONTAINER(spinner_button), spinner);

	/* should always loop continously when loading */
	gnome_animator_set_loop_type(GNOME_ANIMATOR(spinner),
				     GNOME_ANIMATOR_LOOP_RESTART);

	/* 256 is an arbitrary upper limit, in case something
	 * goes wrong with testing the existence of the files */
	for (i = 1; i < 256; i++)
	{
		gchar *filename;

		/* build the filename */
		filename = g_strdup_printf("%s/anim_%02d.png", anim_dir, i);

		/* test for the existence of the file */
		if ((g_file_exists(filename) & (G_FILE_TEST_ISFILE |
						G_FILE_TEST_ISLINK)) == 0)
		{
			/* free the string */
			g_free(filename);

			/* check if this is the first one and warn */
			if (i == 1)
			{
				g_warning("no frames of animation found in "
					  "directory `%s'", anim_dir);
				return NULL;
			}

			/* jump out of loading */
			break;
		}

		/* otherwise add it in */
		gnome_animator_append_frame_from_file_at_size
			(GNOME_ANIMATOR(spinner),
			 filename,    /* filename */
			 0, 0,        /* x_offset, y_offset */
			 100,         /* interval */
			 size, size); /* x_size, y_size */
 
		/* free allocated filename */
		g_free(filename);
	}

	/* add it to the hbox */
	gtk_box_pack_end (GTK_BOX(hbox), spinner_button, FALSE, FALSE, 1);

	/* show the spinner */
	gtk_widget_show(spinner_button);
	gtk_widget_show(spinner);

	/* free directory string */
	g_free(anim_dir);

	/* return the spinner */
	return spinner;
}
