// $Id: schema.h,v 1.3 2002/02/17 18:53:39 murrayc Exp $ -*- c++ -*-

/* schema.h
 *
 * Copyright (C) 2000-2002 GConfmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GCONFMM_SCHEMA_H
#define GCONFMM_SCHEMA_H

#include <gconfmm/value.h>

extern "C"
{
#include <gconf/gconf-schema.h>
}


namespace Gnome
{

namespace Conf
{


class Schema
{
public:
  Schema();
  explicit Schema(const GConfSchema* pSchema);
  Schema(const Schema& Schema);
  Schema::~Schema();

  Schema& operator=(const Schema& src);

  void set_type(GConfValueType  type);
  void set_list_type(GConfValueType  type);
  void set_car_type(GConfValueType  type);
  void set_cdr_type(GConfValueType  type);
  void set_locale(const std::string& locale);
  void set_short_desc(const Glib::ustring& desc);
  void set_long_desc(const Glib::ustring& desc);
  void set_owner(const Glib::ustring& owner);
  void set_default_value(const Value& val);
  //void set_default_value_nocopy(Value *val);

  GConfValueType get_type() const;
  GConfValueType get_list_type() const;
  GConfValueType get_car_type() const;
  GConfValueType get_cdr_type() const;
  std::string get_locale() const;
  Glib::ustring get_short_desc() const;
  Glib::ustring get_long_desc() const;
  Glib::ustring get_owner() const;
  Value get_default_value() const;


  GConfSchema* Schema::gobj();
  const GConfSchema* Schema::gobj() const;

protected:
  void clear();

  GConfSchema* m_pSchema;
};


} /* namespace Conf */
} /* namespace Gnome */

#endif //GCONFMM_SCHEMA_H
