/* gca-dbus.c generated by valac 0.20.1, the Vala compiler
 * generated from gca-dbus.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define GCA_DBUS_TYPE_OPEN_DOCUMENT (gca_dbus_open_document_get_type ())
typedef struct _GcaDBusOpenDocument GcaDBusOpenDocument;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GCA_DBUS_TYPE_REMOTE_DOCUMENT (gca_dbus_remote_document_get_type ())
typedef struct _GcaDBusRemoteDocument GcaDBusRemoteDocument;

#define GCA_DBUS_TYPE_SOURCE_LOCATION (gca_dbus_source_location_get_type ())
typedef struct _GcaDBusSourceLocation GcaDBusSourceLocation;

#define GCA_DBUS_TYPE_SOURCE_RANGE (gca_dbus_source_range_get_type ())
typedef struct _GcaDBusSourceRange GcaDBusSourceRange;

#define GCA_DBUS_TYPE_FIXIT (gca_dbus_fixit_get_type ())
typedef struct _GcaDBusFixit GcaDBusFixit;

#define GCA_DBUS_TYPE_DIAGNOSTIC (gca_dbus_diagnostic_get_type ())
typedef struct _GcaDBusDiagnostic GcaDBusDiagnostic;

#define GCA_DBUS_TYPE_INTROSPECTABLE (gca_dbus_introspectable_get_type ())
#define GCA_DBUS_INTROSPECTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_DBUS_TYPE_INTROSPECTABLE, GcaDBusIntrospectable))
#define GCA_DBUS_IS_INTROSPECTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_DBUS_TYPE_INTROSPECTABLE))
#define GCA_DBUS_INTROSPECTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_DBUS_TYPE_INTROSPECTABLE, GcaDBusIntrospectableIface))

typedef struct _GcaDBusIntrospectable GcaDBusIntrospectable;
typedef struct _GcaDBusIntrospectableIface GcaDBusIntrospectableIface;

#define GCA_DBUS_TYPE_INTROSPECTABLE_PROXY (gca_dbus_introspectable_proxy_get_type ())
typedef GDBusProxy GcaDBusIntrospectableProxy;
typedef GDBusProxyClass GcaDBusIntrospectableProxyClass;

#define GCA_DBUS_TYPE_SERVICE (gca_dbus_service_get_type ())
#define GCA_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_DBUS_TYPE_SERVICE, GcaDBusService))
#define GCA_DBUS_IS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_DBUS_TYPE_SERVICE))
#define GCA_DBUS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_DBUS_TYPE_SERVICE, GcaDBusServiceIface))

typedef struct _GcaDBusService GcaDBusService;
typedef struct _GcaDBusServiceIface GcaDBusServiceIface;

#define GCA_DBUS_TYPE_SERVICE_PROXY (gca_dbus_service_proxy_get_type ())
typedef GDBusProxy GcaDBusServiceProxy;
typedef GDBusProxyClass GcaDBusServiceProxyClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GCA_DBUS_TYPE_PROJECT (gca_dbus_project_get_type ())
#define GCA_DBUS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_DBUS_TYPE_PROJECT, GcaDBusProject))
#define GCA_DBUS_IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_DBUS_TYPE_PROJECT))
#define GCA_DBUS_PROJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_DBUS_TYPE_PROJECT, GcaDBusProjectIface))

typedef struct _GcaDBusProject GcaDBusProject;
typedef struct _GcaDBusProjectIface GcaDBusProjectIface;

#define GCA_DBUS_TYPE_PROJECT_PROXY (gca_dbus_project_proxy_get_type ())
typedef GDBusProxy GcaDBusProjectProxy;
typedef GDBusProxyClass GcaDBusProjectProxyClass;

#define GCA_DBUS_TYPE_DOCUMENT (gca_dbus_document_get_type ())
#define GCA_DBUS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_DBUS_TYPE_DOCUMENT, GcaDBusDocument))
#define GCA_DBUS_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_DBUS_TYPE_DOCUMENT))
#define GCA_DBUS_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_DBUS_TYPE_DOCUMENT, GcaDBusDocumentIface))

typedef struct _GcaDBusDocument GcaDBusDocument;
typedef struct _GcaDBusDocumentIface GcaDBusDocumentIface;

#define GCA_DBUS_TYPE_DOCUMENT_PROXY (gca_dbus_document_proxy_get_type ())
typedef GDBusProxy GcaDBusDocumentProxy;
typedef GDBusProxyClass GcaDBusDocumentProxyClass;

#define GCA_DBUS_TYPE_DIAGNOSTICS (gca_dbus_diagnostics_get_type ())
#define GCA_DBUS_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_DBUS_TYPE_DIAGNOSTICS, GcaDBusDiagnostics))
#define GCA_DBUS_IS_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_DBUS_TYPE_DIAGNOSTICS))
#define GCA_DBUS_DIAGNOSTICS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_DBUS_TYPE_DIAGNOSTICS, GcaDBusDiagnosticsIface))

typedef struct _GcaDBusDiagnostics GcaDBusDiagnostics;
typedef struct _GcaDBusDiagnosticsIface GcaDBusDiagnosticsIface;

#define GCA_DBUS_TYPE_DIAGNOSTICS_PROXY (gca_dbus_diagnostics_proxy_get_type ())
typedef GDBusProxy GcaDBusDiagnosticsProxy;
typedef GDBusProxyClass GcaDBusDiagnosticsProxyClass;

struct _GcaDBusOpenDocument {
	gchar* path;
	gchar* data_path;
};

struct _GcaDBusRemoteDocument {
	gchar* path;
	char* remote_path;
};

struct _GcaDBusSourceLocation {
	gint64 line;
	gint64 column;
};

struct _GcaDBusSourceRange {
	gint64 file;
	GcaDBusSourceLocation start;
	GcaDBusSourceLocation end;
};

struct _GcaDBusFixit {
	GcaDBusSourceRange location;
	gchar* replacement;
};

struct _GcaDBusDiagnostic {
	guint32 severity;
	GcaDBusFixit* fixits;
	gint fixits_length1;
	GcaDBusSourceRange* locations;
	gint locations_length1;
	gchar* message;
};

struct _GcaDBusIntrospectableIface {
	GTypeInterface parent_iface;
	void (*Introspect) (GcaDBusIntrospectable* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*Introspect_finish) (GcaDBusIntrospectable* self, GAsyncResult* _res_, GError** error);
};

struct _GcaDBusServiceIface {
	GTypeInterface parent_iface;
	void (*parse) (GcaDBusService* self, const gchar* path, const gchar* data_path, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char* (*parse_finish) (GcaDBusService* self, GAsyncResult* _res_, GError** error);
	void (*dispose) (GcaDBusService* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*dispose_finish) (GcaDBusService* self, GAsyncResult* _res_, GError** error);
};

struct _GcaDBusProjectIface {
	GTypeInterface parent_iface;
	void (*parse_all) (GcaDBusProject* self, const gchar* path, GcaDBusOpenDocument* documents, int documents_length1, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GcaDBusRemoteDocument* (*parse_all_finish) (GcaDBusProject* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

struct _GcaDBusDocumentIface {
	GTypeInterface parent_iface;
};

struct _GcaDBusDiagnosticsIface {
	GTypeInterface parent_iface;
	void (*diagnostics) (GcaDBusDiagnostics* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GcaDBusDiagnostic* (*diagnostics_finish) (GcaDBusDiagnostics* self, GAsyncResult* _res_, int* result_length1, GError** error);
};



GType gca_dbus_open_document_get_type (void) G_GNUC_CONST;
GcaDBusOpenDocument* gca_dbus_open_document_dup (const GcaDBusOpenDocument* self);
void gca_dbus_open_document_free (GcaDBusOpenDocument* self);
void gca_dbus_open_document_copy (const GcaDBusOpenDocument* self, GcaDBusOpenDocument* dest);
void gca_dbus_open_document_destroy (GcaDBusOpenDocument* self);
GType gca_dbus_remote_document_get_type (void) G_GNUC_CONST;
GcaDBusRemoteDocument* gca_dbus_remote_document_dup (const GcaDBusRemoteDocument* self);
void gca_dbus_remote_document_free (GcaDBusRemoteDocument* self);
void gca_dbus_remote_document_copy (const GcaDBusRemoteDocument* self, GcaDBusRemoteDocument* dest);
void gca_dbus_remote_document_destroy (GcaDBusRemoteDocument* self);
GType gca_dbus_source_location_get_type (void) G_GNUC_CONST;
GcaDBusSourceLocation* gca_dbus_source_location_dup (const GcaDBusSourceLocation* self);
void gca_dbus_source_location_free (GcaDBusSourceLocation* self);
GType gca_dbus_source_range_get_type (void) G_GNUC_CONST;
GcaDBusSourceRange* gca_dbus_source_range_dup (const GcaDBusSourceRange* self);
void gca_dbus_source_range_free (GcaDBusSourceRange* self);
GType gca_dbus_fixit_get_type (void) G_GNUC_CONST;
GcaDBusFixit* gca_dbus_fixit_dup (const GcaDBusFixit* self);
void gca_dbus_fixit_free (GcaDBusFixit* self);
void gca_dbus_fixit_copy (const GcaDBusFixit* self, GcaDBusFixit* dest);
void gca_dbus_fixit_destroy (GcaDBusFixit* self);
GType gca_dbus_diagnostic_get_type (void) G_GNUC_CONST;
GcaDBusDiagnostic* gca_dbus_diagnostic_dup (const GcaDBusDiagnostic* self);
void gca_dbus_diagnostic_free (GcaDBusDiagnostic* self);
void gca_dbus_diagnostic_copy (const GcaDBusDiagnostic* self, GcaDBusDiagnostic* dest);
void gca_dbus_diagnostic_destroy (GcaDBusDiagnostic* self);
static void _vala_GcaDBusFixit_array_free (GcaDBusFixit* array, gint array_length);
static GcaDBusFixit* _vala_array_dup8 (GcaDBusFixit* self, int length);
static GcaDBusSourceRange* _vala_array_dup9 (GcaDBusSourceRange* self, int length);
GType gca_dbus_introspectable_proxy_get_type (void) G_GNUC_CONST;
guint gca_dbus_introspectable_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType gca_dbus_introspectable_get_type (void) G_GNUC_CONST;
void gca_dbus_introspectable_Introspect (GcaDBusIntrospectable* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* gca_dbus_introspectable_Introspect_finish (GcaDBusIntrospectable* self, GAsyncResult* _res_, GError** error);
static void gca_dbus_introspectable_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void gca_dbus_introspectable_proxy_Introspect_async (GcaDBusIntrospectable* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* gca_dbus_introspectable_proxy_Introspect_finish (GcaDBusIntrospectable* self, GAsyncResult* _res_, GError** error);
static void gca_dbus_introspectable_proxy_gca_dbus_introspectable_interface_init (GcaDBusIntrospectableIface* iface);
static void _dbus_gca_dbus_introspectable_Introspect (GcaDBusIntrospectable* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_gca_dbus_introspectable_Introspect_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void gca_dbus_introspectable_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* gca_dbus_introspectable_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean gca_dbus_introspectable_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _gca_dbus_introspectable_unregister_object (gpointer user_data);
GType gca_dbus_service_proxy_get_type (void) G_GNUC_CONST;
guint gca_dbus_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType gca_dbus_service_get_type (void) G_GNUC_CONST;
void gca_dbus_service_parse (GcaDBusService* self, const gchar* path, const gchar* data_path, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
char* gca_dbus_service_parse_finish (GcaDBusService* self, GAsyncResult* _res_, GError** error);
void gca_dbus_service_dispose (GcaDBusService* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gca_dbus_service_dispose_finish (GcaDBusService* self, GAsyncResult* _res_, GError** error);
static void gca_dbus_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void gca_dbus_service_proxy_parse_async (GcaDBusService* self, const gchar* path, const gchar* data_path, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
static char* gca_dbus_service_proxy_parse_finish (GcaDBusService* self, GAsyncResult* _res_, GError** error);
static void gca_dbus_service_proxy_dispose_async (GcaDBusService* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gca_dbus_service_proxy_dispose_finish (GcaDBusService* self, GAsyncResult* _res_, GError** error);
static void gca_dbus_service_proxy_gca_dbus_service_interface_init (GcaDBusServiceIface* iface);
static void _dbus_gca_dbus_service_parse (GcaDBusService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_gca_dbus_service_parse_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_gca_dbus_service_dispose (GcaDBusService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_gca_dbus_service_dispose_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void gca_dbus_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* gca_dbus_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean gca_dbus_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _gca_dbus_service_unregister_object (gpointer user_data);
GType gca_dbus_project_proxy_get_type (void) G_GNUC_CONST;
guint gca_dbus_project_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType gca_dbus_project_get_type (void) G_GNUC_CONST;
void gca_dbus_project_parse_all (GcaDBusProject* self, const gchar* path, GcaDBusOpenDocument* documents, int documents_length1, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
GcaDBusRemoteDocument* gca_dbus_project_parse_all_finish (GcaDBusProject* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void gca_dbus_project_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void gca_dbus_project_proxy_parse_all_async (GcaDBusProject* self, const gchar* path, GcaDBusOpenDocument* documents, int documents_length1, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GcaDBusRemoteDocument* gca_dbus_project_proxy_parse_all_finish (GcaDBusProject* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void gca_dbus_project_proxy_gca_dbus_project_interface_init (GcaDBusProjectIface* iface);
static void _vala_GcaDBusOpenDocument_array_free (GcaDBusOpenDocument* array, gint array_length);
static void _dbus_gca_dbus_project_parse_all (GcaDBusProject* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _vala_GcaDBusRemoteDocument_array_free (GcaDBusRemoteDocument* array, gint array_length);
static void _dbus_gca_dbus_project_parse_all_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void gca_dbus_project_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* gca_dbus_project_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean gca_dbus_project_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _gca_dbus_project_unregister_object (gpointer user_data);
GType gca_dbus_document_get_type (void) G_GNUC_CONST;
GType gca_dbus_document_proxy_get_type (void) G_GNUC_CONST;
guint gca_dbus_document_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
static void gca_dbus_document_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void gca_dbus_document_proxy_gca_dbus_document_interface_init (GcaDBusDocumentIface* iface);
static void gca_dbus_document_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* gca_dbus_document_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean gca_dbus_document_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _gca_dbus_document_unregister_object (gpointer user_data);
GType gca_dbus_diagnostics_proxy_get_type (void) G_GNUC_CONST;
guint gca_dbus_diagnostics_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType gca_dbus_diagnostics_get_type (void) G_GNUC_CONST;
void gca_dbus_diagnostics_diagnostics (GcaDBusDiagnostics* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
GcaDBusDiagnostic* gca_dbus_diagnostics_diagnostics_finish (GcaDBusDiagnostics* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void gca_dbus_diagnostics_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void gca_dbus_diagnostics_proxy_diagnostics_async (GcaDBusDiagnostics* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GcaDBusDiagnostic* gca_dbus_diagnostics_proxy_diagnostics_finish (GcaDBusDiagnostics* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void gca_dbus_diagnostics_proxy_gca_dbus_diagnostics_interface_init (GcaDBusDiagnosticsIface* iface);
static void _dbus_gca_dbus_diagnostics_diagnostics (GcaDBusDiagnostics* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _vala_GcaDBusDiagnostic_array_free (GcaDBusDiagnostic* array, gint array_length);
static void _dbus_gca_dbus_diagnostics_diagnostics_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void gca_dbus_diagnostics_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* gca_dbus_diagnostics_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean gca_dbus_diagnostics_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _gca_dbus_diagnostics_unregister_object (gpointer user_data);

static const GDBusArgInfo _gca_dbus_introspectable_dbus_arg_info_Introspect_result = {-1, "result", "s"};
static const GDBusArgInfo * const _gca_dbus_introspectable_dbus_arg_info_Introspect_in[] = {NULL};
static const GDBusArgInfo * const _gca_dbus_introspectable_dbus_arg_info_Introspect_out[] = {&_gca_dbus_introspectable_dbus_arg_info_Introspect_result, NULL};
static const GDBusMethodInfo _gca_dbus_introspectable_dbus_method_info_Introspect = {-1, "Introspect", (GDBusArgInfo **) (&_gca_dbus_introspectable_dbus_arg_info_Introspect_in), (GDBusArgInfo **) (&_gca_dbus_introspectable_dbus_arg_info_Introspect_out)};
static const GDBusMethodInfo * const _gca_dbus_introspectable_dbus_method_info[] = {&_gca_dbus_introspectable_dbus_method_info_Introspect, NULL};
static const GDBusSignalInfo * const _gca_dbus_introspectable_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gca_dbus_introspectable_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gca_dbus_introspectable_dbus_interface_info = {-1, "org.freedesktop.DBus.Introspectable", (GDBusMethodInfo **) (&_gca_dbus_introspectable_dbus_method_info), (GDBusSignalInfo **) (&_gca_dbus_introspectable_dbus_signal_info), (GDBusPropertyInfo **) (&_gca_dbus_introspectable_dbus_property_info)};
static const GDBusInterfaceVTable _gca_dbus_introspectable_dbus_interface_vtable = {gca_dbus_introspectable_dbus_interface_method_call, gca_dbus_introspectable_dbus_interface_get_property, gca_dbus_introspectable_dbus_interface_set_property};
static const GDBusArgInfo _gca_dbus_service_dbus_arg_info_parse_path = {-1, "path", "s"};
static const GDBusArgInfo _gca_dbus_service_dbus_arg_info_parse_data_path = {-1, "data_path", "s"};
static const GDBusArgInfo _gca_dbus_service_dbus_arg_info_parse_cursor = {-1, "cursor", "(xx)"};
static const GDBusArgInfo _gca_dbus_service_dbus_arg_info_parse_options = {-1, "options", "a{sv}"};
static const GDBusArgInfo _gca_dbus_service_dbus_arg_info_parse_result = {-1, "result", "o"};
static const GDBusArgInfo * const _gca_dbus_service_dbus_arg_info_parse_in[] = {&_gca_dbus_service_dbus_arg_info_parse_path, &_gca_dbus_service_dbus_arg_info_parse_data_path, &_gca_dbus_service_dbus_arg_info_parse_cursor, &_gca_dbus_service_dbus_arg_info_parse_options, NULL};
static const GDBusArgInfo * const _gca_dbus_service_dbus_arg_info_parse_out[] = {&_gca_dbus_service_dbus_arg_info_parse_result, NULL};
static const GDBusMethodInfo _gca_dbus_service_dbus_method_info_parse = {-1, "Parse", (GDBusArgInfo **) (&_gca_dbus_service_dbus_arg_info_parse_in), (GDBusArgInfo **) (&_gca_dbus_service_dbus_arg_info_parse_out)};
static const GDBusArgInfo _gca_dbus_service_dbus_arg_info_dispose_path = {-1, "path", "s"};
static const GDBusArgInfo * const _gca_dbus_service_dbus_arg_info_dispose_in[] = {&_gca_dbus_service_dbus_arg_info_dispose_path, NULL};
static const GDBusArgInfo * const _gca_dbus_service_dbus_arg_info_dispose_out[] = {NULL};
static const GDBusMethodInfo _gca_dbus_service_dbus_method_info_dispose = {-1, "Dispose", (GDBusArgInfo **) (&_gca_dbus_service_dbus_arg_info_dispose_in), (GDBusArgInfo **) (&_gca_dbus_service_dbus_arg_info_dispose_out)};
static const GDBusMethodInfo * const _gca_dbus_service_dbus_method_info[] = {&_gca_dbus_service_dbus_method_info_parse, &_gca_dbus_service_dbus_method_info_dispose, NULL};
static const GDBusSignalInfo * const _gca_dbus_service_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gca_dbus_service_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gca_dbus_service_dbus_interface_info = {-1, "org.gnome.CodeAssist.v1.Service", (GDBusMethodInfo **) (&_gca_dbus_service_dbus_method_info), (GDBusSignalInfo **) (&_gca_dbus_service_dbus_signal_info), (GDBusPropertyInfo **) (&_gca_dbus_service_dbus_property_info)};
static const GDBusInterfaceVTable _gca_dbus_service_dbus_interface_vtable = {gca_dbus_service_dbus_interface_method_call, gca_dbus_service_dbus_interface_get_property, gca_dbus_service_dbus_interface_set_property};
static const GDBusArgInfo _gca_dbus_project_dbus_arg_info_parse_all_path = {-1, "path", "s"};
static const GDBusArgInfo _gca_dbus_project_dbus_arg_info_parse_all_documents = {-1, "documents", "a(ss)"};
static const GDBusArgInfo _gca_dbus_project_dbus_arg_info_parse_all_cursor = {-1, "cursor", "(xx)"};
static const GDBusArgInfo _gca_dbus_project_dbus_arg_info_parse_all_options = {-1, "options", "a{sv}"};
static const GDBusArgInfo _gca_dbus_project_dbus_arg_info_parse_all_result = {-1, "result", "a(so)"};
static const GDBusArgInfo * const _gca_dbus_project_dbus_arg_info_parse_all_in[] = {&_gca_dbus_project_dbus_arg_info_parse_all_path, &_gca_dbus_project_dbus_arg_info_parse_all_documents, &_gca_dbus_project_dbus_arg_info_parse_all_cursor, &_gca_dbus_project_dbus_arg_info_parse_all_options, NULL};
static const GDBusArgInfo * const _gca_dbus_project_dbus_arg_info_parse_all_out[] = {&_gca_dbus_project_dbus_arg_info_parse_all_result, NULL};
static const GDBusMethodInfo _gca_dbus_project_dbus_method_info_parse_all = {-1, "ParseAll", (GDBusArgInfo **) (&_gca_dbus_project_dbus_arg_info_parse_all_in), (GDBusArgInfo **) (&_gca_dbus_project_dbus_arg_info_parse_all_out)};
static const GDBusMethodInfo * const _gca_dbus_project_dbus_method_info[] = {&_gca_dbus_project_dbus_method_info_parse_all, NULL};
static const GDBusSignalInfo * const _gca_dbus_project_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gca_dbus_project_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gca_dbus_project_dbus_interface_info = {-1, "org.gnome.CodeAssist.v1.Project", (GDBusMethodInfo **) (&_gca_dbus_project_dbus_method_info), (GDBusSignalInfo **) (&_gca_dbus_project_dbus_signal_info), (GDBusPropertyInfo **) (&_gca_dbus_project_dbus_property_info)};
static const GDBusInterfaceVTable _gca_dbus_project_dbus_interface_vtable = {gca_dbus_project_dbus_interface_method_call, gca_dbus_project_dbus_interface_get_property, gca_dbus_project_dbus_interface_set_property};
static const GDBusMethodInfo * const _gca_dbus_document_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _gca_dbus_document_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gca_dbus_document_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gca_dbus_document_dbus_interface_info = {-1, "org.gnome.CodeAssist.v1.Document", (GDBusMethodInfo **) (&_gca_dbus_document_dbus_method_info), (GDBusSignalInfo **) (&_gca_dbus_document_dbus_signal_info), (GDBusPropertyInfo **) (&_gca_dbus_document_dbus_property_info)};
static const GDBusInterfaceVTable _gca_dbus_document_dbus_interface_vtable = {gca_dbus_document_dbus_interface_method_call, gca_dbus_document_dbus_interface_get_property, gca_dbus_document_dbus_interface_set_property};
static const GDBusArgInfo _gca_dbus_diagnostics_dbus_arg_info_diagnostics_result = {-1, "result", "a(ua((x(xx)(xx))s)a(x(xx)(xx))s)"};
static const GDBusArgInfo * const _gca_dbus_diagnostics_dbus_arg_info_diagnostics_in[] = {NULL};
static const GDBusArgInfo * const _gca_dbus_diagnostics_dbus_arg_info_diagnostics_out[] = {&_gca_dbus_diagnostics_dbus_arg_info_diagnostics_result, NULL};
static const GDBusMethodInfo _gca_dbus_diagnostics_dbus_method_info_diagnostics = {-1, "Diagnostics", (GDBusArgInfo **) (&_gca_dbus_diagnostics_dbus_arg_info_diagnostics_in), (GDBusArgInfo **) (&_gca_dbus_diagnostics_dbus_arg_info_diagnostics_out)};
static const GDBusMethodInfo * const _gca_dbus_diagnostics_dbus_method_info[] = {&_gca_dbus_diagnostics_dbus_method_info_diagnostics, NULL};
static const GDBusSignalInfo * const _gca_dbus_diagnostics_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gca_dbus_diagnostics_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gca_dbus_diagnostics_dbus_interface_info = {-1, "org.gnome.CodeAssist.v1.Diagnostics", (GDBusMethodInfo **) (&_gca_dbus_diagnostics_dbus_method_info), (GDBusSignalInfo **) (&_gca_dbus_diagnostics_dbus_signal_info), (GDBusPropertyInfo **) (&_gca_dbus_diagnostics_dbus_property_info)};
static const GDBusInterfaceVTable _gca_dbus_diagnostics_dbus_interface_vtable = {gca_dbus_diagnostics_dbus_interface_method_call, gca_dbus_diagnostics_dbus_interface_get_property, gca_dbus_diagnostics_dbus_interface_set_property};

void gca_dbus_open_document_copy (const GcaDBusOpenDocument* self, GcaDBusOpenDocument* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp0_ = (*self).path;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_g_free0 ((*dest).path);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	(*dest).path = _tmp1_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp2_ = (*self).data_path;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_g_free0 ((*dest).data_path);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	(*dest).data_path = _tmp3_;
#line 362 "gca-dbus.c"
}


void gca_dbus_open_document_destroy (GcaDBusOpenDocument* self) {
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_g_free0 ((*self).path);
#line 26 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_g_free0 ((*self).data_path);
#line 371 "gca-dbus.c"
}


GcaDBusOpenDocument* gca_dbus_open_document_dup (const GcaDBusOpenDocument* self) {
	GcaDBusOpenDocument* dup;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	dup = g_new0 (GcaDBusOpenDocument, 1);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	gca_dbus_open_document_copy (self, dup);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	return dup;
#line 383 "gca-dbus.c"
}


void gca_dbus_open_document_free (GcaDBusOpenDocument* self) {
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	gca_dbus_open_document_destroy (self);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	g_free (self);
#line 392 "gca-dbus.c"
}


GType gca_dbus_open_document_get_type (void) {
	static volatile gsize gca_dbus_open_document_type_id__volatile = 0;
	if (g_once_init_enter (&gca_dbus_open_document_type_id__volatile)) {
		GType gca_dbus_open_document_type_id;
		gca_dbus_open_document_type_id = g_boxed_type_register_static ("GcaDBusOpenDocument", (GBoxedCopyFunc) gca_dbus_open_document_dup, (GBoxedFreeFunc) gca_dbus_open_document_free);
		g_once_init_leave (&gca_dbus_open_document_type_id__volatile, gca_dbus_open_document_type_id);
	}
	return gca_dbus_open_document_type_id__volatile;
}


void gca_dbus_remote_document_copy (const GcaDBusRemoteDocument* self, GcaDBusRemoteDocument* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const char* _tmp2_;
	char* _tmp3_;
#line 29 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp0_ = (*self).path;
#line 29 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 29 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_g_free0 ((*dest).path);
#line 29 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	(*dest).path = _tmp1_;
#line 29 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp2_ = (*self).remote_path;
#line 29 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 29 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_g_free0 ((*dest).remote_path);
#line 29 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	(*dest).remote_path = _tmp3_;
#line 428 "gca-dbus.c"
}


void gca_dbus_remote_document_destroy (GcaDBusRemoteDocument* self) {
#line 31 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_g_free0 ((*self).path);
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_g_free0 ((*self).remote_path);
#line 437 "gca-dbus.c"
}


GcaDBusRemoteDocument* gca_dbus_remote_document_dup (const GcaDBusRemoteDocument* self) {
	GcaDBusRemoteDocument* dup;
#line 29 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	dup = g_new0 (GcaDBusRemoteDocument, 1);
#line 29 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	gca_dbus_remote_document_copy (self, dup);
#line 29 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	return dup;
#line 449 "gca-dbus.c"
}


void gca_dbus_remote_document_free (GcaDBusRemoteDocument* self) {
#line 29 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	gca_dbus_remote_document_destroy (self);
#line 29 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	g_free (self);
#line 458 "gca-dbus.c"
}


GType gca_dbus_remote_document_get_type (void) {
	static volatile gsize gca_dbus_remote_document_type_id__volatile = 0;
	if (g_once_init_enter (&gca_dbus_remote_document_type_id__volatile)) {
		GType gca_dbus_remote_document_type_id;
		gca_dbus_remote_document_type_id = g_boxed_type_register_static ("GcaDBusRemoteDocument", (GBoxedCopyFunc) gca_dbus_remote_document_dup, (GBoxedFreeFunc) gca_dbus_remote_document_free);
		g_once_init_leave (&gca_dbus_remote_document_type_id__volatile, gca_dbus_remote_document_type_id);
	}
	return gca_dbus_remote_document_type_id__volatile;
}


GcaDBusSourceLocation* gca_dbus_source_location_dup (const GcaDBusSourceLocation* self) {
	GcaDBusSourceLocation* dup;
#line 35 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	dup = g_new0 (GcaDBusSourceLocation, 1);
#line 35 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	memcpy (dup, self, sizeof (GcaDBusSourceLocation));
#line 35 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	return dup;
#line 481 "gca-dbus.c"
}


void gca_dbus_source_location_free (GcaDBusSourceLocation* self) {
#line 35 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	g_free (self);
#line 488 "gca-dbus.c"
}


GType gca_dbus_source_location_get_type (void) {
	static volatile gsize gca_dbus_source_location_type_id__volatile = 0;
	if (g_once_init_enter (&gca_dbus_source_location_type_id__volatile)) {
		GType gca_dbus_source_location_type_id;
		gca_dbus_source_location_type_id = g_boxed_type_register_static ("GcaDBusSourceLocation", (GBoxedCopyFunc) gca_dbus_source_location_dup, (GBoxedFreeFunc) gca_dbus_source_location_free);
		g_once_init_leave (&gca_dbus_source_location_type_id__volatile, gca_dbus_source_location_type_id);
	}
	return gca_dbus_source_location_type_id__volatile;
}


GcaDBusSourceRange* gca_dbus_source_range_dup (const GcaDBusSourceRange* self) {
	GcaDBusSourceRange* dup;
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	dup = g_new0 (GcaDBusSourceRange, 1);
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	memcpy (dup, self, sizeof (GcaDBusSourceRange));
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	return dup;
#line 511 "gca-dbus.c"
}


void gca_dbus_source_range_free (GcaDBusSourceRange* self) {
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	g_free (self);
#line 518 "gca-dbus.c"
}


GType gca_dbus_source_range_get_type (void) {
	static volatile gsize gca_dbus_source_range_type_id__volatile = 0;
	if (g_once_init_enter (&gca_dbus_source_range_type_id__volatile)) {
		GType gca_dbus_source_range_type_id;
		gca_dbus_source_range_type_id = g_boxed_type_register_static ("GcaDBusSourceRange", (GBoxedCopyFunc) gca_dbus_source_range_dup, (GBoxedFreeFunc) gca_dbus_source_range_free);
		g_once_init_leave (&gca_dbus_source_range_type_id__volatile, gca_dbus_source_range_type_id);
	}
	return gca_dbus_source_range_type_id__volatile;
}


void gca_dbus_fixit_copy (const GcaDBusFixit* self, GcaDBusFixit* dest) {
	GcaDBusSourceRange _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp0_ = (*self).location;
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	(*dest).location = _tmp0_;
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp1_ = (*self).replacement;
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_g_free0 ((*dest).replacement);
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	(*dest).replacement = _tmp2_;
#line 549 "gca-dbus.c"
}


void gca_dbus_fixit_destroy (GcaDBusFixit* self) {
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_g_free0 ((*self).replacement);
#line 556 "gca-dbus.c"
}


GcaDBusFixit* gca_dbus_fixit_dup (const GcaDBusFixit* self) {
	GcaDBusFixit* dup;
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	dup = g_new0 (GcaDBusFixit, 1);
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	gca_dbus_fixit_copy (self, dup);
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	return dup;
#line 568 "gca-dbus.c"
}


void gca_dbus_fixit_free (GcaDBusFixit* self) {
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	gca_dbus_fixit_destroy (self);
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	g_free (self);
#line 577 "gca-dbus.c"
}


GType gca_dbus_fixit_get_type (void) {
	static volatile gsize gca_dbus_fixit_type_id__volatile = 0;
	if (g_once_init_enter (&gca_dbus_fixit_type_id__volatile)) {
		GType gca_dbus_fixit_type_id;
		gca_dbus_fixit_type_id = g_boxed_type_register_static ("GcaDBusFixit", (GBoxedCopyFunc) gca_dbus_fixit_dup, (GBoxedFreeFunc) gca_dbus_fixit_free);
		g_once_init_leave (&gca_dbus_fixit_type_id__volatile, gca_dbus_fixit_type_id);
	}
	return gca_dbus_fixit_type_id__volatile;
}


static void _vala_GcaDBusFixit_array_free (GcaDBusFixit* array, gint array_length) {
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	if (array != NULL) {
#line 595 "gca-dbus.c"
		int i;
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
			gca_dbus_fixit_destroy (&array[i]);
#line 601 "gca-dbus.c"
		}
	}
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	g_free (array);
#line 606 "gca-dbus.c"
}


static GcaDBusFixit* _vala_array_dup8 (GcaDBusFixit* self, int length) {
	GcaDBusFixit* result;
	int i;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	result = g_new0 (GcaDBusFixit, length);
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	for (i = 0; i < length; i++) {
#line 617 "gca-dbus.c"
		GcaDBusFixit _tmp0_ = {0};
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
		gca_dbus_fixit_copy (&self[i], &_tmp0_);
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
		result[i] = _tmp0_;
#line 623 "gca-dbus.c"
	}
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	return result;
#line 627 "gca-dbus.c"
}


static GcaDBusSourceRange* _vala_array_dup9 (GcaDBusSourceRange* self, int length) {
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	return g_memdup (self, length * sizeof (GcaDBusSourceRange));
#line 634 "gca-dbus.c"
}


void gca_dbus_diagnostic_copy (const GcaDBusDiagnostic* self, GcaDBusDiagnostic* dest) {
	guint32 _tmp0_;
	GcaDBusFixit* _tmp1_;
	gint _tmp1__length1;
	GcaDBusFixit* _tmp2_;
	gint _tmp2__length1;
	GcaDBusSourceRange* _tmp3_;
	gint _tmp3__length1;
	GcaDBusSourceRange* _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp0_ = (*self).severity;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	(*dest).severity = _tmp0_;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp1_ = (*self).fixits;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp1__length1 = (*self).fixits_length1;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup8 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp2__length1 = _tmp1__length1;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	(*dest).fixits = (_vala_GcaDBusFixit_array_free ((*dest).fixits, (*dest).fixits_length1), NULL);
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	(*dest).fixits = _tmp2_;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	(*dest).fixits_length1 = _tmp2__length1;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp3_ = (*self).locations;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp3__length1 = (*self).locations_length1;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup9 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp4__length1 = _tmp3__length1;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	(*dest).locations = (g_free ((*dest).locations), NULL);
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	(*dest).locations = _tmp4_;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	(*dest).locations_length1 = _tmp4__length1;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp5_ = (*self).message;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_g_free0 ((*dest).message);
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	(*dest).message = _tmp6_;
#line 690 "gca-dbus.c"
}


void gca_dbus_diagnostic_destroy (GcaDBusDiagnostic* self) {
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	(*self).fixits = (_vala_GcaDBusFixit_array_free ((*self).fixits, (*self).fixits_length1), NULL);
#line 59 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	(*self).locations = (g_free ((*self).locations), NULL);
#line 60 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	_g_free0 ((*self).message);
#line 701 "gca-dbus.c"
}


GcaDBusDiagnostic* gca_dbus_diagnostic_dup (const GcaDBusDiagnostic* self) {
	GcaDBusDiagnostic* dup;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	dup = g_new0 (GcaDBusDiagnostic, 1);
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	gca_dbus_diagnostic_copy (self, dup);
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	return dup;
#line 713 "gca-dbus.c"
}


void gca_dbus_diagnostic_free (GcaDBusDiagnostic* self) {
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	gca_dbus_diagnostic_destroy (self);
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	g_free (self);
#line 722 "gca-dbus.c"
}


GType gca_dbus_diagnostic_get_type (void) {
	static volatile gsize gca_dbus_diagnostic_type_id__volatile = 0;
	if (g_once_init_enter (&gca_dbus_diagnostic_type_id__volatile)) {
		GType gca_dbus_diagnostic_type_id;
		gca_dbus_diagnostic_type_id = g_boxed_type_register_static ("GcaDBusDiagnostic", (GBoxedCopyFunc) gca_dbus_diagnostic_dup, (GBoxedFreeFunc) gca_dbus_diagnostic_free);
		g_once_init_leave (&gca_dbus_diagnostic_type_id__volatile, gca_dbus_diagnostic_type_id);
	}
	return gca_dbus_diagnostic_type_id__volatile;
}


void gca_dbus_introspectable_Introspect (GcaDBusIntrospectable* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	GCA_DBUS_INTROSPECTABLE_GET_INTERFACE (self)->Introspect (self, _callback_, _user_data_);
#line 740 "gca-dbus.c"
}


gchar* gca_dbus_introspectable_Introspect_finish (GcaDBusIntrospectable* self, GAsyncResult* _res_, GError** error) {
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	return GCA_DBUS_INTROSPECTABLE_GET_INTERFACE (self)->Introspect_finish (self, _res_, error);
#line 747 "gca-dbus.c"
}


static void gca_dbus_introspectable_base_init (GcaDBusIntrospectableIface * iface) {
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	static gboolean initialized = FALSE;
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	if (!initialized) {
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
		initialized = TRUE;
#line 758 "gca-dbus.c"
	}
}


GType gca_dbus_introspectable_get_type (void) {
	static volatile gsize gca_dbus_introspectable_type_id__volatile = 0;
	if (g_once_init_enter (&gca_dbus_introspectable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaDBusIntrospectableIface), (GBaseInitFunc) gca_dbus_introspectable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gca_dbus_introspectable_type_id;
		gca_dbus_introspectable_type_id = g_type_register_static (G_TYPE_INTERFACE, "GcaDBusIntrospectable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gca_dbus_introspectable_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (gca_dbus_introspectable_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gca_dbus_introspectable_proxy_get_type);
		g_type_set_qdata (gca_dbus_introspectable_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus.Introspectable");
		g_type_set_qdata (gca_dbus_introspectable_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gca_dbus_introspectable_register_object);
		g_once_init_leave (&gca_dbus_introspectable_type_id__volatile, gca_dbus_introspectable_type_id);
	}
	return gca_dbus_introspectable_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (GcaDBusIntrospectableProxy, gca_dbus_introspectable_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GCA_DBUS_TYPE_INTROSPECTABLE, gca_dbus_introspectable_proxy_gca_dbus_introspectable_interface_init) )
static void gca_dbus_introspectable_proxy_class_init (GcaDBusIntrospectableProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = gca_dbus_introspectable_proxy_g_signal;
}


static void gca_dbus_introspectable_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void gca_dbus_introspectable_proxy_init (GcaDBusIntrospectableProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void gca_dbus_introspectable_proxy_Introspect_async (GcaDBusIntrospectable* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus.Introspectable", "Introspect");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static gchar* gca_dbus_introspectable_proxy_Introspect_finish (GcaDBusIntrospectable* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp0_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}


static void gca_dbus_introspectable_proxy_gca_dbus_introspectable_interface_init (GcaDBusIntrospectableIface* iface) {
	iface->Introspect = gca_dbus_introspectable_proxy_Introspect_async;
	iface->Introspect_finish = gca_dbus_introspectable_proxy_Introspect_finish;
}


static void _dbus_gca_dbus_introspectable_Introspect (GcaDBusIntrospectable* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	gca_dbus_introspectable_Introspect (self, (GAsyncReadyCallback) _dbus_gca_dbus_introspectable_Introspect_ready, invocation);
}


static void _dbus_gca_dbus_introspectable_Introspect_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	invocation = _user_data_;
	result = gca_dbus_introspectable_Introspect_finish ((GcaDBusIntrospectable*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void gca_dbus_introspectable_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Introspect") == 0) {
		_dbus_gca_dbus_introspectable_Introspect (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* gca_dbus_introspectable_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean gca_dbus_introspectable_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint gca_dbus_introspectable_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gca_dbus_introspectable_dbus_interface_info), &_gca_dbus_introspectable_dbus_interface_vtable, data, _gca_dbus_introspectable_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _gca_dbus_introspectable_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void gca_dbus_service_parse (GcaDBusService* self, const gchar* path, const gchar* data_path, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 70 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	GCA_DBUS_SERVICE_GET_INTERFACE (self)->parse (self, path, data_path, cursor, options, _callback_, _user_data_);
#line 935 "gca-dbus.c"
}


char* gca_dbus_service_parse_finish (GcaDBusService* self, GAsyncResult* _res_, GError** error) {
#line 70 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	return GCA_DBUS_SERVICE_GET_INTERFACE (self)->parse_finish (self, _res_, error);
#line 942 "gca-dbus.c"
}


void gca_dbus_service_dispose (GcaDBusService* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 70 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	GCA_DBUS_SERVICE_GET_INTERFACE (self)->dispose (self, path, _callback_, _user_data_);
#line 949 "gca-dbus.c"
}


void gca_dbus_service_dispose_finish (GcaDBusService* self, GAsyncResult* _res_, GError** error) {
#line 70 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	GCA_DBUS_SERVICE_GET_INTERFACE (self)->dispose_finish (self, _res_, error);
#line 956 "gca-dbus.c"
}


static void gca_dbus_service_base_init (GcaDBusServiceIface * iface) {
#line 70 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	static gboolean initialized = FALSE;
#line 70 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	if (!initialized) {
#line 70 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
		initialized = TRUE;
#line 967 "gca-dbus.c"
	}
}


GType gca_dbus_service_get_type (void) {
	static volatile gsize gca_dbus_service_type_id__volatile = 0;
	if (g_once_init_enter (&gca_dbus_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaDBusServiceIface), (GBaseInitFunc) gca_dbus_service_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gca_dbus_service_type_id;
		gca_dbus_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "GcaDBusService", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gca_dbus_service_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (gca_dbus_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gca_dbus_service_proxy_get_type);
		g_type_set_qdata (gca_dbus_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.CodeAssist.v1.Service");
		g_type_set_qdata (gca_dbus_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gca_dbus_service_register_object);
		g_once_init_leave (&gca_dbus_service_type_id__volatile, gca_dbus_service_type_id);
	}
	return gca_dbus_service_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (GcaDBusServiceProxy, gca_dbus_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GCA_DBUS_TYPE_SERVICE, gca_dbus_service_proxy_gca_dbus_service_interface_init) )
static void gca_dbus_service_proxy_class_init (GcaDBusServiceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = gca_dbus_service_proxy_g_signal;
}


static void gca_dbus_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void gca_dbus_service_proxy_init (GcaDBusServiceProxy* self) {
}


static void gca_dbus_service_proxy_parse_async (GcaDBusService* self, const gchar* path, const gchar* data_path, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp1_;
	GVariantBuilder _tmp2_;
	GHashTableIter _tmp3_;
	gpointer _tmp4_;
	gpointer _tmp5_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.CodeAssist.v1.Service", "Parse");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (path));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (data_path));
	g_variant_builder_init (&_tmp1_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp1_, g_variant_new_int64 ((*cursor).line));
	g_variant_builder_add_value (&_tmp1_, g_variant_new_int64 ((*cursor).column));
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp1_));
	g_hash_table_iter_init (&_tmp3_, options);
	g_variant_builder_init (&_tmp2_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp3_, &_tmp4_, &_tmp5_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp4_;
		_value = (GVariant*) _tmp5_;
		g_variant_builder_add (&_tmp2_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp2_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static char* gca_dbus_service_proxy_parse_finish (GcaDBusService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	char* _result;
	GVariant* _tmp6_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp6_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	g_object_unref (_reply_message);
	return _result;
}


static void gca_dbus_service_proxy_dispose_async (GcaDBusService* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.CodeAssist.v1.Service", "Dispose");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void gca_dbus_service_proxy_dispose_finish (GcaDBusService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void gca_dbus_service_proxy_gca_dbus_service_interface_init (GcaDBusServiceIface* iface) {
	iface->parse = gca_dbus_service_proxy_parse_async;
	iface->parse_finish = gca_dbus_service_proxy_parse_finish;
	iface->dispose = gca_dbus_service_proxy_dispose_async;
	iface->dispose_finish = gca_dbus_service_proxy_dispose_finish;
}


static void _dbus_gca_dbus_service_parse (GcaDBusService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* path = NULL;
	GVariant* _tmp7_;
	gchar* data_path = NULL;
	GVariant* _tmp8_;
	GcaDBusSourceLocation cursor = {0};
	GVariant* _tmp9_;
	GcaDBusSourceLocation _tmp10_;
	GVariantIter _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GHashTable* options = NULL;
	GVariant* _tmp14_;
	GHashTable* _tmp15_;
	GVariantIter _tmp16_;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	path = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	data_path = g_variant_dup_string (_tmp8_, NULL);
	g_variant_unref (_tmp8_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	g_variant_iter_init (&_tmp11_, _tmp9_);
	_tmp12_ = g_variant_iter_next_value (&_tmp11_);
	_tmp10_.line = g_variant_get_int64 (_tmp12_);
	g_variant_unref (_tmp12_);
	_tmp13_ = g_variant_iter_next_value (&_tmp11_);
	_tmp10_.column = g_variant_get_int64 (_tmp13_);
	g_variant_unref (_tmp13_);
	cursor = _tmp10_;
	g_variant_unref (_tmp9_);
	_tmp14_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp15_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp16_, _tmp14_);
	while (g_variant_iter_loop (&_tmp16_, "{?*}", &_tmp17_, &_tmp18_)) {
		g_hash_table_insert (_tmp15_, g_variant_dup_string (_tmp17_, NULL), g_variant_get_variant (_tmp18_));
	}
	options = _tmp15_;
	g_variant_unref (_tmp14_);
	gca_dbus_service_parse (self, path, data_path, &cursor, options, (GAsyncReadyCallback) _dbus_gca_dbus_service_parse_ready, invocation);
	_g_free0 (path);
	_g_free0 (data_path);
	_g_hash_table_unref0 (options);
}


static void _dbus_gca_dbus_service_parse_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char* result;
	invocation = _user_data_;
	result = gca_dbus_service_parse_finish ((GcaDBusService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_object_path (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_gca_dbus_service_dispose (GcaDBusService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* path = NULL;
	GVariant* _tmp19_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp19_ = g_variant_iter_next_value (&_arguments_iter);
	path = g_variant_dup_string (_tmp19_, NULL);
	g_variant_unref (_tmp19_);
	gca_dbus_service_dispose (self, path, (GAsyncReadyCallback) _dbus_gca_dbus_service_dispose_ready, invocation);
	_g_free0 (path);
}


static void _dbus_gca_dbus_service_dispose_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	gca_dbus_service_dispose_finish ((GcaDBusService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void gca_dbus_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Parse") == 0) {
		_dbus_gca_dbus_service_parse (object, parameters, invocation);
	} else if (strcmp (method_name, "Dispose") == 0) {
		_dbus_gca_dbus_service_dispose (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* gca_dbus_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean gca_dbus_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint gca_dbus_service_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gca_dbus_service_dbus_interface_info), &_gca_dbus_service_dbus_interface_vtable, data, _gca_dbus_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _gca_dbus_service_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void gca_dbus_project_parse_all (GcaDBusProject* self, const gchar* path, GcaDBusOpenDocument* documents, int documents_length1, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	GCA_DBUS_PROJECT_GET_INTERFACE (self)->parse_all (self, path, documents, documents_length1, cursor, options, _callback_, _user_data_);
#line 1269 "gca-dbus.c"
}


GcaDBusRemoteDocument* gca_dbus_project_parse_all_finish (GcaDBusProject* self, GAsyncResult* _res_, int* result_length1, GError** error) {
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	return GCA_DBUS_PROJECT_GET_INTERFACE (self)->parse_all_finish (self, _res_, result_length1, error);
#line 1276 "gca-dbus.c"
}


static void gca_dbus_project_base_init (GcaDBusProjectIface * iface) {
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	static gboolean initialized = FALSE;
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	if (!initialized) {
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
		initialized = TRUE;
#line 1287 "gca-dbus.c"
	}
}


GType gca_dbus_project_get_type (void) {
	static volatile gsize gca_dbus_project_type_id__volatile = 0;
	if (g_once_init_enter (&gca_dbus_project_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaDBusProjectIface), (GBaseInitFunc) gca_dbus_project_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gca_dbus_project_type_id;
		gca_dbus_project_type_id = g_type_register_static (G_TYPE_INTERFACE, "GcaDBusProject", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gca_dbus_project_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (gca_dbus_project_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gca_dbus_project_proxy_get_type);
		g_type_set_qdata (gca_dbus_project_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.CodeAssist.v1.Project");
		g_type_set_qdata (gca_dbus_project_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gca_dbus_project_register_object);
		g_once_init_leave (&gca_dbus_project_type_id__volatile, gca_dbus_project_type_id);
	}
	return gca_dbus_project_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (GcaDBusProjectProxy, gca_dbus_project_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GCA_DBUS_TYPE_PROJECT, gca_dbus_project_proxy_gca_dbus_project_interface_init) )
static void gca_dbus_project_proxy_class_init (GcaDBusProjectProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = gca_dbus_project_proxy_g_signal;
}


static void gca_dbus_project_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void gca_dbus_project_proxy_init (GcaDBusProjectProxy* self) {
}


static void gca_dbus_project_proxy_parse_all_async (GcaDBusProject* self, const gchar* path, GcaDBusOpenDocument* documents, int documents_length1, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GcaDBusOpenDocument* _tmp20_;
	GVariantBuilder _tmp21_;
	int _tmp22_;
	GVariantBuilder _tmp24_;
	GVariantBuilder _tmp25_;
	GHashTableIter _tmp26_;
	gpointer _tmp27_;
	gpointer _tmp28_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.CodeAssist.v1.Project", "ParseAll");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (path));
	_tmp20_ = documents;
	g_variant_builder_init (&_tmp21_, G_VARIANT_TYPE ("a(ss)"));
	for (_tmp22_ = 0; _tmp22_ < documents_length1; _tmp22_++) {
		GVariantBuilder _tmp23_;
		g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp23_, g_variant_new_string ((*_tmp20_).path));
		g_variant_builder_add_value (&_tmp23_, g_variant_new_string ((*_tmp20_).data_path));
		g_variant_builder_add_value (&_tmp21_, g_variant_builder_end (&_tmp23_));
		_tmp20_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp21_));
	g_variant_builder_init (&_tmp24_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp24_, g_variant_new_int64 ((*cursor).line));
	g_variant_builder_add_value (&_tmp24_, g_variant_new_int64 ((*cursor).column));
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp24_));
	g_hash_table_iter_init (&_tmp26_, options);
	g_variant_builder_init (&_tmp25_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp26_, &_tmp27_, &_tmp28_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp27_;
		_value = (GVariant*) _tmp28_;
		g_variant_builder_add (&_tmp25_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp25_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static GcaDBusRemoteDocument* gca_dbus_project_proxy_parse_all_finish (GcaDBusProject* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GcaDBusRemoteDocument* _result;
	int _result_length1;
	GVariant* _tmp29_;
	GcaDBusRemoteDocument* _tmp30_;
	int _tmp30__length;
	int _tmp30__size;
	int _tmp30__length1;
	GVariantIter _tmp31_;
	GVariant* _tmp32_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp29_ = g_variant_iter_next_value (&_reply_iter);
	_tmp30_ = g_new (GcaDBusRemoteDocument, 5);
	_tmp30__length = 0;
	_tmp30__size = 4;
	_tmp30__length1 = 0;
	g_variant_iter_init (&_tmp31_, _tmp29_);
	for (; (_tmp32_ = g_variant_iter_next_value (&_tmp31_)) != NULL; _tmp30__length1++) {
		GcaDBusRemoteDocument _tmp33_;
		GVariantIter _tmp34_;
		GVariant* _tmp35_;
		GVariant* _tmp36_;
		if (_tmp30__size == _tmp30__length) {
			_tmp30__size = 2 * _tmp30__size;
			_tmp30_ = g_renew (GcaDBusRemoteDocument, _tmp30_, _tmp30__size + 1);
		}
		g_variant_iter_init (&_tmp34_, _tmp32_);
		_tmp35_ = g_variant_iter_next_value (&_tmp34_);
		_tmp33_.path = g_variant_dup_string (_tmp35_, NULL);
		g_variant_unref (_tmp35_);
		_tmp36_ = g_variant_iter_next_value (&_tmp34_);
		_tmp33_.remote_path = g_variant_dup_string (_tmp36_, NULL);
		g_variant_unref (_tmp36_);
		_tmp30_[_tmp30__length++] = _tmp33_;
		g_variant_unref (_tmp32_);
	}
	_result_length1 = _tmp30__length1;
	_result = _tmp30_;
	g_variant_unref (_tmp29_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static void gca_dbus_project_proxy_gca_dbus_project_interface_init (GcaDBusProjectIface* iface) {
	iface->parse_all = gca_dbus_project_proxy_parse_all_async;
	iface->parse_all_finish = gca_dbus_project_proxy_parse_all_finish;
}


static void _vala_GcaDBusOpenDocument_array_free (GcaDBusOpenDocument* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			gca_dbus_open_document_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _dbus_gca_dbus_project_parse_all (GcaDBusProject* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* path = NULL;
	GVariant* _tmp37_;
	GcaDBusOpenDocument* documents = NULL;
	int documents_length1 = 0;
	GVariant* _tmp38_;
	GcaDBusOpenDocument* _tmp39_;
	int _tmp39__length;
	int _tmp39__size;
	int _tmp39__length1;
	GVariantIter _tmp40_;
	GVariant* _tmp41_;
	GcaDBusSourceLocation cursor = {0};
	GVariant* _tmp46_;
	GcaDBusSourceLocation _tmp47_;
	GVariantIter _tmp48_;
	GVariant* _tmp49_;
	GVariant* _tmp50_;
	GHashTable* options = NULL;
	GVariant* _tmp51_;
	GHashTable* _tmp52_;
	GVariantIter _tmp53_;
	GVariant* _tmp54_;
	GVariant* _tmp55_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp37_ = g_variant_iter_next_value (&_arguments_iter);
	path = g_variant_dup_string (_tmp37_, NULL);
	g_variant_unref (_tmp37_);
	_tmp38_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp39_ = g_new (GcaDBusOpenDocument, 5);
	_tmp39__length = 0;
	_tmp39__size = 4;
	_tmp39__length1 = 0;
	g_variant_iter_init (&_tmp40_, _tmp38_);
	for (; (_tmp41_ = g_variant_iter_next_value (&_tmp40_)) != NULL; _tmp39__length1++) {
		GcaDBusOpenDocument _tmp42_;
		GVariantIter _tmp43_;
		GVariant* _tmp44_;
		GVariant* _tmp45_;
		if (_tmp39__size == _tmp39__length) {
			_tmp39__size = 2 * _tmp39__size;
			_tmp39_ = g_renew (GcaDBusOpenDocument, _tmp39_, _tmp39__size + 1);
		}
		g_variant_iter_init (&_tmp43_, _tmp41_);
		_tmp44_ = g_variant_iter_next_value (&_tmp43_);
		_tmp42_.path = g_variant_dup_string (_tmp44_, NULL);
		g_variant_unref (_tmp44_);
		_tmp45_ = g_variant_iter_next_value (&_tmp43_);
		_tmp42_.data_path = g_variant_dup_string (_tmp45_, NULL);
		g_variant_unref (_tmp45_);
		_tmp39_[_tmp39__length++] = _tmp42_;
		g_variant_unref (_tmp41_);
	}
	documents_length1 = _tmp39__length1;
	documents = _tmp39_;
	g_variant_unref (_tmp38_);
	_tmp46_ = g_variant_iter_next_value (&_arguments_iter);
	g_variant_iter_init (&_tmp48_, _tmp46_);
	_tmp49_ = g_variant_iter_next_value (&_tmp48_);
	_tmp47_.line = g_variant_get_int64 (_tmp49_);
	g_variant_unref (_tmp49_);
	_tmp50_ = g_variant_iter_next_value (&_tmp48_);
	_tmp47_.column = g_variant_get_int64 (_tmp50_);
	g_variant_unref (_tmp50_);
	cursor = _tmp47_;
	g_variant_unref (_tmp46_);
	_tmp51_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp52_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp53_, _tmp51_);
	while (g_variant_iter_loop (&_tmp53_, "{?*}", &_tmp54_, &_tmp55_)) {
		g_hash_table_insert (_tmp52_, g_variant_dup_string (_tmp54_, NULL), g_variant_get_variant (_tmp55_));
	}
	options = _tmp52_;
	g_variant_unref (_tmp51_);
	gca_dbus_project_parse_all (self, path, documents, documents_length1, &cursor, options, (GAsyncReadyCallback) _dbus_gca_dbus_project_parse_all_ready, invocation);
	_g_free0 (path);
	documents = (_vala_GcaDBusOpenDocument_array_free (documents, documents_length1), NULL);
	_g_hash_table_unref0 (options);
}


static void _vala_GcaDBusRemoteDocument_array_free (GcaDBusRemoteDocument* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			gca_dbus_remote_document_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _dbus_gca_dbus_project_parse_all_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GcaDBusRemoteDocument* result;
	int result_length1 = 0;
	GcaDBusRemoteDocument* _tmp56_;
	GVariantBuilder _tmp57_;
	int _tmp58_;
	invocation = _user_data_;
	result = gca_dbus_project_parse_all_finish ((GcaDBusProject*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp56_ = result;
	g_variant_builder_init (&_tmp57_, G_VARIANT_TYPE ("a(so)"));
	for (_tmp58_ = 0; _tmp58_ < result_length1; _tmp58_++) {
		GVariantBuilder _tmp59_;
		g_variant_builder_init (&_tmp59_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp59_, g_variant_new_string ((*_tmp56_).path));
		g_variant_builder_add_value (&_tmp59_, g_variant_new_object_path ((*_tmp56_).remote_path));
		g_variant_builder_add_value (&_tmp57_, g_variant_builder_end (&_tmp59_));
		_tmp56_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp57_));
	result = (_vala_GcaDBusRemoteDocument_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void gca_dbus_project_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ParseAll") == 0) {
		_dbus_gca_dbus_project_parse_all (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* gca_dbus_project_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean gca_dbus_project_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint gca_dbus_project_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gca_dbus_project_dbus_interface_info), &_gca_dbus_project_dbus_interface_vtable, data, _gca_dbus_project_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _gca_dbus_project_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void gca_dbus_document_base_init (GcaDBusDocumentIface * iface) {
#line 93 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	static gboolean initialized = FALSE;
#line 93 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	if (!initialized) {
#line 93 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
		initialized = TRUE;
#line 1640 "gca-dbus.c"
	}
}


GType gca_dbus_document_get_type (void) {
	static volatile gsize gca_dbus_document_type_id__volatile = 0;
	if (g_once_init_enter (&gca_dbus_document_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaDBusDocumentIface), (GBaseInitFunc) gca_dbus_document_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gca_dbus_document_type_id;
		gca_dbus_document_type_id = g_type_register_static (G_TYPE_INTERFACE, "GcaDBusDocument", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gca_dbus_document_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (gca_dbus_document_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gca_dbus_document_proxy_get_type);
		g_type_set_qdata (gca_dbus_document_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.CodeAssist.v1.Document");
		g_type_set_qdata (gca_dbus_document_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gca_dbus_document_register_object);
		g_once_init_leave (&gca_dbus_document_type_id__volatile, gca_dbus_document_type_id);
	}
	return gca_dbus_document_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (GcaDBusDocumentProxy, gca_dbus_document_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GCA_DBUS_TYPE_DOCUMENT, gca_dbus_document_proxy_gca_dbus_document_interface_init) )
static void gca_dbus_document_proxy_class_init (GcaDBusDocumentProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = gca_dbus_document_proxy_g_signal;
}


static void gca_dbus_document_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void gca_dbus_document_proxy_init (GcaDBusDocumentProxy* self) {
}


static void gca_dbus_document_proxy_gca_dbus_document_interface_init (GcaDBusDocumentIface* iface) {
}


static void gca_dbus_document_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* gca_dbus_document_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean gca_dbus_document_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint gca_dbus_document_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gca_dbus_document_dbus_interface_info), &_gca_dbus_document_dbus_interface_vtable, data, _gca_dbus_document_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _gca_dbus_document_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void gca_dbus_diagnostics_diagnostics (GcaDBusDiagnostics* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	GCA_DBUS_DIAGNOSTICS_GET_INTERFACE (self)->diagnostics (self, _callback_, _user_data_);
#line 1734 "gca-dbus.c"
}


GcaDBusDiagnostic* gca_dbus_diagnostics_diagnostics_finish (GcaDBusDiagnostics* self, GAsyncResult* _res_, int* result_length1, GError** error) {
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	return GCA_DBUS_DIAGNOSTICS_GET_INTERFACE (self)->diagnostics_finish (self, _res_, result_length1, error);
#line 1741 "gca-dbus.c"
}


static void gca_dbus_diagnostics_base_init (GcaDBusDiagnosticsIface * iface) {
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	static gboolean initialized = FALSE;
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
	if (!initialized) {
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-dbus.vala"
		initialized = TRUE;
#line 1752 "gca-dbus.c"
	}
}


GType gca_dbus_diagnostics_get_type (void) {
	static volatile gsize gca_dbus_diagnostics_type_id__volatile = 0;
	if (g_once_init_enter (&gca_dbus_diagnostics_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaDBusDiagnosticsIface), (GBaseInitFunc) gca_dbus_diagnostics_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gca_dbus_diagnostics_type_id;
		gca_dbus_diagnostics_type_id = g_type_register_static (G_TYPE_INTERFACE, "GcaDBusDiagnostics", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gca_dbus_diagnostics_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (gca_dbus_diagnostics_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gca_dbus_diagnostics_proxy_get_type);
		g_type_set_qdata (gca_dbus_diagnostics_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.CodeAssist.v1.Diagnostics");
		g_type_set_qdata (gca_dbus_diagnostics_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gca_dbus_diagnostics_register_object);
		g_once_init_leave (&gca_dbus_diagnostics_type_id__volatile, gca_dbus_diagnostics_type_id);
	}
	return gca_dbus_diagnostics_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (GcaDBusDiagnosticsProxy, gca_dbus_diagnostics_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GCA_DBUS_TYPE_DIAGNOSTICS, gca_dbus_diagnostics_proxy_gca_dbus_diagnostics_interface_init) )
static void gca_dbus_diagnostics_proxy_class_init (GcaDBusDiagnosticsProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = gca_dbus_diagnostics_proxy_g_signal;
}


static void gca_dbus_diagnostics_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void gca_dbus_diagnostics_proxy_init (GcaDBusDiagnosticsProxy* self) {
}


static void gca_dbus_diagnostics_proxy_diagnostics_async (GcaDBusDiagnostics* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.CodeAssist.v1.Diagnostics", "Diagnostics");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static GcaDBusDiagnostic* gca_dbus_diagnostics_proxy_diagnostics_finish (GcaDBusDiagnostics* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GcaDBusDiagnostic* _result;
	int _result_length1;
	GVariant* _tmp60_;
	GcaDBusDiagnostic* _tmp61_;
	int _tmp61__length;
	int _tmp61__size;
	int _tmp61__length1;
	GVariantIter _tmp62_;
	GVariant* _tmp63_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp60_ = g_variant_iter_next_value (&_reply_iter);
	_tmp61_ = g_new (GcaDBusDiagnostic, 5);
	_tmp61__length = 0;
	_tmp61__size = 4;
	_tmp61__length1 = 0;
	g_variant_iter_init (&_tmp62_, _tmp60_);
	for (; (_tmp63_ = g_variant_iter_next_value (&_tmp62_)) != NULL; _tmp61__length1++) {
		GcaDBusDiagnostic _tmp64_;
		GVariantIter _tmp65_;
		GVariant* _tmp66_;
		GVariant* _tmp67_;
		GcaDBusFixit* _tmp68_;
		int _tmp68__length;
		int _tmp68__size;
		int _tmp68__length1;
		GVariantIter _tmp69_;
		GVariant* _tmp70_;
		GVariant* _tmp88_;
		GcaDBusSourceRange* _tmp89_;
		int _tmp89__length;
		int _tmp89__size;
		int _tmp89__length1;
		GVariantIter _tmp90_;
		GVariant* _tmp91_;
		GVariant* _tmp105_;
		if (_tmp61__size == _tmp61__length) {
			_tmp61__size = 2 * _tmp61__size;
			_tmp61_ = g_renew (GcaDBusDiagnostic, _tmp61_, _tmp61__size + 1);
		}
		g_variant_iter_init (&_tmp65_, _tmp63_);
		_tmp66_ = g_variant_iter_next_value (&_tmp65_);
		_tmp64_.severity = g_variant_get_uint32 (_tmp66_);
		g_variant_unref (_tmp66_);
		_tmp67_ = g_variant_iter_next_value (&_tmp65_);
		_tmp68_ = g_new (GcaDBusFixit, 5);
		_tmp68__length = 0;
		_tmp68__size = 4;
		_tmp68__length1 = 0;
		g_variant_iter_init (&_tmp69_, _tmp67_);
		for (; (_tmp70_ = g_variant_iter_next_value (&_tmp69_)) != NULL; _tmp68__length1++) {
			GcaDBusFixit _tmp71_;
			GVariantIter _tmp72_;
			GVariant* _tmp73_;
			GcaDBusSourceRange _tmp74_;
			GVariantIter _tmp75_;
			GVariant* _tmp76_;
			GVariant* _tmp77_;
			GcaDBusSourceLocation _tmp78_;
			GVariantIter _tmp79_;
			GVariant* _tmp80_;
			GVariant* _tmp81_;
			GVariant* _tmp82_;
			GcaDBusSourceLocation _tmp83_;
			GVariantIter _tmp84_;
			GVariant* _tmp85_;
			GVariant* _tmp86_;
			GVariant* _tmp87_;
			if (_tmp68__size == _tmp68__length) {
				_tmp68__size = 2 * _tmp68__size;
				_tmp68_ = g_renew (GcaDBusFixit, _tmp68_, _tmp68__size + 1);
			}
			g_variant_iter_init (&_tmp72_, _tmp70_);
			_tmp73_ = g_variant_iter_next_value (&_tmp72_);
			g_variant_iter_init (&_tmp75_, _tmp73_);
			_tmp76_ = g_variant_iter_next_value (&_tmp75_);
			_tmp74_.file = g_variant_get_int64 (_tmp76_);
			g_variant_unref (_tmp76_);
			_tmp77_ = g_variant_iter_next_value (&_tmp75_);
			g_variant_iter_init (&_tmp79_, _tmp77_);
			_tmp80_ = g_variant_iter_next_value (&_tmp79_);
			_tmp78_.line = g_variant_get_int64 (_tmp80_);
			g_variant_unref (_tmp80_);
			_tmp81_ = g_variant_iter_next_value (&_tmp79_);
			_tmp78_.column = g_variant_get_int64 (_tmp81_);
			g_variant_unref (_tmp81_);
			_tmp74_.start = _tmp78_;
			g_variant_unref (_tmp77_);
			_tmp82_ = g_variant_iter_next_value (&_tmp75_);
			g_variant_iter_init (&_tmp84_, _tmp82_);
			_tmp85_ = g_variant_iter_next_value (&_tmp84_);
			_tmp83_.line = g_variant_get_int64 (_tmp85_);
			g_variant_unref (_tmp85_);
			_tmp86_ = g_variant_iter_next_value (&_tmp84_);
			_tmp83_.column = g_variant_get_int64 (_tmp86_);
			g_variant_unref (_tmp86_);
			_tmp74_.end = _tmp83_;
			g_variant_unref (_tmp82_);
			_tmp71_.location = _tmp74_;
			g_variant_unref (_tmp73_);
			_tmp87_ = g_variant_iter_next_value (&_tmp72_);
			_tmp71_.replacement = g_variant_dup_string (_tmp87_, NULL);
			g_variant_unref (_tmp87_);
			_tmp68_[_tmp68__length++] = _tmp71_;
			g_variant_unref (_tmp70_);
		}
		_tmp64_.fixits_length1 = _tmp68__length1;
		_tmp64_.fixits = _tmp68_;
		g_variant_unref (_tmp67_);
		_tmp88_ = g_variant_iter_next_value (&_tmp65_);
		_tmp89_ = g_new (GcaDBusSourceRange, 5);
		_tmp89__length = 0;
		_tmp89__size = 4;
		_tmp89__length1 = 0;
		g_variant_iter_init (&_tmp90_, _tmp88_);
		for (; (_tmp91_ = g_variant_iter_next_value (&_tmp90_)) != NULL; _tmp89__length1++) {
			GcaDBusSourceRange _tmp92_;
			GVariantIter _tmp93_;
			GVariant* _tmp94_;
			GVariant* _tmp95_;
			GcaDBusSourceLocation _tmp96_;
			GVariantIter _tmp97_;
			GVariant* _tmp98_;
			GVariant* _tmp99_;
			GVariant* _tmp100_;
			GcaDBusSourceLocation _tmp101_;
			GVariantIter _tmp102_;
			GVariant* _tmp103_;
			GVariant* _tmp104_;
			if (_tmp89__size == _tmp89__length) {
				_tmp89__size = 2 * _tmp89__size;
				_tmp89_ = g_renew (GcaDBusSourceRange, _tmp89_, _tmp89__size + 1);
			}
			g_variant_iter_init (&_tmp93_, _tmp91_);
			_tmp94_ = g_variant_iter_next_value (&_tmp93_);
			_tmp92_.file = g_variant_get_int64 (_tmp94_);
			g_variant_unref (_tmp94_);
			_tmp95_ = g_variant_iter_next_value (&_tmp93_);
			g_variant_iter_init (&_tmp97_, _tmp95_);
			_tmp98_ = g_variant_iter_next_value (&_tmp97_);
			_tmp96_.line = g_variant_get_int64 (_tmp98_);
			g_variant_unref (_tmp98_);
			_tmp99_ = g_variant_iter_next_value (&_tmp97_);
			_tmp96_.column = g_variant_get_int64 (_tmp99_);
			g_variant_unref (_tmp99_);
			_tmp92_.start = _tmp96_;
			g_variant_unref (_tmp95_);
			_tmp100_ = g_variant_iter_next_value (&_tmp93_);
			g_variant_iter_init (&_tmp102_, _tmp100_);
			_tmp103_ = g_variant_iter_next_value (&_tmp102_);
			_tmp101_.line = g_variant_get_int64 (_tmp103_);
			g_variant_unref (_tmp103_);
			_tmp104_ = g_variant_iter_next_value (&_tmp102_);
			_tmp101_.column = g_variant_get_int64 (_tmp104_);
			g_variant_unref (_tmp104_);
			_tmp92_.end = _tmp101_;
			g_variant_unref (_tmp100_);
			_tmp89_[_tmp89__length++] = _tmp92_;
			g_variant_unref (_tmp91_);
		}
		_tmp64_.locations_length1 = _tmp89__length1;
		_tmp64_.locations = _tmp89_;
		g_variant_unref (_tmp88_);
		_tmp105_ = g_variant_iter_next_value (&_tmp65_);
		_tmp64_.message = g_variant_dup_string (_tmp105_, NULL);
		g_variant_unref (_tmp105_);
		_tmp61_[_tmp61__length++] = _tmp64_;
		g_variant_unref (_tmp63_);
	}
	_result_length1 = _tmp61__length1;
	_result = _tmp61_;
	g_variant_unref (_tmp60_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static void gca_dbus_diagnostics_proxy_gca_dbus_diagnostics_interface_init (GcaDBusDiagnosticsIface* iface) {
	iface->diagnostics = gca_dbus_diagnostics_proxy_diagnostics_async;
	iface->diagnostics_finish = gca_dbus_diagnostics_proxy_diagnostics_finish;
}


static void _dbus_gca_dbus_diagnostics_diagnostics (GcaDBusDiagnostics* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	gca_dbus_diagnostics_diagnostics (self, (GAsyncReadyCallback) _dbus_gca_dbus_diagnostics_diagnostics_ready, invocation);
}


static void _vala_GcaDBusDiagnostic_array_free (GcaDBusDiagnostic* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			gca_dbus_diagnostic_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _dbus_gca_dbus_diagnostics_diagnostics_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GcaDBusDiagnostic* result;
	int result_length1 = 0;
	GcaDBusDiagnostic* _tmp106_;
	GVariantBuilder _tmp107_;
	int _tmp108_;
	invocation = _user_data_;
	result = gca_dbus_diagnostics_diagnostics_finish ((GcaDBusDiagnostics*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp106_ = result;
	g_variant_builder_init (&_tmp107_, G_VARIANT_TYPE ("a(ua((x(xx)(xx))s)a(x(xx)(xx))s)"));
	for (_tmp108_ = 0; _tmp108_ < result_length1; _tmp108_++) {
		GVariantBuilder _tmp109_;
		GcaDBusFixit* _tmp110_;
		GVariantBuilder _tmp111_;
		int _tmp112_;
		GcaDBusSourceRange* _tmp117_;
		GVariantBuilder _tmp118_;
		int _tmp119_;
		g_variant_builder_init (&_tmp109_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp109_, g_variant_new_uint32 ((*_tmp106_).severity));
		_tmp110_ = (*_tmp106_).fixits;
		g_variant_builder_init (&_tmp111_, G_VARIANT_TYPE ("a((x(xx)(xx))s)"));
		for (_tmp112_ = 0; _tmp112_ < (*_tmp106_).fixits_length1; _tmp112_++) {
			GVariantBuilder _tmp113_;
			GVariantBuilder _tmp114_;
			GVariantBuilder _tmp115_;
			GVariantBuilder _tmp116_;
			g_variant_builder_init (&_tmp113_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_init (&_tmp114_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp114_, g_variant_new_int64 ((*_tmp110_).location.file));
			g_variant_builder_init (&_tmp115_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp115_, g_variant_new_int64 ((*_tmp110_).location.start.line));
			g_variant_builder_add_value (&_tmp115_, g_variant_new_int64 ((*_tmp110_).location.start.column));
			g_variant_builder_add_value (&_tmp114_, g_variant_builder_end (&_tmp115_));
			g_variant_builder_init (&_tmp116_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp116_, g_variant_new_int64 ((*_tmp110_).location.end.line));
			g_variant_builder_add_value (&_tmp116_, g_variant_new_int64 ((*_tmp110_).location.end.column));
			g_variant_builder_add_value (&_tmp114_, g_variant_builder_end (&_tmp116_));
			g_variant_builder_add_value (&_tmp113_, g_variant_builder_end (&_tmp114_));
			g_variant_builder_add_value (&_tmp113_, g_variant_new_string ((*_tmp110_).replacement));
			g_variant_builder_add_value (&_tmp111_, g_variant_builder_end (&_tmp113_));
			_tmp110_++;
		}
		g_variant_builder_add_value (&_tmp109_, g_variant_builder_end (&_tmp111_));
		_tmp117_ = (*_tmp106_).locations;
		g_variant_builder_init (&_tmp118_, G_VARIANT_TYPE ("a(x(xx)(xx))"));
		for (_tmp119_ = 0; _tmp119_ < (*_tmp106_).locations_length1; _tmp119_++) {
			GVariantBuilder _tmp120_;
			GVariantBuilder _tmp121_;
			GVariantBuilder _tmp122_;
			g_variant_builder_init (&_tmp120_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp120_, g_variant_new_int64 ((*_tmp117_).file));
			g_variant_builder_init (&_tmp121_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp121_, g_variant_new_int64 ((*_tmp117_).start.line));
			g_variant_builder_add_value (&_tmp121_, g_variant_new_int64 ((*_tmp117_).start.column));
			g_variant_builder_add_value (&_tmp120_, g_variant_builder_end (&_tmp121_));
			g_variant_builder_init (&_tmp122_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp122_, g_variant_new_int64 ((*_tmp117_).end.line));
			g_variant_builder_add_value (&_tmp122_, g_variant_new_int64 ((*_tmp117_).end.column));
			g_variant_builder_add_value (&_tmp120_, g_variant_builder_end (&_tmp122_));
			g_variant_builder_add_value (&_tmp118_, g_variant_builder_end (&_tmp120_));
			_tmp117_++;
		}
		g_variant_builder_add_value (&_tmp109_, g_variant_builder_end (&_tmp118_));
		g_variant_builder_add_value (&_tmp109_, g_variant_new_string ((*_tmp106_).message));
		g_variant_builder_add_value (&_tmp107_, g_variant_builder_end (&_tmp109_));
		_tmp106_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp107_));
	result = (_vala_GcaDBusDiagnostic_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void gca_dbus_diagnostics_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Diagnostics") == 0) {
		_dbus_gca_dbus_diagnostics_diagnostics (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* gca_dbus_diagnostics_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean gca_dbus_diagnostics_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint gca_dbus_diagnostics_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gca_dbus_diagnostics_dbus_interface_info), &_gca_dbus_diagnostics_dbus_interface_vtable, data, _gca_dbus_diagnostics_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _gca_dbus_diagnostics_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}



