/* gca-diagnostic.c generated by valac 0.20.1, the Vala compiler
 * generated from gca-diagnostic.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define GCA_TYPE_SOURCE_RANGE_SUPPORT (gca_source_range_support_get_type ())
#define GCA_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_SOURCE_RANGE_SUPPORT, GcaSourceRangeSupport))
#define GCA_IS_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_SOURCE_RANGE_SUPPORT))
#define GCA_SOURCE_RANGE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_TYPE_SOURCE_RANGE_SUPPORT, GcaSourceRangeSupportIface))

typedef struct _GcaSourceRangeSupport GcaSourceRangeSupport;
typedef struct _GcaSourceRangeSupportIface GcaSourceRangeSupportIface;

#define GCA_TYPE_SOURCE_RANGE (gca_source_range_get_type ())

#define GCA_TYPE_SOURCE_LOCATION (gca_source_location_get_type ())
typedef struct _GcaSourceLocation GcaSourceLocation;
typedef struct _GcaSourceRange GcaSourceRange;

#define GCA_TYPE_DIAGNOSTIC (gca_diagnostic_get_type ())
#define GCA_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DIAGNOSTIC, GcaDiagnostic))
#define GCA_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DIAGNOSTIC, GcaDiagnosticClass))
#define GCA_IS_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DIAGNOSTIC))
#define GCA_IS_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DIAGNOSTIC))
#define GCA_DIAGNOSTIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DIAGNOSTIC, GcaDiagnosticClass))

typedef struct _GcaDiagnostic GcaDiagnostic;
typedef struct _GcaDiagnosticClass GcaDiagnosticClass;
typedef struct _GcaDiagnosticPrivate GcaDiagnosticPrivate;

#define GCA_DIAGNOSTIC_TYPE_FIXIT (gca_diagnostic_fixit_get_type ())
typedef struct _GcaDiagnosticFixit GcaDiagnosticFixit;

#define GCA_DIAGNOSTIC_TYPE_SEVERITY (gca_diagnostic_severity_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define GCA_DBUS_TYPE_DIAGNOSTIC (gca_dbus_diagnostic_get_type ())

#define GCA_DBUS_TYPE_FIXIT (gca_dbus_fixit_get_type ())

#define GCA_DBUS_TYPE_SOURCE_RANGE (gca_dbus_source_range_get_type ())

#define GCA_DBUS_TYPE_SOURCE_LOCATION (gca_dbus_source_location_get_type ())
typedef struct _GcaDBusSourceLocation GcaDBusSourceLocation;
typedef struct _GcaDBusSourceRange GcaDBusSourceRange;
typedef struct _GcaDBusFixit GcaDBusFixit;
typedef struct _GcaDBusDiagnostic GcaDBusDiagnostic;

struct _GcaSourceLocation {
	gint line;
	gint column;
};

struct _GcaSourceRange {
	GcaSourceLocation start;
	GcaSourceLocation end;
};

struct _GcaSourceRangeSupportIface {
	GTypeInterface parent_iface;
	GcaSourceRange* (*get_ranges) (GcaSourceRangeSupport* self, int* result_length1);
};

struct _GcaDiagnostic {
	GObject parent_instance;
	GcaDiagnosticPrivate * priv;
};

struct _GcaDiagnosticClass {
	GObjectClass parent_class;
};

struct _GcaDiagnosticFixit {
	GcaSourceRange range;
	gchar* replacement;
};

typedef enum  {
	GCA_DIAGNOSTIC_SEVERITY_NONE,
	GCA_DIAGNOSTIC_SEVERITY_INFO,
	GCA_DIAGNOSTIC_SEVERITY_WARNING,
	GCA_DIAGNOSTIC_SEVERITY_DEPRECATED,
	GCA_DIAGNOSTIC_SEVERITY_ERROR,
	GCA_DIAGNOSTIC_SEVERITY_FATAL
} GcaDiagnosticSeverity;

struct _GcaDiagnosticPrivate {
	GcaSourceRange* d_location;
	gint d_location_length1;
	gint _d_location_size_;
	GcaDiagnosticFixit* d_fixits;
	gint d_fixits_length1;
	gint _d_fixits_size_;
	GcaDiagnosticSeverity d_severity;
	gchar* d_message;
};

struct _GcaDBusSourceLocation {
	gint64 line;
	gint64 column;
};

struct _GcaDBusSourceRange {
	gint64 file;
	GcaDBusSourceLocation start;
	GcaDBusSourceLocation end;
};

struct _GcaDBusFixit {
	GcaDBusSourceRange location;
	gchar* replacement;
};

struct _GcaDBusDiagnostic {
	guint32 severity;
	GcaDBusFixit* fixits;
	gint fixits_length1;
	GcaDBusSourceRange* locations;
	gint locations_length1;
	gchar* message;
};


static gpointer gca_diagnostic_parent_class = NULL;
static GcaSourceRangeSupportIface* gca_diagnostic_gca_source_range_support_parent_iface = NULL;

GType gca_source_range_get_type (void) G_GNUC_CONST;
GType gca_source_location_get_type (void) G_GNUC_CONST;
GcaSourceLocation* gca_source_location_dup (const GcaSourceLocation* self);
void gca_source_location_free (GcaSourceLocation* self);
GcaSourceRange* gca_source_range_dup (const GcaSourceRange* self);
void gca_source_range_free (GcaSourceRange* self);
GType gca_source_range_support_get_type (void) G_GNUC_CONST;
GType gca_diagnostic_get_type (void) G_GNUC_CONST;
GType gca_diagnostic_fixit_get_type (void) G_GNUC_CONST;
GcaDiagnosticFixit* gca_diagnostic_fixit_dup (const GcaDiagnosticFixit* self);
void gca_diagnostic_fixit_free (GcaDiagnosticFixit* self);
void gca_diagnostic_fixit_copy (const GcaDiagnosticFixit* self, GcaDiagnosticFixit* dest);
void gca_diagnostic_fixit_destroy (GcaDiagnosticFixit* self);
GType gca_diagnostic_severity_get_type (void) G_GNUC_CONST;
#define GCA_DIAGNOSTIC_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCA_TYPE_DIAGNOSTIC, GcaDiagnosticPrivate))
enum  {
	GCA_DIAGNOSTIC_DUMMY_PROPERTY,
	GCA_DIAGNOSTIC_SEVERITY,
	GCA_DIAGNOSTIC_MESSAGE
};
gchar* gca_diagnostic_severity_to_string (GcaDiagnosticSeverity self);
static void _vala_GcaDiagnosticFixit_array_free (GcaDiagnosticFixit* array, gint array_length);
GType gca_dbus_diagnostic_get_type (void) G_GNUC_CONST;
GType gca_dbus_fixit_get_type (void) G_GNUC_CONST;
GType gca_dbus_source_range_get_type (void) G_GNUC_CONST;
GType gca_dbus_source_location_get_type (void) G_GNUC_CONST;
GcaDBusSourceLocation* gca_dbus_source_location_dup (const GcaDBusSourceLocation* self);
void gca_dbus_source_location_free (GcaDBusSourceLocation* self);
GcaDBusSourceRange* gca_dbus_source_range_dup (const GcaDBusSourceRange* self);
void gca_dbus_source_range_free (GcaDBusSourceRange* self);
GcaDBusFixit* gca_dbus_fixit_dup (const GcaDBusFixit* self);
void gca_dbus_fixit_free (GcaDBusFixit* self);
void gca_dbus_fixit_copy (const GcaDBusFixit* self, GcaDBusFixit* dest);
void gca_dbus_fixit_destroy (GcaDBusFixit* self);
GcaDBusDiagnostic* gca_dbus_diagnostic_dup (const GcaDBusDiagnostic* self);
void gca_dbus_diagnostic_free (GcaDBusDiagnostic* self);
void gca_dbus_diagnostic_copy (const GcaDBusDiagnostic* self, GcaDBusDiagnostic* dest);
void gca_dbus_diagnostic_destroy (GcaDBusDiagnostic* self);
GcaDiagnostic* gca_diagnostic_new_from_dbus (GcaDBusDiagnostic* diagnostic);
GcaDiagnostic* gca_diagnostic_construct_from_dbus (GType object_type, GcaDBusDiagnostic* diagnostic);
void gca_diagnostic_fixit_from_dbus (GcaDBusFixit* fixit, GcaDiagnosticFixit* result);
void gca_source_range_from_dbus (GcaDBusSourceRange* range, GcaSourceRange* result);
GcaDiagnostic* gca_diagnostic_new (GcaDiagnosticSeverity severity, GcaSourceRange* location, int location_length1, GcaDiagnosticFixit* fixits, int fixits_length1, const gchar* message);
GcaDiagnostic* gca_diagnostic_construct (GType object_type, GcaDiagnosticSeverity severity, GcaSourceRange* location, int location_length1, GcaDiagnosticFixit* fixits, int fixits_length1, const gchar* message);
static GcaSourceRange* _vala_array_dup1 (GcaSourceRange* self, int length);
static GcaDiagnosticFixit* _vala_array_dup2 (GcaDiagnosticFixit* self, int length);
static gchar* gca_diagnostic_loc_string (GcaDiagnostic* self);
gchar* gca_source_range_to_string (GcaSourceRange *self);
gchar* gca_diagnostic_to_markup (GcaDiagnostic* self, gboolean include_severity);
static GcaSourceRange* _vala_array_dup3 (GcaSourceRange* self, int length);
GcaDiagnosticFixit* gca_diagnostic_get_fixits (GcaDiagnostic* self, int* result_length1);
GcaDiagnosticSeverity gca_diagnostic_get_severity (GcaDiagnostic* self);
const gchar* gca_diagnostic_get_message (GcaDiagnostic* self);
GcaSourceRange* gca_diagnostic_get_location (GcaDiagnostic* self, int* result_length1);
static void gca_diagnostic_finalize (GObject* obj);
static void _vala_gca_diagnostic_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gchar* gca_diagnostic_severity_to_string (GcaDiagnosticSeverity self) {
	gchar* result = NULL;
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	switch (self) {
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		case GCA_DIAGNOSTIC_SEVERITY_NONE:
#line 217 "gca-diagnostic.c"
		{
			gchar* _tmp0_;
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			_tmp0_ = g_strdup ("None");
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			result = _tmp0_;
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			return result;
#line 226 "gca-diagnostic.c"
		}
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		case GCA_DIAGNOSTIC_SEVERITY_INFO:
#line 230 "gca-diagnostic.c"
		{
			gchar* _tmp1_;
#line 43 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			_tmp1_ = g_strdup ("Info");
#line 43 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			result = _tmp1_;
#line 43 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			return result;
#line 239 "gca-diagnostic.c"
		}
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		case GCA_DIAGNOSTIC_SEVERITY_WARNING:
#line 243 "gca-diagnostic.c"
		{
			gchar* _tmp2_;
#line 45 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			_tmp2_ = g_strdup ("Warning");
#line 45 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			result = _tmp2_;
#line 45 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			return result;
#line 252 "gca-diagnostic.c"
		}
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		case GCA_DIAGNOSTIC_SEVERITY_DEPRECATED:
#line 256 "gca-diagnostic.c"
		{
			gchar* _tmp3_;
#line 47 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			_tmp3_ = g_strdup ("Deprecated");
#line 47 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			result = _tmp3_;
#line 47 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			return result;
#line 265 "gca-diagnostic.c"
		}
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		case GCA_DIAGNOSTIC_SEVERITY_ERROR:
#line 269 "gca-diagnostic.c"
		{
			gchar* _tmp4_;
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			_tmp4_ = g_strdup ("Error");
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			result = _tmp4_;
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			return result;
#line 278 "gca-diagnostic.c"
		}
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		case GCA_DIAGNOSTIC_SEVERITY_FATAL:
#line 282 "gca-diagnostic.c"
		{
			gchar* _tmp5_;
#line 51 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			_tmp5_ = g_strdup ("Fatal");
#line 51 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			result = _tmp5_;
#line 51 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			return result;
#line 291 "gca-diagnostic.c"
		}
		default:
		{
			gchar* _tmp6_;
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			_tmp6_ = g_strdup ("Unknown");
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			result = _tmp6_;
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			return result;
#line 302 "gca-diagnostic.c"
		}
	}
}


GType gca_diagnostic_severity_get_type (void) {
	static volatile gsize gca_diagnostic_severity_type_id__volatile = 0;
	if (g_once_init_enter (&gca_diagnostic_severity_type_id__volatile)) {
		static const GEnumValue values[] = {{GCA_DIAGNOSTIC_SEVERITY_NONE, "GCA_DIAGNOSTIC_SEVERITY_NONE", "none"}, {GCA_DIAGNOSTIC_SEVERITY_INFO, "GCA_DIAGNOSTIC_SEVERITY_INFO", "info"}, {GCA_DIAGNOSTIC_SEVERITY_WARNING, "GCA_DIAGNOSTIC_SEVERITY_WARNING", "warning"}, {GCA_DIAGNOSTIC_SEVERITY_DEPRECATED, "GCA_DIAGNOSTIC_SEVERITY_DEPRECATED", "deprecated"}, {GCA_DIAGNOSTIC_SEVERITY_ERROR, "GCA_DIAGNOSTIC_SEVERITY_ERROR", "error"}, {GCA_DIAGNOSTIC_SEVERITY_FATAL, "GCA_DIAGNOSTIC_SEVERITY_FATAL", "fatal"}, {0, NULL, NULL}};
		GType gca_diagnostic_severity_type_id;
		gca_diagnostic_severity_type_id = g_enum_register_static ("GcaDiagnosticSeverity", values);
		g_once_init_leave (&gca_diagnostic_severity_type_id__volatile, gca_diagnostic_severity_type_id);
	}
	return gca_diagnostic_severity_type_id__volatile;
}


static void _vala_GcaDiagnosticFixit_array_free (GcaDiagnosticFixit* array, gint array_length) {
#line 74 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	if (array != NULL) {
#line 323 "gca-diagnostic.c"
		int i;
#line 74 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 74 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			gca_diagnostic_fixit_destroy (&array[i]);
#line 329 "gca-diagnostic.c"
		}
	}
#line 74 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	g_free (array);
#line 334 "gca-diagnostic.c"
}


GcaDiagnostic* gca_diagnostic_construct_from_dbus (GType object_type, GcaDBusDiagnostic* diagnostic) {
	GcaDiagnostic * self = NULL;
	GcaDBusDiagnostic _tmp0_;
	GcaDBusFixit* _tmp1_;
	gint _tmp1__length1;
	GcaDiagnosticFixit* _tmp2_ = NULL;
	GcaDiagnosticFixit* f;
	gint f_length1;
	gint _f_size_;
	GcaDBusDiagnostic _tmp17_;
	GcaDBusSourceRange* _tmp18_;
	gint _tmp18__length1;
	GcaSourceRange* _tmp19_ = NULL;
	GcaSourceRange* l;
	gint l_length1;
	gint _l_size_;
	GcaDBusDiagnostic _tmp34_;
	guint32 _tmp35_;
	GcaSourceRange* _tmp36_;
	gint _tmp36__length1;
	GcaDiagnosticFixit* _tmp37_;
	gint _tmp37__length1;
	GcaDBusDiagnostic _tmp38_;
	const gchar* _tmp39_;
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	g_return_val_if_fail (diagnostic != NULL, NULL);
#line 80 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp0_ = *diagnostic;
#line 80 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp1_ = _tmp0_.fixits;
#line 80 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp1__length1 = _tmp0_.fixits_length1;
#line 80 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp2_ = g_new0 (GcaDiagnosticFixit, _tmp1__length1);
#line 80 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	f = _tmp2_;
#line 80 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	f_length1 = _tmp1__length1;
#line 80 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_f_size_ = f_length1;
#line 378 "gca-diagnostic.c"
	{
		gint i;
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		i = 0;
#line 383 "gca-diagnostic.c"
		{
			gboolean _tmp3_;
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			_tmp3_ = TRUE;
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			while (TRUE) {
#line 390 "gca-diagnostic.c"
				gboolean _tmp4_;
				gint _tmp6_;
				GcaDBusDiagnostic _tmp7_;
				GcaDBusFixit* _tmp8_;
				gint _tmp8__length1;
				GcaDiagnosticFixit* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				GcaDBusDiagnostic _tmp11_;
				GcaDBusFixit* _tmp12_;
				gint _tmp12__length1;
				gint _tmp13_;
				GcaDBusFixit _tmp14_;
				GcaDiagnosticFixit _tmp15_ = {0};
				GcaDiagnosticFixit _tmp16_;
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp4_ = _tmp3_;
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				if (!_tmp4_) {
#line 410 "gca-diagnostic.c"
					gint _tmp5_;
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
					_tmp5_ = i;
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
					i = _tmp5_ + 1;
#line 416 "gca-diagnostic.c"
				}
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp3_ = FALSE;
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp6_ = i;
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp7_ = *diagnostic;
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp8_ = _tmp7_.fixits;
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp8__length1 = _tmp7_.fixits_length1;
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				if (!(_tmp6_ < _tmp8__length1)) {
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
					break;
#line 432 "gca-diagnostic.c"
				}
#line 84 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp9_ = f;
#line 84 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp9__length1 = f_length1;
#line 84 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp10_ = i;
#line 84 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp11_ = *diagnostic;
#line 84 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp12_ = _tmp11_.fixits;
#line 84 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp12__length1 = _tmp11_.fixits_length1;
#line 84 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp13_ = i;
#line 84 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp14_ = _tmp12_[_tmp13_];
#line 84 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				gca_diagnostic_fixit_from_dbus (&_tmp14_, &_tmp15_);
#line 84 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				gca_diagnostic_fixit_destroy (&_tmp9_[_tmp10_]);
#line 84 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp9_[_tmp10_] = _tmp15_;
#line 84 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp16_ = _tmp9_[_tmp10_];
#line 458 "gca-diagnostic.c"
			}
		}
	}
#line 87 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp17_ = *diagnostic;
#line 87 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp18_ = _tmp17_.locations;
#line 87 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp18__length1 = _tmp17_.locations_length1;
#line 87 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp19_ = g_new0 (GcaSourceRange, _tmp18__length1);
#line 87 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	l = _tmp19_;
#line 87 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	l_length1 = _tmp18__length1;
#line 87 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_l_size_ = l_length1;
#line 476 "gca-diagnostic.c"
	{
		gint i;
#line 89 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		i = 0;
#line 481 "gca-diagnostic.c"
		{
			gboolean _tmp20_;
#line 89 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			_tmp20_ = TRUE;
#line 89 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			while (TRUE) {
#line 488 "gca-diagnostic.c"
				gboolean _tmp21_;
				gint _tmp23_;
				GcaDBusDiagnostic _tmp24_;
				GcaDBusSourceRange* _tmp25_;
				gint _tmp25__length1;
				GcaSourceRange* _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				GcaDBusDiagnostic _tmp28_;
				GcaDBusSourceRange* _tmp29_;
				gint _tmp29__length1;
				gint _tmp30_;
				GcaDBusSourceRange _tmp31_;
				GcaSourceRange _tmp32_ = {0};
				GcaSourceRange _tmp33_;
#line 89 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp21_ = _tmp20_;
#line 89 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				if (!_tmp21_) {
#line 508 "gca-diagnostic.c"
					gint _tmp22_;
#line 89 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
					_tmp22_ = i;
#line 89 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
					i = _tmp22_ + 1;
#line 514 "gca-diagnostic.c"
				}
#line 89 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp20_ = FALSE;
#line 89 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp23_ = i;
#line 89 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp24_ = *diagnostic;
#line 89 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp25_ = _tmp24_.locations;
#line 89 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp25__length1 = _tmp24_.locations_length1;
#line 89 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				if (!(_tmp23_ < _tmp25__length1)) {
#line 89 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
					break;
#line 530 "gca-diagnostic.c"
				}
#line 91 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp26_ = l;
#line 91 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp26__length1 = l_length1;
#line 91 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp27_ = i;
#line 91 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp28_ = *diagnostic;
#line 91 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp29_ = _tmp28_.locations;
#line 91 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp29__length1 = _tmp28_.locations_length1;
#line 91 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp30_ = i;
#line 91 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp31_ = _tmp29_[_tmp30_];
#line 91 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				gca_source_range_from_dbus (&_tmp31_, &_tmp32_);
#line 91 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp26_[_tmp27_] = _tmp32_;
#line 91 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp33_ = _tmp26_[_tmp27_];
#line 554 "gca-diagnostic.c"
			}
		}
	}
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp34_ = *diagnostic;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp35_ = _tmp34_.severity;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp36_ = l;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp36__length1 = l_length1;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp37_ = f;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp37__length1 = f_length1;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp38_ = *diagnostic;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp39_ = _tmp38_.message;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self = (GcaDiagnostic*) gca_diagnostic_construct (object_type, (GcaDiagnosticSeverity) _tmp35_, _tmp36_, _tmp36__length1, _tmp37_, _tmp37__length1, _tmp39_);
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	l = (g_free (l), NULL);
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	f = (_vala_GcaDiagnosticFixit_array_free (f, f_length1), NULL);
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	return self;
#line 582 "gca-diagnostic.c"
}


GcaDiagnostic* gca_diagnostic_new_from_dbus (GcaDBusDiagnostic* diagnostic) {
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	return gca_diagnostic_construct_from_dbus (GCA_TYPE_DIAGNOSTIC, diagnostic);
#line 589 "gca-diagnostic.c"
}


static GcaSourceRange* _vala_array_dup1 (GcaSourceRange* self, int length) {
#line 103 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	return g_memdup (self, length * sizeof (GcaSourceRange));
#line 596 "gca-diagnostic.c"
}


static GcaDiagnosticFixit* _vala_array_dup2 (GcaDiagnosticFixit* self, int length) {
	GcaDiagnosticFixit* result;
	int i;
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	result = g_new0 (GcaDiagnosticFixit, length);
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	for (i = 0; i < length; i++) {
#line 607 "gca-diagnostic.c"
		GcaDiagnosticFixit _tmp0_ = {0};
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		gca_diagnostic_fixit_copy (&self[i], &_tmp0_);
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		result[i] = _tmp0_;
#line 613 "gca-diagnostic.c"
	}
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	return result;
#line 617 "gca-diagnostic.c"
}


GcaDiagnostic* gca_diagnostic_construct (GType object_type, GcaDiagnosticSeverity severity, GcaSourceRange* location, int location_length1, GcaDiagnosticFixit* fixits, int fixits_length1, const gchar* message) {
	GcaDiagnostic * self = NULL;
	GcaDiagnosticSeverity _tmp0_;
	GcaSourceRange* _tmp1_;
	gint _tmp1__length1;
	GcaSourceRange* _tmp2_;
	gint _tmp2__length1;
	GcaDiagnosticFixit* _tmp3_;
	gint _tmp3__length1;
	GcaDiagnosticFixit* _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
#line 97 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	g_return_val_if_fail (message != NULL, NULL);
#line 97 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self = (GcaDiagnostic*) g_object_new (object_type, NULL);
#line 102 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp0_ = severity;
#line 102 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self->priv->d_severity = _tmp0_;
#line 103 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp1_ = location;
#line 103 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp1__length1 = location_length1;
#line 103 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
#line 103 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp2__length1 = _tmp1__length1;
#line 103 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self->priv->d_location = (g_free (self->priv->d_location), NULL);
#line 103 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self->priv->d_location = _tmp2_;
#line 103 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self->priv->d_location_length1 = _tmp2__length1;
#line 103 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self->priv->_d_location_size_ = self->priv->d_location_length1;
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp3_ = fixits;
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp3__length1 = fixits_length1;
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp4__length1 = _tmp3__length1;
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self->priv->d_fixits = (_vala_GcaDiagnosticFixit_array_free (self->priv->d_fixits, self->priv->d_fixits_length1), NULL);
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self->priv->d_fixits = _tmp4_;
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self->priv->d_fixits_length1 = _tmp4__length1;
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self->priv->_d_fixits_size_ = self->priv->d_fixits_length1;
#line 105 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp5_ = message;
#line 105 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 105 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_g_free0 (self->priv->d_message);
#line 105 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self->priv->d_message = _tmp6_;
#line 97 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	return self;
#line 684 "gca-diagnostic.c"
}


GcaDiagnostic* gca_diagnostic_new (GcaDiagnosticSeverity severity, GcaSourceRange* location, int location_length1, GcaDiagnosticFixit* fixits, int fixits_length1, const gchar* message) {
#line 97 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	return gca_diagnostic_construct (GCA_TYPE_DIAGNOSTIC, severity, location, location_length1, fixits, fixits_length1, message);
#line 691 "gca-diagnostic.c"
}


static gchar* gca_diagnostic_loc_string (GcaDiagnostic* self) {
	gchar* result = NULL;
	GcaSourceRange* _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_ = NULL;
	gchar** r;
	gint r_length1;
	gint _r_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_ = NULL;
#line 136 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 138 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp0_ = self->priv->d_location;
#line 138 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp0__length1 = self->priv->d_location_length1;
#line 138 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp1_ = g_new0 (gchar*, _tmp0__length1 + 1);
#line 138 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	r = _tmp1_;
#line 138 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	r_length1 = _tmp0__length1;
#line 138 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_r_size_ = r_length1;
#line 720 "gca-diagnostic.c"
	{
		gint i;
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		i = 0;
#line 725 "gca-diagnostic.c"
		{
			gboolean _tmp2_;
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			_tmp2_ = TRUE;
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
			while (TRUE) {
#line 732 "gca-diagnostic.c"
				gboolean _tmp3_;
				gint _tmp5_;
				GcaSourceRange* _tmp6_;
				gint _tmp6__length1;
				gchar** _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				GcaSourceRange* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp3_ = _tmp2_;
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				if (!_tmp3_) {
#line 749 "gca-diagnostic.c"
					gint _tmp4_;
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
					_tmp4_ = i;
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
					i = _tmp4_ + 1;
#line 755 "gca-diagnostic.c"
				}
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp2_ = FALSE;
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp5_ = i;
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp6_ = self->priv->d_location;
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp6__length1 = self->priv->d_location_length1;
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				if (!(_tmp5_ < _tmp6__length1)) {
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
					break;
#line 769 "gca-diagnostic.c"
				}
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp7_ = r;
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp7__length1 = r_length1;
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp8_ = i;
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp9_ = self->priv->d_location;
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp9__length1 = self->priv->d_location_length1;
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp10_ = i;
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp11_ = gca_source_range_to_string (&_tmp9_[_tmp10_]);
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_g_free0 (_tmp7_[_tmp8_]);
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp7_[_tmp8_] = _tmp11_;
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
				_tmp12_ = _tmp7_[_tmp8_];
#line 791 "gca-diagnostic.c"
			}
		}
	}
#line 145 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp13_ = r;
#line 145 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp13__length1 = r_length1;
#line 145 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp14_ = g_strjoinv (", ", _tmp13_);
#line 145 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	result = _tmp14_;
#line 145 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	r = (_vala_array_free (r, r_length1, (GDestroyNotify) g_free), NULL);
#line 145 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	return result;
#line 807 "gca-diagnostic.c"
}


gchar* gca_diagnostic_to_markup (GcaDiagnostic* self, gboolean include_severity) {
	gchar* result = NULL;
	gboolean _tmp0_;
#line 148 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 150 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp0_ = include_severity;
#line 150 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	if (_tmp0_) {
#line 820 "gca-diagnostic.c"
		GcaDiagnosticSeverity _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp1_ = self->priv->d_severity;
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp2_ = gca_diagnostic_severity_to_string (_tmp1_);
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp3_ = _tmp2_;
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp4_ = gca_diagnostic_loc_string (self);
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp5_ = _tmp4_;
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp6_ = self->priv->d_message;
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp7_ = g_markup_escape_text (_tmp6_, (gssize) (-1));
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp8_ = _tmp7_;
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp9_ = g_strdup_printf ("<b>%s</b> %s: %s", _tmp3_, _tmp5_, _tmp8_);
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp10_ = _tmp9_;
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_g_free0 (_tmp8_);
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_g_free0 (_tmp5_);
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_g_free0 (_tmp3_);
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		result = _tmp10_;
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		return result;
#line 861 "gca-diagnostic.c"
	} else {
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
#line 158 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp11_ = gca_diagnostic_loc_string (self);
#line 158 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp12_ = _tmp11_;
#line 158 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp13_ = self->priv->d_message;
#line 158 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp14_ = g_markup_escape_text (_tmp13_, (gssize) (-1));
#line 158 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp15_ = _tmp14_;
#line 158 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp16_ = g_strdup_printf ("%s: %s", _tmp12_, _tmp15_);
#line 158 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_tmp17_ = _tmp16_;
#line 158 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_g_free0 (_tmp15_);
#line 158 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		_g_free0 (_tmp12_);
#line 158 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		result = _tmp17_;
#line 158 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		return result;
#line 892 "gca-diagnostic.c"
	}
}


static GcaSourceRange* _vala_array_dup3 (GcaSourceRange* self, int length) {
#line 112 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	return g_memdup (self, length * sizeof (GcaSourceRange));
#line 900 "gca-diagnostic.c"
}


static GcaSourceRange* gca_diagnostic_real_get_ranges (GcaSourceRangeSupport* base, int* result_length1) {
	GcaSourceRange* result;
	GcaDiagnostic* self;
	GcaSourceRange* _tmp0_;
	gint _tmp0__length1;
	GcaSourceRange* _tmp1_;
	gint _tmp1__length1;
	GcaSourceRange* _tmp2_;
	gint _tmp2__length1;
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self = (GcaDiagnostic*) base;
#line 112 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp0_ = self->priv->d_location;
#line 112 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp0__length1 = self->priv->d_location_length1;
#line 112 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 112 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp1__length1 = _tmp0__length1;
#line 112 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp2_ = _tmp1_;
#line 112 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp2__length1 = _tmp1__length1;
#line 112 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	if (result_length1) {
#line 112 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		*result_length1 = _tmp2__length1;
#line 931 "gca-diagnostic.c"
	}
#line 112 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	result = _tmp2_;
#line 112 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	return result;
#line 937 "gca-diagnostic.c"
}


GcaDiagnosticFixit* gca_diagnostic_get_fixits (GcaDiagnostic* self, int* result_length1) {
	GcaDiagnosticFixit* result;
	GcaDiagnosticFixit* _tmp0_;
	gint _tmp0__length1;
	GcaDiagnosticFixit* _tmp1_;
	gint _tmp1__length1;
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp0_ = self->priv->d_fixits;
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp0__length1 = self->priv->d_fixits_length1;
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp1_ = _tmp0_;
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp1__length1 = _tmp0__length1;
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	if (result_length1) {
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		*result_length1 = _tmp1__length1;
#line 961 "gca-diagnostic.c"
	}
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	result = _tmp1_;
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	return result;
#line 967 "gca-diagnostic.c"
}


GcaDiagnosticSeverity gca_diagnostic_get_severity (GcaDiagnostic* self) {
	GcaDiagnosticSeverity result;
	GcaDiagnosticSeverity _tmp0_;
#line 123 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 123 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp0_ = self->priv->d_severity;
#line 123 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	result = _tmp0_;
#line 123 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	return result;
#line 982 "gca-diagnostic.c"
}


const gchar* gca_diagnostic_get_message (GcaDiagnostic* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 128 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 128 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp0_ = self->priv->d_message;
#line 128 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	result = _tmp0_;
#line 128 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	return result;
#line 997 "gca-diagnostic.c"
}


GcaSourceRange* gca_diagnostic_get_location (GcaDiagnostic* self, int* result_length1) {
	GcaSourceRange* result;
	GcaSourceRange* _tmp0_;
	gint _tmp0__length1;
	GcaSourceRange* _tmp1_;
	gint _tmp1__length1;
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp0_ = self->priv->d_location;
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp0__length1 = self->priv->d_location_length1;
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp1_ = _tmp0_;
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp1__length1 = _tmp0__length1;
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	if (result_length1) {
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		*result_length1 = _tmp1__length1;
#line 1021 "gca-diagnostic.c"
	}
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	result = _tmp1_;
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	return result;
#line 1027 "gca-diagnostic.c"
}


void gca_diagnostic_fixit_from_dbus (GcaDBusFixit* fixit, GcaDiagnosticFixit* result) {
	GcaDBusFixit _tmp0_;
	GcaDBusSourceRange _tmp1_;
	GcaSourceRange _tmp2_ = {0};
	GcaDBusFixit _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GcaDiagnosticFixit _tmp6_ = {0};
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	g_return_if_fail (fixit != NULL);
#line 65 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp0_ = *fixit;
#line 65 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp1_ = _tmp0_.location;
#line 65 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	gca_source_range_from_dbus (&_tmp1_, &_tmp2_);
#line 65 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp3_ = *fixit;
#line 65 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp4_ = _tmp3_.replacement;
#line 65 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 65 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	memset (&_tmp6_, 0, sizeof (GcaDiagnosticFixit));
#line 65 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp6_.range = _tmp2_;
#line 65 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_g_free0 (_tmp6_.replacement);
#line 65 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp6_.replacement = _tmp5_;
#line 65 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	*result = _tmp6_;
#line 65 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	return;
#line 1065 "gca-diagnostic.c"
}


void gca_diagnostic_fixit_copy (const GcaDiagnosticFixit* self, GcaDiagnosticFixit* dest) {
	GcaSourceRange _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp0_ = (*self).range;
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	(*dest).range = _tmp0_;
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp1_ = (*self).replacement;
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_g_free0 ((*dest).replacement);
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	(*dest).replacement = _tmp2_;
#line 1085 "gca-diagnostic.c"
}


void gca_diagnostic_fixit_destroy (GcaDiagnosticFixit* self) {
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_g_free0 ((*self).replacement);
#line 1092 "gca-diagnostic.c"
}


GcaDiagnosticFixit* gca_diagnostic_fixit_dup (const GcaDiagnosticFixit* self) {
	GcaDiagnosticFixit* dup;
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	dup = g_new0 (GcaDiagnosticFixit, 1);
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	gca_diagnostic_fixit_copy (self, dup);
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	return dup;
#line 1104 "gca-diagnostic.c"
}


void gca_diagnostic_fixit_free (GcaDiagnosticFixit* self) {
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	gca_diagnostic_fixit_destroy (self);
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	g_free (self);
#line 1113 "gca-diagnostic.c"
}


GType gca_diagnostic_fixit_get_type (void) {
	static volatile gsize gca_diagnostic_fixit_type_id__volatile = 0;
	if (g_once_init_enter (&gca_diagnostic_fixit_type_id__volatile)) {
		GType gca_diagnostic_fixit_type_id;
		gca_diagnostic_fixit_type_id = g_boxed_type_register_static ("GcaDiagnosticFixit", (GBoxedCopyFunc) gca_diagnostic_fixit_dup, (GBoxedFreeFunc) gca_diagnostic_fixit_free);
		g_once_init_leave (&gca_diagnostic_fixit_type_id__volatile, gca_diagnostic_fixit_type_id);
	}
	return gca_diagnostic_fixit_type_id__volatile;
}


static void gca_diagnostic_class_init (GcaDiagnosticClass * klass) {
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	gca_diagnostic_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	g_type_class_add_private (klass, sizeof (GcaDiagnosticPrivate));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gca_diagnostic_get_property;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	G_OBJECT_CLASS (klass)->finalize = gca_diagnostic_finalize;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_DIAGNOSTIC_SEVERITY, g_param_spec_enum ("severity", "severity", "severity", GCA_DIAGNOSTIC_TYPE_SEVERITY, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_DIAGNOSTIC_MESSAGE, g_param_spec_string ("message", "message", "message", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1141 "gca-diagnostic.c"
}


static void gca_diagnostic_gca_source_range_support_interface_init (GcaSourceRangeSupportIface * iface) {
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	gca_diagnostic_gca_source_range_support_parent_iface = g_type_interface_peek_parent (iface);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	iface->get_ranges = gca_diagnostic_real_get_ranges;
#line 1150 "gca-diagnostic.c"
}


static void gca_diagnostic_instance_init (GcaDiagnostic * self) {
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self->priv = GCA_DIAGNOSTIC_GET_PRIVATE (self);
#line 1157 "gca-diagnostic.c"
}


static void gca_diagnostic_finalize (GObject* obj) {
	GcaDiagnostic * self;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCA_TYPE_DIAGNOSTIC, GcaDiagnostic);
#line 73 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self->priv->d_location = (g_free (self->priv->d_location), NULL);
#line 74 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	self->priv->d_fixits = (_vala_GcaDiagnosticFixit_array_free (self->priv->d_fixits, self->priv->d_fixits_length1), NULL);
#line 76 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	_g_free0 (self->priv->d_message);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	G_OBJECT_CLASS (gca_diagnostic_parent_class)->finalize (obj);
#line 1173 "gca-diagnostic.c"
}


GType gca_diagnostic_get_type (void) {
	static volatile gsize gca_diagnostic_type_id__volatile = 0;
	if (g_once_init_enter (&gca_diagnostic_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaDiagnosticClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_diagnostic_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaDiagnostic), 0, (GInstanceInitFunc) gca_diagnostic_instance_init, NULL };
		static const GInterfaceInfo gca_source_range_support_info = { (GInterfaceInitFunc) gca_diagnostic_gca_source_range_support_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gca_diagnostic_type_id;
		gca_diagnostic_type_id = g_type_register_static (G_TYPE_OBJECT, "GcaDiagnostic", &g_define_type_info, 0);
		g_type_add_interface_static (gca_diagnostic_type_id, GCA_TYPE_SOURCE_RANGE_SUPPORT, &gca_source_range_support_info);
		g_once_init_leave (&gca_diagnostic_type_id__volatile, gca_diagnostic_type_id);
	}
	return gca_diagnostic_type_id__volatile;
}


static void _vala_gca_diagnostic_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcaDiagnostic * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GCA_TYPE_DIAGNOSTIC, GcaDiagnostic);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
	switch (property_id) {
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		case GCA_DIAGNOSTIC_SEVERITY:
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		g_value_set_enum (value, gca_diagnostic_get_severity (self));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		break;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		case GCA_DIAGNOSTIC_MESSAGE:
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		g_value_set_string (value, gca_diagnostic_get_message (self));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		break;
#line 1208 "gca-diagnostic.c"
		default:
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostic.vala"
		break;
#line 1214 "gca-diagnostic.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



