#!/usr/bin/env python
"""
/*  GFAX - Gnome fax application
 *  Copyright (C) 2001 George A. Farris
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

This module provides base classes for Glade-derived UIs and their
controllers."""

import os, libglade
from gtk import *
from gnome.ui import *
import gnome.config
from GDK import *
import string

from ui import Ui
from file_handler import *


class Controller(Ui):
	"""Base class for all controllers of glade-derived UIs."""
	def __init__(self):
		Ui.__init__(self)

		self.refresh_focus = 'status'	# which status to show initially
		self.timerId = FALSE			# timer for status refresh period

		# if a filename exists go straight to send page
		if self.filename:
			self.send_ui_show(None)
			
	def change_prefs(self, *args):
		self.prefs.change()
		self.update_status(self.prefs.transmitAgent)

	# if it exists then just update the entry
	def save_gfax_phb(self, name, filename, ftype, isdefault):
		print 'Save gfax phb...'
		n = gnome.config.get_int('gfax/Phonebooks/count') or 0
		for i in range(n):
			ft, na, fn = string.split(
								gnome.config.get_string('gfax/Phonebooks/%d' % i),':')
			if na == name:
				gnome.config.set_string('gfax/Phonebooks/%d' % i, ftype+':'+name+':'+filename)
				if isdefault:
					gnome.config.set_int('gfax/Phonebooks/Default', i)
				gnome.config.sync()
				return
					
		gnome.config.set_string('gfax/Phonebooks/%d' % n, ftype+':'+name+':'+filename)
		if isdefault:
			gnome.config.set_int('gfax/Phonebooks/Default', n)
		gnome.config.set_int('gfax/Phonebooks/count', n+1)
		gnome.config.sync()
		
	def load_gfax_phb(self, filename, ftype):
		print 'Load gfax phb...'
		
		if ftype == 'gfax':
			gfile = GfaxFile()
		elif ftype == 'gcard':
			gfile = GnomecardFile()
		#if ftype == 'evolution':
		#	gfile = EvolutionFile()
		#if ftype == 'ldap':
		#	gfile = LdapFile()
		#if ftype == 'sqldbase':
		#	gfile = DbaseFile()
		
		records = []	
		gfile.open(filename)
		records = gfile.get_records()
		gfile.close()
		del(gfile)
		
		return records

	def save_gfax_phb_items(self, phonebook, items):
		n = gnome.config.get_int('gfax/Phonebooks/count')
		for i in range(n):
			ftype, name, filename = string.split(
								gnome.config.get_string('gfax/Phonebooks/%d' % i),':')
			if name == phonebook:
				break		

		if ftype == 'gfax':
			gfile = GfaxFile()
		elif ftype == 'gcard':
			gfile = GnomecardFile()

		gfile.open(filename)
		gfile.save(phonebook, items)
		gfile.close()
		del(gfile)
			
	# Return the gnomeconfig line in ~./gnome/gfax
	def get_phonebook_index(self, book):
		# Load the phone books in the list
		n = gnome.config.get_int('gfax/Phonebooks/count')
		for i in range(n):
			ftype, name, filename = string.split(
								gnome.config.get_string('gfax/Phonebooks/%d' % i),':')
			if name == book:
				return i
		

	##
	##          JobID  Pri  Status  Owner  Number   Pages  Dials  Time  Error
	##          ----------------------------------------------------------------------------
	##	Sendq ->922    122  S       root   7437868  0:1    5:12   19:53 Busy signal detected
	##	Doneq ->923    122  S       root   7437868  0:1    5:12
	##
	def stat_queue(self, statusType):

		self.appbar('Refreshing status...')
		#while events_pending():
		#	mainiteration()
		mainstatus = self.fax.status('status')			
		resultList = self.fax.status(statusType)
		
		# Main status window at bottom of main window
		# always update this.
		self.status('','clear')
		for line in mainstatus:
			if line != '':
				self.status(line+'\n')

		if len(resultList) > 0:
			if self.refresh_focus == 'sendq':
				self.queList('clear')
				for l in resultList:
					if l == '':
						break
					line = string.split(l)

					arraySize = len(line)

					print 'Sendq status result'
					print line
					
					jid    = line[0]
					stat   = line[2]
					owner  = line[3]
					number = line[4]
					pages  = line[5]
					dials  = line[6]
					if arraySize > 7:
						time   = line[7]
					else:
						time = ''
					if arraySize > 8:
						error  = line[8]
					else:
						error = ''
			
					s = [jid,stat,owner,number,time,pages,dials,error]
					self.queList('clear')
					self.queList('newrow', 0,0,s)
							
			if self.refresh_focus == 'doneq':
				self.queList('clear')
				for l in resultList:
					if l == '':
						break
					line = string.split(l)

					print 'Doneq status result'
					print line
					
					jid    = line[0]
					stat   = line[2]
					owner  = line[3]
					number = line[4]
					pages  = line[5]
					dials  = line[6]
					time   = ' '
					if len(line) > 7:
						error = line[7]
					else:
						error  = ' '

					s = [jid,stat,owner,number,time,pages,dials,error]
					self.queList('newrow', 0,0,s)
				
		self.appbar('')		
		return TRUE
	

	def destroy(self, *args):
		print "Closing..."
		try:
			os.unlink(self.filename)
		except:
			pass
		mainquit()

	def cleanup_exit(self):
		try:
			os.unlink(self.filename)
		except:
			pass
		sys.exit(1)

if __name__ == "__main__":
    main()

