#!/usr/bin/env python
"""
/*  GFAX - Gnome fax application
 *  Copyright (C) 2001 George A. Farris
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
"""

#from gtk import *
from gnome.ui import GnomeRequestDialog
import gtk
import os
import string,sys
from socket import *
from hfaxlib import *
import libglade


#Mgetty data for Optionmenus
mgBps = ["115200","57600","38400","19200","9600","4800","2400"]
mgBpsSwitch = ["None","115200","57600","38400","19200","9600","4800","2400"]
mgCarrier = ["Y","N"]
mgMtc = ["Y","N"]
mgType = ['auto', 'cls2', 'c2.0']


#**************************************************************************
# Hylafax class
#
# Hylafax is a network fax server package and has many clients under both 
# Linux and Windows.  
#
#--------------------------------------------------------------------------
class hylafax:
	def __init__(self, prefs):
		# Create a new instance of the library class
		self.hyi = hfax()
		self.prefs = prefs		
		
		# set the queues available for refresh in the main tree display
		# this is different for mgetty or efax
		self.queue = {0: 'status', 1 : 'sendq', 2 : 'doneq', 3 : 'recvq' }
		
		print 'Hylafax init'

		# If the username is null then hylafax doesn't need usernames
		if self.prefs.serverUsername == '':
			self.password = ''
		else:
			d = GnomeRequestDialog(1,\
					'Current Hylafax server is:\n\n'+self.prefs.serverHost+'\n\nPlease enter your password:',None,32,self.set_password, None)
			d.run()


	def set_password(self, data):
		self.password = data

	## Method send(numberList, filename)
	##
	##	itemList is a list that can hold more than one phone number
	##
	def send(self, itemList, filename):
		
		try:
			win = libglade.GladeXML(self.prefs.file_path + '/gfax.glade', 'hylafaxProgressbarDialog')
		except:
			print "Can't open interface description file (gfax.glade)"
		
		app = win.get_widget('hylafaxProgressbarDialog')
		pb = win.get_widget('hylafaxProgressbar')
		
		dic={}		
		dic['hylafaxProgressbarCancelButton_clicked'] = self.fax_cancel
		
		win.signal_autoconnect(dic)
		
		#app.run()

		# If the username is null then hylafax doesn't need usernames
		self.hyi.connect(self.prefs.serverHost, self.prefs.serverUsername, self.password)

		infile, outfile, reply = self.hyi.storefile_open(filename)			

		print "[hylafax] storing file"
		
		# figure out how many lines in the file
		nolines = 0
		while 1:
			dump = infile.readline()
			if not dump:
				infile.seek(0)	#rewind file
				break
			nolines = nolines + 1

		
		percent = float(0)
		linesleft = float(1)
		while 1:
			line=infile.readline()
			if not line: break
			outfile.write(line)
			gtk.mainiteration(0)
			linesleft = linesleft + 1
			percent = linesleft / float(nolines)
			self.update(percent, pb)
			
		sf = self.hyi.storefile_close(infile, reply)
		
		
		for item in itemList:			#item[0] is the number
			jid = self.hyi.job_new()	#item[1] is the name
										#item[2] is the company 
			#if debug is set:
			#	self.hyi.setdebuginfo(2,'./logfile.log')
				
			self.hyi.job_param_set('FROMUSER', 'George Farris')
			self.hyi.job_param_set('LASTTIME', '000259')
			self.hyi.job_param_set('MAXDIALS', '12')
			self.hyi.job_param_set('MAXTRIES', '3')		
			self.hyi.job_param_set('SCHEDPRI', '127')		
			self.hyi.job_param_set('DIALSTRING', item[0])
			self.hyi.job_param_set('NOTIFYADDR', self.prefs.emailAddress)
			self.hyi.job_param_set('VRES', '98')		
			self.hyi.job_param_set('PAGEWIDTH', '215')
			self.hyi.job_param_set('PAGELENGTH', '279')
			self.hyi.job_param_set('NOTIFY', 'none')
			self.hyi.job_param_set('PAGECHOP', 'default')
			self.hyi.job_param_set('CHOPTHRESHOLD', '3')		
			self.hyi.job_param_set('DOCUMENT', sf)		
			self.hyi.submitjob()

		self.hyi.close()
		
		app.destroy()	# close progress bar
				
		return ''
	
	def cancel(self):
		pass
		
	## Method status(queue)
	##
	##	queue is the queue directory of the hylafax server it can be one of:
	##	'status', 'sendq', 'doneq' or 'recvq'
	##
	## Return a list containing lines	
	def status(self, queue):
		if self.hyi.connect(self.prefs.serverHost, self.prefs.serverUsername, self.password) > 0:
			return 'error'

		s = string.split(self.hyi.getfolder(queue), '\015\012')
		self.hyi.close()
		return s
		
		
	def update(self, percent, pb):
		pb.update(percent)
		#return(1)
	
	def fax_cancel(self, button):
		pass
		
	def receive(self):
		pass
		
						
#**************************************************************************
# mgetty class
#
#
#
#
#
#--------------------------------------------------------------------------
class mgetty:
	def __init__(self, prefs):
		self.prefs = prefs

	def send(self, itemList, filename):
		for item in itemList:	#item[0] is the number
								#item[1] is the name
								#item[2] is the company 

			command = 'faxspool'	#program to execute

			#set the resolution, true is fine res
			if not self.prefs.resolution_state:
				command = command + ' -n'
			if self.prefs.coverPage_state:
				command = command + ' -C /usr/lib/mgetty+sendfax/make.coverpg'
			else:
				command = command + ' -C -'

			#set the email address for notification
			if self.prefs.emailNotify_state:
            	#if len(self.emailAddress) <= 1):
                #    return(NO_EMAIL_ADDRESS)
				command = command + ' -f '+ self.prefs.emailAddress

			#set the verbose destination for return mail and @D@ on each page
			#if len() > 1):
			#	command = command + ' -D ' + dest->organization

			#set time to send fax only if not send immediate
			if not self.prefs.sendNow_state:
				command = command + ' -t ' + hour + ':' + minute

			#set the phone number to send to.  First we want to strip all the spaces
			#out of the number 
			tmpnum = ' '
			for i in item[0]:
				if i == ' ':
					continue
				else:
					tmpnum = tmpnum + i
			
			number = self.prefs.phonePrefix + tmpnum

			#tack the filename onto the end
			command = command + number + ' ' + filename
			
			#at this point we will let faxspool do the rest of the sanity checking
			#more and better checking will be done in the future.

			return command
			
	
	def cancel(self):
		pass
		
	def status(self, queue):
		return ''
		
	def receive(self):
		pass


#**************************************************************************
# efax class
#
#
#
#
#
#--------------------------------------------------------------------------
class efax:
	def __init__(self, prefs):
		self.prefs = prefs

	def send(self, itemList, filename):

		for item in itemList:	#item[0] is the number
								#item[1] is the name
								#item[2] is the company 

			command = 'fax send'	#program to execute

			#set the resolution, true is fine res
			if not self.prefs.resolution_state:
				command = command + ' -l'

			#set the phone number to send to.  First we want to strip all the spaces
			#out of the number 
			tmpnum = ' '
			for i in item[0]:
				if i == ' ':
					continue
				else:
					tmpnum = tmpnum + i
			
			number = self.prefs.phonePrefix + tmpnum

			#tack the filename onto the end
			command = command + number + ' ' + filename
			
			# We should now open a spooling tab and show the results of the fax actually
			# being sent.  For now just spit it out on the console.
			
			#print command
			return command

	
	def cancel(self):
		pass
		
	def status(self, queue):
		return ''
		
	def receive(self):
		pass


#----------------------------- MAIN ----------------------------------------------
if __name__=="__main__":
	pass	
	
	
"""
	host = 'localhost'

	if len(sys.argv)>1:
		listdir=sys.argv[1]
	else:
		listdir="sendq"

	# Create hylafax instance
	hyi = hfax()
	hyi.connect(host,"george","linux")

	print hyi.getfolder(listdir)

	fn = hyi.storefile('/home/george/hyi.ps')
	print fn
	jid = hyi.job_new()
	print jid
	hyi.setdebuginfo(2,'./logfile.log')
	hyi.job_param_set('FROMUSER', 'George Farris')
	hyi.job_param_set('LASTTIME', '000259')
	hyi.job_param_set('MAXDIALS', '12')
	hyi.job_param_set('MAXTRIES', '3')		
	hyi.job_param_set('SCHEDPRI', '127')		
	hyi.job_param_set('DIALSTRING', '555-1212')
	hyi.job_param_set('NOTIFYADDR', 'george')
	hyi.job_param_set('VRES', '98')		
	hyi.job_param_set('PAGEWIDTH', '215')
	hyi.job_param_set('PAGELENGTH', '279')
	hyi.job_param_set('NOTIFY', 'none')
	hyi.job_param_set('PAGECHOP', 'default')
	hyi.job_param_set('CHOPTHRESHOLD', '3')		
	hyi.job_param_set('DOCUMENT', fn)		
	hyi.submitjob()

	hyi.close()

"""
