#!/usr/bin/env python
"""
/*  GFAX - Gnome fax application
 *  Copyright (C) 2001 George A. Farris
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
"""

import os
import os.path
import gnome.ui
import gnome.config
import string


class GfileHandler:
				
	def open(self, filename):

		if os.path.exists(filename):
			try:
				self.fp = open(filename, 'r+')
			except:
				print "Can't open file..."
		else:
			try:
				print 'Creating file'
				self.fp = open(filename, 'w')
			except:
				print "Can't create file..."

	def close(self):
		self.fp.close()

		
class GfaxFile(GfileHandler):		

	def get_records(self):
		records = []

		while 1:
			line = string.lstrip(self.fp.readline())
			if not line:	#eof
				break

			if line == '<item>\n':
				# get number
				line = string.lstrip(self.fp.readline())
				i1 = string.find(line, '<number>')
				i2 = string.find(line, '</number>')
				num = line[i1+8:i2]

				# get name
				line = string.lstrip(self.fp.readline())
				i1 = string.find(line, '<name>')
				i2 = string.find(line, '</name>')
				name = line[i1+6:i2]

				# get company
				line = string.lstrip(self.fp.readline())
				i1 = string.find(line, '<company>')
				i2 = string.find(line, '</company>')
				com = line[i1+9:i2]
			
				records.append([num,name,com])

		return records				


	def save(self, phonebook, items):
	
		self.fp.write('<')
		self.fp.write(phonebook)
		self.fp.write('>\n')

		for item in items:
			self.fp.write('\t<item>\n')
			
			self.fp.write('\t\t<number>')
			self.fp.write(item[0])
			self.fp.write('</number>\n')
			
			self.fp.write('\t\t<name>')
			self.fp.write(item[1])
			self.fp.write('</name>\n')

			self.fp.write('\t\t<company>')
			self.fp.write(item[2])
			self.fp.write('</company>\n')

			self.fp.write('\t</item>\n')

		self.fp.write('</')
		self.fp.write(phonebook)
		self.fp.write('>\n')


class GnomecardFile(GfileHandler):		

	def get_records(self):
		records = []
		
		isfax = None
		com = None
		name = None
		
		while 1:
			line = self.fp.readline()
			if not line:	#eof
				break

			if line != '\n':
				line = string.lstrip(line)
				
			if line[0:11] == 'BEGIN:VCARD':
				continue	
			if line[0:8] == 'TEL;FAX:':
				# get number
				num = string.rstrip(line[8:])
				isfax = 1
			if line[0:2] == 'N:':
				# get name
				name = line[2:]
			if line[0:4] == 'ORG:':
				# get company
				com = string.rstrip(line[4:])

			if line[0:9] == 'END:VCARD':
				if isfax:
					if com == None:
						com = ''
						
					# change name from "last;first" to "first last"
					seperator = string.find(name, ';')
					newname = string.rstrip(name[seperator+1:])+' '+name[0:seperator]
					records.append([num,newname,com])
					isfax = None
					name = ''
					com = ''
					
		return records				


	def save(self, phonebook, items):
		m = gnome.ui.GnomeWarningDialog('Saving Gnomecard files is not implemented yet\n \
								please use Gnomecard to add or edit items.')
		m.run()
		return
		
		rec = []
		newfile = []
		tmpfile = []
		index = 0
		
		# get all the records into a list of lists
		while 1:
			line = self.fp.readline()
			if not line:	#eof
				break

			if line != '\n':
				line = string.lstrip(line)

			if line[0:11] == 'BEGIN:VCARD':
				rec.append(line)
			
				while line[0:9] != 'END:VCARD':
					line = self.fp.readline()
					rec.append(line)

				tmpfile.append(rec)				
				rec = []
				

		#reset the file pointer
		self.fp.seek(0)	
		
		
		# Write all records that aren't 'TEL;FAX' entries
		for rec in tmpfile:
			isfax = 0
			for s in rec:
				if string.find(s, 'TEL;FAX:') != -1:
					isfax = 1
			if isfax == 0:
				newfile.append(rec)
		for rec in newfile:
			for s in rec:
				#self.fp.write(string.rstrip(s)) #chop \012\015
				self.fp.write('\n')
			self.fp.write('\n')

		return
					
		# Write all TEL;FAX: records
		for item in items:
			self.fp.write('BEGIN:VCARD\n')	# start of vcard
			self.fp.write('N:')				# name record
			fname,lname = string.split(item[1])
			self.fp.write(lname)			# change name record
			self.fp.write(';')
			self.fp.write(fname)
			self.fp.write('\n')

			self.fp.write('TEL;FAX:')
			self.fp.write(string.rstrip(item[0]))
			self.fp.write('\n')
			
			self.fp.write('ORG:')
			self.fp.write(string.rstrip(item[2]))
			self.fp.write('\n')			
			
			self.fp.write('END:VCARD\n\n')

				

