#!/usr/bin/env python
"""
/*  GFAX - Gnome fax application
 *  Copyright (C) 2001 George A. Farris
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
"""

import sys

sys.path.append('/usr/lib/gfax')

# System imports
from gtk import *
from gnome.ui import *
import select
import tempfile

# gfax imports
from prefs import *
from ui import *
from controller import *
from fax import *

HYLAFAX_ERROR="Cannot connect to fax server...\nPlease check the preferences for the \
correct hostname."


#def main():
	
class Gfax(Controller):


	def __init__(self, filename):
		self.filename = filename
		
		print filename
		# Get preferences
		self.prefs = Preferences()
		
		if self.prefs.transmitAgent == "hylafax":
			# Make a fax instance
			self.fax = hylafax(self.prefs)
		if self.prefs.transmitAgent == "mgetty":
			self.fax = mgetty(self.prefs)
		if self.prefs.transmitAgent == "efax":
			self.fax = efax(self.prefs)

		Controller.__init__(self)


	## Method update_status(transmitAgent)
	##
	##	Update the tree and status widgets
	##
	def update_status(self, transmitAgent):

		if transmitAgent == "hylafax":
			#s = self.fax_server_status(self.prefs.serverHost, self.fax, 'status')
			str_result = self.fax.status('status') 
			if  str_result == 'error' :
				self.status(HYLAFAX_ERROR, 'clear')
			else:	
				self.status('','clear')
				for line in str_result:
					if line != '':
						self.status(line+'\n')
				self.queTree('update')
	
		if transmitAgent == "mgetty":
			self.queTree('clear')
			self.status('Configured transmit agent is the Mgetty+Sendfax system.', 'clear')

		if transmitAgent == "efax":
			self.queTree('clear')
			self.status('Configured transmit agent is the Efax system.', 'clear')


if __name__ == '__main__': 
	print 'Starting.....'
	
	filename = ''
	
	r = select.select([0],[],[],0)
	
	if len(sys.argv) > 1:
		# we have a file name on the command line
		filename = sys.argv[1]
	elif r[0]:
		# If we have file piped in
		tempfile.tempdir = '/tmp'
		filename = tempfile.mktemp('.gfax')
		i = sys.stdin.read()
		f = open(filename, 'w')
		f.write(i)
		n = f.tell()		
		f.close()

		# if file size is 0 we were started from gnome menu????
		if n == 0:			
			os.unlink(filename)
			filename = ''


	# if we have a file on the command line
	#if len(sys.argv) == 2:
	#	filename = argv[1]
	
	g = Gfax(filename)
	try:
		g.update_status(g.prefs.transmitAgent)
	except:
		pass	# put warning here
	g.appbar('Not Configured yet...')
	mainloop()
