#!/usr/bin/env python

# Author: Harald Holzer (harald.holzer@eunet.at)
# 5.4.2000: Initial release

# 6.5.2000: Harald Holzer (harald.holzer@eunet.at)
#	added logging support

# 13.6.2000: Added patch, for job_new. jobids now returned correctly.
#	Patch supplied by Victor M. Moreno (vmoreno@geminus.com)

# 13.12.2001: Added patch to split up storing of file so we will have
#	status of percent file stored.  George Farris george@gmsys.com

import string,sys
from socket import *


class hfax:
	s=None
	sf=None
	d=None
	df=None
	user=""
	pw=""
	host=""
	port=4559
	debuglevel=0
	logfile="/tmp/gfax-hfax.log"

	def readline(self):
		data=self.sf.readline()
		self.loginfo("read: " + data)
		return data
	
	def writeline(self,line):
		self.loginfo("write: " + line)
		self.s.send(line)
	
	def connect(self,host,user,pw):
		self.host=host
		self.user=user
		self.pw=pw
		self.s=socket(AF_INET,SOCK_STREAM)
		
		try:
			self.s.connect(host,self.port)
			self.sf = self.s.makefile("rw")
			line = self.readline()
			self.writeline("USER " + user + "\n")
			line = self.readline()
			if line[:3]=="230":
				rc = 0
			else:
				rc = 1
			print "[hylafax] opening connection"
		except error,detail:
			self.loginfo("error: " + str(detail))
			rc=2
		return rc
	
	def job_new(self):
		self.writeline("JOB default\n")
		self.readline()
		self.writeline("JNEW\n")
		data=self.readline()
		#Victor: 200 NEW job created jobid: 2 groupid: 2.
		jobid=string.atoi(data[string.find(data,"jobid:")+6:string.find(data,"groupid:")])
		return jobid

	def job_select(self,jobid):
		self.writeline("JOB " + str(jobid) + "\n")
		self.readline()

	def job_kill(self):
		self.writeline("JKILL\n")
		self.readline()

	def job_delete(self):
		self.writeline("JDELE\n")
		self.readline()
	
	def job_param_getall(self):
		self.writeline("JPARM\n")
		self.readline()
		data=""
		while 1:
			line=self.readline()
			if line[:4]=="217 ": break
			data=data + line
		return data
	
	def	job_param_get(self,pname):
		self.writeline("JPARM " + pname + "\n")
		data=""
		while 1:
			line = self.readline()
			data = data + line[4:]
			if line[3]==" ": break
		return string.strip(data)
	
	def job_param_set(self,pname,pvalue):
		self.writeline("JPARM " + pname + " " + pvalue +"\n")
		self.readline()	

	def getfolder(self,folder):
		self.writeline("PASV\n")
		data = self.readline()
		
		data=data[string.find(data,"(")+1:string.find(data,")")]
		a1,a2,a3,a4,p1,p2=string.split(data,",")
		addr=a1 + "." + a2 + "." + a3 + "." + a4
		port=string.atoi(p1)*256 + string.atoi(p2)
		self.d=socket(AF_INET,SOCK_STREAM)
		self.d.connect(addr,port)
		self.df=self.d.makefile()
		self.writeline("list "+folder+"\n")
		fdata=""
		while 1:
			line=self.df.readline()
			if not line: break
			fdata=fdata + line
		self.df.close()
		self.d.close()
		self.readline()
		self.readline()
		return fdata

	def storefile_open(self,filename):
		self.loginfo("filename: " + filename)
		self.writeline("PASV\n")
		data=self.readline()
		#print data
		data=data[string.find(data,"(")+1:string.find(data,")")]
		a1,a2,a3,a4,p1,p2=string.split(data,",")
		addr=a1 + "." + a2 + "." + a3 + "." + a4
		port=string.atoi(p1)*256 + string.atoi(p2)
		self.d=socket(AF_INET,SOCK_STREAM)
		self.d.connect(addr,port)
		self.df=self.d.makefile("w")
		self.writeline("STOT\n")
		reply=self.readline()
		sfile=open(filename,"r")
		return sfile, self.df, reply

	def storefile_close(self, infile, reply):
		infile.close()
		self.df.close()
		self.d.close()
		self.readline()
		filename=string.split(reply," ")[2]
		return filename

	def retrfile(self,filename,tmpfilename):
		self.writeline("PASV\n")
		data=self.readline()
		#print data
		data=data[string.find(data,"(")+1:string.find(data,")")]
		a1,a2,a3,a4,p1,p2=string.split(data,",")
		addr=a1 + "." + a2 + "." + a3 + "." + a4
		port=string.atoi(p1) * 256 + string.atoi(p2)
		self.d=socket(AF_INET,SOCK_STREAM)
		self.d.connect(addr,port)
		self.df=self.d.makefile("rb")
	
		self.writeline("RETR " + filename + "\n")
		reply=self.readline()
		sfile=open(tmpfilename,"wb")
		line=self.df.read()
		#while 1:
		#	line=self.df.readline()
		#	if not line: break
		#	sfile.write(line)
		sfile.write(line)
		sfile.close()
		self.df.close()
		self.d.close()
		self.readline()
		return reply
    		
	def deletefile(self,name):
		self.writeline("DELE " + name + "\n")
		self.readline()

	def jobparam(self,param):
		self.writeline("JPARM " + param+"\n")
		self.readline()
	
	def submitjob(self):
		self.writeline("JSUBM\n")
		self.readline()
	
	def docmd(self,cmd):
		self.writeline(cmd+"\n")
		self.readline()
	
	def close(self):
		print "[hylafax] closing connection"
		self.sf.close()
		self.s.close()

	def setdebuginfo(self,dbglevel,logfile):
		self.debuglevel=dbglevel
		self.logfile=logfile
	
	def loginfo(self,info):
		if self.debuglevel>0:
			f = open(self.logfile,"a")
			f.write(info+"\r\n")
			f.close
	
# ---------------- Main function -----------------------------------

if __name__=="__main__":
	
	host   = 'raven'
	user   = 'george'
	passwd = 'linux'
	
	if len(sys.argv)>1:
		listdir=sys.argv[1]
	else:
		listdir="sendq"

	test = hfax()
	test.connect(host,user,passwd)

	print test.getfolder(listdir)

	print "[hylafax] storing file"

	infile, outfile, reply = test.storefile_open('./test.ps')			
	while 1:
		line=infile.readline()
		if not line: break
		outfile.write(line)

	fn = test.storefile_close(infile, reply)

	print fn
	jid = test.job_new()
	print jid
	test.setdebuginfo(2,'./hfaxlib.log')
	test.job_param_set('FROMUSER', 'John Doe')
	test.job_param_set('LASTTIME', '000259')
	test.job_param_set('MAXDIALS', '12')
	test.job_param_set('MAXTRIES', '3')		
	test.job_param_set('SCHEDPRI', '127')		
	test.job_param_set('DIALSTRING', '555-1212')
	test.job_param_set('NOTIFYADDR', 'george')
	test.job_param_set('VRES', '98')		
	test.job_param_set('PAGEWIDTH', '215')
	test.job_param_set('PAGELENGTH', '279')
	test.job_param_set('NOTIFY', 'none')
	test.job_param_set('PAGECHOP', 'default')
	test.job_param_set('CHOPTHRESHOLD', '3')		
	test.job_param_set('DOCUMENT', fn)		
	test.submitjob()

	test.close()
