"""
*  GFAX - Gnome fax application
*  Copyright (C) 2001 George A. Farris
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
"""

## System modules
from gtk import *
from gnome.ui import *
from gnome.config import *
from posixpath import split
import os, glob
from prefs_ui import *
import string

# This is used by gnome_config
GLOBALCONFIG='=/usr/share/gfax/Config='

#Mgetty data for Optionmenus, used to write the sendfax config file
mgBps = ["115200","57600","38400","19200","9600","4800","2400"]
mgBpsSwitch = ["None","115200","57600","38400","19200","9600","4800","2400"]
mgCarrier = ["Y","N"]
mgMtc = ["Y","N"]
mgType = ['auto', 'cls2', 'c2.0']

#Efax data for Optionmenus, used to write the efax config file
efaxPage = ['letter', 'legal', 'a4']

##
##
## Preferences class
##
##
class Preferences(Preferences_Ui):
    ##
    ## Method __init__ (self)
    ##
    ##    Constructor for preferences class.
    ##
    ##
	def __init__(self):
	
		# where we find all the .glade files etc.
		#self.file_path = "/home/george/work/Python/gfax"
		self.file_path = "/usr/lib/gfax"
		
		if not has_section('gfax/Settings'):
			self.firsttime_setup()

		# Load all the prefs
		self.version = "0.5"

		# Get Main settings
		self.phonePrefix = get_string('gfax/Settings/PhonePrefix') or ''
		self.ourFaxNumber = get_string('gfax/Settings/OurFaxNumber') or ''
		self.emailAddress = get_string('gfax/Settings/EmailAddress') or ''			
		self.transmitAgent = get_string('gfax/Settings/TransmitAgent') or "mgetty"

		self.sendNow_state = get_bool('gfax/Settings/SendNow')
		self.emailNotify_state = get_bool('gfax/Settings/EmailNotify')
		self.coverPage_state = get_bool('gfax/Settings/CoverPage')
		self.resolution_state = get_bool('gfax/Settings/Resolution')

		# Hylafax related settings
		self.serverHost = get_string('gfax/Hylafax/ServerHost') or "localhost"
		self.serverPort = get_int('gfax/Hylafax/ServerPort') or 4559
		self.serverUsername = get_string('gfax/Hylafax/Username') or ""

		# Mgetty related settings
		self.mgModemInit = get_string(GLOBALCONFIG + '/Mgetty/ModemInit') or "ATZ"
		self.mgModemHandshake = get_string(GLOBALCONFIG + '/Mgetty/ModemHandshake') or ""
		self.mgModemQuirks = get_string(GLOBALCONFIG + '/Mgetty/ModemQuirks') or ""
		self.mgConfigFile = get_string(GLOBALCONFIG + '/Mgetty/ConfigFile') or "/etc/mgetty+sendfax/sendfax.config"
		self.mgDialCommand = get_string(GLOBALCONFIG + '/Mgetty/ModemDialCommand') or "ATDT"
		self.mgModemPort = get_string(GLOBALCONFIG + '/Mgetty/FaxDevices') or 'modem'

		self.mgModemType = get_int(GLOBALCONFIG + '/Mgetty/ModemType') or 0
		self.mgOpenDelay = get_int(GLOBALCONFIG + '/Mgetty/OpenDelay') or 0
		self.mgModemSpeed = get_int(GLOBALCONFIG + '/Mgetty/PortSpeed') or 0
		self.mgModemSwitchSpeed = get_int(GLOBALCONFIG + '/Mgetty/SwitchPortSpeed') or 0
		self.mgDebugLevel = get_int(GLOBALCONFIG + '/Mgetty/DebugLevel') or 0
		self.mgMaxTries = get_int(GLOBALCONFIG + '/Mgetty/MaxTries') or 0
		self.mgIgnoreCarrier = get_int(GLOBALCONFIG + '/Mgetty/IgnoreCarrier') or 0
		self.mgMaxTriesCont = get_int(GLOBALCONFIG + '/Mgetty/MaxTriesContinue') or 0
		self.mgQueuePeriod = get_int(GLOBALCONFIG + 'Mgetty/RunQueuePeriod') or 0

		# get the fax.allow and fax.deny file contents from the sendfax system
		mgPath = os.path.dirname(self.mgConfigFile)
		if os.path.isfile(os.path.join(mgPath, 'fax.allow')):
			fp = open(os.path.join(mgPath, 'fax.allow'), 'r')
			self.mgAllowedUsers = fp.read()
			fp.close()
		else:
			self.mgAllowedUsers = ''
						
		if os.path.isfile(os.path.join(mgPath, 'fax.deny')):
			fp = open(os.path.join(mgPath, 'fax.deny'), 'r')
			self.mgDeniedUsers = fp.read()
			fp.close()
		else:
			self.mgDeniedUsers = ''		
		
		# Efax related settings
		self.efaxModemHandshake = get_string(GLOBALCONFIG + '/Efax/ModemHandshake') or "FCINIT=''"
		self.efaxConfigFile = get_string(GLOBALCONFIG + '/Efax/ConfigFile') or "/etc/efax.rc"
		self.efaxModemLockFile = get_string(GLOBALCONFIG + '/Efax/LockFile') or "'-x /var/lock/LCK..$DEV'"
		self.efaxModemPort = get_string(GLOBALCONFIG + '/Efax/ModemPort') or "modem"		
		self.efaxPageSize = get_int(GLOBALCONFIG + '/Efax/PageSize') or 0		


	## Method change(self)
	##
	## Called from main controller when "Preferences" button hit
	## 
	def change(self):
		self.prefs_dialog()


    ## Method save(self)
    ##
    ##    Save the current configuration.
    ##
	def save(self):
		set_string('gfax/Settings/file_path', self.file_path)

		# Main settings
		set_bool('gfax/Settings/SendNow', self.sendNow_state)
		set_bool('gfax/Settings/EmailNotify', self.emailNotify_state)
		set_bool('gfax/Settings/CoverPage', self.coverPage_state)
		set_bool('gfax/Settings/Resolution', self.resolution_state)
		set_string('gfax/Settings/EmailAddress', self.emailAddress)
		set_string('gfax/Settings/PhonePrefix', self.phonePrefix)
		set_string('gfax/Settings/OurFaxNumber', self.ourFaxNumber)
		set_string('gfax/Settings/TransmitAgent', self.transmitAgent)


		# Hylafax settings
		if self.transmitAgent == "hylafax" and self.hylafaxPrefsChanged == 1:
			set_string('gfax/Hylafax/ServerHost', self.serverHost)
		 	set_int('gfax/Hylafax/ServerPort', self.serverPort)
			set_string('gfax/Hylafax/Username', self.serverUsername)
		
		# Mgetty Settings
		if self.transmitAgent == "mgetty" and self.mgettyPrefsChanged == 1:
			set_string(GLOBALCONFIG + 'Mgetty/ModemInit', self.mgModemInit)
			set_string(GLOBALCONFIG + 'Mgetty/ModemHandshake', self.mgModemHandshake)
			set_string(GLOBALCONFIG + 'Mgetty/ModemQuirks', self.mgModemQuirks)
			set_string(GLOBALCONFIG + 'Mgetty/ConfigFile', self.mgConfigFile)
			set_string(GLOBALCONFIG + 'Mgetty/ModemDialCommand',   self.mgDialCommand)
			set_string(GLOBALCONFIG + 'Mgetty/FaxDevices', self.mgModemPort)

			set_int(GLOBALCONFIG + 'Mgetty/ModemType', self.mgModemType)
			set_int(GLOBALCONFIG + 'Mgetty/OpenDelay', self.mgOpenDelay)
			set_int(GLOBALCONFIG + 'Mgetty/PortSpeed', self.mgModemSpeed)
			set_int(GLOBALCONFIG + 'Mgetty/SwitchPortSpeed', self.mgModemSwitchSpeed)
			set_int(GLOBALCONFIG + 'Mgetty/DebugLevel', self.mgDebugLevel)
			set_int(GLOBALCONFIG + 'Mgetty/MaxTries', self.mgMaxTries)
			set_int(GLOBALCONFIG + 'Mgetty/IgnoreCarrier', self.mgIgnoreCarrier)
			set_int(GLOBALCONFIG + 'Mgetty/MaxTriesContinue', self.mgMaxTriesCont)
			set_int(GLOBALCONFIG + 'Mgetty/RunQueuePeriod', self.mgQueuePeriod)


			# Write out the config file that mgetty+sendfax uses.
			self.write_sendfax_config()
			
	
		# Efax Settings
		if self.transmitAgent == "efax" and self.efaxPrefsChanged == 1:
			set_string(GLOBALCONFIG + '/Efax/ModemHandshake', self.efaxModemHandshake)
			set_string(GLOBALCONFIG + '/Efax/ConfigFile', self.efaxConfigFile)
			set_string(GLOBALCONFIG + '/Efax/LockFile', self.efaxModemLockFile)
			set_string(GLOBALCONFIG + '/Efax/ModemPort', self.efaxModemPort)
			set_int(GLOBALCONFIG + '/Efax/PageSize', self.efaxPageSize)
			
			self.write_efax_config()
			

		sync()


	## Method write_sendfax_config(self)
	##
	## Called when Mgetty preferences are saved.
	## 
	def write_sendfax_config(self):
		try:
			fp = open(self.mgConfigFile, 'w')
		except:
			print 'I can\'t open the sendfax config file.'
			return;

		fp.write("\
#Sendfax.config\n\
#\n\
#This file has beed created by GFax.  It will be over written\n\
#every time Gfax's mgetty setup is changed.\n\
#\n")

		fp.write('modem-init ' + self.mgModemInit + '\n')
		fp.write('modem-handshake ' + self.mgModemHandshake + '\n')
		fp.write('modem-quirks ' + self.mgModemQuirks + '\n')
		fp.write('fax-devices ' + self.mgModemPort + '\n')
		fp.write('speed ' + mgBps[self.mgModemSpeed] + '\n')
		fp.write('switchbd ' + mgBpsSwitch[self.mgModemSwitchSpeed] + '\n')
		fp.write('modem-type ' + mgType[self.mgModemType] + '\n')
		fp.write('ignore-carrier ' + mgCarrier[self.mgIgnoreCarrier] + '\n')
		fp.write('max-tries %d\n' % self.mgMaxTries)
		fp.write('max-tries-continue ' + mgMtc[self.mgMaxTriesCont] + '\n'); 				 
		fp.write('dial-prefix ' + self.mgDialCommand + '\n');
		fp.write('debug-level %d\n' % self.mgDebugLevel)				 
		fp.write('open-delay %d\n' % (self.mgOpenDelay * 500))

		fp.close()

		
		if self.mgQueuePeriod == 0:		#delete it
			self.append_crontab_entry(None)
		if self.mgQueuePeriod == 1:		#every minute
			self.append_crontab_entry("* * * * * root /usr/bin/faxrunq\n")
		if self.mgQueuePeriod == 2:		#every 5 minutes
			self.append_crontab_entry("*/5 * * * * root /usr/bin/faxrunq\n")
		if self.mgQueuePeriod == 3:		#every 10 minutes
			self.append_crontab_entry("*/10 * * * * root /usr/bin/faxrunq\n")
		if self.mgQueuePeriod == 4:		#every 15 minutes
			self.append_crontab_entry("*/15 * * * * root /usr/bin/faxrunq\n")
		if self.mgQueuePeriod == 5:		#every 30 minutes
			self.append_crontab_entry("*/30 * * * * root /usr/bin/faxrunq\n")
		if self.mgQueuePeriod == 6:		#every hour
			self.append_crontab_entry("1 * * * * root /usr/bin/faxrunq\n")

		# lets write the fax.allow file
		if len(self.mgAllowedUsers) >= 2:
			fp = open(os.path.join(os.path.dirname(self.mgConfigFile), 'fax.allow'), 'w')
			fp.write(self.mgAllowedUsers)
			fp.close()

		# and the fax.deny file	
		if len(self.mgDeniedUsers) >= 2:
			fp = open(os.path.join(os.path.dirname(self.mgConfigFile), 'fax.deny'), 'w')
			fp.write(self.mgDeniedUsers)
			fp.close()
		

	## Method append_crontab_entry(self, line)
	##
	## Appends the "line" to the /etc/crontab file
	## 
	def append_crontab_entry(self, line):
		if line == None:
			self.delete_crontab_entry('faxrunq')
		else:
			#add crontab entry s
			self.delete_crontab_entry('faxrunq')	#first we delete the entry thats there
             
			try:
				fout = open("/etc/crontab", "a")
				fout.write(line)
				fout.close()
			except:
				print "\nCan't open /etc/crontab\n"
				return
			
			
	## Method delete_crontab_entry(self, line)
	##
	## Deletes the "line" from the /etc/crontab file
	## 
	def delete_crontab_entry(self, line):
		try:
			fin = open("/etc/crontab", "r")
		except:
			print "\nCan't open /etc/crontab\n"
			return

		try:
			fout = open("/tmp/crontab", "w")
		except:
			print "\nCan't open /tmp/crontab\n"
			return

		while 1:
			l = fin.readline()
			if not l:
				break

			if string.find(l, line) != -1:
				continue
			else:
				fout.write(l)
					
			
		fout.close()
		fin.close()
		
		#now copy the new file back to /etc
		try:
			fin = open("/tmp/crontab", "r")
		except:
			print "\nCan't open /tmp/crontab\n"
			return

		try:
			fout = open("/etc/crontab", "w")
		except:
			print "\nCan't open /etc/crontab\n"
			return

		fout.write(fin.read())
		fout.close()
		fin.close()
		
		
		os.unlink('/tmp/crontab')


	## Method write_efax_config(self)
	##
	## Called when Efax preferences are saved.
	## 
	def write_efax_config(self):
		try:
			fp = open(self.efaxConfigFile, 'w')
		except:
			print 'I can\'t open the efax config file.'
			return;

		fp.write("\
#efax.rc\n\
#\n\
#This file has beed created by GFax.  It will be over written\n\
#every time Gfax's efax setup is changed.\n\
#\n")

		fp.write('FROM=' + self.ourFaxNumber + '\n')
		#fp.write('NAME=' +  '\n')
		fp.write('DIALPREFIX=' + self.phonePrefix + '\n')

		fp.write('DEV=' + self.efaxModemPort + '\n')
		fp.write('PAGE=' + efaxPage[self.efaxPageSize] + '\n')
		fp.write('LOCK=' + self.efaxModemLockFile + '\n')
		fp.write(self.efaxModemHandshake + '\n')
		

		fp.close()

		

	def firsttime_setup(self):# Open the window
		self.firsttime_dialog()
		
		
