"""
/*  GFAX - Gnome fax application
 *  Copyright (C) 2001 George A. Farris
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
"""
from gtk import *
import os, sys
import gnome.ui
import libglade
from gnome.config import *

class Preferences_Ui:

	##=============================================================================
	## Method firsttime_dialog(self)
	##
	## Go here when the first time Gfax is run.  This sets up some of the variables
	## required for oporation.
	## 
	def firsttime_dialog(self):
		
		try:
			self.ftwin = libglade.GladeXML(self.file_path + '/gfax.glade', 'GfaxFirstTimeDruid')
		except:
			print "Can't open interface description file (gfax.glade)"
		
		ftapp = self.ftwin.get_widget('GfaxFirstTimeDruid')
		ftdic={}		
		ftdic['new_user_druid_cancel'] = self.new_user_druid_cancel
		ftdic['new_user_druid_delete_event'] = self.new_user_druid_cancel
		ftdic['new_user_druid_finish'] = self.new_user_druid_finish
		
		self.ftwin.signal_autoconnect(ftdic)
	
		mainloop()
	
	def new_user_druid_finish(self, *args):
		print "we're finished"
	
		if self.ftwin.get_widget('ftHylafaxRadiobutton').get_active():
			self.transmitAgent = 'hylafax'
		if self.ftwin.get_widget('ftMgettyRadiobutton').get_active():
			self.transmitAgent = 'mgetty'
			self.mgModemPort = self.ftwin.get_widget('ftModemPortEntry').get_text()
		if self.ftwin.get_widget('ftEfaxRadiobutton').get_active():
			self.transmitAgent = 'efax'
			self.efaxModemPort = self.ftwin.get_widget('ftModemPortEntry').get_text()			

		self.emailAddress = self.ftwin.get_widget('ftEmailAddressEntry').get_text()
		self.ourFaxNumber = self.ftwin.get_widget('ftPhoneNumberEntry').get_text()
		self.phonePrefix = self.ftwin.get_widget('ftPhonePrefixEntry').get_text()

		# now call save, make sure all defaults are correct.
		set_string('gfax/Settings/file_path', self.file_path)

		# Main settings
		set_string('gfax/Settings/EmailAddress', self.emailAddress)
		set_string('gfax/Settings/PhonePrefix', self.phonePrefix)
		set_string('gfax/Settings/OurFaxNumber', self.ourFaxNumber)
		set_string('gfax/Settings/TransmitAgent', self.transmitAgent)
		set_bool('gfax/Settings/SendNow', TRUE)
		set_bool('gfax/Settings/EmailNotify', FALSE)
		set_bool('gfax/Settings/CoverPage', FALSE)
		set_bool('gfax/Settings/Resolution', TRUE)

		sync()
						
		args[0].get_toplevel().destroy()	# nuke to window
		mainquit()	# firsttimes mainloop
	
	def new_user_druid_cancel(self, *args):
		mainquit()
		sys.exit(1)

	# End of first time code			
	#-------------------------------------------------------------------------------
		





	##=============================================================================
	## Method prefs_dialog(self)
	##
	## Open up the preferences dialog.
	## 
	def prefs_dialog(self):
		# Open the window
		try:
			self.pwin = libglade.GladeXML(self.file_path + '/setup.glade', 'setup')
		except:
			print "Can't open interface description file " + self.file_path + '/setup.glade'
			return

		# Change flag for saving prefs
		self.hylafaxPrefsChanged = 0
		self.mgettyPrefsChanged = 0
		self.efaxPrefsChanged = 0	

		# Set all the widgets according to prefs		
		# System, Hylafax, Mgetty, Efax ------------------------------

		#Hylafax
		if self.transmitAgent == "hylafax":
			self.pwin.get_widget('hylafaxRadioButton').set_active(1)
			self.pwin.get_widget('hylafaxServerNameEntry').set_text(self.serverHost)
			self.pwin.get_widget('hylafaxServerPortEntry').set_text('%s' % (self.serverPort))
			self.pwin.get_widget('hylafaxUsernameEntry').set_text(self.serverUsername)
			self.pwin.get_widget('mgettyFrame').set_sensitive(0)
			self.pwin.get_widget('efaxFrame').set_sensitive(0)
			self.pwin.get_widget('hylafaxFrame').set_sensitive(1)
		else:
			self.pwin.get_widget('hylafaxRadioButton').set_active(0)
			
		#Mgetty
		if self.transmitAgent == "mgetty":
			self.pwin.get_widget('mgettyRadioButton').set_active(1)
			self.pwin.get_widget('hylafaxFrame').set_sensitive(0)
			self.pwin.get_widget('efaxFrame').set_sensitive(0)
			self.pwin.get_widget('mgettyFrame').set_sensitive(1)

			#entry widgets
			self.pwin.get_widget('mgettyModemInitEntry').set_text(self.mgModemInit)
			self.pwin.get_widget('mgettyModemHandshakeEntry').set_text(self.mgModemHandshake)
			self.pwin.get_widget('mgettyModemQuirksEntry').set_text(self.mgModemQuirks)
			self.pwin.get_widget('mgettySendfaxConfigFileEntry').set_text(self.mgConfigFile)
			self.pwin.get_widget('mgettyDialCommandEntry').set_text(self.mgDialCommand)
			self.pwin.get_widget('mgettyModemPortCombo').set_text(self.mgModemPort)

			#Option menus
			self.pwin.get_widget('mgettyModemTypeOptionmenu').set_history(self.mgModemType)
			self.pwin.get_widget('mgettyOpenDelayOptionmenu').set_history(self.mgOpenDelay)
			self.pwin.get_widget('mgettyModemSpeedOptionmenu').set_history(self.mgModemSpeed)
			self.pwin.get_widget('mgettyModemSwitchSpeedOptionmenu').set_history(self.mgModemSwitchSpeed)
			self.pwin.get_widget('mgettyDebugLevelOptionmenu').set_history(self.mgDebugLevel)
			self.pwin.get_widget('mgettyMaxTriesOptionmenu').set_history(self.mgMaxTries)
			self.pwin.get_widget('mgettyIgnoreCarrierOptionmenu').set_history(self.mgIgnoreCarrier)
			self.pwin.get_widget('mgettyMaxTriesContOptionmenu').set_history(self.mgMaxTriesCont)
			self.pwin.get_widget('mgRunQueueOptionmenu').set_history(self.mgQueuePeriod)

			#text widgets
			txt = self.pwin.get_widget('mgUserAllowText')
			txt.set_point(0)
			txt.forward_delete(-1)
			txt.insert(None, None, None, self.mgAllowedUsers)

			txt = self.pwin.get_widget('mgUserDenyText')
			txt.set_point(0)
			txt.forward_delete(-1)
			txt.insert(None, None, None, self.mgDeniedUsers)


		else:
			self.pwin.get_widget('mgettyRadioButton').set_active(0)

		#Efax
		if self.transmitAgent == "efax":
			self.pwin.get_widget('efaxRadioButton').set_active(1)
			self.pwin.get_widget('mgettyFrame').set_sensitive(0)
			self.pwin.get_widget('hylafaxFrame').set_sensitive(0)
			self.pwin.get_widget('efaxFrame').set_sensitive(1)

			#entry widgets
			self.pwin.get_widget('efaxModemHandshakeCombo').set_text(self.efaxModemHandshake)
			self.pwin.get_widget('efaxConfigFileEntry').set_text(self.efaxConfigFile)
			self.pwin.get_widget('efaxModemLockFileCombo').set_text(self.efaxModemLockFile)
			self.pwin.get_widget('efaxModemPortCombo').set_text(self.efaxModemPort)

			#Option menus
			self.pwin.get_widget('efaxPageSizeOptionmenu').set_history(self.efaxPageSize)

		else:
			self.pwin.get_widget('efaxRadioButton').set_active(0)

		self.pwin.get_widget('ourFaxNumberEntry').set_text(self.ourFaxNumber)
		self.pwin.get_widget('phonePrefixEntry').set_text(self.phonePrefix)


		# User -------------------------------------------------
		self.pwin.get_widget('emailNotifyCheckButton').set_active(self.emailNotify_state)
		self.pwin.get_widget('sendNowCheckButton').set_active(self.sendNow_state)
		self.pwin.get_widget('coverPageCheckButton').set_active(self.coverPage_state)
		self.pwin.get_widget('resolutionCheckButton').set_active(self.resolution_state)

		self.pwin.get_widget('emailAddressEntry').set_text(self.emailAddress)
								
		
		# Collect all the signals and methods for autoconnect
		dic={}
		#for key in dir(self.__class__):
		#	dic[key] = getattr(self,key)

		# Need to add methods in this module as well
		dic['setup_changed'] = self.setup_changed
		dic['setup_apply'] = self.setup_apply
		dic['setup_help'] = self.setup_help
		dic['hylafax_setup_changed'] = self.hylafax_setup_changed
		dic['mgetty_setup_changed'] = self.mgetty_setup_changed
		dic['efax_setup_changed'] = self.efax_setup_changed
		
		self.pwin.signal_autoconnect(dic)
		

		# Don't return til we're finished
		self.pwin.get_widget('setup').run()


	## Method set_config(self, button, data)
	##
	## Go here when "OK" or "Apply" button hit
	## 
	def setup_apply(self, button, pageNumber):
		if pageNumber == -1:	# This stop apply from being run twice
			return
		print "Apply or OK hit..."
		
		if self.hylafaxPrefsChanged:	# Hylafax
			self.hylafax_get_changes()

		if self.mgettyPrefsChanged:		# Mgetty
			if os.geteuid() != 0:
				m = gnome.ui.GnomeWarningDialog('You must be \'root\' to save mgetty system preferences')
				m.run()
			else:				
				self.mgetty_get_changes()

		if self.efaxPrefsChanged:		# Efax
			if os.geteuid() != 0:
				m = gnome.ui.GnomeWarningDialog('You must be \'root\' to save efax system preferences')
				m.run()
			else:				
				self.efax_get_changes()
		
		self.save()
		

	def setup_help(self, button, data):
		print "Help hit..."        



	def setup_changed(self, *args):

		# Ya I know we get this for every widget that changes anything
		# but who cares.
		if self.pwin.get_widget('hylafaxRadioButton').get_active():
			self.transmitAgent = 'hylafax'
			self.pwin.get_widget('mgettyFrame').set_sensitive(0)
			self.pwin.get_widget('hylafaxFrame').set_sensitive(1)
			self.pwin.get_widget('efaxFrame').set_sensitive(0)
			self.pwin.get_widget('hylafaxServerNameEntry').set_text(self.serverHost)
			self.pwin.get_widget('hylafaxServerPortEntry').set_text('%s' % (self.serverPort))
			self.pwin.get_widget('hylafaxUsernameEntry').set_text(self.serverUsername)

		if self.pwin.get_widget('mgettyRadioButton').get_active():
			self.transmitAgent = 'mgetty'
			self.pwin.get_widget('mgettyFrame').set_sensitive(1)
			self.pwin.get_widget('hylafaxFrame').set_sensitive(0)
			self.pwin.get_widget('efaxFrame').set_sensitive(0)

		if self.pwin.get_widget('efaxRadioButton').get_active():
			self.transmitAgent = 'efax'	
			self.pwin.get_widget('mgettyFrame').set_sensitive(0)
			self.pwin.get_widget('hylafaxFrame').set_sensitive(0)
			self.pwin.get_widget('efaxFrame').set_sensitive(1)

		self.emailNotify_state = self.pwin.get_widget('emailNotifyCheckButton').get_active()
		self.sendNow_state = self.pwin.get_widget('sendNowCheckButton').get_active()
		self.coverPage_state = self.pwin.get_widget('coverPageCheckButton').get_active()
		self.resolution_state = self.pwin.get_widget('resolutionCheckButton').get_active()

		self.ourFaxNumber = self.pwin.get_widget('ourFaxNumberEntry').get_text()
		self.phonePrefix = self.pwin.get_widget('phonePrefixEntry').get_text()
		self.emailAddress = self.pwin.get_widget('emailAddressEntry').get_text()
		

		# Tell user something was changed
		self.pwin.get_widget('setup').changed()
		

	# these are really place holders for the time being
	def hylafax_setup_changed(self, *args):
		# Tell user something was changed
		self.hylafaxPrefsChanged = 1
		self.pwin.get_widget('setup').changed()

	def hylafax_get_changes(self):
		self.serverHost = self.pwin.get_widget('hylafaxServerNameEntry').get_text()
		self.serverPort = int(self.pwin.get_widget('hylafaxServerPortEntry').get_text())		
		self.serverUsername = self.pwin.get_widget('hylafaxUsernameEntry').get_text()


 	def mgetty_setup_changed(self, *args):
		# Tell user something was changed
		self.mgettyPrefsChanged = 1
		self.pwin.get_widget('setup').changed()
		
	def mgetty_get_changes(self):
		#text widgets
		self.mgModemInit = self.pwin.get_widget('mgettyModemInitEntry').get_text()
		self.mgModemHandshake = self.pwin.get_widget('mgettyModemHandshakeEntry').get_text()
		self.mgModemQuirks = self.pwin.get_widget('mgettyModemQuirksEntry').get_text()
		self.mgConfigFile = self.pwin.get_widget('mgettySendfaxConfigFileEntry').get_text()
		self.mgDialCommand = self.pwin.get_widget('mgettyDialCommandEntry').get_text()
		self.mgModemPort = self.pwin.get_widget('mgettyModemPortCombo').get_text()

		#Option menus
		mm = self.pwin.get_widget('mgettyModemTypeOptionmenu').get_menu()
		self.mgModemType = mm.children().index(mm.get_active())

		mm = self.pwin.get_widget('mgettyOpenDelayOptionmenu').get_menu()
		self.mgOpenDelay = mm.children().index(mm.get_active())

		mm = self.pwin.get_widget('mgettyModemSpeedOptionmenu').get_menu()
		self.mgModemSpeed = mm.children().index(mm.get_active())

		mm = self.pwin.get_widget('mgettyModemSwitchSpeedOptionmenu').get_menu()
		self.mgModemSwitchSpeed = mm.children().index(mm.get_active())

		mm = self.pwin.get_widget('mgettyDebugLevelOptionmenu').get_menu()
		self.mgDebugLevel = mm.children().index(mm.get_active())

		mm = self.pwin.get_widget('mgettyMaxTriesOptionmenu').get_menu()
		self.mgMaxTries = mm.children().index(mm.get_active())

		mm = self.pwin.get_widget('mgettyIgnoreCarrierOptionmenu').get_menu()
		self.mgIgnoreCarrier = mm.children().index(mm.get_active())

		mm = self.pwin.get_widget('mgettyMaxTriesContOptionmenu').get_menu()
		self.mgMaxTriesCont = mm.children().index(mm.get_active())

		mm = self.pwin.get_widget('mgRunQueueOptionmenu').get_menu()
		self.mgQueuePeriod = mm.children().index(mm.get_active())

		# get the AllowText and DenyText text entries.
		self.mgAllowedUsers = self.pwin.get_widget('mgUserAllowText').get_chars(0, -1)
		self.mgDeniedUsers = self.pwin.get_widget('mgUserDenyText').get_chars(0, -1)
		
		
		#self.pwin.get_widget('mgettySetupDruidButton')
		
		
	def efax_setup_changed(self, *args):
		# Tell user something was changed
		self.efaxPrefsChanged = 1
		self.pwin.get_widget('setup').changed()

		
	def efax_get_changes(self):
		#entry widgets
		self.efaxModemHandshake  = self.pwin.get_widget('efaxModemHandshakeCombo').get_text()
		self.efaxConfigFile = self.pwin.get_widget('efaxConfigFileEntry').get_text()
		self.efaxModemLockFile = self.pwin.get_widget('efaxModemLockFileCombo').get_text()
		self.efaxModemPort = self.pwin.get_widget('efaxModemPortCombo').get_text()

		#Option menus
		mm = self.pwin.get_widget('efaxPageSizeOptionmenu').get_menu()
		self.efaxPageSize = mm.children().index(mm.get_active())
		
		#self.pwin.get_widget('efaxSetupDruidButton')
