#!/usr/bin/python
"""
/*  GFAX - Gnome fax application
 *  Copyright (C) 2001 George A. Farris
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
"""

# System imports
import os
import re
import sys
import select
import string
from popen2 import popen3
from gtk import *
from gnome.ui import *
from GDK import _2BUTTON_PRESS, BUTTON3_MASK, INPUT_READ
import gnome.config
import libglade

# Main notebook pages
MAINPAGE = 0
SENDPAGE = 1
PHONEPAGE = 2
NEWBOOKPAGE = 3
ITEMSPAGE = 4

class Ui:
	
	def __init__(self):

		try:
			win = libglade.GladeXML(self.prefs.file_path + '/gfax.glade', 'Gfax')
		except:
			print "Can't open interface description file (gfax.glade)"
			self.cleanup_exit(self)


		self.caller = []	#stack that tells what dialog we came from
		
		# get the widgets we'll need for the main window
		self.gfax = win.get_widget('Gfax')
		self.mainDockitem = win.get_widget('mainDockitem')
		self.mainNotebook = win.get_widget('mainNotebook')
		self.mainPhonebookButton = win.get_widget('phonebookButton')
		self.mainRefreshButton = win.get_widget('refreshButton')
		self.mainAppbar = win.get_widget('appbar1')
		self.mainStatus = win.get_widget('text1')
		self.mainQueList = win.get_widget('clist1')
		self.mainQueTree = win.get_widget('ctree1')
		self.mainQueTree.set_line_style(CTREE_LINES_SOLID)	

		# Send widgets
		self.sendSendfaxButton = win.get_widget('sendSendfaxButton')		
		self.sendPhonebookButton = win.get_widget('sendPhonebookButton')
		self.sendNumberAddButton = win.get_widget('sendNumberaddButton')
		self.sendNumberEntry = win.get_widget('sendNumberEntry')
		self.sendNumberClist = win.get_widget('sendNumberlistClist')
		self.sendPSfileEntry = win.get_widget('sendPSfileEntry')
		
		# Phone book widgets
		self.phoneNewbookButton = win.get_widget('phoneNewbookButton')
		self.phoneBooklistClist = win.get_widget('phoneBooklistClist')
		self.phoneBookitemClist = win.get_widget('phoneBookitemClist')

		# New Phone book widgets
		self.newphbCloseButton = win.get_widget('newphbCloseButton')
		self.newphbNameEntry = win.get_widget('newphbNameEntry')		
		self.newphbGfaxFileentry = win.get_widget('newphbGfaxFileentry')
		self.newphbDefaultCheckbutton = win.get_widget('newphbDefaultCheckbutton')
		self.newphbPhonebookClist = win.get_widget('newphbPhonebookClist')
		self.newphbGfaxRadiobutton = win.get_widget('newphbGfaxRadiobutton')
		self.newphbGcardRadiobutton = win.get_widget('newphbGcardRadiobutton')
		
		# Edit Phone book items widgets
		self.editphbSaveButton = win.get_widget('editphbSaveButton')
		self.editphbDeleteButton = win.get_widget('editphbDeleteButton')
		self.editphbCloseButton = win.get_widget('editphbCloseButton')
		self.editphbCphbEntry = win.get_widget('editphbCphbEntry')
		self.editphbClist = win.get_widget('editphbClist')
		self.editphbNumberEntry = win.get_widget('editphbNumberEntry')
		self.editphbNameEntry = win.get_widget('editphbNameEntry')
		self.editphbCompanyEntry = win.get_widget('editphbCompanyEntry')
		
		# Set initial ui state
		self.mainNotebook.set_show_tabs(FALSE)
		self.mainNotebook.set_page(SENDPAGE)	# got to do this so mainpage will show
		self.mainNotebook.set_page(MAINPAGE)	# the proper size.
					
			
		signal_handlers = {
			# GTK signals
			'on_Gfax2_delete_event' : self.destroy,
			'destroy' : self.destroy,
		
			# Menu items
			'on_exit1_activate' : self.destroy,
			'on_newfax_activate' : self.destroy,
			'on_preferences_activate' : self.destroy,
			'on_about_activate' : self.destroy,
		
			# Button bar
			'on_newfaxButton_clicked' : self.send_ui_show,
			'on_refreshButton_toggled' : self.refresh_status,
			'on_phonebookButton_clicked' : self.phone_ui_show,
			'on_preferencesButton_clicked' : self.change_prefs,
			'on_exitButton_clicked' : self.destroy,

			# CTree signals
			'on_ctree1_select_row' : self.tree_select_row,
		
			# CList signals
			'on_enter_notify_event' : self.enter_notify_event,
			'on_leave_notify_event' : self.leave_notify_event,
			
			# Send fax signals
			'on_sendSendfaxButton_clicked' : self.send_ui_hide,
			'on_sendPhonebookButton_clicked' : self.phone_ui_show,
			'on_sendCancelButton_clicked' : self.send_ui_hide,
			'on_sendNumberaddButton_clicked' : self.send_number_add,
			'on_sendNumberEntry_activate' : self.send_number_add,
			'on_sendNumberlistClist_button_press_event' : self.send_button_press_event,
																		
			# Phone book signals
			'on_phoneNewbookButton_clicked' : self.newphb_ui_show,
			'on_phoneDeletebookButton_clicked' : self.phone_delete,
			'on_phoneEditbookButton_clicked' : self.editphb_ui_show,
			'on_phonePreviousButton_clicked' : self.phone_ui_hide,
			'on_phoneNextButton_clicked' : self.phone_ui_hide,
			'on_phoneCancelButton_clicked' : self.phone_ui_hide,
			'on_phoneBooklistClist_select_row' : self.phone_select_row,
			'on_phoneBookitemClist_select_row' : self.phone_select_row,
			
			# New phone book signals
			'on_newphbCloseButton_clicked' : self.newphb_ui_hide,
			'on_newphbSaveButton_clicked' : self.newphb_save,
			'on_newphbDeleteButton_clicked' : self.newphb_delete,
			'on_newphbPhonebookClist_select_row' : self.newphb_select_row,
			
			# Edit phone book items signals
			'on_editphbSaveButton_clicked' : self.editphb_save_items,
			'on_editphbDeleteButton_clicked' : self.editphb_delete_item,
			'on_editphbCloseButton_clicked' : self.editphb_ui_hide,
			'on_editphbNumberEntry_activate' : self.editphb_activate,
			'on_editphbNameEntry_activate' : self.editphb_activate,
			'on_editphbCompanyEntry_activate' : self.editphb_activate,
			'on_editphbClist_select_row' : self.editphb_select_row
		}

		win.signal_autoconnect(signal_handlers)


	def appbar(self, text):
		self.mainAppbar.set_status(text)

	def tree_select_row(self, tree, row, col, event):
		print "Row selected...", row

		# What gets refreshed if we press the "Toggle Refresh" button
		self.refresh_focus = self.fax.queue[row]
		self.stat_queue(self.fax.queue[row])

		# do main status always
		if row > 0:
			self.refresh_focus = 'status'
			self.stat_queue('status')				
			
			
	## Method refresh_status(*args)
	##
	##	Refresh the selected item when button is pushed.
	##
	def refresh_status(self, button):
		if button.get_active() == 0:
			print 'Refresh off...'
			if self.timerId:
				timeout_remove(self.timerId)
		else:
			print 'Refresh on...'		
			self.stat_queue(self.refresh_focus)
			self.timerId = timeout_add(10000, self.stat_queue, self.refresh_focus)

	def status(self, text=None, cmd=None):
		if cmd == 'clear':
			# Clear the status text 
			length = self.mainStatus.get_length()
			if length:
				self.mainStatus.set_point(0)
				self.mainStatus.forward_delete(length)
						
		# Add the text
		self.mainStatus.insert(None,None,None,text)

	def queTree(self, cmd):
		if cmd == 'clear':
			# Clear the tree
			for i in self.mainQueTree.base_nodes():
				self.mainQueTree.remove_node(i)
		
		if cmd == 'update':
			# Clear the tree
			for i in self.mainQueTree.base_nodes():
				self.mainQueTree.remove_node(i)

			host = string.split(self.prefs.serverHost, '.')
			print host[0]
			cp = self.mainQueTree.insert_node(None,None,[host[0]],is_leaf=FALSE, expanded=TRUE)
			cp1 = self.mainQueTree.insert_node(cp,None,['Send_Q'])
			cp2 = self.mainQueTree.insert_node(cp,None,['Done_Q'])
			cp3 = self.mainQueTree.insert_node(cp,None,['Receive_Q'])	


	def queList(self, cmd=None, row=None, col=None, text=None):
		if cmd == 'clear':
			self.mainQueList.clear()
		if cmd == 'newrow':	
			self.mainQueList.append(text)
		if cmd == 'delete':
			pass

	def enter_notify_event(self, *args):
		print args
		
	def leave_notify_event(self, *args):
		print args
		


########################################################################
##	Send methods
##
## We go here when we close the send window and also when we hit the
## the send fax button.
########################################################################

	def send_ui_show(self, button):
		print 'Show send ui...'
		self.mainDockitem.hide()
		self.mainNotebook.set_page(SENDPAGE)
		self.sendNumberClist.clear()
		self.sendNumOfRows = -1
		self.appbar('Click "Phone Book" to select from lists...')
		self.sendPSfileEntry.set_text(self.filename)
						
	def send_ui_hide(self, button):
		print 'Hide send ui...'
		self.mainDockitem.show()
		self.mainNotebook.set_page(MAINPAGE)
		
		#
		# go here to send fax
		if button == self.sendSendfaxButton:
			self.appbar('')
			# get all the numbers, then send
			sendList = []
			item = []
			for i in range(self.sendNumOfRows + 1):	#from send_number_add
				number = self.sendNumberClist.get_text(i,0)
				name = self.sendNumberClist.get_text(i,1)
				company = self.sendNumberClist.get_text(i,2)				
				sendList.append([number,name,company])
				number = ''
				name = ''
				company = ''

			filename = self.sendPSfileEntry.get_text()

			command = self.fax.send(sendList, filename)
			
			if self.prefs.transmitAgent == 'efax':
				self.regexOK = re.compile('done, returning 0')
				self.regexBUSY = re.compile('done, returning 1')
				self.regexFILE = re.compile('done, returning 2')
				self.regexPROTOCOL = re.compile('done, returning 3')
				self.regexMODEM = re.compile('done, returning 4')
				self.regexTERM = re.compile('done, returning 5')
				
				self.status('', 'clear')											
				#fpout, fpin, fperr = popen3('/home/george/work/Python/efaxemu.sh')
				fpout, fpin, fperr = popen3(command)
				self.tag = input_add(fpout, INPUT_READ, self.update_efax_status)
				
			if self.prefs.transmitAgent == 'mgetty':
				os.system(command)
			
			
			# show the status of the faxes that were just sent
			# by hylafax.
			if self.prefs.transmitAgent == 'hylafax':
				self.refresh_focus = 'sendq'
				self.stat_queue('sendq')		
				
				self.mainRefreshButton.set_active(1)				
					
		self.appbar('')
		
	def send_number_add(self, button, data=None):
		if data == None:  #just single number
			self.sendNumOfRows = self.sendNumberClist.append([self.sendNumberEntry.get_text(),"",""])		
			self.sendNumberEntry.set_text('')
		else:	# multiple numbers
			if button == 'items':
				for item in data:
					self.sendNumOfRows = self.sendNumberClist.append(item)
			else:	# entire book
				index = self.get_phonebook_index(data)
				ftype, name, filename = string.split(
							gnome.config.get_string('gfax/Phonebooks/%d' % index),':')

				items = self.load_gfax_phb(filename, ftype)
				for item in items:
					self.sendNumOfRows = self.sendNumberClist.append(item)

		
	def send_button_press_event(self, clist, event):
		#if hasattr(event, 'type') and event.type == _2BUTTON_PRESS:
		#print dir(event)
		if self.sendNumberClist.selection == []:
			return

		if event.button == 3:
			menu = GtkMenu()
			menuitem = GtkMenuItem('Remove')
			menuitem.connect('activate', self.send_number_remove_row)
			menu.append(menuitem)
			menuitem.show()
			menuitem = GtkMenuItem('Remove All')
			menuitem.connect('activate', self.send_number_remove_all)
			menu.append(menuitem)
			menuitem.show()

			menu.popup(None, None, None, event.button, event.time)
			menu.show()

	def send_number_remove_row(self, menuitem):
		self.sendNumberClist.remove(self.sendNumberClist.selection[0])

	def send_number_remove_all(self, menuitem):
		self.sendNumberClist.clear()

	# this is run from the gtk input_add function and just reads
	# output from the popen3 command above.
	def update_efax_status(self, fd, data):
		s = fd.readline()
		print s
		if not s:
			input_remove(self.tag)
			return
		
		if self.regexOK.search(s):	# 0
			self.status('Your facsimile was sent successfully...')
		elif self.regexBUSY.search(s):		# 1
			self.status('The line was busy please try again later...  ')
		elif self.regexFILE.search(s):		# 2
			self.status('Facsimile not found or disk full...  ')
		elif self.regexPROTOCOL.search(s):	# 3
			self.status('Modem communication problem, unexpected response...  ')
		elif self.regexMODEM.search(s):	# 4
			self.status('The modem is not responding...  ')
		elif self.regexTERM.search(s):		# 5
			self.status('Unexpected program termination...  ')
		
		self.status(s)
		
########################################################################
##
##	Choose phone book methods
##
########################################################################
	def phone_ui_show(self, button):
		# Show the page and return to the correct caller when closed
		if button == self.mainPhonebookButton:
			self.caller.append('main')
			self.mainDockitem.hide()
			self.mainNotebook.set_page(PHONEPAGE)
		elif button == self.newphbCloseButton:
			self.mainNotebook.set_page(PHONEPAGE)
		elif button == self.editphbCloseButton:
			self.mainNotebook.set_page(PHONEPAGE)
		elif button == self.editphbSaveButton:
			self.mainNotebook.set_page(PHONEPAGE)		
		else:	#must be from send
			self.caller.append('send') 
			self.mainNotebook.set_page(PHONEPAGE)
			self.appbar('Choose entire phone book or items then click "Close"...')
			
		# Find the default phone book if there is one, -1 if not
		default = gnome.config.get_int('gfax/Phonebooks/Default')
		
		# Save the selection
		srow = self.phoneBooklistClist.selection

		# Load the phone books in the list
		self.phoneBooklistClist.clear()
		self.phoneBookitemClist.clear()

		n = gnome.config.get_int('gfax/Phonebooks/count')
		for i in range(n):
			ftype, name, filename = string.split(gnome.config.get_string('gfax/Phonebooks/%d' % i),':')
											
			row = self.phoneBooklistClist.append([name,filename])

			# This will load the default phonebook. If one was previously selected 
			# it will load it instead.

			if i == default and srow == []:
				self.phoneBooklistClist.select_row(row, 0)
			else:
				try:
					self.phoneBooklistClist.select_row(srow[0], 0)	
				except:
					pass

			# set colour on default phonebook
			if i == default:
				colour = GdkColor(00000, 00000, 65000)	# this is the default
				self.phoneBooklistClist.unselect_all()
				self.phoneBooklistClist.set_foreground(row, colour)
					
	def phone_ui_hide(self, button):
		if self.caller.pop() == 'send':
			self.mainNotebook.set_page(SENDPAGE)
		else: # must be main
			self.mainDockitem.show()
			self.mainNotebook.set_page(MAINPAGE)			
		self.appbar('')

	def phone_delete(self, button):
		print 'Delete book...'
		row = self.phoneBooklistClist.selection[0]
		self.phoneBooklistClist.remove(row)
		self.phoneBookitemClist.clear()

		default = gnome.config.get_int('gfax/Phonebooks/Default')
		
		n = gnome.config.get_int('gfax/Phonebooks/count')
		for i in range(n):
			ftype, name, filename = string.split(gnome.config.get_string(
											'gfax/Phonebooks/%d' % i),':')

		if default == row:
			gnome.config.clean_key('gfax/Phonebooks/Default')
		gnome.config.clean_key('gfax/Phonebooks/%d' % row)
		gnome.config.set_int('gfax/Phonebooks/count', n -1)	
		gnome.config.sync()
		
	def phone_select_row(self, clist, row, col, event):
		self.sendItemList = []  #tested in phone_ui_hide
		if clist == self.phoneBooklistClist:
			book = self.phoneBooklistClist.get_text(row, col)
			index = self.get_phonebook_index(book)
			
			self.phoneBookitemClist.clear()
			ftype, name, filename = string.split(
						gnome.config.get_string('gfax/Phonebooks/%d' % index),':')

			records = self.load_gfax_phb(filename, ftype)

			for i in records:
				self.phoneBookitemClist.append(i)
	
			if event != None:
				self.send_number_add('phonebook', book)
 
		if clist == self.phoneBookitemClist:
			number = self.phoneBookitemClist.get_text(row,0)
			name = self.phoneBookitemClist.get_text(row,1)
			company = self.phoneBookitemClist.get_text(row,2)
				
			self.sendItemList.append([number,name,company])
			self.send_number_add('items', self.sendItemList)
			
########################################################################
##
##	Create or edit phone book methods
##
########################################################################
	def newphb_ui_show(self, button):
		print 'Show newphb ui...'
		self.mainNotebook.set_page(NEWBOOKPAGE)

		# Clear the widgets when we enter
		self.newphbPhonebookClist.clear()		
		self.newphbNameEntry.set_text('')
		self.newphbGfaxFileentry.gtk_entry().set_text('')
		self.newphbDefaultCheckbutton.set_active(0)
			
		n = gnome.config.get_int('gfax/Phonebooks/count')
		for i in range(n):
			ftype, name, filename = string.split(gnome.config.get_string('gfax/Phonebooks/%d' % i),':')
			self.newphbPhonebookClist.append([name,filename])

	
	def newphb_save(self, button):
		print 'Save newphb...'
		name = self.newphbNameEntry.get_text()
		filename = self.newphbGfaxFileentry.get_full_path(0)
		isdefault = self.newphbDefaultCheckbutton.get_active()

		# It's a gfax phonebook
		if self.newphbGfaxRadiobutton.get_active() == 1:
			if self.newphbPhonebookClist.selection == []:	# new book
				self.newphbPhonebookClist.append([name])
			self.save_gfax_phb(name, filename, 'gfax', isdefault)
		# It's a gnomecard phonebook
		if self.newphbGcardRadiobutton.get_active() == 1:
			if self.newphbPhonebookClist.selection == []:	# new book
				self.newphbPhonebookClist.append([name])
			self.save_gfax_phb(name, filename, 'gcard', isdefault)
		

	def newphb_delete(self, button):
		print 'Delete newphb...'
		row = self.newphbPhonebookClist.selection[0]
		self.newphbPhonebookClist.remove(row)
		self.newphbNameEntry.set_text('')
		self.newphbGfaxFileentry.gtk_entry().set_text('')
		self.newphbDefaultCheckbutton.set_active(0)

		default = gnome.config.get_int('gfax/Phonebooks/Default')
		
		n = gnome.config.get_int('gfax/Phonebooks/count')
		for i in range(n):
			ftype, name, filename = string.split(gnome.config.get_string(
											'gfax/Phonebooks/%d' % i),':')

		if default == row:
			gnome.config.clean_key('gfax/Phonebooks/Default')
		gnome.config.clean_key('gfax/Phonebooks/%d' % row)
		gnome.config.set_int('gfax/Phonebooks/count', n -1)	
		gnome.config.sync()
		

	def newphb_ui_hide(self, button):
		print 'Hide newphb ui...'
		self.phone_ui_show(button)

	def newphb_select_row(self, clist, row, col, event):
		book = self.newphbPhonebookClist.get_text(row, col)
		index = self.get_phonebook_index(book)
			
		default = gnome.config.get_int('gfax/Phonebooks/Default')
		ftype, name, filename = string.split(
					gnome.config.get_string('gfax/Phonebooks/%d' % index),':')

		self.newphbNameEntry.set_text(name)
		e = self.newphbGfaxFileentry.gtk_entry().set_text(filename)

		if default == index:
			self.newphbDefaultCheckbutton.set_active(1)
		else:
			self.newphbDefaultCheckbutton.set_active(0)
		if ftype == 'gfax':
			self.newphbGfaxRadiobutton.set_active(1)

		

########################################################################
##
##	Create or edit phone book item methods
##
########################################################################
	def editphb_ui_show(self, button):
		print 'Show newphbitems ui...'
		self.editInProgress = []	
		self.mainNotebook.set_page(ITEMSPAGE)
		row = self.phoneBooklistClist.selection[0]
		book = self.phoneBooklistClist.get_text(row, 0)
		# Show the book
		self.editphbCphbEntry.set_text(book)
		# now show the entries in that book
		index = self.get_phonebook_index(book)
		self.editphbClist.clear()
		ftype, name, filename = string.split(
					gnome.config.get_string('gfax/Phonebooks/%d' % index),':')
		records = self.load_gfax_phb(filename, ftype)
		for i in records:
			self.editphbClist.append(i)
				
		# set the focus in the desired entry
		self.editphbNumberEntry.grab_focus()		

	def editphb_ui_hide(self, button):
		self.phone_ui_show(button)
		
	def editphb_activate(self, entry):
		if entry == self.editphbNumberEntry:
			self.editphbNameEntry.grab_focus()
		elif entry == self.editphbNameEntry:
			self.editphbCompanyEntry.grab_focus()		
		else:
			number = self.editphbNumberEntry.get_text()
			name = self.editphbNameEntry.get_text()
			company = self.editphbCompanyEntry.get_text()
			if self.editInProgress != []:
				row = self.editInProgress[0]
				self.editphbClist.set_text(row,0,number)
				self.editphbClist.set_text(row,1,name)
				self.editphbClist.set_text(row,2,company)								
				self.editInProgress = []
			else:
				self.editphbClist.append([number,name,company])
			
			self.editphbNumberEntry.set_text('')
			self.editphbNameEntry.set_text('')
			self.editphbCompanyEntry.set_text('')
			
			self.editphbNumberEntry.grab_focus()

	def editphb_save_items(self, button):
		# Build a list of items
		items = []
		for row in range(self.editphbClist.rows):
			number = self.editphbClist.get_text(row,0)
			name = self.editphbClist.get_text(row,1)
			company =self.editphbClist.get_text(row,2)								
			items.append([number,name,company])	
		phonebook = self.editphbCphbEntry.get_text()
		self.save_gfax_phb_items(phonebook,items)
		self.phone_ui_show(button)
		
	
	def editphb_delete_item(self, button):			
		self.editphbClist.remove(self.editInProgress[0])
		self.editphbNumberEntry.set_text('')
		self.editphbNameEntry.set_text('')
		self.editphbCompanyEntry.set_text('')
		self.editphbNumberEntry.grab_focus()


	def editphb_select_row(self, clist, row, col, event):
		self.editphbNumberEntry.set_text(self.editphbClist.get_text(row, 0))
		self.editphbNameEntry.set_text(self.editphbClist.get_text(row, 1))
		self.editphbCompanyEntry.set_text(self.editphbClist.get_text(row, 2))		
		self.editphbNumberEntry.grab_focus()	
		self.editInProgress = [row, col]
		


		
