/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

/* Copyright (C) 1998 Redhat Software Inc. 
 * Authors: Jonathan Blandford <jrb@redhat.com>
 */
#include <config.h>
#include <gnome.h>
#include <math.h>
#include <gdk/gdkkeysyms.h>
#include "gtkscrollpane.h"
#include "gtkgs.h"
#include "crop.h"



typedef struct _ggv_window ggv_window;
struct _ggv_window {
        GtkWidget *main_window;
        GtkWidget *pagelist;
        GtkWidget *coordinates;
        GtkWidget *scrollpane;
        GtkWidget *sidebar;
        GtkWidget *nextbutton;
        GtkWidget *prevbutton;
        GtkWidget *popup_menu;
        GtkWidget *show_hide_menubar;
        GtkWidget *show_hide_toolbar;
        GtkObject *hadj, *vadj;
        GtkWidget *gs;
        gboolean loaded;
        gboolean toolbar_hidden;
        gboolean menubar_hidden;
        gchar *startup_file;
        crop_data *cd;
        gint zoom_value;
};

typedef struct _window_with_data window_with_data;
struct _window_with_data {
        ggv_window *ggv;
        gint data;
};

GtkWidget *file_sel;
GList *window_list;
static int active_ggv;

/* List of all files we are going to load at startup.  */
static GList *garbage_can;

/* prototypes */
static gboolean load_gs(ggv_window *ggv, char *fname);
static ggv_window *create_ggv_window(void);
static void create_menus(ggv_window *retval, window_with_data **temp);
static void create_popup_menus(ggv_window *ggv);

/* callback prototypes */
static void about_callback(GtkWidget *widget, gpointer data);
static void button_press_callback(GtkWidget *widget, GdkEventButton *event, gpointer data);
static void button_release_callback(GtkWidget *widget, GdkEventButton *event, gpointer data);
static void close_cmd (GtkWidget *widget, ggv_window *ggv);
static gint exit_callback(GtkWidget *widget, gpointer data);
static void file_open_destroy_callback(GtkWidget *widget, gpointer data);
static void file_open_ok_callback(GtkWidget *widget, gpointer data);
static void help_callback(GtkWidget *widget, gpointer data);
static void hide_menubar_callback(GtkWidget *widget, gpointer data);
static void hide_toolbar_callback(GtkWidget *widget, gpointer data);
static void motion_callback(GtkWidget *widget, GdkEventMotion *event, gpointer data);
static void key_pressed_event_callback(GtkWidget *widget, GdkEventKey *event, gpointer data);
static void next_page_callback(GtkWidget *widget, gpointer data);
static void open_callback(GtkWidget *widget, gpointer data);
static void orientation_callback(GtkWidget *widget, gpointer data);
static void preferences_callback(GtkWidget *widget, gpointer data);
static void previous_page_callback(GtkWidget *widget, gpointer data);
static void print_callback(GtkWidget *widget, gpointer data);
static void recenter_page_callback(GtkWidget *widget, gpointer data);
static void reload_callback(GtkWidget *widget, gpointer data);
static void scrollpane_middle_click_callback(GtkWidget *widget, gpointer data);
static void scrollpane_right_click_callback(GtkWidget *widget, gpointer data);
static void save_callback(GtkWidget *widget, gpointer data);
static void save_as_callback(GtkWidget *widget, gpointer data);
static void select_page_callback(GtkWidget *widget, gint row, gint column, GdkEventButton *event, gpointer data);
static void zoom_callback(GtkWidget *widget, gpointer data);
static double compute_zoom(gint zoom_spec);

/* Usefull functions */
static gboolean
load_gs(ggv_window *ggv, char *fname)
{
	char *title;
	guint i,n;
	gchar *texts[3];

        g_print ("loading the page...zoom factor %f",compute_zoom(ggv->zoom_value));

	if (!gtk_gs_load (GTK_GS (ggv->gs), fname)) {
                GString *s;
		GtkWidget *w;
                s = g_string_new("Unable to load file ");
                g_string_append(s, fname);
                w =  gnome_app_error (GNOME_APP(ggv->main_window) , s->str);
		gtk_widget_show(w);

                g_string_free(s,0);
                return FALSE;
        }
        g_print ("loaded page...\n");
        fflush(NULL);
        gtk_gs_set_pagemedia(GTK_GS (ggv->gs), -1, FALSE, FALSE, 0);
        g_print ("set the page_media...\n");
        fflush(NULL);

	title = gtk_gs_document_title (GTK_GS (ggv->gs));
	if (title) {
		title = g_strjoin("", "ggv: ", title, NULL);
		gtk_window_set_title(GTK_WINDOW(ggv->main_window), title);
		g_free(title);
	}
        else 
                gtk_window_set_title (GTK_WINDOW(ggv->main_window), "ggv");

        /* FIXME:
           Resize window if necessary, we 
           must verify whether automatic resizing is allowed (add option to
           menu on whether to auto resize 
           finally, at most it should be as large as the screen
           
           We also have to zoom the document to the specific zoom factor
           according to the menu. 

           gtk_gs_set_zoom (GTK_GS (ggv->gs), ggv->zoom_value); 

           So far, the user can't make the window smaller. I don't 
           know how to fix it.

        */

	/*
        gtk_widget_set_usize (ggv->gs, 
                              GTK_GS(ggv->gs)->width,GTK_GS(ggv->gs)->height);
	*/

	gtk_clist_freeze(GTK_CLIST(ggv->pagelist));
	gtk_clist_clear(GTK_CLIST(ggv->pagelist));
        n = gtk_gs_document_numpages(GTK_GS (ggv->gs));

	if (n > 0) {
		for (i=1; i<=n ; i++) {
			texts[0] = "";
			texts[1] = g_strdup(gtk_gs_document_page_label(GTK_GS (ggv->gs), i));
			gtk_clist_append(GTK_CLIST(ggv->pagelist), texts);
		}
	}
	gtk_clist_thaw(GTK_CLIST(ggv->pagelist));
        return TRUE;
}


  /****************/
 /* Callbacks... */
/****************/
static void about_callback(GtkWidget *widget, gpointer data) 
{
	GtkWidget *about = NULL;

	gchar *authors[] = {
		"Szekeres Istvan <szekeres@cyberspace.mht.bme.hu>",
                "Jonathan Blandford <jrb@redhat.com>",
		NULL
	};

	about = gnome_about_new(_("Ghostview for Gnome"), "0.1",
				"Copyright (C) 1998 the Free Software Foundation",
				(const gchar **) authors,
				_("Postscript(TM) document viewer.\nBased on Tim Theisen's excellent Ghostview application (last modified by ."),
				NULL);
        gtk_widget_show(about);
}
static void button_press_callback(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
        ggv_window *ggv = (ggv_window *)data;
        gint button = event->button;
        gint x = 0;
        gint y = 0;


        if (event->window == GTK_GS (ggv->gs)->pstarget) {
                gdk_window_get_position (event->window, &x, &y);
        }
        x += event->x;
        y += event->y;
        if (GTK_WIDGET_VISIBLE(ggv->popup_menu)) {
                gtk_menu_popdown(GTK_MENU(ggv->popup_menu));
                if (button == 3)
                        return;
        }
        switch(button) {
        case 1:
                /* uncomment this to mark a section to crop.
                 * it has been removed until it clears correctly */
                   
                /*                clear_crop (ggv->cd, ggv->gs->window);
                 *                crop_button_clicked (ggv->cd, x, y);
                 *                draw_crop (ggv->cd, ggv->gs->window);
                 */
                break;
        case 2:
                break;
        case 3:
                gtk_menu_popup (GTK_MENU(ggv->popup_menu), NULL, NULL, NULL, NULL,
                                event->button, event->time);
                break;
        default:
                break;
        }
}
static void
button_release_callback(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
        ggv_window *ggv = (ggv_window *)data;

        switch(event->button) {
        case 1:
                ggv->cd->incrop=0;
                break;
        default:
                break;
        }
}
static void
close_cmd (GtkWidget *widget, ggv_window *ggv)
{
        /* do we want to save changes??? */
	window_list = g_list_remove (window_list, ggv);

	gtk_widget_destroy (GTK_WIDGET (ggv->main_window));

        active_ggv--;

	if (active_ggv == 0)
		gtk_main_quit ();

}


static gint
exit_callback(GtkWidget *widget, gpointer data) 
{

        ggv_window *ggv;

        /* do we want to save anything before we exit??? */        

        while (g_list_length(window_list)> 0) {
                /* This is probably not the cleanest way
                   to traverse the list, but I don't know any other yet,
                   besides, it should not be a problem, the list should
                   be very small anyways */

                /*  g_print("List lenght %d\n", g_list_length(window_list)); */
                ggv = (ggv_window*)g_list_nth_data (window_list,0);
                window_list = g_list_remove (window_list, ggv);
                gtk_widget_destroy (GTK_WIDGET (ggv->main_window));
        }
        

	gtk_main_quit();

	return 0;
}
static void file_open_destroy_callback(GtkWidget *widget, gpointer data)
{
        gtk_widget_hide(file_sel);
}
static void file_open_ok_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *)data;
        gchar *file;

	gtk_widget_hide(file_sel);

	file = gtk_file_selection_get_filename(GTK_FILE_SELECTION(file_sel));

        if (load_gs(ggv, file))
            ggv->loaded = TRUE;
            
}
static void help_callback(GtkWidget *widget, gpointer data) {}
static void
hide_menubar_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;

        if (ggv->menubar_hidden) {
                gtk_widget_show ((GNOME_APP(ggv->main_window))->menubar);
                ggv->menubar_hidden = FALSE;
                
        } else {
                gtk_widget_hide ((GNOME_APP(ggv->main_window))->menubar);
                ggv->menubar_hidden = TRUE;
        }
}
static void
hide_toolbar_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;

        if (ggv->toolbar_hidden) {
                gtk_widget_show (ggv->sidebar);
                ggv->toolbar_hidden = FALSE;
        } else {
                gtk_widget_hide (ggv->sidebar);
                ggv->toolbar_hidden = TRUE;
        }
}
static void
motion_callback(GtkWidget *widget, GdkEventMotion *event, gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;
        
        mouse_moved (ggv->cd, ggv->gs->window, 
                     event->x, event->y,
                     ggv->main_window->allocation.width,
                     ggv->main_window->allocation.height);
}
static void
key_pressed_event_callback(GtkWidget *widget, GdkEventKey *event, gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;
        gint key = event->keyval;
        gint orientation = gtk_gs_get_orientation (GTK_GS (ggv->gs));

        if (!ggv->loaded)
                return;
        /*ugh. the possibilities! */
        switch (key) {
        case GDK_space:
                switch (orientation) {
                case GTK_GS_ORIENTATION_PORTRAIT:
                        if (!gtk_scrollpane_step_down (GTK_SCROLLPANE (ggv->scrollpane))) {
                                gtk_gs_goto_page ( GTK_GS (ggv->gs), GTK_GS (ggv->gs)->current_page+1);
                                gtk_clist_select_row (GTK_CLIST (ggv->pagelist), GTK_GS (ggv->gs)->current_page,1);
                        }
                        break;
                case GTK_GS_ORIENTATION_LANDSCAPE:
                        if (!gtk_scrollpane_step_left (GTK_SCROLLPANE (ggv->scrollpane))) {
                                gtk_gs_goto_page ( GTK_GS (ggv->gs), GTK_GS (ggv->gs)->current_page+1);
                                gtk_clist_select_row (GTK_CLIST (ggv->pagelist), GTK_GS (ggv->gs)->current_page,1);
                        }
                        break;
                case GTK_GS_ORIENTATION_SEASCAPE:
                        if (!gtk_scrollpane_step_right (GTK_SCROLLPANE (ggv->scrollpane))) {
                                gtk_gs_goto_page ( GTK_GS (ggv->gs), GTK_GS (ggv->gs)->current_page+1);
                                gtk_clist_select_row (GTK_CLIST (ggv->pagelist), GTK_GS (ggv->gs)->current_page,1);
                        }
                        break;
                case GTK_GS_ORIENTATION_UPSIDEDOWN:
                        if (!gtk_scrollpane_step_up (GTK_SCROLLPANE (ggv->scrollpane))) {
                                gtk_gs_goto_page ( GTK_GS (ggv->gs), GTK_GS (ggv->gs)->current_page+1);
                                gtk_clist_select_row (GTK_CLIST (ggv->pagelist), GTK_GS (ggv->gs)->current_page,1);
                        }
                        break;
                }
                gtk_signal_emit_stop_by_name (GTK_OBJECT(ggv->main_window), "key_press_event");
                break;
        case GDK_BackSpace:
        case GDK_Delete:
                switch (orientation) {
                case GTK_GS_ORIENTATION_PORTRAIT:
                        if (!gtk_scrollpane_step_up (GTK_SCROLLPANE (ggv->scrollpane))) {
                                gtk_gs_goto_page ( GTK_GS (ggv->gs), GTK_GS (ggv->gs)->current_page-1);
                                gtk_clist_select_row (GTK_CLIST (ggv->pagelist), GTK_GS (ggv->gs)->current_page,1);
                        }
                        break;
                case GTK_GS_ORIENTATION_LANDSCAPE:
                        if (!gtk_scrollpane_step_right (GTK_SCROLLPANE (ggv->scrollpane))) {
                                gtk_gs_goto_page ( GTK_GS (ggv->gs), GTK_GS (ggv->gs)->current_page-1);
                                gtk_clist_select_row (GTK_CLIST (ggv->pagelist), GTK_GS (ggv->gs)->current_page,1);
                        }
                        break;
                case GTK_GS_ORIENTATION_SEASCAPE:
                        if (!gtk_scrollpane_step_left (GTK_SCROLLPANE (ggv->scrollpane))) {
                                gtk_gs_goto_page ( GTK_GS (ggv->gs), GTK_GS (ggv->gs)->current_page-1);
                                gtk_clist_select_row (GTK_CLIST (ggv->pagelist), GTK_GS (ggv->gs)->current_page,1);
                        }
                        break;
                case GTK_GS_ORIENTATION_UPSIDEDOWN:
                        if (!gtk_scrollpane_step_down (GTK_SCROLLPANE (ggv->scrollpane))) {
                                gtk_gs_goto_page ( GTK_GS (ggv->gs), GTK_GS (ggv->gs)->current_page-1);
                                gtk_clist_select_row (GTK_CLIST (ggv->pagelist), GTK_GS (ggv->gs)->current_page,1);
                        }
                        break;
                }
                gtk_signal_emit_stop_by_name (GTK_OBJECT(ggv->main_window), "key_press_event");
                break;
        case GDK_Left:
                gtk_scrollpane_step_left (GTK_SCROLLPANE (ggv->scrollpane));
                gtk_signal_emit_stop_by_name (GTK_OBJECT(ggv->main_window), "key_press_event");
                break;
        case GDK_Right:
                gtk_scrollpane_step_right (GTK_SCROLLPANE (ggv->scrollpane));
                gtk_signal_emit_stop_by_name (GTK_OBJECT(ggv->main_window), "key_press_event");
                break;
        case GDK_Up:
                gtk_scrollpane_step_up (GTK_SCROLLPANE (ggv->scrollpane));
                gtk_signal_emit_stop_by_name (GTK_OBJECT(ggv->main_window), "key_press_event");
                break;
        case GDK_Down:
                gtk_scrollpane_step_down (GTK_SCROLLPANE (ggv->scrollpane));
                gtk_signal_emit_stop_by_name (GTK_OBJECT(ggv->main_window), "key_press_event");
                break;
        case GDK_Page_Up:
                gtk_gs_goto_page (GTK_GS(ggv->gs), GTK_GS(ggv->gs)->current_page-1);
                gtk_clist_select_row (GTK_CLIST (ggv->pagelist), GTK_GS (ggv->gs)->current_page,1);
                gtk_signal_emit_stop_by_name (GTK_OBJECT(ggv->main_window), "key_press_event");
                break;
        case GDK_Page_Down:
                gtk_gs_goto_page (GTK_GS(ggv->gs), GTK_GS(ggv->gs)->current_page+1);
                gtk_clist_select_row (GTK_CLIST (ggv->pagelist), GTK_GS (ggv->gs)->current_page,1);
                gtk_signal_emit_stop_by_name (GTK_OBJECT(ggv->main_window), "key_press_event");
                break;
        }
}
static void next_page_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;

        g_print("Entering next page");
        if (ggv->loaded) {
                g_print("going to next page");
                gtk_gs_goto_page (GTK_GS(ggv->gs), GTK_GS(ggv->gs)->current_page+1);
                gtk_clist_select_row (GTK_CLIST (ggv->pagelist), GTK_GS (ggv->gs)->current_page,1);
        }
}
static void open_callback(GtkWidget *widget, gpointer data)
{
	if (file_sel) {
		gtk_widget_show(file_sel);
		return;
	}

	file_sel = gtk_file_selection_new("ggv: Open File");
	gtk_signal_connect(GTK_OBJECT(file_sel), "delete_event",
			   GTK_SIGNAL_FUNC(file_open_destroy_callback), data);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_sel)->cancel_button),
			   "clicked",
			   GTK_SIGNAL_FUNC(file_open_destroy_callback), data);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_sel)->ok_button),
			   "clicked",
			   GTK_SIGNAL_FUNC(file_open_ok_callback), data);

        gtk_widget_show(file_sel);
}
static void orientation_callback(GtkWidget *widget, gpointer data)
{
        window_with_data *wwd = (window_with_data *) data;
        ggv_window *ggv = wwd->ggv;

        if (gtk_gs_set_orientation (GTK_GS(ggv->gs), wwd->data))
                gtk_gs_goto_page (GTK_GS(ggv->gs), GTK_GS(ggv->gs)->current_page);
}
static void preferences_callback(GtkWidget *widget, gpointer data) {}
static void previous_page_callback(GtkWidget *widget, gpointer data) 
{
        ggv_window *ggv = (ggv_window *) data;

        if (ggv->loaded) {
                gtk_gs_goto_page (GTK_GS(ggv->gs), GTK_GS(ggv->gs)->current_page-1);
                gtk_clist_select_row (GTK_CLIST (ggv->pagelist), GTK_GS (ggv->gs)->current_page,1);
        }
}
static void print_callback(GtkWidget *widget, gpointer data) {}
static void recenter_page_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;

        if (ggv->loaded)
                gtk_gs_center_page (GTK_GS (ggv->gs));
}
static void reload_callback(GtkWidget *widget, gpointer data) 
{
        ggv_window *ggv = (ggv_window *) data;

        //gtk_gs_load (GTK_GS (ggv->gs), GTK_GS (ggv->gs)->gs_filename_raw);

}
static void save_callback(GtkWidget *widget, gpointer data) {}
static void save_as_callback(GtkWidget *widget, gpointer data) {}
static void
scrollpane_middle_click_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;

        if (ggv->loaded) {
                gtk_gs_goto_page (GTK_GS(ggv->gs), GTK_GS(ggv->gs)->current_page-1);
                gtk_clist_select_row (GTK_CLIST (ggv->pagelist), GTK_GS (ggv->gs)->current_page,1);
        }
}
static void
scrollpane_right_click_callback(GtkWidget *widget, gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;

        if (ggv->loaded) {
                gtk_gs_goto_page (GTK_GS(ggv->gs), GTK_GS(ggv->gs)->current_page+1);
                gtk_clist_select_row (GTK_CLIST (ggv->pagelist), GTK_GS (ggv->gs)->current_page,1);
        }
}
static void select_page_callback(GtkWidget *widget, gint row, gint column, GdkEventButton *event, gpointer data)
{
        ggv_window *ggv = (ggv_window *) data;

        gtk_gs_goto_page (GTK_GS (ggv->gs), row);
}

static double compute_zoom(gint zoom_spec)
{
        double a,b;
        if ((zoom_spec>>8) == 144) {
                a = sqrt(2.0);
        }
        else {
                a = (double)(zoom_spec>>8);
        }
        if ((zoom_spec & 0xff) == 144) {
                b = sqrt(2.0);
        }
        else {
                b = (double)(zoom_spec & 0xff);
        }
        return a/b;
}

static void zoom_callback(GtkWidget *widget, gpointer data)
{
        window_with_data *wwd = (window_with_data *) data;
        ggv_window *ggv = wwd->ggv;
        double z;

        if (ggv->zoom_value == wwd->data) 
                return;
        ggv->zoom_value = wwd->data;

        z = compute_zoom(wwd->data);

        g_print("Changing zoom mag: %f\n", z);

        /* Return if no active doc */
        if (!ggv->loaded) {
                g_assert(ggv->gs);
                GTK_GS(ggv->gs)->zoom_factor = z;
                return;
        }
        gtk_gs_set_zoom (GTK_GS (ggv->gs), z);
        gtk_gs_goto_page (GTK_GS (ggv->gs), GTK_GS(ggv->gs)->current_page);        
}

static void
create_popup_menus(ggv_window *ggv)
{
        /* we do this the really hard way, unfortunately... */

        GtkWidget *next = gtk_menu_item_new_with_label (_("Next"));
        GtkWidget *prev = gtk_menu_item_new_with_label (_("Prev"));
        GtkWidget *separator = gtk_menu_item_new ();
        ggv->show_hide_menubar = gtk_menu_item_new_with_label (_("Hide Menubar"));
        ggv->show_hide_toolbar = gtk_menu_item_new_with_label (_("Hide Side Panel"));
        ggv->popup_menu = gtk_menu_new ();

        gtk_menu_append (GTK_MENU (ggv->popup_menu), next);
        gtk_menu_append (GTK_MENU (ggv->popup_menu), prev);
        gtk_menu_append (GTK_MENU (ggv->popup_menu), separator);
        gtk_menu_append (GTK_MENU (ggv->popup_menu), ggv->show_hide_menubar);
        gtk_menu_append (GTK_MENU (ggv->popup_menu), ggv->show_hide_toolbar);

        gtk_signal_connect_object (GTK_OBJECT(ggv->show_hide_menubar), "activate", GTK_SIGNAL_FUNC(hide_menubar_callback), (gpointer) ggv);
        gtk_signal_connect_object (GTK_OBJECT(ggv->show_hide_toolbar), "activate", GTK_SIGNAL_FUNC(hide_toolbar_callback), (gpointer) ggv);
        
        gtk_widget_show (next);
        gtk_widget_show (prev);
        gtk_widget_show (separator);
        gtk_widget_show (ggv->show_hide_menubar);
        gtk_widget_show (ggv->show_hide_toolbar);
}        
        

static void
create_menus(ggv_window *retval, window_with_data **temp)
{
        GnomeUIInfo orientationMenu2[] = {
                {GNOME_APP_UI_ITEM, N_("Automatic"), NULL, orientation_callback, temp[0], NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
                {GNOME_APP_UI_SEPARATOR},
                {GNOME_APP_UI_ITEM, N_("Portrait"), NULL, orientation_callback, temp[1], NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
                {GNOME_APP_UI_ITEM, N_("Landscape"), NULL, orientation_callback, temp[2], NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
                {GNOME_APP_UI_ITEM, N_("Seascape"), NULL, orientation_callback, temp[3], NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
                {GNOME_APP_UI_ITEM, N_("Upside Down"), NULL, orientation_callback, temp[4], NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
                {GNOME_APP_UI_ENDOFINFO, NULL, NULL, NULL, NULL, NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL}
        };
        
        GnomeUIInfo orientationMenu[] = {
                {GNOME_APP_UI_RADIOITEMS, NULL , NULL, orientationMenu2, NULL, NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
                GNOMEUIINFO_END,
        };
        
        GnomeUIInfo zoomMenu2[] = {
                GNOMEUIINFO_RADIOITEM_DATA("1:1", NULL, zoom_callback, temp[10], NULL),
                GNOMEUIINFO_RADIOITEM_DATA("1:10" , NULL, zoom_callback,temp[5] , NULL),
                GNOMEUIINFO_RADIOITEM_DATA("1:8" , NULL, zoom_callback,temp[6], NULL),
                GNOMEUIINFO_RADIOITEM_DATA("1:4", NULL, zoom_callback,temp[7], NULL),
                GNOMEUIINFO_RADIOITEM_DATA("1:2", NULL, zoom_callback,temp[8], NULL),
                GNOMEUIINFO_RADIOITEM_DATA("1:1.4", NULL, zoom_callback,temp[9], NULL),
                GNOMEUIINFO_RADIOITEM_DATA("1.4:1", NULL, zoom_callback,temp[11] , NULL),
                GNOMEUIINFO_RADIOITEM_DATA("2:1", NULL, zoom_callback,temp[12], NULL),
                GNOMEUIINFO_RADIOITEM_DATA("4:1", NULL, zoom_callback,temp[13], NULL),
                GNOMEUIINFO_RADIOITEM_DATA("8:1", NULL, zoom_callback,temp[14], NULL),
                GNOMEUIINFO_RADIOITEM_DATA("10:1", NULL, zoom_callback,temp[15], NULL),
                GNOMEUIINFO_END,
        };
        
        GnomeUIInfo zoomMenu[] = {
                {GNOME_APP_UI_RADIOITEMS, NULL , NULL, zoomMenu2, NULL, NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
                GNOMEUIINFO_END,
        };
        
        GnomeUIInfo fileMenu[] = {
                {GNOME_APP_UI_ITEM, N_("Open"), NULL, open_callback, retval, NULL,
                 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 0, 0, NULL},
                {GNOME_APP_UI_ITEM, N_("Reload"), NULL, reload_callback, retval, NULL,
                 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REFRESH, 0, 0, NULL},
                {GNOME_APP_UI_SEPARATOR},
                {GNOME_APP_UI_ITEM, N_("Preferences..."), NULL, preferences_callback, retval, NULL,
                 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF, 0, 0, NULL},
                {GNOME_APP_UI_SEPARATOR},
                {GNOME_APP_UI_ITEM, N_("Print..."), NULL, print_callback, retval, NULL,
                 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PRINT, 0, 0, NULL},
                {GNOME_APP_UI_ITEM, N_("Save"), NULL, save_callback, retval, NULL,
                 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, 0, 0, NULL},
                {GNOME_APP_UI_ITEM, N_("Save as..."), NULL, save_as_callback, retval, NULL,
                 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, 0, 0, NULL},
                {GNOME_APP_UI_SEPARATOR},
                {GNOME_APP_UI_ITEM, N_("Recently Used Docs"), NULL, NULL, NULL, NULL,
                 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_OPEN, 0, 0, NULL},
                {GNOME_APP_UI_SEPARATOR},
                {GNOME_APP_UI_ITEM, N_("Close"), NULL, close_cmd, retval, NULL,
                 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT, 0, 0, NULL},
                {GNOME_APP_UI_SEPARATOR},
                {GNOME_APP_UI_ITEM, N_("Exit"), NULL, exit_callback, retval, NULL,
                 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT, 0, 0, NULL},
                {GNOME_APP_UI_ENDOFINFO, NULL, NULL, NULL, NULL, NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL}
        };
        
        GnomeUIInfo documentMenu[] = {
                {GNOME_APP_UI_ITEM, N_("Next Page"), NULL, next_page_callback, retval, NULL,
                 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_FORWARD, 0, 0, NULL},
                {GNOME_APP_UI_ITEM, N_("Previous Page"), NULL, previous_page_callback, retval, NULL,
                 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BACK, 0, 0, NULL},
                {GNOME_APP_UI_ITEM, N_("Recenter Page"), NULL, recenter_page_callback, retval, NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
                {GNOME_APP_UI_SEPARATOR},
                {GNOME_APP_UI_SUBTREE, N_("Orientation"), NULL, orientationMenu, NULL, NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
                {GNOME_APP_UI_SUBTREE, N_("Zoom"), NULL, zoomMenu, NULL, NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
                {GNOME_APP_UI_SEPARATOR},
                {GNOME_APP_UI_ITEM, N_("Show/Hide Menubar"), NULL, hide_menubar_callback, retval, NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
                {GNOME_APP_UI_ITEM, N_("Show/Hide Side Panel"), NULL, hide_toolbar_callback, retval, NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
                {GNOME_APP_UI_ENDOFINFO}
        };
        
        GnomeUIInfo helpMenu[] = {
                {GNOME_APP_UI_HELP, NULL, NULL, NULL, NULL, NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
                {GNOME_APP_UI_ITEM, N_("Help with ggv..."), NULL, help_callback, NULL, NULL,
                 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL},
                {GNOME_APP_UI_SEPARATOR},
                {GNOME_APP_UI_ITEM, N_("About..."), NULL, about_callback, retval, NULL,
                 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL},
                {GNOME_APP_UI_ENDOFINFO, NULL, NULL, NULL, NULL, NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL}
        };
        
        GnomeUIInfo mainMenu[] = {
                {GNOME_APP_UI_SUBTREE, N_("File"), NULL, fileMenu, NULL, NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
                {GNOME_APP_UI_SUBTREE, N_("Document"), NULL, documentMenu, NULL, NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
                {GNOME_APP_UI_SUBTREE, N_("Help"), NULL, helpMenu, NULL, NULL,
                 GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
                {GNOME_APP_UI_ENDOFINFO}
        };

        /* We set up the main window... */
        

	gnome_app_create_menus (GNOME_APP (retval->main_window), mainMenu);
}        



/* main functions */

static
ggv_window *create_ggv_window()
{
        ggv_window *retval = g_malloc (sizeof (ggv_window));
        gint i;
        window_with_data *temp[16];
        GtkWidget *pic;
        GtkWidget *npbhbox;
        GtkWidget *hbox;
        GtkWidget *vbox;
        GtkWidget *sbvbox;
        GtkWidget *sbframe;

        /* create the main window. */
        retval->main_window = gnome_app_new("ggv", "ggv:");
        retval->cd = NULL;
	gtk_signal_connect (GTK_OBJECT (retval->main_window), "delete_event",
                            GTK_SIGNAL_FUNC (exit_callback), retval);

        /* Set up the callback values for the orientation */
        for (i = 0; i < 16; i++) {
                temp[i] = g_malloc (sizeof (window_with_data));
                temp[i]->ggv = retval;
                garbage_can = g_list_append (garbage_can, temp[i]);
        }
        temp[0]->data = GTK_GS_ORIENTATION_DEFAULT;
        temp[1]->data = GTK_GS_ORIENTATION_PORTRAIT;
        temp[2]->data = GTK_GS_ORIENTATION_LANDSCAPE;
        temp[3]->data = GTK_GS_ORIENTATION_SEASCAPE;
        temp[4]->data = GTK_GS_ORIENTATION_UPSIDEDOWN;

        /* Two bytes a,b, they make up the ratio as in a/b.
           sqrt(2) is special case, hence it is handled as
           144 by zoom_callback */

        temp[5]->data = 1 << 8 | 10;
        temp[6]->data = 1 << 8 | 8;
        temp[7]->data = 1 << 8 | 4;
        temp[8]->data = 1 << 8 | 2;
        temp[9]->data = 1 << 8 | 144 ;
        temp[10]->data = 1 << 8 | 1;
        temp[11]->data = 144 << 8 | 1;
        temp[12]->data = 2 << 8 | 1;
        temp[13]->data = 4 << 8 | 1;
        temp[14]->data = 8 << 8 | 1;
        temp[15]->data = 10 << 8 | 1 ;

        
        /* Menus: */
        create_menus (retval, temp);
        create_popup_menus(retval);
        

        /* We set up the layout */
        hbox = gtk_hbox_new (FALSE, 0);
        vbox = gtk_vbox_new (FALSE, 0);

        retval->hadj = gtk_adjustment_new(0.1, 0.0, 1.0, 1.0, 1.0, 0.5);
        retval->vadj = gtk_adjustment_new(0.1, 0.0, 1.0, 1.0, 1.0, 0.5);


        /* we set up the post script display */
        retval->gs = gtk_gs_new (GTK_ADJUSTMENT (retval->hadj),
                                 GTK_ADJUSTMENT (retval->vadj));
        gtk_widget_set_events (retval->gs, 
                               GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK | GDK_POINTER_MOTION_MASK);
        gtk_widget_set_usize (retval->gs, 400, 600);
        gtk_widget_show (retval->gs);
        

        /* we prepare for the crop data */
        retval->cd = g_malloc (sizeof (crop_data));

        /* We set up the sidebar */
        retval->sidebar = gtk_handle_box_new ();
        gtk_widget_show (retval->sidebar);
        retval->toolbar_hidden = FALSE;
        retval->menubar_hidden = FALSE;
        sbframe = gtk_frame_new (NULL);
        gtk_frame_set_shadow_type (GTK_FRAME (sbframe), GTK_SHADOW_NONE);
        sbvbox = gtk_vbox_new (FALSE, 0);
        retval->zoom_value = 1 << 8 | 1; /* 1 : 1 */
        retval->coordinates = gtk_label_new (" ");
        gtk_widget_show (retval->coordinates);

        
        retval->scrollpane = gtk_scrollpane_new(GTK_ADJUSTMENT (retval->hadj), GTK_ADJUSTMENT (retval->vadj), 1.0);
        gtk_signal_connect (GTK_OBJECT(retval->scrollpane), "middle_clicked", GTK_SIGNAL_FUNC(scrollpane_middle_click_callback), retval);
        gtk_signal_connect (GTK_OBJECT(retval->scrollpane), "right_clicked", GTK_SIGNAL_FUNC(scrollpane_right_click_callback), retval);
	gtk_widget_set_usize (retval->scrollpane, 80, 80);
        gtk_widget_show (retval->scrollpane);
        
        npbhbox = gtk_hbox_new (TRUE, 0);
        retval->nextbutton = gtk_button_new ();
        retval->prevbutton = gtk_button_new ();

        pic = gnome_stock_pixmap_widget_new(retval->prevbutton, GNOME_STOCK_MENU_BACK);
        gtk_widget_show (pic);
        gtk_container_add (GTK_CONTAINER (retval->prevbutton), pic);
        pic = gnome_stock_pixmap_widget_new(retval->prevbutton, GNOME_STOCK_MENU_FORWARD);
        gtk_widget_show (pic);
        gtk_container_add (GTK_CONTAINER (retval->nextbutton), pic);
        gtk_signal_connect (GTK_OBJECT(retval->nextbutton), "clicked", GTK_SIGNAL_FUNC(next_page_callback), retval);
        gtk_signal_connect (GTK_OBJECT(retval->prevbutton), "clicked", GTK_SIGNAL_FUNC(previous_page_callback), retval);
        gtk_container_add (GTK_CONTAINER (npbhbox), retval->prevbutton);
        gtk_container_add (GTK_CONTAINER (npbhbox), retval->nextbutton);
        gtk_widget_show (retval->prevbutton);
        gtk_widget_show (retval->nextbutton);
        gtk_widget_show (npbhbox);

        retval->pagelist = gtk_clist_new(2);
	gtk_widget_set_usize (retval->pagelist, 80, 300);
	gtk_clist_set_column_width (GTK_CLIST (retval->pagelist), 1, 10);
	gtk_clist_set_column_width (GTK_CLIST (retval->pagelist), 2, 20);
	gtk_clist_set_selection_mode (GTK_CLIST (retval->pagelist), GTK_SELECTION_BROWSE);
	gtk_clist_set_column_justification (GTK_CLIST (retval->pagelist), 1, GTK_JUSTIFY_CENTER);
	gtk_clist_set_column_justification (GTK_CLIST (retval->pagelist), 2, GTK_JUSTIFY_RIGHT);
        gtk_signal_connect(GTK_OBJECT(retval->pagelist), "select_row", GTK_SIGNAL_FUNC(select_page_callback),retval);
	gtk_widget_show (retval->pagelist);

        gtk_box_pack_start (GTK_BOX (sbvbox), retval->coordinates, FALSE, FALSE, 0);
        gtk_box_pack_start (GTK_BOX (sbvbox), retval->scrollpane, FALSE, FALSE, 0);
        gtk_box_pack_start (GTK_BOX (sbvbox), npbhbox, FALSE, FALSE, 2 );
        gtk_container_add (GTK_CONTAINER (sbvbox), retval->pagelist);
        gtk_container_add (GTK_CONTAINER (sbframe), sbvbox);
        gtk_container_add (GTK_CONTAINER (retval->sidebar), sbframe);
        gtk_widget_show(sbvbox);
        gtk_widget_show (sbframe); 


        /* We layout the page */
        gtk_box_pack_start (GTK_BOX (hbox), retval->sidebar, FALSE, FALSE, 0);
        gtk_box_pack_start (GTK_BOX (hbox), retval->gs, TRUE, TRUE, 0);
        gtk_widget_show(hbox);
        gtk_widget_show(vbox);

        retval->loaded = FALSE;
	gnome_app_set_contents(GNOME_APP(retval->main_window), hbox);
        gtk_signal_connect (GTK_OBJECT(retval->gs), "button_press_event", GTK_SIGNAL_FUNC (button_press_callback), retval);
        gtk_signal_connect (GTK_OBJECT(retval->gs), "button_release_event", GTK_SIGNAL_FUNC (button_release_callback), retval);
        gtk_signal_connect (GTK_OBJECT(retval->gs), "motion_notify_event", GTK_SIGNAL_FUNC (motion_callback), retval);
        gtk_signal_connect (GTK_OBJECT(retval->main_window), "key_press_event", GTK_SIGNAL_FUNC(key_pressed_event_callback), retval);

        return retval;
}





/* and we finally start the main prog. */
int
main(int argc, char *argv[])
{
        GList *list;
	poptContext ctx;
	char **startups;
	int i;
        
        active_ggv=0;

        bindtextdomain (PACKAGE, GNOMELOCALEDIR);
        textdomain (PACKAGE);

	gnome_init_with_popt_table("gnome-ghostview", VERSION, argc, argv, NULL, 0, &ctx);

        window_list = NULL;
        garbage_can = NULL;
        startups = poptGetArgs(ctx);
        if(startups) {
                for(i = 0; startups[i]; i++) {
                        ggv_window *ggv = create_ggv_window ();
                        g_print("Startup Options %s\n", startups[i]);
                        gtk_widget_show (ggv->main_window);
                        active_ggv ++;
                        if (load_gs (ggv, startups[i])) {                                
                                ggv->loaded = TRUE;
                        }
                        else {
                                
                        }
                        /* Even if not loaded the window has been created */
                        window_list = g_list_append (window_list, ggv);

                }
        }
	poptFreeContext(ctx);

        if (window_list == NULL) {
                ggv_window *ggv = create_ggv_window ();
                active_ggv ++;
                window_list = g_list_alloc();
                window_list->data = ggv;
                gtk_widget_show (ggv->main_window);
        }

        file_sel = NULL;

	gtk_main ();
        return 0;
}
