/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * ggv-postscript-view.h.
 *
 * Authors:  Jaka Mocnik  <jaka@gnu.org>
 *
 * Copyright (c) 2001 Free Software Foundation
 */

#ifndef _GGV_POSTSCRIPT_VIEW_H_
#define _GGV_POSTSCRIPT_VIEW_H_

#include <gtkgs.h>

#include <gnome.h>

#include <bonobo.h>

#include <Ggv.h>

G_BEGIN_DECLS

#define GGV_POSTSCRIPT_VIEW_TYPE          (ggv_postscript_view_get_type ())
#define GGV_POSTSCRIPT_VIEW(o)            (GTK_CHECK_CAST ((o), GGV_POSTSCRIPT_VIEW_TYPE, GgvPostscriptView))
#define GGV_POSTSCRIPT_VIEW_CLASS(k)      (GTK_CHECK_CLASS_CAST((k), GGV_POSTSCRIPT_VIEW_TYPE, GgvPostscriptViewClass))
#define GGV_IS_POSTSCRIPT_VIEW(o)         (GTK_CHECK_TYPE ((o), GGV_POSTSCRIPT_VIEW_TYPE))
#define GGV_IS_POSTSCRIPT_VIEW_CLASS(k)   (GTK_CHECK_CLASS_TYPE ((k), GGV_POSTSCRIPT_VIEW_TYPE))

typedef struct _GgvPostscriptView             GgvPostscriptView;
typedef struct _GgvPostscriptViewClass        GgvPostscriptViewClass;
typedef struct _GgvPostscriptViewPrivate      GgvPostscriptViewPrivate;
typedef struct _GgvPostscriptViewClassPrivate GgvPostscriptViewClassPrivate;

struct _GgvPostscriptView {
	BonoboObject base;

	GgvPostscriptViewPrivate *priv;
};

struct _GgvPostscriptViewClass {
	BonoboObjectClass parent_class;

	POA_GNOME_GGV_PostscriptView__epv epv;

	GgvPostscriptViewClassPrivate *priv;
};

GtkType               ggv_postscript_view_get_type              (void);
GgvPostscriptView     *ggv_postscript_view_new                  (GtkGS *gs,
								 gboolean zoom_fit);
GgvPostscriptView     *ggv_postscript_view_construct            (GgvPostscriptView *ps_view,
								 GtkGS *gs,
								 gboolean zoom_fit);
BonoboPropertyBag     *ggv_postscript_view_get_property_bag     (GgvPostscriptView *image_view);
BonoboPropertyControl *ggv_postscript_view_get_property_control (GgvPostscriptView *image_view);
void                  ggv_postscript_view_set_ui_container      (GgvPostscriptView *image_view,
								 Bonobo_UIContainer ui_container);
void                  ggv_postscript_view_unset_ui_container    (GgvPostscriptView *image_view);
GtkWidget             *ggv_postscript_view_get_widget           (GgvPostscriptView *image_view);
void	              ggv_postscript_view_print                 (GgvPostscriptView *image_view,
								 gboolean preview);


/* Zooming */
float ggv_postscript_view_get_zoom_factor (GgvPostscriptView *image_view);
void  ggv_postscript_view_set_zoom_factor (GgvPostscriptView *image_view,
					   float zoom_factor);
gfloat ggv_postscript_view_zoom_to_fit     (GgvPostscriptView *image_view,
					    gboolean fit_width);
void  ggv_postscript_view_set_zoom        (GgvPostscriptView *image_view,
					   double zoomx,
					   double zoomy);

BonoboObject *ggv_postscript_view_add_interfaces (GgvPostscriptView *ps_view,
						  BonoboObject *to_aggregate);

void ggv_postscript_view_goto_page(GgvPostscriptView *ps_view, gint page);

/* Properties */
void
ggv_postscript_view_set_orientation (GgvPostscriptView *ps_view,
				     GNOME_GGV_Orientation orientation);
GNOME_GGV_Orientation
ggv_postscript_view_get_orientation (GgvPostscriptView *ps_view);

void
ggv_postscript_view_set_size        (GgvPostscriptView *ps_view,
				     GNOME_GGV_Size size);
GNOME_GGV_Size
ggv_postscript_view_get_size        (GgvPostscriptView *ps_view);

GtkAdjustment *ggv_postscript_view_get_hadj(GgvPostscriptView *ps_view);
GtkAdjustment *ggv_postscript_view_get_vadj(GgvPostscriptView *ps_view);


G_END_DECLS

#endif /* _GGV_POSTSCRIPT_VIEW_H_ */
