/*
 * gIDE calculator plugin
 *
 * Shows a calculator
 */

#include <config.h>

#include <gnome.h>
#include <bonobo.h>
#include <liboaf/liboaf.h>
#include <libgide/libgide.h>
#include <unistd.h>
#include <sys/stat.h>
#include <gdl/GDL.h>

#define CALCULATOR_COMPONENT_IID "OAFIID:GNOME_Development_Plugin:calculator"
#define PLUGIN_NAME			"gide-calculator-plugin"
#define PLUGIN_XML			"gide-calculator-plugin.xml"

static void
calculator(
	GtkWidget*			widget,
	gpointer			data
)
{
	GtkWidget*			window;
	GtkWidget*			calc;

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window), _("Calculator"));
	gtk_signal_connect(GTK_OBJECT(window), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), NULL);

	calc = gnome_calculator_new();
	gtk_container_add(GTK_CONTAINER(window), calc);
	gtk_window_add_accel_group(GTK_WINDOW(window),
		GNOME_CALCULATOR(calc)->accel);

	gtk_widget_show_all(window);
}

/*
 * Define the verbs in this plugin
 */
static BonoboUIVerb verbs[] = {
	BONOBO_UI_UNSAFE_VERB("Calculator", calculator),
	BONOBO_UI_VERB_END
};

/*
 * Boilerplate initialization function
 */
static gboolean
impl_init(
	GideTool*			tool,
	gpointer			closure
)
{
	BonoboUIComponent*		uic;
	CORBA_Environment		ev;

	g_return_val_if_fail(tool != NULL, FALSE);
	g_return_val_if_fail(GIDE_IS_TOOL(tool), FALSE);

	CORBA_exception_init(&ev);

	uic = bonobo_ui_component_new(PLUGIN_NAME);
	bonobo_ui_component_set_container(uic, tool->ui_container);
	bonobo_ui_util_set_ui(uic, GIDE_DATADIR, PLUGIN_XML,
		PLUGIN_NAME);

	bonobo_ui_component_add_verb_list_with_data(uic, verbs, tool);

	CORBA_exception_free(&ev);

	return TRUE;
}

/*
 * Boilerplace cleanup function
 */
static void
impl_cleanup(
	GideTool*			tool,
	gpointer			closure
)
{
	CORBA_Environment		ev;

	CORBA_exception_init(&ev);
	CORBA_exception_free(&ev);
}

/*
 * Boilerplate creation function
 */
static CORBA_Object
make_object(
	PortableServer_POA		poa,
	const char*			iid,
	gpointer			impl_ptr,
	CORBA_Environment*		ev
)
{
	GideTool*			tool;

	tool = gide_tool_new(impl_init, impl_cleanup, NULL);

	oaf_plugin_use(poa, impl_ptr);

	return BONOBO_OBJREF (tool->props);
}

/*
 * List of plugins
 */
static const OAFPluginObject plugin_list[] =
{
	{
		CALCULATOR_COMPONENT_IID,
		make_object
	},
	{
		NULL
	}
};

/*
 * Plugin description
 */
const OAFPlugin OAF_Plugin_info = {
	plugin_list,
	"gIDE Calculator Plugin"
};
