/*
 * gIDE text plugin
 *
 * Contains all text based plugins:
 *  - insert date and time
 *  - insert GPL header (C and C++)
 *  - insert file
 *  - delete BOF, EOF, BOL, EOL
 *  - replace tabs with spaces
 */

#include <config.h>

#include <libgide/libgide.h>

#include "text-insert.h"
#include "text-delete.h"
#include "text-replace.h"

#define TEXT_COMPONENT_IID "OAFIID:GNOME_Development_Plugin:text"
#define PLUGIN_NAME			"gide-text-plugin"
#define PLUGIN_XML			"gide-text-plugin.xml"


/*
 * Define the verbs in this plugin
 */
static BonoboUIVerb verbs[] = {
	BONOBO_UI_UNSAFE_VERB("TextInsertDateTime", text_insert_date),
	BONOBO_UI_UNSAFE_VERB("TextInsertGplC", text_insert_gpl_c),
	BONOBO_UI_UNSAFE_VERB("TextInsertGplCpp", text_insert_gpl_cpp),
	BONOBO_UI_UNSAFE_VERB("TextInsertFile", text_insert_file),
	BONOBO_UI_UNSAFE_VERB("TextDeleteBOF", text_delete_to_bof),
	BONOBO_UI_UNSAFE_VERB("TextDeleteEOF", text_delete_to_eof),
	BONOBO_UI_UNSAFE_VERB("TextDeleteBOL", text_delete_to_bol),
	BONOBO_UI_UNSAFE_VERB("TextDeleteEOL", text_delete_to_eol),
	BONOBO_UI_UNSAFE_VERB("TextReplaceTabs", text_replace_tab_spaces),
	BONOBO_UI_VERB_END
};

/*
 * Boilerplate initialization function
 */
static gboolean
impl_init(
	GideTool*			tool,
	gpointer			closure
)
{
	BonoboUIComponent*		uic;
	CORBA_Environment		ev;

	g_return_val_if_fail(tool != NULL, FALSE);
	g_return_val_if_fail(GIDE_IS_TOOL(tool), FALSE);

	CORBA_exception_init(&ev);

	uic = bonobo_ui_component_new(PLUGIN_NAME);
	bonobo_ui_component_set_container(uic, tool->ui_container);
	bonobo_ui_util_set_ui(uic, GIDE_DATADIR, PLUGIN_XML,
		PLUGIN_NAME);

	bonobo_ui_component_add_verb_list_with_data(uic, verbs, tool);

	CORBA_exception_free(&ev);

	return TRUE;
}

/*
 * Boilerplace cleanup function
 */
static void
impl_cleanup(
	GideTool*			tool,
	gpointer			closure
)
{
}

/*
 * Boilerplate creation function
 */
static CORBA_Object
make_object(
	PortableServer_POA		poa,
	const char*			iid,
	gpointer			impl_ptr,
	CORBA_Environment*		ev
)
{
	GideTool*			tool;

	tool = gide_tool_new(impl_init, impl_cleanup, NULL);

	oaf_plugin_use(poa, impl_ptr);

	return BONOBO_OBJREF (tool->props);
}

/*
 * List of plugins
 */
static const OAFPluginObject plugin_list[] =
{
	{
		TEXT_COMPONENT_IID,
		make_object
	},
	{
		NULL
	}
};

/*
 * Plugin description
 */
const OAFPlugin OAF_Plugin_info = {
	plugin_list,
	"gIDE Text Plugin"
};
