// Generated by gtkmmproc -- DO NOT MODIFY!


#include <giomm/file.h>
#include <giomm/private/file_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>
#include <utility>
#include <glibmm/error.h>
#include <glibmm/exceptionhandler.h>

namespace {

typedef std::pair<Gio::File::SlotReadMore*, Gio::SlotAsyncReady*> LoadPartialSlots;

static void
SignalProxy_async_callback(GObject*, GAsyncResult* res, void* data)
{
  Gio::SlotAsyncReady* the_slot = static_cast<Gio::SlotAsyncReady*>(data);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    Glib::RefPtr<Gio::AsyncResult> result = Glib::wrap(res, true /* take copy */);
    (*the_slot)(result);
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  delete the_slot;
}

static void
SignalProxy_file_progress_callback(goffset current_num_bytes,
                                   goffset total_num_bytes,
                                   gpointer data)
{
  Gio::File::SlotFileProgress* the_slot = static_cast<Gio::File::SlotFileProgress*>(data);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED

    (*the_slot)(current_num_bytes, total_num_bytes);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  delete the_slot;
}

// TODO: here it is supposed that the callback is invoked multiple times.
// If not, then it should be deleted here, not in async_packed_callback.
static gboolean
SignalProxy_read_more_callback(const char* file_contents, goffset file_size, gpointer data)
{
  LoadPartialSlots* slot_pair = static_cast<LoadPartialSlots*>(data);
  Gio::File::SlotReadMore* the_slot = slot_pair->first;

  bool result = false;

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED

    result = (*the_slot)(file_contents, file_size);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  return result;
}

// Same as SignalProxy_async_callback, except that this one knows that
// the slot is packed in a pair. The operation is assumed to be finished
// after the callback is triggered, so we delete that pair here.
static void
SignalProxy_async_packed_callback(GObject*, GAsyncResult* res, void* data)
{
  LoadPartialSlots* slot_pair = static_cast<LoadPartialSlots*>(data);
  Gio::SlotAsyncReady* the_slot = slot_pair->second;

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    Glib::RefPtr<Gio::AsyncResult> result = Glib::wrap(res, true /* take copy */);
    (*the_slot)(result);
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  delete the_slot;
  delete slot_pair->first; // read_more slot
  delete slot_pair;
}

} // anonymous namespace

namespace Gio {

Glib::RefPtr<File>
File::create_for_path(const std::string& path)
{
  GFile* cfile = g_file_new_for_path(path.c_str());
  return Glib::wrap(G_FILE(cfile));
}

Glib::RefPtr<File>
File::create_for_uri(const std::string& uri)
{
  GFile* cfile = g_file_new_for_uri(uri.c_str());
  return Glib::wrap(G_FILE(cfile));
}

Glib::RefPtr<File>
File::create_for_commandline_arg(const std::string& arg)
{
  GFile* cfile = g_file_new_for_commandline_arg(arg.c_str());
  return Glib::wrap(G_FILE(cfile));
}

Glib::RefPtr<File>
File::create_for_parse_name(const Glib::ustring& parse_name)
{
  GFile* cfile = g_file_parse_name(parse_name.c_str());
  return Glib::wrap(G_FILE(cfile));
}

bool
File::equal(const Glib::RefPtr<File>& other) const
{
  return static_cast<bool>(
    g_file_equal(const_cast<GFile*>(this->gobj()),
                 const_cast<GFile*>(other->gobj())));
}

void
File::read_async(int io_priority,
                 Glib::RefPtr<Cancellable>& cancellable,
                 const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_read_async(gobj(),
                    io_priority,
                    cancellable->gobj(),
                    &SignalProxy_async_callback,
                    slot_copy);
}

void
File::append_to_async(FileCreateFlags flags,
                      int io_priority,
                      const Glib::RefPtr<Cancellable>& cancellable,
                      const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_append_to_async(gobj(),
                         static_cast<GFileCreateFlags>(flags),
                         io_priority,
                         cancellable->gobj(),
                         &SignalProxy_async_callback,
                         slot_copy);
}

void
File::append_to_async(FileCreateFlags flags,
                      int io_priority,
                      const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_append_to_async(gobj(),
                         static_cast<GFileCreateFlags>(flags),
                         io_priority,
                         NULL, // cancellable
                         &SignalProxy_async_callback,
                         slot_copy);
}

void
File::create_file_async(FileCreateFlags flags,
                   int io_priority,
                   const Glib::RefPtr<Cancellable>& cancellable,
                   const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_create_async(gobj(),
                      static_cast<GFileCreateFlags>(flags),
                      io_priority,
                      cancellable->gobj(),
                      &SignalProxy_async_callback,
                      slot_copy);
}

void
File::create_file_async(FileCreateFlags flags,
                   int io_priority,
                   const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_create_async(gobj(),
                      static_cast<GFileCreateFlags>(flags),
                      io_priority,
                      NULL, // cancellable
                      &SignalProxy_async_callback,
                      slot_copy);
}

void
File::replace_async(const std::string& etag,
                    bool make_backup,
                    FileCreateFlags flags,
                    int io_priority,
                    const Glib::RefPtr<Cancellable>& cancellable,
                    const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_replace_async(gobj(),
                       etag.c_str(),
                       make_backup,
                       static_cast<GFileCreateFlags>(flags),
                       io_priority,
                       cancellable->gobj(),
                       &SignalProxy_async_callback,
                       slot_copy);
}

void
File::replace_async(const std::string& etag,
                    bool make_backup,
                    FileCreateFlags flags,
                    int io_priority,
                    const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_replace_async(gobj(),
                       etag.c_str(),
                       make_backup,
                       static_cast<GFileCreateFlags>(flags),
                       io_priority,
                       NULL, // cancellable
                       &SignalProxy_async_callback,
                       slot_copy);
}

void
File::query_info_async(const std::string& attributes,
                       FileQueryInfoFlags flags,
                       int io_priority,
                       const Glib::RefPtr<Cancellable>& cancellable,
                       const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_query_info_async(gobj(),
                          attributes.c_str(),
                          static_cast<GFileQueryInfoFlags>(flags),
                          io_priority,
                          cancellable->gobj(),
                          &SignalProxy_async_callback,
                          slot_copy);
}

void
File::query_info_async(const std::string& attributes,
                       FileQueryInfoFlags flags,
                       int io_priority,
                       const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_query_info_async(gobj(),
                          attributes.c_str(),
                          static_cast<GFileQueryInfoFlags>(flags),
                          io_priority,
                          NULL, // cancellable
                          &SignalProxy_async_callback,
                          slot_copy);
}

void
File::enumerate_children_async(const std::string& attributes,
                               FileQueryInfoFlags flags,
                               int io_priority,
                               const Glib::RefPtr<Cancellable>& cancellable,
                               const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_enumerate_children_async(gobj(),
                                  attributes.c_str(),
                                  static_cast<GFileQueryInfoFlags>(flags),
                                  io_priority,
                                  cancellable->gobj(),
                                  &SignalProxy_async_callback,
                                  slot_copy);
}

void
File::enumerate_children_async(const std::string& attributes,
                               FileQueryInfoFlags flags,
                               int io_priority,
                               const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_enumerate_children_async(gobj(),
                                  attributes.c_str(),
                                  static_cast<GFileQueryInfoFlags>(flags),
                                  io_priority,
                                  NULL,
                                  &SignalProxy_async_callback,
                                  slot_copy);
}

void
File::set_display_name_async(const std::string& display_name,
                             int io_priority,
                             const Glib::RefPtr<Cancellable>& cancellable,
                             const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_set_display_name_async(gobj(),
                                display_name.c_str(),
                                io_priority,
                                cancellable->gobj(),
                                &SignalProxy_async_callback,
                                slot_copy);
}

void
File::set_display_name_async(const std::string& display_name,
                             int io_priority,
                             const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_set_display_name_async(gobj(),
                                display_name.c_str(),
                                io_priority,
                                NULL,
                                &SignalProxy_async_callback,
                                slot_copy);
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool
File::copy(const Glib::RefPtr<File>& destination,
           FileCopyFlags flags,
           const Glib::RefPtr<Cancellable>& cancellable,
           const SlotFileProgress& slot)
#else
bool
File::copy(const Glib::RefPtr<File>& destination,
           FileCopyFlags flags,
           const Glib::RefPtr<Cancellable>& cancellable,
           const SlotFileProgress& slot,
           std::auto_ptr<Glib::Error>& error)
#endif // GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool res;

  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotFileProgress* slot_copy = new SlotFileProgress(slot);

  res = g_file_copy(gobj(),
                    destination->gobj(),
                    static_cast<GFileCopyFlags>(flags),
                    cancellable->gobj(),
                    &SignalProxy_file_progress_callback,
                    slot_copy,
                    &gerror);

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if (gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if (gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return res;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool
File::copy(const Glib::RefPtr<File>& destination,
           FileCopyFlags flags,
           const SlotFileProgress& slot)
#else
bool
File::copy(const Glib::RefPtr<File>& destination,
           FileCopyFlags flags,
           const SlotFileProgress& slot,
           std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool res;

  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotFileProgress* slot_copy = new SlotFileProgress(slot);

  res = g_file_copy(gobj(),
                    destination->gobj(),
                    static_cast<GFileCopyFlags>(flags),
                    NULL,
                    &SignalProxy_file_progress_callback,
                    slot_copy,
                    &gerror);

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if (gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if (gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return res;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool
File::move(const Glib::RefPtr<File>& destination,
           FileCopyFlags flags,
           const Glib::RefPtr<Cancellable>& cancellable,
           const SlotFileProgress& slot)
#else
bool
File::move(const Glib::RefPtr<File>& destination,
           FileCopyFlags flags,
           const Glib::RefPtr<Cancellable>& cancellable,
           const SlotFileProgress& slot,
           std::auto_ptr<Glib::Error>& error)
#endif // GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool res;

  // Create a move of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotFileProgress* slot_copy = new SlotFileProgress(slot);

  res = g_file_move(gobj(),
                    destination->gobj(),
                    static_cast<GFileCopyFlags>(flags),
                    cancellable->gobj(),
                    &SignalProxy_file_progress_callback,
                    slot_copy,
                    &gerror);

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if (gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if (gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return res;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool
File::move(const Glib::RefPtr<File>& destination,
           FileCopyFlags flags,
           const SlotFileProgress& slot)
#else
bool
File::move(const Glib::RefPtr<File>& destination,
           FileCopyFlags flags,
           const SlotFileProgress& slot,
           std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool res;

  // Create a move of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotFileProgress* slot_copy = new SlotFileProgress(slot);

  res = g_file_move(gobj(),
                    destination->gobj(),
                    static_cast<GFileCopyFlags>(flags),
                    NULL,
                    &SignalProxy_file_progress_callback,
                    slot_copy,
                    &gerror);

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if (gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if (gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return res;
}

void
File::set_attributes_async(const Glib::RefPtr<FileInfo>& info,
                           FileQueryInfoFlags flags,
                           int io_priority,
                           const Glib::RefPtr<Cancellable>& cancellable,
                           const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_set_attributes_async(gobj(),
                              info->gobj(),
                              static_cast<GFileQueryInfoFlags>(flags),
                              io_priority,
                              cancellable->gobj(),
                              &SignalProxy_async_callback,
                              slot_copy);
}

void
File::set_attributes_async(const Glib::RefPtr<FileInfo>& info,
                           FileQueryInfoFlags flags,
                           int io_priority,
                           const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_set_attributes_async(gobj(),
                              info->gobj(),
                              static_cast<GFileQueryInfoFlags>(flags),
                              io_priority,
                              NULL,
                              &SignalProxy_async_callback,
                              slot_copy);
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool
File::set_attributes_finish(const Glib::RefPtr<AsyncResult>& result,
                            const Glib::RefPtr<FileInfo>& info)
#else
bool
File::set_attributes_finish(const Glib::RefPtr<AsyncResult>& result,
                            const Glib::RefPtr<FileInfo>& info,
                            std::auto_ptr<Glib::Error>& error)
#endif // GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  GFileInfo* cinfo = info->gobj();
  bool res;

  res = g_file_set_attributes_finish(gobj(),
                                     result->gobj(),
                                     &cinfo,
                                     &gerror);

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if (gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if (gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return res;
}

void File::mount_mountable(const Glib::RefPtr<MountOperation>& mount_operation, const Glib::RefPtr<Cancellable>& cancellable, const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_mount_mountable(gobj(),
                         mount_operation->gobj(),
                         cancellable->gobj(),
                         &SignalProxy_async_callback,
                         slot_copy);
}

void File::mount_mountable(const Glib::RefPtr<MountOperation>& mount_operation, const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_mount_mountable(gobj(),
                         mount_operation->gobj(),
                         NULL,
                         &SignalProxy_async_callback,
                         slot_copy);
}

void File::mount_mountable(const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_mount_mountable(gobj(),
                         NULL,
                         NULL,
                         &SignalProxy_async_callback,
                         slot_copy);
}

void File::unmount_mountable(GMountUnmountFlags flags, const Glib::RefPtr<Cancellable>& cancellable, const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_unmount_mountable(gobj(),
                           flags, 
                           cancellable->gobj(),
                           &SignalProxy_async_callback,
                           slot_copy);
}

void
File::unmount_mountable(GMountUnmountFlags flags, const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_unmount_mountable(gobj(),
                           flags, 
                           NULL,
                           &SignalProxy_async_callback,
                           slot_copy);
}

void
File::eject_mountable(GMountUnmountFlags flags, const Glib::RefPtr<Cancellable>& cancellable, const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_eject_mountable(gobj(),
                         flags, 
                         cancellable->gobj(),
                         &SignalProxy_async_callback,
                         slot_copy);
}

void
File::eject_mountable(GMountUnmountFlags flags, const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_eject_mountable(gobj(),
                         flags, 
                         NULL,
                         &SignalProxy_async_callback,
                         slot_copy);
}

void
File::load_contents_async(const Glib::RefPtr<Cancellable>& cancellable,
                          const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_load_contents_async(gobj(),
                             cancellable->gobj(),
                             &SignalProxy_async_callback,
                             slot_copy);
}

void
File::load_contents_async(const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_load_contents_async(gobj(),
                             NULL,
                             &SignalProxy_async_callback,
                             slot_copy);
}

void
File::load_partial_contents_async(const Glib::RefPtr<Cancellable>& cancellable,
                                  const SlotReadMore& slot_read_more,
                                  const SlotAsyncReady& slot_async_ready)
{
  // Create a new pair which will hold copies of passed slots.
  LoadPartialSlots* slots = new LoadPartialSlots();
  SlotReadMore* slot_read_more_copy = new SlotReadMore(slot_read_more);
  SlotAsyncReady* slot_async_copy = new SlotAsyncReady(slot_async_ready);

  slots->first = slot_read_more_copy;
  slots->second = slot_async_copy;

  g_file_load_partial_contents_async(gobj(),
                                     cancellable->gobj(),
                                     &SignalProxy_read_more_callback,
                                     &SignalProxy_async_packed_callback,
                                     slots);
}

void
File::load_partial_contents_async(const SlotReadMore& slot_read_more,
                                  const SlotAsyncReady& slot_async_ready)
{
  // Create a new pair which will hold copies of passed slots.
  LoadPartialSlots* slots = new LoadPartialSlots();
  SlotReadMore* slot_read_more_copy = new SlotReadMore(slot_read_more);
  SlotAsyncReady* slot_async_copy = new SlotAsyncReady(slot_async_ready);

  slots->first = slot_read_more_copy;
  slots->second = slot_async_copy;

  g_file_load_partial_contents_async(gobj(),
                                     NULL,
                                     &SignalProxy_read_more_callback,
                                     &SignalProxy_async_packed_callback,
                                     slots);
}

void
File::replace_contents_async(const char* contents,
                             gsize length,
                             const char* etag,
                             bool make_backup,
                             FileCreateFlags flags,
                             const Glib::RefPtr<Cancellable>& cancellable,
                             const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_replace_contents_async(gobj(),
                                contents,
                                length,
                                etag,
                                make_backup,
                                static_cast<GFileCreateFlags>(flags),
                                cancellable->gobj(),
                                &SignalProxy_async_callback,
                                slot_copy);
}

void
File::replace_contents_async(const char* contents,
                             gsize length,
                             const char* etag,
                             bool make_backup,
                             FileCreateFlags flags,
                             const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_replace_contents_async(gobj(),
                                contents,
                                length,
                                etag,
                                make_backup,
                                static_cast<GFileCreateFlags>(flags),
                                NULL,
                                &SignalProxy_async_callback,
                                slot_copy);
}

} // namespace Gio

namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gio::File> wrap(GFile* object, bool take_copy)
{
  return Glib::RefPtr<Gio::File>( dynamic_cast<Gio::File*> (Glib::wrap_auto_interface<Gio::File> ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} // namespace Glib


namespace Gio
{


/* The *_Class implementation: */

const Glib::Interface_Class& File_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Interface_Class has to know the interface init function
    // in order to add interfaces to implementing types.
    class_init_func_ = &File_Class::iface_init_function;

    // We can not derive from another interface, and it is not necessary anyway.
    gtype_ = g_file_get_type();
  }

  return *this;
}

void File_Class::iface_init_function(void* g_iface, void*)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_iface);

  //This is just to avoid an "unused variable" warning when there are no vfuncs or signal handlers to connect.
  //This is a temporary fix until I find out why I can not seem to derive a GtkFileChooser interface. murrayc
  g_assert(klass != 0); 

#ifdef GLIBMM_VFUNCS_ENABLED
  klass->dup = &dup_vfunc_callback;
  klass->hash = &hash_vfunc_callback;
  klass->get_basename = &get_basename_vfunc_callback;
  klass->get_path = &get_path_vfunc_callback;
  klass->get_uri = &get_uri_vfunc_callback;
  klass->get_parse_name = &get_parse_name_vfunc_callback;
  klass->get_parent = &get_parent_vfunc_callback;
  klass->contains_file = &contains_file_vfunc_callback;
  klass->get_relative_path = &get_relative_path_vfunc_callback;
  klass->resolve_relative_path = &resolve_relative_path_vfunc_callback;
  klass->is_native = &is_native_vfunc_callback;
  klass->has_uri_scheme = &has_uri_scheme_vfunc_callback;
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
GFile* File_Class::dup_vfunc_callback(GFile* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap(obj->dup_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->dup)
    return (*base->dup)(self);


  typedef GFile* RType;
  return RType();
}
guint File_Class::hash_vfunc_callback(GFile* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return obj->hash_vfunc();
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->hash)
    return (*base->hash)(self);


  typedef guint RType;
  return RType();
}
char* File_Class::get_basename_vfunc_callback(GFile* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return g_strdup((obj->get_basename_vfunc()).c_str());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_basename)
    return (*base->get_basename)(self);


  typedef char* RType;
  return RType();
}
char* File_Class::get_path_vfunc_callback(GFile* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return g_strdup((obj->get_path_vfunc()).c_str());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_path)
    return (*base->get_path)(self);


  typedef char* RType;
  return RType();
}
char* File_Class::get_uri_vfunc_callback(GFile* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return g_strdup((obj->get_uri_vfunc()).c_str());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_uri)
    return (*base->get_uri)(self);


  typedef char* RType;
  return RType();
}
char* File_Class::get_parse_name_vfunc_callback(GFile* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return g_strdup((obj->get_parse_name_vfunc()).c_str());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_parse_name)
    return (*base->get_parse_name)(self);


  typedef char* RType;
  return RType();
}
GFile* File_Class::get_parent_vfunc_callback(GFile* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap(obj->get_parent_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_parent)
    return (*base->get_parent)(self);


  typedef GFile* RType;
  return RType();
}
gboolean File_Class::contains_file_vfunc_callback(GFile* self, GFile* descendant)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->contains_file_vfunc(Glib::wrap(descendant, true)
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->contains_file)
    return (*base->contains_file)(self, descendant);


  typedef gboolean RType;
  return RType();
}
char* File_Class::get_relative_path_vfunc_callback(GFile* self, GFile* descendant)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return g_strdup((obj->get_relative_path_vfunc(Glib::wrap(descendant, true)
)).c_str());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_relative_path)
    return (*base->get_relative_path)(self, descendant);


  typedef char* RType;
  return RType();
}
GFile* File_Class::resolve_relative_path_vfunc_callback(GFile* self, const char* relative_path)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap(obj->resolve_relative_path_vfunc(Glib::convert_const_gchar_ptr_to_stdstring(relative_path)
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->resolve_relative_path)
    return (*base->resolve_relative_path)(self, relative_path);


  typedef GFile* RType;
  return RType();
}
gboolean File_Class::is_native_vfunc_callback(GFile* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->is_native_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->is_native)
    return (*base->is_native)(self);


  typedef gboolean RType;
  return RType();
}
gboolean File_Class::has_uri_scheme_vfunc_callback(GFile* self, const char* uri_scheme)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->has_uri_scheme_vfunc(Glib::convert_const_gchar_ptr_to_stdstring(uri_scheme)
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->has_uri_scheme)
    return (*base->has_uri_scheme)(self, uri_scheme);


  typedef gboolean RType;
  return RType();
}
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* File_Class::wrap_new(GObject* object)
{
  return new File((GFile*)(object));
}


/* The implementation: */

File::File()
:
  Glib::Interface(file_class_.init())
{}

File::File(GFile* castitem)
:
  Glib::Interface((GObject*)(castitem))
{}

File::~File()
{}

// static
void File::add_interface(GType gtype_implementer)
{
  file_class_.init().add_interface(gtype_implementer);
}

File::CppClassType File::file_class_; // initialize static member

GType File::get_type()
{
  return file_class_.init().get_type();
}

GType File::get_base_type()
{
  return g_file_get_type();
}


Glib::RefPtr<File> File::dup() const
{
  return Glib::wrap(g_file_dup(const_cast<GFile*>(gobj())));
}

guint File::hash() const
{
  return g_file_hash(const_cast<GFile*>(gobj()));
}

std::string File::get_basename() const
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_file_get_basename(const_cast<GFile*>(gobj())));
}

std::string File::get_path() const
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_file_get_path(const_cast<GFile*>(gobj())));
}

std::string File::get_uri() const
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_file_get_uri(const_cast<GFile*>(gobj())));
}

Glib::ustring File::get_parse_name() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(g_file_get_parse_name(const_cast<GFile*>(gobj())));
}

Glib::RefPtr<File> File::get_parent() const
{
  return Glib::wrap(g_file_get_parent(const_cast<GFile*>(gobj())));
}

Glib::RefPtr<File> File::get_child(const std::string& name) const
{
  return Glib::wrap(g_file_get_child(const_cast<GFile*>(gobj()), name.c_str()));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<File> File::get_child_for_display_name(const std::string& display_name) const
#else
Glib::RefPtr<File> File::get_child_for_display_name(const std::string& display_name, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<File> retvalue = Glib::wrap(g_file_get_child_for_display_name(const_cast<GFile*>(gobj()), display_name.c_str(), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

bool File::contains_file(const Glib::RefPtr<File>& descendant) const
{
  return g_file_contains_file(const_cast<GFile*>(gobj()), const_cast<GFile*>(Glib::unwrap(descendant)));
}

std::string File::get_relative_path(const Glib::RefPtr<File>& descendant) const
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_file_get_relative_path(const_cast<GFile*>(gobj()), const_cast<GFile*>(Glib::unwrap(descendant))));
}

Glib::RefPtr<File> File::resolve_relative_path(const std::string& relative_path) const
{
  return Glib::wrap(g_file_resolve_relative_path(const_cast<GFile*>(gobj()), relative_path.c_str()));
}

bool File::is_native() const
{
  return g_file_is_native(const_cast<GFile*>(gobj()));
}

bool File::has_uri_scheme(const std::string& uri_scheme) const
{
  return g_file_has_uri_scheme(const_cast<GFile*>(gobj()), uri_scheme.c_str());
}

std::string File::get_uri_scheme() const
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_file_get_uri_scheme(const_cast<GFile*>(gobj())));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<FileInputStream> File::read(const Glib::RefPtr<Cancellable>& cancellable)
#else
Glib::RefPtr<FileInputStream> File::read(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<FileInputStream> retvalue = Glib::wrap(g_file_read(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<const FileInputStream> File::read(const Glib::RefPtr<Cancellable>& cancellable) const
#else
Glib::RefPtr<const FileInputStream> File::read(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  return const_cast<File*>(this)->read(cancellable);
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<FileInputStream> File::read_finish(const Glib::RefPtr<AsyncResult>& result)
#else
Glib::RefPtr<FileInputStream> File::read_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<FileInputStream> retvalue = Glib::wrap(g_file_read_finish(gobj(), Glib::unwrap(result), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<FileOutputStream> File::append_to(FileCreateFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
#else
Glib::RefPtr<FileOutputStream> File::append_to(FileCreateFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<FileOutputStream> retvalue = Glib::wrap(g_file_append_to(gobj(), ((GFileCreateFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<FileOutputStream> File::create_file(FileCreateFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
#else
Glib::RefPtr<FileOutputStream> File::create_file(FileCreateFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<FileOutputStream> retvalue = Glib::wrap(g_file_create(gobj(), ((GFileCreateFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<FileOutputStream> File::replace(const std::string& etag, bool make_backup, FileCreateFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
#else
Glib::RefPtr<FileOutputStream> File::replace(const std::string& etag, bool make_backup, FileCreateFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<FileOutputStream> retvalue = Glib::wrap(g_file_replace(gobj(), etag.c_str(), static_cast<int>(make_backup), ((GFileCreateFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<FileOutputStream> File::append_to_finish(const Glib::RefPtr<AsyncResult>& result)
#else
Glib::RefPtr<FileOutputStream> File::append_to_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<FileOutputStream> retvalue = Glib::wrap(g_file_append_to_finish(gobj(), Glib::unwrap(result), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<FileOutputStream> File::create_file_finish(const Glib::RefPtr<AsyncResult>& result)
#else
Glib::RefPtr<FileOutputStream> File::create_file_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<FileOutputStream> retvalue = Glib::wrap(g_file_create_finish(gobj(), Glib::unwrap(result), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<FileOutputStream> File::replace_finish(const Glib::RefPtr<AsyncResult>& result)
#else
Glib::RefPtr<FileOutputStream> File::replace_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<FileOutputStream> retvalue = Glib::wrap(g_file_replace_finish(gobj(), Glib::unwrap(result), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<FileInfo> File::query_info(const std::string& attributes, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
#else
Glib::RefPtr<FileInfo> File::query_info(const std::string& attributes, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<FileInfo> retvalue = Glib::wrap(g_file_query_info(gobj(), attributes.c_str(), ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<FileInfo> File::query_info_finish(const Glib::RefPtr<AsyncResult>& result)
#else
Glib::RefPtr<FileInfo> File::query_info_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<FileInfo> retvalue = Glib::wrap(g_file_query_info_finish(gobj(), Glib::unwrap(result), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<FileInfo> File::query_filesystem_info(const std::string& attributes, const Glib::RefPtr<Cancellable>& cancellable)
#else
Glib::RefPtr<FileInfo> File::query_filesystem_info(const std::string& attributes, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<FileInfo> retvalue = Glib::wrap(g_file_query_filesystem_info(gobj(), attributes.c_str(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<FileEnumerator> File::enumerate_children(const std::string& attributes, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
#else
Glib::RefPtr<FileEnumerator> File::enumerate_children(const std::string& attributes, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<FileEnumerator> retvalue = Glib::wrap(g_file_enumerate_children(gobj(), attributes.c_str(), ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<FileEnumerator> File::enumerate_children_finish(const Glib::RefPtr<AsyncResult>& result)
#else
Glib::RefPtr<FileEnumerator> File::enumerate_children_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<FileEnumerator> retvalue = Glib::wrap(g_file_enumerate_children_finish(gobj(), Glib::unwrap(result), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<File> File::set_display_name(const std::string& display_name, const Glib::RefPtr<Cancellable>& cancellable)
#else
Glib::RefPtr<File> File::set_display_name(const std::string& display_name, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<File> retvalue = Glib::wrap(g_file_set_display_name(gobj(), display_name.c_str(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<File> File::set_display_name_finish(const Glib::RefPtr<AsyncResult>& result)
#else
Glib::RefPtr<File> File::set_display_name_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<File> retvalue = Glib::wrap(g_file_set_display_name_finish(gobj(), Glib::unwrap(result), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool File::remove(const Glib::RefPtr<Cancellable>& cancellable)
#else
bool File::remove(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_file_delete(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool File::trash(const Glib::RefPtr<Cancellable>& cancellable)
#else
bool File::trash(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_file_trash(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool File::make_directory(const Glib::RefPtr<Cancellable>& cancellable)
#else
bool File::make_directory(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_file_make_directory(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool File::make_symbolic_link(const std::string& symlink_value, const Glib::RefPtr<Cancellable>& cancellable)
#else
bool File::make_symbolic_link(const std::string& symlink_value, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_file_make_symbolic_link(gobj(), symlink_value.c_str(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<FileAttributeInfoList> File::query_settable_attributes(const Glib::RefPtr<Cancellable>& cancellable)
#else
Glib::RefPtr<FileAttributeInfoList> File::query_settable_attributes(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<FileAttributeInfoList> retvalue = Glib::wrap(g_file_query_settable_attributes(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<FileAttributeInfoList> File::query_writable_namespaces(const Glib::RefPtr<Cancellable>& cancellable)
#else
Glib::RefPtr<FileAttributeInfoList> File::query_writable_namespaces(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<FileAttributeInfoList> retvalue = Glib::wrap(g_file_query_writable_namespaces(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool File::set_attributes_from_info(const Glib::RefPtr<FileInfo>& info, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
#else
bool File::set_attributes_from_info(const Glib::RefPtr<FileInfo>& info, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_file_set_attributes_from_info(gobj(), Glib::unwrap(info), ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool File::set_attribute_string(const std::string& attribute, const std::string& value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
#else
bool File::set_attribute_string(const std::string& attribute, const std::string& value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_file_set_attribute_string(gobj(), attribute.c_str(), value.c_str(), ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool File::set_attribute_byte_string(const std::string& attribute, const std::string& value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
#else
bool File::set_attribute_byte_string(const std::string& attribute, const std::string& value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_file_set_attribute_byte_string(gobj(), attribute.c_str(), value.c_str(), ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool File::set_attribute_uint32(const std::string& attribute, guint32 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
#else
bool File::set_attribute_uint32(const std::string& attribute, guint32 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_file_set_attribute_uint32(gobj(), attribute.c_str(), value, ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool File::set_attribute_int32(const std::string& attribute, gint32 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
#else
bool File::set_attribute_int32(const std::string& attribute, gint32 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_file_set_attribute_int32(gobj(), attribute.c_str(), value, ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool File::set_attribute_uint64(const std::string& attribute, guint64 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
#else
bool File::set_attribute_uint64(const std::string& attribute, guint64 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_file_set_attribute_uint64(gobj(), attribute.c_str(), value, ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool File::set_attribute_int64(const std::string& attribute, gint64 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
#else
bool File::set_attribute_int64(const std::string& attribute, gint64 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_file_set_attribute_int64(gobj(), attribute.c_str(), value, ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<File> File::mount_mountable_finish(const Glib::RefPtr<AsyncResult>& result)
#else
Glib::RefPtr<File> File::mount_mountable_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<File> retvalue = Glib::wrap(g_file_mount_mountable_finish(gobj(), Glib::unwrap(result), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool File::unmount_mountable_finish(const Glib::RefPtr<AsyncResult>& result)
#else
bool File::unmount_mountable_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_file_unmount_mountable_finish(gobj(), Glib::unwrap(result), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool File::eject_mountable_finish(const Glib::RefPtr<AsyncResult>& result)
#else
bool File::eject_mountable_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_file_eject_mountable_finish(gobj(), Glib::unwrap(result), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool File::load_contents(const Glib::RefPtr<Cancellable>& cancellable, char** contents, gsize& length, char** etag_out)
#else
bool File::load_contents(const Glib::RefPtr<Cancellable>& cancellable, char** contents, gsize& length, char** etag_out, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_file_load_contents(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), contents, &(length), etag_out, &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool File::load_contents_finish(const Glib::RefPtr<AsyncResult>& result, char** contents, gsize& length, char** etag_out)
#else
bool File::load_contents_finish(const Glib::RefPtr<AsyncResult>& result, char** contents, gsize& length, char** etag_out, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_file_load_contents_finish(gobj(), Glib::unwrap(result), contents, &(length), etag_out, &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool File::load_partial_contents_finish(const Glib::RefPtr<AsyncResult>& result, char** contents, gsize& length, char** etag_out)
#else
bool File::load_partial_contents_finish(const Glib::RefPtr<AsyncResult>& result, char** contents, gsize& length, char** etag_out, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_file_load_partial_contents_finish(gobj(), Glib::unwrap(result), contents, &(length), etag_out, &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void File::replace_contents(const char* contents, gsize length, const char* etag, bool make_backup, FileCreateFlags flags, char** new_etag, const Glib::RefPtr<Cancellable>& cancellable)
#else
void File::replace_contents(const char* contents, gsize length, const char* etag, bool make_backup, FileCreateFlags flags, char** new_etag, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  g_file_replace_contents(gobj(), contents, length, etag, static_cast<int>(make_backup), ((GFileCreateFlags)(flags)), new_etag, const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void File::replace_contents_finish(const Glib::RefPtr<AsyncResult>& result, char** new_etag)
#else
void File::replace_contents_finish(const Glib::RefPtr<AsyncResult>& result, char** new_etag, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  g_file_replace_contents_finish(gobj(), Glib::unwrap(result), new_etag, &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
Glib::RefPtr<File> Gio::File::dup_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->dup)
    return Glib::wrap((*base->dup)(gobj()));

  typedef Glib::RefPtr<File> RType;
  return RType();
}
guint Gio::File::hash_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->hash)
    return (*base->hash)(const_cast<GFile*>(gobj()));

  typedef guint RType;
  return RType();
}
std::string Gio::File::get_basename_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_basename)
    return Glib::convert_const_gchar_ptr_to_stdstring((*base->get_basename)(const_cast<GFile*>(gobj())));

  typedef std::string RType;
  return RType();
}
std::string Gio::File::get_path_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_path)
    return Glib::convert_const_gchar_ptr_to_stdstring((*base->get_path)(const_cast<GFile*>(gobj())));

  typedef std::string RType;
  return RType();
}
std::string Gio::File::get_uri_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_uri)
    return Glib::convert_const_gchar_ptr_to_stdstring((*base->get_uri)(const_cast<GFile*>(gobj())));

  typedef std::string RType;
  return RType();
}
std::string Gio::File::get_parse_name_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_parse_name)
    return Glib::convert_const_gchar_ptr_to_stdstring((*base->get_parse_name)(const_cast<GFile*>(gobj())));

  typedef std::string RType;
  return RType();
}
Glib::RefPtr<File> Gio::File::get_parent_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_parent)
    return Glib::wrap((*base->get_parent)(const_cast<GFile*>(gobj())));

  typedef Glib::RefPtr<File> RType;
  return RType();
}
bool Gio::File::contains_file_vfunc(const Glib::RefPtr<File>& descendant) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->contains_file)
    return (*base->contains_file)(const_cast<GFile*>(gobj()),const_cast<GFile*>(Glib::unwrap(descendant)));

  typedef bool RType;
  return RType();
}
std::string Gio::File::get_relative_path_vfunc(const Glib::RefPtr<File>& descendant) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_relative_path)
    return Glib::convert_const_gchar_ptr_to_stdstring((*base->get_relative_path)(const_cast<GFile*>(gobj()),const_cast<GFile*>(Glib::unwrap(descendant))));

  typedef std::string RType;
  return RType();
}
Glib::RefPtr<File> Gio::File::resolve_relative_path_vfunc(const std::string& relative_path) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->resolve_relative_path)
    return Glib::wrap((*base->resolve_relative_path)(const_cast<GFile*>(gobj()),relative_path.c_str()));

  typedef Glib::RefPtr<File> RType;
  return RType();
}
bool Gio::File::is_native_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->is_native)
    return (*base->is_native)(const_cast<GFile*>(gobj()));

  typedef bool RType;
  return RType();
}
bool Gio::File::has_uri_scheme_vfunc(const std::string& uri_scheme) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->has_uri_scheme)
    return (*base->has_uri_scheme)(const_cast<GFile*>(gobj()),uri_scheme.c_str());

  typedef bool RType;
  return RType();
}
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gio


