// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_FILEOUTPUTSTREAM_H
#define _GIOMM_FILEOUTPUTSTREAM_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>

#include <giomm/outputstream.h>
#include <giomm/seekable.h>
#include <giomm/fileinfo.h>
#include <glibmm/object.h>
#include <glibmm/iochannel.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GFileOutputStream GFileOutputStream;
typedef struct _GFileOutputStreamClass GFileOutputStreamClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class FileOutputStream_Class; } // namespace Gio
namespace Gio
{

/** FileOutputStream provides output streams that write their content to a file.
 *
 * FileOutputStream implements Seekable, which allows the output stream to jump 
 * to arbitrary positions in the file and to truncate the file, provided the 
 * filesystem of the file supports these operations. In addition to the generic 
 * Seekable API, FileOutputStream has its own API for seeking and positioning. 
 * To find the position of a file output stream, use stream_tell(). To find 
 * out if a file output stream supports seeking, use can_seek(). To position a 
 * file output stream, use seek(). To find out if a file output stream supports 
 * truncating, use can_truncate(). To truncate a file output stream, use 
 * truncate().
 *
 * @newin2p16
 */

class FileOutputStream
: public OutputStream,
  public Seekable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef FileOutputStream CppObjectType;
  typedef FileOutputStream_Class CppClassType;
  typedef GFileOutputStream BaseObjectType;
  typedef GFileOutputStreamClass BaseClassType;

private:  friend class FileOutputStream_Class;
  static CppClassType fileoutputstream_class_;

private:
  // noncopyable
  FileOutputStream(const FileOutputStream&);
  FileOutputStream& operator=(const FileOutputStream&);

protected:
  explicit FileOutputStream(const Glib::ConstructParams& construct_params);
  explicit FileOutputStream(GFileOutputStream* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~FileOutputStream();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GFileOutputStream*       gobj()       { return reinterpret_cast<GFileOutputStream*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GFileOutputStream* gobj() const { return reinterpret_cast<GFileOutputStream*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GFileOutputStream* gobj_copy();

private:

  
public:
  //TODO: vfuncs and overloads without Cancellable

  
  /** Queries a file output stream for the given @a attributes . 
   * This function blocks while querying the stream. For the asynchronous 
   * version of this function, see g_file_output_stream_query_info_async(). 
   * While the stream is blocked, the stream will set the pending flag 
   * internally, and any other operations on the stream will fail with 
   * G::IO_ERROR_PENDING.
   * 
   * Can fail if the stream was already closed (with @a error  being set to 
   * G::IO_ERROR_CLOSED), the stream has pending operations (with @a error  being
   * set to G::IO_ERROR_PENDING), or if querying info is not supported for 
   * the stream's interface (with @a error  being set to G::IO_ERROR_NOT_SUPPORTED). In
   * all cases of failure, <tt>0</tt> will be returned.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be set, and <tt>0</tt> will 
   * be returned.
   * @param attributes A file attribute query string.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, <tt>0</tt> to ignore.
   * @return A G::FileInfo for the @a stream , or <tt>0</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileInfo> query_info(const std::string& attributes, const Glib::RefPtr<Cancellable>& cancellable);
#else
  Glib::RefPtr<FileInfo> query_info(const std::string& attributes, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  void query_info_async(const std::string& attributes, int io_priority, Glib::RefPtr<Cancellable>& cancellable, const SlotAsyncReady& slot);
  //TODO: cancellable can probably be NULL.

  
  /** Finalizes the asynchronous query started 
   * by g_file_output_stream_query_info_async().
   * @param result A G::AsyncResult.
   * @param error A G::Error, <tt>0</tt> to ignore.
   * @return A G::FileInfo for the finished query.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<FileInfo> query_info_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  Glib::RefPtr<FileInfo> query_info_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Gets the entity tag for the file when its been written.
   * This must be called after the stream has been written
   * and closed. As the etag can change while writing.
   * @return The entity tag for the stream.
   */
  std::string get_etag() const;
  
  /** Gets the current location within the stream.
   * @return A #goffset of the location within the stream.
   */
  goffset tell() const;
  
  /** Checks if the stream can be seeked.
   * @return <tt>true</tt> if seeking is supported by the stream.
   */
  bool can_seek() const;

  
  /** Seeks to a location in a file output stream.
   * @param offset A #goffset to seek.
   * @param type A G::SeekType.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, <tt>0</tt> to ignore.
   * @return <tt>true</tt> if the seek was successful. <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool seek(goffset offset, Glib::SeekType type, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool seek(goffset offset, Glib::SeekType type, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  //TODO: cancellable can probably be NULL.

  
  /** Checks if the stream can be truncated.
   * @return <tt>true</tt> if stream can be truncated.
   */
  bool can_truncate() const;
  
  /** Truncates a file output stream.
   * @param size A #goffset to truncate the stream at.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error, <tt>0</tt> to ignore.
   * @return <tt>true</tt> if @a stream  is truncated successfully.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool truncate(goffset size, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool truncate(goffset size, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  //TODO: cancellable can probalby be NULL.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::FileOutputStream
   */
  Glib::RefPtr<Gio::FileOutputStream> wrap(GFileOutputStream* object, bool take_copy = false);
}


#endif /* _GIOMM_FILEOUTPUTSTREAM_H */

