// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_VOLUME_H
#define _GIOMM_VOLUME_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>

#include <glibmm/interface.h>
#include <giomm/asyncresult.h>
#include <giomm/cancellable.h>
#include <giomm/drive.h>
#include <giomm/icon.h>
#include <giomm/mountoperation.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GVolume GVolume;
typedef struct _GVolumeClass GVolumeClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class Volume_Class; } // namespace Gio
namespace Gio
{

// Making a forward declaration here to avoid circular dependency.
// file.hg already includes volume.h.
class File;

/** The Volume interface represents user-visible objects that can be mounted.
 * 
 * Mounting a Volume instance is an asynchronous operation. For more information about asynchronous operations, see AsyncReady and SimpleAsyncReady. To 
 * mount a GVolume, first call mount(), optionally providing a MountOperation object and a SlotAsyncReady callback.
 * 
 * Typically, you will not want to provide a MountOperation if automounting all volumes when a desktop session starts since it's not desirable to 
 * put up a lot of dialogs asking for credentials.
 * 
 * The callback will be fired when the operation has resolved (either with success or failure), and a AsyncReady structure will be passed to the callback. 
 * That callback should then call g_volume_mount_finish() with the GVolume instance and the GAsyncReady data to see if the operation was completed 
 * successfully. If an error is present when finish() is called, then it will be filled with any error information.
 *
 * @newin2p16
 */

class Volume : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Volume CppObjectType;
  typedef Volume_Class CppClassType;
  typedef GVolume BaseObjectType;
  typedef GVolumeIface BaseClassType;

private:
  friend class Volume_Class;
  static CppClassType volume_class_;

  // noncopyable
  Volume(const Volume&);
  Volume& operator=(const Volume&);

protected:
  Volume(); // you must derive from this class

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit Volume(GVolume* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Volume();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GVolume*       gobj()       { return reinterpret_cast<GVolume*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GVolume* gobj() const { return reinterpret_cast<GVolume*>(gobject_); }

private:

public:
  
  /** Gets the name of @a volume .
   * @return The name for the given @a volume . The returned string should 
   * be freed when no longer needed.
   */
  std::string get_name() const;
  
  /** Gets the UUID for the @a volume . The reference is typically based on
   * the file system UUID for the volume in question and should be
   * considered an opaque string. Returns <tt>0</tt> if there is no UUID
   * available.
   * @return The UUID for @a volume  or <tt>0</tt> if no UUID can be computed.
   */
  std::string get_uuid() const;

  
  /** Gets the icon for @a volume .
   * @return A G::Icon.
   */
  Glib::RefPtr<Icon> get_icon();
  
  /** Gets the icon for @a volume .
   * @return A G::Icon.
   */
  Glib::RefPtr<const Icon> get_icon() const;

  
  /** Gets the drive for the @a volume .
   * @return A G::Drive or <tt>0</tt> if @a volume  is not associated with a drive.
   */
  Glib::RefPtr<Drive> get_drive();
  
  /** Gets the drive for the @a volume .
   * @return A G::Drive or <tt>0</tt> if @a volume  is not associated with a drive.
   */
  Glib::RefPtr<const Drive> get_drive() const;

  
  /** Checks if a volume can be mounted.
   * @return <tt>true</tt> if the @a volume  can be mounted. <tt>false</tt> otherwise.
   */
  bool can_mount() const;
  
  /** Checks if a volume can be ejected.
   * @return <tt>true</tt> if the @a volume  can be ejected. <tt>false</tt> otherwise.
   */
  bool can_eject() const;

  //TODO: Documentation.

  void mount(const Glib::RefPtr<MountOperation>& mount_operation, const Glib::RefPtr<Cancellable>& cancellable, const SlotAsyncReady& slot);

  void mount(const Glib::RefPtr<MountOperation>& mount_operation, const SlotAsyncReady& slot);
  

  /** Finishes mounting a volume.
   * @param result A G::AsyncResult.
   * @param error A G::Error.
   * @return <tt>true</tt>, <tt>false</tt> if operation failed.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool mount_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  bool mount_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  //TODO: Documentation.
  //TODO: Use MountUnmountFlags instead of GMountUnmountFlags.
  void eject(GMountUnmountFlags flags, const Glib::RefPtr<Cancellable>& cancellable, const SlotAsyncReady& slot);

  void eject(GMountUnmountFlags flags, const SlotAsyncReady& slot);
  

  /** Finishes ejecting a volume.
   * @param result A G::AsyncResult.
   * @param error A G::Error.
   * @return <tt>true</tt>, <tt>false</tt> if operation failed.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool eject_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  bool eject_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  //gtkmmproc error: changed :  signal defs lookup failed

  /* vfuncs */
  //TODO


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::Volume
   */
  Glib::RefPtr<Gio::Volume> wrap(GVolume* object, bool take_copy = false);

} // namespace Glib


#endif /* _GIOMM_VOLUME_H */

