// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_APPLICATION_H
#define _GIOMM_APPLICATION_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <glibmm/variant.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GApplication GApplication;
typedef struct _GApplicationClass GApplicationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class Application_Class; } // namespace Gio
namespace Gio
{

/** TODO
 *
 * @newin{2,26}
 */

class Application : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Application CppObjectType;
  typedef Application_Class CppClassType;
  typedef GApplication BaseObjectType;
  typedef GApplicationClass BaseClassType;

private:  friend class Application_Class;
  static CppClassType application_class_;

private:
  // noncopyable
  Application(const Application&);
  Application& operator=(const Application&);

protected:
  explicit Application(const Glib::ConstructParams& construct_params);
  explicit Application(GApplication* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Application();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GApplication*       gobj()       { return reinterpret_cast<GApplication*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GApplication* gobj() const { return reinterpret_cast<GApplication*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GApplication* gobj_copy();

private:


protected:
  Application();

public:
  //_WRAP_CREATE()

  
  /** Create a new Application.  This uses a platform-specific
   * mechanism to ensure the current process is the unique owner of the
   * application (as defined by the @a appid). If successful, the
   * Application:is-remote property will be <tt>false</tt>, and it is safe to
   * continue creating other resources such as graphics windows.
   * 
   * If the given @a appid is already running in another process, the the
   * GApplication::activate_with_data signal will be emitted in the
   * remote process, with the data from @a argv and other
   * platform-specific data available.  Subsequently the
   * Application:default-quit property will be evaluated.  If it's
   * <tt>true</tt>, then the current process will terminate.  If <tt>false</tt>, then
   * the application remains in the Application:is-remote state, and
   * you can e.g. call g_application_invoke_action(). Note that proxy
   * instances should not call g_application_add_action().
   * 
   * This function may do synchronous I/O to obtain unique ownership
   * of the application id, and will block the calling thread in this
   * case.
   * 
   * If the environment does not support the basic functionality of
   * Application, this function will invoke Glib::error(), which by
   * default is a fatal operation.  This may arise for example on
   * UNIX systems using D-Bus when the session bus is not available.
   * 
   * As a convenience, this function is defined to call Glib::type_init() as
   * its very first action.
   * 
   * @newin{2,26}
   * @param appid System-dependent application identifier.
   * @param argc Number of arguments in @a argv.
   * @param argv Argument vector, usually from the <parameter>argv</parameter> parameter of main().
   * @return An application instance.
   */
  static Glib::RefPtr<Application> create(const Glib::ustring& appid, int argc, char** argv);
  
  //TODO: Documentation
  static Glib::RefPtr<Application> create(const Glib::ustring& appid);

  
  /** This function is similar to g_application_new(), but allows for
   * more graceful fallback if the environment doesn't support the
   * basic Application functionality.
   * 
   * @newin{2,26}
   * @param appid System-dependent application identifier.
   * @param argc Number of arguments in @a argv.
   * @param argv Argument vector, usually from the <parameter>argv</parameter> parameter of main().
   * @return An application instance.
   */
  static Glib::RefPtr<Application> create_try(const Glib::ustring& appid,  int argc, char** argv);
  
   //TODO: Documentation
   static Glib::RefPtr<Application> create_try(const Glib::ustring& appid);

  
  /** This function is similar to g_application_try_new(), but also
   * sets the GApplication:register property to <tt>false</tt>.  You can later
   * call g_application_register() to complete initialization.
   * 
   * @newin{2,26}
   * @param appid System-dependent application identifier.
   * @param argc Number of arguments in @a argv.
   * @param argv Argument vector, usually from the <parameter>argv</parameter> parameter of main().
   * @return An application instance.
   */
  static Glib::RefPtr<Application> create_unregistered_try(const Glib::ustring& appid, int argc, char** argv);
  
   //TODO: Documentation
   static Glib::RefPtr<Application> create_unregistered_try(const Glib::ustring& appid);


  //Renamed from register() because that is a C++ keyword.
  
  /** By default, Application ensures process uniqueness when
   * initialized, but this behavior is controlled by the
   * GApplication:register property.  If it was given as <tt>false</tt> at
   * construction time, this function allows you to later attempt
   * to ensure uniqueness.  Note that the GApplication:default-quit
   * property no longer applies at this point; if this function returns
   * <tt>false</tt>, platform activation will occur, but the current process
   * will not be terminated.
   * 
   * It is an error to call this function more than once.  It is
   * also an error to call this function if the GApplication:register
   * property was <tt>true</tt> at construction time.
   * @return <tt>true</tt> if registration was successful.
   */
  bool register_application();

  
  /** In the normal case where there is exactly one Application instance
   * in this process, return that instance.  If there are multiple, the
   * first one created will be returned.  Otherwise, return <tt>0</tt>.
   * 
   * @newin{2,26}
   * @return The primary instance of Application,
   * or <tt>0</tt> if none is set.
   */
  static Glib::RefPtr<Application> get_instance();
  
  /** Retrieves the platform-specific identifier for the Application.
   * 
   * @newin{2,26}
   * @return The platform-specific identifier. The returned string
   * is owned by the Application instance and it should never be
   * modified or freed.
   */
  Glib::ustring get_id() const;

  
  /** Adds an action @a name to the list of exported actions of @a application.
   * 
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   * 
   * You can invoke an action using g_application_invoke_action().
   * 
   * The newly added action is enabled by default; you can call
   * g_application_set_action_enabled() to disable it.
   * 
   * @newin{2,26}
   * @param name The action name.
   * @param description The action description; can be a translatable
   * string.
   */
  void add_action(const Glib::ustring& name, const Glib::ustring& description);
  
  /** Removes the action @a name from the list of exported actions of @a application.
   * 
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   * 
   * @newin{2,26}
   * @param name The name of the action to remove.
   */
  void remove_action(const Glib::ustring& name);
  
    
  /** Retrieves the list of action names currently exported by @a application.
   * 
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   * 
   * @newin{2,26}
   * @return A newly allocation, <tt>0</tt>-terminated array
   * of strings containing action names; use Glib::strfreev() to free the
   * resources used by the returned array.
   */
  Glib::StringArrayHandle list_actions() const;
  
  
  /** Sets whether the action @a name inside @a application should be enabled
   * or disabled.
   * 
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   * 
   * Invoking a disabled action will not result in the Application::action
   * signal being emitted.
   * 
   * @newin{2,26}
   * @param name The name of the application.
   * @param enabled Whether to enable or disable the action @a name.
   */
  void set_action_enabled(const Glib::ustring& name, bool enabled = true);
  
  /** Retrieves whether the action @a name is enabled or not.
   * 
   * See g_application_set_action_enabled().
   * 
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   * 
   * @newin{2,26}
   * @param name The name of the action.
   * @return <tt>true</tt> if the action was enabled, and <tt>false</tt> otherwise.
   */
  bool get_action_enabled(const Glib::ustring& name) const;
  
  /** Gets the description of the action @a name.
   * 
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   * 
   * @newin{2,26}
   * @param name Action name.
   * @return Description for the given action named @a name.
   */
  Glib::ustring get_action_description(const Glib::ustring& name);
  
  /** Invokes the action @a name of the passed Application.
   * 
   * This function has different behavior depending on whether @a application
   * is acting as a proxy for another process.  In the normal case where
   * the current process is hosting the application, and the specified
   * action exists and is enabled, the Application::action signal will
   * be emitted.
   * 
   * If @a application is a proxy, then the specified action will be invoked
   * in the remote process. It is not necessary to call
   * g_application_add_action() in the current process in order to invoke
   * one remotely.
   * 
   * @newin{2,26}
   * @param name The name of the action to invoke.
   * @param platform_data Platform-specific event data.
   */
  void invoke_action(const Glib::ustring& name, const Glib::VariantBase& platform_data);

  
  /** Starts the application.
   * 
   * The default implementation of this virtual function will simply run
   * a main loop.
   * 
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   * 
   * @newin{2,26}
   */
  void run();
  
  /** Request that the application quits.
   * 
   * This function has different behavior depending on whether @a application
   * is acting as a proxy for another process.  In the normal case where
   * the current process is hosting the application, the default
   * implementation will quit the main loop created by g_application_run().
   * 
   * If @a application is a proxy, then the remote process will be asked
   * to quit.
   * 
   * @newin{2,26}
   * @param platform_data Platform-specific data.
   * @return <tt>true</tt> if the application accepted the request, <tt>false</tt> otherwise.
   */
  bool quit_with_data(const Glib::VariantBase& platform_data);

  
  /** Returns whether the object represents a proxy for a remote application.
   * @return <tt>true</tt> if this object represents a proxy for a remote application.
   */
  bool is_remote() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};


} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::Application
   */
  Glib::RefPtr<Gio::Application> wrap(GApplication* object, bool take_copy = false);
}


#endif /* _GIOMM_APPLICATION_H */

