// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_DBUSMESSAGE_H
#define _GIOMM_DBUSMESSAGE_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <glibmm/variant.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GDBusMessage GDBusMessage;
typedef struct _GDBusMessageClass GDBusMessageClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class DBusMessage_Class; } // namespace Gio
namespace Gio
{

/** @addtogroup giommEnums giomm Enums and Flags */

/**
 * @ingroup giommEnums
 */
enum DBusMessageType
{
  DBUS_MESSAGE_TYPE_INVALID,
  DBUS_MESSAGE_TYPE_METHOD_CALL,
  DBUS_MESSAGE_TYPE_METHOD_RETURN,
  DBUS_MESSAGE_TYPE_ERROR,
  DBUS_MESSAGE_TYPE_SIGNAL
};


/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%DBusMessageFlags operator|(DBusMessageFlags, DBusMessageFlags)</tt><br>
 * <tt>%DBusMessageFlags operator&(DBusMessageFlags, DBusMessageFlags)</tt><br>
 * <tt>%DBusMessageFlags operator^(DBusMessageFlags, DBusMessageFlags)</tt><br>
 * <tt>%DBusMessageFlags operator~(DBusMessageFlags)</tt><br>
 * <tt>%DBusMessageFlags& operator|=(DBusMessageFlags&, DBusMessageFlags)</tt><br>
 * <tt>%DBusMessageFlags& operator&=(DBusMessageFlags&, DBusMessageFlags)</tt><br>
 * <tt>%DBusMessageFlags& operator^=(DBusMessageFlags&, DBusMessageFlags)</tt><br>
 */
enum DBusMessageFlags
{
  DBUS_MESSAGE_FLAGS_NONE = 0x0,
  DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED = (1<<0),
  DBUS_MESSAGE_FLAGS_NO_AUTO_START = (1<<1)
};

/** @ingroup giommEnums */
inline DBusMessageFlags operator|(DBusMessageFlags lhs, DBusMessageFlags rhs)
  { return static_cast<DBusMessageFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusMessageFlags operator&(DBusMessageFlags lhs, DBusMessageFlags rhs)
  { return static_cast<DBusMessageFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusMessageFlags operator^(DBusMessageFlags lhs, DBusMessageFlags rhs)
  { return static_cast<DBusMessageFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusMessageFlags operator~(DBusMessageFlags flags)
  { return static_cast<DBusMessageFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline DBusMessageFlags& operator|=(DBusMessageFlags& lhs, DBusMessageFlags rhs)
  { return (lhs = static_cast<DBusMessageFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusMessageFlags& operator&=(DBusMessageFlags& lhs, DBusMessageFlags rhs)
  { return (lhs = static_cast<DBusMessageFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusMessageFlags& operator^=(DBusMessageFlags& lhs, DBusMessageFlags rhs)
  { return (lhs = static_cast<DBusMessageFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup giommEnums
 */
enum DBusMessageHeaderField
{
  DBUS_MESSAGE_HEADER_FIELD_INVALID,
  DBUS_MESSAGE_HEADER_FIELD_PATH,
  DBUS_MESSAGE_HEADER_FIELD_INTERFACE,
  DBUS_MESSAGE_HEADER_FIELD_MEMBER,
  DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME,
  DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL,
  DBUS_MESSAGE_HEADER_FIELD_DESTINATION,
  DBUS_MESSAGE_HEADER_FIELD_SENDER,
  DBUS_MESSAGE_HEADER_FIELD_SIGNATURE,
  DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS
};


class UnixFDList;

/** DBusMessage - D-Bus Message.
 * A type for representing D-Bus messages that can be sent or received on a
 * DBusConnection.
 *
 * @newin{2,26}
 */

class DBusMessage : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DBusMessage CppObjectType;
  typedef DBusMessage_Class CppClassType;
  typedef GDBusMessage BaseObjectType;
  typedef GDBusMessageClass BaseClassType;

private:  friend class DBusMessage_Class;
  static CppClassType dbusmessage_class_;

private:
  // noncopyable
  DBusMessage(const DBusMessage&);
  DBusMessage& operator=(const DBusMessage&);

protected:
  explicit DBusMessage(const Glib::ConstructParams& construct_params);
  explicit DBusMessage(GDBusMessage* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DBusMessage();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GDBusMessage*       gobj()       { return reinterpret_cast<GDBusMessage*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GDBusMessage* gobj() const { return reinterpret_cast<GDBusMessage*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusMessage* gobj_copy();

private:


protected:
  DBusMessage();
  

public:
  
  /** Creates a new empty DBusMessage.
   * 
   * @newin{2,26}
   * @return A DBusMessage. Free with Glib::object_unref().
   */

  
  static Glib::RefPtr<DBusMessage> create();


  // TODO: We can't use _WRAP_CTOR() and _WRAP_CREATE() because the C functions do more than just call g_object_new():
  // http://bugzilla.gnome.org/show_bug.cgi?id=624977
  // TODO: Should these paramters be ustring or std::string?
  
  /** Creates a new DBusMessage for a signal emission.
   * 
   * @newin{2,26}
   * @param path A valid object path.
   * @param interface A valid D-Bus interface name.
   * @param signal A valid signal name.
   * @return A DBusMessage. Free with Glib::object_unref().
   */
  static Glib::RefPtr<DBusMessage> create_signal(const Glib::ustring& path, const Glib::ustring& interface, const Glib::ustring& signal);
  
  /** Creates a new DBusMessage for a method call.
   * 
   * @newin{2,26}
   * @param name A valid D-Bus name or <tt>0</tt>.
   * @param path A valid object path.
   * @param interface A valid D-Bus interface name or <tt>0</tt>.
   * @param method A valid method name.
   * @return A DBusMessage. Free with Glib::object_unref().
   */
  static Glib::RefPtr<DBusMessage> create_method_call(const Glib::ustring& name, const Glib::ustring& path, const Glib::ustring& interface, const Glib::ustring& method);
  
  /** Creates a new DBusMessage that is a reply to @a method_call_message.
   * 
   * @newin{2,26}
   * @return A DBusMessage. Free with Glib::object_unref().
   */
  static Glib::RefPtr<DBusMessage> create_method_reply(const Glib::RefPtr<DBusMessage>& method_call_message);
  
  /** Creates a new DBusMessage that is an error reply to @a method_call_message.
   * 
   * @newin{2,26}
   * @param error_name A valid D-Bus error name.
   * @param error_message The D-Bus error message.
   * @return A DBusMessage. Free with Glib::object_unref().
   */
  static Glib::RefPtr<DBusMessage> create_method_error_literal(const Glib::RefPtr<const DBusMessage>& method_call_message, const Glib::ustring& error_name, const Glib::ustring& error_message);

  
  /** Produces a human-readable multi-line description of @a message.
   * 
   * The contents of the description has no ABI guarantees, the contents
   * and formatting is subject to change at any time. Typical output
   * looks something like this:
   * <programlisting>
   * Type:    method-call
   * Flags:   none
   * Version: 0
   * Serial:  4
   * Headers:
   * path -> objectpath '/org/gtk/GDBus/TestObject'
   * interface -> 'org.gtk.GDBus.TestInterface'
   * member -> 'GimmeStdout'
   * destination -> ':1.146'
   * Body: ()
   * UNIX File Descriptors:
   * (none)
   * </programlisting>
   * or
   * <programlisting>
   * Type:    method-return
   * Flags:   no-reply-expected
   * Version: 0
   * Serial:  477
   * Headers:
   * reply-serial -> uint32 4
   * destination -> ':1.159'
   * sender -> ':1.146'
   * num-unix-fds -> uint32 1
   * Body: ()
   * UNIX File Descriptors:
   * fd 12: dev=0:10,mode=020620,ino=5,uid=500,gid=5,rdev=136:2,size=0,atime=1273085037,mtime=1273085851,ctime=1272982635
   * </programlisting>
   * 
   * @newin{2,26}
   * @param indent Indentation level.
   * @return A string that should be freed with Glib::free().
   */
  Glib::ustring print(guint indent);

  
  /** Gets the type of @a message.
   * 
   * @newin{2,26}
   * @return A 8-bit unsigned integer (typically a value from the DBusMessageType enumeration).
   */
  DBusMessageType get_message_type() const;
  
  /** Sets @a message to be of @a type.
   * 
   * @newin{2,26}
   * @param type A 8-bit unsigned integer (typically a value from the DBusMessageType enumeration).
   */
  void set_message_type(DBusMessageType type);

  
  /** Gets the serial for @a message.
   * 
   * @newin{2,26}
   * @return A #guint32.
   */
  guint32 get_serial() const;
  
  /** Sets the serial for @a message.
   * 
   * @newin{2,26}
   * @param serial A #guint32.
   */
  void set_serial(guint32 serial);

  
  /** Gets the flags for @a message.
   * 
   * @newin{2,26}
   * @return Flags that are set (typically values from the DBusMessageFlags enumeration bitwise ORed together).
   */
  DBusMessageFlags get_flags() const;
  
  /** Sets the flags to set on @a message.
   * 
   * @newin{2,26}
   * @param flags Flags for @a message that are set (typically values from the DBusMessageFlags
   * enumeration bitwise ORed together).
   */
  void set_flags(DBusMessageFlags flags);

  /** Gets the body of a message.  The body is returned in @a value.
   * @param value Location in which to store the header.
   */
  void get_body(Glib::VariantBase& value) const;
  

  /** Sets the body @a message. As a side-effect the
   * DBUS_MESSAGE_HEADER_FIELD_SIGNATURE header field is set to the
   * type string of @a body (or cleared if @a body is <tt>0</tt>).
   * 
   * If @a body is floating, @a message assumes ownership of @a body.
   * 
   * @newin{2,26}
   * @param body Either <tt>0</tt> or a Variant that is a tuple.
   */
  void set_body(const Glib::VariantBase& body);

  
  /** Gets the UNIX file descriptors associated with @a message, if any.
   * 
   * This method is only available on UNIX.
   * 
   * @newin{2,26}
   * @return A UnixFDList or <tt>0</tt> if no file descriptors are
   * associated. Do not free, this object is owned by @a message.
   */

#ifdef  G_OS_UNIX
  Glib::RefPtr<UnixFDList> get_unix_fd_list();
#endif //  G_OS_UNIX

  
  /** Gets the UNIX file descriptors associated with @a message, if any.
   * 
   * This method is only available on UNIX.
   * 
   * @newin{2,26}
   * @return A UnixFDList or <tt>0</tt> if no file descriptors are
   * associated. Do not free, this object is owned by @a message.
   */

#ifdef  G_OS_UNIX
  Glib::RefPtr<const UnixFDList> get_unix_fd_list() const;
#endif //  G_OS_UNIX

  
  /** Sets the UNIX file descriptors associated with @a message. As a
   * side-effect the DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS header
   * field is set to the number of fds in @a fd_list (or cleared if
   *  @a fd_list is <tt>0</tt>).
   * 
   * This method is only available on UNIX.
   * 
   * @newin{2,26}
   * @param fd_list A UnixFDList or <tt>0</tt>.
   */

#ifdef  G_OS_UNIX
  void set_unix_fd_list(const Glib::RefPtr<UnixFDList>& fd_list);
#endif //  G_OS_UNIX


#ifdef G_OS_UNIX
  /** Clears the existing UNIX file descriptor list.
   */
  void unset_unix_fd_list();
#endif //G_OS_UNIX

  
  /** Convenience getter for the DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS header field.
   * 
   * @newin{2,26}
   * @return The value.
   */
  guint32 get_num_unix_fds() const;
  
  /** Convenience setter for the DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS header field.
   * 
   * @newin{2,26}
   * @param value The value to set.
   */
  void set_num_unix_fds(guint32 value);

  //TODO: _WRAP_METHOD(guchar* get_header_fields() const, g_dbus_message_get_header_fields)

  /** Gets a header field on the message.  The header is returned in @a value.
   * @param value Location in which to store the header.
   * @param header_field The header field type.
   */
  void get_header(Glib::VariantBase& value, DBusMessageHeaderField header_field) const;
  
  
  /** Sets a header field on @a message.
   * 
   * If @a value is floating, @a message assumes ownership of @a value.
   * 
   * @newin{2,26}
   * @param header_field A 8-bit unsigned integer (typically a value from the DBusMessageHeaderField enumeration).
   * @param value A Variant to set the header field or <tt>0</tt> to clear the header field.
   */
  void set_header(DBusMessageHeaderField header_field, const Glib::VariantBase& value);

  
  /** Convenience getter for the DBUS_MESSAGE_HEADER_FIELD_DESTINATION header field.
   * 
   * @newin{2,26}
   * @return The value.
   */
  Glib::ustring get_destination() const;
  
  /** Convenience setter for the DBUS_MESSAGE_HEADER_FIELD_DESTINATION header field.
   * 
   * @newin{2,26}
   * @param value The value to set.
   */
  void set_destination(const Glib::ustring& value);

  
  /** Convenience getter for the DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME header field.
   * 
   * @newin{2,26}
   * @return The value.
   */
  Glib::ustring get_error_name() const;
  
  /** Convenience setter for the DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME header field.
   * 
   * @newin{2,26}
   * @param value The value to set.
   */
  void set_error_name(const Glib::ustring& value);

  
  /** Convenience getter for the DBUS_MESSAGE_HEADER_FIELD_INTERFACE header field.
   * 
   * @newin{2,26}
   * @return The value.
   */
  Glib::ustring get_interface() const;
  
  /** Convenience setter for the DBUS_MESSAGE_HEADER_FIELD_INTERFACE header field.
   * 
   * @newin{2,26}
   * @param value The value to set.
   */
  void set_interface(const Glib::ustring& value);

  
  /** Convenience getter for the DBUS_MESSAGE_HEADER_FIELD_MEMBER header field.
   * 
   * @newin{2,26}
   * @return The value.
   */
  Glib::ustring get_member() const;
  
  /** Convenience setter for the DBUS_MESSAGE_HEADER_FIELD_MEMBER header field.
   * 
   * @newin{2,26}
   * @param value The value to set.
   */
  void set_member(const Glib::ustring& value);

  
  /** Convenience getter for the DBUS_MESSAGE_HEADER_FIELD_PATH header field.
   * 
   * @newin{2,26}
   * @return The value.
   */
  Glib::ustring get_path() const;
  
  /** Convenience setter for the DBUS_MESSAGE_HEADER_FIELD_PATH header field.
   * 
   * @newin{2,26}
   * @param value The value to set.
   */
  void set_path(const Glib::ustring& value);

  
  /** Convenience getter for the DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL header field.
   * 
   * @newin{2,26}
   * @return The value.
   */
  guint32 get_reply_serial() const;
  
  /** Convenience setter for the DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL header field.
   * 
   * @newin{2,26}
   * @param value The value to set.
   */
  void set_reply_serial(guint32 value);

  
  /** Convenience getter for the DBUS_MESSAGE_HEADER_FIELD_SENDER header field.
   * 
   * @newin{2,26}
   * @return The value.
   */
  Glib::ustring get_sender() const;
  
  /** Convenience setter for the DBUS_MESSAGE_HEADER_FIELD_SENDER header field.
   * 
   * @newin{2,26}
   * @param value The value to set.
   */
  void set_sender(const Glib::ustring& value);

  
  /** Convenience getter for the DBUS_MESSAGE_HEADER_FIELD_SIGNATURE header field.
   * 
   * @newin{2,26}
   * @return The value.
   */
  Glib::ustring get_signature() const;
  
  /** Convenience setter for the DBUS_MESSAGE_HEADER_FIELD_SIGNATURE header field.
   * 
   * @newin{2,26}
   * @param value The value to set.
   */
  void set_signature(const Glib::ustring& value);

  
  /** Convenience to get the first item in the body of @a message.
   * 
   * @newin{2,26}
   * @return The string item or <tt>0</tt> if the first item in the body of
   *  @a message is not a string.
   */
  Glib::ustring get_arg0() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};


} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBusMessage
   */
  Glib::RefPtr<Gio::DBusMessage> wrap(GDBusMessage* object, bool take_copy = false);
}


#endif /* _GIOMM_DBUSMESSAGE_H */

