// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_DBUSPROXY_H
#define _GIOMM_DBUSPROXY_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <giomm/asyncresult.h>
#include <giomm/dbusintrospection.h>
#include <giomm/initable.h>
#include <giomm/asyncinitable.h>
#include <giomm/dbusconnection.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GDBusProxy GDBusProxy;
typedef struct _GDBusProxyClass GDBusProxyClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{

namespace DBus
{ class Proxy_Class; } // namespace DBus

} // namespace Gio
namespace Gio
{

namespace DBus
{

/** @addtogroup giommEnums giomm Enums and Flags */

/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%ProxyFlags operator|(ProxyFlags, ProxyFlags)</tt><br>
 * <tt>%ProxyFlags operator&(ProxyFlags, ProxyFlags)</tt><br>
 * <tt>%ProxyFlags operator^(ProxyFlags, ProxyFlags)</tt><br>
 * <tt>%ProxyFlags operator~(ProxyFlags)</tt><br>
 * <tt>%ProxyFlags& operator|=(ProxyFlags&, ProxyFlags)</tt><br>
 * <tt>%ProxyFlags& operator&=(ProxyFlags&, ProxyFlags)</tt><br>
 * <tt>%ProxyFlags& operator^=(ProxyFlags&, ProxyFlags)</tt><br>
 */
enum ProxyFlags
{
  PROXY_FLAGS_NONE = 0x0,
  PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES = (1<<0),
  PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS = (1<<1),
  PROXY_FLAGS_DO_NOT_AUTO_START = (1<<2)
};

/** @ingroup giommEnums */
inline ProxyFlags operator|(ProxyFlags lhs, ProxyFlags rhs)
  { return static_cast<ProxyFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline ProxyFlags operator&(ProxyFlags lhs, ProxyFlags rhs)
  { return static_cast<ProxyFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline ProxyFlags operator^(ProxyFlags lhs, ProxyFlags rhs)
  { return static_cast<ProxyFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline ProxyFlags operator~(ProxyFlags flags)
  { return static_cast<ProxyFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline ProxyFlags& operator|=(ProxyFlags& lhs, ProxyFlags rhs)
  { return (lhs = static_cast<ProxyFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline ProxyFlags& operator&=(ProxyFlags& lhs, ProxyFlags rhs)
  { return (lhs = static_cast<ProxyFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline ProxyFlags& operator^=(ProxyFlags& lhs, ProxyFlags rhs)
  { return (lhs = static_cast<ProxyFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/** A client-side proxy.
 * This is a base class used for proxies to access a D-Bus interface on
 * a remote object. It can be constructed for both well-known and
 * unique names.
 *
 * By default, Proxy will cache all properties (and listen to changes) of
 * the remote object, and proxy all signals that gets emitted. This behaviour
 * can be changed by passing suitable ProxyFlags when the proxy is
 * created. If the proxy is for a well-known name, the property cache is
 * flushed when the name owner vanishes and reloaded when a name owner
 * appears.
 *
 * If a Proxy is used for a well-known name, the owner of the name is
 * tracked and can be read from property_g_name_owner().
 *
 * The generic signal_g_properties_changed() and signal_g_signal() signals are
 * not very convenient to work with. Therefore, the recommended way of working
 * with proxies is to subclass Proxy, and have more natural properties and
 * signals in your derived class.
 *
 * This documentation was adapted from the C API documentation.  The C API docs
 * has more information and an example.
 *
 * @newin{2,28}
 * @ingroup DBus
 */

class Proxy
: public Glib::Object,
  public Initable,
  public AsyncInitable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Proxy CppObjectType;
  typedef Proxy_Class CppClassType;
  typedef GDBusProxy BaseObjectType;
  typedef GDBusProxyClass BaseClassType;

private:  friend class Proxy_Class;
  static CppClassType proxy_class_;

private:
  // noncopyable
  Proxy(const Proxy&);
  Proxy& operator=(const Proxy&);

protected:
  explicit Proxy(const Glib::ConstructParams& construct_params);
  explicit Proxy(GDBusProxy* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Proxy();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GDBusProxy*       gobj()       { return reinterpret_cast<GDBusProxy*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GDBusProxy* gobj() const { return reinterpret_cast<GDBusProxy*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusProxy* gobj_copy();

private:

  
protected:

  Proxy(const Glib::RefPtr<Connection>& connection,
    const Glib::ustring& name,
    const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable,
    const Glib::RefPtr<InterfaceInfo>& info = Glib::RefPtr<InterfaceInfo>(),
    ProxyFlags flags = PROXY_FLAGS_NONE);

  Proxy(const Glib::RefPtr<Connection>& connection,
    const Glib::ustring& name,
    const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<InterfaceInfo>& info = Glib::RefPtr<InterfaceInfo>(),
    ProxyFlags flags = PROXY_FLAGS_NONE);

  Proxy(const Glib::RefPtr<Connection>& connection,
    const Glib::ustring& name,
    const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const Glib::RefPtr<Cancellable>& cancellable,
    const Glib::RefPtr<InterfaceInfo>& info = Glib::RefPtr<InterfaceInfo>(),
    ProxyFlags flags = PROXY_FLAGS_NONE);

  Proxy(const Glib::RefPtr<Connection>& connection,
    const Glib::ustring& name,
    const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const Glib::RefPtr<InterfaceInfo>& info = Glib::RefPtr<InterfaceInfo>(),
    ProxyFlags flags = PROXY_FLAGS_NONE);

  Proxy(BusType bus_type,
    const Glib::ustring& name,
    const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable,
    const Glib::RefPtr<InterfaceInfo>& info = Glib::RefPtr<InterfaceInfo>(),
    ProxyFlags flags = PROXY_FLAGS_NONE);

  Proxy(BusType bus_type,
    const Glib::ustring& name,
    const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<InterfaceInfo>& info = Glib::RefPtr<InterfaceInfo>(),
    ProxyFlags flags = PROXY_FLAGS_NONE);

  Proxy(BusType bus_type,
    const Glib::ustring& name,
    const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const Glib::RefPtr<Cancellable>& cancellable,
    const Glib::RefPtr<InterfaceInfo>& info = Glib::RefPtr<InterfaceInfo>(),
    ProxyFlags flags = PROXY_FLAGS_NONE);

  Proxy(BusType bus_type,
    const Glib::ustring& name,
    const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const Glib::RefPtr<InterfaceInfo>& info = Glib::RefPtr<InterfaceInfo>(),
    ProxyFlags flags = PROXY_FLAGS_NONE);

public:

  
  /** Creates a proxy for accessing @a interface_name on the remote object
   * at @a object_path owned by @a name at @a connection and asynchronously
   * loads D-Bus properties unless the
   * DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES flag is used. Connect to
   * the DBusProxy::signal_g_properties_changed() signal to get notified about
   * property changes.
   * 
   * If the DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS flag is not set, also sets up
   * match rules for signals. Connect to the DBusProxy::signal_g_signal() signal
   * to handle signals from the remote object.
   * 
   * If @a name is a well-known name and the
   * DBUS_PROXY_FLAGS_DO_NOT_AUTO_START flag isn't set and no name
   * owner currently exists, the message bus will be requested to launch
   * a name owner for the name.
   * 
   * This is a failable asynchronous constructor - when the proxy is
   * ready, @a callback will be invoked and you can use
   * g_dbus_proxy_new_finish() to get the result.
   * 
   * See g_dbus_proxy_new_sync() and for a synchronous version of this constructor.
   * 
   * See <xref linkend="gdbus-wellknown-proxy"/> for an example of how DBusProxy can be used.
   * 
   * @newin{2,26}
   * @param connection A DBusConnection.
   * @param flags Flags used when constructing the proxy.
   * @param info A DBusInterfaceInfo specifying the minimal interface that @a proxy conforms to or <tt>0</tt>.
   * @param name A bus name (well-known or unique) or <tt>0</tt> if @a connection is not a message bus connection.
   * @param object_path An object path.
   * @param interface_name A D-Bus interface name.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @param callback Callback function to invoke when the proxy is ready.
   * @param user_data User data to pass to @a callback.
   */

  static void create(const Glib::RefPtr<Connection>& connection,
    const Glib::ustring& name,
    const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable,
    const Glib::RefPtr<InterfaceInfo>& info = Glib::RefPtr<InterfaceInfo>(),
    ProxyFlags flags = PROXY_FLAGS_NONE);

  /// Non-cancellable version of create().
  static void create(const Glib::RefPtr<Connection>& connection,
    const Glib::ustring& name,
    const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<InterfaceInfo>& info = Glib::RefPtr<InterfaceInfo>(),
    ProxyFlags flags = PROXY_FLAGS_NONE);

  
  /** Finishes creating a DBusProxy.
   * 
   * @newin{2,26}
   * @param res A AsyncResult obtained from the AsyncReadyCallback function passed to g_dbus_proxy_new().
   * @return A DBusProxy or <tt>0</tt> if @a error is set. Free with Glib::object_unref().
   */


  /** @throw Glib::Error.
   */
  static Glib::RefPtr<Proxy> create_finish(const Glib::RefPtr<AsyncResult>& result);

  
  /** Creates a proxy for accessing @a interface_name on the remote object
   * at @a object_path owned by @a name at @a connection and synchronously
   * loads D-Bus properties unless the
   * DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES flag is used.
   * 
   * If the DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS flag is not set, also sets up
   * match rules for signals. Connect to the DBusProxy::signal_g_signal() signal
   * to handle signals from the remote object.
   * 
   * If @a name is a well-known name and the
   * DBUS_PROXY_FLAGS_DO_NOT_AUTO_START flag isn't set and no name
   * owner currently exists, the message bus will be requested to launch
   * a name owner for the name.
   * 
   * This is a synchronous failable constructor. See g_dbus_proxy_new()
   * and g_dbus_proxy_new_finish() for the asynchronous version.
   * 
   * See <xref linkend="gdbus-wellknown-proxy"/> for an example of how DBusProxy can be used.
   * 
   * @newin{2,26}
   * @param connection A DBusConnection.
   * @param flags Flags used when constructing the proxy.
   * @param info A DBusInterfaceInfo specifying the minimal interface that @a proxy conforms to or <tt>0</tt>.
   * @param name A bus name (well-known or unique) or <tt>0</tt> if @a connection is not a message bus connection.
   * @param object_path An object path.
   * @param interface_name A D-Bus interface name.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @return A DBusProxy or <tt>0</tt> if error is set. Free with Glib::object_unref().
   */

  static Glib::RefPtr<Proxy>
  create_sync(const Glib::RefPtr<Connection>& connection,
    const Glib::ustring& name,
    const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const Glib::RefPtr<Cancellable>& cancellable,
    const Glib::RefPtr<InterfaceInfo>& info = Glib::RefPtr<InterfaceInfo>(),
    ProxyFlags flags = PROXY_FLAGS_NONE);

  /// Non-cancellable version of create_sync().
  static Glib::RefPtr<Proxy>
  create_sync(const Glib::RefPtr<Connection>& connection,
    const Glib::ustring& name,
    const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const Glib::RefPtr<InterfaceInfo>& info = Glib::RefPtr<InterfaceInfo>(),
    ProxyFlags flags = PROXY_FLAGS_NONE);

  
  /** Like g_dbus_proxy_new() but takes a BusType instead of a DBusConnection.
   * 
   * See <xref linkend="gdbus-wellknown-proxy"/> for an example of how DBusProxy can be used.
   * 
   * @newin{2,26}
   * @param bus_type A BusType.
   * @param flags Flags used when constructing the proxy.
   * @param info A DBusInterfaceInfo specifying the minimal interface that @a proxy conforms to or <tt>0</tt>.
   * @param name A bus name (well-known or unique).
   * @param object_path An object path.
   * @param interface_name A D-Bus interface name.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @param callback Callback function to invoke when the proxy is ready.
   * @param user_data User data to pass to @a callback.
   */

  static void create_for_bus(BusType bus_type,
    const Glib::ustring& name,
    const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable,
    const Glib::RefPtr<InterfaceInfo>& info = Glib::RefPtr<InterfaceInfo>(),
    ProxyFlags flags = PROXY_FLAGS_NONE);

  /// Non-cancellable version of create_for_bus().
  static void create_for_bus(BusType bus_type,
    const Glib::ustring& name,
    const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<InterfaceInfo>& info = Glib::RefPtr<InterfaceInfo>(),
    ProxyFlags flags = PROXY_FLAGS_NONE);

  
  /** Finishes creating a DBusProxy.
   * 
   * @newin{2,26}
   * @param res A AsyncResult obtained from the AsyncReadyCallback function passed to g_dbus_proxy_new_for_bus().
   * @return A DBusProxy or <tt>0</tt> if @a error is set. Free with Glib::object_unref().
   */


  /** @throw Glib::Error.
   */
  static Glib::RefPtr<Proxy> create_for_bus_finish(const Glib::RefPtr<AsyncResult>& result);

  
  /** Like g_dbus_proxy_new_sync() but takes a BusType instead of a DBusConnection.
   * 
   * See <xref linkend="gdbus-wellknown-proxy"/> for an example of how DBusProxy can be used.
   * 
   * @newin{2,26}
   * @param bus_type A BusType.
   * @param flags Flags used when constructing the proxy.
   * @param info A DBusInterfaceInfo specifying the minimal interface
   * that @a proxy conforms to or <tt>0</tt>.
   * @param name A bus name (well-known or unique).
   * @param object_path An object path.
   * @param interface_name A D-Bus interface name.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @return A DBusProxy or <tt>0</tt> if error is set. Free with Glib::object_unref().
   */

  static Glib::RefPtr<Proxy>
  create_for_bus_sync(BusType bus_type,
    const Glib::ustring& name,
    const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const Glib::RefPtr<Cancellable>& cancellable,
    const Glib::RefPtr<InterfaceInfo>& info = Glib::RefPtr<InterfaceInfo>(),
    ProxyFlags flags = PROXY_FLAGS_NONE);

  /// Non-cancellable version of create_for_bus_sync().
  static Glib::RefPtr<Proxy>
  create_for_bus_sync(BusType bus_type,
    const Glib::ustring& name,
    const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const Glib::RefPtr<InterfaceInfo>& info = Glib::RefPtr<InterfaceInfo>(),
    ProxyFlags flags = PROXY_FLAGS_NONE);

  
  /** Gets the flags that @a proxy was constructed with.
   * 
   * @newin{2,26}
   * @return Flags from the DBusProxyFlags enumeration.
   */
  ProxyFlags get_flags() const;

  
  /** Gets the connection @a proxy is for.
   * 
   * @newin{2,26}
   * @return A DBusConnection owned by @a proxy. Do not free.
   */
  Glib::RefPtr<Connection> get_connection();
  
  /** Gets the connection @a proxy is for.
   * 
   * @newin{2,26}
   * @return A DBusConnection owned by @a proxy. Do not free.
   */
  Glib::RefPtr<const Connection> get_connection() const;

  
  /** Gets the name that @a proxy was constructed for.
   * 
   * @newin{2,26}
   * @return A string owned by @a proxy. Do not free.
   */
  Glib::ustring get_name() const;
  
  /** The unique name that owns the name that @a proxy is for or <tt>0</tt> if
   * no-one currently owns that name. You may connect to the
   * Object::signal_notify() signal to track changes to the
   * DBusProxy::property_g_name_owner() property.
   * 
   * @newin{2,26}
   * @return The name owner or <tt>0</tt> if no name owner exists. Free with Glib::free().
   */
  Glib::ustring get_name_owner() const;
  
  /** Gets the object path @a proxy is for.
   * 
   * @newin{2,26}
   * @return A string owned by @a proxy. Do not free.
   */
  Glib::ustring get_object_path() const;
  
  /** Gets the D-Bus interface name @a proxy is for.
   * 
   * @newin{2,26}
   * @return A string owned by @a proxy. Do not free.
   */
  Glib::ustring get_interface_name() const;

  
  /** Gets the timeout to use if -1 (specifying default timeout) is
   * passed as @a timeout_msec in the g_dbus_proxy_call() and
   * g_dbus_proxy_call_sync() functions.
   * 
   * See the DBusProxy::property_g_default_timeout() property for more details.
   * 
   * @newin{2,26}
   * @return Timeout to use for @a proxy.
   */
  int get_default_timeout() const;
  
  /** Sets the timeout to use if -1 (specifying default timeout) is
   * passed as @a timeout_msec in the g_dbus_proxy_call() and
   * g_dbus_proxy_call_sync() functions.
   * 
   * See the DBusProxy::property_g_default_timeout() property for more details.
   * 
   * @newin{2,26}
   * @param timeout_msec Timeout in milliseconds.
   */
  void set_default_timeout(int timeout_msec =  -1);

  /** Looks up the value for a property from the cache. This call does no
   * blocking IO.
   *
   * If proxy has an expected interface (see property_g_interface_info()),
   * then @a property_name (for existence) is checked against it.
   *
   * @param property An output parameter in which to hold to the variant
   * instance that holds the value for @a property_name.
   * @param property_name Property name.
   *
   * @newin{2,28}
   */
  void get_cached_property(Glib::VariantBase& property,
    const Glib::ustring& property_name) const;
  

  /** If @a value is not <tt>0</tt>, sets the cached value for the property with
   * name @a property_name to the value in @a value.
   * 
   * If @a value is <tt>0</tt>, then the cached value is removed from the
   * property cache.
   * 
   * If @a proxy has an expected interface (see
   * DBusProxy::property_g_interface_info()) and @a property_name is referenced by
   * it, then @a value is checked against the type of the property.
   * 
   * If the @a value Variant is floating, it is consumed. This allows
   * convenient 'inline' use of Glib::variant_new(), e.g.
   * 
   * [C example ellipted]
   * 
   * Normally you will not need to use this method since @a proxy is
   * tracking changes using the
   * <tt>org.freedesktop.DBus.Properties.PropertiesChanged</tt>
   * D-Bus signal. However, for performance reasons an object may decide
   * to not use this signal for some properties and instead use a
   * proprietary out-of-band mechanism to transmit changes.
   * 
   * As a concrete example, consider an object with a property
   * <tt>ChatroomParticipants</tt> which is an array of
   * strings. Instead of transmitting the same (long) array every time
   * the property changes, it is more efficient to only transmit the
   * delta using e.g. signals <tt>ChatroomParticipantJoined(String
   * name)</tt> and <tt>ChatroomParticipantParted(String
   * name)</tt>.
   * 
   * @newin{2,26}
   * @param property_name Property name.
   * @param value Value for the property or <tt>0</tt> to remove it from the cache.
   */
  void set_cached_property(const Glib::ustring& property_name, const Glib::VariantBase& value);

 
  /** Gets the names of all cached properties on @a proxy.
   * 
   * @newin{2,26}
   * @return A <tt>0</tt>-terminated array of strings or <tt>0</tt> if
   *  @a proxy has no cached properties. Free the returned array with
   * Glib::strfreev().
   */
  Glib::StringArrayHandle get_cached_property_names() const;

  
  /** Ensure that interactions with @a proxy conform to the given
   * interface. See the DBusProxy::property_g_interface_info() property for more
   * details.
   * 
   * @newin{2,26}
   * @param info Minimum interface this proxy conforms to or <tt>0</tt> to unset.
   */
  void set_interface_info(const Glib::RefPtr<InterfaceInfo>& info);
  
  /** Returns the DBusInterfaceInfo, if any, specifying the interface
   * that @a proxy conforms to. See the DBusProxy::property_g_interface_info()
   * property for more details.
   * 
   * @newin{2,26}
   * @return A DBusInterfaceInfo or <tt>0</tt>. Do not unref the returned
   * object, it is owned by @a proxy.
   */
  Glib::RefPtr<InterfaceInfo> get_interface_info();
  
  /** Returns the DBusInterfaceInfo, if any, specifying the interface
   * that @a proxy conforms to. See the DBusProxy::property_g_interface_info()
   * property for more details.
   * 
   * @newin{2,26}
   * @return A DBusInterfaceInfo or <tt>0</tt>. Do not unref the returned
   * object, it is owned by @a proxy.
   */
  Glib::RefPtr<const InterfaceInfo> get_interface_info() const;

  
  /** Asynchronously invokes the @a method_name method on @a proxy.
   * 
   * If @a method_name contains any dots, then @a name is split into interface and
   * method name parts. This allows using @a proxy for invoking methods on
   * other interfaces.
   * 
   * If the DBusConnection associated with @a proxy is closed then
   * the operation will fail with IO_ERROR_CLOSED. If
   *  @a cancellable is canceled, the operation will fail with
   * IO_ERROR_CANCELLED. If @parameters contains a value not
   * compatible with the D-Bus protocol, the operation fails with
   * IO_ERROR_INVALID_ARGUMENT.
   * 
   * If the @parameters Variant is floating, it is consumed. This allows
   * convenient 'inline' use of Glib::variant_new(), e.g.:
   * 
   * [C example ellipted]
   * 
   * If @a proxy has an expected interface (see
   * DBusProxy::property_g_interface_info()) and @a method_name is referenced by it,
   * then the return value is checked against the return type.
   * 
   * This is an asynchronous method. When the operation is finished,
   *  @a callback will be invoked in the
   * thread-default main loop
   * of the thread you are calling this method from.
   * You can then call g_dbus_proxy_call_finish() to get the result of
   * the operation. See g_dbus_proxy_call_sync() for the synchronous
   * version of this method.
   * 
   * @newin{2,26}
   * @param method_name Name of method to invoke.
   * @param parameters A Variant tuple with parameters for the signal or <tt>0</tt> if not passing parameters.
   * @param flags Flags from the DBusCallFlags enumeration.
   * @param timeout_msec The timeout in milliseconds (with MAXINT meaning
   * "infinite") or -1 to use the proxy default timeout.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @param callback A AsyncReadyCallback to call when the request is satisfied or <tt>0</tt> if you don't
   * care about the result of the method invocation.
   * @param user_data The data to pass to @a callback.
   */

  void call(
    const Glib::ustring& method_name,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable,
    const Glib::VariantContainerBase& parameters = Glib::VariantContainerBase(),
    int timeout_msec = -1,
    CallFlags flags = Gio::DBus::CALL_FLAGS_NONE
  );

  /// A non-cancellable version of call().
  void call(
    const Glib::ustring& method_name,
    const SlotAsyncReady& slot,
    const Glib::VariantContainerBase& parameters = Glib::VariantContainerBase(),
    int timeout_msec = -1,
    CallFlags flags = Gio::DBus::CALL_FLAGS_NONE
  );

  
  /** Finishes an operation started with call().
   *
   * @param res An AsyncResult obtained from the SlotAsyncReady passed to
   * call().
   * @result A Variant tuple with return values.
   *
   * @throw Glib::Error.
   */
  Glib::VariantContainerBase call_finish(const Glib::RefPtr<AsyncResult>& res);

  /** Synchronously invokes the method_name method on proxy.
   * See call(), the asynchronous version of this method for more information.
   *
   * @param method_name Name of method to invoke.
   * @param timeout_msec The timeout in milliseconds or -1 to use the proxy
   * default timeout.
   * @param flags Flags from the CallFlags enumeration.
   * @param parameters A Glib::VariantContainerBase tuple with parameters for the
   * signal.
   * @param cancellable A Cancellable.
   * @result A Variant tuple with return values.
   *
   * @throw Glib::Error.
   */
  Glib::VariantContainerBase call_sync(
    const Glib::ustring& method_name,
    const Glib::RefPtr<Cancellable>& cancellable,
    const Glib::VariantContainerBase& parameters = Glib::VariantContainerBase(),
    int timeout_msec = -1,
    CallFlags flags = Gio::DBus::CALL_FLAGS_NONE
  );
  

  /// A non-cancellable version of call_sync().
  Glib::VariantContainerBase call_sync(
    const Glib::ustring& method_name,
    const Glib::VariantContainerBase& parameters = Glib::VariantContainerBase(),
    int timeout_msec = -1,
    CallFlags flags = Gio::DBus::CALL_FLAGS_NONE
  );

 //_WRAP_PROPERTY("g-bus-type", BusType) // write-only construct-only
 #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Connection> > property_g_connection() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


 #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< int > property_g_default_timeout() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Timeout for remote method invocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_g_default_timeout() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

 #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ProxyFlags > property_g_flags() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


 #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<InterfaceInfo> > property_g_interface_info() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Interface Information.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<InterfaceInfo> > property_g_interface_info() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

 #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_g_interface_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


 #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_g_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


 #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_g_name_owner() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


 #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_g_object_path() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  typedef std::map<Glib::ustring, Glib::VariantBase> MapChangedProperties;

  // TODO: Should the signal names match the C API names (ie. the C API names
  // are g_signal_name while these are just signal_name).

  // The DBus API ensures that the variant changed_properties is of type "DICT<STRING,VARIANT>"
   

  /**
   * @par Slot Prototype:
   * <tt>void on_my_%properties_changed(const MapChangedProperties& changed_properties, const std::vector<Glib::ustring>& invalidated_properties)</tt>
   *
   * Emitted when one or more D-Bus properties on @a proxy changes. The
   * local cache has already been updated when this signal fires. Note
   * that both @a changed_properties and @a invalidated_properties are
   * guaranteed to never be <tt>0</tt> (either may be empty though).
   * 
   * If the proxy has the flag
   * DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES set, then
   *  @a invalidated_properties will always be empty.
   * 
   * This signal corresponds to the
   * <tt>PropertiesChanged</tt> D-Bus signal on the
   * <tt>org.freedesktop.DBus.Properties</tt> interface.
   * 
   * @newin{2,26}
   * @param changed_properties A Variant containing the properties that changed.
   * @param invalidated_properties A <tt>0</tt> terminated array of properties that was invalidated.
   */


  Glib::SignalProxy2< void,const MapChangedProperties&,const std::vector<Glib::ustring>& > signal_properties_changed();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%signal(const Glib::ustring& sender_name, const Glib::ustring& signal_name, const Glib::VariantContainerBase& parameters)</tt>
   *
   * Emitted when a signal from the remote object and interface that @a proxy is for, has been received.
   * 
   * @newin{2,26}
   * @param sender_name The sender of the signal or <tt>0</tt> if the connection is not a bus connection.
   * @param signal_name The name of the signal.
   * @param parameters A Variant tuple with parameters for the signal.
   */


  Glib::SignalProxy3< void,const Glib::ustring&,const Glib::ustring&,const Glib::VariantContainerBase& > signal_signal();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_properties_changed().
  virtual void on_properties_changed(const MapChangedProperties& changed_properties, const std::vector<Glib::ustring>& invalidated_properties);
  /// This is a default handler for the signal signal_signal().
  virtual void on_signal(const Glib::ustring& sender_name, const Glib::ustring& signal_name, const Glib::VariantContainerBase& parameters);


};

} //namespace

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBus::Proxy
   */
  Glib::RefPtr<Gio::DBus::Proxy> wrap(GDBusProxy* object, bool take_copy = false);
}


#endif /* _GIOMM_DBUSPROXY_H */

