// Generated by gmmproc 2.51.6 -- DO NOT MODIFY!


#include <glibmm.h>

#include <giomm/fileiostream.h>
#include <giomm/private/fileiostream_p.h>


// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>
#include "slot_async.h"
#include <glibmm/exceptionhandler.h>

namespace Gio
{

Glib::RefPtr<FileInfo>
FileIOStream::query_info(
  const Glib::RefPtr<Cancellable>& cancellable, const std::string& attributes)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_file_io_stream_query_info(gobj(), g_strdup((attributes).c_str()),
    const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileInfo>
FileIOStream::query_info(const std::string& attributes)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(
    g_file_io_stream_query_info(gobj(), g_strdup((attributes).c_str()), nullptr, &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

void
FileIOStream::query_info_async(const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable, const std::string& attributes, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  auto slot_copy = new SlotAsyncReady(slot);

  g_file_io_stream_query_info_async(gobj(), const_cast<char*>(attributes.c_str()), io_priority,
    Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
FileIOStream::query_info_async(
  const SlotAsyncReady& slot, const std::string& attributes, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  auto slot_copy = new SlotAsyncReady(slot);

  g_file_io_stream_query_info_async(gobj(), const_cast<char*>(attributes.c_str()), io_priority,
    nullptr, &SignalProxy_async_callback, slot_copy);
}

} // namespace Gio

namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gio::FileIOStream> wrap(GFileIOStream* object, bool take_copy)
{
  return Glib::RefPtr<Gio::FileIOStream>( dynamic_cast<Gio::FileIOStream*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& FileIOStream_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &FileIOStream_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_file_io_stream_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Seekable::add_interface(get_type());

  }

  return *this;
}


void FileIOStream_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* FileIOStream_Class::wrap_new(GObject* object)
{
  return new FileIOStream((GFileIOStream*)object);
}


/* The implementation: */

GFileIOStream* FileIOStream::gobj_copy()
{
  reference();
  return gobj();
}

FileIOStream::FileIOStream(const Glib::ConstructParams& construct_params)
:
  Gio::IOStream(construct_params)
{

}

FileIOStream::FileIOStream(GFileIOStream* castitem)
:
  Gio::IOStream((GIOStream*)(castitem))
{}


FileIOStream::FileIOStream(FileIOStream&& src) noexcept
: Gio::IOStream(std::move(src))
  , Seekable(std::move(src))
{}

FileIOStream& FileIOStream::operator=(FileIOStream&& src) noexcept
{
  Gio::IOStream::operator=(std::move(src));
  Seekable::operator=(std::move(src));
  return *this;
}


FileIOStream::~FileIOStream() noexcept
{}


FileIOStream::CppClassType FileIOStream::fileiostream_class_; // initialize static member

GType FileIOStream::get_type()
{
  return fileiostream_class_.init().get_type();
}


GType FileIOStream::get_base_type()
{
  return g_file_io_stream_get_type();
}


Glib::RefPtr<FileInfo> FileIOStream::query_info_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileInfo> retvalue = Glib::wrap(g_file_io_stream_query_info_finish(gobj(), Glib::unwrap(result), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

std::string FileIOStream::get_etag() const
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_file_io_stream_get_etag(const_cast<GFileIOStream*>(gobj())));
}


} // namespace Gio


