// Generated by gmmproc 2.60.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <giomm/file.h>
#include <giomm/private/file_p.h>


/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <giomm/mount.h>
#include <gio/gio.h>
#include <utility>
#include <glibmm/error.h>
#include <glibmm/exceptionhandler.h>
#include "slot_async.h"

namespace
{

using CopySlots = std::pair<Gio::File::SlotFileProgress*, Gio::SlotAsyncReady*>;
using MeasureSlots = std::pair<Gio::File::SlotFileMeasureProgress*, Gio::SlotAsyncReady*>;
using LoadPartialSlots = std::pair<Gio::File::SlotReadMore*, Gio::SlotAsyncReady*>;

static void
SignalProxy_file_progress_callback(
  goffset current_num_bytes, goffset total_num_bytes, gpointer data)
{
  auto the_slot = static_cast<Gio::File::SlotFileProgress*>(data);

  try
  {

    (*the_slot)(current_num_bytes, total_num_bytes);
  }
  catch (...)
  {
    Glib::exception_handlers_invoke();
  }
}

// Same as SignalProxy_async_callback, except that this one knows that
// the slot is packed in a pair. The operation is assumed to be finished
// after the callback is triggered, so we delete that pair here.
static void
SignalProxy_file_copy_async_callback(GObject*, GAsyncResult* res, void* data)
{
  auto slot_pair = static_cast<CopySlots*>(data);
  auto the_slot = slot_pair->second;

  try
  {
    if (*the_slot)
    {
      auto result = Glib::wrap(res, true /* take copy */);
      (*the_slot)(result);
    }
  }
  catch (...)
  {
    Glib::exception_handlers_invoke();
  }

  delete the_slot;
  delete slot_pair->first; // progress slot
  delete slot_pair;
}

// Same as SignalProxy_async_callback, except that this one knows that
// the slot is packed in a pair. The operation is assumed to be finished
// after the callback is triggered, so we delete that pair here.
static void
SignalProxy_file_measure_async_callback(GObject*, GAsyncResult* res, void* data)
{
  auto slot_pair = static_cast<MeasureSlots*>(data);
  auto the_slot = slot_pair->second;

  try
  {
    if (*the_slot)
    {
      auto result = Glib::wrap(res, true /* take copy */);
      (*the_slot)(result);
    }
  }
  catch (...)
  {
    Glib::exception_handlers_invoke();
  }

  delete the_slot;
  delete slot_pair->first; // progress slot
  delete slot_pair;
}

static gboolean
SignalProxy_load_partial_contents_read_more_callback(
  const char* file_contents, goffset file_size, gpointer data)
{
  auto slot_pair = static_cast<LoadPartialSlots*>(data);
  auto the_slot = slot_pair->first;

  bool result = false;

  try
  {

    result = (*the_slot)(file_contents, file_size);
  }
  catch (...)
  {
    Glib::exception_handlers_invoke();
  }

  return result;
}

// Same as SignalProxy_async_callback, except that this one knows that
// the slot is packed in a pair. The operation is assumed to be finished
// after the callback is triggered, so we delete that pair here.
static void
SignalProxy_load_partial_contents_ready_callback(GObject*, GAsyncResult* res, void* data)
{
  LoadPartialSlots* slot_pair = static_cast<LoadPartialSlots*>(data);
  Gio::SlotAsyncReady* the_slot = slot_pair->second;

  try
  {
    auto result = Glib::wrap(res, true /* take copy */);
    (*the_slot)(result);
  }
  catch (...)
  {
    Glib::exception_handlers_invoke();
  }

  delete the_slot;
  delete slot_pair->first; // read_more slot
  delete slot_pair;
}

static void
SignalProxy_file_measure_progress_callback(
  gboolean reporting, guint64 current_size, guint64 num_dirs, guint64 num_files, gpointer data)
{
  Gio::File::SlotFileMeasureProgress* the_slot =
    static_cast<Gio::File::SlotFileMeasureProgress*>(data);

  try
  {

    (*the_slot)(reporting, current_size, num_dirs, num_files);
  }
  catch (...)
  {
    Glib::exception_handlers_invoke();
  }
}

} // anonymous namespace

namespace Gio
{

Glib::RefPtr<File>
File::create_for_path(const std::string& path)
{
  GFile* cfile = g_file_new_for_path(path.c_str());
  return Glib::wrap(G_FILE(cfile));
}

Glib::RefPtr<File>
File::create_for_uri(const std::string& uri)
{
  GFile* cfile = g_file_new_for_uri(uri.c_str());
  return Glib::wrap(G_FILE(cfile));
}

Glib::RefPtr<File>
File::create_for_commandline_arg(const std::string& arg)
{
  GFile* cfile = g_file_new_for_commandline_arg(arg.c_str());
  return Glib::wrap(G_FILE(cfile));
}

Glib::RefPtr<File>
File::create_for_parse_name(const Glib::ustring& parse_name)
{
  GFile* cfile = g_file_parse_name(parse_name.c_str());
  return Glib::wrap(G_FILE(cfile));
}

void
File::read_async(const SlotAsyncReady& slot, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_read_async(gobj(), io_priority, nullptr, &SignalProxy_async_callback, slot_copy);
}

void
File::read_async(
  const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_read_async(
    gobj(), io_priority, Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::append_to_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable,
  FileCreateFlags flags, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_append_to_async(gobj(), static_cast<GFileCreateFlags>(flags), io_priority,
    Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::append_to_async(const SlotAsyncReady& slot, FileCreateFlags flags, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_append_to_async(gobj(), static_cast<GFileCreateFlags>(flags), io_priority,
    nullptr, // cancellable
    &SignalProxy_async_callback, slot_copy);
}

void
File::create_file_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable,
  FileCreateFlags flags, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_create_async(gobj(), static_cast<GFileCreateFlags>(flags), io_priority,
    Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::create_file_async(const SlotAsyncReady& slot, FileCreateFlags flags, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_create_async(gobj(), static_cast<GFileCreateFlags>(flags), io_priority,
    nullptr, // cancellable
    &SignalProxy_async_callback, slot_copy);
}

void
File::create_file_readwrite_async(const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable, FileCreateFlags flags, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_create_async(gobj(), static_cast<GFileCreateFlags>(flags), io_priority,
    Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::create_file_readwrite_async(
  const SlotAsyncReady& slot, FileCreateFlags flags, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_create_readwrite_async(gobj(), static_cast<GFileCreateFlags>(flags), io_priority,
    nullptr, // cancellable
    &SignalProxy_async_callback, slot_copy);
}

void
File::replace_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable,
  const std::string& etag, bool make_backup, FileCreateFlags flags, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_replace_async(gobj(), Glib::c_str_or_nullptr(etag), make_backup,
    static_cast<GFileCreateFlags>(flags), io_priority, Glib::unwrap(cancellable),
    &SignalProxy_async_callback, slot_copy);
}

void
File::replace_async(const SlotAsyncReady& slot, const std::string& etag, bool make_backup,
  FileCreateFlags flags, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_replace_async(gobj(), Glib::c_str_or_nullptr(etag), make_backup,
    static_cast<GFileCreateFlags>(flags), io_priority,
    nullptr, // cancellable
    &SignalProxy_async_callback, slot_copy);
}

void
File::open_readwrite_async(const SlotAsyncReady& slot, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_open_readwrite_async(gobj(), io_priority, nullptr, &SignalProxy_async_callback, slot_copy);
}

void
File::open_readwrite_async(
  const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_open_readwrite_async(
    gobj(), io_priority, Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::replace_readwrite_async(const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable, const std::string& etag, bool make_backup,
  FileCreateFlags flags, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_replace_readwrite_async(gobj(), Glib::c_str_or_nullptr(etag), make_backup,
    static_cast<GFileCreateFlags>(flags), io_priority, Glib::unwrap(cancellable),
    &SignalProxy_async_callback, slot_copy);
}

void
File::replace_readwrite_async(const SlotAsyncReady& slot, const std::string& etag, bool make_backup,
  FileCreateFlags flags, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_replace_readwrite_async(gobj(), Glib::c_str_or_nullptr(etag), make_backup,
    static_cast<GFileCreateFlags>(flags), io_priority,
    nullptr, // cancellable
    &SignalProxy_async_callback, slot_copy);
}

FileType
File::query_file_type(FileQueryInfoFlags flags) const
{
  return (FileType)g_file_query_file_type(
    const_cast<GFile*>(gobj()), (GFileQueryInfoFlags)flags, nullptr);
}

Glib::RefPtr<FileInfo>
File::query_info(const Glib::RefPtr<Cancellable>& cancellable, const std::string& attributes,
  FileQueryInfoFlags flags) const
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_file_query_info(const_cast<GFile*>(gobj()), attributes.c_str(),
    ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)),
    &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileInfo>
File::query_info(const std::string& attributes, FileQueryInfoFlags flags) const
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_file_query_info(const_cast<GFile*>(gobj()), attributes.c_str(),
    ((GFileQueryInfoFlags)(flags)), nullptr, &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

void
File::query_info_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable,
  const std::string& attributes, FileQueryInfoFlags flags, int io_priority) const
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_query_info_async(const_cast<GFile*>(gobj()), attributes.c_str(),
    static_cast<GFileQueryInfoFlags>(flags), io_priority, Glib::unwrap(cancellable),
    &SignalProxy_async_callback, slot_copy);
}

void
File::query_info_async(const SlotAsyncReady& slot, const std::string& attributes,
  FileQueryInfoFlags flags, int io_priority) const
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_query_info_async(const_cast<GFile*>(gobj()), attributes.c_str(),
    static_cast<GFileQueryInfoFlags>(flags), io_priority,
    nullptr, // cancellable
    &SignalProxy_async_callback, slot_copy);
}

Glib::RefPtr<FileInfo>
File::query_filesystem_info(
  const Glib::RefPtr<Cancellable>& cancellable, const std::string& attributes)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_file_query_filesystem_info(
    gobj(), attributes.c_str(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileInfo>
File::query_filesystem_info(const std::string& attributes)
{
  GError* gerror = nullptr;
  auto retvalue =
    Glib::wrap(g_file_query_filesystem_info(gobj(), attributes.c_str(), nullptr, &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

void
File::query_filesystem_info_async(const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable, const std::string& attributes,
  int io_priority) const
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_query_filesystem_info_async(const_cast<GFile*>(gobj()), attributes.c_str(), io_priority,
    Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::query_filesystem_info_async(
  const SlotAsyncReady& slot, const std::string& attributes, int io_priority) const
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_query_filesystem_info_async(const_cast<GFile*>(gobj()), attributes.c_str(), io_priority,
    nullptr, // cancellable
    &SignalProxy_async_callback, slot_copy);
}

Glib::RefPtr<FileEnumerator>
File::enumerate_children(const Glib::RefPtr<Cancellable>& cancellable,
  const std::string& attributes, FileQueryInfoFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue =
    Glib::wrap(g_file_enumerate_children(gobj(), attributes.c_str(), ((GFileQueryInfoFlags)(flags)),
      const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileEnumerator>
File::enumerate_children(const std::string& attributes, FileQueryInfoFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_file_enumerate_children(
    gobj(), attributes.c_str(), ((GFileQueryInfoFlags)(flags)), nullptr, &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

void
File::enumerate_children_async(const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable, const std::string& attributes,
  FileQueryInfoFlags flags, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_enumerate_children_async(gobj(), attributes.c_str(),
    static_cast<GFileQueryInfoFlags>(flags), io_priority, Glib::unwrap(cancellable),
    &SignalProxy_async_callback, slot_copy);
}

void
File::enumerate_children_async(const SlotAsyncReady& slot, const std::string& attributes,
  FileQueryInfoFlags flags, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_enumerate_children_async(gobj(), attributes.c_str(),
    static_cast<GFileQueryInfoFlags>(flags), io_priority, nullptr, &SignalProxy_async_callback,
    slot_copy);
}

void
File::set_display_name_async(const Glib::ustring& display_name, const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_set_display_name_async(gobj(), display_name.c_str(), io_priority,
    Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::set_display_name_async(
  const Glib::ustring& display_name, const SlotAsyncReady& slot, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_set_display_name_async(
    gobj(), display_name.c_str(), io_priority, nullptr, &SignalProxy_async_callback, slot_copy);
}

bool
File::copy(const Glib::RefPtr<File>& destination, const SlotFileProgress& slot,
  const Glib::RefPtr<Cancellable>& cancellable, FileCopyFlags flags)
{
  GError* gerror = nullptr;
  bool res;

  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotFileProgress* slot_copy = new SlotFileProgress(slot);

  res = g_file_copy(gobj(), Glib::unwrap(destination), static_cast<GFileCopyFlags>(flags),
    Glib::unwrap(cancellable), &SignalProxy_file_progress_callback, slot_copy, &gerror);

  delete slot_copy;

  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return res;
}

bool
File::copy(const Glib::RefPtr<File>& destination, const SlotFileProgress& slot, FileCopyFlags flags)
{
  GError* gerror = nullptr;
  bool res;

  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotFileProgress* slot_copy = new SlotFileProgress(slot);

  res = g_file_copy(gobj(), Glib::unwrap(destination), static_cast<GFileCopyFlags>(flags), nullptr,
    &SignalProxy_file_progress_callback, slot_copy, &gerror);

  delete slot_copy;

  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return res;
}

bool
File::copy(const Glib::RefPtr<File>& destination, FileCopyFlags flags)
{
  GError* gerror = nullptr;
  bool res = g_file_copy(gobj(), Glib::unwrap(destination), static_cast<GFileCopyFlags>(flags),
    nullptr, nullptr, nullptr, &gerror);

  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return res;
}

void
File::copy_async(const Glib::RefPtr<File>& destination, const SlotFileProgress& slot_progress,
  const SlotAsyncReady& slot_ready, const Glib::RefPtr<Cancellable>& cancellable,
  FileCopyFlags flags, int io_priority)
{
  // Create a new pair which will hold copies of passed slots.
  // This will be deleted in the SignalProxy_file_copy_async_callback() callback
  CopySlots* slots = new CopySlots();
  SlotFileProgress* slot_progress_copy = new SlotFileProgress(slot_progress);
  SlotAsyncReady* slot_ready_copy = new SlotAsyncReady(slot_ready);

  slots->first = slot_progress_copy;
  slots->second = slot_ready_copy;

  g_file_copy_async(gobj(), Glib::unwrap(destination), static_cast<GFileCopyFlags>(flags),
    io_priority, Glib::unwrap(cancellable), &SignalProxy_file_progress_callback, slot_progress_copy,
    &SignalProxy_file_copy_async_callback, slots);
}

void
File::copy_async(const Glib::RefPtr<File>& destination, const SlotAsyncReady& slot_ready,
  const Glib::RefPtr<Cancellable>& cancellable, FileCopyFlags flags, int io_priority)
{
  // Create copies of slots.
  // Pointers to them will be passed through the callbacks' data parameter
  // and deleted in the corresponding callback.
  SlotAsyncReady* slot_ready_copy = new SlotAsyncReady(slot_ready);

  g_file_copy_async(gobj(), Glib::unwrap(destination), static_cast<GFileCopyFlags>(flags),
    io_priority, Glib::unwrap(cancellable), nullptr, nullptr, &SignalProxy_async_callback,
    slot_ready_copy);
}

void
File::copy_async(const Glib::RefPtr<File>& destination, const SlotFileProgress& slot_progress,
  const SlotAsyncReady& slot_ready, FileCopyFlags flags, int io_priority)
{
  // Create a new pair which will hold copies of passed slots.
  // This will be deleted in the SignalProxy_file_copy_async_callback() callback
  CopySlots* slots = new CopySlots();
  SlotFileProgress* slot_progress_copy = new SlotFileProgress(slot_progress);
  SlotAsyncReady* slot_ready_copy = new SlotAsyncReady(slot_ready);

  slots->first = slot_progress_copy;
  slots->second = slot_ready_copy;

  g_file_copy_async(gobj(), Glib::unwrap(destination), static_cast<GFileCopyFlags>(flags),
    io_priority, nullptr, &SignalProxy_file_progress_callback, slot_progress_copy,
    &SignalProxy_file_copy_async_callback, slots);
}

void
File::copy_async(const Glib::RefPtr<File>& destination, const SlotAsyncReady& slot_ready,
  FileCopyFlags flags, int io_priority)
{
  // Create copies of slots.
  // Pointers to them will be passed through the callbacks' data parameter
  // and deleted in the corresponding callback.
  SlotAsyncReady* slot_ready_copy = new SlotAsyncReady(slot_ready);

  g_file_copy_async(gobj(), Glib::unwrap(destination), static_cast<GFileCopyFlags>(flags),
    io_priority, nullptr, nullptr, nullptr, &SignalProxy_async_callback, slot_ready_copy);
}

bool
File::move(const Glib::RefPtr<File>& destination, const SlotFileProgress& slot,
  const Glib::RefPtr<Cancellable>& cancellable, FileCopyFlags flags)
{
  GError* gerror = nullptr;
  bool res;

  // Create a move of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotFileProgress* slot_copy = new SlotFileProgress(slot);

  res = g_file_move(gobj(), Glib::unwrap(destination), static_cast<GFileCopyFlags>(flags),
    Glib::unwrap(cancellable), &SignalProxy_file_progress_callback, slot_copy, &gerror);

  delete slot_copy;

  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return res;
}

bool
File::move(const Glib::RefPtr<File>& destination, const SlotFileProgress& slot, FileCopyFlags flags)
{
  GError* gerror = nullptr;
  bool res;

  // Create a move of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotFileProgress* slot_copy = new SlotFileProgress(slot);

  res = g_file_move(gobj(), Glib::unwrap(destination), static_cast<GFileCopyFlags>(flags), nullptr,
    &SignalProxy_file_progress_callback, slot_copy, &gerror);

  delete slot_copy;

  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return res;
}

bool
File::move(const Glib::RefPtr<File>& destination, FileCopyFlags flags)
{
  GError* gerror = nullptr;
  bool res;

  res = g_file_move(gobj(), Glib::unwrap(destination), static_cast<GFileCopyFlags>(flags), nullptr,
    nullptr, nullptr, &gerror);

  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return res;
}

void
File::set_attributes_async(const Glib::RefPtr<FileInfo>& info, const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable, FileQueryInfoFlags flags, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_set_attributes_async(gobj(), Glib::unwrap(info), static_cast<GFileQueryInfoFlags>(flags),
    io_priority, Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::set_attributes_async(const Glib::RefPtr<FileInfo>& info, const SlotAsyncReady& slot,
  FileQueryInfoFlags flags, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_set_attributes_async(gobj(), Glib::unwrap(info), static_cast<GFileQueryInfoFlags>(flags),
    io_priority, nullptr, &SignalProxy_async_callback, slot_copy);
}

bool
File::set_attributes_finish(
  const Glib::RefPtr<AsyncResult>& result, const Glib::RefPtr<FileInfo>& info)
{
  GError* gerror = nullptr;
  GFileInfo* cinfo = Glib::unwrap(info);
  bool res;

  res = g_file_set_attributes_finish(gobj(), Glib::unwrap(result), &cinfo, &gerror);

  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return res;
}

void
File::mount_mountable(const Glib::RefPtr<MountOperation>& mount_operation,
  const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, MountMountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_mount_mountable(gobj(), static_cast<GMountMountFlags>(flags),
    Glib::unwrap(mount_operation), Glib::unwrap(cancellable), &SignalProxy_async_callback,
    slot_copy);
}

void
File::mount_mountable(const Glib::RefPtr<MountOperation>& mount_operation,
  const SlotAsyncReady& slot, MountMountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_mount_mountable(gobj(), static_cast<GMountMountFlags>(flags),
    Glib::unwrap(mount_operation), nullptr, &SignalProxy_async_callback, slot_copy);
}

void
File::mount_mountable(const SlotAsyncReady& slot, MountMountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_mount_mountable(gobj(), static_cast<GMountMountFlags>(flags), nullptr, nullptr,
    &SignalProxy_async_callback, slot_copy);
}

void
File::mount_mountable(MountMountFlags flags)
{
  g_file_mount_mountable(
    gobj(), static_cast<GMountMountFlags>(flags), nullptr, nullptr, nullptr, nullptr);
}

void
File::unmount_mountable(
  const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, MountUnmountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_unmount_mountable_with_operation(gobj(), static_cast<GMountUnmountFlags>(flags), nullptr,
    Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::unmount_mountable(const SlotAsyncReady& slot, MountUnmountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_unmount_mountable_with_operation(gobj(), static_cast<GMountUnmountFlags>(flags), nullptr,
    nullptr, &SignalProxy_async_callback, slot_copy);
}

void
File::unmount_mountable(MountUnmountFlags flags)
{
  g_file_unmount_mountable_with_operation(
    gobj(), static_cast<GMountUnmountFlags>(flags), nullptr, nullptr, nullptr, nullptr);
}

void
File::unmount_mountable(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable,
  const Glib::RefPtr<MountOperation>& mount_operation, MountUnmountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_unmount_mountable_with_operation(gobj(), static_cast<GMountUnmountFlags>(flags),
    Glib::unwrap(mount_operation), Glib::unwrap(cancellable), &SignalProxy_async_callback,
    slot_copy);
}

void
File::unmount_mountable(const SlotAsyncReady& slot,
  const Glib::RefPtr<MountOperation>& mount_operation, MountUnmountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_unmount_mountable_with_operation(gobj(), static_cast<GMountUnmountFlags>(flags),
    Glib::unwrap(mount_operation), nullptr, &SignalProxy_async_callback, slot_copy);
}

void
File::unmount_mountable(
  const Glib::RefPtr<MountOperation>& mount_operation, MountUnmountFlags flags)
{
  g_file_unmount_mountable_with_operation(gobj(), static_cast<GMountUnmountFlags>(flags),
    Glib::unwrap(mount_operation), nullptr, nullptr, nullptr);
}

void
File::mount_enclosing_volume(const Glib::RefPtr<MountOperation>& mount_operation,
  const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, MountMountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_mount_enclosing_volume(gobj(), static_cast<GMountMountFlags>(flags),
    Glib::unwrap(mount_operation), Glib::unwrap(cancellable), &SignalProxy_async_callback,
    slot_copy);
}

void
File::mount_enclosing_volume(const Glib::RefPtr<MountOperation>& mount_operation,
  const SlotAsyncReady& slot, MountMountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_mount_enclosing_volume(gobj(), static_cast<GMountMountFlags>(flags),
    Glib::unwrap(mount_operation), nullptr, &SignalProxy_async_callback, slot_copy);
}

void
File::mount_enclosing_volume(const SlotAsyncReady& slot, MountMountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_mount_enclosing_volume(gobj(), static_cast<GMountMountFlags>(flags), nullptr, nullptr,
    &SignalProxy_async_callback, slot_copy);
}

void
File::mount_enclosing_volume(MountMountFlags flags)
{
  g_file_mount_enclosing_volume(
    gobj(), static_cast<GMountMountFlags>(flags), nullptr, nullptr, nullptr, nullptr);
}

void
File::eject_mountable(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable,
  const Glib::RefPtr<MountOperation>& mount_operation, MountUnmountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_eject_mountable_with_operation(gobj(), static_cast<GMountUnmountFlags>(flags),
    Glib::unwrap(mount_operation), Glib::unwrap(cancellable), &SignalProxy_async_callback,
    slot_copy);
}

void
File::eject_mountable(const SlotAsyncReady& slot,
  const Glib::RefPtr<MountOperation>& mount_operation, MountUnmountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_eject_mountable_with_operation(gobj(), static_cast<GMountUnmountFlags>(flags),
    Glib::unwrap(mount_operation), nullptr, &SignalProxy_async_callback, slot_copy);
}

void
File::eject_mountable(const Glib::RefPtr<MountOperation>& mount_operation, MountUnmountFlags flags)
{
  g_file_eject_mountable_with_operation(gobj(), static_cast<GMountUnmountFlags>(flags),
    Glib::unwrap(mount_operation), nullptr, nullptr, nullptr);
}

void
File::eject_mountable(
  const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, MountUnmountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_eject_mountable_with_operation(gobj(), static_cast<GMountUnmountFlags>(flags), nullptr,
    Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::eject_mountable(const SlotAsyncReady& slot, MountUnmountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_eject_mountable_with_operation(gobj(), static_cast<GMountUnmountFlags>(flags), nullptr,
    nullptr, &SignalProxy_async_callback, slot_copy);
}

void
File::eject_mountable(MountUnmountFlags flags)
{
  g_file_eject_mountable_with_operation(
    gobj(), static_cast<GMountUnmountFlags>(flags), nullptr, nullptr, nullptr, nullptr);
}

void
File::load_contents_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_load_contents_async(
    gobj(), Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::load_contents_async(const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_load_contents_async(gobj(), nullptr, &SignalProxy_async_callback, slot_copy);
}

void
File::load_partial_contents_async(const SlotReadMore& slot_read_more,
  const SlotAsyncReady& slot_async_ready, const Glib::RefPtr<Cancellable>& cancellable)
{
  // Create a new pair which will hold copies of passed slots.
  // This will be deleted in the SignalProxy_load_partial_contents_ready_callback() callback
  LoadPartialSlots* slots = new LoadPartialSlots();
  SlotReadMore* slot_read_more_copy = new SlotReadMore(slot_read_more);
  SlotAsyncReady* slot_async_copy = new SlotAsyncReady(slot_async_ready);

  slots->first = slot_read_more_copy;
  slots->second = slot_async_copy;

  g_file_load_partial_contents_async(gobj(), Glib::unwrap(cancellable),
    &SignalProxy_load_partial_contents_read_more_callback,
    &SignalProxy_load_partial_contents_ready_callback, slots);
}

void
File::load_partial_contents_async(
  const SlotReadMore& slot_read_more, const SlotAsyncReady& slot_async_ready)
{
  // Create a new pair which will hold copies of passed slots.
  // This will be deleted in the SignalProxy_load_partial_contents_ready_callback() callback
  LoadPartialSlots* slots = new LoadPartialSlots();
  SlotReadMore* slot_read_more_copy = new SlotReadMore(slot_read_more);
  SlotAsyncReady* slot_async_copy = new SlotAsyncReady(slot_async_ready);

  slots->first = slot_read_more_copy;
  slots->second = slot_async_copy;

  g_file_load_partial_contents_async(gobj(), nullptr,
    &SignalProxy_load_partial_contents_read_more_callback,
    &SignalProxy_load_partial_contents_ready_callback, slots);
}

void
File::replace_contents(const char* contents, gsize length, const std::string& etag,
  std::string& new_etag, const Glib::RefPtr<Cancellable>& cancellable, bool make_backup,
  FileCreateFlags flags)
{
  GError* gerror = nullptr;
  gchar* c_etag_new = nullptr;
  g_file_replace_contents(gobj(), contents, length, Glib::c_str_or_nullptr(etag),
    static_cast<int>(make_backup), ((GFileCreateFlags)(flags)), &c_etag_new,
    const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  if (c_etag_new)
    new_etag = c_etag_new;
  else
    new_etag = std::string();
}

void
File::replace_contents(const char* contents, gsize length, const std::string& etag,
  std::string& new_etag, bool make_backup, FileCreateFlags flags)
{
  GError* gerror = nullptr;
  gchar* c_etag_new = nullptr;
  g_file_replace_contents(gobj(), contents, length, Glib::c_str_or_nullptr(etag),
    static_cast<int>(make_backup), ((GFileCreateFlags)(flags)), &c_etag_new, nullptr, &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  if (c_etag_new)
    new_etag = c_etag_new;
  else
    new_etag = std::string();
}

void
File::replace_contents(const std::string& contents, const std::string& etag, std::string& new_etag,
  const Glib::RefPtr<Cancellable>& cancellable, bool make_backup, FileCreateFlags flags)
{
  GError* gerror = nullptr;
  gchar* c_etag_new = nullptr;
  g_file_replace_contents(gobj(), contents.c_str(), contents.size(), Glib::c_str_or_nullptr(etag),
    static_cast<int>(make_backup), ((GFileCreateFlags)(flags)), &c_etag_new,
    const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  if (c_etag_new)
    new_etag = c_etag_new;
  else
    new_etag = std::string();
}

void
File::replace_contents(const std::string& contents, const std::string& etag, std::string& new_etag,
  bool make_backup, FileCreateFlags flags)
{
  GError* gerror = nullptr;
  gchar* c_etag_new = nullptr;
  g_file_replace_contents(gobj(), contents.c_str(), contents.size(), Glib::c_str_or_nullptr(etag),
    static_cast<int>(make_backup), ((GFileCreateFlags)(flags)), &c_etag_new, nullptr, &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  if (c_etag_new)
    new_etag = c_etag_new;
  else
    new_etag = std::string();
}

void
File::replace_contents_async(const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable, const char* contents, gsize length,
  const std::string& etag, bool make_backup, FileCreateFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_replace_contents_async(gobj(), contents, length, Glib::c_str_or_nullptr(etag), make_backup,
    static_cast<GFileCreateFlags>(flags), Glib::unwrap(cancellable), &SignalProxy_async_callback,
    slot_copy);
}

void
File::replace_contents_async(const SlotAsyncReady& slot, const char* contents, gsize length,
  const std::string& etag, bool make_backup, FileCreateFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_replace_contents_async(gobj(), contents, length, Glib::c_str_or_nullptr(etag), make_backup,
    static_cast<GFileCreateFlags>(flags), nullptr, &SignalProxy_async_callback, slot_copy);
}

void
File::replace_contents_async(const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable, const std::string& contents,
  const std::string& etag, bool make_backup, FileCreateFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_replace_contents_async(gobj(), contents.c_str(), contents.size(),
    Glib::c_str_or_nullptr(etag), make_backup, static_cast<GFileCreateFlags>(flags),
    Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::replace_contents_async(const SlotAsyncReady& slot, const std::string& contents,
  const std::string& etag, bool make_backup, FileCreateFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_replace_contents_async(gobj(), contents.c_str(), contents.size(),
    Glib::c_str_or_nullptr(etag), make_backup, static_cast<GFileCreateFlags>(flags), nullptr,
    &SignalProxy_async_callback, slot_copy);
}

void
File::replace_contents_finish(const Glib::RefPtr<AsyncResult>& result, std::string& new_etag)
{
  GError* gerror = nullptr;
  gchar* c_new_etag = nullptr;
  g_file_replace_contents_finish(gobj(), Glib::unwrap(result), &c_new_etag, &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  if (c_new_etag)
    new_etag = c_new_etag;
  else
    new_etag = std::string();
}

void
File::replace_contents_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  g_file_replace_contents_finish(gobj(), Glib::unwrap(result), nullptr, &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);
}

void
File::replace_contents_bytes_async(const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable, const Glib::RefPtr<const Glib::Bytes>& contents,
  const std::string& etag, bool make_backup, FileCreateFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_replace_contents_bytes_async(gobj(), const_cast<GBytes*>(Glib::unwrap(contents)),
    Glib::c_str_or_nullptr(etag), make_backup, static_cast<GFileCreateFlags>(flags),
    Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::replace_contents_bytes_async(const SlotAsyncReady& slot,
  const Glib::RefPtr<const Glib::Bytes>& contents, const std::string& etag, bool make_backup,
  FileCreateFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_replace_contents_bytes_async(gobj(), const_cast<GBytes*>(Glib::unwrap(contents)),
    Glib::c_str_or_nullptr(etag), make_backup, static_cast<GFileCreateFlags>(flags), nullptr,
    &SignalProxy_async_callback, slot_copy);
}

Glib::RefPtr<FileOutputStream>
File::replace(const Glib::RefPtr<Cancellable>& cancellable, const std::string& etag,
  bool make_backup, FileCreateFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_file_replace(gobj(), Glib::c_str_or_nullptr(etag),
    static_cast<int>(make_backup), ((GFileCreateFlags)(flags)),
    const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileOutputStream>
File::replace(const std::string& etag, bool make_backup, FileCreateFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_file_replace(gobj(), Glib::c_str_or_nullptr(etag),
    static_cast<int>(make_backup), ((GFileCreateFlags)(flags)), nullptr, &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileIOStream>
File::replace_readwrite(const Glib::RefPtr<Cancellable>& cancellable, const std::string& etag,
  bool make_backup, FileCreateFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_file_replace_readwrite(gobj(), Glib::c_str_or_nullptr(etag),
    static_cast<int>(make_backup), ((GFileCreateFlags)(flags)),
    const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileIOStream>
File::replace_readwrite(const std::string& etag, bool make_backup, FileCreateFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_file_replace_readwrite(gobj(), Glib::c_str_or_nullptr(etag),
    static_cast<int>(make_backup), ((GFileCreateFlags)(flags)), nullptr, &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileMonitor>
File::monitor_directory(const Glib::RefPtr<Cancellable>& cancellable, FileMonitorFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_file_monitor_directory(gobj(), ((GFileMonitorFlags)(flags)),
    const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileMonitor>
File::monitor_directory(FileMonitorFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue =
    Glib::wrap(g_file_monitor_directory(gobj(), ((GFileMonitorFlags)(flags)), nullptr, &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileMonitor>
File::monitor_file(const Glib::RefPtr<Cancellable>& cancellable, FileMonitorFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_file_monitor_file(gobj(), ((GFileMonitorFlags)(flags)),
    const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileMonitor>
File::monitor_file(FileMonitorFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue =
    Glib::wrap(g_file_monitor_file(gobj(), ((GFileMonitorFlags)(flags)), nullptr, &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileMonitor>
File::monitor(const Glib::RefPtr<Cancellable>& cancellable, FileMonitorFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_file_monitor(gobj(), ((GFileMonitorFlags)(flags)),
    const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileMonitor>
File::monitor(FileMonitorFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue =
    Glib::wrap(g_file_monitor(gobj(), ((GFileMonitorFlags)(flags)), nullptr, &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

void
File::measure_disk_usage(const Glib::RefPtr<Cancellable>& cancellable,
  const SlotFileMeasureProgress& slot_progress, guint64& disk_usage, guint64& num_dirs,
  guint64& num_files, FileMeasureFlags flags)
{
  GError* gerror = nullptr;
  g_file_measure_disk_usage(gobj(), ((GFileMeasureFlags)(flags)),
    const_cast<GCancellable*>(Glib::unwrap(cancellable)),
    &SignalProxy_file_measure_progress_callback,
    const_cast<SlotFileMeasureProgress*>(&slot_progress), &disk_usage, &num_dirs, &num_files,
    &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);
}

void
File::measure_disk_usage_async(const SlotAsyncReady& slot_ready,
  const Glib::RefPtr<Cancellable>& cancellable, const SlotFileMeasureProgress& slot_progress,
  FileMeasureFlags flags, int io_priority)
{
  // Create a new pair which will hold copies of passed slots.
  // This will be deleted in the SignalProxy_file_measure_async_callback() callback
  MeasureSlots* slots = new MeasureSlots();
  SlotFileMeasureProgress* slot_progress_copy = new SlotFileMeasureProgress(slot_progress);
  SlotAsyncReady* slot_ready_copy = new SlotAsyncReady(slot_ready);

  slots->first = slot_progress_copy;
  slots->second = slot_ready_copy;

  g_file_measure_disk_usage_async(gobj(), ((GFileMeasureFlags)(flags)), io_priority,
    const_cast<GCancellable*>(Glib::unwrap(cancellable)),
    &SignalProxy_file_measure_progress_callback,
    const_cast<SlotFileMeasureProgress*>(&slot_progress), &SignalProxy_file_measure_async_callback,
    slots);
}

void
File::start_mountable(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable,
  const Glib::RefPtr<MountOperation>& start_operation, DriveStartFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_start_mountable(gobj(), ((GDriveStartFlags)(flags)), Glib::unwrap(start_operation),
    Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::start_mountable(const SlotAsyncReady& slot,
  const Glib::RefPtr<MountOperation>& start_operation, DriveStartFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_start_mountable(gobj(), ((GDriveStartFlags)(flags)), Glib::unwrap(start_operation),
    nullptr, &SignalProxy_async_callback, slot_copy);
}

void
File::stop_mountable(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable,
  const Glib::RefPtr<MountOperation>& start_operation, MountUnmountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_stop_mountable(gobj(), ((GMountUnmountFlags)(flags)), Glib::unwrap(start_operation),
    Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::stop_mountable(const SlotAsyncReady& slot,
  const Glib::RefPtr<MountOperation>& start_operation, MountUnmountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_stop_mountable(gobj(), ((GMountUnmountFlags)(flags)), Glib::unwrap(start_operation),
    nullptr, &SignalProxy_async_callback, slot_copy);
}

void
File::poll_mountable(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_poll_mountable(gobj(), Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::poll_mountable(const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_poll_mountable(gobj(), nullptr, &SignalProxy_async_callback, slot_copy);
}

void
File::find_enclosing_mount_async(
  const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_find_enclosing_mount_async(
    gobj(), io_priority, Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
File::find_enclosing_mount_async(const SlotAsyncReady& slot, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_file_find_enclosing_mount_async(
    gobj(), io_priority, nullptr, &SignalProxy_async_callback, slot_copy);
}

bool
File::set_attributes_from_info(const Glib::RefPtr<FileInfo>& info,
  const Glib::RefPtr<Cancellable>& cancellable, FileQueryInfoFlags flags)
{
  GError* gerror = nullptr;
  bool retvalue =
    g_file_set_attributes_from_info(gobj(), Glib::unwrap(info), ((GFileQueryInfoFlags)(flags)),
      const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

bool
File::set_attributes_from_info(const Glib::RefPtr<FileInfo>& info, FileQueryInfoFlags flags)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_set_attributes_from_info(
    gobj(), Glib::unwrap(info), ((GFileQueryInfoFlags)(flags)), nullptr, &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

bool
File::copy_attributes(const Glib::RefPtr<File>& destination,
  const Glib::RefPtr<Cancellable>& cancellable, FileCopyFlags flags)
{
  GError* gerror = nullptr;
  bool res;

  res = g_file_copy_attributes(gobj(), Glib::unwrap(destination),
    static_cast<GFileCopyFlags>(flags), Glib::unwrap(cancellable), &gerror);

  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return res;
}

bool
File::copy_attributes(const Glib::RefPtr<File>& destination, FileCopyFlags flags)
{
  GError* gerror = nullptr;
  bool res;

  res = g_file_copy_attributes(
    gobj(), Glib::unwrap(destination), static_cast<GFileCopyFlags>(flags), nullptr, &gerror);

  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return res;
}

Glib::RefPtr<FileOutputStream>
File::create_file(const Glib::RefPtr<Cancellable>& cancellable, FileCreateFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_file_create(gobj(), ((GFileCreateFlags)(flags)),
    const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileOutputStream>
File::create_file(FileCreateFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue =
    Glib::wrap(g_file_create(gobj(), ((GFileCreateFlags)(flags)), nullptr, &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileIOStream>
File::create_file_readwrite(const Glib::RefPtr<Cancellable>& cancellable, FileCreateFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_file_create_readwrite(gobj(), ((GFileCreateFlags)(flags)),
    const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileIOStream>
File::create_file_readwrite(FileCreateFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue =
    Glib::wrap(g_file_create_readwrite(gobj(), ((GFileCreateFlags)(flags)), nullptr, &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileOutputStream>
File::append_to(const Glib::RefPtr<Cancellable>& cancellable, FileCreateFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_file_append_to(gobj(), ((GFileCreateFlags)(flags)),
    const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<FileOutputStream>
File::append_to(FileCreateFlags flags)
{
  GError* gerror = nullptr;
  auto retvalue =
    Glib::wrap(g_file_append_to(gobj(), ((GFileCreateFlags)(flags)), nullptr, &(gerror)));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

bool
File::load_contents(const Glib::RefPtr<Cancellable>& cancellable, char*& contents, gsize& length,
  std::string& etag_out)
{
  GError* gerror = nullptr;
  gchar* cetag_out = nullptr;
  bool retvalue = g_file_load_contents(
    gobj(), Glib::unwrap(cancellable), &contents, &(length), &cetag_out, &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  etag_out = Glib::convert_return_gchar_ptr_to_stdstring(cetag_out);

  return retvalue;
}

bool
File::load_contents(const Glib::RefPtr<Cancellable>& cancellable, char*& contents, gsize& length)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_load_contents(
    gobj(), Glib::unwrap(cancellable), &contents, &(length), nullptr, &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

bool
File::load_contents(char*& contents, gsize& length, std::string& etag_out)
{
  GError* gerror = nullptr;
  gchar* cetag_out = nullptr;
  bool retvalue =
    g_file_load_contents(gobj(), nullptr, &contents, &(length), &cetag_out, &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  etag_out = Glib::convert_return_gchar_ptr_to_stdstring(cetag_out);

  return retvalue;
}

bool
File::load_contents(char*& contents, gsize& length)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_load_contents(gobj(), nullptr, &contents, &(length), nullptr, &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

bool
File::load_contents_finish(
  const Glib::RefPtr<AsyncResult>& result, char*& contents, gsize& length, std::string& etag_out)
{
  GError* gerror = nullptr;
  gchar* cetag_out = nullptr;
  bool retvalue = g_file_load_contents_finish(
    gobj(), Glib::unwrap(result), &contents, &(length), &cetag_out, &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  etag_out = Glib::convert_return_gchar_ptr_to_stdstring(cetag_out);

  return retvalue;
}

bool
File::load_contents_finish(const Glib::RefPtr<AsyncResult>& result, char*& contents, gsize& length)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_load_contents_finish(
    gobj(), Glib::unwrap(result), &contents, &(length), nullptr, &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

bool
File::load_partial_contents_finish(
  const Glib::RefPtr<AsyncResult>& result, char*& contents, gsize& length, std::string& etag_out)
{
  GError* gerror = nullptr;
  gchar* cetag_out = nullptr;
  bool retvalue = g_file_load_partial_contents_finish(
    gobj(), Glib::unwrap(result), &contents, &(length), &cetag_out, &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  etag_out = Glib::convert_return_gchar_ptr_to_stdstring(cetag_out);

  return retvalue;
}

bool
File::load_partial_contents_finish(
  const Glib::RefPtr<AsyncResult>& result, char*& contents, gsize& length)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_load_partial_contents_finish(
    gobj(), Glib::unwrap(result), &contents, &(length), nullptr, &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

bool
File::has_parent() const
{
  return g_file_has_parent(const_cast<GFile*>(gobj()), nullptr);
}

void
File::remove_async(
  const SlotAsyncReady& slot_ready, const Glib::RefPtr<Cancellable>& cancellable, int io_priority)
{
  // Create copies of slots.
  // Pointers to them will be passed through the callbacks' data parameter
  // and deleted in the corresponding callback.
  SlotAsyncReady* slot_ready_copy = new SlotAsyncReady(slot_ready);

  g_file_delete_async(
    gobj(), io_priority, Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_ready_copy);
}

void
File::remove_async(const SlotAsyncReady& slot_ready, int io_priority)
{
  // Create copies of slots.
  // Pointers to them will be passed through the callbacks' data parameter
  // and deleted in the corresponding callback.
  SlotAsyncReady* slot_ready_copy = new SlotAsyncReady(slot_ready);

  g_file_delete_async(gobj(), io_priority, nullptr, &SignalProxy_async_callback, slot_ready_copy);
}

void
File::trash_async(
  const SlotAsyncReady& slot_ready, const Glib::RefPtr<Cancellable>& cancellable, int io_priority)
{
  // Create copies of slots.
  // Pointers to them will be passed through the callbacks' data parameter
  // and deleted in the corresponding callback.
  SlotAsyncReady* slot_ready_copy = new SlotAsyncReady(slot_ready);

  g_file_trash_async(
    gobj(), io_priority, Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_ready_copy);
}

void
File::trash_async(const SlotAsyncReady& slot_ready, int io_priority)
{
  // Create copies of slots.
  // Pointers to them will be passed through the callbacks' data parameter
  // and deleted in the corresponding callback.
  SlotAsyncReady* slot_ready_copy = new SlotAsyncReady(slot_ready);

  g_file_trash_async(gobj(), io_priority, nullptr, &SignalProxy_async_callback, slot_ready_copy);
}

void
File::make_directory_async(
  const SlotAsyncReady& slot_ready, const Glib::RefPtr<Cancellable>& cancellable, int io_priority)
{
  // Create copies of slots.
  // Pointers to them will be passed through the callbacks' data parameter
  // and deleted in the corresponding callback.
  SlotAsyncReady* slot_ready_copy = new SlotAsyncReady(slot_ready);

  g_file_make_directory_async(
    gobj(), io_priority, Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_ready_copy);
}

void
File::make_directory_async(const SlotAsyncReady& slot_ready, int io_priority)
{
  // Create copies of slots.
  // Pointers to them will be passed through the callbacks' data parameter
  // and deleted in the corresponding callback.
  SlotAsyncReady* slot_ready_copy = new SlotAsyncReady(slot_ready);

  g_file_make_directory_async(
    gobj(), io_priority, nullptr, &SignalProxy_async_callback, slot_ready_copy);
}

} // namespace Gio

namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gio::File> wrap(GFile* object, bool take_copy)
{
  return Glib::RefPtr<Gio::File>( dynamic_cast<Gio::File*> (Glib::wrap_auto_interface<Gio::File> ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} // namespace Glib


namespace Gio
{


/* The *_Class implementation: */

const Glib::Interface_Class& File_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Interface_Class has to know the interface init function
    // in order to add interfaces to implementing types.
    class_init_func_ = &File_Class::iface_init_function;

    // We can not derive from another interface, and it is not necessary anyway.
    gtype_ = g_file_get_type();
  }

  return *this;
}

void File_Class::iface_init_function(void* g_iface, void*)
{
  const auto klass = static_cast<BaseClassType*>(g_iface);

  //This is just to avoid an "unused variable" warning when there are no vfuncs or signal handlers to connect.
  //This is a temporary fix until I find out why I can not seem to derive a GtkFileChooser interface. murrayc
  g_assert(klass != nullptr);


}


Glib::ObjectBase* File_Class::wrap_new(GObject* object)
{
  return new File((GFile*)(object));
}


/* The implementation: */

File::File()
:
  Glib::Interface(file_class_.init())
{}

File::File(GFile* castitem)
:
  Glib::Interface((GObject*)(castitem))
{}

File::File(const Glib::Interface_Class& interface_class)
: Glib::Interface(interface_class)
{
}

File::File(File&& src) noexcept
: Glib::Interface(std::move(src))
{}

File& File::operator=(File&& src) noexcept
{
  Glib::Interface::operator=(std::move(src));
  return *this;
}

File::~File() noexcept
{}

// static
void File::add_interface(GType gtype_implementer)
{
  file_class_.init().add_interface(gtype_implementer);
}

File::CppClassType File::file_class_; // initialize static member

GType File::get_type()
{
  return file_class_.init().get_type();
}


GType File::get_base_type()
{
  return g_file_get_type();
}


Glib::RefPtr<File> File::dup() const
{
  return Glib::wrap(g_file_dup(const_cast<GFile*>(gobj())));
}

guint File::hash() const
{
  return g_file_hash(const_cast<GFile*>(gobj()));
}

bool File::equal(const Glib::RefPtr<const File>& other) const
{
  return g_file_equal(const_cast<GFile*>(gobj()), const_cast<GFile*>(Glib::unwrap<Gio::File>(other)));
}

std::string File::get_basename() const
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_file_get_basename(const_cast<GFile*>(gobj())));
}

std::string File::get_path() const
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_file_get_path(const_cast<GFile*>(gobj())));
}

std::string File::get_uri() const
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_file_get_uri(const_cast<GFile*>(gobj())));
}

Glib::ustring File::get_parse_name() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(g_file_get_parse_name(const_cast<GFile*>(gobj())));
}

Glib::RefPtr<File> File::get_parent() const
{
  return Glib::wrap(g_file_get_parent(const_cast<GFile*>(gobj())));
}

bool File::has_parent(const Glib::RefPtr<File>& parent) const
{
  return g_file_has_parent(const_cast<GFile*>(gobj()), Glib::unwrap(parent));
}

Glib::RefPtr<File> File::get_child(const std::string& name) const
{
  return Glib::wrap(g_file_get_child(const_cast<GFile*>(gobj()), name.c_str()));
}

Glib::RefPtr<File> File::get_child_for_display_name(const Glib::ustring& display_name) const
{
  GError* gerror = nullptr;
  Glib::RefPtr<File> retvalue = Glib::wrap(g_file_get_child_for_display_name(const_cast<GFile*>(gobj()), display_name.c_str(), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::has_prefix(const Glib::RefPtr<const File>& prefix) const
{
  return g_file_has_prefix(const_cast<GFile*>(gobj()), const_cast<GFile*>(Glib::unwrap<Gio::File>(prefix)));
}

std::string File::get_relative_path(const Glib::RefPtr<const File>& descendant) const
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_file_get_relative_path(const_cast<GFile*>(gobj()), const_cast<GFile*>(Glib::unwrap<Gio::File>(descendant))));
}

Glib::RefPtr<File> File::resolve_relative_path(const std::string& relative_path) const
{
  return Glib::wrap(g_file_resolve_relative_path(const_cast<GFile*>(gobj()), relative_path.c_str()));
}

bool File::is_native() const
{
  return g_file_is_native(const_cast<GFile*>(gobj()));
}

bool File::has_uri_scheme(const std::string& uri_scheme) const
{
  return g_file_has_uri_scheme(const_cast<GFile*>(gobj()), uri_scheme.c_str());
}

std::string File::get_uri_scheme() const
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_file_get_uri_scheme(const_cast<GFile*>(gobj())));
}

Glib::RefPtr<FileInputStream> File::read(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileInputStream> retvalue = Glib::wrap(g_file_read(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<FileInputStream> File::read()
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileInputStream> retvalue = Glib::wrap(g_file_read(gobj(), nullptr, &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<FileInputStream> File::read_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileInputStream> retvalue = Glib::wrap(g_file_read_finish(gobj(), Glib::unwrap(res), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<FileOutputStream> File::append_to_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileOutputStream> retvalue = Glib::wrap(g_file_append_to_finish(gobj(), Glib::unwrap(res), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<FileOutputStream> File::create_file_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileOutputStream> retvalue = Glib::wrap(g_file_create_finish(gobj(), Glib::unwrap(res), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<FileIOStream> File::create_file_readwrite_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileIOStream> retvalue = Glib::wrap(g_file_create_readwrite_finish(gobj(), Glib::unwrap(res), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<FileOutputStream> File::replace_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileOutputStream> retvalue = Glib::wrap(g_file_replace_finish(gobj(), Glib::unwrap(res), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<FileIOStream> File::open_readwrite(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileIOStream> retvalue = Glib::wrap(g_file_open_readwrite(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<FileIOStream> File::open_readwrite()
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileIOStream> retvalue = Glib::wrap(g_file_open_readwrite(gobj(), nullptr, &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<FileIOStream> File::open_readwrite_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileIOStream> retvalue = Glib::wrap(g_file_open_readwrite_finish(gobj(), Glib::unwrap(res), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<FileIOStream> File::replace_readwrite_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileIOStream> retvalue = Glib::wrap(g_file_replace_readwrite_finish(gobj(), Glib::unwrap(res), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::query_exists(const Glib::RefPtr<Cancellable>& cancellable) const
{
  return g_file_query_exists(const_cast<GFile*>(gobj()), const_cast<GCancellable*>(Glib::unwrap(cancellable)));
}

bool File::query_exists() const
{
  return g_file_query_exists(const_cast<GFile*>(gobj()), nullptr);
}

FileType File::query_file_type(FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable) const
{
  return ((FileType)(g_file_query_file_type(const_cast<GFile*>(gobj()), ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)))));
}

Glib::RefPtr<FileInfo> File::query_info_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileInfo> retvalue = Glib::wrap(g_file_query_info_finish(gobj(), Glib::unwrap(res), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<Mount> File::find_enclosing_mount(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  Glib::RefPtr<Mount> retvalue = Glib::wrap(g_file_find_enclosing_mount(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<Mount> File::find_enclosing_mount()
{
  GError* gerror = nullptr;
  Glib::RefPtr<Mount> retvalue = Glib::wrap(g_file_find_enclosing_mount(gobj(), nullptr, &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<FileInfo> File::query_filesystem_info_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileInfo> retvalue = Glib::wrap(g_file_query_filesystem_info_finish(gobj(), Glib::unwrap(res), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<Mount> File::find_enclosing_mount_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  Glib::RefPtr<Mount> retvalue = Glib::wrap(g_file_find_enclosing_mount_finish(gobj(), Glib::unwrap(res), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<FileEnumerator> File::enumerate_children_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileEnumerator> retvalue = Glib::wrap(g_file_enumerate_children_finish(gobj(), Glib::unwrap(res), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<File> File::set_display_name(const Glib::ustring& display_name, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  Glib::RefPtr<File> retvalue = Glib::wrap(g_file_set_display_name(gobj(), display_name.c_str(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<File> File::set_display_name(const Glib::ustring& display_name)
{
  GError* gerror = nullptr;
  Glib::RefPtr<File> retvalue = Glib::wrap(g_file_set_display_name(gobj(), display_name.c_str(), nullptr, &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<File> File::set_display_name_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  Glib::RefPtr<File> retvalue = Glib::wrap(g_file_set_display_name_finish(gobj(), Glib::unwrap(res), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::remove(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_delete(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::remove()
{
  GError* gerror = nullptr;
  bool retvalue = g_file_delete(gobj(), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::remove_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_delete_finish(gobj(), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::trash(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_trash(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::trash()
{
  GError* gerror = nullptr;
  bool retvalue = g_file_trash(gobj(), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::trash_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_trash_finish(gobj(), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::copy_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_copy_finish(gobj(), Glib::unwrap(res), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::make_directory(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_make_directory(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::make_directory()
{
  GError* gerror = nullptr;
  bool retvalue = g_file_make_directory(gobj(), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::make_directory_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_make_directory_finish(gobj(), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::make_directory_with_parents(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_make_directory_with_parents(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::make_directory_with_parents()
{
  GError* gerror = nullptr;
  bool retvalue = g_file_make_directory_with_parents(gobj(), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::make_symbolic_link(const std::string& symlink_value, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_make_symbolic_link(gobj(), symlink_value.c_str(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::make_symbolic_link(const std::string& symlink_value)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_make_symbolic_link(gobj(), symlink_value.c_str(), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<FileAttributeInfoList> File::query_settable_attributes(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileAttributeInfoList> retvalue = Glib::wrap(g_file_query_settable_attributes(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<FileAttributeInfoList> File::query_settable_attributes()
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileAttributeInfoList> retvalue = Glib::wrap(g_file_query_settable_attributes(gobj(), nullptr, &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<FileAttributeInfoList> File::query_writable_namespaces(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileAttributeInfoList> retvalue = Glib::wrap(g_file_query_writable_namespaces(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<FileAttributeInfoList> File::query_writable_namespaces()
{
  GError* gerror = nullptr;
  Glib::RefPtr<FileAttributeInfoList> retvalue = Glib::wrap(g_file_query_writable_namespaces(gobj(), nullptr, &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::set_attribute_string(const std::string& attribute, const std::string& value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_set_attribute_string(gobj(), attribute.c_str(), value.c_str(), ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::set_attribute_string(const std::string& attribute, const std::string& value, FileQueryInfoFlags flags)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_set_attribute_string(gobj(), attribute.c_str(), value.c_str(), ((GFileQueryInfoFlags)(flags)), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::set_attribute_byte_string(const std::string& attribute, const std::string& value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_set_attribute_byte_string(gobj(), attribute.c_str(), value.c_str(), ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::set_attribute_byte_string(const std::string& attribute, const std::string& value, FileQueryInfoFlags flags)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_set_attribute_byte_string(gobj(), attribute.c_str(), value.c_str(), ((GFileQueryInfoFlags)(flags)), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::set_attribute_uint32(const std::string& attribute, guint32 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_set_attribute_uint32(gobj(), attribute.c_str(), value, ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::set_attribute_uint32(const std::string& attribute, guint32 value, FileQueryInfoFlags flags)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_set_attribute_uint32(gobj(), attribute.c_str(), value, ((GFileQueryInfoFlags)(flags)), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::set_attribute_int32(const std::string& attribute, gint32 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_set_attribute_int32(gobj(), attribute.c_str(), value, ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::set_attribute_int32(const std::string& attribute, gint32 value, FileQueryInfoFlags flags)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_set_attribute_int32(gobj(), attribute.c_str(), value, ((GFileQueryInfoFlags)(flags)), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::set_attribute_uint64(const std::string& attribute, guint64 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_set_attribute_uint64(gobj(), attribute.c_str(), value, ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::set_attribute_uint64(const std::string& attribute, guint64 value, FileQueryInfoFlags flags)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_set_attribute_uint64(gobj(), attribute.c_str(), value, ((GFileQueryInfoFlags)(flags)), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::set_attribute_int64(const std::string& attribute, gint64 value, FileQueryInfoFlags flags, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_set_attribute_int64(gobj(), attribute.c_str(), value, ((GFileQueryInfoFlags)(flags)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::set_attribute_int64(const std::string& attribute, gint64 value, FileQueryInfoFlags flags)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_set_attribute_int64(gobj(), attribute.c_str(), value, ((GFileQueryInfoFlags)(flags)), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::mount_enclosing_volume_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_mount_enclosing_volume_finish(gobj(), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<File> File::mount_mountable_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  Glib::RefPtr<File> retvalue = Glib::wrap(g_file_mount_mountable_finish(gobj(), Glib::unwrap(result), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::unmount_mountable_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_unmount_mountable_with_operation_finish(gobj(), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::eject_mountable_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_eject_mountable_with_operation_finish(gobj(), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::measure_disk_usage_finish(const Glib::RefPtr<AsyncResult>& result, guint64& disk_usage, guint64& num_dirs, guint64& num_files)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_measure_disk_usage_finish(gobj(), Glib::unwrap(result), &(disk_usage), &(num_dirs), &(num_files), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::start_mountable_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_start_mountable_finish(gobj(), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::stop_mountable_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_stop_mountable_finish(gobj(), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::poll_mountable_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  bool retvalue = g_file_poll_mountable_finish(gobj(), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<AppInfo> File::query_default_handler(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  Glib::RefPtr<AppInfo> retvalue = Glib::wrap(g_file_query_default_handler(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<AppInfo> File::query_default_handler()
{
  GError* gerror = nullptr;
  Glib::RefPtr<AppInfo> retvalue = Glib::wrap(g_file_query_default_handler(gobj(), nullptr, &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool File::supports_thread_contexts() const
{
  return g_file_supports_thread_contexts(const_cast<GFile*>(gobj()));
}


} // namespace Gio


