#include <gmf.h>
#include <libgmf/gnome-genericfactory.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>

#include "stk-synth.h"

typedef struct {
  CORBA_ORB orb;
  CORBA_Environment *ev;
  GMFTimeReference *timeref;
  GnomeGenericFactory *factory;
  gpointer stk_info;
  guint timer_id;
  GtkWidget *inst_dlg;
} STKSynthInfo;

typedef struct {
  STKSynthInfo *ai;
  GMFFilter *filter;
} FiltInfo;

static void stk_synth_create_filter(GnomeGenericFactory *factory,
				    const char *goad_id, GNOME_stringlist *params,
				    CORBA_Object *new_object, STKSynthInfo *ai);

static void stk_synth_in_get_pipe(GMFFilter *filter,
				  GMF_Direction pDirection,
				  GMFPipe **pipe,
				  FiltInfo *fi);
static GtkWidget *inst_dlg_new(STKSynthInfo *ai);

#if 0
static void stk_synth_out_get_pipe(GMFFilter *filter,
				  GMF_Direction pDirection,
				  GMFPipe **pipe,
				  FiltInfo *fi);
#endif

int main(int argc, char *argv[])
{
  CORBA_Environment ev;
  poptContext ctx;
  STKSynthInfo appinfo;

  CORBA_exception_init(&ev);
  appinfo.ev = &ev;
  appinfo.timer_id = 0;
  appinfo.orb = gnome_CORBA_init_with_popt_table("stk-synth", VERSION,
						 &argc, argv, NULL, 0,
						 &ctx, GNORBA_INIT_SERVER_FUNC,
						 &ev);

  appinfo.factory = GNOME_GENERIC_FACTORY(gnome_generic_factory_new("stk-synth-factory"));
  appinfo.timeref = GMF_TIME_REFERENCE(gmf_time_reference_new());
  appinfo.stk_info = stk_synth_init();
  appinfo.inst_dlg = inst_dlg_new(&appinfo);
  
  stk_synth_change_instrument(appinfo.stk_info, "Clarinet");

  gtk_signal_connect(GTK_OBJECT(appinfo.factory), "create_object",
		     GTK_SIGNAL_FUNC(stk_synth_create_filter), &appinfo);

  gtk_main();

  return 0;
}

static void
set_instrument(GtkMenuItem *item, STKSynthInfo *ai)
{
  char *val = "Clarinet";
  GtkLabel *label;

  val = gtk_object_get_data(GTK_OBJECT(item), "inst");

  g_message("Changing instrument to %s", val);

  stk_synth_change_instrument(ai->stk_info, val);
}

static GtkWidget *
inst_dlg_new(STKSynthInfo *ai)
{
  char *instruments[] = {
    "Clarinet",
    "Flute",
    "Brass",
    "Bowed",
    "Plucked",
    "Mandolin",
    "Marimba",
    "Vibraphn",
    "AgogoBel",
    "Rhodey",
    "Wurley",
    "TubeBell",
    "HeavyMtl",
    "PercFlut",
    "BeeThree",
    "Moog1",
    "FMVoices",
    "VoicForm",
    "DrumSynt",
    NULL
  };
  GtkWidget *retval, *wtmp1, *wtmp2, *ent;
  int i;

  retval = gtk_dialog_new();

  wtmp1 = gtk_option_menu_new();
  wtmp2 = gtk_menu_new();

  for(i = 0; instruments[i]; i++) {
    ent = gtk_menu_item_new_with_label(instruments[i]);
    gtk_menu_append(GTK_MENU(wtmp2), ent);
    gtk_widget_show_all(ent);

    gtk_object_set_data(GTK_OBJECT(ent), "inst", instruments[i]);
    gtk_signal_connect(GTK_OBJECT(ent), "activate",
		       GTK_SIGNAL_FUNC(set_instrument), ai);
  }

  gtk_option_menu_set_history(GTK_OPTION_MENU(wtmp1), 0);

  gtk_option_menu_set_menu(GTK_OPTION_MENU(wtmp1), wtmp2);
  gtk_widget_show(wtmp1);

  gtk_container_add(GTK_CONTAINER(GTK_DIALOG(retval)->vbox), wtmp1);

  gtk_widget_show(retval);

  return retval;
}

static void
stk_synth_create_filter(GnomeGenericFactory *factory,
		       const char *goad_id, GNOME_stringlist *params,
		       CORBA_Object *new_object, STKSynthInfo *ai)
{
  GMFFilter *new_filter;
  GMF_Filter_Type ftype;
  FiltInfo *fi;

  if(!strcmp(goad_id, "stk-synth-out")) {
    ftype = GMF_Filter_RENDERER;
  } else {
    return; /* Can't activate anything else */
  }

  new_filter = GMF_FILTER(gmf_filter_new(ftype, goad_id));
  g_assert(new_filter);

  fi = g_new0(FiltInfo, 1);
  fi->ai = ai;
  if(!strcmp(goad_id, "stk-synth-out")) {
    gtk_signal_connect(GTK_OBJECT(new_filter), "get_pipe",
		       GTK_SIGNAL_FUNC(stk_synth_in_get_pipe), fi);
  } else
    g_assert(!"Not reached!");

  fi->filter = new_filter;

  *new_object = CORBA_Object_duplicate(new_filter->corba_object, ai->ev);
}

static void raw_pipe_can_process(GMFPipe *pipe, GMF_MediaTypeInfo *type_info,
				 gboolean *retval)
{
  if(type_info->majorType != GMF_MEDIA_AUDIO_SCENE)
    return;

  if(strcmp(type_info->minorType, "audio/midi"))
    return;

  *retval = TRUE;
}

static void raw_pipe_processable_types(GMFPipe *pipe,
				       GMF_MediaTypeInfoList **out_typelist,
				       FiltInfo *fi)
{
  GMF_MediaTypeInfoList *list;
  GMF_MediaTypeInfo *ti;

  list = GMF_MediaTypeInfoList__alloc();
  list->_length = 1;
  list->_buffer = CORBA_sequence_GMF_MediaTypeInfo_allocbuf(list->_length);

  ti = &list->_buffer[0];
  {
    memset(ti, 0, sizeof(*ti));
    ti->majorType = GMF_MEDIA_AUDIO_SCENE;
    ti->minorType = CORBA_string_dup("audio/midi");
    ti->typeData._type = (CORBA_TypeCode)CORBA_Object_duplicate((CORBA_Object)TC_null, fi->ai->ev);
    ti->formatData._type = (CORBA_TypeCode)CORBA_Object_duplicate((CORBA_Object)TC_null, fi->ai->ev);
  }

  *out_typelist = list;
}

static gint do_tick(gpointer stk_info)
{
  stk_synth_tick(stk_info);
  stk_synth_tick(stk_info);
  stk_synth_tick(stk_info);
  stk_synth_tick(stk_info);
  stk_synth_tick(stk_info);
  stk_synth_tick(stk_info);
  stk_synth_tick(stk_info);
  stk_synth_tick(stk_info);

  return TRUE;
}

static void raw_pipe_in_handle_sample(GMFPipe *pipe,
				       GMF_Sample *sample,
				       gboolean must_copy,
				       FiltInfo *fi)
{
  if(!fi->ai->timer_id)
#if 0
    fi->ai->timer_id = gtk_timeout_add(1, do_tick, fi->ai->stk_info);
#else
    fi->ai->timer_id = gtk_idle_add(do_tick, fi->ai->stk_info);
#endif

  stk_synth_play(fi->ai->stk_info, sample->sData._buffer, sample->sData._length);
}

static void stk_synth_in_get_pipe(GMFFilter *filter,
				 GMF_Direction pDirection,
				 GMFPipe **pipe,
				 FiltInfo *fi)
{
  GMFPipe *newpipe;

  g_return_if_fail(pDirection == GMF_IN);

  newpipe = GMF_PIPE(gmf_pipe_new(filter, pDirection,
				  GMF_Transport_UNIX_SOCKETS|GMF_Transport_CORBA));

  g_assert(newpipe);

  gtk_signal_connect(GTK_OBJECT(newpipe), "can_process_type",
		     GTK_SIGNAL_FUNC(raw_pipe_can_process), fi);
  gtk_signal_connect(GTK_OBJECT(newpipe), "get_processable_types",
		     GTK_SIGNAL_FUNC(raw_pipe_processable_types), fi);

  gtk_signal_connect(GTK_OBJECT(newpipe), "receive_sample",
		     GTK_SIGNAL_FUNC(raw_pipe_in_handle_sample), fi);

  *pipe = newpipe;
}

#if 0
static void stk_synth_out_get_pipe(GMFFilter *filter,
				  GMF_Direction pDirection,
				  GMFPipe **pipe,
				  FiltInfo *fi)
{
  GMFPipe *newpipe;

  g_return_if_fail(pDirection == GMF_IN); /* We only allow data to be fed in */

  newpipe = GMF_PIPE(gmf_pipe_new(filter, pDirection,
				  GMF_Transport_UNIX_SOCKETS|GMF_Transport_CORBA));

  g_assert(newpipe);

  gtk_signal_connect(GTK_OBJECT(newpipe), "can_process_type",
		     GTK_SIGNAL_FUNC(raw_pipe_can_process), fi);
  gtk_signal_connect(GTK_OBJECT(newpipe), "get_processable_types",
		     GTK_SIGNAL_FUNC(raw_pipe_processable_types), fi);

  *pipe = newpipe;
}
#endif
