/*
 *  GMF: The GNOME Media Framework
 *
 *  Copyright (C) 1999 Elliot Lee
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Elliot Lee <sopwith@redhat.com>
 *
 */

#ifndef GMF_FILTERREGISTRY_H
#define GMF_FILTERREGISTRY_H 1

typedef struct {
  char *goad_id;
  char **input_types, **output_types;
} GMFFilterRegistryEntry;

typedef struct {
  /* value is a GMFFilterRegistryEntry pointer */
  GSList *list;
  /* value is a GMFFilterRegistryEntry pointer */
  GHashTable *by_id;
  /* value is a GSList pointer */
  GHashTable *by_input_type, *by_output_type;
} GMFFilterRegistry;

GMF_Filter gmf_filter_activate(GoadServerList *slist,
			       const char *goad_id);
GMF_Filter gmf_filter_activate_for_types(GoadServerList *slist,
					 GMFFilterRegistry *registry,
					 const char *intype,
					 const char *outtype);

GMFFilterRegistry *gmf_filter_registry_get();
void gmf_filter_registry_free(GMFFilterRegistry *registry);

#endif /* GMF_FILTERREGISTRY_H */
