/* archive-reader.c generated by valac 0.26.0.50-d9a75, the Vala compiler
 * generated from archive-reader.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <archive.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <archive_entry.h>
#include <libcommon.h>
#include <stdio.h>
#include <glib/gstdio.h>


#define BOXES_TYPE_ARCHIVE_READER (boxes_archive_reader_get_type ())
#define BOXES_ARCHIVE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReader))
#define BOXES_ARCHIVE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReaderClass))
#define BOXES_IS_ARCHIVE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ARCHIVE_READER))
#define BOXES_IS_ARCHIVE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ARCHIVE_READER))
#define BOXES_ARCHIVE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReaderClass))

typedef struct _BoxesArchiveReader BoxesArchiveReader;
typedef struct _BoxesArchiveReaderClass BoxesArchiveReaderClass;
typedef struct _BoxesArchiveReaderPrivate BoxesArchiveReaderPrivate;
#define _archive_read_finish0(var) ((var == NULL) ? NULL : (var = (archive_read_finish (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _Block10Data Block10Data;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _Block11Data Block11Data;

struct _BoxesArchiveReader {
	GObject parent_instance;
	BoxesArchiveReaderPrivate * priv;
	struct archive* archive;
};

struct _BoxesArchiveReaderClass {
	GObjectClass parent_class;
};

struct _BoxesArchiveReaderPrivate {
	gchar* filename;
	int* format;
	GList* filters;
};

struct _Block10Data {
	int _ref_count_;
	BoxesArchiveReader* self;
	FILE* fd;
};

struct _Block11Data {
	int _ref_count_;
	BoxesArchiveReader* self;
	int filter;
};


static gpointer boxes_archive_reader_parent_class = NULL;

GType boxes_archive_reader_get_type (void) G_GNUC_CONST;
#define BOXES_ARCHIVE_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReaderPrivate))
enum  {
	BOXES_ARCHIVE_READER_DUMMY_PROPERTY
};
#define BOXES_ARCHIVE_READER_BLOCK_SIZE 10240
BoxesArchiveReader* boxes_archive_reader_new (const gchar* filename, int* format, GList* filters, GError** error);
BoxesArchiveReader* boxes_archive_reader_construct (GType object_type, const gchar* filename, int* format, GList* filters, GError** error);
static int* _archive_format_dup (int* self);
static void boxes_archive_reader_open_archive (BoxesArchiveReader* self, GError** error);
GList* boxes_archive_reader_get_file_list (BoxesArchiveReader* self, GError** error);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
void boxes_archive_reader_extract_file (BoxesArchiveReader* self, const gchar* src, const gchar* dest, gboolean override_if_necessary, GError** error);
static void boxes_archive_reader_extract_files_recursive (BoxesArchiveReader* self, gchar** src_list, int src_list_length1, gchar** dest_list, int dest_list_length1, gboolean override_if_necessary, gboolean follow_hardlinks, GError** error);
void boxes_archive_reader_reset (BoxesArchiveReader* self, GError** error);
static int _archive_read_close_boxes_libarchive_function (gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static gchar* boxes_archive_reader_get_dest_file (BoxesArchiveReader* self, gchar** src_list, int src_list_length1, gchar** dest_list, int dest_list_length1, const gchar* src);
static int _archive_read_data_skip_boxes_libarchive_function (gpointer self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static int ___lambda85_ (Block10Data* _data10_);
static int ____lambda85__boxes_libarchive_function (gpointer self);
static int _archive_read_support_format_all_boxes_libarchive_function (gpointer self);
static int ___lambda82_ (BoxesArchiveReader* self);
static int ____lambda82__boxes_libarchive_function (gpointer self);
static int _archive_read_support_filter_all_boxes_libarchive_function (gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static int _____lambda83_ (Block11Data* _data11_);
static int ______lambda83__boxes_libarchive_function (gpointer self);
static int __lambda84_ (BoxesArchiveReader* self);
static int ___lambda84__boxes_libarchive_function (gpointer self);
static void boxes_archive_reader_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static int* _archive_format_dup (int* self) {
	int* dup;
#line 18 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	dup = g_new0 (int, 1);
#line 18 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	memcpy (dup, self, sizeof (int));
#line 18 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return dup;
#line 117 "archive-reader.c"
}


static gpointer __archive_format_dup0 (gpointer self) {
#line 18 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return self ? _archive_format_dup (self) : NULL;
#line 124 "archive-reader.c"
}


BoxesArchiveReader* boxes_archive_reader_construct (GType object_type, const gchar* filename, int* format, GList* filters, GError** error) {
	BoxesArchiveReader * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	int* _tmp2_ = NULL;
	int* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 13 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 13 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	self = (BoxesArchiveReader*) g_object_new (object_type, NULL);
#line 17 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = filename;
#line 17 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 17 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_g_free0 (self->priv->filename);
#line 17 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	self->priv->filename = _tmp1_;
#line 18 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp2_ = format;
#line 18 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp3_ = __archive_format_dup0 (_tmp2_);
#line 18 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_g_free0 (self->priv->format);
#line 18 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	self->priv->format = _tmp3_;
#line 19 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp4_ = filters;
#line 19 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	if (_tmp4_ != NULL) {
#line 160 "archive-reader.c"
		GList* _tmp5_ = NULL;
		GList* _tmp6_ = NULL;
#line 20 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp5_ = filters;
#line 20 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp6_ = g_list_copy (_tmp5_);
#line 20 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_g_list_free0 (self->priv->filters);
#line 20 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		self->priv->filters = _tmp6_;
#line 171 "archive-reader.c"
	}
#line 22 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	boxes_archive_reader_open_archive (self, &_inner_error_);
#line 22 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 22 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 22 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 22 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_g_object_unref0 (self);
#line 22 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			return NULL;
#line 185 "archive-reader.c"
		} else {
#line 22 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 22 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_clear_error (&_inner_error_);
#line 22 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			return NULL;
#line 193 "archive-reader.c"
		}
	}
#line 13 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return self;
#line 198 "archive-reader.c"
}


BoxesArchiveReader* boxes_archive_reader_new (const gchar* filename, int* format, GList* filters, GError** error) {
#line 13 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return boxes_archive_reader_construct (BOXES_TYPE_ARCHIVE_READER, filename, format, filters, error);
#line 205 "archive-reader.c"
}


static void _g_free0_ (gpointer var) {
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	var = (g_free (var), NULL);
#line 212 "archive-reader.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	g_list_free (self);
#line 221 "archive-reader.c"
}


GList* boxes_archive_reader_get_file_list (BoxesArchiveReader* self, GError** error) {
	GList* result = NULL;
	GList* _result_ = NULL;
	struct archive_entry* iterator = NULL;
	GError * _inner_error_ = NULL;
#line 25 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 26 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_result_ = NULL;
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	while (TRUE) {
#line 236 "archive-reader.c"
		gboolean _tmp0_ = FALSE;
		struct archive* _tmp1_ = NULL;
		struct archive_entry* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		struct archive_entry* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp1_ = self->archive;
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp3_ = boxes_get_next_header (_tmp1_, &_tmp2_, (guint) 1, &_inner_error_);
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		iterator = _tmp2_;
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp0_ = _tmp3_;
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				__g_list_free__g_free0_0 (_result_);
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				return NULL;
#line 262 "archive-reader.c"
			} else {
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				__g_list_free__g_free0_0 (_result_);
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_clear_error (&_inner_error_);
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				return NULL;
#line 272 "archive-reader.c"
			}
		}
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (!_tmp0_) {
#line 28 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			break;
#line 279 "archive-reader.c"
		}
#line 29 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp4_ = iterator;
#line 29 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp5_ = archive_entry_pathname (_tmp4_);
#line 29 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 29 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_result_ = g_list_append (_result_, _tmp6_);
#line 289 "archive-reader.c"
	}
#line 31 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	result = _result_;
#line 31 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return result;
#line 295 "archive-reader.c"
}


void boxes_archive_reader_extract_file (BoxesArchiveReader* self, const gchar* src, const gchar* dest, gboolean override_if_necessary, GError** error) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gboolean _tmp8_ = FALSE;
	GError * _inner_error_ = NULL;
#line 35 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	g_return_if_fail (self != NULL);
#line 35 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	g_return_if_fail (src != NULL);
#line 35 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	g_return_if_fail (dest != NULL);
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = src;
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp2_ = g_new0 (gchar*, 1 + 1);
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp2_[0] = _tmp1_;
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp3_ = _tmp2_;
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp3__length1 = 1;
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp4_ = dest;
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp6_ = g_new0 (gchar*, 1 + 1);
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp6_[0] = _tmp5_;
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp7_ = _tmp6_;
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp7__length1 = 1;
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp8_ = override_if_necessary;
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	boxes_archive_reader_extract_files_recursive (self, _tmp3_, 1, _tmp7_, 1, _tmp8_, TRUE, &_inner_error_);
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			return;
#line 358 "archive-reader.c"
		} else {
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_clear_error (&_inner_error_);
#line 39 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			return;
#line 366 "archive-reader.c"
		}
	}
}


static int _archive_read_close_boxes_libarchive_function (gpointer self) {
	int result;
	result = archive_read_close ((struct archive*) self);
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return result;
#line 377 "archive-reader.c"
}


void boxes_archive_reader_reset (BoxesArchiveReader* self, GError** error) {
	struct archive* _tmp0_ = NULL;
	struct archive* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 42 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	g_return_if_fail (self != NULL);
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = self->archive;
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = self->archive;
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	boxes_execute_libarchive_function (_tmp0_, _archive_read_close_boxes_libarchive_function, _tmp1_, (guint) 1, &_inner_error_);
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			return;
#line 401 "archive-reader.c"
		} else {
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_clear_error (&_inner_error_);
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			return;
#line 409 "archive-reader.c"
		}
	}
#line 44 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	boxes_archive_reader_open_archive (self, &_inner_error_);
#line 44 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 44 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 44 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 44 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			return;
#line 422 "archive-reader.c"
		} else {
#line 44 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 44 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_clear_error (&_inner_error_);
#line 44 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			return;
#line 430 "archive-reader.c"
		}
	}
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	g_atomic_int_inc (&_data10_->_ref_count_);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return _data10_;
#line 441 "archive-reader.c"
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
#line 450 "archive-reader.c"
		BoxesArchiveReader* self;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		self = _data10_->self;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_fclose0 (_data10_->fd);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_g_object_unref0 (self);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		g_slice_free (Block10Data, _data10_);
#line 460 "archive-reader.c"
	}
}


static int _archive_read_data_skip_boxes_libarchive_function (gpointer self) {
	int result;
	result = archive_read_data_skip ((struct archive*) self);
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return result;
#line 470 "archive-reader.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 73 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	if ((*length) == (*size)) {
#line 73 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 73 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 481 "archive-reader.c"
	}
#line 73 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	(*array)[(*length)++] = value;
#line 73 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	(*array)[*length] = NULL;
#line 487 "archive-reader.c"
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
#line 74 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	if ((*length) == (*size)) {
#line 74 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 74 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 498 "archive-reader.c"
	}
#line 74 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	(*array)[(*length)++] = value;
#line 74 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	(*array)[*length] = NULL;
#line 504 "archive-reader.c"
}


static int ___lambda85_ (Block10Data* _data10_) {
	BoxesArchiveReader* self;
	int result = 0;
	struct archive* _tmp0_ = NULL;
	FILE* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	int _tmp3_ = 0;
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	self = _data10_->self;
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = self->archive;
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = _data10_->fd;
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp2_ = fileno (_tmp1_);
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp3_ = archive_read_data_into_fd (_tmp0_, _tmp2_);
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	result = _tmp3_;
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return result;
#line 529 "archive-reader.c"
}


static int ____lambda85__boxes_libarchive_function (gpointer self) {
	int result;
	result = ___lambda85_ (self);
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return result;
#line 538 "archive-reader.c"
}


static void boxes_archive_reader_extract_files_recursive (BoxesArchiveReader* self, gchar** src_list, int src_list_length1, gchar** dest_list, int dest_list_length1, gboolean override_if_necessary, gboolean follow_hardlinks, GError** error) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	struct archive_entry* iterator = NULL;
	guint i = 0U;
	gchar** hardlink_src = NULL;
	gchar** _tmp3_ = NULL;
	gint hardlink_src_length1 = 0;
	gint _hardlink_src_size_ = 0;
	gchar** hardlink_dest = NULL;
	gchar** _tmp4_ = NULL;
	gint hardlink_dest_length1 = 0;
	gint _hardlink_dest_size_ = 0;
	gchar** _tmp49_ = NULL;
	gint _tmp49__length1 = 0;
	guint _tmp50_ = 0U;
	gchar** _tmp52_ = NULL;
	gint _tmp52__length1 = 0;
	GError * _inner_error_ = NULL;
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	g_return_if_fail (self != NULL);
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = src_list;
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp0__length1 = src_list_length1;
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = dest_list;
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp1__length1 = dest_list_length1;
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	g_return_if_fail (_tmp0__length1 == _tmp1__length1);
#line 53 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp2_ = src_list;
#line 53 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp2__length1 = src_list_length1;
#line 53 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	if (_tmp2__length1 == 0) {
#line 54 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		return;
#line 585 "archive-reader.c"
	}
#line 57 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	i = (guint) 0;
#line 58 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp3_ = g_new0 (gchar*, 0 + 1);
#line 58 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	hardlink_src = _tmp3_;
#line 58 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	hardlink_src_length1 = 0;
#line 58 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_hardlink_src_size_ = hardlink_src_length1;
#line 59 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp4_ = g_new0 (gchar*, 0 + 1);
#line 59 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	hardlink_dest = _tmp4_;
#line 59 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	hardlink_dest_length1 = 0;
#line 59 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_hardlink_dest_size_ = hardlink_dest_length1;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	while (TRUE) {
#line 607 "archive-reader.c"
		Block10Data* _data10_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		struct archive* _tmp7_ = NULL;
		struct archive_entry* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gchar* dest = NULL;
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		gchar** _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		struct archive_entry* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gboolean _tmp20_ = FALSE;
		struct archive_entry* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		const gchar* _tmp43_ = NULL;
		FILE* _tmp44_ = NULL;
		struct archive* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		guint _tmp48_ = 0U;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_data10_ = g_slice_new0 (Block10Data);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_data10_->_ref_count_ = 1;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_data10_->self = g_object_ref (self);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp7_ = self->archive;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp9_ = boxes_get_next_header (_tmp7_, &_tmp8_, (guint) 1, &_inner_error_);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		iterator = _tmp8_;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp6_ = _tmp9_;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				block10_data_unref (_data10_);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_data10_ = NULL;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				return;
#line 664 "archive-reader.c"
			} else {
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				block10_data_unref (_data10_);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_data10_ = NULL;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_clear_error (&_inner_error_);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				return;
#line 680 "archive-reader.c"
			}
		}
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (_tmp6_) {
#line 685 "archive-reader.c"
			guint _tmp10_ = 0U;
			gchar** _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp10_ = i;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp11_ = src_list;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp11__length1 = src_list_length1;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp5_ = _tmp10_ < ((guint) _tmp11__length1);
#line 697 "archive-reader.c"
		} else {
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp5_ = FALSE;
#line 701 "archive-reader.c"
		}
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (!_tmp5_) {
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			block10_data_unref (_data10_);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_data10_ = NULL;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			break;
#line 711 "archive-reader.c"
		}
#line 62 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp12_ = src_list;
#line 62 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp12__length1 = src_list_length1;
#line 62 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp13_ = dest_list;
#line 62 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp13__length1 = dest_list_length1;
#line 62 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp14_ = iterator;
#line 62 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp15_ = archive_entry_pathname (_tmp14_);
#line 62 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp16_ = boxes_archive_reader_get_dest_file (self, _tmp12_, _tmp12__length1, _tmp13_, _tmp13__length1, _tmp15_);
#line 62 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		dest = _tmp16_;
#line 64 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp17_ = dest;
#line 64 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (_tmp17_ == NULL) {
#line 733 "archive-reader.c"
			struct archive* _tmp18_ = NULL;
			struct archive* _tmp19_ = NULL;
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp18_ = self->archive;
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp19_ = self->archive;
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			boxes_execute_libarchive_function (_tmp18_, _archive_read_data_skip_boxes_libarchive_function, _tmp19_, (guint) 1, &_inner_error_);
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				if (_inner_error_->domain == G_IO_ERROR) {
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					g_propagate_error (error, _inner_error_);
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					_g_free0 (dest);
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					block10_data_unref (_data10_);
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					_data10_ = NULL;
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					return;
#line 760 "archive-reader.c"
				} else {
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					_g_free0 (dest);
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					block10_data_unref (_data10_);
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					_data10_ = NULL;
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					g_clear_error (&_inner_error_);
#line 66 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					return;
#line 778 "archive-reader.c"
				}
			}
#line 68 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_g_free0 (dest);
#line 68 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			block10_data_unref (_data10_);
#line 68 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_data10_ = NULL;
#line 68 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			continue;
#line 789 "archive-reader.c"
		}
#line 71 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp21_ = iterator;
#line 71 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp22_ = archive_entry_hardlink (_tmp21_);
#line 71 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (_tmp22_ != NULL) {
#line 797 "archive-reader.c"
			struct archive_entry* _tmp23_ = NULL;
			gint64 _tmp24_ = 0LL;
#line 71 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp23_ = iterator;
#line 71 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp24_ = archive_entry_size (_tmp23_);
#line 71 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp20_ = _tmp24_ == ((gint64) 0);
#line 806 "archive-reader.c"
		} else {
#line 71 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp20_ = FALSE;
#line 810 "archive-reader.c"
		}
#line 71 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (_tmp20_) {
#line 814 "archive-reader.c"
			struct archive_entry* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			struct archive_entry* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			gchar** _tmp29_ = NULL;
			gint _tmp29__length1 = 0;
			struct archive_entry* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			gchar** _tmp33_ = NULL;
			gint _tmp33__length1 = 0;
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			guint _tmp36_ = 0U;
#line 72 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp25_ = iterator;
#line 72 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp26_ = archive_entry_pathname (_tmp25_);
#line 72 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp27_ = iterator;
#line 72 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp28_ = archive_entry_hardlink (_tmp27_);
#line 72 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_debug ("archive-reader.vala:72: Following hardlink of '%s' to '%s'.", _tmp26_, _tmp28_);
#line 73 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp29_ = hardlink_src;
#line 73 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp29__length1 = hardlink_src_length1;
#line 73 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp30_ = iterator;
#line 73 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp31_ = archive_entry_hardlink (_tmp30_);
#line 73 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp32_ = g_strdup (_tmp31_);
#line 73 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_vala_array_add1 (&hardlink_src, &hardlink_src_length1, &_hardlink_src_size_, _tmp32_);
#line 74 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp33_ = hardlink_dest;
#line 74 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp33__length1 = hardlink_dest_length1;
#line 74 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp34_ = dest;
#line 74 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp35_ = g_strdup (_tmp34_);
#line 74 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_vala_array_add2 (&hardlink_dest, &hardlink_dest_length1, &_hardlink_dest_size_, _tmp35_);
#line 75 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp36_ = i;
#line 75 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			i = _tmp36_ + 1;
#line 77 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_g_free0 (dest);
#line 77 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			block10_data_unref (_data10_);
#line 77 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_data10_ = NULL;
#line 77 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			continue;
#line 873 "archive-reader.c"
		}
#line 80 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp38_ = override_if_necessary;
#line 80 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (!_tmp38_) {
#line 879 "archive-reader.c"
			const gchar* _tmp39_ = NULL;
			gboolean _tmp40_ = FALSE;
#line 80 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp39_ = dest;
#line 80 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp40_ = g_file_test (_tmp39_, G_FILE_TEST_EXISTS);
#line 80 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp37_ = _tmp40_;
#line 888 "archive-reader.c"
		} else {
#line 80 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp37_ = FALSE;
#line 892 "archive-reader.c"
		}
#line 80 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (_tmp37_) {
#line 896 "archive-reader.c"
			const gchar* _tmp41_ = NULL;
			GError* _tmp42_ = NULL;
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp41_ = dest;
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp42_ = g_error_new (G_IO_ERROR, G_IO_ERROR_EXISTS, "Destination file '%s' already exists.", _tmp41_);
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_inner_error_ = _tmp42_;
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_g_free0 (dest);
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				block10_data_unref (_data10_);
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_data10_ = NULL;
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				return;
#line 921 "archive-reader.c"
			} else {
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_g_free0 (dest);
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				block10_data_unref (_data10_);
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_data10_ = NULL;
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_clear_error (&_inner_error_);
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				return;
#line 939 "archive-reader.c"
			}
		}
#line 84 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp43_ = dest;
#line 84 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp44_ = g_fopen (_tmp43_, "w+");
#line 84 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_data10_->fd = _tmp44_;
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp45_ = self->archive;
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		boxes_execute_libarchive_function (_tmp45_, ____lambda85__boxes_libarchive_function, _data10_, (guint) 1, &_inner_error_);
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_g_free0 (dest);
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				block10_data_unref (_data10_);
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_data10_ = NULL;
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				return;
#line 970 "archive-reader.c"
			} else {
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_g_free0 (dest);
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				block10_data_unref (_data10_);
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_data10_ = NULL;
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_clear_error (&_inner_error_);
#line 85 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				return;
#line 988 "archive-reader.c"
			}
		}
#line 87 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp46_ = dest;
#line 87 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp47_ = self->priv->filename;
#line 87 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		g_debug ("archive-reader.vala:87: Extracted file '%s' from archive '%s'.", _tmp46_, _tmp47_);
#line 88 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp48_ = i;
#line 88 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		i = _tmp48_ + 1;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_g_free0 (dest);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		block10_data_unref (_data10_);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_data10_ = NULL;
#line 1007 "archive-reader.c"
	}
#line 91 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp49_ = src_list;
#line 91 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp49__length1 = src_list_length1;
#line 91 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp50_ = i;
#line 91 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	if (((guint) _tmp49__length1) != _tmp50_) {
#line 1017 "archive-reader.c"
		GError* _tmp51_ = NULL;
#line 92 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp51_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "At least one specified file was not found in the archive.");
#line 92 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_inner_error_ = _tmp51_;
#line 92 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 92 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 92 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 92 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 92 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			return;
#line 1033 "archive-reader.c"
		} else {
#line 92 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 92 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 92 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 92 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_clear_error (&_inner_error_);
#line 92 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			return;
#line 1045 "archive-reader.c"
		}
	}
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	boxes_archive_reader_reset (self, &_inner_error_);
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			return;
#line 1062 "archive-reader.c"
		} else {
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_clear_error (&_inner_error_);
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			return;
#line 1074 "archive-reader.c"
		}
	}
#line 96 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp52_ = hardlink_src;
#line 96 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp52__length1 = hardlink_src_length1;
#line 96 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	if (_tmp52__length1 > 0) {
#line 1083 "archive-reader.c"
		gboolean _tmp53_ = FALSE;
#line 97 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp53_ = follow_hardlinks;
#line 97 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (_tmp53_) {
#line 1089 "archive-reader.c"
			gchar** _tmp54_ = NULL;
			gint _tmp54__length1 = 0;
			gchar** _tmp55_ = NULL;
			gint _tmp55__length1 = 0;
			gboolean _tmp56_ = FALSE;
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp54_ = hardlink_src;
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp54__length1 = hardlink_src_length1;
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp55_ = hardlink_dest;
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp55__length1 = hardlink_dest_length1;
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp56_ = override_if_necessary;
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			boxes_archive_reader_extract_files_recursive (self, _tmp54_, _tmp54__length1, _tmp55_, _tmp55__length1, _tmp56_, FALSE, &_inner_error_);
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				if (_inner_error_->domain == G_IO_ERROR) {
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					g_propagate_error (error, _inner_error_);
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					return;
#line 1119 "archive-reader.c"
				} else {
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					g_clear_error (&_inner_error_);
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					return;
#line 1131 "archive-reader.c"
				}
			}
		} else {
			gchar* msg = NULL;
			gchar* _tmp57_ = NULL;
			const gchar* _tmp58_ = NULL;
			GError* _tmp59_ = NULL;
#line 100 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp57_ = g_strdup ("Maximum recursion depth exceeded. It is likely that a hardlink points " \
"to itself.");
#line 100 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			msg = _tmp57_;
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp58_ = msg;
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp59_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_WOULD_RECURSE, _tmp58_);
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_inner_error_ = _tmp59_;
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_g_free0 (msg);
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				return;
#line 1161 "archive-reader.c"
			} else {
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_g_free0 (msg);
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_clear_error (&_inner_error_);
#line 102 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				return;
#line 1175 "archive-reader.c"
			}
#line 97 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_g_free0 (msg);
#line 1179 "archive-reader.c"
		}
	}
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 1186 "archive-reader.c"
}


static gchar* boxes_archive_reader_get_dest_file (BoxesArchiveReader* self, gchar** src_list, int src_list_length1, gchar** dest_list, int dest_list_length1, const gchar* src) {
	gchar* result = NULL;
#line 107 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 107 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 1196 "archive-reader.c"
	{
		guint j = 0U;
#line 108 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		j = (guint) 0;
#line 1201 "archive-reader.c"
		{
			gboolean _tmp0_ = FALSE;
#line 108 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			_tmp0_ = TRUE;
#line 108 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			while (TRUE) {
#line 1208 "archive-reader.c"
				guint _tmp2_ = 0U;
				gchar** _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gchar** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				guint _tmp5_ = 0U;
				const gchar* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
#line 108 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				if (!_tmp0_) {
#line 1219 "archive-reader.c"
					guint _tmp1_ = 0U;
#line 108 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					_tmp1_ = j;
#line 108 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					j = _tmp1_ + 1;
#line 1225 "archive-reader.c"
				}
#line 108 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_tmp0_ = FALSE;
#line 108 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_tmp2_ = j;
#line 108 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_tmp3_ = src_list;
#line 108 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_tmp3__length1 = src_list_length1;
#line 108 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				if (!(_tmp2_ < ((guint) _tmp3__length1))) {
#line 108 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					break;
#line 1239 "archive-reader.c"
				}
#line 109 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_tmp4_ = src_list;
#line 109 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_tmp4__length1 = src_list_length1;
#line 109 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_tmp5_ = j;
#line 109 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_tmp6_ = _tmp4_[_tmp5_];
#line 109 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				_tmp7_ = src;
#line 109 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
#line 1253 "archive-reader.c"
					gchar** _tmp8_ = NULL;
					gint _tmp8__length1 = 0;
					guint _tmp9_ = 0U;
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
#line 110 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					_tmp8_ = dest_list;
#line 110 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					_tmp8__length1 = dest_list_length1;
#line 110 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					_tmp9_ = j;
#line 110 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					_tmp10_ = _tmp8_[_tmp9_];
#line 110 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					_tmp11_ = g_strdup (_tmp10_);
#line 110 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					result = _tmp11_;
#line 110 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					return result;
#line 1273 "archive-reader.c"
				}
			}
		}
	}
#line 113 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	result = NULL;
#line 113 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1282 "archive-reader.c"
}


static int _archive_read_support_format_all_boxes_libarchive_function (gpointer self) {
	int result;
	result = archive_read_support_format_all ((struct archive*) self);
#line 120 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1291 "archive-reader.c"
}


static int ___lambda82_ (BoxesArchiveReader* self) {
	int result = 0;
	struct archive* _tmp0_ = NULL;
	int* _tmp1_ = NULL;
	int _tmp2_ = 0;
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = self->archive;
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = self->priv->format;
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp2_ = archive_read_set_format (_tmp0_, *_tmp1_);
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	result = _tmp2_;
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1310 "archive-reader.c"
}


static int ____lambda82__boxes_libarchive_function (gpointer self) {
	int result;
	result = ___lambda82_ ((BoxesArchiveReader*) self);
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1319 "archive-reader.c"
}


static int _archive_read_support_filter_all_boxes_libarchive_function (gpointer self) {
	int result;
	result = archive_read_support_filter_all ((struct archive*) self);
#line 125 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1328 "archive-reader.c"
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	g_atomic_int_inc (&_data11_->_ref_count_);
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return _data11_;
#line 1337 "archive-reader.c"
}


static void block11_data_unref (void * _userdata_) {
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
#line 1346 "archive-reader.c"
		BoxesArchiveReader* self;
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		self = _data11_->self;
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_g_object_unref0 (self);
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		g_slice_free (Block11Data, _data11_);
#line 1354 "archive-reader.c"
	}
}


static int _____lambda83_ (Block11Data* _data11_) {
	BoxesArchiveReader* self;
	int result = 0;
	struct archive* _tmp0_ = NULL;
	int _tmp1_ = 0;
	int _tmp2_ = 0;
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	self = _data11_->self;
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = self->archive;
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = _data11_->filter;
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp2_ = archive_read_append_filter (_tmp0_, _tmp1_);
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	result = _tmp2_;
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1377 "archive-reader.c"
}


static int ______lambda83__boxes_libarchive_function (gpointer self) {
	int result;
	result = _____lambda83_ (self);
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1386 "archive-reader.c"
}


static int __lambda84_ (BoxesArchiveReader* self) {
	int result = 0;
	struct archive* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	int _tmp2_ = 0;
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = self->archive;
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = self->priv->filename;
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp2_ = archive_read_open_filename (_tmp0_, _tmp1_, (gsize) BOXES_ARCHIVE_READER_BLOCK_SIZE);
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	result = _tmp2_;
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1405 "archive-reader.c"
}


static int ___lambda84__boxes_libarchive_function (gpointer self) {
	int result;
	result = __lambda84_ ((BoxesArchiveReader*) self);
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1414 "archive-reader.c"
}


static void boxes_archive_reader_open_archive (BoxesArchiveReader* self, GError** error) {
	struct archive* _tmp0_ = NULL;
	int* _tmp1_ = NULL;
	GList* _tmp5_ = NULL;
	struct archive* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 116 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	g_return_if_fail (self != NULL);
#line 117 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = archive_read_new ();
#line 117 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_archive_read_finish0 (self->archive);
#line 117 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	self->archive = _tmp0_;
#line 119 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = self->priv->format;
#line 119 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	if (_tmp1_ == NULL) {
#line 1436 "archive-reader.c"
		struct archive* _tmp2_ = NULL;
		struct archive* _tmp3_ = NULL;
#line 120 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp2_ = self->archive;
#line 120 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp3_ = self->archive;
#line 120 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		boxes_execute_libarchive_function (_tmp2_, _archive_read_support_format_all_boxes_libarchive_function, _tmp3_, (guint) 1, &_inner_error_);
#line 120 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 120 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 120 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 120 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				return;
#line 1453 "archive-reader.c"
			} else {
#line 120 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 120 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_clear_error (&_inner_error_);
#line 120 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				return;
#line 1461 "archive-reader.c"
			}
		}
	} else {
		struct archive* _tmp4_ = NULL;
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp4_ = self->archive;
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		boxes_execute_libarchive_function (_tmp4_, ____lambda82__boxes_libarchive_function, self, (guint) 1, &_inner_error_);
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				return;
#line 1478 "archive-reader.c"
			} else {
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_clear_error (&_inner_error_);
#line 122 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				return;
#line 1486 "archive-reader.c"
			}
		}
	}
#line 124 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp5_ = self->priv->filters;
#line 124 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	if (_tmp5_ == NULL) {
#line 1494 "archive-reader.c"
		struct archive* _tmp6_ = NULL;
		struct archive* _tmp7_ = NULL;
#line 125 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp6_ = self->archive;
#line 125 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp7_ = self->archive;
#line 125 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		boxes_execute_libarchive_function (_tmp6_, _archive_read_support_filter_all_boxes_libarchive_function, _tmp7_, (guint) 1, &_inner_error_);
#line 125 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 125 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 125 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 125 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				return;
#line 1511 "archive-reader.c"
			} else {
#line 125 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 125 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				g_clear_error (&_inner_error_);
#line 125 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				return;
#line 1519 "archive-reader.c"
			}
		}
	} else {
		GList* _tmp8_ = NULL;
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		_tmp8_ = self->priv->filters;
#line 1526 "archive-reader.c"
		{
			GList* filter_collection = NULL;
			GList* filter_it = NULL;
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			filter_collection = _tmp8_;
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			for (filter_it = filter_collection; filter_it != NULL; filter_it = filter_it->next) {
#line 1534 "archive-reader.c"
				int filter = 0;
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
				filter = (int) ((gintptr) filter_it->data);
#line 1538 "archive-reader.c"
				{
					Block11Data* _data11_;
					struct archive* _tmp9_ = NULL;
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					_data11_ = g_slice_new0 (Block11Data);
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					_data11_->_ref_count_ = 1;
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					_data11_->self = g_object_ref (self);
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					_data11_->filter = filter;
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					_tmp9_ = self->archive;
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					boxes_execute_libarchive_function (_tmp9_, ______lambda83__boxes_libarchive_function, _data11_, (guint) 1, &_inner_error_);
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
						if (_inner_error_->domain == G_IO_ERROR) {
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
							block11_data_unref (_data11_);
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
							_data11_ = NULL;
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
							return;
#line 1566 "archive-reader.c"
						} else {
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
							block11_data_unref (_data11_);
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
							_data11_ = NULL;
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
							g_clear_error (&_inner_error_);
#line 128 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
							return;
#line 1578 "archive-reader.c"
						}
					}
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					block11_data_unref (_data11_);
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
					_data11_ = NULL;
#line 1585 "archive-reader.c"
				}
			}
		}
	}
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_tmp10_ = self->archive;
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	boxes_execute_libarchive_function (_tmp10_, ___lambda84__boxes_libarchive_function, self, (guint) 1, &_inner_error_);
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			return;
#line 1602 "archive-reader.c"
		} else {
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			g_clear_error (&_inner_error_);
#line 131 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
			return;
#line 1610 "archive-reader.c"
		}
	}
}


static void boxes_archive_reader_class_init (BoxesArchiveReaderClass * klass) {
#line 3 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	boxes_archive_reader_parent_class = g_type_class_peek_parent (klass);
#line 3 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	g_type_class_add_private (klass, sizeof (BoxesArchiveReaderPrivate));
#line 3 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	G_OBJECT_CLASS (klass)->finalize = boxes_archive_reader_finalize;
#line 1623 "archive-reader.c"
}


static void boxes_archive_reader_instance_init (BoxesArchiveReader * self) {
#line 3 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	self->priv = BOXES_ARCHIVE_READER_GET_PRIVATE (self);
#line 1630 "archive-reader.c"
}


static void boxes_archive_reader_finalize (GObject* obj) {
	BoxesArchiveReader * self;
#line 3 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReader);
#line 7 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_archive_read_finish0 (self->archive);
#line 9 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_g_free0 (self->priv->filename);
#line 10 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_g_free0 (self->priv->format);
#line 11 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	_g_list_free0 (self->priv->filters);
#line 3 "/home/zeenix/checkout/gnome/gnome-boxes/src/archive-reader.vala"
	G_OBJECT_CLASS (boxes_archive_reader_parent_class)->finalize (obj);
#line 1648 "archive-reader.c"
}


GType boxes_archive_reader_get_type (void) {
	static volatile gsize boxes_archive_reader_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_archive_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesArchiveReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_archive_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesArchiveReader), 0, (GInstanceInitFunc) boxes_archive_reader_instance_init, NULL };
		GType boxes_archive_reader_type_id;
		boxes_archive_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesArchiveReader", &g_define_type_info, 0);
		g_once_init_leave (&boxes_archive_reader_type_id__volatile, boxes_archive_reader_type_id);
	}
	return boxes_archive_reader_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



