/* unattended-setup-box.c generated by valac 0.39.5, the Vala compiler
 * generated from unattended-setup-box.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libsecret/secret.h>
#include <glib/gi18n-lib.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <libcommon.h>
#include <osinfo/osinfo.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define BOXES_TYPE_UNATTENDED_SETUP_BOX (boxes_unattended_setup_box_get_type ())
#define BOXES_UNATTENDED_SETUP_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UNATTENDED_SETUP_BOX, BoxesUnattendedSetupBox))
#define BOXES_UNATTENDED_SETUP_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_UNATTENDED_SETUP_BOX, BoxesUnattendedSetupBoxClass))
#define BOXES_IS_UNATTENDED_SETUP_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UNATTENDED_SETUP_BOX))
#define BOXES_IS_UNATTENDED_SETUP_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_UNATTENDED_SETUP_BOX))
#define BOXES_UNATTENDED_SETUP_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_UNATTENDED_SETUP_BOX, BoxesUnattendedSetupBoxClass))

typedef struct _BoxesUnattendedSetupBox BoxesUnattendedSetupBox;
typedef struct _BoxesUnattendedSetupBoxClass BoxesUnattendedSetupBoxClass;
typedef struct _BoxesUnattendedSetupBoxPrivate BoxesUnattendedSetupBoxPrivate;
enum  {
	BOXES_UNATTENDED_SETUP_BOX_0_PROPERTY,
	BOXES_UNATTENDED_SETUP_BOX_READY_FOR_EXPRESS_PROPERTY,
	BOXES_UNATTENDED_SETUP_BOX_READY_TO_CREATE_PROPERTY,
	BOXES_UNATTENDED_SETUP_BOX_EXPRESS_INSTALL_PROPERTY,
	BOXES_UNATTENDED_SETUP_BOX_USERNAME_PROPERTY,
	BOXES_UNATTENDED_SETUP_BOX_PASSWORD_PROPERTY,
	BOXES_UNATTENDED_SETUP_BOX_HIDDEN_PASSWORD_PROPERTY,
	BOXES_UNATTENDED_SETUP_BOX_PRODUCT_KEY_PROPERTY,
	BOXES_UNATTENDED_SETUP_BOX_AVATAR_PATH_PROPERTY,
	BOXES_UNATTENDED_SETUP_BOX_NUM_PROPERTIES
};
static GParamSpec* boxes_unattended_setup_box_properties[BOXES_UNATTENDED_SETUP_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))

#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;

#define BOXES_TYPE_VM_CREATOR (boxes_vm_creator_get_type ())
#define BOXES_VM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VM_CREATOR, BoxesVMCreator))
#define BOXES_VM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VM_CREATOR, BoxesVMCreatorClass))
#define BOXES_IS_VM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VM_CREATOR))
#define BOXES_IS_VM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VM_CREATOR))
#define BOXES_VM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VM_CREATOR, BoxesVMCreatorClass))

typedef struct _BoxesVMCreator BoxesVMCreator;
typedef struct _BoxesVMCreatorClass BoxesVMCreatorClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
enum  {
	BOXES_UNATTENDED_SETUP_BOX_USER_WANTS_TO_CREATE_SIGNAL,
	BOXES_UNATTENDED_SETUP_BOX_NUM_SIGNALS
};
static guint boxes_unattended_setup_box_signals[BOXES_UNATTENDED_SETUP_BOX_NUM_SIGNALS] = {0};

struct _BoxesUnattendedSetupBox {
	GtkBox parent_instance;
	BoxesUnattendedSetupBoxPrivate * priv;
};

struct _BoxesUnattendedSetupBoxClass {
	GtkBoxClass parent_class;
};

struct _BoxesUnattendedSetupBoxPrivate {
	GtkInfoBar* needs_internet_bar;
	GtkLabel* needs_internet_label;
	GtkGrid* setup_grid;
	GtkLabel* express_label;
	GtkSwitch* express_toggle;
	GtkImage* user_avatar;
	GtkEntry* username_entry;
	GtkNotebook* password_notebook;
	GtkEntry* password_entry;
	GtkLabel* product_key_label;
	GtkEntry* product_key_entry;
	gchar* product_key_format;
	gchar* media_path;
	GCancellable* cancellable;
	GKeyFile* keyfile;
	SecretSchema* secret_password_schema;
	gboolean we_inserted_text;
};

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoResources* resources;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
	void (*set_direct_boot_params) (BoxesInstallerMedia* self, GVirConfigDomainOs* os);
	void (*prepare) (BoxesInstallerMedia* self, BoxesActivityProgress* progress, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*prepare_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_);
	void (*prepare_for_installation) (BoxesInstallerMedia* self, const gchar* vm_name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_for_installation_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_);
	void (*prepare_to_continue_installation) (BoxesInstallerMedia* self, const gchar* vm_name);
	void (*clean_up) (BoxesInstallerMedia* self);
	void (*clean_up_preparation_cache) (BoxesInstallerMedia* self);
	void (*setup_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	void (*setup_post_install_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	void (*populate_setup_box) (BoxesInstallerMedia* self, GtkBox* setup_box);
	GList* (*get_vm_properties) (BoxesInstallerMedia* self);
	BoxesVMCreator* (*get_vm_creator) (BoxesInstallerMedia* self);
	OsinfoDeviceList* (*get_supported_devices) (BoxesInstallerMedia* self);
	guint64 (*get_installed_size) (BoxesInstallerMedia* self);
	gboolean (*get_need_user_input_for_vm_creation) (BoxesInstallerMedia* self);
	gboolean (*get_ready_to_create) (BoxesInstallerMedia* self);
	gboolean (*get_live) (BoxesInstallerMedia* self);
	gchar* (*get_architecture) (BoxesInstallerMedia* self);
};


static gpointer boxes_unattended_setup_box_parent_class = NULL;

GType boxes_unattended_setup_box_get_type (void) G_GNUC_CONST;
#define BOXES_UNATTENDED_SETUP_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_UNATTENDED_SETUP_BOX, BoxesUnattendedSetupBoxPrivate))
#define BOXES_UNATTENDED_SETUP_BOX_KEY_FILE "setup-data.conf"
#define BOXES_UNATTENDED_SETUP_BOX_EXPRESS_KEY "express-install"
#define BOXES_UNATTENDED_SETUP_BOX_USERNAME_KEY "username"
#define BOXES_UNATTENDED_SETUP_BOX_PASSWORD_KEY "password"
#define BOXES_UNATTENDED_SETUP_BOX_PRODUCTKEY_KEY "product-key"
GType boxes_installer_media_get_type (void) G_GNUC_CONST;
BoxesUnattendedSetupBox* boxes_unattended_setup_box_new (BoxesInstallerMedia* media,
                                                         const gchar* product_key_format,
                                                         gboolean needs_internet);
BoxesUnattendedSetupBox* boxes_unattended_setup_box_construct (GType object_type,
                                                               BoxesInstallerMedia* media,
                                                               const gchar* product_key_format,
                                                               gboolean needs_internet);
gpointer boxes_vm_creator_ref (gpointer instance);
void boxes_vm_creator_unref (gpointer instance);
GParamSpec* boxes_param_spec_vm_creator (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void boxes_value_set_vm_creator (GValue* value,
                                 gpointer v_object);
void boxes_value_take_vm_creator (GValue* value,
                                  gpointer v_object);
gpointer boxes_value_get_vm_creator (const GValue* value);
GType boxes_vm_creator_get_type (void) G_GNUC_CONST;
static void boxes_unattended_setup_box_set_entry_text_from_key (BoxesUnattendedSetupBox* self,
                                                         GtkEntry* entry,
                                                         const gchar* key,
                                                         const gchar* default_value);
gchar* boxes_unattended_setup_box_get_password (BoxesUnattendedSetupBox* self);
static void ____lambda25_ (BoxesUnattendedSetupBox* self,
                    GObject* obj,
                    GAsyncResult* res);
static void _____lambda25__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void boxes_unattended_setup_box_setup_express_toggle (BoxesUnattendedSetupBox* self,
                                                      gboolean live,
                                                      gboolean needs_internet);
static void boxes_unattended_setup_box_real_dispose (GObject* base);
void boxes_unattended_setup_box_clean_up (BoxesUnattendedSetupBox* self);
static void boxes_unattended_setup_box_update_express_toggle (BoxesUnattendedSetupBox* self,
                                                       gboolean network_available);
static void _boxes_unattended_setup_box_update_express_toggle_g_network_monitor_network_changed (GNetworkMonitor* _sender,
                                                                                          gboolean network_available,
                                                                                          gpointer self);
void boxes_unattended_setup_box_save_settings (BoxesUnattendedSetupBox* self);
gboolean boxes_unattended_setup_box_get_express_install (BoxesUnattendedSetupBox* self);
const gchar* boxes_unattended_setup_box_get_username (BoxesUnattendedSetupBox* self);
gchar* boxes_unattended_setup_box_get_product_key (BoxesUnattendedSetupBox* self);
static void ___lambda26_ (BoxesUnattendedSetupBox* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda26__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void boxes_unattended_setup_box_on_mandatory_input_changed (BoxesUnattendedSetupBox* self);
static void _boxes_unattended_setup_box_on_mandatory_input_changed_g_object_notify (GObject* _sender,
                                                                             GParamSpec* pspec,
                                                                             gpointer self);
static void boxes_unattended_setup_box_on_username_entry_activated (BoxesUnattendedSetupBox* self);
gboolean boxes_unattended_setup_box_get_ready_for_express (BoxesUnattendedSetupBox* self);
static void _boxes_unattended_setup_box_on_username_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                                 gpointer self);
static void boxes_unattended_setup_box_on_password_button_clicked (BoxesUnattendedSetupBox* self);
static void _boxes_unattended_setup_box_on_password_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                gpointer self);
static void boxes_unattended_setup_box_on_password_entry_changed (BoxesUnattendedSetupBox* self);
static void _boxes_unattended_setup_box_on_password_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                                 gpointer self);
static gboolean boxes_unattended_setup_box_on_password_entry_focus_out (BoxesUnattendedSetupBox* self);
static gboolean _boxes_unattended_setup_box_on_password_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                             GdkEventFocus* event,
                                                                                             gpointer self);
static void boxes_unattended_setup_box_on_password_entry_activated (BoxesUnattendedSetupBox* self);
static void _boxes_unattended_setup_box_on_password_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                                 gpointer self);
static void boxes_unattended_setup_box_on_key_entry_activated (BoxesUnattendedSetupBox* self);
static void _boxes_unattended_setup_box_on_key_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                            gpointer self);
static void boxes_unattended_setup_box_on_key_text_inserted (BoxesUnattendedSetupBox* self,
                                                      const gchar* text,
                                                      gint text_length,
                                                      gint* position);
static void _boxes_unattended_setup_box_on_key_text_inserted_gtk_editable_insert_text (GtkEditable* _sender,
                                                                                const gchar* new_text,
                                                                                gint new_text_length,
                                                                                gint* position,
                                                                                gpointer self);
gboolean boxes_unattended_setup_box_get_ready_to_create (BoxesUnattendedSetupBox* self);
void boxes_unattended_setup_box_set_express_install (BoxesUnattendedSetupBox* self,
                                                     gboolean value);
gchar* boxes_unattended_setup_box_get_hidden_password (BoxesUnattendedSetupBox* self);
void boxes_unattended_setup_box_set_avatar_path (BoxesUnattendedSetupBox* self,
                                                 const gchar* value);
static void boxes_unattended_setup_box_finalize (GObject * obj);
static void _vala_boxes_unattended_setup_box_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_boxes_unattended_setup_box_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);


static void
____lambda25_ (BoxesUnattendedSetupBox* self,
               GObject* obj,
               GAsyncResult* res)
{
	GError * _inner_error_ = NULL;
#line 127 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (res != NULL);
#line 264 "unattended-setup-box.c"
	{
		gchar* credentials_str = NULL;
		gchar* _tmp0_;
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_;
#line 129 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp0_ = secret_password_lookup_finish (res, &_inner_error_);
#line 129 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		credentials_str = _tmp0_;
#line 129 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 129 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
#line 278 "unattended-setup-box.c"
				goto __catch90_g_io_error_cancelled;
			}
			goto __catch90_g_error;
		}
#line 130 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp2_ = credentials_str;
#line 130 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (_tmp2_ == NULL) {
#line 130 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp1_ = TRUE;
#line 289 "unattended-setup-box.c"
		} else {
			const gchar* _tmp3_;
#line 130 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp3_ = credentials_str;
#line 130 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
#line 296 "unattended-setup-box.c"
		}
#line 130 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (_tmp1_) {
#line 131 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_g_free0 (credentials_str);
#line 131 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			return;
#line 304 "unattended-setup-box.c"
		}
		{
			GVariant* credentials_variant = NULL;
			const gchar* _tmp4_;
			GVariant* _tmp5_;
			gchar* password_str = NULL;
			GVariant* _tmp6_;
			gboolean _tmp8_ = FALSE;
			const gchar* _tmp9_;
#line 134 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp4_ = credentials_str;
#line 134 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp5_ = g_variant_parse (NULL, _tmp4_, NULL, NULL, &_inner_error_);
#line 134 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			credentials_variant = _tmp5_;
#line 134 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 322 "unattended-setup-box.c"
				goto __catch91_g_error;
			}
#line 136 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp6_ = credentials_variant;
#line 136 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			if (!g_variant_lookup (_tmp6_, "password", "s", &password_str, NULL)) {
#line 329 "unattended-setup-box.c"
				GError* _tmp7_;
#line 137 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp7_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, "couldn't unpack a string for the 'password' key");
#line 137 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_inner_error_ = _tmp7_;
#line 137 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_g_free0 (password_str);
#line 137 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_g_variant_unref0 (credentials_variant);
#line 339 "unattended-setup-box.c"
				goto __catch91_g_error;
			}
#line 139 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp9_ = password_str;
#line 139 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			if (_tmp9_ != NULL) {
#line 346 "unattended-setup-box.c"
				const gchar* _tmp10_;
#line 139 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp10_ = password_str;
#line 139 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp8_ = g_strcmp0 (_tmp10_, "") != 0;
#line 352 "unattended-setup-box.c"
			} else {
#line 139 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp8_ = FALSE;
#line 356 "unattended-setup-box.c"
			}
#line 139 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			if (_tmp8_) {
#line 360 "unattended-setup-box.c"
				GtkEntry* _tmp11_;
				const gchar* _tmp12_;
				GtkNotebook* _tmp13_;
#line 140 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp11_ = self->priv->password_entry;
#line 140 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp12_ = password_str;
#line 140 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				gtk_entry_set_text (_tmp11_, _tmp12_);
#line 141 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp13_ = self->priv->password_notebook;
#line 141 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				gtk_notebook_next_page (_tmp13_);
#line 374 "unattended-setup-box.c"
			}
#line 133 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_g_free0 (password_str);
#line 133 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_g_variant_unref0 (credentials_variant);
#line 380 "unattended-setup-box.c"
		}
		goto __finally91;
		__catch91_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp14_;
			const gchar* _tmp15_;
#line 133 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_error_ = _inner_error_;
#line 133 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_inner_error_ = NULL;
#line 144 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp14_ = _error_;
#line 144 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp15_ = _tmp14_->message;
#line 144 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			g_warning ("unattended-setup-box.vala:144: Failed to parse password from the keyri" \
"ng: %s", _tmp15_);
#line 133 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_g_error_free0 (_error_);
#line 400 "unattended-setup-box.c"
		}
		__finally91:
#line 133 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 133 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_g_free0 (credentials_str);
#line 133 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
#line 409 "unattended-setup-box.c"
				goto __catch90_g_io_error_cancelled;
			}
			goto __catch90_g_error;
		}
#line 128 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_free0 (credentials_str);
#line 416 "unattended-setup-box.c"
	}
	goto __finally90;
	__catch90_g_io_error_cancelled:
	{
		GError* _error_ = NULL;
#line 128 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_error_ = _inner_error_;
#line 128 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_inner_error_ = NULL;
#line 147 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_error_free0 (_error_);
#line 147 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		return;
#line 430 "unattended-setup-box.c"
	}
	goto __finally90;
	__catch90_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
#line 128 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_error_ = _inner_error_;
#line 128 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_inner_error_ = NULL;
#line 149 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp16_ = self->priv->media_path;
#line 149 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp17_ = _error_;
#line 149 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp18_ = _tmp17_->message;
#line 149 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_warning ("unattended-setup-box.vala:149: Failed to lookup password for '%s' from" \
" the keyring: %s", _tmp16_, _tmp18_);
#line 128 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_error_free0 (_error_);
#line 453 "unattended-setup-box.c"
	}
	__finally90:
#line 128 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 128 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 128 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_clear_error (&_inner_error_);
#line 128 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		return;
#line 464 "unattended-setup-box.c"
	}
}


static void
_____lambda25__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
#line 127 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	____lambda25_ ((BoxesUnattendedSetupBox*) self, source_object, res);
#line 127 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_object_unref (self);
#line 478 "unattended-setup-box.c"
}


BoxesUnattendedSetupBox*
boxes_unattended_setup_box_construct (GType object_type,
                                      BoxesInstallerMedia* media,
                                      const gchar* product_key_format,
                                      gboolean needs_internet)
{
	BoxesUnattendedSetupBox * self = NULL;
	gchar* _tmp0_;
	gchar* msg = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GtkLabel* _tmp3_;
	const gchar* _tmp4_;
	GtkInfoBar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GKeyFile* _tmp8_;
	OsinfoMedia* _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	GtkGrid* _tmp42_;
	GList* _tmp43_;
	GError * _inner_error_ = NULL;
#line 107 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_val_if_fail (media != NULL, NULL);
#line 107 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	self = (BoxesUnattendedSetupBox*) g_object_new (object_type, NULL);
#line 108 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = g_strdup (product_key_format);
#line 108 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_free0 (self->priv->product_key_format);
#line 108 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	self->priv->product_key_format = _tmp0_;
#line 110 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = media->label;
#line 110 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp2_ = g_strdup_printf (_ ("Express installation of %s requires an internet connection."), _tmp1_);
#line 110 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	msg = _tmp2_;
#line 111 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp3_ = self->priv->needs_internet_label;
#line 111 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp4_ = msg;
#line 111 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_label_set_label (_tmp3_, _tmp4_);
#line 112 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp5_ = self->priv->needs_internet_bar;
#line 112 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, needs_internet);
#line 113 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp6_ = media->device_file;
#line 113 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 113 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_free0 (self->priv->media_path);
#line 113 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	self->priv->media_path = _tmp7_;
#line 114 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp8_ = g_key_file_new ();
#line 114 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_key_file_unref0 (self->priv->keyfile);
#line 114 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	self->priv->keyfile = _tmp8_;
#line 545 "unattended-setup-box.c"
	{
		gchar* filename = NULL;
		gchar* _tmp9_;
		GKeyFile* _tmp10_;
		const gchar* _tmp11_;
		GtkEntry* _tmp12_;
		const gchar* _tmp13_;
		GtkEntry* _tmp14_;
		GtkEntry* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gboolean _tmp19_;
#line 117 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp9_ = boxes_get_user_unattended (BOXES_UNATTENDED_SETUP_BOX_KEY_FILE);
#line 117 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		filename = _tmp9_;
#line 118 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp10_ = self->priv->keyfile;
#line 118 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp11_ = filename;
#line 118 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_key_file_load_from_file (_tmp10_, _tmp11_, G_KEY_FILE_KEEP_COMMENTS, &_inner_error_);
#line 118 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 118 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_g_free0 (filename);
#line 573 "unattended-setup-box.c"
			goto __catch89_g_error;
		}
#line 120 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp12_ = self->priv->username_entry;
#line 120 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp13_ = g_get_user_name ();
#line 120 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		boxes_unattended_setup_box_set_entry_text_from_key (self, _tmp12_, BOXES_UNATTENDED_SETUP_BOX_USERNAME_KEY, _tmp13_);
#line 121 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp14_ = self->priv->password_entry;
#line 121 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		boxes_unattended_setup_box_set_entry_text_from_key (self, _tmp14_, BOXES_UNATTENDED_SETUP_BOX_PASSWORD_KEY, NULL);
#line 122 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp15_ = self->priv->product_key_entry;
#line 122 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		boxes_unattended_setup_box_set_entry_text_from_key (self, _tmp15_, BOXES_UNATTENDED_SETUP_BOX_PRODUCTKEY_KEY, NULL);
#line 124 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp16_ = boxes_unattended_setup_box_get_password (self);
#line 124 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp17_ = _tmp16_;
#line 124 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp18_ = _tmp17_;
#line 124 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp19_ = g_strcmp0 (_tmp18_, "") != 0;
#line 124 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_free0 (_tmp18_);
#line 124 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (_tmp19_) {
#line 602 "unattended-setup-box.c"
			GtkNotebook* _tmp20_;
#line 125 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp20_ = self->priv->password_notebook;
#line 125 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			gtk_notebook_next_page (_tmp20_);
#line 608 "unattended-setup-box.c"
		} else {
			SecretSchema* _tmp21_;
			GCancellable* _tmp22_;
			const gchar* _tmp23_;
#line 127 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp21_ = self->priv->secret_password_schema;
#line 127 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp22_ = self->priv->cancellable;
#line 127 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp23_ = self->priv->media_path;
#line 127 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			secret_password_lookup (_tmp21_, _tmp22_, _____lambda25__gasync_ready_callback, g_object_ref (self), "gnome-boxes-media-path", _tmp23_, NULL);
#line 621 "unattended-setup-box.c"
		}
		{
			GKeyFile* _tmp24_;
			const gchar* _tmp25_;
#line 157 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp24_ = self->priv->keyfile;
#line 157 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp25_ = self->priv->media_path;
#line 157 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			g_key_file_remove_key (_tmp24_, _tmp25_, BOXES_UNATTENDED_SETUP_BOX_PASSWORD_KEY, &_inner_error_);
#line 157 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 634 "unattended-setup-box.c"
				goto __catch92_g_error;
			}
		}
		goto __finally92;
		__catch92_g_error:
		{
			GError* _error_ = NULL;
			const gchar* _tmp26_;
			GError* _tmp27_;
			const gchar* _tmp28_;
#line 156 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_error_ = _inner_error_;
#line 156 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_inner_error_ = NULL;
#line 159 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp26_ = self->priv->media_path;
#line 159 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp27_ = _error_;
#line 159 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp28_ = _tmp27_->message;
#line 159 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			g_debug ("unattended-setup-box.vala:159: Failed to remove key '%s' under '%s': %" \
"s", BOXES_UNATTENDED_SETUP_BOX_PASSWORD_KEY, _tmp26_, _tmp28_);
#line 156 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_g_error_free0 (_error_);
#line 659 "unattended-setup-box.c"
		}
		__finally92:
#line 156 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 156 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_g_free0 (filename);
#line 666 "unattended-setup-box.c"
			goto __catch89_g_error;
		}
#line 116 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_free0 (filename);
#line 671 "unattended-setup-box.c"
	}
	goto __finally89;
	__catch89_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
#line 116 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_error_ = _inner_error_;
#line 116 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_inner_error_ = NULL;
#line 162 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp29_ = _error_;
#line 162 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp30_ = _tmp29_->message;
#line 162 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_debug ("unattended-setup-box.vala:162: %s either doesn't already exist or we f" \
"ailed to load it: %s", BOXES_UNATTENDED_SETUP_BOX_KEY_FILE, _tmp30_);
#line 116 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_error_free0 (_error_);
#line 691 "unattended-setup-box.c"
	}
	__finally89:
#line 116 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 116 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_free0 (msg);
#line 116 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 116 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_clear_error (&_inner_error_);
#line 116 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		return NULL;
#line 704 "unattended-setup-box.c"
	}
#line 164 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp31_ = media->os_media;
#line 164 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_object_get (_tmp31_, "live", &_tmp32_, NULL);
#line 164 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp33_ = _tmp32_;
#line 164 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	boxes_unattended_setup_box_setup_express_toggle (self, _tmp33_, needs_internet);
#line 166 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (product_key_format != NULL) {
#line 716 "unattended-setup-box.c"
		GtkLabel* _tmp34_;
		GtkEntry* _tmp35_;
		GtkEntry* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		GtkEntry* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
#line 167 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp34_ = self->priv->product_key_label;
#line 167 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp34_, TRUE);
#line 169 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp35_ = self->priv->product_key_entry;
#line 169 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp35_, TRUE);
#line 170 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp36_ = self->priv->product_key_entry;
#line 170 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp37_ = strlen (product_key_format);
#line 170 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp38_ = _tmp37_;
#line 170 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		gtk_entry_set_width_chars (_tmp36_, _tmp38_);
#line 171 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp39_ = self->priv->product_key_entry;
#line 171 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp40_ = strlen (product_key_format);
#line 171 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp41_ = _tmp40_;
#line 171 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		gtk_entry_set_max_length (_tmp39_, _tmp41_);
#line 749 "unattended-setup-box.c"
	}
#line 174 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp42_ = self->priv->setup_grid;
#line 174 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp43_ = gtk_container_get_children ((GtkContainer*) _tmp42_);
#line 755 "unattended-setup-box.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 174 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		child_collection = _tmp43_;
#line 174 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 763 "unattended-setup-box.c"
			GtkWidget* child = NULL;
#line 174 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			child = (GtkWidget*) child_it->data;
#line 767 "unattended-setup-box.c"
			{
				gboolean _tmp44_ = FALSE;
				GtkWidget* _tmp45_;
				GtkLabel* _tmp46_;
#line 175 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp45_ = child;
#line 175 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp46_ = self->priv->express_label;
#line 175 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				if (_tmp45_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_widget_get_type (), GtkWidget)) {
#line 778 "unattended-setup-box.c"
					GtkWidget* _tmp47_;
					GtkSwitch* _tmp48_;
#line 175 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp47_ = child;
#line 175 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp48_ = self->priv->express_toggle;
#line 175 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp44_ = _tmp47_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_widget_get_type (), GtkWidget);
#line 787 "unattended-setup-box.c"
				} else {
#line 175 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp44_ = FALSE;
#line 791 "unattended-setup-box.c"
				}
#line 175 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				if (_tmp44_) {
#line 795 "unattended-setup-box.c"
					GtkSwitch* _tmp49_;
					GtkWidget* _tmp50_;
#line 176 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp49_ = self->priv->express_toggle;
#line 176 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp50_ = child;
#line 176 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					g_object_bind_property_with_closures ((GObject*) _tmp49_, "active", (GObject*) _tmp50_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 804 "unattended-setup-box.c"
				}
			}
		}
#line 174 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_list_free0 (child_collection);
#line 810 "unattended-setup-box.c"
	}
#line 107 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_free0 (msg);
#line 107 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	return self;
#line 816 "unattended-setup-box.c"
}


BoxesUnattendedSetupBox*
boxes_unattended_setup_box_new (BoxesInstallerMedia* media,
                                const gchar* product_key_format,
                                gboolean needs_internet)
{
#line 107 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	return boxes_unattended_setup_box_construct (BOXES_TYPE_UNATTENDED_SETUP_BOX, media, product_key_format, needs_internet);
#line 827 "unattended-setup-box.c"
}


static void
boxes_unattended_setup_box_real_dispose (GObject* base)
{
	BoxesUnattendedSetupBox * self;
	GCancellable* _tmp0_;
#line 179 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	self = (BoxesUnattendedSetupBox*) base;
#line 180 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = self->priv->cancellable;
#line 180 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (_tmp0_ != NULL) {
#line 842 "unattended-setup-box.c"
		GCancellable* _tmp1_;
#line 181 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp1_ = self->priv->cancellable;
#line 181 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_cancellable_cancel (_tmp1_);
#line 182 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_object_unref0 (self->priv->cancellable);
#line 182 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		self->priv->cancellable = NULL;
#line 852 "unattended-setup-box.c"
	}
#line 185 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	G_OBJECT_CLASS (boxes_unattended_setup_box_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox));
#line 856 "unattended-setup-box.c"
}


static void
_boxes_unattended_setup_box_update_express_toggle_g_network_monitor_network_changed (GNetworkMonitor* _sender,
                                                                                     gboolean network_available,
                                                                                     gpointer self)
{
#line 189 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	boxes_unattended_setup_box_update_express_toggle ((BoxesUnattendedSetupBox*) self, network_available);
#line 867 "unattended-setup-box.c"
}


void
boxes_unattended_setup_box_clean_up (BoxesUnattendedSetupBox* self)
{
	GNetworkMonitor* _tmp0_;
	guint _tmp1_;
#line 188 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (self != NULL);
#line 189 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = g_network_monitor_get_default ();
#line 189 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_signal_parse_name ("network-changed", g_network_monitor_get_type (), &_tmp1_, NULL, FALSE);
#line 189 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _boxes_unattended_setup_box_update_express_toggle_g_network_monitor_network_changed, self);
#line 884 "unattended-setup-box.c"
}


static void
___lambda26_ (BoxesUnattendedSetupBox* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError * _inner_error_ = NULL;
#line 218 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (res != NULL);
#line 896 "unattended-setup-box.c"
	{
#line 220 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		secret_password_store_finish (res, &_inner_error_);
#line 220 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 902 "unattended-setup-box.c"
			goto __catch94_g_error;
		}
	}
	goto __finally94;
	__catch94_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp0_;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 219 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_error_ = _inner_error_;
#line 219 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_inner_error_ = NULL;
#line 222 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp0_ = self->priv->media_path;
#line 222 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp1_ = _error_;
#line 222 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp2_ = _tmp1_->message;
#line 222 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_warning ("unattended-setup-box.vala:222: Failed to store password for '%s' in th" \
"e keyring: %s", _tmp0_, _tmp2_);
#line 219 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_error_free0 (_error_);
#line 927 "unattended-setup-box.c"
	}
	__finally94:
#line 219 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 219 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 219 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_clear_error (&_inner_error_);
#line 219 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		return;
#line 938 "unattended-setup-box.c"
	}
}


static void
____lambda26__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
#line 213 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	___lambda26_ ((BoxesUnattendedSetupBox*) self, source_object, res);
#line 213 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_object_unref (self);
#line 952 "unattended-setup-box.c"
}


void
boxes_unattended_setup_box_save_settings (BoxesUnattendedSetupBox* self)
{
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GKeyFile* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GKeyFile* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* filename = NULL;
	gchar* _tmp13_;
	gboolean _tmp18_ = FALSE;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	GError * _inner_error_ = NULL;
#line 192 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (self != NULL);
#line 193 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = self->priv->keyfile;
#line 193 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = self->priv->media_path;
#line 193 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp2_ = boxes_unattended_setup_box_get_express_install (self);
#line 193 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp3_ = _tmp2_;
#line 193 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_key_file_set_boolean (_tmp0_, _tmp1_, BOXES_UNATTENDED_SETUP_BOX_EXPRESS_KEY, _tmp3_);
#line 194 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp4_ = self->priv->keyfile;
#line 194 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp5_ = self->priv->media_path;
#line 194 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp6_ = boxes_unattended_setup_box_get_username (self);
#line 194 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp7_ = _tmp6_;
#line 194 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_key_file_set_string (_tmp4_, _tmp5_, BOXES_UNATTENDED_SETUP_BOX_USERNAME_KEY, _tmp7_);
#line 195 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp8_ = self->priv->keyfile;
#line 195 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp9_ = self->priv->media_path;
#line 195 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp10_ = boxes_unattended_setup_box_get_product_key (self);
#line 195 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp11_ = _tmp10_;
#line 195 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp12_ = _tmp11_;
#line 195 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_key_file_set_string (_tmp8_, _tmp9_, BOXES_UNATTENDED_SETUP_BOX_PRODUCTKEY_KEY, _tmp12_);
#line 195 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_free0 (_tmp12_);
#line 197 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp13_ = boxes_get_user_unattended (BOXES_UNATTENDED_SETUP_BOX_KEY_FILE);
#line 197 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	filename = _tmp13_;
#line 1020 "unattended-setup-box.c"
	{
		GKeyFile* _tmp14_;
#line 199 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp14_ = self->priv->keyfile;
#line 199 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_key_file_save_to_file (_tmp14_, filename, &_inner_error_);
#line 199 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1029 "unattended-setup-box.c"
			goto __catch93_g_error;
		}
	}
	goto __finally93;
	__catch93_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
#line 198 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_error_ = _inner_error_;
#line 198 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_inner_error_ = NULL;
#line 201 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp15_ = self->priv->media_path;
#line 201 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp16_ = _error_;
#line 201 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp17_ = _tmp16_->message;
#line 201 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_debug ("unattended-setup-box.vala:201: Error saving settings for '%s': %s", _tmp15_, _tmp17_);
#line 198 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_error_free0 (_error_);
#line 1054 "unattended-setup-box.c"
	}
	__finally93:
#line 198 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 198 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_free0 (filename);
#line 198 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 198 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_clear_error (&_inner_error_);
#line 198 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		return;
#line 1067 "unattended-setup-box.c"
	}
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp19_ = boxes_unattended_setup_box_get_password (self);
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp20_ = _tmp19_;
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp21_ = _tmp20_;
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp22_ = _tmp21_ != NULL;
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_free0 (_tmp21_);
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (_tmp22_) {
#line 1081 "unattended-setup-box.c"
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp23_ = boxes_unattended_setup_box_get_password (self);
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp24_ = _tmp23_;
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp25_ = _tmp24_;
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp18_ = g_strcmp0 (_tmp25_, "") != 0;
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_free0 (_tmp25_);
#line 1095 "unattended-setup-box.c"
	} else {
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp18_ = FALSE;
#line 1099 "unattended-setup-box.c"
	}
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (_tmp18_) {
#line 1103 "unattended-setup-box.c"
		GVariantBuilder* variant_builder = NULL;
		const GVariantType* _tmp26_;
		GVariantBuilder* _tmp27_;
		GVariant* password_variant = NULL;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		GVariant* _tmp31_;
		GVariant* _tmp32_;
		GVariantBuilder* _tmp33_;
		GVariant* _tmp34_;
		GVariant* credentials_variant = NULL;
		GVariantBuilder* _tmp35_;
		GVariant* _tmp36_;
		gchar* credentials_str = NULL;
		GVariant* _tmp37_;
		gchar* _tmp38_;
		gchar* label = NULL;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		SecretSchema* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
#line 205 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp26_ = G_VARIANT_TYPE_VARDICT;
#line 205 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp27_ = g_variant_builder_new (_tmp26_);
#line 205 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		variant_builder = _tmp27_;
#line 206 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp28_ = boxes_unattended_setup_box_get_password (self);
#line 206 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp29_ = _tmp28_;
#line 206 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp30_ = _tmp29_;
#line 206 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp31_ = g_variant_new ("s", _tmp30_, NULL);
#line 206 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_variant_ref_sink (_tmp31_);
#line 206 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp32_ = _tmp31_;
#line 206 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_free0 (_tmp30_);
#line 206 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		password_variant = _tmp32_;
#line 207 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp33_ = variant_builder;
#line 207 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp34_ = password_variant;
#line 207 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_variant_builder_add (_tmp33_, "{sv}", "password", _tmp34_, NULL);
#line 209 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp35_ = variant_builder;
#line 209 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp36_ = g_variant_builder_end (_tmp35_);
#line 209 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_variant_ref_sink (_tmp36_);
#line 209 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		credentials_variant = _tmp36_;
#line 210 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp37_ = credentials_variant;
#line 210 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp38_ = g_variant_print (_tmp37_, TRUE);
#line 210 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		credentials_str = _tmp38_;
#line 212 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp39_ = self->priv->media_path;
#line 212 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp40_ = g_strdup_printf (_ ("GNOME Boxes credentials for “%s”"), _tmp39_);
#line 212 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		label = _tmp40_;
#line 213 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp41_ = self->priv->secret_password_schema;
#line 213 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp42_ = label;
#line 213 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp43_ = credentials_str;
#line 213 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp44_ = self->priv->media_path;
#line 213 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		secret_password_store (_tmp41_, SECRET_COLLECTION_DEFAULT, _tmp42_, _tmp43_, NULL, ____lambda26__gasync_ready_callback, g_object_ref (self), "gnome-boxes-media-path", _tmp44_, NULL);
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_free0 (label);
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_free0 (credentials_str);
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_variant_unref0 (credentials_variant);
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_variant_unref0 (password_variant);
#line 204 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_variant_builder_unref0 (variant_builder);
#line 1196 "unattended-setup-box.c"
	}
#line 192 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_free0 (filename);
#line 1200 "unattended-setup-box.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 239 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	return self ? g_object_ref (self) : NULL;
#line 1209 "unattended-setup-box.c"
}


static void
boxes_unattended_setup_box_setup_express_toggle (BoxesUnattendedSetupBox* self,
                                                 gboolean live,
                                                 gboolean needs_internet)
{
	GNetworkMonitor* network_monitor = NULL;
	GNetworkMonitor* _tmp8_;
	GNetworkMonitor* _tmp9_;
	GNetworkMonitor* _tmp10_;
	GNetworkMonitor* _tmp11_;
	GError * _inner_error_ = NULL;
#line 228 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (self != NULL);
#line 1226 "unattended-setup-box.c"
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		const gchar* _tmp2_;
		GtkSwitch* _tmp3_;
#line 230 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp1_ = self->priv->keyfile;
#line 230 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp2_ = self->priv->media_path;
#line 230 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp0_ = g_key_file_get_boolean (_tmp1_, _tmp2_, BOXES_UNATTENDED_SETUP_BOX_EXPRESS_KEY, &_inner_error_);
#line 230 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1240 "unattended-setup-box.c"
			goto __catch95_g_error;
		}
#line 230 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp3_ = self->priv->express_toggle;
#line 230 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		gtk_switch_set_active (_tmp3_, _tmp0_);
#line 1247 "unattended-setup-box.c"
	}
	goto __finally95;
	__catch95_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		GtkSwitch* _tmp7_;
#line 229 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_error_ = _inner_error_;
#line 229 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_inner_error_ = NULL;
#line 232 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp4_ = self->priv->media_path;
#line 232 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp5_ = _error_;
#line 232 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp6_ = _tmp5_->message;
#line 232 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_debug ("unattended-setup-box.vala:232: Failed to read key '%s' under '%s': %s\n", BOXES_UNATTENDED_SETUP_BOX_EXPRESS_KEY, _tmp4_, _tmp6_);
#line 233 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp7_ = self->priv->express_toggle;
#line 233 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		gtk_switch_set_active (_tmp7_, !live);
#line 229 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_error_free0 (_error_);
#line 1275 "unattended-setup-box.c"
	}
	__finally95:
#line 229 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 229 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 229 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_clear_error (&_inner_error_);
#line 229 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		return;
#line 1286 "unattended-setup-box.c"
	}
#line 236 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (!needs_internet) {
#line 237 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		return;
#line 1292 "unattended-setup-box.c"
	}
#line 239 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp8_ = g_network_monitor_get_default ();
#line 239 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 239 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	network_monitor = _tmp9_;
#line 240 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp10_ = network_monitor;
#line 240 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	boxes_unattended_setup_box_update_express_toggle (self, g_network_monitor_get_network_available (_tmp10_));
#line 241 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp11_ = network_monitor;
#line 241 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_signal_connect_object (_tmp11_, "network-changed", (GCallback) _boxes_unattended_setup_box_update_express_toggle_g_network_monitor_network_changed, self, 0);
#line 228 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_object_unref0 (network_monitor);
#line 1310 "unattended-setup-box.c"
}


static void
boxes_unattended_setup_box_update_express_toggle (BoxesUnattendedSetupBox* self,
                                                  gboolean network_available)
{
#line 244 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (self != NULL);
#line 245 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (network_available) {
#line 1322 "unattended-setup-box.c"
		GtkSwitch* _tmp0_;
#line 246 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp0_ = self->priv->express_toggle;
#line 246 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
#line 1328 "unattended-setup-box.c"
	} else {
		GtkSwitch* _tmp1_;
		GtkSwitch* _tmp2_;
#line 248 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp1_ = self->priv->express_toggle;
#line 248 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
#line 249 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp2_ = self->priv->express_toggle;
#line 249 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		gtk_switch_set_active (_tmp2_, FALSE);
#line 1340 "unattended-setup-box.c"
	}
}


static void
boxes_unattended_setup_box_set_entry_text_from_key (BoxesUnattendedSetupBox* self,
                                                    GtkEntry* entry,
                                                    const gchar* key,
                                                    const gchar* default_value)
{
	gchar* str = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	GError * _inner_error_ = NULL;
#line 253 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (self != NULL);
#line 253 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (entry != NULL);
#line 253 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (key != NULL);
#line 254 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	str = NULL;
#line 1363 "unattended-setup-box.c"
	{
		gchar* _tmp0_ = NULL;
		GKeyFile* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 256 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp1_ = self->priv->keyfile;
#line 256 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp2_ = self->priv->media_path;
#line 256 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp3_ = g_key_file_get_string (_tmp1_, _tmp2_, key, &_inner_error_);
#line 256 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp0_ = _tmp3_;
#line 256 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1380 "unattended-setup-box.c"
			goto __catch96_g_error;
		}
#line 256 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp4_ = _tmp0_;
#line 256 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp0_ = NULL;
#line 256 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_free0 (str);
#line 256 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		str = _tmp4_;
#line 255 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_free0 (_tmp0_);
#line 1393 "unattended-setup-box.c"
	}
	goto __finally96;
	__catch96_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 255 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_error_ = _inner_error_;
#line 255 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_inner_error_ = NULL;
#line 258 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp5_ = self->priv->media_path;
#line 258 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp6_ = _error_;
#line 258 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp7_ = _tmp6_->message;
#line 258 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_debug ("unattended-setup-box.vala:258: Failed to read key '%s' under '%s': %s\n", key, _tmp5_, _tmp7_);
#line 255 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_error_free0 (_error_);
#line 1416 "unattended-setup-box.c"
	}
	__finally96:
#line 255 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 255 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_free0 (str);
#line 255 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 255 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_clear_error (&_inner_error_);
#line 255 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		return;
#line 1429 "unattended-setup-box.c"
	}
#line 261 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp9_ = str;
#line 261 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (_tmp9_ != NULL) {
#line 1435 "unattended-setup-box.c"
		const gchar* _tmp10_;
#line 261 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp10_ = str;
#line 261 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp8_ = g_strcmp0 (_tmp10_, "") != 0;
#line 1441 "unattended-setup-box.c"
	} else {
#line 261 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp8_ = FALSE;
#line 1445 "unattended-setup-box.c"
	}
#line 261 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (_tmp8_) {
#line 1449 "unattended-setup-box.c"
		const gchar* _tmp11_;
#line 262 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp11_ = str;
#line 262 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		gtk_entry_set_text (entry, _tmp11_);
#line 1455 "unattended-setup-box.c"
	} else {
#line 263 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (default_value != NULL) {
#line 264 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			gtk_entry_set_text (entry, default_value);
#line 1461 "unattended-setup-box.c"
		}
	}
#line 253 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_free0 (str);
#line 1466 "unattended-setup-box.c"
}


static void
boxes_unattended_setup_box_on_mandatory_input_changed (BoxesUnattendedSetupBox* self)
{
#line 268 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (self != NULL);
#line 269 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_object_notify ((GObject*) self, "ready-to-create");
#line 1477 "unattended-setup-box.c"
}


static void
_boxes_unattended_setup_box_on_mandatory_input_changed_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self)
{
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	boxes_unattended_setup_box_on_mandatory_input_changed ((BoxesUnattendedSetupBox*) self);
#line 1488 "unattended-setup-box.c"
}


static void
boxes_unattended_setup_box_on_username_entry_activated (BoxesUnattendedSetupBox* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 273 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (self != NULL);
#line 274 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = boxes_unattended_setup_box_get_ready_for_express (self);
#line 274 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = _tmp0_;
#line 274 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (_tmp1_) {
#line 275 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_signal_emit (self, boxes_unattended_setup_box_signals[BOXES_UNATTENDED_SETUP_BOX_USER_WANTS_TO_CREATE_SIGNAL], 0);
#line 1507 "unattended-setup-box.c"
	} else {
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
#line 276 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp3_ = boxes_unattended_setup_box_get_username (self);
#line 276 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp4_ = _tmp3_;
#line 276 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (g_strcmp0 (_tmp4_, "") != 0) {
#line 1518 "unattended-setup-box.c"
			const gchar* _tmp5_;
#line 276 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp5_ = self->priv->product_key_format;
#line 276 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp2_ = _tmp5_ != NULL;
#line 1524 "unattended-setup-box.c"
		} else {
#line 276 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp2_ = FALSE;
#line 1528 "unattended-setup-box.c"
		}
#line 276 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (_tmp2_) {
#line 1532 "unattended-setup-box.c"
			GtkEntry* _tmp6_;
#line 277 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp6_ = self->priv->product_key_entry;
#line 277 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
#line 1538 "unattended-setup-box.c"
		}
	}
}


static void
_boxes_unattended_setup_box_on_username_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                            gpointer self)
{
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	boxes_unattended_setup_box_on_username_entry_activated ((BoxesUnattendedSetupBox*) self);
#line 1550 "unattended-setup-box.c"
}


static void
boxes_unattended_setup_box_on_password_button_clicked (BoxesUnattendedSetupBox* self)
{
	GtkNotebook* _tmp0_;
	GtkEntry* _tmp1_;
#line 281 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (self != NULL);
#line 282 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = self->priv->password_notebook;
#line 282 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_notebook_next_page (_tmp0_);
#line 283 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = self->priv->password_entry;
#line 283 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
#line 1569 "unattended-setup-box.c"
}


static void
_boxes_unattended_setup_box_on_password_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                           gpointer self)
{
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	boxes_unattended_setup_box_on_password_button_clicked ((BoxesUnattendedSetupBox*) self);
#line 1579 "unattended-setup-box.c"
}


static void
boxes_unattended_setup_box_on_password_entry_changed (BoxesUnattendedSetupBox* self)
{
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 287 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (self != NULL);
#line 288 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = self->priv->cancellable;
#line 288 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_cancellable_cancel (_tmp0_);
#line 289 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = g_cancellable_new ();
#line 289 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 289 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	self->priv->cancellable = _tmp1_;
#line 1600 "unattended-setup-box.c"
}


static void
_boxes_unattended_setup_box_on_password_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                            gpointer self)
{
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	boxes_unattended_setup_box_on_password_entry_changed ((BoxesUnattendedSetupBox*) self);
#line 1610 "unattended-setup-box.c"
}


static gboolean
boxes_unattended_setup_box_on_password_entry_focus_out (BoxesUnattendedSetupBox* self)
{
	gboolean result = FALSE;
	GtkEntry* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
#line 293 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 294 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = self->priv->password_entry;
#line 294 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = gtk_entry_get_text_length (_tmp0_);
#line 294 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp2_ = _tmp1_;
#line 294 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (_tmp2_ == ((guint) 0)) {
#line 1631 "unattended-setup-box.c"
		GtkNotebook* _tmp3_;
#line 295 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp3_ = self->priv->password_notebook;
#line 295 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		gtk_notebook_prev_page (_tmp3_);
#line 1637 "unattended-setup-box.c"
	}
#line 296 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	result = FALSE;
#line 296 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	return result;
#line 1643 "unattended-setup-box.c"
}


static gboolean
_boxes_unattended_setup_box_on_password_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                    GdkEventFocus* event,
                                                                                    gpointer self)
{
	gboolean result;
	result = boxes_unattended_setup_box_on_password_entry_focus_out ((BoxesUnattendedSetupBox*) self);
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	return result;
#line 1656 "unattended-setup-box.c"
}


static void
boxes_unattended_setup_box_on_password_entry_activated (BoxesUnattendedSetupBox* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 300 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (self != NULL);
#line 301 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = boxes_unattended_setup_box_get_ready_for_express (self);
#line 301 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = _tmp0_;
#line 301 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (_tmp1_) {
#line 302 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_signal_emit (self, boxes_unattended_setup_box_signals[BOXES_UNATTENDED_SETUP_BOX_USER_WANTS_TO_CREATE_SIGNAL], 0);
#line 1675 "unattended-setup-box.c"
	} else {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
#line 303 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp2_ = boxes_unattended_setup_box_get_username (self);
#line 303 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp3_ = _tmp2_;
#line 303 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (g_strcmp0 (_tmp3_, "") == 0) {
#line 1685 "unattended-setup-box.c"
			GtkEntry* _tmp4_;
#line 304 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp4_ = self->priv->username_entry;
#line 304 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
#line 1691 "unattended-setup-box.c"
		} else {
			const gchar* _tmp5_;
#line 305 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp5_ = self->priv->product_key_format;
#line 305 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			if (_tmp5_ != NULL) {
#line 1698 "unattended-setup-box.c"
				GtkEntry* _tmp6_;
#line 306 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp6_ = self->priv->product_key_entry;
#line 306 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
#line 1704 "unattended-setup-box.c"
			}
		}
	}
}


static void
_boxes_unattended_setup_box_on_password_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                            gpointer self)
{
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	boxes_unattended_setup_box_on_password_entry_activated ((BoxesUnattendedSetupBox*) self);
#line 1717 "unattended-setup-box.c"
}


static void
boxes_unattended_setup_box_on_key_entry_activated (BoxesUnattendedSetupBox* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 310 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (self != NULL);
#line 311 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = boxes_unattended_setup_box_get_ready_for_express (self);
#line 311 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = _tmp0_;
#line 311 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (_tmp1_) {
#line 312 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_signal_emit (self, boxes_unattended_setup_box_signals[BOXES_UNATTENDED_SETUP_BOX_USER_WANTS_TO_CREATE_SIGNAL], 0);
#line 1736 "unattended-setup-box.c"
	} else {
		GtkEntry* _tmp2_;
		guint _tmp3_;
		guint _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
#line 313 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp2_ = self->priv->product_key_entry;
#line 313 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp3_ = gtk_entry_get_text_length (_tmp2_);
#line 313 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp4_ = _tmp3_;
#line 313 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp5_ = self->priv->product_key_format;
#line 313 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp6_ = strlen (_tmp5_);
#line 313 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp7_ = _tmp6_;
#line 313 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (_tmp4_ == ((guint) _tmp7_)) {
#line 1758 "unattended-setup-box.c"
			GtkEntry* _tmp8_;
#line 314 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp8_ = self->priv->username_entry;
#line 314 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			gtk_widget_grab_focus ((GtkWidget*) _tmp8_);
#line 1764 "unattended-setup-box.c"
		}
	}
}


static void
_boxes_unattended_setup_box_on_key_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                       gpointer self)
{
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	boxes_unattended_setup_box_on_key_entry_activated ((BoxesUnattendedSetupBox*) self);
#line 1776 "unattended-setup-box.c"
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
#line 1124 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1125 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1125 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 1125 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1794 "unattended-setup-box.c"
}


static void
boxes_unattended_setup_box_on_key_text_inserted (BoxesUnattendedSetupBox* self,
                                                 const gchar* text,
                                                 gint text_length,
                                                 gint* position)
{
	gboolean _tmp0_;
	gchar* _result_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp32_;
	GtkEntry* _tmp40_;
#line 320 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (self != NULL);
#line 320 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (text != NULL);
#line 321 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = self->priv->we_inserted_text;
#line 321 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (_tmp0_) {
#line 322 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		return;
#line 1819 "unattended-setup-box.c"
	}
#line 324 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = g_strdup ("");
#line 324 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_result_ = _tmp1_;
#line 1825 "unattended-setup-box.c"
	{
		guint i = 0U;
		guint j = 0U;
#line 326 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		i = (guint) 0;
#line 326 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		j = (guint) (*position);
#line 1833 "unattended-setup-box.c"
		{
			gboolean _tmp2_ = FALSE;
#line 326 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp2_ = TRUE;
#line 326 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			while (TRUE) {
#line 1840 "unattended-setup-box.c"
				gboolean _tmp3_ = FALSE;
				guint _tmp4_;
				gchar character = '\0';
				guint _tmp9_;
				gchar allowed_char = '\0';
				const gchar* _tmp10_;
				guint _tmp11_;
				gboolean skip_input_char = FALSE;
				gchar _tmp12_;
				guint _tmp24_;
				gboolean _tmp25_;
				const gchar* _tmp26_;
				gchar _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				guint _tmp31_;
#line 326 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				if (!_tmp2_) {
#line 1860 "unattended-setup-box.c"
				}
#line 326 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp2_ = FALSE;
#line 326 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp4_ = i;
#line 326 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				if (_tmp4_ < ((guint) text_length)) {
#line 1868 "unattended-setup-box.c"
					guint _tmp5_;
					const gchar* _tmp6_;
					gint _tmp7_;
					gint _tmp8_;
#line 326 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp5_ = j;
#line 326 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp6_ = self->priv->product_key_format;
#line 326 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp7_ = strlen (_tmp6_);
#line 326 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp8_ = _tmp7_;
#line 326 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp3_ = _tmp5_ < ((guint) _tmp8_);
#line 1883 "unattended-setup-box.c"
				} else {
#line 326 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp3_ = FALSE;
#line 1887 "unattended-setup-box.c"
				}
#line 326 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				if (!_tmp3_) {
#line 326 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					break;
#line 1893 "unattended-setup-box.c"
				}
#line 327 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp9_ = i;
#line 327 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				character = string_get (text, (glong) _tmp9_);
#line 328 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp10_ = self->priv->product_key_format;
#line 328 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp11_ = j;
#line 328 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				allowed_char = string_get (_tmp10_, (glong) _tmp11_);
#line 330 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				skip_input_char = FALSE;
#line 331 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp12_ = allowed_char;
#line 331 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				switch (_tmp12_) {
#line 331 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					case '@':
#line 1913 "unattended-setup-box.c"
					{
#line 333 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						break;
#line 1917 "unattended-setup-box.c"
					}
#line 331 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					case '%':
#line 1921 "unattended-setup-box.c"
					{
						gchar _tmp13_;
#line 336 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						_tmp13_ = character;
#line 336 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						if (!g_ascii_isalpha (_tmp13_)) {
#line 337 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
							skip_input_char = TRUE;
#line 1930 "unattended-setup-box.c"
						}
#line 338 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						break;
#line 1934 "unattended-setup-box.c"
					}
#line 331 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					case '#':
#line 1938 "unattended-setup-box.c"
					{
						gchar _tmp14_;
#line 341 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						_tmp14_ = character;
#line 341 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						if (!g_ascii_isdigit (_tmp14_)) {
#line 342 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
							skip_input_char = TRUE;
#line 1947 "unattended-setup-box.c"
						}
#line 343 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						break;
#line 1951 "unattended-setup-box.c"
					}
#line 331 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					case '$':
#line 1955 "unattended-setup-box.c"
					{
						gchar _tmp15_;
#line 346 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						_tmp15_ = character;
#line 346 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						if (!g_ascii_isalnum (_tmp15_)) {
#line 347 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
							skip_input_char = TRUE;
#line 1964 "unattended-setup-box.c"
						}
#line 348 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						break;
#line 1968 "unattended-setup-box.c"
					}
					default:
					{
						gchar _tmp16_;
						gchar _tmp17_;
#line 351 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						_tmp16_ = character;
#line 351 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						_tmp17_ = allowed_char;
#line 351 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						if (_tmp16_ != _tmp17_) {
#line 1980 "unattended-setup-box.c"
							const gchar* _tmp18_;
							gchar _tmp19_;
							gchar* _tmp20_;
							gchar* _tmp21_;
							gchar* _tmp22_;
							guint _tmp23_;
#line 352 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
							_tmp18_ = _result_;
#line 352 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
							_tmp19_ = allowed_char;
#line 352 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
							_tmp20_ = g_strdup_printf ("%c", _tmp19_);
#line 352 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
							_tmp21_ = _tmp20_;
#line 352 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
							_tmp22_ = g_strconcat (_tmp18_, _tmp21_, NULL);
#line 352 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
							_g_free0 (_result_);
#line 352 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
							_result_ = _tmp22_;
#line 352 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
							_g_free0 (_tmp21_);
#line 353 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
							_tmp23_ = j;
#line 353 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
							j = _tmp23_ + 1;
#line 355 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
							continue;
#line 2009 "unattended-setup-box.c"
						}
#line 358 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						break;
#line 2013 "unattended-setup-box.c"
					}
				}
#line 361 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp24_ = i;
#line 361 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				i = _tmp24_ + 1;
#line 362 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp25_ = skip_input_char;
#line 362 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				if (_tmp25_) {
#line 363 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					continue;
#line 2026 "unattended-setup-box.c"
				}
#line 365 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp26_ = _result_;
#line 365 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp27_ = character;
#line 365 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp28_ = g_strdup_printf ("%c", _tmp27_);
#line 365 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp29_ = _tmp28_;
#line 365 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp30_ = g_strconcat (_tmp26_, _tmp29_, NULL);
#line 365 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_g_free0 (_result_);
#line 365 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_result_ = _tmp30_;
#line 365 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_g_free0 (_tmp29_);
#line 366 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp31_ = j;
#line 366 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				j = _tmp31_ + 1;
#line 2048 "unattended-setup-box.c"
			}
		}
	}
#line 369 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp32_ = _result_;
#line 369 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (g_strcmp0 (_tmp32_, "") != 0) {
#line 2056 "unattended-setup-box.c"
		GtkEntry* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		const gchar* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
#line 370 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		self->priv->we_inserted_text = TRUE;
#line 371 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp33_ = self->priv->product_key_entry;
#line 371 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp34_ = _result_;
#line 371 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp35_ = g_utf8_strup (_tmp34_, (gssize) -1);
#line 371 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp36_ = _tmp35_;
#line 371 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp37_ = _result_;
#line 371 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp38_ = strlen (_tmp37_);
#line 371 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp39_ = _tmp38_;
#line 371 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_signal_emit_by_name ((GtkEditable*) _tmp33_, "insert-text", _tmp36_, _tmp39_, position);
#line 371 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_free0 (_tmp36_);
#line 372 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		self->priv->we_inserted_text = FALSE;
#line 2086 "unattended-setup-box.c"
	}
#line 375 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp40_ = self->priv->product_key_entry;
#line 375 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_signal_stop_emission_by_name (_tmp40_, "insert-text");
#line 320 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_free0 (_result_);
#line 2094 "unattended-setup-box.c"
}


static void
_boxes_unattended_setup_box_on_key_text_inserted_gtk_editable_insert_text (GtkEditable* _sender,
                                                                           const gchar* new_text,
                                                                           gint new_text_length,
                                                                           gint* position,
                                                                           gpointer self)
{
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	boxes_unattended_setup_box_on_key_text_inserted ((BoxesUnattendedSetupBox*) self, new_text, new_text_length, position);
#line 2107 "unattended-setup-box.c"
}


gboolean
boxes_unattended_setup_box_get_ready_for_express (BoxesUnattendedSetupBox* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
#line 12 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 13 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = boxes_unattended_setup_box_get_username (self);
#line 13 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp2_ = _tmp1_;
#line 13 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (g_strcmp0 (_tmp2_, "") != 0) {
#line 2126 "unattended-setup-box.c"
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_;
#line 14 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp4_ = self->priv->product_key_format;
#line 14 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (_tmp4_ == NULL) {
#line 14 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp3_ = TRUE;
#line 2135 "unattended-setup-box.c"
		} else {
			GtkEntry* _tmp5_;
			guint _tmp6_;
			guint _tmp7_;
			const gchar* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
#line 15 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp5_ = self->priv->product_key_entry;
#line 15 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp6_ = gtk_entry_get_text_length (_tmp5_);
#line 15 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp7_ = _tmp6_;
#line 15 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp8_ = self->priv->product_key_format;
#line 15 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp9_ = strlen (_tmp8_);
#line 15 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp10_ = _tmp9_;
#line 15 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			_tmp3_ = _tmp7_ == ((guint) _tmp10_);
#line 2157 "unattended-setup-box.c"
		}
#line 14 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp0_ = _tmp3_;
#line 2161 "unattended-setup-box.c"
	} else {
#line 13 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp0_ = FALSE;
#line 2165 "unattended-setup-box.c"
	}
#line 13 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	result = _tmp0_;
#line 13 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	return result;
#line 2171 "unattended-setup-box.c"
}


gboolean
boxes_unattended_setup_box_get_ready_to_create (BoxesUnattendedSetupBox* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
#line 20 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 21 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = self->priv->express_toggle;
#line 21 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp2_ = gtk_switch_get_active (_tmp1_);
#line 21 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp3_ = _tmp2_;
#line 21 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (!_tmp3_) {
#line 21 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp0_ = TRUE;
#line 2195 "unattended-setup-box.c"
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
#line 21 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp4_ = boxes_unattended_setup_box_get_ready_for_express (self);
#line 21 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp5_ = _tmp4_;
#line 21 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp0_ = _tmp5_;
#line 2205 "unattended-setup-box.c"
	}
#line 21 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	result = _tmp0_;
#line 21 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	return result;
#line 2211 "unattended-setup-box.c"
}


gboolean
boxes_unattended_setup_box_get_express_install (BoxesUnattendedSetupBox* self)
{
	gboolean result;
	GtkSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 26 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 27 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = self->priv->express_toggle;
#line 27 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = gtk_switch_get_active (_tmp0_);
#line 27 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp2_ = _tmp1_;
#line 27 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	result = _tmp2_;
#line 27 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	return result;
#line 2234 "unattended-setup-box.c"
}


void
boxes_unattended_setup_box_set_express_install (BoxesUnattendedSetupBox* self,
                                                gboolean value)
{
	GtkSwitch* _tmp0_;
#line 30 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (self != NULL);
#line 31 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = self->priv->express_toggle;
#line 31 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_switch_set_active (_tmp0_, value);
#line 30 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_object_notify_by_pspec ((GObject *) self, boxes_unattended_setup_box_properties[BOXES_UNATTENDED_SETUP_BOX_EXPRESS_INSTALL_PROPERTY]);
#line 2251 "unattended-setup-box.c"
}


const gchar*
boxes_unattended_setup_box_get_username (BoxesUnattendedSetupBox* self)
{
	const gchar* result;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
#line 36 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 36 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = self->priv->username_entry;
#line 36 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 36 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp2_ = _tmp1_;
#line 36 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	result = _tmp2_;
#line 36 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	return result;
#line 2274 "unattended-setup-box.c"
}


gchar*
boxes_unattended_setup_box_get_password (BoxesUnattendedSetupBox* self)
{
	gchar* result;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
#line 40 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = self->priv->password_entry;
#line 40 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 40 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp2_ = _tmp1_;
#line 40 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 40 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	result = _tmp3_;
#line 40 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	return result;
#line 2300 "unattended-setup-box.c"
}


static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 963 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 963 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 964 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = str;
#line 964 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	g_unichar_to_utf8 (self, _tmp1_);
#line 965 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	result = str;
#line 965 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 2323 "unattended-setup-box.c"
}


gchar*
boxes_unattended_setup_box_get_hidden_password (BoxesUnattendedSetupBox* self)
{
	gchar* result;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
#line 44 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = self->priv->password_entry;
#line 45 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 45 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp2_ = _tmp1_;
#line 45 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp3_ = strlen (_tmp2_);
#line 45 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp4_ = _tmp3_;
#line 45 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (_tmp4_ > 0) {
#line 2350 "unattended-setup-box.c"
		gchar* str = NULL;
		gchar* _tmp5_;
#line 46 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp5_ = g_strdup ("");
#line 46 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		str = _tmp5_;
#line 2357 "unattended-setup-box.c"
		{
			gint i = 0;
#line 47 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
			i = 0;
#line 2362 "unattended-setup-box.c"
			{
				gboolean _tmp6_ = FALSE;
#line 47 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				_tmp6_ = TRUE;
#line 47 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
				while (TRUE) {
#line 2369 "unattended-setup-box.c"
					gint _tmp8_;
					GtkEntry* _tmp9_;
					guint _tmp10_;
					guint _tmp11_;
					const gchar* _tmp12_;
					GtkEntry* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
#line 47 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					if (!_tmp6_) {
#line 2381 "unattended-setup-box.c"
						gint _tmp7_;
#line 47 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						_tmp7_ = i;
#line 47 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						i = _tmp7_ + 1;
#line 2387 "unattended-setup-box.c"
					}
#line 47 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp6_ = FALSE;
#line 47 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp8_ = i;
#line 47 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp9_ = self->priv->password_entry;
#line 47 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp10_ = gtk_entry_get_text_length (_tmp9_);
#line 47 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp11_ = _tmp10_;
#line 47 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					if (!(((guint) _tmp8_) < _tmp11_)) {
#line 47 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
						break;
#line 2403 "unattended-setup-box.c"
					}
#line 48 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp12_ = str;
#line 48 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp13_ = self->priv->password_entry;
#line 48 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp14_ = g_unichar_to_string (gtk_entry_get_invisible_char (_tmp13_));
#line 48 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp15_ = _tmp14_;
#line 48 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_tmp16_ = g_strconcat (_tmp12_, _tmp15_, NULL);
#line 48 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_g_free0 (str);
#line 48 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					str = _tmp16_;
#line 48 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
					_g_free0 (_tmp15_);
#line 2421 "unattended-setup-box.c"
				}
			}
		}
#line 50 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		result = str;
#line 50 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		return result;
#line 2429 "unattended-setup-box.c"
	} else {
		gchar* _tmp17_;
#line 52 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp17_ = g_strdup (_ ("no password"));
#line 52 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		result = _tmp17_;
#line 52 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		return result;
#line 2438 "unattended-setup-box.c"
	}
}


gchar*
boxes_unattended_setup_box_get_product_key (BoxesUnattendedSetupBox* self)
{
	gchar* result;
	const gchar* _tmp0_ = NULL;
	GtkEntry* _tmp1_;
	gchar* _tmp5_;
#line 57 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 58 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = self->priv->product_key_entry;
#line 58 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (_tmp1_ != NULL) {
#line 2456 "unattended-setup-box.c"
		GtkEntry* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
#line 58 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp2_ = self->priv->product_key_entry;
#line 58 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp3_ = gtk_entry_get_text (_tmp2_);
#line 58 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp4_ = _tmp3_;
#line 58 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp0_ = _tmp4_;
#line 2468 "unattended-setup-box.c"
	} else {
#line 58 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp0_ = NULL;
#line 2472 "unattended-setup-box.c"
	}
#line 58 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp5_ = g_strdup (_tmp0_);
#line 58 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	result = _tmp5_;
#line 58 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	return result;
#line 2480 "unattended-setup-box.c"
}


void
boxes_unattended_setup_box_set_avatar_path (BoxesUnattendedSetupBox* self,
                                            const gchar* value)
{
	GError * _inner_error_ = NULL;
#line 63 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_return_if_fail (self != NULL);
#line 2491 "unattended-setup-box.c"
	{
		GdkPixbuf* pixbuf = NULL;
		GdkPixbuf* _tmp0_;
		GtkImage* _tmp1_;
#line 65 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp0_ = gdk_pixbuf_new_from_file_at_scale (value, 64, 64, TRUE, &_inner_error_);
#line 65 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		pixbuf = _tmp0_;
#line 65 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2502 "unattended-setup-box.c"
			goto __catch97_g_error;
		}
#line 66 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp1_ = self->priv->user_avatar;
#line 66 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_object_set (_tmp1_, "pixbuf", pixbuf, NULL);
#line 64 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_object_unref0 (pixbuf);
#line 2511 "unattended-setup-box.c"
	}
	goto __finally97;
	__catch97_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 64 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_error_ = _inner_error_;
#line 64 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_inner_error_ = NULL;
#line 68 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp2_ = _error_;
#line 68 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_tmp3_ = _tmp2_->message;
#line 68 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_debug ("unattended-setup-box.vala:68: Failed to load user avatar file '%s': %s", value, _tmp3_);
#line 64 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		_g_error_free0 (_error_);
#line 2531 "unattended-setup-box.c"
	}
	__finally97:
#line 64 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 64 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 64 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_clear_error (&_inner_error_);
#line 64 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		return;
#line 2542 "unattended-setup-box.c"
	}
#line 63 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_object_notify_by_pspec ((GObject *) self, boxes_unattended_setup_box_properties[BOXES_UNATTENDED_SETUP_BOX_AVATAR_PATH_PROPERTY]);
#line 2546 "unattended-setup-box.c"
}


static void
boxes_unattended_setup_box_class_init (BoxesUnattendedSetupBoxClass * klass)
{
	gint BoxesUnattendedSetupBox_private_offset;
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	boxes_unattended_setup_box_parent_class = g_type_class_peek_parent (klass);
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_type_class_add_private (klass, sizeof (BoxesUnattendedSetupBoxPrivate));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	((GObjectClass *) klass)->dispose = (void (*) (GObject *)) boxes_unattended_setup_box_real_dispose;
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_unattended_setup_box_get_property;
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_unattended_setup_box_set_property;
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	G_OBJECT_CLASS (klass)->finalize = boxes_unattended_setup_box_finalize;
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_UNATTENDED_SETUP_BOX_READY_FOR_EXPRESS_PROPERTY, boxes_unattended_setup_box_properties[BOXES_UNATTENDED_SETUP_BOX_READY_FOR_EXPRESS_PROPERTY] = g_param_spec_boolean ("ready-for-express", "ready-for-express", "ready-for-express", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_UNATTENDED_SETUP_BOX_READY_TO_CREATE_PROPERTY, boxes_unattended_setup_box_properties[BOXES_UNATTENDED_SETUP_BOX_READY_TO_CREATE_PROPERTY] = g_param_spec_boolean ("ready-to-create", "ready-to-create", "ready-to-create", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_UNATTENDED_SETUP_BOX_EXPRESS_INSTALL_PROPERTY, boxes_unattended_setup_box_properties[BOXES_UNATTENDED_SETUP_BOX_EXPRESS_INSTALL_PROPERTY] = g_param_spec_boolean ("express-install", "express-install", "express-install", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_UNATTENDED_SETUP_BOX_USERNAME_PROPERTY, boxes_unattended_setup_box_properties[BOXES_UNATTENDED_SETUP_BOX_USERNAME_PROPERTY] = g_param_spec_string ("username", "username", "username", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_UNATTENDED_SETUP_BOX_PASSWORD_PROPERTY, boxes_unattended_setup_box_properties[BOXES_UNATTENDED_SETUP_BOX_PASSWORD_PROPERTY] = g_param_spec_string ("password", "password", "password", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_UNATTENDED_SETUP_BOX_HIDDEN_PASSWORD_PROPERTY, boxes_unattended_setup_box_properties[BOXES_UNATTENDED_SETUP_BOX_HIDDEN_PASSWORD_PROPERTY] = g_param_spec_string ("hidden-password", "hidden-password", "hidden-password", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_UNATTENDED_SETUP_BOX_PRODUCT_KEY_PROPERTY, boxes_unattended_setup_box_properties[BOXES_UNATTENDED_SETUP_BOX_PRODUCT_KEY_PROPERTY] = g_param_spec_string ("product-key", "product-key", "product-key", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_UNATTENDED_SETUP_BOX_AVATAR_PATH_PROPERTY, boxes_unattended_setup_box_properties[BOXES_UNATTENDED_SETUP_BOX_AVATAR_PATH_PROPERTY] = g_param_spec_string ("avatar-path", "avatar-path", "avatar-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	BoxesUnattendedSetupBox_private_offset = g_type_class_get_instance_private_offset (klass);
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Boxes/ui/unattended-setup-box.ui");
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	boxes_unattended_setup_box_signals[BOXES_UNATTENDED_SETUP_BOX_USER_WANTS_TO_CREATE_SIGNAL] = g_signal_new ("user-wants-to-create", BOXES_TYPE_UNATTENDED_SETUP_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "needs_internet_bar", FALSE, BoxesUnattendedSetupBox_private_offset + G_STRUCT_OFFSET (BoxesUnattendedSetupBoxPrivate, needs_internet_bar));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "needs_internet_label", FALSE, BoxesUnattendedSetupBox_private_offset + G_STRUCT_OFFSET (BoxesUnattendedSetupBoxPrivate, needs_internet_label));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "setup_grid", FALSE, BoxesUnattendedSetupBox_private_offset + G_STRUCT_OFFSET (BoxesUnattendedSetupBoxPrivate, setup_grid));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "express_label", FALSE, BoxesUnattendedSetupBox_private_offset + G_STRUCT_OFFSET (BoxesUnattendedSetupBoxPrivate, express_label));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "express_toggle", FALSE, BoxesUnattendedSetupBox_private_offset + G_STRUCT_OFFSET (BoxesUnattendedSetupBoxPrivate, express_toggle));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_avatar", FALSE, BoxesUnattendedSetupBox_private_offset + G_STRUCT_OFFSET (BoxesUnattendedSetupBoxPrivate, user_avatar));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "username_entry", FALSE, BoxesUnattendedSetupBox_private_offset + G_STRUCT_OFFSET (BoxesUnattendedSetupBoxPrivate, username_entry));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "password_notebook", FALSE, BoxesUnattendedSetupBox_private_offset + G_STRUCT_OFFSET (BoxesUnattendedSetupBoxPrivate, password_notebook));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "password_entry", FALSE, BoxesUnattendedSetupBox_private_offset + G_STRUCT_OFFSET (BoxesUnattendedSetupBoxPrivate, password_entry));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "product_key_label", FALSE, BoxesUnattendedSetupBox_private_offset + G_STRUCT_OFFSET (BoxesUnattendedSetupBoxPrivate, product_key_label));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "product_key_entry", FALSE, BoxesUnattendedSetupBox_private_offset + G_STRUCT_OFFSET (BoxesUnattendedSetupBoxPrivate, product_key_entry));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_mandatory_input_changed", G_CALLBACK(_boxes_unattended_setup_box_on_mandatory_input_changed_g_object_notify));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_username_entry_activated", G_CALLBACK(_boxes_unattended_setup_box_on_username_entry_activated_gtk_entry_activate));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_password_button_clicked", G_CALLBACK(_boxes_unattended_setup_box_on_password_button_clicked_gtk_button_clicked));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_password_entry_changed", G_CALLBACK(_boxes_unattended_setup_box_on_password_entry_changed_gtk_editable_changed));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_password_entry_focus_out", G_CALLBACK(_boxes_unattended_setup_box_on_password_entry_focus_out_gtk_widget_focus_out_event));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_password_entry_activated", G_CALLBACK(_boxes_unattended_setup_box_on_password_entry_activated_gtk_entry_activate));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_key_entry_activated", G_CALLBACK(_boxes_unattended_setup_box_on_key_entry_activated_gtk_entry_activate));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_key_text_inserted", G_CALLBACK(_boxes_unattended_setup_box_on_key_text_inserted_gtk_editable_insert_text));
#line 2626 "unattended-setup-box.c"
}


static void
boxes_unattended_setup_box_instance_init (BoxesUnattendedSetupBox * self)
{
	GCancellable* _tmp0_;
	SecretSchema* _tmp1_;
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	self->priv = BOXES_UNATTENDED_SETUP_BOX_GET_PRIVATE (self);
#line 100 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp0_ = g_cancellable_new ();
#line 100 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	self->priv->cancellable = _tmp0_;
#line 102 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_tmp1_ = secret_schema_new ("org.gnome.Boxes", SECRET_SCHEMA_NONE, "gnome-boxes-media-path", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
#line 102 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	self->priv->secret_password_schema = _tmp1_;
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 2647 "unattended-setup-box.c"
}


static void
boxes_unattended_setup_box_finalize (GObject * obj)
{
	BoxesUnattendedSetupBox * self;
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_UNATTENDED_SETUP_BOX, BoxesUnattendedSetupBox);
#line 76 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_object_unref0 (self->priv->needs_internet_bar);
#line 78 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_object_unref0 (self->priv->needs_internet_label);
#line 80 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_object_unref0 (self->priv->setup_grid);
#line 82 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_object_unref0 (self->priv->express_label);
#line 84 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_object_unref0 (self->priv->express_toggle);
#line 86 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_object_unref0 (self->priv->user_avatar);
#line 88 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_object_unref0 (self->priv->username_entry);
#line 90 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_object_unref0 (self->priv->password_notebook);
#line 92 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_object_unref0 (self->priv->password_entry);
#line 94 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_object_unref0 (self->priv->product_key_label);
#line 96 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_object_unref0 (self->priv->product_key_entry);
#line 98 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_free0 (self->priv->product_key_format);
#line 99 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_free0 (self->priv->media_path);
#line 100 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 101 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_g_key_file_unref0 (self->priv->keyfile);
#line 102 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	_secret_schema_unref0 (self->priv->secret_password_schema);
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	G_OBJECT_CLASS (boxes_unattended_setup_box_parent_class)->finalize (obj);
#line 2691 "unattended-setup-box.c"
}


GType
boxes_unattended_setup_box_get_type (void)
{
	static volatile gsize boxes_unattended_setup_box_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_unattended_setup_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesUnattendedSetupBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_unattended_setup_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesUnattendedSetupBox), 0, (GInstanceInitFunc) boxes_unattended_setup_box_instance_init, NULL };
		GType boxes_unattended_setup_box_type_id;
		boxes_unattended_setup_box_type_id = g_type_register_static (gtk_box_get_type (), "BoxesUnattendedSetupBox", &g_define_type_info, 0);
		g_once_init_leave (&boxes_unattended_setup_box_type_id__volatile, boxes_unattended_setup_box_type_id);
	}
	return boxes_unattended_setup_box_type_id__volatile;
}


static void
_vala_boxes_unattended_setup_box_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	BoxesUnattendedSetupBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_UNATTENDED_SETUP_BOX, BoxesUnattendedSetupBox);
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	switch (property_id) {
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		case BOXES_UNATTENDED_SETUP_BOX_READY_FOR_EXPRESS_PROPERTY:
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_value_set_boolean (value, boxes_unattended_setup_box_get_ready_for_express (self));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		break;
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		case BOXES_UNATTENDED_SETUP_BOX_READY_TO_CREATE_PROPERTY:
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_value_set_boolean (value, boxes_unattended_setup_box_get_ready_to_create (self));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		break;
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		case BOXES_UNATTENDED_SETUP_BOX_EXPRESS_INSTALL_PROPERTY:
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_value_set_boolean (value, boxes_unattended_setup_box_get_express_install (self));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		break;
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		case BOXES_UNATTENDED_SETUP_BOX_USERNAME_PROPERTY:
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_value_set_string (value, boxes_unattended_setup_box_get_username (self));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		break;
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		case BOXES_UNATTENDED_SETUP_BOX_PASSWORD_PROPERTY:
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_value_take_string (value, boxes_unattended_setup_box_get_password (self));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		break;
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		case BOXES_UNATTENDED_SETUP_BOX_HIDDEN_PASSWORD_PROPERTY:
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_value_take_string (value, boxes_unattended_setup_box_get_hidden_password (self));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		break;
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		case BOXES_UNATTENDED_SETUP_BOX_PRODUCT_KEY_PROPERTY:
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		g_value_take_string (value, boxes_unattended_setup_box_get_product_key (self));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		break;
#line 2761 "unattended-setup-box.c"
		default:
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		break;
#line 2767 "unattended-setup-box.c"
	}
}


static void
_vala_boxes_unattended_setup_box_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	BoxesUnattendedSetupBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_UNATTENDED_SETUP_BOX, BoxesUnattendedSetupBox);
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
	switch (property_id) {
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		case BOXES_UNATTENDED_SETUP_BOX_EXPRESS_INSTALL_PROPERTY:
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		boxes_unattended_setup_box_set_express_install (self, g_value_get_boolean (value));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		break;
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		case BOXES_UNATTENDED_SETUP_BOX_AVATAR_PATH_PROPERTY:
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		boxes_unattended_setup_box_set_avatar_path (self, g_value_get_string (value));
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		break;
#line 2794 "unattended-setup-box.c"
		default:
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 4 "/home/fborges/checkout/gnome-boxes/src/unattended-setup-box.vala"
		break;
#line 2800 "unattended-setup-box.c"
	}
}



