/* os-database.c generated by valac 0.15.0, the Vala compiler
 * generated from os-database.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <osinfo/osinfo.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define BOXES_TYPE_OS_DATABASE (boxes_os_database_get_type ())
#define BOXES_OS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_OS_DATABASE, BoxesOSDatabase))
#define BOXES_OS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_OS_DATABASE, BoxesOSDatabaseClass))
#define BOXES_IS_OS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_OS_DATABASE))
#define BOXES_IS_OS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_OS_DATABASE))
#define BOXES_OS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_OS_DATABASE, BoxesOSDatabaseClass))

typedef struct _BoxesOSDatabase BoxesOSDatabase;
typedef struct _BoxesOSDatabaseClass BoxesOSDatabaseClass;
typedef struct _BoxesOSDatabasePrivate BoxesOSDatabasePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _boxes_os_database_unref0(var) ((var == NULL) ? NULL : (var = (boxes_os_database_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BoxesOsDatabaseGuessOsFromInstallMediaData BoxesOsDatabaseGuessOsFromInstallMediaData;
typedef struct _BoxesParamSpecOSDatabase BoxesParamSpecOSDatabase;

typedef enum  {
	BOXES_OS_DATABASE_ERROR_NON_BOOTABLE,
	BOXES_OS_DATABASE_ERROR_UNKNOWN_OS_ID,
	BOXES_OS_DATABASE_ERROR_UNKNOWN_MEDIA_ID
} BoxesOSDatabaseError;
#define BOXES_OS_DATABASE_ERROR boxes_os_database_error_quark ()
struct _BoxesOSDatabase {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BoxesOSDatabasePrivate * priv;
};

struct _BoxesOSDatabaseClass {
	GTypeClass parent_class;
	void (*finalize) (BoxesOSDatabase *self);
};

struct _BoxesOSDatabasePrivate {
	OsinfoDb* db;
};

struct _BoxesOsDatabaseGuessOsFromInstallMediaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesOSDatabase* self;
	gchar* media_path;
	OsinfoMedia* os_media;
	GCancellable* cancellable;
	OsinfoOs* result;
	const gchar* _tmp0_;
	GCancellable* _tmp1_;
	OsinfoMedia* _tmp2_;
	OsinfoMedia* media;
	OsinfoDb* _tmp3_;
	OsinfoMedia* _tmp4_;
	OsinfoOs* _tmp5_;
	OsinfoMedia* _tmp6_;
	OsinfoOs* _tmp7_;
	GError * _inner_error_;
};

struct _BoxesParamSpecOSDatabase {
	GParamSpec parent_instance;
};


static gpointer boxes_os_database_parent_class = NULL;

GQuark boxes_os_database_error_quark (void);
gpointer boxes_os_database_ref (gpointer instance);
void boxes_os_database_unref (gpointer instance);
GParamSpec* boxes_param_spec_os_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void boxes_value_set_os_database (GValue* value, gpointer v_object);
void boxes_value_take_os_database (GValue* value, gpointer v_object);
gpointer boxes_value_get_os_database (const GValue* value);
GType boxes_os_database_get_type (void) G_GNUC_CONST;
#define BOXES_OS_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_OS_DATABASE, BoxesOSDatabasePrivate))
enum  {
	BOXES_OS_DATABASE_DUMMY_PROPERTY
};
#define BOXES_OS_DATABASE_DEFAULT_VCPUS 1
#define BOXES_OS_DATABASE_DEFAULT_RAM (500 * ((gint64) OSINFO_MEBIBYTES))
#define BOXES_OS_DATABASE_DEFAULT_STORAGE (20 * ((gint64) OSINFO_GIBIBYTES))
static OsinfoResources* boxes_os_database_get_default_resources (void);
BoxesOSDatabase* boxes_os_database_new (GError** error);
BoxesOSDatabase* boxes_os_database_construct (GType object_type, GError** error);
static void boxes_os_database_guess_os_from_install_media_data_free (gpointer _data);
void boxes_os_database_guess_os_from_install_media (BoxesOSDatabase* self, const gchar* media_path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
OsinfoOs* boxes_os_database_guess_os_from_install_media_finish (BoxesOSDatabase* self, GAsyncResult* _res_, OsinfoMedia** os_media, GError** error);
static gboolean boxes_os_database_guess_os_from_install_media_co (BoxesOsDatabaseGuessOsFromInstallMediaData* _data_);
static void boxes_os_database_guess_os_from_install_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
OsinfoOs* boxes_os_database_get_os_by_id (BoxesOSDatabase* self, const gchar* id, GError** error);
OsinfoMedia* boxes_os_database_get_media_by_id (BoxesOSDatabase* self, OsinfoOs* os, const gchar* id, GError** error);
OsinfoResources* boxes_os_database_get_resources_for_os (BoxesOSDatabase* self, OsinfoOs* os);
static OsinfoResources* boxes_os_database_get_prefered_resources (BoxesOSDatabase* self, OsinfoResourcesList* list, gchar** prefs, int prefs_length1);
static OsinfoResources* boxes_os_database_get_resources_from_os_resources (BoxesOSDatabase* self, OsinfoResources* minimum, OsinfoResources* recommended);
static void boxes_os_database_finalize (BoxesOSDatabase* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark boxes_os_database_error_quark (void) {
	return g_quark_from_static_string ("boxes_os_database_error-quark");
}


static OsinfoResources* boxes_os_database_get_default_resources (void) {
	OsinfoResources* result = NULL;
	OsinfoResources* _tmp0_;
	OsinfoResources* resources;
	_tmp0_ = osinfo_resources_new ("whatever", "x86_64");
	resources = _tmp0_;
	osinfo_resources_set_n_cpus (resources, BOXES_OS_DATABASE_DEFAULT_VCPUS);
	osinfo_resources_set_ram (resources, BOXES_OS_DATABASE_DEFAULT_RAM);
	osinfo_resources_set_storage (resources, BOXES_OS_DATABASE_DEFAULT_STORAGE);
	result = resources;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


BoxesOSDatabase* boxes_os_database_construct (GType object_type, GError** error) {
	BoxesOSDatabase* self = NULL;
	OsinfoLoader* _tmp0_;
	OsinfoLoader* loader;
	OsinfoDb* _tmp1_ = NULL;
	OsinfoDb* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (BoxesOSDatabase*) g_type_create_instance (object_type);
	_tmp0_ = osinfo_loader_new ();
	loader = _tmp0_;
	osinfo_loader_process_default_path (loader, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (loader);
		_boxes_os_database_unref0 (self);
		return NULL;
	}
	_tmp1_ = osinfo_loader_get_db (loader);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->db);
	self->priv->db = _tmp2_;
	_g_object_unref0 (loader);
	return self;
}


BoxesOSDatabase* boxes_os_database_new (GError** error) {
	return boxes_os_database_construct (BOXES_TYPE_OS_DATABASE, error);
}


static void boxes_os_database_guess_os_from_install_media_data_free (gpointer _data) {
	BoxesOsDatabaseGuessOsFromInstallMediaData* _data_;
	_data_ = _data;
	_g_free0 (_data_->media_path);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_boxes_os_database_unref0 (_data_->self);
	g_slice_free (BoxesOsDatabaseGuessOsFromInstallMediaData, _data_);
}


static gpointer _boxes_os_database_ref0 (gpointer self) {
	return self ? boxes_os_database_ref (self) : NULL;
}


void boxes_os_database_guess_os_from_install_media (BoxesOSDatabase* self, const gchar* media_path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesOsDatabaseGuessOsFromInstallMediaData* _data_;
	BoxesOSDatabase* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (BoxesOsDatabaseGuessOsFromInstallMediaData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, boxes_os_database_guess_os_from_install_media);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_os_database_guess_os_from_install_media_data_free);
	_tmp0_ = _boxes_os_database_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = media_path;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->media_path = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	boxes_os_database_guess_os_from_install_media_co (_data_);
}


OsinfoOs* boxes_os_database_guess_os_from_install_media_finish (BoxesOSDatabase* self, GAsyncResult* _res_, OsinfoMedia** os_media, GError** error) {
	OsinfoOs* result;
	BoxesOsDatabaseGuessOsFromInstallMediaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (os_media) {
		*os_media = _data_->os_media;
	} else {
		_g_object_unref0 (_data_->os_media);
	}
	_data_->os_media = NULL;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void boxes_os_database_guess_os_from_install_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesOsDatabaseGuessOsFromInstallMediaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_os_database_guess_os_from_install_media_co (_data_);
}


static gboolean boxes_os_database_guess_os_from_install_media_co (BoxesOsDatabaseGuessOsFromInstallMediaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->media_path;
	_data_->_tmp1_ = _data_->cancellable;
	_data_->_state_ = 1;
	osinfo_media_create_from_location_async (_data_->_tmp0_, G_PRIORITY_DEFAULT, _data_->_tmp1_, boxes_os_database_guess_os_from_install_media_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = osinfo_media_create_from_location_finish (_data_->_res_, &_data_->_inner_error_);
	_data_->media = _data_->_tmp2_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->db;
	_data_->_tmp4_ = NULL;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = osinfo_db_guess_os_from_media (_data_->_tmp3_, _data_->media, &_data_->_tmp4_);
	_g_object_unref0 (_data_->os_media);
	_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp4_);
	_data_->os_media = _data_->_tmp6_;
	_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp5_);
	_data_->result = _data_->_tmp7_;
	_g_object_unref0 (_data_->media);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->media);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


OsinfoOs* boxes_os_database_get_os_by_id (BoxesOSDatabase* self, const gchar* id, GError** error) {
	OsinfoOs* result = NULL;
	OsinfoDb* _tmp0_;
	const gchar* _tmp1_;
	OsinfoOs* _tmp2_ = NULL;
	OsinfoOs* _tmp3_;
	OsinfoOs* os;
	OsinfoOs* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->priv->db;
	_tmp1_ = id;
	_tmp2_ = osinfo_db_get_os (_tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	os = _tmp3_;
	_tmp4_ = os;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_;
		GError* _tmp6_;
		_tmp5_ = id;
		_tmp6_ = g_error_new (BOXES_OS_DATABASE_ERROR, BOXES_OS_DATABASE_ERROR_UNKNOWN_OS_ID, "Unknown OS ID '%s'", _tmp5_);
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == BOXES_OS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (os);
			return NULL;
		} else {
			_g_object_unref0 (os);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = os;
	return result;
}


OsinfoMedia* boxes_os_database_get_media_by_id (BoxesOSDatabase* self, OsinfoOs* os, const gchar* id, GError** error) {
	OsinfoMedia* result = NULL;
	OsinfoOs* _tmp0_;
	OsinfoMediaList* _tmp1_ = NULL;
	OsinfoMediaList* medias;
	OsinfoMediaList* _tmp2_;
	const gchar* _tmp3_;
	OsinfoEntity* _tmp4_ = NULL;
	OsinfoMedia* _tmp5_;
	OsinfoMedia* media;
	OsinfoMedia* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (os != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = os;
	_tmp1_ = osinfo_os_get_media_list (_tmp0_);
	medias = _tmp1_;
	_tmp2_ = medias;
	_tmp3_ = id;
	_tmp4_ = osinfo_list_find_by_id ((OsinfoList*) _tmp2_, _tmp3_);
	_tmp5_ = _g_object_ref0 (OSINFO_IS_MEDIA (_tmp4_) ? ((OsinfoMedia*) _tmp4_) : NULL);
	media = _tmp5_;
	_tmp6_ = media;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_;
		GError* _tmp8_;
		_tmp7_ = id;
		_tmp8_ = g_error_new (BOXES_OS_DATABASE_ERROR, BOXES_OS_DATABASE_ERROR_UNKNOWN_MEDIA_ID, "Unknown media ID '%s'", _tmp7_);
		_inner_error_ = _tmp8_;
		if (_inner_error_->domain == BOXES_OS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (media);
			_g_object_unref0 (medias);
			return NULL;
		} else {
			_g_object_unref0 (media);
			_g_object_unref0 (medias);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = media;
	_g_object_unref0 (medias);
	return result;
}


OsinfoResources* boxes_os_database_get_resources_for_os (BoxesOSDatabase* self, OsinfoOs* os) {
	OsinfoResources* result = NULL;
	OsinfoOs* _tmp0_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** prefs;
	gint prefs_length1;
	gint _prefs_size_;
	OsinfoOs* _tmp7_;
	OsinfoResourcesList* _tmp8_ = NULL;
	OsinfoResourcesList* list;
	OsinfoResourcesList* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	OsinfoResources* _tmp11_ = NULL;
	OsinfoResources* recommended;
	OsinfoOs* _tmp12_;
	OsinfoResourcesList* _tmp13_ = NULL;
	OsinfoResourcesList* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	OsinfoResources* _tmp16_ = NULL;
	OsinfoResources* minimum;
	OsinfoResources* _tmp17_;
	OsinfoResources* _tmp18_;
	OsinfoResources* _tmp19_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = os;
	if (_tmp0_ == NULL) {
		OsinfoResources* _tmp1_ = NULL;
		_tmp1_ = boxes_os_database_get_default_resources ();
		result = _tmp1_;
		return result;
	}
	_tmp2_ = g_strdup ("x86_64");
	_tmp3_ = g_strdup ("i686");
	_tmp4_ = g_strdup ("i386");
	_tmp5_ = g_strdup (OSINFO_ARCHITECTURE_ALL);
	_tmp6_ = g_new0 (gchar*, 4 + 1);
	_tmp6_[0] = _tmp2_;
	_tmp6_[1] = _tmp3_;
	_tmp6_[2] = _tmp4_;
	_tmp6_[3] = _tmp5_;
	prefs = _tmp6_;
	prefs_length1 = 4;
	_prefs_size_ = prefs_length1;
	_tmp7_ = os;
	_tmp8_ = osinfo_os_get_recommended_resources (_tmp7_);
	list = _tmp8_;
	_tmp9_ = list;
	_tmp10_ = prefs;
	_tmp10__length1 = prefs_length1;
	_tmp11_ = boxes_os_database_get_prefered_resources (self, _tmp9_, _tmp10_, _tmp10__length1);
	recommended = _tmp11_;
	_tmp12_ = os;
	_tmp13_ = osinfo_os_get_minimum_resources (_tmp12_);
	_g_object_unref0 (list);
	list = _tmp13_;
	_tmp14_ = list;
	_tmp15_ = prefs;
	_tmp15__length1 = prefs_length1;
	_tmp16_ = boxes_os_database_get_prefered_resources (self, _tmp14_, _tmp15_, _tmp15__length1);
	minimum = _tmp16_;
	_tmp17_ = minimum;
	_tmp18_ = recommended;
	_tmp19_ = boxes_os_database_get_resources_from_os_resources (self, _tmp17_, _tmp18_);
	result = _tmp19_;
	_g_object_unref0 (minimum);
	_g_object_unref0 (recommended);
	_g_object_unref0 (list);
	prefs = (_vala_array_free (prefs, prefs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static OsinfoResources* boxes_os_database_get_resources_from_os_resources (BoxesOSDatabase* self, OsinfoResources* minimum, OsinfoResources* recommended) {
	OsinfoResources* result = NULL;
	OsinfoResources* _tmp0_ = NULL;
	OsinfoResources* resources;
	gboolean _tmp1_ = FALSE;
	OsinfoResources* _tmp2_;
	gboolean _tmp6_;
	gboolean _tmp25_ = FALSE;
	OsinfoResources* _tmp26_;
	gboolean _tmp30_;
	gboolean _tmp49_ = FALSE;
	OsinfoResources* _tmp50_;
	gboolean _tmp54_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = boxes_os_database_get_default_resources ();
	resources = _tmp0_;
	_tmp2_ = recommended;
	if (_tmp2_ != NULL) {
		OsinfoResources* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = recommended;
		_tmp4_ = osinfo_resources_get_n_cpus (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		OsinfoResources* _tmp7_;
		OsinfoResources* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp7_ = resources;
		_tmp8_ = recommended;
		_tmp9_ = osinfo_resources_get_n_cpus (_tmp8_);
		_tmp10_ = _tmp9_;
		osinfo_resources_set_n_cpus (_tmp7_, _tmp10_);
	} else {
		gboolean _tmp11_ = FALSE;
		OsinfoResources* _tmp12_;
		gboolean _tmp16_;
		_tmp12_ = minimum;
		if (_tmp12_ != NULL) {
			OsinfoResources* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp13_ = minimum;
			_tmp14_ = osinfo_resources_get_n_cpus (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_ > 0;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp16_ = _tmp11_;
		if (_tmp16_) {
			OsinfoResources* _tmp17_;
			OsinfoResources* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			OsinfoResources* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_ = 0;
			_tmp17_ = resources;
			_tmp18_ = minimum;
			_tmp19_ = osinfo_resources_get_n_cpus (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = resources;
			_tmp22_ = osinfo_resources_get_n_cpus (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = MAX (_tmp20_, _tmp23_);
			osinfo_resources_set_n_cpus (_tmp17_, _tmp24_);
		}
	}
	_tmp26_ = recommended;
	if (_tmp26_ != NULL) {
		OsinfoResources* _tmp27_;
		gint64 _tmp28_;
		gint64 _tmp29_;
		_tmp27_ = recommended;
		_tmp28_ = osinfo_resources_get_ram (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp25_ = _tmp29_ > ((gint64) 0);
	} else {
		_tmp25_ = FALSE;
	}
	_tmp30_ = _tmp25_;
	if (_tmp30_) {
		OsinfoResources* _tmp31_;
		OsinfoResources* _tmp32_;
		gint64 _tmp33_;
		gint64 _tmp34_;
		_tmp31_ = resources;
		_tmp32_ = recommended;
		_tmp33_ = osinfo_resources_get_ram (_tmp32_);
		_tmp34_ = _tmp33_;
		osinfo_resources_set_ram (_tmp31_, _tmp34_);
	} else {
		gboolean _tmp35_ = FALSE;
		OsinfoResources* _tmp36_;
		gboolean _tmp40_;
		_tmp36_ = minimum;
		if (_tmp36_ != NULL) {
			OsinfoResources* _tmp37_;
			gint64 _tmp38_;
			gint64 _tmp39_;
			_tmp37_ = minimum;
			_tmp38_ = osinfo_resources_get_ram (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp35_ = _tmp39_ > ((gint64) 0);
		} else {
			_tmp35_ = FALSE;
		}
		_tmp40_ = _tmp35_;
		if (_tmp40_) {
			OsinfoResources* _tmp41_;
			OsinfoResources* _tmp42_;
			gint64 _tmp43_;
			gint64 _tmp44_;
			OsinfoResources* _tmp45_;
			gint64 _tmp46_;
			gint64 _tmp47_;
			gint64 _tmp48_ = 0LL;
			_tmp41_ = resources;
			_tmp42_ = minimum;
			_tmp43_ = osinfo_resources_get_ram (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = resources;
			_tmp46_ = osinfo_resources_get_ram (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = MAX (_tmp44_, _tmp47_);
			osinfo_resources_set_ram (_tmp41_, _tmp48_);
		}
	}
	_tmp50_ = recommended;
	if (_tmp50_ != NULL) {
		OsinfoResources* _tmp51_;
		gint64 _tmp52_;
		gint64 _tmp53_;
		_tmp51_ = recommended;
		_tmp52_ = osinfo_resources_get_storage (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp49_ = _tmp53_ > ((gint64) 0);
	} else {
		_tmp49_ = FALSE;
	}
	_tmp54_ = _tmp49_;
	if (_tmp54_) {
		OsinfoResources* _tmp55_;
		OsinfoResources* _tmp56_;
		gint64 _tmp57_;
		gint64 _tmp58_;
		_tmp55_ = resources;
		_tmp56_ = recommended;
		_tmp57_ = osinfo_resources_get_storage (_tmp56_);
		_tmp58_ = _tmp57_;
		osinfo_resources_set_storage (_tmp55_, _tmp58_);
	} else {
		gboolean _tmp59_ = FALSE;
		OsinfoResources* _tmp60_;
		gboolean _tmp64_;
		_tmp60_ = minimum;
		if (_tmp60_ != NULL) {
			OsinfoResources* _tmp61_;
			gint64 _tmp62_;
			gint64 _tmp63_;
			_tmp61_ = minimum;
			_tmp62_ = osinfo_resources_get_storage (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp59_ = _tmp63_ > ((gint64) 0);
		} else {
			_tmp59_ = FALSE;
		}
		_tmp64_ = _tmp59_;
		if (_tmp64_) {
			OsinfoResources* _tmp65_;
			OsinfoResources* _tmp66_;
			gint64 _tmp67_;
			gint64 _tmp68_;
			OsinfoResources* _tmp69_;
			gint64 _tmp70_;
			gint64 _tmp71_;
			gint64 _tmp72_ = 0LL;
			_tmp65_ = resources;
			_tmp66_ = minimum;
			_tmp67_ = osinfo_resources_get_storage (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = resources;
			_tmp70_ = osinfo_resources_get_storage (_tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = MAX (_tmp68_ * 2, _tmp71_);
			osinfo_resources_set_storage (_tmp65_, _tmp72_);
		}
	}
	result = resources;
	return result;
}


static OsinfoResources* boxes_os_database_get_prefered_resources (BoxesOSDatabase* self, OsinfoResourcesList* list, gchar** prefs, int prefs_length1) {
	OsinfoResources* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	OsinfoFilter* _tmp1_;
	OsinfoFilter* filter;
	OsinfoFilter* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	OsinfoResourcesList* _tmp5_;
	OsinfoFilter* _tmp6_;
	OsinfoResourcesList* _tmp7_ = NULL;
	OsinfoResourcesList* filtered;
	OsinfoResourcesList* _tmp8_;
	gint _tmp9_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (list != NULL, NULL);
	_tmp0_ = prefs;
	_tmp0__length1 = prefs_length1;
	if (_tmp0__length1 <= 0) {
		result = NULL;
		return result;
	}
	_tmp1_ = osinfo_filter_new ();
	filter = _tmp1_;
	_tmp2_ = filter;
	_tmp3_ = prefs;
	_tmp3__length1 = prefs_length1;
	_tmp4_ = _tmp3_[0];
	osinfo_filter_add_constraint (_tmp2_, OSINFO_RESOURCES_PROP_ARCHITECTURE, _tmp4_);
	_tmp5_ = list;
	_tmp6_ = filter;
	_tmp7_ = osinfo_resourceslist_new_filtered (_tmp5_, _tmp6_);
	filtered = _tmp7_;
	_tmp8_ = filtered;
	_tmp9_ = osinfo_list_get_length ((OsinfoList*) _tmp8_);
	if (_tmp9_ <= 0) {
		OsinfoResourcesList* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar** _tmp12_;
		gint _tmp12__length1;
		OsinfoResources* _tmp13_ = NULL;
		_tmp10_ = list;
		_tmp11_ = prefs;
		_tmp11__length1 = prefs_length1;
		_tmp12_ = prefs;
		_tmp12__length1 = prefs_length1;
		_tmp13_ = boxes_os_database_get_prefered_resources (self, _tmp10_, _tmp11_ + 1, _tmp12__length1 - 1);
		result = _tmp13_;
		_g_object_unref0 (filtered);
		_g_object_unref0 (filter);
		return result;
	} else {
		OsinfoResourcesList* _tmp14_;
		OsinfoEntity* _tmp15_ = NULL;
		OsinfoResources* _tmp16_;
		_tmp14_ = filtered;
		_tmp15_ = osinfo_list_get_nth ((OsinfoList*) _tmp14_, 0);
		_tmp16_ = _g_object_ref0 (OSINFO_IS_RESOURCES (_tmp15_) ? ((OsinfoResources*) _tmp15_) : NULL);
		result = _tmp16_;
		_g_object_unref0 (filtered);
		_g_object_unref0 (filter);
		return result;
	}
	_g_object_unref0 (filtered);
	_g_object_unref0 (filter);
}


static void boxes_value_os_database_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void boxes_value_os_database_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		boxes_os_database_unref (value->data[0].v_pointer);
	}
}


static void boxes_value_os_database_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = boxes_os_database_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer boxes_value_os_database_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* boxes_value_os_database_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		BoxesOSDatabase* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = boxes_os_database_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* boxes_value_os_database_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BoxesOSDatabase** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = boxes_os_database_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* boxes_param_spec_os_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BoxesParamSpecOSDatabase* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BOXES_TYPE_OS_DATABASE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer boxes_value_get_os_database (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_OS_DATABASE), NULL);
	return value->data[0].v_pointer;
}


void boxes_value_set_os_database (GValue* value, gpointer v_object) {
	BoxesOSDatabase* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_OS_DATABASE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_OS_DATABASE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		boxes_os_database_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		boxes_os_database_unref (old);
	}
}


void boxes_value_take_os_database (GValue* value, gpointer v_object) {
	BoxesOSDatabase* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_OS_DATABASE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_OS_DATABASE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		boxes_os_database_unref (old);
	}
}


static void boxes_os_database_class_init (BoxesOSDatabaseClass * klass) {
	boxes_os_database_parent_class = g_type_class_peek_parent (klass);
	BOXES_OS_DATABASE_CLASS (klass)->finalize = boxes_os_database_finalize;
	g_type_class_add_private (klass, sizeof (BoxesOSDatabasePrivate));
}


static void boxes_os_database_instance_init (BoxesOSDatabase * self) {
	self->priv = BOXES_OS_DATABASE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void boxes_os_database_finalize (BoxesOSDatabase* obj) {
	BoxesOSDatabase * self;
	self = BOXES_OS_DATABASE (obj);
	_g_object_unref0 (self->priv->db);
}


GType boxes_os_database_get_type (void) {
	static volatile gsize boxes_os_database_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_os_database_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { boxes_value_os_database_init, boxes_value_os_database_free_value, boxes_value_os_database_copy_value, boxes_value_os_database_peek_pointer, "p", boxes_value_os_database_collect_value, "p", boxes_value_os_database_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BoxesOSDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_os_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesOSDatabase), 0, (GInstanceInitFunc) boxes_os_database_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType boxes_os_database_type_id;
		boxes_os_database_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BoxesOSDatabase", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&boxes_os_database_type_id__volatile, boxes_os_database_type_id);
	}
	return boxes_os_database_type_id__volatile;
}


gpointer boxes_os_database_ref (gpointer instance) {
	BoxesOSDatabase* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void boxes_os_database_unref (gpointer instance) {
	BoxesOSDatabase* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BOXES_OS_DATABASE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



