/* unit.c generated by valac 0.22.1, the Vala compiler
 * generated from unit.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_UNIT_MANAGER (unit_manager_get_type ())
#define UNIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT_MANAGER, UnitManager))
#define UNIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT_MANAGER, UnitManagerClass))
#define IS_UNIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT_MANAGER))
#define IS_UNIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT_MANAGER))
#define UNIT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT_MANAGER, UnitManagerClass))

typedef struct _UnitManager UnitManager;
typedef struct _UnitManagerClass UnitManagerClass;
typedef struct _UnitManagerPrivate UnitManagerPrivate;

#define TYPE_UNIT_CATEGORY (unit_category_get_type ())
#define UNIT_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT_CATEGORY, UnitCategory))
#define UNIT_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT_CATEGORY, UnitCategoryClass))
#define IS_UNIT_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT_CATEGORY))
#define IS_UNIT_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT_CATEGORY))
#define UNIT_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT_CATEGORY, UnitCategoryClass))

typedef struct _UnitCategory UnitCategory;
typedef struct _UnitCategoryClass UnitCategoryClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_UNIT (unit_get_type ())
#define UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT, Unit))
#define UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT, UnitClass))
#define IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT))
#define IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT))
#define UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT, UnitClass))

typedef struct _Unit Unit;
typedef struct _UnitClass UnitClass;

#define TYPE_CURRENCY (currency_get_type ())
#define CURRENCY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CURRENCY, Currency))
#define CURRENCY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CURRENCY, CurrencyClass))
#define IS_CURRENCY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CURRENCY))
#define IS_CURRENCY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CURRENCY))
#define CURRENCY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CURRENCY, CurrencyClass))

typedef struct _Currency Currency;
typedef struct _CurrencyClass CurrencyClass;

#define TYPE_CURRENCY_MANAGER (currency_manager_get_type ())
#define CURRENCY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CURRENCY_MANAGER, CurrencyManager))
#define CURRENCY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CURRENCY_MANAGER, CurrencyManagerClass))
#define IS_CURRENCY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CURRENCY_MANAGER))
#define IS_CURRENCY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CURRENCY_MANAGER))
#define CURRENCY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CURRENCY_MANAGER, CurrencyManagerClass))

typedef struct _CurrencyManager CurrencyManager;
typedef struct _CurrencyManagerClass CurrencyManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
typedef struct _UnitCategoryPrivate UnitCategoryPrivate;
#define _number_unref0(var) ((var == NULL) ? NULL : (var = (number_unref (var), NULL)))
typedef struct _UnitPrivate UnitPrivate;

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

#define TYPE_EQUATION (equation_get_type ())
#define EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EQUATION, Equation))
#define EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EQUATION, EquationClass))
#define IS_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EQUATION))
#define IS_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EQUATION))
#define EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EQUATION, EquationClass))

typedef struct _Equation Equation;
typedef struct _EquationClass EquationClass;

#define TYPE_UNIT_SOLVE_EQUATION (unit_solve_equation_get_type ())
#define UNIT_SOLVE_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT_SOLVE_EQUATION, UnitSolveEquation))
#define UNIT_SOLVE_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT_SOLVE_EQUATION, UnitSolveEquationClass))
#define IS_UNIT_SOLVE_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT_SOLVE_EQUATION))
#define IS_UNIT_SOLVE_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT_SOLVE_EQUATION))
#define UNIT_SOLVE_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT_SOLVE_EQUATION, UnitSolveEquationClass))

typedef struct _UnitSolveEquation UnitSolveEquation;
typedef struct _UnitSolveEquationClass UnitSolveEquationClass;
typedef struct _EquationPrivate EquationPrivate;

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

#define TYPE_ERROR_CODE (error_code_get_type ())
#define _equation_unref0(var) ((var == NULL) ? NULL : (var = (equation_unref (var), NULL)))
typedef struct _UnitSolveEquationPrivate UnitSolveEquationPrivate;

struct _UnitManager {
	GObject parent_instance;
	UnitManagerPrivate * priv;
};

struct _UnitManagerClass {
	GObjectClass parent_class;
};

struct _UnitManagerPrivate {
	GList* categories;
};

struct _UnitCategory {
	GObject parent_instance;
	UnitCategoryPrivate * priv;
};

struct _UnitCategoryClass {
	GObjectClass parent_class;
};

struct _UnitCategoryPrivate {
	GList* units;
	gchar* _name;
	gchar* _display_name;
};

struct _Unit {
	GObject parent_instance;
	UnitPrivate * priv;
};

struct _UnitClass {
	GObjectClass parent_class;
};

struct _UnitPrivate {
	gchar* _name;
	gchar* _display_name;
	gchar* _format;
	GList* _symbols;
	gchar* from_function;
	gchar* to_function;
	Serializer* serializer;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _Equation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EquationPrivate * priv;
	gint base;
	gint wordlen;
	AngleUnit angle_units;
};

struct _EquationClass {
	GTypeClass parent_class;
	void (*finalize) (Equation *self);
	gboolean (*variable_is_defined) (Equation* self, const gchar* name);
	Number* (*get_variable) (Equation* self, const gchar* name);
	void (*set_variable) (Equation* self, const gchar* name, Number* x);
	gboolean (*function_is_defined) (Equation* self, const gchar* name);
	Number* (*convert) (Equation* self, Number* x, const gchar* x_units, const gchar* z_units);
};

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;

struct _UnitSolveEquation {
	Equation parent_instance;
	UnitSolveEquationPrivate * priv;
};

struct _UnitSolveEquationClass {
	EquationClass parent_class;
};

struct _UnitSolveEquationPrivate {
	Number* x;
};


extern UnitManager* default_unit_manager;
UnitManager* default_unit_manager = NULL;
static gpointer unit_manager_parent_class = NULL;
static gpointer unit_category_parent_class = NULL;
static gpointer unit_parent_class = NULL;
static gpointer unit_solve_equation_parent_class = NULL;

GType unit_manager_get_type (void) G_GNUC_CONST;
GType unit_category_get_type (void) G_GNUC_CONST;
#define UNIT_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_UNIT_MANAGER, UnitManagerPrivate))
enum  {
	UNIT_MANAGER_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
UnitManager* unit_manager_new (void);
UnitManager* unit_manager_construct (GType object_type);
UnitManager* unit_manager_get_default (void);
UnitCategory* unit_manager_add_category (UnitManager* self, const gchar* name, const gchar* display_name);
GType unit_get_type (void) G_GNUC_CONST;
void unit_category_add_unit (UnitCategory* self, Unit* unit);
Unit* unit_new (const gchar* name, const gchar* display_name, const gchar* format, const gchar* from_function, const gchar* to_function, const gchar* symbols);
Unit* unit_construct (GType object_type, const gchar* name, const gchar* display_name, const gchar* format, const gchar* from_function, const gchar* to_function, const gchar* symbols);
GType currency_get_type (void) G_GNUC_CONST;
GType currency_manager_get_type (void) G_GNUC_CONST;
CurrencyManager* currency_manager_get_default (void);
GList* currency_manager_get_currencies (CurrencyManager* self);
static gint __lambda7_ (Currency* a, Currency* b);
gchar* currency_get_display_name (Currency* self);
static gint ___lambda7__gcompare_func (gconstpointer a, gconstpointer b);
gchar* currency_get_symbol (Currency* self);
gchar* currency_get_name (Currency* self);
UnitCategory* unit_category_new (const gchar* name, const gchar* display_name);
UnitCategory* unit_category_construct (GType object_type, const gchar* name, const gchar* display_name);
GList* unit_manager_get_categories (UnitManager* self);
UnitCategory* unit_manager_get_category (UnitManager* self, const gchar* category);
gchar* unit_category_get_name (UnitCategory* self);
Unit* unit_manager_get_unit_by_name (UnitManager* self, const gchar* name);
Unit* unit_category_get_unit_by_name (UnitCategory* self, const gchar* name);
Unit* unit_manager_get_unit_by_symbol (UnitManager* self, const gchar* symbol);
Unit* unit_category_get_unit_by_symbol (UnitCategory* self, const gchar* symbol);
gpointer number_ref (gpointer instance);
void number_unref (gpointer instance);
GParamSpec* param_spec_number (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_number (GValue* value, gpointer v_object);
void value_take_number (GValue* value, gpointer v_object);
gpointer value_get_number (const GValue* value);
GType number_get_type (void) G_GNUC_CONST;
Number* unit_manager_convert_by_symbol (UnitManager* self, Number* x, const gchar* x_symbol, const gchar* z_symbol);
Number* unit_category_convert (UnitCategory* self, Number* x, Unit* x_units, Unit* z_units);
static void unit_manager_finalize (GObject* obj);
#define UNIT_CATEGORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_UNIT_CATEGORY, UnitCategoryPrivate))
enum  {
	UNIT_CATEGORY_DUMMY_PROPERTY,
	UNIT_CATEGORY_NAME,
	UNIT_CATEGORY_DISPLAY_NAME
};
gchar* unit_get_name (Unit* self);
gboolean unit_matches_symbol (Unit* self, const gchar* symbol);
GList* unit_category_get_units (UnitCategory* self);
Number* unit_convert_from (Unit* self, Number* x);
Number* unit_convert_to (Unit* self, Number* x);
gchar* unit_category_get_display_name (UnitCategory* self);
static void unit_category_finalize (GObject* obj);
static void _vala_unit_category_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType serializer_get_type (void) G_GNUC_CONST;
#define UNIT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_UNIT, UnitPrivate))
enum  {
	UNIT_DUMMY_PROPERTY,
	UNIT_NAME,
	UNIT_DISPLAY_NAME
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
GType display_format_get_type (void) G_GNUC_CONST;
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
void serializer_set_leading_digits (Serializer* self, gint leading_digits);
GList* unit_get_symbols (Unit* self);
static Number* unit_solve_function (Unit* self, const gchar* function, Number* x);
Number* currency_manager_get_value (CurrencyManager* self, const gchar* currency);
Number* number_divide (Number* self, Number* y);
Number* number_multiply (Number* self, Number* y);
gchar* unit_format (Unit* self, Number* x);
gchar* serializer_to_string (Serializer* self, Number* x);
gpointer equation_ref (gpointer instance);
void equation_unref (gpointer instance);
GParamSpec* param_spec_equation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_equation (GValue* value, gpointer v_object);
void value_take_equation (GValue* value, gpointer v_object);
gpointer value_get_equation (const GValue* value);
GType equation_get_type (void) G_GNUC_CONST;
GType unit_solve_equation_get_type (void) G_GNUC_CONST;
UnitSolveEquation* unit_solve_equation_new (const gchar* function, Number* x);
UnitSolveEquation* unit_solve_equation_construct (GType object_type, const gchar* function, Number* x);
GType angle_unit_get_type (void) G_GNUC_CONST;
GType error_code_get_type (void) G_GNUC_CONST;
Number* equation_parse (Equation* self, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint** error_start, guint** error_end);
gchar* unit_get_display_name (Unit* self);
static void unit_finalize (GObject* obj);
static void _vala_unit_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define UNIT_SOLVE_EQUATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_UNIT_SOLVE_EQUATION, UnitSolveEquationPrivate))
enum  {
	UNIT_SOLVE_EQUATION_DUMMY_PROPERTY
};
Equation* equation_new (const gchar* expression);
Equation* equation_construct (GType object_type, const gchar* expression);
static gboolean unit_solve_equation_real_variable_is_defined (Equation* base, const gchar* name);
static Number* unit_solve_equation_real_get_variable (Equation* base, const gchar* name);
static void unit_solve_equation_finalize (Equation* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


UnitManager* unit_manager_construct (GType object_type) {
	UnitManager * self = NULL;
	self = (UnitManager*) g_object_new (object_type, NULL);
	__g_list_free__g_object_unref0_0 (self->priv->categories);
	self->priv->categories = NULL;
	return self;
}


UnitManager* unit_manager_new (void) {
	return unit_manager_construct (TYPE_UNIT_MANAGER);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint __lambda7_ (Currency* a, Currency* b) {
	gint result = 0;
	GCompareFunc _tmp0_ = NULL;
	Currency* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	Currency* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_strcmp0;
	_tmp1_ = a;
	_tmp2_ = currency_get_display_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = b;
	_tmp6_ = currency_get_display_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp0_ (_tmp4_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp4_);
	result = _tmp10_;
	return result;
}


static gint ___lambda7__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = __lambda7_ (a, b);
	return result;
}


UnitManager* unit_manager_get_default (void) {
	UnitManager* result = NULL;
	UnitManager* _tmp0_ = NULL;
	UnitManager* _tmp3_ = NULL;
	UnitCategory* angle_category = NULL;
	UnitManager* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	UnitCategory* _tmp6_ = NULL;
	UnitCategory* length_category = NULL;
	UnitManager* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	UnitCategory* _tmp9_ = NULL;
	UnitCategory* area_category = NULL;
	UnitManager* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	UnitCategory* _tmp12_ = NULL;
	UnitCategory* volume_category = NULL;
	UnitManager* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	UnitCategory* _tmp15_ = NULL;
	UnitCategory* weight_category = NULL;
	UnitManager* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	UnitCategory* _tmp18_ = NULL;
	UnitCategory* duration_category = NULL;
	UnitManager* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	UnitCategory* _tmp21_ = NULL;
	UnitCategory* temperature_category = NULL;
	UnitManager* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	UnitCategory* _tmp24_ = NULL;
	UnitCategory* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	Unit* _tmp29_ = NULL;
	Unit* _tmp30_ = NULL;
	UnitCategory* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	Unit* _tmp35_ = NULL;
	Unit* _tmp36_ = NULL;
	UnitCategory* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	Unit* _tmp41_ = NULL;
	Unit* _tmp42_ = NULL;
	UnitCategory* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	Unit* _tmp47_ = NULL;
	Unit* _tmp48_ = NULL;
	UnitCategory* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	Unit* _tmp53_ = NULL;
	Unit* _tmp54_ = NULL;
	UnitCategory* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	Unit* _tmp59_ = NULL;
	Unit* _tmp60_ = NULL;
	UnitCategory* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	Unit* _tmp65_ = NULL;
	Unit* _tmp66_ = NULL;
	UnitCategory* _tmp67_ = NULL;
	const gchar* _tmp68_ = NULL;
	const gchar* _tmp69_ = NULL;
	const gchar* _tmp70_ = NULL;
	Unit* _tmp71_ = NULL;
	Unit* _tmp72_ = NULL;
	UnitCategory* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	const gchar* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	Unit* _tmp77_ = NULL;
	Unit* _tmp78_ = NULL;
	UnitCategory* _tmp79_ = NULL;
	const gchar* _tmp80_ = NULL;
	const gchar* _tmp81_ = NULL;
	const gchar* _tmp82_ = NULL;
	Unit* _tmp83_ = NULL;
	Unit* _tmp84_ = NULL;
	UnitCategory* _tmp85_ = NULL;
	const gchar* _tmp86_ = NULL;
	const gchar* _tmp87_ = NULL;
	const gchar* _tmp88_ = NULL;
	Unit* _tmp89_ = NULL;
	Unit* _tmp90_ = NULL;
	UnitCategory* _tmp91_ = NULL;
	const gchar* _tmp92_ = NULL;
	const gchar* _tmp93_ = NULL;
	const gchar* _tmp94_ = NULL;
	Unit* _tmp95_ = NULL;
	Unit* _tmp96_ = NULL;
	UnitCategory* _tmp97_ = NULL;
	const gchar* _tmp98_ = NULL;
	const gchar* _tmp99_ = NULL;
	const gchar* _tmp100_ = NULL;
	Unit* _tmp101_ = NULL;
	Unit* _tmp102_ = NULL;
	UnitCategory* _tmp103_ = NULL;
	const gchar* _tmp104_ = NULL;
	const gchar* _tmp105_ = NULL;
	const gchar* _tmp106_ = NULL;
	Unit* _tmp107_ = NULL;
	Unit* _tmp108_ = NULL;
	UnitCategory* _tmp109_ = NULL;
	const gchar* _tmp110_ = NULL;
	const gchar* _tmp111_ = NULL;
	const gchar* _tmp112_ = NULL;
	Unit* _tmp113_ = NULL;
	Unit* _tmp114_ = NULL;
	UnitCategory* _tmp115_ = NULL;
	const gchar* _tmp116_ = NULL;
	const gchar* _tmp117_ = NULL;
	const gchar* _tmp118_ = NULL;
	Unit* _tmp119_ = NULL;
	Unit* _tmp120_ = NULL;
	UnitCategory* _tmp121_ = NULL;
	const gchar* _tmp122_ = NULL;
	const gchar* _tmp123_ = NULL;
	const gchar* _tmp124_ = NULL;
	Unit* _tmp125_ = NULL;
	Unit* _tmp126_ = NULL;
	UnitCategory* _tmp127_ = NULL;
	const gchar* _tmp128_ = NULL;
	const gchar* _tmp129_ = NULL;
	const gchar* _tmp130_ = NULL;
	Unit* _tmp131_ = NULL;
	Unit* _tmp132_ = NULL;
	UnitCategory* _tmp133_ = NULL;
	const gchar* _tmp134_ = NULL;
	const gchar* _tmp135_ = NULL;
	const gchar* _tmp136_ = NULL;
	Unit* _tmp137_ = NULL;
	Unit* _tmp138_ = NULL;
	UnitCategory* _tmp139_ = NULL;
	const gchar* _tmp140_ = NULL;
	const gchar* _tmp141_ = NULL;
	const gchar* _tmp142_ = NULL;
	Unit* _tmp143_ = NULL;
	Unit* _tmp144_ = NULL;
	UnitCategory* _tmp145_ = NULL;
	const gchar* _tmp146_ = NULL;
	const gchar* _tmp147_ = NULL;
	const gchar* _tmp148_ = NULL;
	Unit* _tmp149_ = NULL;
	Unit* _tmp150_ = NULL;
	UnitCategory* _tmp151_ = NULL;
	const gchar* _tmp152_ = NULL;
	const gchar* _tmp153_ = NULL;
	const gchar* _tmp154_ = NULL;
	Unit* _tmp155_ = NULL;
	Unit* _tmp156_ = NULL;
	UnitCategory* _tmp157_ = NULL;
	const gchar* _tmp158_ = NULL;
	const gchar* _tmp159_ = NULL;
	const gchar* _tmp160_ = NULL;
	Unit* _tmp161_ = NULL;
	Unit* _tmp162_ = NULL;
	UnitCategory* _tmp163_ = NULL;
	const gchar* _tmp164_ = NULL;
	const gchar* _tmp165_ = NULL;
	const gchar* _tmp166_ = NULL;
	Unit* _tmp167_ = NULL;
	Unit* _tmp168_ = NULL;
	UnitCategory* _tmp169_ = NULL;
	const gchar* _tmp170_ = NULL;
	const gchar* _tmp171_ = NULL;
	const gchar* _tmp172_ = NULL;
	Unit* _tmp173_ = NULL;
	Unit* _tmp174_ = NULL;
	UnitCategory* _tmp175_ = NULL;
	const gchar* _tmp176_ = NULL;
	const gchar* _tmp177_ = NULL;
	const gchar* _tmp178_ = NULL;
	Unit* _tmp179_ = NULL;
	Unit* _tmp180_ = NULL;
	UnitCategory* _tmp181_ = NULL;
	const gchar* _tmp182_ = NULL;
	const gchar* _tmp183_ = NULL;
	const gchar* _tmp184_ = NULL;
	Unit* _tmp185_ = NULL;
	Unit* _tmp186_ = NULL;
	UnitCategory* _tmp187_ = NULL;
	const gchar* _tmp188_ = NULL;
	const gchar* _tmp189_ = NULL;
	const gchar* _tmp190_ = NULL;
	Unit* _tmp191_ = NULL;
	Unit* _tmp192_ = NULL;
	UnitCategory* _tmp193_ = NULL;
	const gchar* _tmp194_ = NULL;
	const gchar* _tmp195_ = NULL;
	const gchar* _tmp196_ = NULL;
	Unit* _tmp197_ = NULL;
	Unit* _tmp198_ = NULL;
	UnitCategory* _tmp199_ = NULL;
	const gchar* _tmp200_ = NULL;
	const gchar* _tmp201_ = NULL;
	const gchar* _tmp202_ = NULL;
	Unit* _tmp203_ = NULL;
	Unit* _tmp204_ = NULL;
	UnitCategory* _tmp205_ = NULL;
	const gchar* _tmp206_ = NULL;
	const gchar* _tmp207_ = NULL;
	const gchar* _tmp208_ = NULL;
	Unit* _tmp209_ = NULL;
	Unit* _tmp210_ = NULL;
	UnitCategory* _tmp211_ = NULL;
	const gchar* _tmp212_ = NULL;
	const gchar* _tmp213_ = NULL;
	const gchar* _tmp214_ = NULL;
	Unit* _tmp215_ = NULL;
	Unit* _tmp216_ = NULL;
	UnitCategory* _tmp217_ = NULL;
	const gchar* _tmp218_ = NULL;
	const gchar* _tmp219_ = NULL;
	const gchar* _tmp220_ = NULL;
	Unit* _tmp221_ = NULL;
	Unit* _tmp222_ = NULL;
	UnitCategory* _tmp223_ = NULL;
	const gchar* _tmp224_ = NULL;
	const gchar* _tmp225_ = NULL;
	const gchar* _tmp226_ = NULL;
	Unit* _tmp227_ = NULL;
	Unit* _tmp228_ = NULL;
	UnitCategory* _tmp229_ = NULL;
	const gchar* _tmp230_ = NULL;
	const gchar* _tmp231_ = NULL;
	const gchar* _tmp232_ = NULL;
	Unit* _tmp233_ = NULL;
	Unit* _tmp234_ = NULL;
	UnitCategory* _tmp235_ = NULL;
	const gchar* _tmp236_ = NULL;
	const gchar* _tmp237_ = NULL;
	const gchar* _tmp238_ = NULL;
	Unit* _tmp239_ = NULL;
	Unit* _tmp240_ = NULL;
	UnitCategory* _tmp241_ = NULL;
	const gchar* _tmp242_ = NULL;
	const gchar* _tmp243_ = NULL;
	const gchar* _tmp244_ = NULL;
	Unit* _tmp245_ = NULL;
	Unit* _tmp246_ = NULL;
	UnitCategory* _tmp247_ = NULL;
	const gchar* _tmp248_ = NULL;
	const gchar* _tmp249_ = NULL;
	const gchar* _tmp250_ = NULL;
	Unit* _tmp251_ = NULL;
	Unit* _tmp252_ = NULL;
	UnitCategory* _tmp253_ = NULL;
	const gchar* _tmp254_ = NULL;
	const gchar* _tmp255_ = NULL;
	const gchar* _tmp256_ = NULL;
	Unit* _tmp257_ = NULL;
	Unit* _tmp258_ = NULL;
	UnitCategory* _tmp259_ = NULL;
	const gchar* _tmp260_ = NULL;
	const gchar* _tmp261_ = NULL;
	const gchar* _tmp262_ = NULL;
	Unit* _tmp263_ = NULL;
	Unit* _tmp264_ = NULL;
	UnitCategory* _tmp265_ = NULL;
	const gchar* _tmp266_ = NULL;
	const gchar* _tmp267_ = NULL;
	const gchar* _tmp268_ = NULL;
	Unit* _tmp269_ = NULL;
	Unit* _tmp270_ = NULL;
	UnitCategory* _tmp271_ = NULL;
	const gchar* _tmp272_ = NULL;
	const gchar* _tmp273_ = NULL;
	const gchar* _tmp274_ = NULL;
	Unit* _tmp275_ = NULL;
	Unit* _tmp276_ = NULL;
	UnitCategory* _tmp277_ = NULL;
	const gchar* _tmp278_ = NULL;
	const gchar* _tmp279_ = NULL;
	const gchar* _tmp280_ = NULL;
	Unit* _tmp281_ = NULL;
	Unit* _tmp282_ = NULL;
	UnitCategory* _tmp283_ = NULL;
	const gchar* _tmp284_ = NULL;
	const gchar* _tmp285_ = NULL;
	const gchar* _tmp286_ = NULL;
	Unit* _tmp287_ = NULL;
	Unit* _tmp288_ = NULL;
	UnitCategory* _tmp289_ = NULL;
	const gchar* _tmp290_ = NULL;
	const gchar* _tmp291_ = NULL;
	const gchar* _tmp292_ = NULL;
	Unit* _tmp293_ = NULL;
	Unit* _tmp294_ = NULL;
	UnitCategory* _tmp295_ = NULL;
	const gchar* _tmp296_ = NULL;
	const gchar* _tmp297_ = NULL;
	const gchar* _tmp298_ = NULL;
	Unit* _tmp299_ = NULL;
	Unit* _tmp300_ = NULL;
	UnitCategory* _tmp301_ = NULL;
	const gchar* _tmp302_ = NULL;
	const gchar* _tmp303_ = NULL;
	const gchar* _tmp304_ = NULL;
	Unit* _tmp305_ = NULL;
	Unit* _tmp306_ = NULL;
	UnitCategory* currency_category = NULL;
	UnitManager* _tmp307_ = NULL;
	const gchar* _tmp308_ = NULL;
	UnitCategory* _tmp309_ = NULL;
	GList* currencies = NULL;
	CurrencyManager* _tmp310_ = NULL;
	CurrencyManager* _tmp311_ = NULL;
	GList* _tmp312_ = NULL;
	GList* _tmp313_ = NULL;
	GList* _tmp314_ = NULL;
	UnitManager* _tmp340_ = NULL;
	UnitManager* _tmp341_ = NULL;
	_tmp0_ = default_unit_manager;
	if (_tmp0_ != NULL) {
		UnitManager* _tmp1_ = NULL;
		UnitManager* _tmp2_ = NULL;
		_tmp1_ = default_unit_manager;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = unit_manager_new ();
	_g_object_unref0 (default_unit_manager);
	default_unit_manager = _tmp3_;
	_tmp4_ = default_unit_manager;
	_tmp5_ = _ ("Angle");
	_tmp6_ = unit_manager_add_category (_tmp4_, "angle", _tmp5_);
	angle_category = _tmp6_;
	_tmp7_ = default_unit_manager;
	_tmp8_ = _ ("Length");
	_tmp9_ = unit_manager_add_category (_tmp7_, "length", _tmp8_);
	length_category = _tmp9_;
	_tmp10_ = default_unit_manager;
	_tmp11_ = _ ("Area");
	_tmp12_ = unit_manager_add_category (_tmp10_, "area", _tmp11_);
	area_category = _tmp12_;
	_tmp13_ = default_unit_manager;
	_tmp14_ = _ ("Volume");
	_tmp15_ = unit_manager_add_category (_tmp13_, "volume", _tmp14_);
	volume_category = _tmp15_;
	_tmp16_ = default_unit_manager;
	_tmp17_ = _ ("Weight");
	_tmp18_ = unit_manager_add_category (_tmp16_, "weight", _tmp17_);
	weight_category = _tmp18_;
	_tmp19_ = default_unit_manager;
	_tmp20_ = _ ("Duration");
	_tmp21_ = unit_manager_add_category (_tmp19_, "duration", _tmp20_);
	duration_category = _tmp21_;
	_tmp22_ = default_unit_manager;
	_tmp23_ = _ ("Temperature");
	_tmp24_ = unit_manager_add_category (_tmp22_, "temperature", _tmp23_);
	temperature_category = _tmp24_;
	_tmp25_ = angle_category;
	_tmp26_ = _ ("Degrees");
	_tmp27_ = g_dpgettext2 (NULL, "unit-format", "%s degrees");
	_tmp28_ = g_dpgettext2 (NULL, "unit-symbols", "degree,degrees,deg");
	_tmp29_ = unit_new ("degree", _tmp26_, _tmp27_, "π*x/180", "180x/π", _tmp28_);
	_tmp30_ = _tmp29_;
	unit_category_add_unit (_tmp25_, _tmp30_);
	_g_object_unref0 (_tmp30_);
	_tmp31_ = angle_category;
	_tmp32_ = _ ("Radians");
	_tmp33_ = g_dpgettext2 (NULL, "unit-format", "%s radians");
	_tmp34_ = g_dpgettext2 (NULL, "unit-symbols", "radian,radians,rad");
	_tmp35_ = unit_new ("radian", _tmp32_, _tmp33_, "x", "x", _tmp34_);
	_tmp36_ = _tmp35_;
	unit_category_add_unit (_tmp31_, _tmp36_);
	_g_object_unref0 (_tmp36_);
	_tmp37_ = angle_category;
	_tmp38_ = _ ("Gradians");
	_tmp39_ = g_dpgettext2 (NULL, "unit-format", "%s gradians");
	_tmp40_ = g_dpgettext2 (NULL, "unit-symbols", "gradian,gradians,grad");
	_tmp41_ = unit_new ("gradian", _tmp38_, _tmp39_, "π*x/200", "200x/π", _tmp40_);
	_tmp42_ = _tmp41_;
	unit_category_add_unit (_tmp37_, _tmp42_);
	_g_object_unref0 (_tmp42_);
	_tmp43_ = length_category;
	_tmp44_ = _ ("Parsecs");
	_tmp45_ = g_dpgettext2 (NULL, "unit-format", "%s pc");
	_tmp46_ = g_dpgettext2 (NULL, "unit-symbols", "parsec,parsecs,pc");
	_tmp47_ = unit_new ("parsec", _tmp44_, _tmp45_, "30857000000000000x", "x/30857000000000000", _tmp46_);
	_tmp48_ = _tmp47_;
	unit_category_add_unit (_tmp43_, _tmp48_);
	_g_object_unref0 (_tmp48_);
	_tmp49_ = length_category;
	_tmp50_ = _ ("Light Years");
	_tmp51_ = g_dpgettext2 (NULL, "unit-format", "%s ly");
	_tmp52_ = g_dpgettext2 (NULL, "unit-symbols", "lightyear,lightyears,ly");
	_tmp53_ = unit_new ("lightyear", _tmp50_, _tmp51_, "9460730472580800x", "x/9460730472580800", _tmp52_);
	_tmp54_ = _tmp53_;
	unit_category_add_unit (_tmp49_, _tmp54_);
	_g_object_unref0 (_tmp54_);
	_tmp55_ = length_category;
	_tmp56_ = _ ("Astronomical Units");
	_tmp57_ = g_dpgettext2 (NULL, "unit-format", "%s au");
	_tmp58_ = g_dpgettext2 (NULL, "unit-symbols", "au");
	_tmp59_ = unit_new ("astronomical-unit", _tmp56_, _tmp57_, "149597870691x", "x/149597870691", _tmp58_);
	_tmp60_ = _tmp59_;
	unit_category_add_unit (_tmp55_, _tmp60_);
	_g_object_unref0 (_tmp60_);
	_tmp61_ = length_category;
	_tmp62_ = _ ("Nautical Miles");
	_tmp63_ = g_dpgettext2 (NULL, "unit-format", "%s nmi");
	_tmp64_ = g_dpgettext2 (NULL, "unit-symbols", "nmi");
	_tmp65_ = unit_new ("nautical-mile", _tmp62_, _tmp63_, "1852x", "x/1852", _tmp64_);
	_tmp66_ = _tmp65_;
	unit_category_add_unit (_tmp61_, _tmp66_);
	_g_object_unref0 (_tmp66_);
	_tmp67_ = length_category;
	_tmp68_ = _ ("Miles");
	_tmp69_ = g_dpgettext2 (NULL, "unit-format", "%s mi");
	_tmp70_ = g_dpgettext2 (NULL, "unit-symbols", "mile,miles,mi");
	_tmp71_ = unit_new ("mile", _tmp68_, _tmp69_, "1609.344x", "x/1609.344", _tmp70_);
	_tmp72_ = _tmp71_;
	unit_category_add_unit (_tmp67_, _tmp72_);
	_g_object_unref0 (_tmp72_);
	_tmp73_ = length_category;
	_tmp74_ = _ ("Kilometers");
	_tmp75_ = g_dpgettext2 (NULL, "unit-format", "%s km");
	_tmp76_ = g_dpgettext2 (NULL, "unit-symbols", "kilometer,kilometers,km,kms");
	_tmp77_ = unit_new ("kilometer", _tmp74_, _tmp75_, "1000x", "x/1000", _tmp76_);
	_tmp78_ = _tmp77_;
	unit_category_add_unit (_tmp73_, _tmp78_);
	_g_object_unref0 (_tmp78_);
	_tmp79_ = length_category;
	_tmp80_ = _ ("Cables");
	_tmp81_ = g_dpgettext2 (NULL, "unit-format", "%s cb");
	_tmp82_ = g_dpgettext2 (NULL, "unit-symbols", "cable,cables,cb");
	_tmp83_ = unit_new ("cable", _tmp80_, _tmp81_, "219.456x", "x/219.456", _tmp82_);
	_tmp84_ = _tmp83_;
	unit_category_add_unit (_tmp79_, _tmp84_);
	_g_object_unref0 (_tmp84_);
	_tmp85_ = length_category;
	_tmp86_ = _ ("Fathoms");
	_tmp87_ = g_dpgettext2 (NULL, "unit-format", "%s ftm");
	_tmp88_ = g_dpgettext2 (NULL, "unit-symbols", "fathom,fathoms,ftm");
	_tmp89_ = unit_new ("fathom", _tmp86_, _tmp87_, "1.8288x", "x/1.8288", _tmp88_);
	_tmp90_ = _tmp89_;
	unit_category_add_unit (_tmp85_, _tmp90_);
	_g_object_unref0 (_tmp90_);
	_tmp91_ = length_category;
	_tmp92_ = _ ("Meters");
	_tmp93_ = g_dpgettext2 (NULL, "unit-format", "%s m");
	_tmp94_ = g_dpgettext2 (NULL, "unit-symbols", "meter,meters,m");
	_tmp95_ = unit_new ("meter", _tmp92_, _tmp93_, "x", "x", _tmp94_);
	_tmp96_ = _tmp95_;
	unit_category_add_unit (_tmp91_, _tmp96_);
	_g_object_unref0 (_tmp96_);
	_tmp97_ = length_category;
	_tmp98_ = _ ("Yards");
	_tmp99_ = g_dpgettext2 (NULL, "unit-format", "%s yd");
	_tmp100_ = g_dpgettext2 (NULL, "unit-symbols", "yard,yards,yd");
	_tmp101_ = unit_new ("yard", _tmp98_, _tmp99_, "0.9144x", "x/0.9144", _tmp100_);
	_tmp102_ = _tmp101_;
	unit_category_add_unit (_tmp97_, _tmp102_);
	_g_object_unref0 (_tmp102_);
	_tmp103_ = length_category;
	_tmp104_ = _ ("Feet");
	_tmp105_ = g_dpgettext2 (NULL, "unit-format", "%s ft");
	_tmp106_ = g_dpgettext2 (NULL, "unit-symbols", "foot,feet,ft");
	_tmp107_ = unit_new ("foot", _tmp104_, _tmp105_, "0.3048x", "x/0.3048", _tmp106_);
	_tmp108_ = _tmp107_;
	unit_category_add_unit (_tmp103_, _tmp108_);
	_g_object_unref0 (_tmp108_);
	_tmp109_ = length_category;
	_tmp110_ = _ ("Inches");
	_tmp111_ = g_dpgettext2 (NULL, "unit-format", "%s in");
	_tmp112_ = g_dpgettext2 (NULL, "unit-symbols", "inch,inches,in");
	_tmp113_ = unit_new ("inch", _tmp110_, _tmp111_, "0.0254x", "x/0.0254", _tmp112_);
	_tmp114_ = _tmp113_;
	unit_category_add_unit (_tmp109_, _tmp114_);
	_g_object_unref0 (_tmp114_);
	_tmp115_ = length_category;
	_tmp116_ = _ ("Centimeters");
	_tmp117_ = g_dpgettext2 (NULL, "unit-format", "%s cm");
	_tmp118_ = g_dpgettext2 (NULL, "unit-symbols", "centimeter,centimeters,cm,cms");
	_tmp119_ = unit_new ("centimeter", _tmp116_, _tmp117_, "x/100", "100x", _tmp118_);
	_tmp120_ = _tmp119_;
	unit_category_add_unit (_tmp115_, _tmp120_);
	_g_object_unref0 (_tmp120_);
	_tmp121_ = length_category;
	_tmp122_ = _ ("Millimeters");
	_tmp123_ = g_dpgettext2 (NULL, "unit-format", "%s mm");
	_tmp124_ = g_dpgettext2 (NULL, "unit-symbols", "millimeter,millimeters,mm");
	_tmp125_ = unit_new ("millimeter", _tmp122_, _tmp123_, "x/1000", "1000x", _tmp124_);
	_tmp126_ = _tmp125_;
	unit_category_add_unit (_tmp121_, _tmp126_);
	_g_object_unref0 (_tmp126_);
	_tmp127_ = length_category;
	_tmp128_ = _ ("Micrometers");
	_tmp129_ = g_dpgettext2 (NULL, "unit-format", "%s μm");
	_tmp130_ = g_dpgettext2 (NULL, "unit-symbols", "micrometer,micrometers,um");
	_tmp131_ = unit_new ("micrometer", _tmp128_, _tmp129_, "x/1000000", "1000000x", _tmp130_);
	_tmp132_ = _tmp131_;
	unit_category_add_unit (_tmp127_, _tmp132_);
	_g_object_unref0 (_tmp132_);
	_tmp133_ = length_category;
	_tmp134_ = _ ("Nanometers");
	_tmp135_ = g_dpgettext2 (NULL, "unit-format", "%s nm");
	_tmp136_ = g_dpgettext2 (NULL, "unit-symbols", "nanometer,nanometers,nm");
	_tmp137_ = unit_new ("nanometer", _tmp134_, _tmp135_, "x/1000000000", "1000000000x", _tmp136_);
	_tmp138_ = _tmp137_;
	unit_category_add_unit (_tmp133_, _tmp138_);
	_g_object_unref0 (_tmp138_);
	_tmp139_ = area_category;
	_tmp140_ = _ ("Hectares");
	_tmp141_ = g_dpgettext2 (NULL, "unit-format", "%s ha");
	_tmp142_ = g_dpgettext2 (NULL, "unit-symbols", "hectare,hectares,ha");
	_tmp143_ = unit_new ("hectare", _tmp140_, _tmp141_, "10000x", "x/10000", _tmp142_);
	_tmp144_ = _tmp143_;
	unit_category_add_unit (_tmp139_, _tmp144_);
	_g_object_unref0 (_tmp144_);
	_tmp145_ = area_category;
	_tmp146_ = _ ("Acres");
	_tmp147_ = g_dpgettext2 (NULL, "unit-format", "%s acres");
	_tmp148_ = g_dpgettext2 (NULL, "unit-symbols", "acre,acres");
	_tmp149_ = unit_new ("acre", _tmp146_, _tmp147_, "4046.8564224x", "x/4046.8564224", _tmp148_);
	_tmp150_ = _tmp149_;
	unit_category_add_unit (_tmp145_, _tmp150_);
	_g_object_unref0 (_tmp150_);
	_tmp151_ = area_category;
	_tmp152_ = _ ("Square Meters");
	_tmp153_ = g_dpgettext2 (NULL, "unit-format", "%s m²");
	_tmp154_ = g_dpgettext2 (NULL, "unit-symbols", "m²");
	_tmp155_ = unit_new ("square-meter", _tmp152_, _tmp153_, "x", "x", _tmp154_);
	_tmp156_ = _tmp155_;
	unit_category_add_unit (_tmp151_, _tmp156_);
	_g_object_unref0 (_tmp156_);
	_tmp157_ = area_category;
	_tmp158_ = _ ("Square Centimeters");
	_tmp159_ = g_dpgettext2 (NULL, "unit-format", "%s cm²");
	_tmp160_ = g_dpgettext2 (NULL, "unit-symbols", "cm²");
	_tmp161_ = unit_new ("square-centimeter", _tmp158_, _tmp159_, "0.0001x", "10000x", _tmp160_);
	_tmp162_ = _tmp161_;
	unit_category_add_unit (_tmp157_, _tmp162_);
	_g_object_unref0 (_tmp162_);
	_tmp163_ = area_category;
	_tmp164_ = _ ("Square Millimeters");
	_tmp165_ = g_dpgettext2 (NULL, "unit-format", "%s mm²");
	_tmp166_ = g_dpgettext2 (NULL, "unit-symbols", "mm²");
	_tmp167_ = unit_new ("square-millimeter", _tmp164_, _tmp165_, "0.000001x", "1000000x", _tmp166_);
	_tmp168_ = _tmp167_;
	unit_category_add_unit (_tmp163_, _tmp168_);
	_g_object_unref0 (_tmp168_);
	_tmp169_ = volume_category;
	_tmp170_ = _ ("Cubic Meters");
	_tmp171_ = g_dpgettext2 (NULL, "unit-format", "%s m³");
	_tmp172_ = g_dpgettext2 (NULL, "unit-symbols", "m³");
	_tmp173_ = unit_new ("cubic-meter", _tmp170_, _tmp171_, "1000x", "x/1000", _tmp172_);
	_tmp174_ = _tmp173_;
	unit_category_add_unit (_tmp169_, _tmp174_);
	_g_object_unref0 (_tmp174_);
	_tmp175_ = volume_category;
	_tmp176_ = _ ("Gallons");
	_tmp177_ = g_dpgettext2 (NULL, "unit-format", "%s gal");
	_tmp178_ = g_dpgettext2 (NULL, "unit-symbols", "gallon,gallons,gal");
	_tmp179_ = unit_new ("gallon", _tmp176_, _tmp177_, "3.785412x", "x/3.785412", _tmp178_);
	_tmp180_ = _tmp179_;
	unit_category_add_unit (_tmp175_, _tmp180_);
	_g_object_unref0 (_tmp180_);
	_tmp181_ = volume_category;
	_tmp182_ = _ ("Liters");
	_tmp183_ = g_dpgettext2 (NULL, "unit-format", "%s L");
	_tmp184_ = g_dpgettext2 (NULL, "unit-symbols", "litre,litres,liter,liters,L");
	_tmp185_ = unit_new ("litre", _tmp182_, _tmp183_, "x", "x", _tmp184_);
	_tmp186_ = _tmp185_;
	unit_category_add_unit (_tmp181_, _tmp186_);
	_g_object_unref0 (_tmp186_);
	_tmp187_ = volume_category;
	_tmp188_ = _ ("Quarts");
	_tmp189_ = g_dpgettext2 (NULL, "unit-format", "%s qt");
	_tmp190_ = g_dpgettext2 (NULL, "unit-symbols", "quart,quarts,qt");
	_tmp191_ = unit_new ("quart", _tmp188_, _tmp189_, "0.9463529x", "x/0.9463529", _tmp190_);
	_tmp192_ = _tmp191_;
	unit_category_add_unit (_tmp187_, _tmp192_);
	_g_object_unref0 (_tmp192_);
	_tmp193_ = volume_category;
	_tmp194_ = _ ("Pints");
	_tmp195_ = g_dpgettext2 (NULL, "unit-format", "%s pt");
	_tmp196_ = g_dpgettext2 (NULL, "unit-symbols", "pint,pints,pt");
	_tmp197_ = unit_new ("pint", _tmp194_, _tmp195_, "0.4731765x", "x/0.4731765", _tmp196_);
	_tmp198_ = _tmp197_;
	unit_category_add_unit (_tmp193_, _tmp198_);
	_g_object_unref0 (_tmp198_);
	_tmp199_ = volume_category;
	_tmp200_ = _ ("Milliliters");
	_tmp201_ = g_dpgettext2 (NULL, "unit-format", "%s mL");
	_tmp202_ = g_dpgettext2 (NULL, "unit-symbols", "millilitre,millilitres,milliliter,milliliters,mL,cm³");
	_tmp203_ = unit_new ("millilitre", _tmp200_, _tmp201_, "0.001x", "1000x", _tmp202_);
	_tmp204_ = _tmp203_;
	unit_category_add_unit (_tmp199_, _tmp204_);
	_g_object_unref0 (_tmp204_);
	_tmp205_ = volume_category;
	_tmp206_ = _ ("Microliters");
	_tmp207_ = g_dpgettext2 (NULL, "unit-format", "%s μL");
	_tmp208_ = g_dpgettext2 (NULL, "unit-symbols", "mm³,μL,uL");
	_tmp209_ = unit_new ("microlitre", _tmp206_, _tmp207_, "0.000001x", "1000000x", _tmp208_);
	_tmp210_ = _tmp209_;
	unit_category_add_unit (_tmp205_, _tmp210_);
	_g_object_unref0 (_tmp210_);
	_tmp211_ = weight_category;
	_tmp212_ = _ ("Tonnes");
	_tmp213_ = g_dpgettext2 (NULL, "unit-format", "%s T");
	_tmp214_ = g_dpgettext2 (NULL, "unit-symbols", "tonne,tonnes");
	_tmp215_ = unit_new ("tonne", _tmp212_, _tmp213_, "1000x", "x/1000", _tmp214_);
	_tmp216_ = _tmp215_;
	unit_category_add_unit (_tmp211_, _tmp216_);
	_g_object_unref0 (_tmp216_);
	_tmp217_ = weight_category;
	_tmp218_ = _ ("Kilograms");
	_tmp219_ = g_dpgettext2 (NULL, "unit-format", "%s kg");
	_tmp220_ = g_dpgettext2 (NULL, "unit-symbols", "kilogram,kilograms,kilogramme,kilogrammes,kg,kgs");
	_tmp221_ = unit_new ("kilograms", _tmp218_, _tmp219_, "x", "x", _tmp220_);
	_tmp222_ = _tmp221_;
	unit_category_add_unit (_tmp217_, _tmp222_);
	_g_object_unref0 (_tmp222_);
	_tmp223_ = weight_category;
	_tmp224_ = _ ("Pounds");
	_tmp225_ = g_dpgettext2 (NULL, "unit-format", "%s lb");
	_tmp226_ = g_dpgettext2 (NULL, "unit-symbols", "pound,pounds,lb");
	_tmp227_ = unit_new ("pound", _tmp224_, _tmp225_, "0.45359237x", "x/0.45359237", _tmp226_);
	_tmp228_ = _tmp227_;
	unit_category_add_unit (_tmp223_, _tmp228_);
	_g_object_unref0 (_tmp228_);
	_tmp229_ = weight_category;
	_tmp230_ = _ ("Ounces");
	_tmp231_ = g_dpgettext2 (NULL, "unit-format", "%s oz");
	_tmp232_ = g_dpgettext2 (NULL, "unit-symbols", "ounce,ounces,oz");
	_tmp233_ = unit_new ("ounce", _tmp230_, _tmp231_, "0.02834952x", "x/0.02834952", _tmp232_);
	_tmp234_ = _tmp233_;
	unit_category_add_unit (_tmp229_, _tmp234_);
	_g_object_unref0 (_tmp234_);
	_tmp235_ = weight_category;
	_tmp236_ = _ ("Grams");
	_tmp237_ = g_dpgettext2 (NULL, "unit-format", "%s g");
	_tmp238_ = g_dpgettext2 (NULL, "unit-symbols", "gram,grams,gramme,grammes,g");
	_tmp239_ = unit_new ("gram", _tmp236_, _tmp237_, "0.001x", "1000x", _tmp238_);
	_tmp240_ = _tmp239_;
	unit_category_add_unit (_tmp235_, _tmp240_);
	_g_object_unref0 (_tmp240_);
	_tmp241_ = duration_category;
	_tmp242_ = _ ("Years");
	_tmp243_ = g_dpgettext2 (NULL, "unit-format", "%s years");
	_tmp244_ = g_dpgettext2 (NULL, "unit-symbols", "year,years");
	_tmp245_ = unit_new ("year", _tmp242_, _tmp243_, "31557600x", "x/31557600", _tmp244_);
	_tmp246_ = _tmp245_;
	unit_category_add_unit (_tmp241_, _tmp246_);
	_g_object_unref0 (_tmp246_);
	_tmp247_ = duration_category;
	_tmp248_ = _ ("Days");
	_tmp249_ = g_dpgettext2 (NULL, "unit-format", "%s days");
	_tmp250_ = g_dpgettext2 (NULL, "unit-symbols", "day,days");
	_tmp251_ = unit_new ("day", _tmp248_, _tmp249_, "86400x", "x/86400", _tmp250_);
	_tmp252_ = _tmp251_;
	unit_category_add_unit (_tmp247_, _tmp252_);
	_g_object_unref0 (_tmp252_);
	_tmp253_ = duration_category;
	_tmp254_ = _ ("Hours");
	_tmp255_ = g_dpgettext2 (NULL, "unit-format", "%s hours");
	_tmp256_ = g_dpgettext2 (NULL, "unit-symbols", "hour,hours");
	_tmp257_ = unit_new ("hour", _tmp254_, _tmp255_, "3600x", "x/3600", _tmp256_);
	_tmp258_ = _tmp257_;
	unit_category_add_unit (_tmp253_, _tmp258_);
	_g_object_unref0 (_tmp258_);
	_tmp259_ = duration_category;
	_tmp260_ = _ ("Minutes");
	_tmp261_ = g_dpgettext2 (NULL, "unit-format", "%s minutes");
	_tmp262_ = g_dpgettext2 (NULL, "unit-symbols", "minute,minutes");
	_tmp263_ = unit_new ("minute", _tmp260_, _tmp261_, "60x", "x/60", _tmp262_);
	_tmp264_ = _tmp263_;
	unit_category_add_unit (_tmp259_, _tmp264_);
	_g_object_unref0 (_tmp264_);
	_tmp265_ = duration_category;
	_tmp266_ = _ ("Seconds");
	_tmp267_ = g_dpgettext2 (NULL, "unit-format", "%s s");
	_tmp268_ = g_dpgettext2 (NULL, "unit-symbols", "second,seconds,s");
	_tmp269_ = unit_new ("second", _tmp266_, _tmp267_, "x", "x", _tmp268_);
	_tmp270_ = _tmp269_;
	unit_category_add_unit (_tmp265_, _tmp270_);
	_g_object_unref0 (_tmp270_);
	_tmp271_ = duration_category;
	_tmp272_ = _ ("Milliseconds");
	_tmp273_ = g_dpgettext2 (NULL, "unit-format", "%s ms");
	_tmp274_ = g_dpgettext2 (NULL, "unit-symbols", "millisecond,milliseconds,ms");
	_tmp275_ = unit_new ("millisecond", _tmp272_, _tmp273_, "0.001x", "1000x", _tmp274_);
	_tmp276_ = _tmp275_;
	unit_category_add_unit (_tmp271_, _tmp276_);
	_g_object_unref0 (_tmp276_);
	_tmp277_ = duration_category;
	_tmp278_ = _ ("Microseconds");
	_tmp279_ = g_dpgettext2 (NULL, "unit-format", "%s μs");
	_tmp280_ = g_dpgettext2 (NULL, "unit-symbols", "microsecond,microseconds,us,μs");
	_tmp281_ = unit_new ("microsecond", _tmp278_, _tmp279_, "0.000001x", "1000000x", _tmp280_);
	_tmp282_ = _tmp281_;
	unit_category_add_unit (_tmp277_, _tmp282_);
	_g_object_unref0 (_tmp282_);
	_tmp283_ = temperature_category;
	_tmp284_ = _ ("Celsius");
	_tmp285_ = g_dpgettext2 (NULL, "unit-format", "%s ˚C");
	_tmp286_ = g_dpgettext2 (NULL, "unit-symbols", "degC,˚C");
	_tmp287_ = unit_new ("degree-celcius", _tmp284_, _tmp285_, "x+273.15", "x-273.15", _tmp286_);
	_tmp288_ = _tmp287_;
	unit_category_add_unit (_tmp283_, _tmp288_);
	_g_object_unref0 (_tmp288_);
	_tmp289_ = temperature_category;
	_tmp290_ = _ ("Fahrenheit");
	_tmp291_ = g_dpgettext2 (NULL, "unit-format", "%s ˚F");
	_tmp292_ = g_dpgettext2 (NULL, "unit-symbols", "degF,˚F");
	_tmp293_ = unit_new ("degree-farenheit", _tmp290_, _tmp291_, "(x+459.67)*5/9", "x*9/5-459.67", _tmp292_);
	_tmp294_ = _tmp293_;
	unit_category_add_unit (_tmp289_, _tmp294_);
	_g_object_unref0 (_tmp294_);
	_tmp295_ = temperature_category;
	_tmp296_ = _ ("Kelvin");
	_tmp297_ = g_dpgettext2 (NULL, "unit-format", "%s K");
	_tmp298_ = g_dpgettext2 (NULL, "unit-symbols", "K");
	_tmp299_ = unit_new ("degree-kelvin", _tmp296_, _tmp297_, "x", "x", _tmp298_);
	_tmp300_ = _tmp299_;
	unit_category_add_unit (_tmp295_, _tmp300_);
	_g_object_unref0 (_tmp300_);
	_tmp301_ = temperature_category;
	_tmp302_ = _ ("Rankine");
	_tmp303_ = g_dpgettext2 (NULL, "unit-format", "%s ˚R");
	_tmp304_ = g_dpgettext2 (NULL, "unit-symbols", "degR,˚R,˚Ra");
	_tmp305_ = unit_new ("degree-rankine", _tmp302_, _tmp303_, "x*5/9", "x*9/5", _tmp304_);
	_tmp306_ = _tmp305_;
	unit_category_add_unit (_tmp301_, _tmp306_);
	_g_object_unref0 (_tmp306_);
	_tmp307_ = default_unit_manager;
	_tmp308_ = _ ("Currency");
	_tmp309_ = unit_manager_add_category (_tmp307_, "currency", _tmp308_);
	currency_category = _tmp309_;
	_tmp310_ = currency_manager_get_default ();
	_tmp311_ = _tmp310_;
	_tmp312_ = currency_manager_get_currencies (_tmp311_);
	_tmp313_ = _tmp312_;
	_g_object_unref0 (_tmp311_);
	currencies = _tmp313_;
	currencies = g_list_sort (currencies, ___lambda7__gcompare_func);
	_tmp314_ = currencies;
	{
		GList* currency_collection = NULL;
		GList* currency_it = NULL;
		currency_collection = _tmp314_;
		for (currency_it = currency_collection; currency_it != NULL; currency_it = currency_it->next) {
			Currency* _tmp315_ = NULL;
			Currency* currency = NULL;
			_tmp315_ = _g_object_ref0 ((Currency*) currency_it->data);
			currency = _tmp315_;
			{
				gchar* format = NULL;
				const gchar* _tmp316_ = NULL;
				Currency* _tmp317_ = NULL;
				gchar* _tmp318_ = NULL;
				gchar* _tmp319_ = NULL;
				gchar* _tmp320_ = NULL;
				gchar* _tmp321_ = NULL;
				gchar* _tmp322_ = NULL;
				Unit* unit = NULL;
				Currency* _tmp323_ = NULL;
				gchar* _tmp324_ = NULL;
				gchar* _tmp325_ = NULL;
				gchar* _tmp326_ = NULL;
				Currency* _tmp327_ = NULL;
				gchar* _tmp328_ = NULL;
				gchar* _tmp329_ = NULL;
				gchar* _tmp330_ = NULL;
				const gchar* _tmp331_ = NULL;
				Currency* _tmp332_ = NULL;
				gchar* _tmp333_ = NULL;
				gchar* _tmp334_ = NULL;
				gchar* _tmp335_ = NULL;
				Unit* _tmp336_ = NULL;
				Unit* _tmp337_ = NULL;
				UnitCategory* _tmp338_ = NULL;
				Unit* _tmp339_ = NULL;
				_tmp316_ = _ ("%s%%s");
				_tmp317_ = currency;
				_tmp318_ = currency_get_symbol (_tmp317_);
				_tmp319_ = _tmp318_;
				_tmp320_ = _tmp319_;
				_tmp321_ = g_strdup_printf (_tmp316_, _tmp320_);
				_tmp322_ = _tmp321_;
				_g_free0 (_tmp320_);
				format = _tmp322_;
				_tmp323_ = currency;
				_tmp324_ = currency_get_name (_tmp323_);
				_tmp325_ = _tmp324_;
				_tmp326_ = _tmp325_;
				_tmp327_ = currency;
				_tmp328_ = currency_get_display_name (_tmp327_);
				_tmp329_ = _tmp328_;
				_tmp330_ = _tmp329_;
				_tmp331_ = format;
				_tmp332_ = currency;
				_tmp333_ = currency_get_name (_tmp332_);
				_tmp334_ = _tmp333_;
				_tmp335_ = _tmp334_;
				_tmp336_ = unit_new (_tmp326_, _tmp330_, _tmp331_, NULL, NULL, _tmp335_);
				_tmp337_ = _tmp336_;
				_g_free0 (_tmp335_);
				_g_free0 (_tmp330_);
				_g_free0 (_tmp326_);
				unit = _tmp337_;
				_tmp338_ = currency_category;
				_tmp339_ = unit;
				unit_category_add_unit (_tmp338_, _tmp339_);
				_g_object_unref0 (unit);
				_g_free0 (format);
				_g_object_unref0 (currency);
			}
		}
	}
	_tmp340_ = default_unit_manager;
	_tmp341_ = _g_object_ref0 (_tmp340_);
	result = _tmp341_;
	__g_list_free__g_object_unref0_0 (currencies);
	_g_object_unref0 (currency_category);
	_g_object_unref0 (temperature_category);
	_g_object_unref0 (duration_category);
	_g_object_unref0 (weight_category);
	_g_object_unref0 (volume_category);
	_g_object_unref0 (area_category);
	_g_object_unref0 (length_category);
	_g_object_unref0 (angle_category);
	return result;
}


UnitCategory* unit_manager_add_category (UnitManager* self, const gchar* name, const gchar* display_name) {
	UnitCategory* result = NULL;
	UnitCategory* category = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	UnitCategory* _tmp2_ = NULL;
	UnitCategory* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = display_name;
	_tmp2_ = unit_category_new (_tmp0_, _tmp1_);
	category = _tmp2_;
	_tmp3_ = _g_object_ref0 (category);
	self->priv->categories = g_list_append (self->priv->categories, _tmp3_);
	result = category;
	return result;
}


GList* unit_manager_get_categories (UnitManager* self) {
	GList* result = NULL;
	GList* r = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	r = NULL;
	_tmp0_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp1_ = NULL;
			UnitCategory* c = NULL;
			_tmp1_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp1_;
			{
				UnitCategory* _tmp2_ = NULL;
				UnitCategory* _tmp3_ = NULL;
				_tmp2_ = c;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				r = g_list_append (r, _tmp3_);
				_g_object_unref0 (c);
			}
		}
	}
	result = r;
	return result;
}


UnitCategory* unit_manager_get_category (UnitManager* self, const gchar* category) {
	UnitCategory* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (category != NULL, NULL);
	_tmp0_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp1_ = NULL;
			UnitCategory* c = NULL;
			_tmp1_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp1_;
			{
				UnitCategory* _tmp2_ = NULL;
				gchar* _tmp3_ = NULL;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				_tmp2_ = c;
				_tmp3_ = unit_category_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = _tmp4_;
				_tmp6_ = category;
				_tmp7_ = g_strcmp0 (_tmp5_, _tmp6_) == 0;
				_g_free0 (_tmp5_);
				if (_tmp7_) {
					result = c;
					return result;
				}
				_g_object_unref0 (c);
			}
		}
	}
	result = NULL;
	return result;
}


Unit* unit_manager_get_unit_by_name (UnitManager* self, const gchar* name) {
	Unit* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp1_ = NULL;
			UnitCategory* c = NULL;
			_tmp1_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp1_;
			{
				Unit* u = NULL;
				UnitCategory* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				Unit* _tmp4_ = NULL;
				Unit* _tmp5_ = NULL;
				_tmp2_ = c;
				_tmp3_ = name;
				_tmp4_ = unit_category_get_unit_by_name (_tmp2_, _tmp3_);
				u = _tmp4_;
				_tmp5_ = u;
				if (_tmp5_ != NULL) {
					result = u;
					_g_object_unref0 (c);
					return result;
				}
				_g_object_unref0 (u);
				_g_object_unref0 (c);
			}
		}
	}
	result = NULL;
	return result;
}


Unit* unit_manager_get_unit_by_symbol (UnitManager* self, const gchar* symbol) {
	Unit* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp1_ = NULL;
			UnitCategory* c = NULL;
			_tmp1_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp1_;
			{
				Unit* u = NULL;
				UnitCategory* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				Unit* _tmp4_ = NULL;
				Unit* _tmp5_ = NULL;
				_tmp2_ = c;
				_tmp3_ = symbol;
				_tmp4_ = unit_category_get_unit_by_symbol (_tmp2_, _tmp3_);
				u = _tmp4_;
				_tmp5_ = u;
				if (_tmp5_ != NULL) {
					result = u;
					_g_object_unref0 (c);
					return result;
				}
				_g_object_unref0 (u);
				_g_object_unref0 (c);
			}
		}
	}
	result = NULL;
	return result;
}


Number* unit_manager_convert_by_symbol (UnitManager* self, Number* x, const gchar* x_symbol, const gchar* z_symbol) {
	Number* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_symbol != NULL, NULL);
	g_return_val_if_fail (z_symbol != NULL, NULL);
	_tmp0_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp1_ = NULL;
			UnitCategory* c = NULL;
			_tmp1_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp1_;
			{
				Unit* x_units = NULL;
				UnitCategory* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				Unit* _tmp4_ = NULL;
				Unit* z_units = NULL;
				UnitCategory* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				Unit* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				Unit* _tmp9_ = NULL;
				gboolean _tmp11_ = FALSE;
				_tmp2_ = c;
				_tmp3_ = x_symbol;
				_tmp4_ = unit_category_get_unit_by_symbol (_tmp2_, _tmp3_);
				x_units = _tmp4_;
				_tmp5_ = c;
				_tmp6_ = z_symbol;
				_tmp7_ = unit_category_get_unit_by_symbol (_tmp5_, _tmp6_);
				z_units = _tmp7_;
				_tmp9_ = x_units;
				if (_tmp9_ != NULL) {
					Unit* _tmp10_ = NULL;
					_tmp10_ = z_units;
					_tmp8_ = _tmp10_ != NULL;
				} else {
					_tmp8_ = FALSE;
				}
				_tmp11_ = _tmp8_;
				if (_tmp11_) {
					UnitCategory* _tmp12_ = NULL;
					Number* _tmp13_ = NULL;
					Unit* _tmp14_ = NULL;
					Unit* _tmp15_ = NULL;
					Number* _tmp16_ = NULL;
					_tmp12_ = c;
					_tmp13_ = x;
					_tmp14_ = x_units;
					_tmp15_ = z_units;
					_tmp16_ = unit_category_convert (_tmp12_, _tmp13_, _tmp14_, _tmp15_);
					result = _tmp16_;
					_g_object_unref0 (z_units);
					_g_object_unref0 (x_units);
					_g_object_unref0 (c);
					return result;
				}
				_g_object_unref0 (z_units);
				_g_object_unref0 (x_units);
				_g_object_unref0 (c);
			}
		}
	}
	result = NULL;
	return result;
}


static void unit_manager_class_init (UnitManagerClass * klass) {
	unit_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnitManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = unit_manager_finalize;
}


static void unit_manager_instance_init (UnitManager * self) {
	self->priv = UNIT_MANAGER_GET_PRIVATE (self);
}


static void unit_manager_finalize (GObject* obj) {
	UnitManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNIT_MANAGER, UnitManager);
	__g_list_free__g_object_unref0_0 (self->priv->categories);
	G_OBJECT_CLASS (unit_manager_parent_class)->finalize (obj);
}


GType unit_manager_get_type (void) {
	static volatile gsize unit_manager_type_id__volatile = 0;
	if (g_once_init_enter (&unit_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnitManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unit_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnitManager), 0, (GInstanceInitFunc) unit_manager_instance_init, NULL };
		GType unit_manager_type_id;
		unit_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "UnitManager", &g_define_type_info, 0);
		g_once_init_leave (&unit_manager_type_id__volatile, unit_manager_type_id);
	}
	return unit_manager_type_id__volatile;
}


UnitCategory* unit_category_construct (GType object_type, const gchar* name, const gchar* display_name) {
	UnitCategory * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	self = (UnitCategory*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	_tmp2_ = display_name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp3_;
	__g_list_free__g_object_unref0_0 (self->priv->units);
	self->priv->units = NULL;
	return self;
}


UnitCategory* unit_category_new (const gchar* name, const gchar* display_name) {
	return unit_category_construct (TYPE_UNIT_CATEGORY, name, display_name);
}


void unit_category_add_unit (UnitCategory* self, Unit* unit) {
	Unit* _tmp0_ = NULL;
	Unit* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unit != NULL);
	_tmp0_ = unit;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	self->priv->units = g_list_append (self->priv->units, _tmp1_);
}


Unit* unit_category_get_unit_by_name (UnitCategory* self, const gchar* name) {
	Unit* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->units;
	{
		GList* unit_collection = NULL;
		GList* unit_it = NULL;
		unit_collection = _tmp0_;
		for (unit_it = unit_collection; unit_it != NULL; unit_it = unit_it->next) {
			Unit* _tmp1_ = NULL;
			Unit* unit = NULL;
			_tmp1_ = _g_object_ref0 ((Unit*) unit_it->data);
			unit = _tmp1_;
			{
				Unit* _tmp2_ = NULL;
				gchar* _tmp3_ = NULL;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				_tmp2_ = unit;
				_tmp3_ = unit_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = _tmp4_;
				_tmp6_ = name;
				_tmp7_ = g_strcmp0 (_tmp5_, _tmp6_) == 0;
				_g_free0 (_tmp5_);
				if (_tmp7_) {
					result = unit;
					return result;
				}
				_g_object_unref0 (unit);
			}
		}
	}
	result = NULL;
	return result;
}


Unit* unit_category_get_unit_by_symbol (UnitCategory* self, const gchar* symbol) {
	Unit* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = self->priv->units;
	{
		GList* unit_collection = NULL;
		GList* unit_it = NULL;
		unit_collection = _tmp0_;
		for (unit_it = unit_collection; unit_it != NULL; unit_it = unit_it->next) {
			Unit* _tmp1_ = NULL;
			Unit* unit = NULL;
			_tmp1_ = _g_object_ref0 ((Unit*) unit_it->data);
			unit = _tmp1_;
			{
				Unit* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				_tmp2_ = unit;
				_tmp3_ = symbol;
				_tmp4_ = unit_matches_symbol (_tmp2_, _tmp3_);
				if (_tmp4_) {
					result = unit;
					return result;
				}
				_g_object_unref0 (unit);
			}
		}
	}
	result = NULL;
	return result;
}


GList* unit_category_get_units (UnitCategory* self) {
	GList* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->units;
	result = _tmp0_;
	return result;
}


Number* unit_category_convert (UnitCategory* self, Number* x, Unit* x_units, Unit* z_units) {
	Number* result = NULL;
	Number* t = NULL;
	Unit* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Unit* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_units != NULL, NULL);
	g_return_val_if_fail (z_units != NULL, NULL);
	_tmp0_ = x_units;
	_tmp1_ = x;
	_tmp2_ = unit_convert_from (_tmp0_, _tmp1_);
	t = _tmp2_;
	_tmp3_ = t;
	if (_tmp3_ == NULL) {
		result = NULL;
		_number_unref0 (t);
		return result;
	}
	_tmp4_ = z_units;
	_tmp5_ = t;
	_tmp6_ = unit_convert_to (_tmp4_, _tmp5_);
	result = _tmp6_;
	_number_unref0 (t);
	return result;
}


gchar* unit_category_get_name (UnitCategory* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* unit_category_get_display_name (UnitCategory* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void unit_category_class_init (UnitCategoryClass * klass) {
	unit_category_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnitCategoryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unit_category_get_property;
	G_OBJECT_CLASS (klass)->finalize = unit_category_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIT_CATEGORY_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIT_CATEGORY_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void unit_category_instance_init (UnitCategory * self) {
	self->priv = UNIT_CATEGORY_GET_PRIVATE (self);
}


static void unit_category_finalize (GObject* obj) {
	UnitCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNIT_CATEGORY, UnitCategory);
	__g_list_free__g_object_unref0_0 (self->priv->units);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_display_name);
	G_OBJECT_CLASS (unit_category_parent_class)->finalize (obj);
}


GType unit_category_get_type (void) {
	static volatile gsize unit_category_type_id__volatile = 0;
	if (g_once_init_enter (&unit_category_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnitCategoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unit_category_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnitCategory), 0, (GInstanceInitFunc) unit_category_instance_init, NULL };
		GType unit_category_type_id;
		unit_category_type_id = g_type_register_static (G_TYPE_OBJECT, "UnitCategory", &g_define_type_info, 0);
		g_once_init_leave (&unit_category_type_id__volatile, unit_category_type_id);
	}
	return unit_category_type_id__volatile;
}


static void _vala_unit_category_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnitCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNIT_CATEGORY, UnitCategory);
	switch (property_id) {
		case UNIT_CATEGORY_NAME:
		g_value_take_string (value, unit_category_get_name (self));
		break;
		case UNIT_CATEGORY_DISPLAY_NAME:
		g_value_take_string (value, unit_category_get_display_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


Unit* unit_construct (GType object_type, const gchar* name, const gchar* display_name, const gchar* format, const gchar* from_function, const gchar* to_function, const gchar* symbols) {
	Unit * self = NULL;
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar** symbol_names = NULL;
	const gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint symbol_names_length1 = 0;
	gint _symbol_names_size_ = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	g_return_val_if_fail (format != NULL, NULL);
	g_return_val_if_fail (symbols != NULL, NULL);
	self = (Unit*) g_object_new (object_type, NULL);
	_tmp0_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 2);
	_g_object_unref0 (self->priv->serializer);
	self->priv->serializer = _tmp0_;
	_tmp1_ = self->priv->serializer;
	serializer_set_leading_digits (_tmp1_, 6);
	_tmp2_ = name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp3_;
	_tmp4_ = display_name;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp5_;
	_tmp6_ = format;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->priv->_format);
	self->priv->_format = _tmp7_;
	_tmp8_ = from_function;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (self->priv->from_function);
	self->priv->from_function = _tmp9_;
	_tmp10_ = to_function;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (self->priv->to_function);
	self->priv->to_function = _tmp11_;
	__g_list_free__g_free0_0 (self->priv->_symbols);
	self->priv->_symbols = NULL;
	_tmp12_ = symbols;
	_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, ",", 0);
	symbol_names = _tmp14_;
	symbol_names_length1 = _vala_array_length (_tmp13_);
	_symbol_names_size_ = symbol_names_length1;
	_tmp15_ = symbol_names;
	_tmp15__length1 = symbol_names_length1;
	{
		gchar** symbol_name_collection = NULL;
		gint symbol_name_collection_length1 = 0;
		gint _symbol_name_collection_size_ = 0;
		gint symbol_name_it = 0;
		symbol_name_collection = _tmp15_;
		symbol_name_collection_length1 = _tmp15__length1;
		for (symbol_name_it = 0; symbol_name_it < _tmp15__length1; symbol_name_it = symbol_name_it + 1) {
			gchar* _tmp16_ = NULL;
			gchar* symbol_name = NULL;
			_tmp16_ = g_strdup (symbol_name_collection[symbol_name_it]);
			symbol_name = _tmp16_;
			{
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				_tmp17_ = symbol_name;
				_tmp18_ = g_strdup (_tmp17_);
				self->priv->_symbols = g_list_append (self->priv->_symbols, _tmp18_);
				_g_free0 (symbol_name);
			}
		}
	}
	symbol_names = (_vala_array_free (symbol_names, symbol_names_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


Unit* unit_new (const gchar* name, const gchar* display_name, const gchar* format, const gchar* from_function, const gchar* to_function, const gchar* symbols) {
	return unit_construct (TYPE_UNIT, name, display_name, format, from_function, to_function, symbols);
}


gboolean unit_matches_symbol (Unit* self, const gchar* symbol) {
	gboolean result = FALSE;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (symbol != NULL, FALSE);
	_tmp0_ = self->priv->_symbols;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp0_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp1_ = NULL;
			gchar* s = NULL;
			_tmp1_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp1_;
			{
				const gchar* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				_tmp2_ = s;
				_tmp3_ = symbol;
				if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
					result = TRUE;
					_g_free0 (s);
					return result;
				}
				_g_free0 (s);
			}
		}
	}
	result = FALSE;
	return result;
}


GList* unit_get_symbols (Unit* self) {
	GList* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_symbols;
	result = _tmp0_;
	return result;
}


Number* unit_convert_from (Unit* self, Number* x) {
	Number* result = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = self->priv->from_function;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
		_tmp1_ = self->priv->from_function;
		_tmp2_ = x;
		_tmp3_ = unit_solve_function (self, _tmp1_, _tmp2_);
		result = _tmp3_;
		return result;
	} else {
		Number* r = NULL;
		CurrencyManager* _tmp4_ = NULL;
		CurrencyManager* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		_tmp4_ = currency_manager_get_default ();
		_tmp5_ = _tmp4_;
		_tmp6_ = unit_get_name (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = currency_manager_get_value (_tmp5_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_g_object_unref0 (_tmp5_);
		r = _tmp10_;
		_tmp11_ = r;
		if (_tmp11_ == NULL) {
			result = NULL;
			_number_unref0 (r);
			return result;
		}
		_tmp12_ = x;
		_tmp13_ = r;
		_tmp14_ = number_divide (_tmp12_, _tmp13_);
		result = _tmp14_;
		_number_unref0 (r);
		return result;
	}
}


Number* unit_convert_to (Unit* self, Number* x) {
	Number* result = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = self->priv->to_function;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
		_tmp1_ = self->priv->to_function;
		_tmp2_ = x;
		_tmp3_ = unit_solve_function (self, _tmp1_, _tmp2_);
		result = _tmp3_;
		return result;
	} else {
		Number* r = NULL;
		CurrencyManager* _tmp4_ = NULL;
		CurrencyManager* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		_tmp4_ = currency_manager_get_default ();
		_tmp5_ = _tmp4_;
		_tmp6_ = unit_get_name (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = currency_manager_get_value (_tmp5_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_g_object_unref0 (_tmp5_);
		r = _tmp10_;
		_tmp11_ = r;
		if (_tmp11_ == NULL) {
			result = NULL;
			_number_unref0 (r);
			return result;
		}
		_tmp12_ = x;
		_tmp13_ = r;
		_tmp14_ = number_multiply (_tmp12_, _tmp13_);
		result = _tmp14_;
		_number_unref0 (r);
		return result;
	}
}


gchar* unit_format (Unit* self, Number* x) {
	gchar* result = NULL;
	gchar* number_text = NULL;
	Serializer* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = self->priv->serializer;
	_tmp1_ = x;
	_tmp2_ = serializer_to_string (_tmp0_, _tmp1_);
	number_text = _tmp2_;
	_tmp3_ = self->priv->_format;
	_tmp4_ = g_strdup_printf (_tmp3_, number_text);
	result = _tmp4_;
	_g_free0 (number_text);
	return result;
}


static Number* unit_solve_function (Unit* self, const gchar* function, Number* x) {
	Number* result = NULL;
	UnitSolveEquation* equation = NULL;
	const gchar* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	UnitSolveEquation* _tmp2_ = NULL;
	UnitSolveEquation* _tmp3_ = NULL;
	UnitSolveEquation* _tmp4_ = NULL;
	Number* z = NULL;
	UnitSolveEquation* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (function != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = function;
	_tmp1_ = x;
	_tmp2_ = unit_solve_equation_new (_tmp0_, _tmp1_);
	equation = _tmp2_;
	_tmp3_ = equation;
	((Equation*) _tmp3_)->base = 10;
	_tmp4_ = equation;
	((Equation*) _tmp4_)->wordlen = 32;
	_tmp5_ = equation;
	_tmp6_ = equation_parse ((Equation*) _tmp5_, NULL, NULL, NULL, NULL, NULL);
	z = _tmp6_;
	_tmp7_ = z;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = function;
		g_warning ("unit.vala:301: Failed to convert value: %s", _tmp8_);
	}
	result = z;
	_equation_unref0 (equation);
	return result;
}


gchar* unit_get_name (Unit* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* unit_get_display_name (Unit* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void unit_class_init (UnitClass * klass) {
	unit_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnitPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unit_get_property;
	G_OBJECT_CLASS (klass)->finalize = unit_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIT_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIT_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void unit_instance_init (Unit * self) {
	self->priv = UNIT_GET_PRIVATE (self);
}


static void unit_finalize (GObject* obj) {
	Unit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNIT, Unit);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_format);
	__g_list_free__g_free0_0 (self->priv->_symbols);
	_g_free0 (self->priv->from_function);
	_g_free0 (self->priv->to_function);
	_g_object_unref0 (self->priv->serializer);
	G_OBJECT_CLASS (unit_parent_class)->finalize (obj);
}


GType unit_get_type (void) {
	static volatile gsize unit_type_id__volatile = 0;
	if (g_once_init_enter (&unit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Unit), 0, (GInstanceInitFunc) unit_instance_init, NULL };
		GType unit_type_id;
		unit_type_id = g_type_register_static (G_TYPE_OBJECT, "Unit", &g_define_type_info, 0);
		g_once_init_leave (&unit_type_id__volatile, unit_type_id);
	}
	return unit_type_id__volatile;
}


static void _vala_unit_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Unit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNIT, Unit);
	switch (property_id) {
		case UNIT_NAME:
		g_value_take_string (value, unit_get_name (self));
		break;
		case UNIT_DISPLAY_NAME:
		g_value_take_string (value, unit_get_display_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _number_ref0 (gpointer self) {
	return self ? number_ref (self) : NULL;
}


UnitSolveEquation* unit_solve_equation_construct (GType object_type, const gchar* function, Number* x) {
	UnitSolveEquation* self = NULL;
	const gchar* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	g_return_val_if_fail (function != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = function;
	self = (UnitSolveEquation*) equation_construct (object_type, _tmp0_);
	_tmp1_ = x;
	_tmp2_ = _number_ref0 (_tmp1_);
	_number_unref0 (self->priv->x);
	self->priv->x = _tmp2_;
	return self;
}


UnitSolveEquation* unit_solve_equation_new (const gchar* function, Number* x) {
	return unit_solve_equation_construct (TYPE_UNIT_SOLVE_EQUATION, function, x);
}


static gboolean unit_solve_equation_real_variable_is_defined (Equation* base, const gchar* name) {
	UnitSolveEquation * self;
	gboolean result = FALSE;
	self = (UnitSolveEquation*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	result = TRUE;
	return result;
}


static Number* unit_solve_equation_real_get_variable (Equation* base, const gchar* name) {
	UnitSolveEquation * self;
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	self = (UnitSolveEquation*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->x;
	_tmp1_ = _number_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void unit_solve_equation_class_init (UnitSolveEquationClass * klass) {
	unit_solve_equation_parent_class = g_type_class_peek_parent (klass);
	EQUATION_CLASS (klass)->finalize = unit_solve_equation_finalize;
	g_type_class_add_private (klass, sizeof (UnitSolveEquationPrivate));
	EQUATION_CLASS (klass)->variable_is_defined = unit_solve_equation_real_variable_is_defined;
	EQUATION_CLASS (klass)->get_variable = unit_solve_equation_real_get_variable;
}


static void unit_solve_equation_instance_init (UnitSolveEquation * self) {
	self->priv = UNIT_SOLVE_EQUATION_GET_PRIVATE (self);
}


static void unit_solve_equation_finalize (Equation* obj) {
	UnitSolveEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNIT_SOLVE_EQUATION, UnitSolveEquation);
	_number_unref0 (self->priv->x);
	EQUATION_CLASS (unit_solve_equation_parent_class)->finalize (obj);
}


GType unit_solve_equation_get_type (void) {
	static volatile gsize unit_solve_equation_type_id__volatile = 0;
	if (g_once_init_enter (&unit_solve_equation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnitSolveEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unit_solve_equation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnitSolveEquation), 0, (GInstanceInitFunc) unit_solve_equation_instance_init, NULL };
		GType unit_solve_equation_type_id;
		unit_solve_equation_type_id = g_type_register_static (TYPE_EQUATION, "UnitSolveEquation", &g_define_type_info, 0);
		g_once_init_leave (&unit_solve_equation_type_id__volatile, unit_solve_equation_type_id);
	}
	return unit_solve_equation_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



