/* math-display.c generated by valac 0.28.0.14-080be, the Vala compiler
 * generated from math-display.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksource.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <atk/atk.h>
#include <gdk/gdk.h>


#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;
typedef struct _MathDisplayPrivate MathDisplayPrivate;

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;

#define TYPE_HISTORY_VIEW (history_view_get_type ())
#define HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_VIEW, HistoryView))
#define HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_VIEW, HistoryViewClass))
#define IS_HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_VIEW))
#define IS_HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_VIEW))
#define HISTORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_VIEW, HistoryViewClass))

typedef struct _HistoryView HistoryView;
typedef struct _HistoryViewClass HistoryViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;

#define TYPE_FUNCTION_COMPLETION_PROVIDER (function_completion_provider_get_type ())
#define FUNCTION_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProvider))
#define FUNCTION_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProviderClass))
#define IS_FUNCTION_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER))
#define IS_FUNCTION_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_COMPLETION_PROVIDER))
#define FUNCTION_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProviderClass))

typedef struct _FunctionCompletionProvider FunctionCompletionProvider;
typedef struct _FunctionCompletionProviderClass FunctionCompletionProviderClass;

#define TYPE_VARIABLE_COMPLETION_PROVIDER (variable_completion_provider_get_type ())
#define VARIABLE_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProvider))
#define VARIABLE_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderClass))
#define IS_VARIABLE_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER))
#define IS_VARIABLE_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VARIABLE_COMPLETION_PROVIDER))
#define VARIABLE_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderClass))

typedef struct _VariableCompletionProvider VariableCompletionProvider;
typedef struct _VariableCompletionProviderClass VariableCompletionProviderClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MATH_FUNCTION (math_function_get_type ())
#define MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_FUNCTION, MathFunction))
#define MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_FUNCTION, MathFunctionClass))
#define IS_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_FUNCTION))
#define IS_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_FUNCTION))
#define MATH_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_FUNCTION, MathFunctionClass))

typedef struct _MathFunction MathFunction;
typedef struct _MathFunctionClass MathFunctionClass;

#define TYPE_MATH_VARIABLES (math_variables_get_type ())
#define MATH_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_VARIABLES, MathVariables))
#define MATH_VARIABLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_VARIABLES, MathVariablesClass))
#define IS_MATH_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_VARIABLES))
#define IS_MATH_VARIABLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_VARIABLES))
#define MATH_VARIABLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_VARIABLES, MathVariablesClass))

typedef struct _MathVariables MathVariables;
typedef struct _MathVariablesClass MathVariablesClass;
#define __vala_GdkEventKey_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventKey_free (var), NULL)))

#define TYPE_NUMBER_MODE (number_mode_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _CompletionProviderPrivate CompletionProviderPrivate;
typedef struct _FunctionCompletionProviderPrivate FunctionCompletionProviderPrivate;

#define TYPE_FUNCTION_MANAGER (function_manager_get_type ())
#define FUNCTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_MANAGER, FunctionManager))
#define FUNCTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_MANAGER, FunctionManagerClass))
#define IS_FUNCTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_MANAGER))
#define IS_FUNCTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_MANAGER))
#define FUNCTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_MANAGER, FunctionManagerClass))

typedef struct _FunctionManager FunctionManager;
typedef struct _FunctionManagerClass FunctionManagerClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _VariableCompletionProviderPrivate VariableCompletionProviderPrivate;

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;

struct _MathDisplay {
	GtkViewport parent_instance;
	MathDisplayPrivate * priv;
};

struct _MathDisplayClass {
	GtkViewportClass parent_class;
};

struct _MathDisplayPrivate {
	MathEquation* _equation;
	HistoryView* history;
	GtkSourceView* source_view;
	GtkTextBuffer* info_buffer;
	GtkSpinner* spinner;
};

typedef enum  {
	NUMBER_MODE_NORMAL,
	NUMBER_MODE_SUPERSCRIPT,
	NUMBER_MODE_SUBSCRIPT
} NumberMode;

struct _CompletionProvider {
	GObject parent_instance;
	CompletionProviderPrivate * priv;
};

struct _CompletionProviderClass {
	GObjectClass parent_class;
	gchar* (*get_name) (CompletionProvider* self);
	gboolean (*get_start_iter) (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
	gboolean (*activate_proposal) (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
	void (*populate) (CompletionProvider* self, GtkSourceCompletionContext* context);
};

struct _FunctionCompletionProvider {
	CompletionProvider parent_instance;
	FunctionCompletionProviderPrivate * priv;
};

struct _FunctionCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _VariableCompletionProvider {
	CompletionProvider parent_instance;
	VariableCompletionProviderPrivate * priv;
};

struct _VariableCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _VariableCompletionProviderPrivate {
	MathEquation* _equation;
};


static gpointer math_display_parent_class = NULL;
static gpointer completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderIface* completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static gpointer function_completion_provider_parent_class = NULL;
static gpointer variable_completion_provider_parent_class = NULL;

GType math_display_get_type (void) G_GNUC_CONST;
GType math_equation_get_type (void) G_GNUC_CONST;
GType history_view_get_type (void) G_GNUC_CONST;
#define MATH_DISPLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_DISPLAY, MathDisplayPrivate))
enum  {
	MATH_DISPLAY_DUMMY_PROPERTY,
	MATH_DISPLAY_EQUATION
};
MathDisplay* math_display_new (MathEquation* equation);
MathDisplay* math_display_construct (GType object_type, MathEquation* equation);
GType number_get_type (void) G_GNUC_CONST;
void math_display_handler (MathDisplay* self, const gchar* answer, Number* number, gint number_base, guint representation_base);
static void _math_display_handler_math_equation_history_signal (MathEquation* _sender, const gchar* answer, Number* number, gint number_base, guint representation_base, gpointer self);
HistoryView* history_view_new (MathDisplay* display, GtkBox* box);
HistoryView* history_view_construct (GType object_type, MathDisplay* display, GtkBox* box);
static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self);
static gboolean math_display_key_press_cb (MathDisplay* self, GdkEventKey* event);
static gboolean _math_display_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void math_display_create_autocompletion (MathDisplay* self);
static void __lambda11_ (MathDisplay* self, GParamSpec* pspec);
static void math_display_status_changed_cb (MathDisplay* self);
static void ___lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda12_ (MathDisplay* self, GParamSpec* pspec);
static void math_display_error_status_changed_cb (MathDisplay* self);
static void ___lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
void math_display_grabfocus (MathDisplay* self);
void math_display_update_history (MathDisplay* self, const gchar* answer, Number* number, gint number_base, guint representation_base);
void math_display_display_text (MathDisplay* self, const gchar* prev_eq);
void math_equation_display_selected (MathEquation* self, const gchar* selected);
void history_view_insert_entry (HistoryView* self, const gchar* equation, Number* answer, gint number_base, guint representation_base);
void math_display_insert_text (MathDisplay* self, const gchar* answer);
void math_equation_insert_selected (MathEquation* self, const gchar* answer);
FunctionCompletionProvider* function_completion_provider_new (void);
FunctionCompletionProvider* function_completion_provider_construct (GType object_type);
GType completion_provider_get_type (void) G_GNUC_CONST;
GType function_completion_provider_get_type (void) G_GNUC_CONST;
MathEquation* math_display_get_equation (MathDisplay* self);
VariableCompletionProvider* variable_completion_provider_new (MathEquation* equation);
VariableCompletionProvider* variable_completion_provider_construct (GType object_type, MathEquation* equation);
GType variable_completion_provider_get_type (void) G_GNUC_CONST;
static gboolean math_display_function_completion_window_visible (MathDisplay* self);
GType math_function_get_type (void) G_GNUC_CONST;
MathFunction** function_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer, int* result_length1);
GType math_variables_get_type (void) G_GNUC_CONST;
gchar** variable_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer, MathVariables* variables, int* result_length1);
MathVariables* math_equation_get_variables (MathEquation* self);
static gboolean math_display_real_key_press_event (GtkWidget* base, GdkEventKey* event);
static GdkEventKey* _vala_GdkEventKey_copy (GdkEventKey* self);
static void _vala_GdkEventKey_free (GdkEventKey* self);
void math_equation_solve (MathEquation* self);
void math_equation_clear (MathEquation* self);
void math_equation_insert_numeric_point (MathEquation* self);
void math_equation_insert (MathEquation* self, const gchar* text);
void math_equation_insert_subtract (MathEquation* self);
void math_equation_insert_exponent (MathEquation* self);
void math_equation_factorize (MathEquation* self);
GType number_mode_get_type (void) G_GNUC_CONST;
NumberMode math_equation_get_number_mode (MathEquation* self);
gchar* math_equation_get_status (MathEquation* self);
gboolean math_equation_get_in_solve (MathEquation* self);
guint math_equation_get_error_token_end (MathEquation* self);
guint math_equation_get_error_token_start (MathEquation* self);
void math_display_grab_focus (MathDisplay* self);
static void math_display_finalize (GObject* obj);
static void _vala_math_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
enum  {
	COMPLETION_PROVIDER_DUMMY_PROPERTY
};
gchar* completion_provider_get_name (CompletionProvider* self);
static gchar* completion_provider_real_get_name (CompletionProvider* self);
void completion_provider_move_iter_to_name_start (GtkTextIter* iter);
gboolean completion_provider_get_start_iter (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static gboolean completion_provider_real_get_start_iter (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
gboolean completion_provider_activate_proposal (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static gboolean completion_provider_real_activate_proposal (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
void completion_provider_populate (CompletionProvider* self, GtkSourceCompletionContext* context);
static void completion_provider_real_populate (CompletionProvider* self, GtkSourceCompletionContext* context);
CompletionProvider* completion_provider_new (void);
CompletionProvider* completion_provider_construct (GType object_type);
enum  {
	FUNCTION_COMPLETION_PROVIDER_DUMMY_PROPERTY
};
static gchar* function_completion_provider_real_get_name (CompletionProvider* base);
GType function_manager_get_type (void) G_GNUC_CONST;
FunctionManager* function_manager_get_default_function_manager (void);
MathFunction** function_manager_functions_eligible_for_autocompletion_for_text (FunctionManager* self, const gchar* display_text, int* result_length1);
static void function_completion_provider_real_populate (CompletionProvider* base, GtkSourceCompletionContext* context);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
const gchar* math_function_get_name (MathFunction* self);
gchar** math_function_get_arguments (MathFunction* self, int* result_length1);
const gchar* math_function_get_description (MathFunction* self);
gboolean math_function_is_custom_function (MathFunction* self);
const gchar* math_function_get_expression (MathFunction* self);
#define VARIABLE_COMPLETION_PROVIDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderPrivate))
enum  {
	VARIABLE_COMPLETION_PROVIDER_DUMMY_PROPERTY
};
static gchar* variable_completion_provider_real_get_name (CompletionProvider* base);
gchar** math_variables_variables_eligible_for_autocompletion (MathVariables* self, const gchar* text, int* result_length1);
static void variable_completion_provider_real_populate (CompletionProvider* base, GtkSourceCompletionContext* context);
GType serializer_get_type (void) G_GNUC_CONST;
Serializer* math_equation_get_serializer (MathEquation* self);
gchar* serializer_to_string (Serializer* self, Number* x);
Number* math_variables_get (MathVariables* self, const gchar* name);
static void variable_completion_provider_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return self ? g_object_ref (self) : NULL;
#line 327 "math-display.c"
}


static void _math_display_handler_math_equation_history_signal (MathEquation* _sender, const gchar* answer, Number* number, gint number_base, guint representation_base, gpointer self) {
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	math_display_handler ((MathDisplay*) self, answer, number, number_base, representation_base);
#line 334 "math-display.c"
}


static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self) {
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return g_boxed_copy (pango_font_description_get_type (), self);
#line 341 "math-display.c"
}


static gpointer __vala_PangoFontDescription_copy0 (gpointer self) {
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return self ? _vala_PangoFontDescription_copy (self) : NULL;
#line 348 "math-display.c"
}


static gboolean _math_display_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = math_display_key_press_cb ((MathDisplay*) self, event);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return result;
#line 357 "math-display.c"
}


static void __lambda11_ (MathDisplay* self, GParamSpec* pspec) {
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (pspec != NULL);
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	math_display_status_changed_cb (self);
#line 366 "math-display.c"
}


static void ___lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	__lambda11_ ((MathDisplay*) self, pspec);
#line 373 "math-display.c"
}


static void __lambda12_ (MathDisplay* self, GParamSpec* pspec) {
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (pspec != NULL);
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	math_display_error_status_changed_cb (self);
#line 382 "math-display.c"
}


static void ___lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	__lambda12_ ((MathDisplay*) self, pspec);
#line 389 "math-display.c"
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_boxed_free (pango_font_description_get_type (), self);
#line 396 "math-display.c"
}


MathDisplay* math_display_construct (GType object_type, MathEquation* equation) {
	MathDisplay * self = NULL;
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
	GtkBox* main_box = NULL;
	GtkBox* _tmp3_ = NULL;
	HistoryView* _tmp4_ = NULL;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp5_ = NULL;
	MathEquation* _tmp6_ = NULL;
	GtkSourceView* _tmp7_ = NULL;
	GtkSourceView* _tmp8_ = NULL;
	GtkSourceView* _tmp9_ = NULL;
	GtkSourceView* _tmp10_ = NULL;
	GtkSourceView* _tmp11_ = NULL;
	PangoFontDescription* font_desc = NULL;
	GtkSourceView* _tmp12_ = NULL;
	GtkStyleContext* _tmp13_ = NULL;
	PangoFontDescription* _tmp14_ = NULL;
	PangoFontDescription* _tmp15_ = NULL;
	GtkSourceView* _tmp16_ = NULL;
	GtkSourceView* _tmp17_ = NULL;
	GtkSourceView* _tmp18_ = NULL;
	GtkSourceView* _tmp19_ = NULL;
	AtkObject* _tmp20_ = NULL;
	GtkSourceView* _tmp21_ = NULL;
	GtkSourceView* _tmp22_ = NULL;
	GtkBox* info_box = NULL;
	GtkBox* _tmp23_ = NULL;
	GtkTextView* info_view = NULL;
	GtkTextView* _tmp24_ = NULL;
	GtkTextBuffer* _tmp25_ = NULL;
	GtkTextBuffer* _tmp26_ = NULL;
	GtkSpinner* _tmp27_ = NULL;
	GtkSpinner* _tmp28_ = NULL;
	GtkSourceView* _tmp29_ = NULL;
	MathEquation* _tmp30_ = NULL;
	MathEquation* _tmp31_ = NULL;
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (equation != NULL, NULL);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self = (MathDisplay*) g_object_new (object_type, NULL);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = equation;
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (self->priv->_equation);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self->priv->_equation = _tmp1_;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp2_ = self->priv->_equation;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_signal_connect_object (_tmp2_, "history-signal", (GCallback) _math_display_handler_math_equation_history_signal, self, 0);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_object_ref_sink (_tmp3_);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	main_box = _tmp3_;
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_box);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp4_ = history_view_new (self, main_box);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_object_ref_sink (_tmp4_);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (self->priv->history);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self->priv->history = _tmp4_;
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp5_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_object_ref_sink (_tmp5_);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	scrolled_window = _tmp5_;
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_scrolled_window_set_policy (scrolled_window, GTK_POLICY_AUTOMATIC, GTK_POLICY_NEVER);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp6_ = equation;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp7_ = (GtkSourceView*) gtk_source_view_new_with_buffer ((GtkSourceBuffer*) _tmp6_);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_object_ref_sink (_tmp7_);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (self->priv->source_view);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self->priv->source_view = _tmp7_;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp8_ = self->priv->source_view;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_view_set_accepts_tab ((GtkTextView*) _tmp8_, FALSE);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp9_ = self->priv->source_view;
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_view_set_pixels_above_lines ((GtkTextView*) _tmp9_, 8);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp10_ = self->priv->source_view;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_view_set_pixels_below_lines ((GtkTextView*) _tmp10_, 2);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp11_ = self->priv->source_view;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_view_set_justification ((GtkTextView*) _tmp11_, GTK_JUSTIFY_RIGHT);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp12_ = self->priv->source_view;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp14_ = gtk_style_context_get_font (_tmp13_, GTK_STATE_FLAG_NORMAL);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp15_ = __vala_PangoFontDescription_copy0 (_tmp14_);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	font_desc = _tmp15_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	pango_font_description_set_size (font_desc, 16 * PANGO_SCALE);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp16_ = self->priv->source_view;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_widget_override_font ((GtkWidget*) _tmp16_, font_desc);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp17_ = self->priv->source_view;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_buildable_set_name ((GtkBuildable*) _tmp17_, "displayitem");
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp18_ = self->priv->source_view;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp18_, 20, 20);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp19_ = self->priv->source_view;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp20_ = gtk_widget_get_accessible ((GtkWidget*) _tmp19_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	atk_object_set_role (_tmp20_, ATK_ROLE_EDITBAR);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp21_ = self->priv->source_view;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_signal_connect_object ((GtkWidget*) _tmp21_, "key-press-event", (GCallback) _math_display_key_press_cb_gtk_widget_key_press_event, self, 0);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	math_display_create_autocompletion (self);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_box_pack_start (main_box, (GtkWidget*) scrolled_window, FALSE, FALSE, (guint) 0);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp22_ = self->priv->source_view;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_container_add ((GtkContainer*) scrolled_window, (GtkWidget*) _tmp22_);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_widget_show ((GtkWidget*) scrolled_window);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp23_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_object_ref_sink (_tmp23_);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	info_box = _tmp23_;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_box_pack_start (main_box, (GtkWidget*) info_box, FALSE, TRUE, (guint) 0);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp24_ = (GtkTextView*) gtk_text_view_new ();
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_object_ref_sink (_tmp24_);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	info_view = _tmp24_;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_view_set_wrap_mode (info_view, GTK_WRAP_WORD);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_widget_set_can_focus ((GtkWidget*) info_view, FALSE);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_view_set_editable (info_view, FALSE);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_view_set_justification (info_view, GTK_JUSTIFY_RIGHT);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_box_pack_start (info_box, (GtkWidget*) info_view, TRUE, TRUE, (guint) 0);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp25_ = gtk_text_view_get_buffer (info_view);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp26_ = _g_object_ref0 (_tmp25_);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (self->priv->info_buffer);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self->priv->info_buffer = _tmp26_;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp27_ = (GtkSpinner*) gtk_spinner_new ();
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_object_ref_sink (_tmp27_);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (self->priv->spinner);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self->priv->spinner = _tmp27_;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp28_ = self->priv->spinner;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_box_pack_end (info_box, (GtkWidget*) _tmp28_, FALSE, FALSE, (guint) 0);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_widget_show ((GtkWidget*) info_box);
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_widget_show ((GtkWidget*) info_view);
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp29_ = self->priv->source_view;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_widget_show ((GtkWidget*) _tmp29_);
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_widget_show ((GtkWidget*) main_box);
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp30_ = equation;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_signal_connect_object ((GObject*) _tmp30_, "notify::status", (GCallback) ___lambda11__g_object_notify, self, 0);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	math_display_status_changed_cb (self);
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp31_ = equation;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_signal_connect_object ((GObject*) _tmp31_, "notify::error-token-end", (GCallback) ___lambda12__g_object_notify, self, 0);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (info_view);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (info_box);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	__vala_PangoFontDescription_free0 (font_desc);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (scrolled_window);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (main_box);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return self;
#line 625 "math-display.c"
}


MathDisplay* math_display_new (MathEquation* equation) {
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return math_display_construct (TYPE_MATH_DISPLAY, equation);
#line 632 "math-display.c"
}


void math_display_grabfocus (MathDisplay* self) {
	GtkSourceView* _tmp0_ = NULL;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (self != NULL);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = self->priv->source_view;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
#line 644 "math-display.c"
}


void math_display_handler (MathDisplay* self, const gchar* answer, Number* number, gint number_base, guint representation_base) {
	const gchar* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	guint _tmp3_ = 0U;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (self != NULL);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (answer != NULL);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (number != NULL);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = answer;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp1_ = number;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp2_ = number_base;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp3_ = representation_base;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	math_display_update_history (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 669 "math-display.c"
}


void math_display_display_text (MathDisplay* self, const gchar* prev_eq) {
	MathEquation* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (self != NULL);
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (prev_eq != NULL);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = self->priv->_equation;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp1_ = prev_eq;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	math_equation_display_selected (_tmp0_, _tmp1_);
#line 686 "math-display.c"
}


void math_display_update_history (MathDisplay* self, const gchar* answer, Number* number, gint number_base, guint representation_base) {
	HistoryView* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	guint _tmp4_ = 0U;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (answer != NULL);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (number != NULL);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = self->priv->history;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp1_ = answer;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp2_ = number;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp3_ = number_base;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp4_ = representation_base;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	history_view_insert_entry (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 714 "math-display.c"
}


void math_display_insert_text (MathDisplay* self, const gchar* answer) {
	MathEquation* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (self != NULL);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (answer != NULL);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = self->priv->_equation;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp1_ = answer;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	math_equation_insert_selected (_tmp0_, _tmp1_);
#line 731 "math-display.c"
}


static void math_display_create_autocompletion (MathDisplay* self) {
	GtkSourceCompletion* completion = NULL;
	GtkSourceView* _tmp0_ = NULL;
	GtkSourceCompletion* _tmp1_ = NULL;
	GtkSourceCompletion* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (self != NULL);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = self->priv->source_view;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp1_ = gtk_source_view_get_completion (_tmp0_);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	completion = _tmp2_;
#line 751 "math-display.c"
	{
		GtkSourceCompletion* _tmp3_ = NULL;
		FunctionCompletionProvider* _tmp4_ = NULL;
		FunctionCompletionProvider* _tmp5_ = NULL;
		GtkSourceCompletion* _tmp6_ = NULL;
		MathEquation* _tmp7_ = NULL;
		MathEquation* _tmp8_ = NULL;
		VariableCompletionProvider* _tmp9_ = NULL;
		VariableCompletionProvider* _tmp10_ = NULL;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp3_ = completion;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp4_ = function_completion_provider_new ();
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp5_ = _tmp4_;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		gtk_source_completion_add_provider (_tmp3_, (GtkSourceCompletionProvider*) _tmp5_, &_inner_error_);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_g_object_unref0 (_tmp5_);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 773 "math-display.c"
			goto __catch8_g_error;
		}
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp6_ = completion;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp7_ = math_display_get_equation (self);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp8_ = _tmp7_;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp9_ = variable_completion_provider_new (_tmp8_);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp10_ = _tmp9_;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		gtk_source_completion_add_provider (_tmp6_, (GtkSourceCompletionProvider*) _tmp10_, &_inner_error_);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_g_object_unref0 (_tmp10_);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 792 "math-display.c"
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		e = _inner_error_;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_inner_error_ = NULL;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		g_warning ("math-display.vala:119: Could not add CompletionProvider to source-view");
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_g_error_free0 (e);
#line 808 "math-display.c"
	}
	__finally8:
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_g_object_unref0 (completion);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		g_clear_error (&_inner_error_);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		return;
#line 821 "math-display.c"
	}
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (completion);
#line 825 "math-display.c"
}


static gboolean math_display_function_completion_window_visible (MathDisplay* self) {
	gboolean result = FALSE;
	GList* providers_list = NULL;
	GtkSourceView* _tmp0_ = NULL;
	GtkSourceCompletion* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = self->priv->source_view;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp1_ = gtk_source_view_get_completion (_tmp0_);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp2_ = gtk_source_completion_get_providers (_tmp1_);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	providers_list = _tmp2_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp3_ = providers_list;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp4_ = g_list_length (_tmp3_);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp4_ > ((guint) 0)) {
#line 853 "math-display.c"
		MathFunction** functions = NULL;
		MathEquation* _tmp5_ = NULL;
		MathEquation* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		MathFunction** _tmp8_ = NULL;
		gint functions_length1 = 0;
		gint _functions_size_ = 0;
		gchar** variables = NULL;
		MathEquation* _tmp9_ = NULL;
		MathEquation* _tmp10_ = NULL;
		MathEquation* _tmp11_ = NULL;
		MathEquation* _tmp12_ = NULL;
		MathVariables* _tmp13_ = NULL;
		MathVariables* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gchar** _tmp16_ = NULL;
		gint variables_length1 = 0;
		gint _variables_size_ = 0;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		MathFunction** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp5_ = math_display_get_equation (self);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp6_ = _tmp5_;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp8_ = function_completion_provider_get_matches_for_completion_at_cursor ((GtkTextBuffer*) _tmp6_, &_tmp7_);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		functions = _tmp8_;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		functions_length1 = _tmp7_;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_functions_size_ = functions_length1;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp9_ = math_display_get_equation (self);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp10_ = _tmp9_;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp11_ = math_display_get_equation (self);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp12_ = _tmp11_;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp13_ = math_equation_get_variables (_tmp12_);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp14_ = _tmp13_;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp16_ = variable_completion_provider_get_matches_for_completion_at_cursor ((GtkTextBuffer*) _tmp10_, _tmp14_, &_tmp15_);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		variables = _tmp16_;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		variables_length1 = _tmp15_;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_variables_size_ = variables_length1;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp19_ = functions;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp19__length1 = functions_length1;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		if (_tmp19__length1 > 0) {
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp18_ = TRUE;
#line 916 "math-display.c"
		} else {
			gchar** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp20_ = variables;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp20__length1 = variables_length1;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp18_ = _tmp20__length1 > 0;
#line 926 "math-display.c"
		}
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		if (_tmp18_) {
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp17_ = TRUE;
#line 932 "math-display.c"
		} else {
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp17_ = FALSE;
#line 936 "math-display.c"
		}
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		result = _tmp17_;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		variables = (_vala_array_free (variables, variables_length1, (GDestroyNotify) g_free), NULL);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		functions = (_vala_array_free (functions, functions_length1, (GDestroyNotify) g_object_unref), NULL);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		return result;
#line 946 "math-display.c"
	}
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	result = FALSE;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return result;
#line 952 "math-display.c"
}


static gboolean math_display_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MathDisplay * self;
	gboolean result = FALSE;
	GtkSourceView* _tmp0_ = NULL;
	GdkEventKey* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self = (MathDisplay*) base;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = self->priv->source_view;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp1_ = event;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_signal_emit_by_name ((GtkWidget*) _tmp0_, "key-press-event", _tmp1_, &_tmp2_);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	result = _tmp2_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return result;
#line 976 "math-display.c"
}


static GdkEventKey* _vala_GdkEventKey_copy (GdkEventKey* self) {
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return g_boxed_copy (gdk_event_get_type (), self);
#line 983 "math-display.c"
}


static gpointer __vala_GdkEventKey_copy0 (gpointer self) {
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return self ? _vala_GdkEventKey_copy (self) : NULL;
#line 990 "math-display.c"
}


static void _vala_GdkEventKey_free (GdkEventKey* self) {
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_boxed_free (gdk_event_get_type (), self);
#line 997 "math-display.c"
}


static gboolean math_display_key_press_cb (MathDisplay* self, GdkEventKey* event) {
	gboolean result = FALSE;
	guint new_keyval = 0U;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	GdkModifierType state = 0;
	GdkEventKey* _tmp9_ = NULL;
	GdkModifierType _tmp10_ = 0;
	guint32 c = 0U;
	GdkEventKey* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	guint32 _tmp13_ = 0U;
	gboolean _tmp14_ = FALSE;
	GdkEventKey* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	GdkEventKey* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	gboolean _tmp38_ = FALSE;
	GdkEventKey* _tmp39_ = NULL;
	guint _tmp40_ = 0U;
	GdkModifierType _tmp45_ = 0;
	GdkModifierType _tmp55_ = 0;
	GdkModifierType _tmp78_ = 0;
	gboolean _tmp85_ = FALSE;
	GdkModifierType _tmp86_ = 0;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	new_keyval = (guint) 0;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = event;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp1_ = _tmp0_->keyval;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	switch (_tmp1_) {
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		case GDK_KEY_KP_Insert:
#line 1044 "math-display.c"
		{
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			new_keyval = (guint) GDK_KEY_0;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			break;
#line 1050 "math-display.c"
		}
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		case GDK_KEY_KP_End:
#line 1054 "math-display.c"
		{
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			new_keyval = (guint) GDK_KEY_1;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			break;
#line 1060 "math-display.c"
		}
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		case GDK_KEY_KP_Down:
#line 1064 "math-display.c"
		{
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			new_keyval = (guint) GDK_KEY_2;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			break;
#line 1070 "math-display.c"
		}
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		case GDK_KEY_KP_Page_Down:
#line 1074 "math-display.c"
		{
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			new_keyval = (guint) GDK_KEY_3;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			break;
#line 1080 "math-display.c"
		}
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		case GDK_KEY_KP_Left:
#line 1084 "math-display.c"
		{
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			new_keyval = (guint) GDK_KEY_4;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			break;
#line 1090 "math-display.c"
		}
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		case GDK_KEY_KP_Begin:
#line 1094 "math-display.c"
		{
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			new_keyval = (guint) GDK_KEY_5;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			break;
#line 1100 "math-display.c"
		}
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		case GDK_KEY_KP_Right:
#line 1104 "math-display.c"
		{
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			new_keyval = (guint) GDK_KEY_6;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			break;
#line 1110 "math-display.c"
		}
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		case GDK_KEY_KP_Home:
#line 1114 "math-display.c"
		{
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			new_keyval = (guint) GDK_KEY_7;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			break;
#line 1120 "math-display.c"
		}
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		case GDK_KEY_KP_Up:
#line 1124 "math-display.c"
		{
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			new_keyval = (guint) GDK_KEY_8;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			break;
#line 1130 "math-display.c"
		}
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		case GDK_KEY_KP_Page_Up:
#line 1134 "math-display.c"
		{
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			new_keyval = (guint) GDK_KEY_9;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			break;
#line 1140 "math-display.c"
		}
		default:
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		break;
#line 1145 "math-display.c"
	}
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp2_ = new_keyval;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp2_ != ((guint) 0)) {
#line 1151 "math-display.c"
		GdkEventKey* new_event = NULL;
		GdkEventKey* _tmp3_ = NULL;
		GdkEventKey* _tmp4_ = NULL;
		GdkEventKey* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		GdkEventKey* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp3_ = event;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp4_ = __vala_GdkEventKey_copy0 (_tmp3_);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		new_event = _tmp4_;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp5_ = new_event;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp6_ = new_keyval;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp5_->keyval = _tmp6_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp7_ = new_event;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		g_signal_emit_by_name ((GtkWidget*) self, "key-press-event", _tmp7_, &_tmp8_);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		result = _tmp8_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		__vala_GdkEventKey_free0 (new_event);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		return result;
#line 1181 "math-display.c"
	}
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp9_ = event;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp10_ = _tmp9_->state;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	state = _tmp10_ & (GDK_CONTROL_MASK | GDK_MOD1_MASK);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp11_ = event;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp12_ = _tmp11_->keyval;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp13_ = gdk_keyval_to_unicode (_tmp12_);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	c = _tmp13_;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp15_ = event;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp16_ = _tmp15_->keyval;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp16_ == ((guint) GDK_KEY_Return)) {
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp14_ = TRUE;
#line 1205 "math-display.c"
	} else {
		GdkEventKey* _tmp17_ = NULL;
		guint _tmp18_ = 0U;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp17_ = event;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp18_ = _tmp17_->keyval;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp14_ = _tmp18_ == ((guint) GDK_KEY_KP_Enter);
#line 1215 "math-display.c"
	}
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp14_) {
#line 1219 "math-display.c"
		gboolean _tmp19_ = FALSE;
		MathEquation* _tmp20_ = NULL;
		MathEquation* _tmp21_ = NULL;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp19_ = math_display_function_completion_window_visible (self);
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		if (_tmp19_) {
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			result = FALSE;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			return result;
#line 1231 "math-display.c"
		}
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp20_ = math_display_get_equation (self);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp21_ = _tmp20_;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		math_equation_solve (_tmp21_);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		result = TRUE;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		return result;
#line 1243 "math-display.c"
	}
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp25_ = event;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp26_ = _tmp25_->keyval;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp26_ == ((guint) GDK_KEY_Escape)) {
#line 1251 "math-display.c"
		GdkModifierType _tmp27_ = 0;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp27_ = state;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp24_ = _tmp27_ == 0;
#line 1257 "math-display.c"
	} else {
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp24_ = FALSE;
#line 1261 "math-display.c"
	}
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp24_) {
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp23_ = TRUE;
#line 1267 "math-display.c"
	} else {
		gboolean _tmp28_ = FALSE;
		GdkEventKey* _tmp29_ = NULL;
		guint _tmp30_ = 0U;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp29_ = event;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp30_ = _tmp29_->keyval;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		if (_tmp30_ == ((guint) GDK_KEY_BackSpace)) {
#line 1278 "math-display.c"
			GdkModifierType _tmp31_ = 0;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp31_ = state;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp28_ = _tmp31_ == GDK_CONTROL_MASK;
#line 1284 "math-display.c"
		} else {
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp28_ = FALSE;
#line 1288 "math-display.c"
		}
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp23_ = _tmp28_;
#line 1292 "math-display.c"
	}
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp23_) {
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp22_ = TRUE;
#line 1298 "math-display.c"
	} else {
		gboolean _tmp32_ = FALSE;
		GdkEventKey* _tmp33_ = NULL;
		guint _tmp34_ = 0U;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp33_ = event;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp34_ = _tmp33_->keyval;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		if (_tmp34_ == ((guint) GDK_KEY_Delete)) {
#line 1309 "math-display.c"
			GdkModifierType _tmp35_ = 0;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp35_ = state;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp32_ = _tmp35_ == GDK_SHIFT_MASK;
#line 1315 "math-display.c"
		} else {
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp32_ = FALSE;
#line 1319 "math-display.c"
		}
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp22_ = _tmp32_;
#line 1323 "math-display.c"
	}
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp22_) {
#line 1327 "math-display.c"
		MathEquation* _tmp36_ = NULL;
		MathEquation* _tmp37_ = NULL;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp36_ = math_display_get_equation (self);
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp37_ = _tmp36_;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		math_equation_clear (_tmp37_);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		result = TRUE;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		return result;
#line 1340 "math-display.c"
	}
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp39_ = event;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp40_ = _tmp39_->keyval;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp40_ == ((guint) GDK_KEY_KP_Decimal)) {
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp38_ = TRUE;
#line 1350 "math-display.c"
	} else {
		GdkEventKey* _tmp41_ = NULL;
		guint _tmp42_ = 0U;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp41_ = event;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp42_ = _tmp41_->keyval;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp38_ = _tmp42_ == ((guint) GDK_KEY_KP_Separator);
#line 1360 "math-display.c"
	}
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp38_) {
#line 1364 "math-display.c"
		MathEquation* _tmp43_ = NULL;
		MathEquation* _tmp44_ = NULL;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp43_ = math_display_get_equation (self);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp44_ = _tmp43_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		math_equation_insert_numeric_point (_tmp44_);
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		result = TRUE;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		return result;
#line 1377 "math-display.c"
	}
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp45_ = state;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp45_ == 0) {
#line 1383 "math-display.c"
		guint32 _tmp46_ = 0U;
		guint32 _tmp49_ = 0U;
		guint32 _tmp52_ = 0U;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp46_ = c;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		if (_tmp46_ == ((guint32) '*')) {
#line 1391 "math-display.c"
			MathEquation* _tmp47_ = NULL;
			MathEquation* _tmp48_ = NULL;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp47_ = math_display_get_equation (self);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp48_ = _tmp47_;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			math_equation_insert (_tmp48_, "×");
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			result = TRUE;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			return result;
#line 1404 "math-display.c"
		}
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp49_ = c;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		if (_tmp49_ == ((guint32) '/')) {
#line 1410 "math-display.c"
			MathEquation* _tmp50_ = NULL;
			MathEquation* _tmp51_ = NULL;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp50_ = math_display_get_equation (self);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp51_ = _tmp50_;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			math_equation_insert (_tmp51_, "÷");
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			result = TRUE;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			return result;
#line 1423 "math-display.c"
		}
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp52_ = c;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		if (_tmp52_ == ((guint32) '-')) {
#line 1429 "math-display.c"
			MathEquation* _tmp53_ = NULL;
			MathEquation* _tmp54_ = NULL;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp53_ = math_display_get_equation (self);
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp54_ = _tmp53_;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			math_equation_insert_subtract (_tmp54_);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			result = TRUE;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			return result;
#line 1442 "math-display.c"
		}
	}
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp55_ = state;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp55_ == GDK_CONTROL_MASK) {
#line 1449 "math-display.c"
		GdkEventKey* _tmp56_ = NULL;
		guint _tmp57_ = 0U;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp56_ = event;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp57_ = _tmp56_->keyval;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		switch (_tmp57_) {
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_bracketleft:
#line 1460 "math-display.c"
			{
				MathEquation* _tmp58_ = NULL;
				MathEquation* _tmp59_ = NULL;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp58_ = math_display_get_equation (self);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp59_ = _tmp58_;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp59_, "⌈");
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1474 "math-display.c"
			}
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_bracketright:
#line 1478 "math-display.c"
			{
				MathEquation* _tmp60_ = NULL;
				MathEquation* _tmp61_ = NULL;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp60_ = math_display_get_equation (self);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp61_ = _tmp60_;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp61_, "⌉");
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1492 "math-display.c"
			}
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_e:
#line 1496 "math-display.c"
			{
				MathEquation* _tmp62_ = NULL;
				MathEquation* _tmp63_ = NULL;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp62_ = math_display_get_equation (self);
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp63_ = _tmp62_;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert_exponent (_tmp63_);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1510 "math-display.c"
			}
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_f:
#line 1514 "math-display.c"
			{
				MathEquation* _tmp64_ = NULL;
				MathEquation* _tmp65_ = NULL;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp64_ = math_display_get_equation (self);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp65_ = _tmp64_;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_factorize (_tmp65_);
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1528 "math-display.c"
			}
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_i:
#line 1532 "math-display.c"
			{
				MathEquation* _tmp66_ = NULL;
				MathEquation* _tmp67_ = NULL;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp66_ = math_display_get_equation (self);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp67_ = _tmp66_;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp67_, "⁻¹");
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1546 "math-display.c"
			}
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_p:
#line 1550 "math-display.c"
			{
				MathEquation* _tmp68_ = NULL;
				MathEquation* _tmp69_ = NULL;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp68_ = math_display_get_equation (self);
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp69_ = _tmp68_;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp69_, "π");
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1564 "math-display.c"
			}
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_r:
#line 1568 "math-display.c"
			{
				MathEquation* _tmp70_ = NULL;
				MathEquation* _tmp71_ = NULL;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp70_ = math_display_get_equation (self);
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp71_ = _tmp70_;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp71_, "√");
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1582 "math-display.c"
			}
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_u:
#line 1586 "math-display.c"
			{
				MathEquation* _tmp72_ = NULL;
				MathEquation* _tmp73_ = NULL;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp72_ = math_display_get_equation (self);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp73_ = _tmp72_;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp73_, "µ");
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1600 "math-display.c"
			}
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_minus:
#line 1604 "math-display.c"
			{
				MathEquation* _tmp74_ = NULL;
				MathEquation* _tmp75_ = NULL;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp74_ = math_display_get_equation (self);
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp75_ = _tmp74_;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp75_, "⁻");
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1618 "math-display.c"
			}
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_apostrophe:
#line 1622 "math-display.c"
			{
				MathEquation* _tmp76_ = NULL;
				MathEquation* _tmp77_ = NULL;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp76_ = math_display_get_equation (self);
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp77_ = _tmp76_;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp77_, "°");
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1636 "math-display.c"
			}
			default:
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			break;
#line 1641 "math-display.c"
		}
	}
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp78_ = state;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp78_ == GDK_MOD1_MASK) {
#line 1648 "math-display.c"
		GdkEventKey* _tmp79_ = NULL;
		guint _tmp80_ = 0U;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp79_ = event;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp80_ = _tmp79_->keyval;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		switch (_tmp80_) {
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_bracketleft:
#line 1659 "math-display.c"
			{
				MathEquation* _tmp81_ = NULL;
				MathEquation* _tmp82_ = NULL;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp81_ = math_display_get_equation (self);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp82_ = _tmp81_;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp82_, "⌊");
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1673 "math-display.c"
			}
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_bracketright:
#line 1677 "math-display.c"
			{
				MathEquation* _tmp83_ = NULL;
				MathEquation* _tmp84_ = NULL;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp83_ = math_display_get_equation (self);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp84_ = _tmp83_;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp84_, "⌋");
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1691 "math-display.c"
			}
			default:
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			break;
#line 1696 "math-display.c"
		}
	}
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp86_ = state;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp86_ == GDK_CONTROL_MASK) {
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp85_ = TRUE;
#line 1705 "math-display.c"
	} else {
		MathEquation* _tmp87_ = NULL;
		MathEquation* _tmp88_ = NULL;
		NumberMode _tmp89_ = 0;
		NumberMode _tmp90_ = 0;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp87_ = math_display_get_equation (self);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp88_ = _tmp87_;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp89_ = math_equation_get_number_mode (_tmp88_);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp90_ = _tmp89_;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp85_ = _tmp90_ == NUMBER_MODE_SUPERSCRIPT;
#line 1721 "math-display.c"
	}
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp85_) {
#line 1725 "math-display.c"
		GdkEventKey* _tmp91_ = NULL;
		guint _tmp92_ = 0U;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp91_ = event;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp92_ = _tmp91_->keyval;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		switch (_tmp92_) {
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_0:
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_KP_0:
#line 1738 "math-display.c"
			{
				MathEquation* _tmp93_ = NULL;
				MathEquation* _tmp94_ = NULL;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp93_ = math_display_get_equation (self);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp94_ = _tmp93_;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp94_, "⁰");
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1752 "math-display.c"
			}
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_1:
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_KP_1:
#line 1758 "math-display.c"
			{
				MathEquation* _tmp95_ = NULL;
				MathEquation* _tmp96_ = NULL;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp95_ = math_display_get_equation (self);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp96_ = _tmp95_;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp96_, "¹");
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1772 "math-display.c"
			}
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_2:
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_KP_2:
#line 1778 "math-display.c"
			{
				MathEquation* _tmp97_ = NULL;
				MathEquation* _tmp98_ = NULL;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp97_ = math_display_get_equation (self);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp98_ = _tmp97_;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp98_, "²");
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1792 "math-display.c"
			}
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_3:
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_KP_3:
#line 1798 "math-display.c"
			{
				MathEquation* _tmp99_ = NULL;
				MathEquation* _tmp100_ = NULL;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp99_ = math_display_get_equation (self);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp100_ = _tmp99_;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp100_, "³");
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1812 "math-display.c"
			}
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_4:
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_KP_4:
#line 1818 "math-display.c"
			{
				MathEquation* _tmp101_ = NULL;
				MathEquation* _tmp102_ = NULL;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp101_ = math_display_get_equation (self);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp102_ = _tmp101_;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp102_, "⁴");
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1832 "math-display.c"
			}
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_5:
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_KP_5:
#line 1838 "math-display.c"
			{
				MathEquation* _tmp103_ = NULL;
				MathEquation* _tmp104_ = NULL;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp103_ = math_display_get_equation (self);
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp104_ = _tmp103_;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp104_, "⁵");
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1852 "math-display.c"
			}
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_6:
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_KP_6:
#line 1858 "math-display.c"
			{
				MathEquation* _tmp105_ = NULL;
				MathEquation* _tmp106_ = NULL;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp105_ = math_display_get_equation (self);
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp106_ = _tmp105_;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp106_, "⁶");
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1872 "math-display.c"
			}
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_7:
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_KP_7:
#line 1878 "math-display.c"
			{
				MathEquation* _tmp107_ = NULL;
				MathEquation* _tmp108_ = NULL;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp107_ = math_display_get_equation (self);
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp108_ = _tmp107_;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp108_, "⁷");
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1892 "math-display.c"
			}
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_8:
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_KP_8:
#line 1898 "math-display.c"
			{
				MathEquation* _tmp109_ = NULL;
				MathEquation* _tmp110_ = NULL;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp109_ = math_display_get_equation (self);
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp110_ = _tmp109_;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp110_, "⁸");
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1912 "math-display.c"
			}
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_9:
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			case GDK_KEY_KP_9:
#line 1918 "math-display.c"
			{
				MathEquation* _tmp111_ = NULL;
				MathEquation* _tmp112_ = NULL;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp111_ = math_display_get_equation (self);
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp112_ = _tmp111_;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				math_equation_insert (_tmp112_, "⁹");
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				result = TRUE;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				return result;
#line 1932 "math-display.c"
			}
			default:
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			break;
#line 1937 "math-display.c"
		}
	} else {
		gboolean _tmp113_ = FALSE;
		GdkModifierType _tmp114_ = 0;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp114_ = state;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		if (_tmp114_ == GDK_MOD1_MASK) {
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp113_ = TRUE;
#line 1948 "math-display.c"
		} else {
			MathEquation* _tmp115_ = NULL;
			MathEquation* _tmp116_ = NULL;
			NumberMode _tmp117_ = 0;
			NumberMode _tmp118_ = 0;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp115_ = math_display_get_equation (self);
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp116_ = _tmp115_;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp117_ = math_equation_get_number_mode (_tmp116_);
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp118_ = _tmp117_;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp113_ = _tmp118_ == NUMBER_MODE_SUBSCRIPT;
#line 1964 "math-display.c"
		}
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		if (_tmp113_) {
#line 1968 "math-display.c"
			GdkEventKey* _tmp119_ = NULL;
			guint _tmp120_ = 0U;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp119_ = event;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp120_ = _tmp119_->keyval;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			switch (_tmp120_) {
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_0:
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_KP_0:
#line 1981 "math-display.c"
				{
					MathEquation* _tmp121_ = NULL;
					MathEquation* _tmp122_ = NULL;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp121_ = math_display_get_equation (self);
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp122_ = _tmp121_;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					math_equation_insert (_tmp122_, "₀");
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					result = TRUE;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					return result;
#line 1995 "math-display.c"
				}
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_1:
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_KP_1:
#line 2001 "math-display.c"
				{
					MathEquation* _tmp123_ = NULL;
					MathEquation* _tmp124_ = NULL;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp123_ = math_display_get_equation (self);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp124_ = _tmp123_;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					math_equation_insert (_tmp124_, "₁");
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					result = TRUE;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					return result;
#line 2015 "math-display.c"
				}
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_2:
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_KP_2:
#line 2021 "math-display.c"
				{
					MathEquation* _tmp125_ = NULL;
					MathEquation* _tmp126_ = NULL;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp125_ = math_display_get_equation (self);
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp126_ = _tmp125_;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					math_equation_insert (_tmp126_, "₂");
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					result = TRUE;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					return result;
#line 2035 "math-display.c"
				}
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_3:
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_KP_3:
#line 2041 "math-display.c"
				{
					MathEquation* _tmp127_ = NULL;
					MathEquation* _tmp128_ = NULL;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp127_ = math_display_get_equation (self);
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp128_ = _tmp127_;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					math_equation_insert (_tmp128_, "₃");
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					result = TRUE;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					return result;
#line 2055 "math-display.c"
				}
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_4:
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_KP_4:
#line 2061 "math-display.c"
				{
					MathEquation* _tmp129_ = NULL;
					MathEquation* _tmp130_ = NULL;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp129_ = math_display_get_equation (self);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp130_ = _tmp129_;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					math_equation_insert (_tmp130_, "₄");
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					result = TRUE;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					return result;
#line 2075 "math-display.c"
				}
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_5:
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_KP_5:
#line 2081 "math-display.c"
				{
					MathEquation* _tmp131_ = NULL;
					MathEquation* _tmp132_ = NULL;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp131_ = math_display_get_equation (self);
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp132_ = _tmp131_;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					math_equation_insert (_tmp132_, "₅");
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					result = TRUE;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					return result;
#line 2095 "math-display.c"
				}
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_6:
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_KP_6:
#line 2101 "math-display.c"
				{
					MathEquation* _tmp133_ = NULL;
					MathEquation* _tmp134_ = NULL;
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp133_ = math_display_get_equation (self);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp134_ = _tmp133_;
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					math_equation_insert (_tmp134_, "₆");
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					result = TRUE;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					return result;
#line 2115 "math-display.c"
				}
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_7:
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_KP_7:
#line 2121 "math-display.c"
				{
					MathEquation* _tmp135_ = NULL;
					MathEquation* _tmp136_ = NULL;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp135_ = math_display_get_equation (self);
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp136_ = _tmp135_;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					math_equation_insert (_tmp136_, "₇");
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					result = TRUE;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					return result;
#line 2135 "math-display.c"
				}
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_8:
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_KP_8:
#line 2141 "math-display.c"
				{
					MathEquation* _tmp137_ = NULL;
					MathEquation* _tmp138_ = NULL;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp137_ = math_display_get_equation (self);
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp138_ = _tmp137_;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					math_equation_insert (_tmp138_, "₈");
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					result = TRUE;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					return result;
#line 2155 "math-display.c"
				}
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_9:
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				case GDK_KEY_KP_9:
#line 2161 "math-display.c"
				{
					MathEquation* _tmp139_ = NULL;
					MathEquation* _tmp140_ = NULL;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp139_ = math_display_get_equation (self);
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp140_ = _tmp139_;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					math_equation_insert (_tmp140_, "₉");
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					result = TRUE;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					return result;
#line 2175 "math-display.c"
				}
				default:
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				break;
#line 2180 "math-display.c"
			}
		}
	}
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	result = FALSE;
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return result;
#line 2188 "math-display.c"
}


static void math_display_status_changed_cb (MathDisplay* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	MathEquation* _tmp7_ = NULL;
	MathEquation* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (self != NULL);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = self->priv->info_buffer;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp1_ = math_display_get_equation (self);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp2_ = _tmp1_;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp3_ = math_equation_get_status (_tmp2_);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp4_ = _tmp3_;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp5_ = _tmp4_;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_buffer_set_text (_tmp0_, _tmp5_, -1);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_free0 (_tmp5_);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp7_ = math_display_get_equation (self);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp8_ = _tmp7_;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp9_ = math_equation_get_in_solve (_tmp8_);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp10_ = _tmp9_;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp10_) {
#line 2232 "math-display.c"
		GtkSpinner* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp11_ = self->priv->spinner;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp12_ = gtk_widget_get_visible ((GtkWidget*) _tmp11_);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp6_ = !_tmp12_;
#line 2241 "math-display.c"
	} else {
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp6_ = FALSE;
#line 2245 "math-display.c"
	}
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp6_) {
#line 2249 "math-display.c"
		GtkSpinner* _tmp13_ = NULL;
		GtkSpinner* _tmp14_ = NULL;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp13_ = self->priv->spinner;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		gtk_widget_show ((GtkWidget*) _tmp13_);
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp14_ = self->priv->spinner;
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		gtk_spinner_start (_tmp14_);
#line 2260 "math-display.c"
	} else {
		gboolean _tmp15_ = FALSE;
		MathEquation* _tmp16_ = NULL;
		MathEquation* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp16_ = math_display_get_equation (self);
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp17_ = _tmp16_;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp18_ = math_equation_get_in_solve (_tmp17_);
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp19_ = _tmp18_;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		if (!_tmp19_) {
#line 2277 "math-display.c"
			GtkSpinner* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp20_ = self->priv->spinner;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp21_ = gtk_widget_get_visible ((GtkWidget*) _tmp20_);
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp15_ = _tmp21_;
#line 2286 "math-display.c"
		} else {
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp15_ = FALSE;
#line 2290 "math-display.c"
		}
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		if (_tmp15_) {
#line 2294 "math-display.c"
			GtkSpinner* _tmp22_ = NULL;
			GtkSpinner* _tmp23_ = NULL;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp22_ = self->priv->spinner;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			gtk_widget_hide ((GtkWidget*) _tmp22_);
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			_tmp23_ = self->priv->spinner;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			gtk_spinner_stop (_tmp23_);
#line 2305 "math-display.c"
		}
	}
}


static void math_display_error_status_changed_cb (MathDisplay* self) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	MathEquation* _tmp4_ = NULL;
	MathEquation* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	MathEquation* _tmp8_ = NULL;
	MathEquation* _tmp9_ = NULL;
	GtkTextIter _tmp10_ = {0};
	MathEquation* _tmp11_ = NULL;
	MathEquation* _tmp12_ = NULL;
	GtkTextIter _tmp13_ = {0};
	MathEquation* _tmp14_ = NULL;
	MathEquation* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	guint _tmp17_ = 0U;
	MathEquation* _tmp18_ = NULL;
	MathEquation* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	MathEquation* _tmp22_ = NULL;
	MathEquation* _tmp23_ = NULL;
	GtkTextIter _tmp24_ = {0};
	GtkTextIter _tmp25_ = {0};
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (self != NULL);
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = math_display_get_equation (self);
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp1_ = _tmp0_;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp2_ = math_equation_get_error_token_end (_tmp1_);
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp3_ = _tmp2_;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp4_ = math_display_get_equation (self);
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp5_ = _tmp4_;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp6_ = math_equation_get_error_token_start (_tmp5_);
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp7_ = _tmp6_;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if ((_tmp3_ - _tmp7_) == ((guint) 0)) {
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		return;
#line 2362 "math-display.c"
	}
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp8_ = math_display_get_equation (self);
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp9_ = _tmp8_;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp9_, &_tmp10_);
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	start = _tmp10_;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp11_ = math_display_get_equation (self);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp12_ = _tmp11_;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp12_, &_tmp13_);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	end = _tmp13_;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp14_ = math_display_get_equation (self);
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp15_ = _tmp14_;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp16_ = math_equation_get_error_token_start (_tmp15_);
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp17_ = _tmp16_;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_iter_set_offset (&start, (gint) _tmp17_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp18_ = math_display_get_equation (self);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp19_ = _tmp18_;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp20_ = math_equation_get_error_token_end (_tmp19_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp21_ = _tmp20_;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_iter_set_offset (&end, (gint) _tmp21_);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp22_ = math_display_get_equation (self);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp23_ = _tmp22_;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp24_ = start;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp25_ = end;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp23_, &_tmp24_, &_tmp25_);
#line 2410 "math-display.c"
}


void math_display_grab_focus (MathDisplay* self) {
	GtkSourceView* _tmp0_ = NULL;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (self != NULL);
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = self->priv->source_view;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
#line 2422 "math-display.c"
}


MathEquation* math_display_get_equation (MathDisplay* self) {
	MathEquation* result;
	MathEquation* _tmp0_ = NULL;
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = self->priv->_equation;
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	result = _tmp0_;
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return result;
#line 2437 "math-display.c"
}


static void math_display_class_init (MathDisplayClass * klass) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	math_display_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_type_class_add_private (klass, sizeof (MathDisplayPrivate));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	((GtkWidgetClass *) klass)->key_press_event = math_display_real_key_press_event;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_math_display_get_property;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	G_OBJECT_CLASS (klass)->finalize = math_display_finalize;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_DISPLAY_EQUATION, g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2454 "math-display.c"
}


static void math_display_instance_init (MathDisplay * self) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self->priv = MATH_DISPLAY_GET_PRIVATE (self);
#line 2461 "math-display.c"
}


static void math_display_finalize (GObject* obj) {
	MathDisplay * self;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_DISPLAY, MathDisplay);
#line 14 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (self->priv->_equation);
#line 16 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (self->priv->history);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (self->priv->source_view);
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (self->priv->info_buffer);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (self->priv->spinner);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	G_OBJECT_CLASS (math_display_parent_class)->finalize (obj);
#line 2481 "math-display.c"
}


GType math_display_get_type (void) {
	static volatile gsize math_display_type_id__volatile = 0;
	if (g_once_init_enter (&math_display_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathDisplay), 0, (GInstanceInitFunc) math_display_instance_init, NULL };
		GType math_display_type_id;
		math_display_type_id = g_type_register_static (gtk_viewport_get_type (), "MathDisplay", &g_define_type_info, 0);
		g_once_init_leave (&math_display_type_id__volatile, math_display_type_id);
	}
	return math_display_type_id__volatile;
}


static void _vala_math_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_DISPLAY, MathDisplay);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		case MATH_DISPLAY_EQUATION:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		g_value_set_object (value, math_display_get_equation (self));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		break;
#line 2508 "math-display.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		break;
#line 2514 "math-display.c"
	}
}


static gchar* completion_provider_real_get_name (CompletionProvider* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = g_strdup ("");
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	result = _tmp0_;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return result;
#line 2528 "math-display.c"
}


gchar* completion_provider_get_name (CompletionProvider* self) {
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return COMPLETION_PROVIDER_GET_CLASS (self)->get_name (self);
#line 2537 "math-display.c"
}


void completion_provider_move_iter_to_name_start (GtkTextIter* iter) {
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (iter != NULL);
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	while (TRUE) {
#line 2546 "math-display.c"
		gboolean _tmp0_ = FALSE;
		gunichar current_char = 0U;
		gunichar _tmp1_ = 0U;
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_ = FALSE;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp0_ = gtk_text_iter_backward_char (iter);
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		if (!_tmp0_) {
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			break;
#line 2558 "math-display.c"
		}
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp1_ = gtk_text_iter_get_char (iter);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		current_char = _tmp1_;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp2_ = current_char;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp3_ = g_unichar_isalpha (_tmp2_);
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		if (!_tmp3_) {
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			gtk_text_iter_forward_char (iter);
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			break;
#line 2574 "math-display.c"
		}
	}
}


static gboolean completion_provider_real_get_start_iter (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	GtkTextIter _vala_iter = {0};
	gboolean result = FALSE;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (context != NULL, FALSE);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (proposal != NULL, FALSE);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	result = FALSE;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (iter) {
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		*iter = _vala_iter;
#line 2593 "math-display.c"
	}
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return result;
#line 2597 "math-display.c"
}


gboolean completion_provider_get_start_iter (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return COMPLETION_PROVIDER_GET_CLASS (self)->get_start_iter (self, context, proposal, iter);
#line 2606 "math-display.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 2626 "math-display.c"
}


static gboolean completion_provider_real_activate_proposal (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	gboolean result = FALSE;
	gchar* proposed_string = NULL;
	GtkSourceCompletionProposal* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkTextBuffer* buffer = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GtkTextIter _tmp6_ = {0};
	GtkTextBuffer* _tmp7_ = NULL;
	GtkTextIter _tmp8_ = {0};
	GtkTextBuffer* _tmp9_ = NULL;
	GtkTextIter _tmp10_ = {0};
	GtkTextIter _tmp11_ = {0};
	GtkTextBuffer* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	const gchar* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (proposal != NULL, FALSE);
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = proposal;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp1_ = gtk_source_completion_proposal_get_text (_tmp0_);
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	proposed_string = _tmp1_;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp2_ = gtk_text_iter_get_buffer (iter);
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	buffer = _tmp3_;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp4_ = buffer;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp5_ = gtk_text_iter_get_offset (iter);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_buffer_get_iter_at_offset (_tmp4_, &_tmp6_, _tmp5_);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	start_iter = _tmp6_;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	completion_provider_move_iter_to_name_start (&start_iter);
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp7_ = buffer;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp8_ = start_iter;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_buffer_place_cursor (_tmp7_, &_tmp8_);
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp9_ = buffer;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp10_ = start_iter;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp11_ = *iter;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_signal_emit_by_name (_tmp9_, "delete-range", &_tmp10_, &_tmp11_);
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp12_ = buffer;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp13_ = proposed_string;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp14_ = proposed_string;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp15_ = strlen (_tmp14_);
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp16_ = _tmp15_;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_buffer_insert_at_cursor (_tmp12_, _tmp13_, _tmp16_);
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp17_ = proposed_string;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp18_ = string_contains (_tmp17_, "()");
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp18_) {
#line 2713 "math-display.c"
		GtkTextBuffer* _tmp19_ = NULL;
		GtkTextBuffer* _tmp20_ = NULL;
		GtkTextMark* _tmp21_ = NULL;
		GtkTextIter _tmp22_ = {0};
		GtkTextBuffer* _tmp23_ = NULL;
		GtkTextIter _tmp24_ = {0};
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp19_ = buffer;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp20_ = buffer;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp21_ = gtk_text_buffer_get_insert (_tmp20_);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		gtk_text_buffer_get_iter_at_mark (_tmp19_, &_tmp22_, _tmp21_);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		end = _tmp22_;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		gtk_text_iter_backward_chars (&end, 1);
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp23_ = buffer;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp24_ = end;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		gtk_text_buffer_place_cursor (_tmp23_, &_tmp24_);
#line 2738 "math-display.c"
	}
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	result = TRUE;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (buffer);
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_free0 (proposed_string);
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return result;
#line 2748 "math-display.c"
}


gboolean completion_provider_activate_proposal (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return COMPLETION_PROVIDER_GET_CLASS (self)->activate_proposal (self, proposal, iter);
#line 2757 "math-display.c"
}


static void completion_provider_real_populate (CompletionProvider* self, GtkSourceCompletionContext* context) {
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (context != NULL);
#line 2764 "math-display.c"
}


void completion_provider_populate (CompletionProvider* self, GtkSourceCompletionContext* context) {
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (self != NULL);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	COMPLETION_PROVIDER_GET_CLASS (self)->populate (self, context);
#line 2773 "math-display.c"
}


CompletionProvider* completion_provider_construct (GType object_type) {
	CompletionProvider * self = NULL;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self = (CompletionProvider*) g_object_new (object_type, NULL);
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return self;
#line 2783 "math-display.c"
}


CompletionProvider* completion_provider_new (void) {
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return completion_provider_construct (TYPE_COMPLETION_PROVIDER);
#line 2790 "math-display.c"
}


static void completion_provider_class_init (CompletionProviderClass * klass) {
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	completion_provider_parent_class = g_type_class_peek_parent (klass);
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	((CompletionProviderClass *) klass)->get_name = completion_provider_real_get_name;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	((CompletionProviderClass *) klass)->get_start_iter = completion_provider_real_get_start_iter;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	((CompletionProviderClass *) klass)->activate_proposal = completion_provider_real_activate_proposal;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	((CompletionProviderClass *) klass)->populate = completion_provider_real_populate;
#line 2805 "math-display.c"
}


static void completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderIface * iface) {
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	iface->get_name = (gchar* (*)(GtkSourceCompletionProvider*)) completion_provider_get_name;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	iface->get_start_iter = (gboolean (*)(GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_get_start_iter;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	iface->activate_proposal = (gboolean (*)(GtkSourceCompletionProvider*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_activate_proposal;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	iface->populate = (void (*)(GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_populate;
#line 2820 "math-display.c"
}


static void completion_provider_instance_init (CompletionProvider * self) {
}


GType completion_provider_get_type (void) {
	static volatile gsize completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionProvider), 0, (GInstanceInitFunc) completion_provider_instance_init, NULL };
		static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType completion_provider_type_id;
		completion_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "CompletionProvider", &g_define_type_info, 0);
		g_type_add_interface_static (completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
		g_once_init_leave (&completion_provider_type_id__volatile, completion_provider_type_id);
	}
	return completion_provider_type_id__volatile;
}


static gchar* function_completion_provider_real_get_name (CompletionProvider* base) {
	FunctionCompletionProvider * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self = (FunctionCompletionProvider*) base;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = g_strdup ("Defined Functions");
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	result = _tmp0_;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return result;
#line 2854 "math-display.c"
}


MathFunction** function_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer, int* result_length1) {
	MathFunction** result = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextMark* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	gchar* search_pattern = NULL;
	GtkTextBuffer* _tmp8_ = NULL;
	GtkTextIter _tmp9_ = {0};
	GtkTextIter _tmp10_ = {0};
	gchar* _tmp11_ = NULL;
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp12_ = NULL;
	MathFunction** functions = NULL;
	gint _tmp13_ = 0;
	MathFunction** _tmp14_ = NULL;
	gint functions_length1 = 0;
	gint _functions_size_ = 0;
	MathFunction** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (text_buffer != NULL, NULL);
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = text_buffer;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp1_ = text_buffer;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp2_ = gtk_text_buffer_get_insert (_tmp1_);
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_buffer_get_iter_at_mark (_tmp0_, &_tmp3_, _tmp2_);
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	end_iter = _tmp3_;
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp4_ = text_buffer;
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp5_ = text_buffer;
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp6_ = gtk_text_buffer_get_insert (_tmp5_);
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_buffer_get_iter_at_mark (_tmp4_, &_tmp7_, _tmp6_);
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	start_iter = _tmp7_;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	completion_provider_move_iter_to_name_start (&start_iter);
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp8_ = text_buffer;
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp9_ = start_iter;
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp10_ = end_iter;
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp11_ = gtk_text_buffer_get_slice (_tmp8_, &_tmp9_, &_tmp10_, FALSE);
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	search_pattern = _tmp11_;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp12_ = function_manager_get_default_function_manager ();
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	function_manager = _tmp12_;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp14_ = function_manager_functions_eligible_for_autocompletion_for_text (function_manager, search_pattern, &_tmp13_);
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	functions = _tmp14_;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	functions_length1 = _tmp13_;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_functions_size_ = functions_length1;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp15_ = functions;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp15__length1 = functions_length1;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (result_length1) {
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		*result_length1 = _tmp15__length1;
#line 2938 "math-display.c"
	}
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	result = _tmp15_;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (function_manager);
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_free0 (search_pattern);
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return result;
#line 2948 "math-display.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 2955 "math-display.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_list_free (self);
#line 2964 "math-display.c"
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 964 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = separator;
#line 964 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp0_ == NULL) {
#line 965 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		separator = "";
#line 2981 "math-display.c"
	}
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = str_array;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3__length1 = str_array_length1;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp2_ = TRUE;
#line 2991 "math-display.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = str_array;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4__length1 = str_array_length1;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp4__length1 > 0;
#line 3001 "math-display.c"
	}
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp2_) {
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 3007 "math-display.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = str_array;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6__length1 = str_array_length1;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		if (_tmp6__length1 == (-1)) {
#line 3018 "math-display.c"
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp7_ = str_array;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp7__length1 = str_array_length1;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp8_ = _tmp7_[0];
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp5_ = _tmp8_ != NULL;
#line 3030 "math-display.c"
		} else {
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 3034 "math-display.c"
		}
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp1_ = _tmp5_;
#line 3038 "math-display.c"
	}
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 3042 "math-display.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
#line 969 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 3065 "math-display.c"
		{
			gboolean _tmp9_ = FALSE;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			i = 0;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp9_ = TRUE;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 3074 "math-display.c"
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				if (!_tmp9_) {
#line 3087 "math-display.c"
					gint _tmp10_ = 0;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp10_ = i;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					i = _tmp10_ + 1;
#line 3093 "math-display.c"
				}
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp9_ = FALSE;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp13_ = str_array;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp13__length1 = str_array_length1;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				if (_tmp13__length1 != (-1)) {
#line 3103 "math-display.c"
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp14_ = i;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp15_ = str_array;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp15__length1 = str_array_length1;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp14_ < _tmp15__length1;
#line 3115 "math-display.c"
				} else {
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp12_ = FALSE;
#line 3119 "math-display.c"
				}
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				if (_tmp12_) {
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp11_ = TRUE;
#line 3125 "math-display.c"
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp17_ = str_array;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp17__length1 = str_array_length1;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					if (_tmp17__length1 == (-1)) {
#line 3136 "math-display.c"
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp18_ = str_array;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp18__length1 = str_array_length1;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp19_ = i;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp20_ = _tmp18_[_tmp19_];
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp16_ = _tmp20_ != NULL;
#line 3151 "math-display.c"
					} else {
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp16_ = FALSE;
#line 3155 "math-display.c"
					}
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp11_ = _tmp16_;
#line 3159 "math-display.c"
				}
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				if (!_tmp11_) {
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					break;
#line 3165 "math-display.c"
				}
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp22_ = str_array;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp22__length1 = str_array_length1;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp23_ = i;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp24_ = _tmp22_[_tmp23_];
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				if (_tmp24_ != NULL) {
#line 3177 "math-display.c"
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp25_ = str_array;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp25__length1 = str_array_length1;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp26_ = i;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp27_ = _tmp25_[_tmp26_];
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp28_ = strlen ((const gchar*) _tmp27_);
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp29_ = _tmp28_;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp21_ = _tmp29_;
#line 3198 "math-display.c"
				} else {
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp21_ = 0;
#line 3202 "math-display.c"
				}
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp30_ = len;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				len = _tmp30_ + _tmp21_;
#line 3208 "math-display.c"
			}
		}
#line 973 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp31_ = i;
#line 973 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		if (_tmp31_ == 0) {
#line 3215 "math-display.c"
			gchar* _tmp32_ = NULL;
#line 974 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp32_ = g_strdup ("");
#line 974 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			result = _tmp32_;
#line 974 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			return result;
#line 3223 "math-display.c"
		}
#line 976 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp33_ = i;
#line 976 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp33_;
#line 976 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp34_ = str_array_length1;
#line 977 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp35_ = len;
#line 977 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp36_ = separator;
#line 977 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp37_ = strlen ((const gchar*) _tmp36_);
#line 977 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp38_ = _tmp37_;
#line 977 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp39_ = i;
#line 977 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
#line 979 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp40_ = len;
#line 979 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp41_ = g_malloc (_tmp40_);
#line 979 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		res = _tmp41_;
#line 980 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp42_ = res;
#line 980 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp43_ = str_array;
#line 980 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp43__length1 = str_array_length1;
#line 980 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp44_ = _tmp43_[0];
#line 980 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
#line 980 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		ptr = _tmp45_;
#line 3261 "math-display.c"
		{
			gboolean _tmp46_ = FALSE;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			i = 1;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp46_ = TRUE;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 3270 "math-display.c"
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				if (!_tmp46_) {
#line 3286 "math-display.c"
					gint _tmp47_ = 0;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp47_ = i;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					i = _tmp47_ + 1;
#line 3292 "math-display.c"
				}
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp46_ = FALSE;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp48_ = i;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp49_ = str_array;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp49__length1 = str_array_length1;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				if (!(_tmp48_ < _tmp49__length1)) {
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					break;
#line 3306 "math-display.c"
				}
#line 982 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp50_ = ptr;
#line 982 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp51_ = separator;
#line 982 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
#line 982 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				ptr = _tmp52_;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp54_ = str_array;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp54__length1 = str_array_length1;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp55_ = i;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp56_ = _tmp54_[_tmp55_];
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				if (_tmp56_ != NULL) {
#line 3326 "math-display.c"
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp57_ = str_array;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp57__length1 = str_array_length1;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp58_ = i;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp59_ = _tmp57_[_tmp58_];
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp53_ = (const gchar*) _tmp59_;
#line 3341 "math-display.c"
				} else {
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp53_ = "";
#line 3345 "math-display.c"
				}
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp60_ = ptr;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
				ptr = _tmp61_;
#line 3353 "math-display.c"
			}
		}
#line 986 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp62_ = res;
#line 986 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		res = NULL;
#line 986 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp62_;
#line 986 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 3364 "math-display.c"
	} else {
		gchar* _tmp63_ = NULL;
#line 988 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp63_ = g_strdup ("");
#line 988 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp63_;
#line 988 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 3373 "math-display.c"
	}
}


static void function_completion_provider_real_populate (CompletionProvider* base, GtkSourceCompletionContext* context) {
	FunctionCompletionProvider * self;
	GtkTextIter iter1 = {0};
	GtkSourceCompletionContext* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkTextBuffer* text_buffer = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	MathFunction** functions = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	MathFunction** _tmp7_ = NULL;
	gint functions_length1 = 0;
	gint _functions_size_ = 0;
	GList* proposals = NULL;
	MathFunction** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	GtkSourceCompletionContext* _tmp52_ = NULL;
	GList* _tmp53_ = NULL;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self = (FunctionCompletionProvider*) base;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (context != NULL);
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = context;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp2_ = gtk_source_completion_context_get_iter (_tmp0_, &_tmp1_);
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	iter1 = _tmp1_;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (!_tmp2_) {
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		return;
#line 3412 "math-display.c"
	}
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp3_ = gtk_text_iter_get_buffer (&iter1);
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	text_buffer = _tmp4_;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp5_ = text_buffer;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp7_ = function_completion_provider_get_matches_for_completion_at_cursor (_tmp5_, &_tmp6_);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	functions = _tmp7_;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	functions_length1 = _tmp6_;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_functions_size_ = functions_length1;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	proposals = NULL;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp8_ = functions;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp8__length1 = functions_length1;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp8__length1 > 0) {
#line 3438 "math-display.c"
		MathFunction** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		__g_list_free__g_object_unref0_0 (proposals);
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		proposals = NULL;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp9_ = functions;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp9__length1 = functions_length1;
#line 3449 "math-display.c"
		{
			MathFunction** function_collection = NULL;
			gint function_collection_length1 = 0;
			gint _function_collection_size_ = 0;
			gint function_it = 0;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			function_collection = _tmp9_;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			function_collection_length1 = _tmp9__length1;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			for (function_it = 0; function_it < _tmp9__length1; function_it = function_it + 1) {
#line 3461 "math-display.c"
				MathFunction* _tmp10_ = NULL;
				MathFunction* function = NULL;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp10_ = _g_object_ref0 (function_collection[function_it]);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				function = _tmp10_;
#line 3468 "math-display.c"
				{
					gchar* display_text = NULL;
					MathFunction* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					MathFunction* _tmp14_ = NULL;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					gchar** _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					gchar* details_text = NULL;
					MathFunction* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					gchar* label_text = NULL;
					MathFunction* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					MathFunction* _tmp29_ = NULL;
					gboolean _tmp30_ = FALSE;
					GtkSourceCompletionItem* proposal = NULL;
					const gchar* _tmp46_ = NULL;
					const gchar* _tmp47_ = NULL;
					const gchar* _tmp48_ = NULL;
					GtkSourceCompletionItem* _tmp49_ = NULL;
					GtkSourceCompletionItem* _tmp50_ = NULL;
					GtkSourceCompletionItem* _tmp51_ = NULL;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp11_ = function;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp12_ = math_function_get_name (_tmp11_);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp13_ = _tmp12_;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp14_ = function;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp15_ = math_function_get_arguments (_tmp14_, &_tmp15__length1);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp16_ = _tmp15_;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp16__length1 = _tmp15__length1;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp17_ = _vala_g_strjoinv (";", _tmp16_, _tmp16__length1);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp18_ = _tmp17_;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp19_ = g_strdup_printf ("%s(%s)", _tmp13_, _tmp18_);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp20_ = _tmp19_;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_g_free0 (_tmp18_);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					display_text = _tmp20_;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp21_ = function;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp22_ = math_function_get_description (_tmp21_);
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp23_ = _tmp22_;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp24_ = g_strdup_printf ("%s", _tmp23_);
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					details_text = _tmp24_;
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp25_ = function;
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp26_ = math_function_get_name (_tmp25_);
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp27_ = _tmp26_;
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp28_ = g_strconcat (_tmp27_, "()", NULL);
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					label_text = _tmp28_;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp29_ = function;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp30_ = math_function_is_custom_function (_tmp29_);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					if (_tmp30_) {
#line 3554 "math-display.c"
						MathFunction* _tmp31_ = NULL;
						const gchar* _tmp32_ = NULL;
						const gchar* _tmp33_ = NULL;
						MathFunction* _tmp34_ = NULL;
						gchar** _tmp35_ = NULL;
						gint _tmp35__length1 = 0;
						gchar** _tmp36_ = NULL;
						gint _tmp36__length1 = 0;
						gchar* _tmp37_ = NULL;
						gchar* _tmp38_ = NULL;
						MathFunction* _tmp39_ = NULL;
						const gchar* _tmp40_ = NULL;
						const gchar* _tmp41_ = NULL;
						MathFunction* _tmp42_ = NULL;
						const gchar* _tmp43_ = NULL;
						const gchar* _tmp44_ = NULL;
						gchar* _tmp45_ = NULL;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_tmp31_ = function;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_tmp32_ = math_function_get_name (_tmp31_);
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_tmp33_ = _tmp32_;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_tmp34_ = function;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_tmp35_ = math_function_get_arguments (_tmp34_, &_tmp35__length1);
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_tmp36_ = _tmp35_;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_tmp36__length1 = _tmp35__length1;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_tmp37_ = _vala_g_strjoinv (";", _tmp36_, _tmp36__length1);
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_tmp38_ = _tmp37_;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_tmp39_ = function;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_tmp40_ = math_function_get_expression (_tmp39_);
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_tmp41_ = _tmp40_;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_tmp42_ = function;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_tmp43_ = math_function_get_description (_tmp42_);
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_tmp44_ = _tmp43_;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_tmp45_ = g_strdup_printf ("%s(%s)=%s\n%s", _tmp33_, _tmp38_, _tmp41_, _tmp44_);
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_g_free0 (details_text);
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						details_text = _tmp45_;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
						_g_free0 (_tmp38_);
#line 3610 "math-display.c"
					}
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp46_ = display_text;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp47_ = label_text;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp48_ = details_text;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp49_ = gtk_source_completion_item_new (_tmp46_, _tmp47_, NULL, _tmp48_);
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					proposal = _tmp49_;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp50_ = proposal;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp51_ = _g_object_ref0 (_tmp50_);
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					proposals = g_list_append (proposals, _tmp51_);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_g_object_unref0 (proposal);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_g_free0 (label_text);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_g_free0 (details_text);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_g_free0 (display_text);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_g_object_unref0 (function);
#line 3638 "math-display.c"
				}
			}
		}
	}
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp52_ = context;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp53_ = proposals;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_source_completion_context_add_proposals (_tmp52_, (GtkSourceCompletionProvider*) self, _tmp53_, TRUE);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	__g_list_free__g_object_unref0_0 (proposals);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	functions = (_vala_array_free (functions, functions_length1, (GDestroyNotify) g_object_unref), NULL);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (text_buffer);
#line 3655 "math-display.c"
}


FunctionCompletionProvider* function_completion_provider_construct (GType object_type) {
	FunctionCompletionProvider * self = NULL;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self = (FunctionCompletionProvider*) completion_provider_construct (object_type);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return self;
#line 3665 "math-display.c"
}


FunctionCompletionProvider* function_completion_provider_new (void) {
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return function_completion_provider_construct (TYPE_FUNCTION_COMPLETION_PROVIDER);
#line 3672 "math-display.c"
}


static void function_completion_provider_class_init (FunctionCompletionProviderClass * klass) {
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	function_completion_provider_parent_class = g_type_class_peek_parent (klass);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	((CompletionProviderClass *) klass)->get_name = function_completion_provider_real_get_name;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	((CompletionProviderClass *) klass)->populate = function_completion_provider_real_populate;
#line 3683 "math-display.c"
}


static void function_completion_provider_instance_init (FunctionCompletionProvider * self) {
}


GType function_completion_provider_get_type (void) {
	static volatile gsize function_completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&function_completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionCompletionProvider), 0, (GInstanceInitFunc) function_completion_provider_instance_init, NULL };
		GType function_completion_provider_type_id;
		function_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "FunctionCompletionProvider", &g_define_type_info, 0);
		g_once_init_leave (&function_completion_provider_type_id__volatile, function_completion_provider_type_id);
	}
	return function_completion_provider_type_id__volatile;
}


VariableCompletionProvider* variable_completion_provider_construct (GType object_type, MathEquation* equation) {
	VariableCompletionProvider * self = NULL;
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (equation != NULL, NULL);
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self = (VariableCompletionProvider*) completion_provider_construct (object_type);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = equation;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (self->priv->_equation);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self->priv->_equation = _tmp1_;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return self;
#line 3721 "math-display.c"
}


VariableCompletionProvider* variable_completion_provider_new (MathEquation* equation) {
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return variable_completion_provider_construct (TYPE_VARIABLE_COMPLETION_PROVIDER, equation);
#line 3728 "math-display.c"
}


static gchar* variable_completion_provider_real_get_name (CompletionProvider* base) {
	VariableCompletionProvider * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self = (VariableCompletionProvider*) base;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = g_strdup ("Defined Variables");
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	result = _tmp0_;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return result;
#line 3744 "math-display.c"
}


gchar** variable_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer, MathVariables* variables, int* result_length1) {
	gchar** result = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextMark* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	gchar* search_pattern = NULL;
	GtkTextBuffer* _tmp8_ = NULL;
	GtkTextIter _tmp9_ = {0};
	GtkTextIter _tmp10_ = {0};
	gchar* _tmp11_ = NULL;
	gchar** math_variables = NULL;
	MathVariables* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gchar** _tmp14_ = NULL;
	gint math_variables_length1 = 0;
	gint _math_variables_size_ = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (text_buffer != NULL, NULL);
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_val_if_fail (variables != NULL, NULL);
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = text_buffer;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp1_ = text_buffer;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp2_ = gtk_text_buffer_get_insert (_tmp1_);
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_buffer_get_iter_at_mark (_tmp0_, &_tmp3_, _tmp2_);
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	end_iter = _tmp3_;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp4_ = text_buffer;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp5_ = text_buffer;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp6_ = gtk_text_buffer_get_insert (_tmp5_);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_text_buffer_get_iter_at_mark (_tmp4_, &_tmp7_, _tmp6_);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	start_iter = _tmp7_;
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	completion_provider_move_iter_to_name_start (&start_iter);
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp8_ = text_buffer;
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp9_ = start_iter;
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp10_ = end_iter;
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp11_ = gtk_text_buffer_get_slice (_tmp8_, &_tmp9_, &_tmp10_, FALSE);
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	search_pattern = _tmp11_;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp12_ = variables;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp14_ = math_variables_variables_eligible_for_autocompletion (_tmp12_, search_pattern, &_tmp13_);
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	math_variables = _tmp14_;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	math_variables_length1 = _tmp13_;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_math_variables_size_ = math_variables_length1;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp15_ = math_variables;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp15__length1 = math_variables_length1;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (result_length1) {
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		*result_length1 = _tmp15__length1;
#line 3827 "math-display.c"
	}
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	result = _tmp15_;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_free0 (search_pattern);
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	return result;
#line 3835 "math-display.c"
}


static void variable_completion_provider_real_populate (CompletionProvider* base, GtkSourceCompletionContext* context) {
	VariableCompletionProvider * self;
	GtkTextIter iter1 = {0};
	GtkSourceCompletionContext* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkTextBuffer* text_buffer = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	gchar** variables = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	MathEquation* _tmp6_ = NULL;
	MathVariables* _tmp7_ = NULL;
	MathVariables* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gchar** _tmp10_ = NULL;
	gint variables_length1 = 0;
	gint _variables_size_ = 0;
	GList* proposals = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GtkSourceCompletionContext* _tmp35_ = NULL;
	GList* _tmp36_ = NULL;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self = (VariableCompletionProvider*) base;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_return_if_fail (context != NULL);
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp0_ = context;
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp2_ = gtk_source_completion_context_get_iter (_tmp0_, &_tmp1_);
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	iter1 = _tmp1_;
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (!_tmp2_) {
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		return;
#line 3876 "math-display.c"
	}
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp3_ = gtk_text_iter_get_buffer (&iter1);
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	text_buffer = _tmp4_;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp5_ = text_buffer;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp6_ = self->priv->_equation;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp7_ = math_equation_get_variables (_tmp6_);
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp8_ = _tmp7_;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp10_ = variable_completion_provider_get_matches_for_completion_at_cursor (_tmp5_, _tmp8_, &_tmp9_);
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	variables = _tmp10_;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	variables_length1 = _tmp9_;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_variables_size_ = variables_length1;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	proposals = NULL;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp11_ = variables;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp11__length1 = variables_length1;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	if (_tmp11__length1 > 0) {
#line 3908 "math-display.c"
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		__g_list_free__g_object_unref0_0 (proposals);
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		proposals = NULL;
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp12_ = variables;
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
		_tmp12__length1 = variables_length1;
#line 3919 "math-display.c"
		{
			gchar** variable_collection = NULL;
			gint variable_collection_length1 = 0;
			gint _variable_collection_size_ = 0;
			gint variable_it = 0;
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			variable_collection = _tmp12_;
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			variable_collection_length1 = _tmp12__length1;
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
			for (variable_it = 0; variable_it < _tmp12__length1; variable_it = variable_it + 1) {
#line 3931 "math-display.c"
				gchar* _tmp13_ = NULL;
				gchar* variable = NULL;
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				_tmp13_ = g_strdup (variable_collection[variable_it]);
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
				variable = _tmp13_;
#line 3938 "math-display.c"
				{
					gchar* display_text = NULL;
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					gchar* details_text = NULL;
					MathEquation* _tmp16_ = NULL;
					Serializer* _tmp17_ = NULL;
					Serializer* _tmp18_ = NULL;
					MathEquation* _tmp19_ = NULL;
					MathVariables* _tmp20_ = NULL;
					MathVariables* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					Number* _tmp23_ = NULL;
					Number* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					gchar* label_text = NULL;
					const gchar* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					GtkSourceCompletionItem* proposal = NULL;
					const gchar* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					const gchar* _tmp31_ = NULL;
					GtkSourceCompletionItem* _tmp32_ = NULL;
					GtkSourceCompletionItem* _tmp33_ = NULL;
					GtkSourceCompletionItem* _tmp34_ = NULL;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp14_ = variable;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp15_ = g_strdup_printf ("%s", _tmp14_);
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					display_text = _tmp15_;
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp16_ = self->priv->_equation;
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp17_ = math_equation_get_serializer (_tmp16_);
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp18_ = _tmp17_;
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp19_ = self->priv->_equation;
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp20_ = math_equation_get_variables (_tmp19_);
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp21_ = _tmp20_;
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp22_ = variable;
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp23_ = math_variables_get (_tmp21_, _tmp22_);
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp24_ = _tmp23_;
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp25_ = serializer_to_string (_tmp18_, _tmp24_);
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp26_ = _tmp25_;
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_g_object_unref0 (_tmp24_);
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					details_text = _tmp26_;
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp27_ = variable;
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp28_ = g_strdup (_tmp27_);
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					label_text = _tmp28_;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp29_ = display_text;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp30_ = label_text;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp31_ = details_text;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp32_ = gtk_source_completion_item_new (_tmp29_, _tmp30_, NULL, _tmp31_);
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					proposal = _tmp32_;
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp33_ = proposal;
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_tmp34_ = _g_object_ref0 (_tmp33_);
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					proposals = g_list_append (proposals, _tmp34_);
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_g_object_unref0 (proposal);
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_g_free0 (label_text);
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_g_free0 (details_text);
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_g_free0 (display_text);
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
					_g_free0 (variable);
#line 4029 "math-display.c"
				}
			}
		}
	}
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp35_ = context;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_tmp36_ = proposals;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	gtk_source_completion_context_add_proposals (_tmp35_, (GtkSourceCompletionProvider*) self, _tmp36_, TRUE);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	__g_list_free__g_object_unref0_0 (proposals);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	variables = (_vala_array_free (variables, variables_length1, (GDestroyNotify) g_free), NULL);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (text_buffer);
#line 4046 "math-display.c"
}


static void variable_completion_provider_class_init (VariableCompletionProviderClass * klass) {
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	variable_completion_provider_parent_class = g_type_class_peek_parent (klass);
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	g_type_class_add_private (klass, sizeof (VariableCompletionProviderPrivate));
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	((CompletionProviderClass *) klass)->get_name = variable_completion_provider_real_get_name;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	((CompletionProviderClass *) klass)->populate = variable_completion_provider_real_populate;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	G_OBJECT_CLASS (klass)->finalize = variable_completion_provider_finalize;
#line 4061 "math-display.c"
}


static void variable_completion_provider_instance_init (VariableCompletionProvider * self) {
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self->priv = VARIABLE_COMPLETION_PROVIDER_GET_PRIVATE (self);
#line 4068 "math-display.c"
}


static void variable_completion_provider_finalize (GObject* obj) {
	VariableCompletionProvider * self;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProvider);
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	_g_object_unref0 (self->priv->_equation);
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-display.vala"
	G_OBJECT_CLASS (variable_completion_provider_parent_class)->finalize (obj);
#line 4080 "math-display.c"
}


GType variable_completion_provider_get_type (void) {
	static volatile gsize variable_completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&variable_completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VariableCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) variable_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VariableCompletionProvider), 0, (GInstanceInitFunc) variable_completion_provider_instance_init, NULL };
		GType variable_completion_provider_type_id;
		variable_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "VariableCompletionProvider", &g_define_type_info, 0);
		g_once_init_leave (&variable_completion_provider_type_id__volatile, variable_completion_provider_type_id);
	}
	return variable_completion_provider_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



