/* test-number.c generated by valac 0.29.1, the Vala compiler
 * generated from test-number.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <locale.h>


#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;


extern gint fail_count;
gint fail_count = 0;
extern gint pass_count;
gint pass_count = 0;

void pass (const gchar* text);
void fail (const gchar* text);
void test_integer (void);
GType number_get_type (void) G_GNUC_CONST;
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
gint64 number_to_integer (Number* self);
void test_unsigned_integer (void);
Number* number_new_unsigned_integer (guint64 x);
Number* number_construct_unsigned_integer (GType object_type, guint64 x);
guint64 number_to_unsigned_integer (Number* self);
void test_fraction (void);
Number* number_new_fraction (gint64 numerator, gint64 denominator);
Number* number_construct_fraction (GType object_type, gint64 numerator, gint64 denominator);
gboolean double_matches (Number* a, gdouble b);
gdouble number_to_double (Number* self);
void test_double (void);
Number* number_new_double (gdouble value);
Number* number_construct_double (GType object_type, gdouble value);
void test_complex (void);
Number* number_new_complex (Number* x, Number* y);
Number* number_construct_complex (GType object_type, Number* x, Number* y);
Number* number_real_component (Number* self);
Number* number_imaginary_component (Number* self);
void test_polar (void);
GType angle_unit_get_type (void) G_GNUC_CONST;
Number* number_new_polar (Number* r, Number* theta, AngleUnit unit);
Number* number_construct_polar (GType object_type, Number* r, Number* theta, AngleUnit unit);
void test_i (void);
Number* number_new_i (void);
Number* number_construct_i (GType object_type);
void test_pi (void);
Number* number_new_pi (void);
Number* number_construct_pi (GType object_type);
void test_eulers (void);
Number* number_new_eulers (void);
Number* number_construct_eulers (GType object_type);
void test_string (void);
Number* mp_set_from_string (const gchar* str, gint default_base);
void test_sgn (void);
Number* number_sgn (Number* self);
void test_invert_sign (void);
Number* number_invert_sign (Number* self);
void test_abs (void);
Number* number_abs (Number* self);
void test_arg (void);
Number* number_arg (Number* self, AngleUnit unit);
gboolean number_is_zero (Number* self);
void test_conjugate (void);
Number* number_conjugate (Number* self);
void test_real_component (void);
void test_imaginary_component (void);
gchar* double_string (gdouble x);
void test_integer_component (void);
Number* number_integer_component (Number* self);
void test_fractional_component (void);
Number* number_fractional_component (Number* self);
void test_fractional_part (void);
Number* number_fractional_part (Number* self);
void test_floor (void);
Number* number_floor (Number* self);
void test_ceiling (void);
Number* number_ceiling (Number* self);
void test_round (void);
Number* number_round (Number* self);
void test_reciprocal (void);
Number* number_reciprocal (Number* self);
void test_epowy (void);
Number* number_epowy (Number* self);
void test_xpowy (void);
Number* number_xpowy (Number* self, Number* y);
void test_xpowy_integer (void);
Number* number_xpowy_integer (Number* self, gint64 n);
void test_root3 (void);
Number* number_root (Number* self, gint64 n);
void test_sqrt (void);
Number* number_sqrt (Number* self);
void test_ln (void);
Number* number_ln (Number* self);
void test_logarithm2 (void);
Number* number_logarithm (Number* self, gint64 n);
void test_logarithm10 (void);
void test_is_zero (void);
void test_is_negative (void);
gboolean number_is_negative (Number* self);
void test_is_integer (void);
gboolean number_is_integer (Number* self);
void test_is_positive_integer (void);
gboolean number_is_positive_integer (Number* self);
void test_is_natural (void);
gboolean number_is_natural (Number* self);
void test_is_complex (void);
gboolean number_is_complex (Number* self);
void test_factorial (void);
Number* number_factorial (Number* self);
void test_add (void);
Number* number_add (Number* self, Number* y);
void test_subtract (void);
Number* number_subtract (Number* self, Number* y);
void test_multiply (void);
Number* number_multiply (Number* self, Number* y);
void test_multiply_integer (void);
Number* number_multiply_integer (Number* self, gint64 y);
void test_divide (void);
Number* number_divide (Number* self, Number* y);
void test_divide_integer (void);
Number* number_divide_integer (Number* self, gint64 y);
void test_modulus_divide (void);
Number* number_modulus_divide (Number* self, Number* y);
void test_sin (void);
Number* number_sin (Number* self, AngleUnit unit);
void test_cos (void);
Number* number_cos (Number* self, AngleUnit unit);
void test_and (void);
Number* number_and (Number* self, Number* y);
void test_or (void);
Number* number_or (Number* self, Number* y);
void test_xor (void);
Number* number_xor (Number* self, Number* y);
void test_not (void);
Number* number_not (Number* self, gint wordlen);
void test_shift (void);
Number* number_shift (Number* self, gint count);
void test_factorize (void);
GList* number_factorize (Number* self);
GList* factorize (gint number);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gint _vala_main (gchar** args, int args_length1);


void pass (const gchar* text) {
	gint _tmp0_ = 0;
#line 17 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp0_ = pass_count;
#line 17 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass_count = _tmp0_ + 1;
#line 190 "test-number.c"
}


void fail (const gchar* text) {
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	g_return_if_fail (text != NULL);
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp0_ = stdout;
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp1_ = text;
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	fprintf (_tmp0_, "*FAIL: %s\n", _tmp1_);
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp2_ = fail_count;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	fail_count = _tmp2_ + 1;
#line 210 "test-number.c"
}


void test_integer (void) {
	{
		gint a = 0;
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 219 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 226 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				gint64 _tmp6_ = 0LL;
				gint _tmp7_ = 0;
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 236 "test-number.c"
					gint _tmp1_ = 0;
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 242 "test-number.c"
				}
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 252 "test-number.c"
				}
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp4_;
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = z;
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = number_to_integer (_tmp5_);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = a;
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp6_ != ((gint64) _tmp7_)) {
#line 268 "test-number.c"
					gint _tmp8_ = 0;
					Number* _tmp9_ = NULL;
					gint64 _tmp10_ = 0LL;
					gint _tmp11_ = 0;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp8_ = a;
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp9_ = z;
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp10_ = number_to_integer (_tmp9_);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp11_ = a;
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp12_ = g_strdup_printf ("Number.integer (%d).to_integer () -> %lli, expected %i", _tmp8_, _tmp10_, _tmp11_);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = _tmp12_;
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp13_);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp13_);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 295 "test-number.c"
				}
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 299 "test-number.c"
			}
		}
	}
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 305 "test-number.c"
}


void test_unsigned_integer (void) {
	{
		gint a = 0;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = 0;
#line 314 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 321 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				guint64 _tmp6_ = 0ULL;
				gint _tmp7_ = 0;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 331 "test-number.c"
					gint _tmp1_ = 0;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 337 "test-number.c"
				}
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 347 "test-number.c"
				}
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_unsigned_integer ((guint64) _tmp3_);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp4_;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = z;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = number_to_unsigned_integer (_tmp5_);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = a;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp6_ != ((guint64) _tmp7_)) {
#line 363 "test-number.c"
					gint _tmp8_ = 0;
					Number* _tmp9_ = NULL;
					guint64 _tmp10_ = 0ULL;
					gint _tmp11_ = 0;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp8_ = a;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp9_ = z;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp10_ = number_to_unsigned_integer (_tmp9_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp11_ = a;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp12_ = g_strdup_printf ("Number.unsigned_integer (%d).to_unsigned_integer () -> %i, expected %i", _tmp8_, (gint) _tmp10_, _tmp11_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = _tmp12_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp13_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp13_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 390 "test-number.c"
				}
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 394 "test-number.c"
			}
		}
	}
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 400 "test-number.c"
}


void test_fraction (void) {
	{
		gint a = 0;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = 0;
#line 409 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 416 "test-number.c"
				gint _tmp2_ = 0;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 420 "test-number.c"
					gint _tmp1_ = 0;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 426 "test-number.c"
				}
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 436 "test-number.c"
				}
				{
					gint b = 0;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = 1;
#line 442 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 449 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							gint _tmp7_ = 0;
							Number* _tmp8_ = NULL;
							gdouble expected = 0.0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							Number* _tmp11_ = NULL;
							gdouble _tmp12_ = 0.0;
							gboolean _tmp13_ = FALSE;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 463 "test-number.c"
								gint _tmp4_ = 0;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 469 "test-number.c"
							}
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 479 "test-number.c"
							}
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = b;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = number_new_fraction ((gint64) _tmp6_, (gint64) _tmp7_);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp8_;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = a;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = b;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = ((gdouble) _tmp9_) / _tmp10_;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = z;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = expected;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = double_matches (_tmp11_, _tmp12_);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp13_) {
#line 503 "test-number.c"
								gint _tmp14_ = 0;
								gint _tmp15_ = 0;
								Number* _tmp16_ = NULL;
								gdouble _tmp17_ = 0.0;
								gdouble _tmp18_ = 0.0;
								gchar* _tmp19_ = NULL;
								gchar* _tmp20_ = NULL;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp14_ = a;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp15_ = b;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp16_ = z;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp17_ = number_to_double (_tmp16_);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp18_ = expected;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp19_ = g_strdup_printf ("Number.fraction (%d, %d) -> %f, expected %f", _tmp14_, _tmp15_, _tmp17_, _tmp18_);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp20_ = _tmp19_;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp20_);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp20_);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 533 "test-number.c"
							}
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 537 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 546 "test-number.c"
}


void test_double (void) {
	{
		gdouble a = 0.0;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10.0;
#line 555 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 562 "test-number.c"
				gdouble _tmp2_ = 0.0;
				Number* z = NULL;
				gdouble _tmp3_ = 0.0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				gdouble _tmp6_ = 0.0;
				gdouble _tmp7_ = 0.0;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 572 "test-number.c"
					gdouble _tmp1_ = 0.0;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 0.5;
#line 578 "test-number.c"
				}
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10.0)) {
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 588 "test-number.c"
				}
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_double (_tmp3_);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp4_;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = z;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = number_to_double (_tmp5_);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = a;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp6_ != _tmp7_) {
#line 604 "test-number.c"
					gdouble _tmp8_ = 0.0;
					Number* _tmp9_ = NULL;
					gdouble _tmp10_ = 0.0;
					gdouble _tmp11_ = 0.0;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp8_ = a;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp9_ = z;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp10_ = number_to_double (_tmp9_);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp11_ = a;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp12_ = g_strdup_printf ("Number.double (%f).to_double () -> %f, expected %f", _tmp8_, _tmp10_, _tmp11_);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = _tmp12_;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp13_);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp13_);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 631 "test-number.c"
				}
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 635 "test-number.c"
			}
		}
	}
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 641 "test-number.c"
}


void test_complex (void) {
	{
		gint a = 0;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 650 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 657 "test-number.c"
				gint _tmp2_ = 0;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 661 "test-number.c"
					gint _tmp1_ = 0;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 667 "test-number.c"
				}
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 677 "test-number.c"
				}
				{
					gint b = 0;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = -10;
#line 683 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 690 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint re_expected = 0;
							gint _tmp14_ = 0;
							gint im_expected = 0;
							gint _tmp15_ = 0;
							gboolean _tmp16_ = FALSE;
							Number* _tmp17_ = NULL;
							Number* _tmp18_ = NULL;
							Number* _tmp19_ = NULL;
							gint64 _tmp20_ = 0LL;
							gint _tmp21_ = 0;
							gboolean _tmp22_ = FALSE;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 714 "test-number.c"
								gint _tmp4_ = 0;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 720 "test-number.c"
							}
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 730 "test-number.c"
							}
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp11_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp13_;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = a;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							re_expected = _tmp14_;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = b;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							im_expected = _tmp15_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = z;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp18_ = number_real_component (_tmp17_);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp19_ = _tmp18_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp20_ = number_to_integer (_tmp19_);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp21_ = re_expected;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp22_ = _tmp20_ != ((gint64) _tmp21_);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp19_);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp22_) {
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp16_ = TRUE;
#line 780 "test-number.c"
							} else {
								Number* _tmp23_ = NULL;
								Number* _tmp24_ = NULL;
								Number* _tmp25_ = NULL;
								gint64 _tmp26_ = 0LL;
								gint _tmp27_ = 0;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp23_ = z;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp24_ = number_imaginary_component (_tmp23_);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp25_ = _tmp24_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp26_ = number_to_integer (_tmp25_);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp27_ = im_expected;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp16_ = _tmp26_ != ((gint64) _tmp27_);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (_tmp25_);
#line 801 "test-number.c"
							}
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp16_) {
#line 805 "test-number.c"
								gint _tmp28_ = 0;
								gint _tmp29_ = 0;
								Number* _tmp30_ = NULL;
								Number* _tmp31_ = NULL;
								Number* _tmp32_ = NULL;
								gint64 _tmp33_ = 0LL;
								Number* _tmp34_ = NULL;
								Number* _tmp35_ = NULL;
								Number* _tmp36_ = NULL;
								gint64 _tmp37_ = 0LL;
								gint _tmp38_ = 0;
								gint _tmp39_ = 0;
								gchar* _tmp40_ = NULL;
								gchar* _tmp41_ = NULL;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp28_ = a;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp29_ = b;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp30_ = z;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp31_ = number_real_component (_tmp30_);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp32_ = _tmp31_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp33_ = number_to_integer (_tmp32_);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp34_ = z;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp35_ = number_imaginary_component (_tmp34_);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp36_ = _tmp35_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp37_ = number_to_integer (_tmp36_);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp38_ = re_expected;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp39_ = im_expected;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp40_ = g_strdup_printf ("Number.complex (%d%+di) -> %d%+di, expected %d%+di", _tmp28_, _tmp29_, (gint) _tmp33_, (gint) _tmp37_, _tmp38_, _tmp39_);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp41_ = _tmp40_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp41_);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp41_);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (_tmp36_);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (_tmp32_);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 860 "test-number.c"
							}
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 864 "test-number.c"
						}
					}
				}
			}
		}
	}
}


void test_polar (void) {
	{
		gint ri = 0;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		ri = -10;
#line 879 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 886 "test-number.c"
				gint _tmp2_ = 0;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 890 "test-number.c"
					gint _tmp1_ = 0;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = ri;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					ri = _tmp1_ + 1;
#line 896 "test-number.c"
				}
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = ri;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 906 "test-number.c"
				}
				{
					gint theta_i = 0;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					theta_i = -10;
#line 912 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 919 "test-number.c"
							gint _tmp5_ = 0;
							gdouble r = 0.0;
							gint _tmp6_ = 0;
							gdouble theta = 0.0;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gdouble _tmp8_ = 0.0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gdouble _tmp11_ = 0.0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gdouble re_expected = 0.0;
							gdouble _tmp16_ = 0.0;
							gdouble _tmp17_ = 0.0;
							gdouble _tmp18_ = 0.0;
							gdouble im_expected = 0.0;
							gdouble _tmp19_ = 0.0;
							gdouble _tmp20_ = 0.0;
							gdouble _tmp21_ = 0.0;
							gboolean _tmp22_ = FALSE;
							Number* _tmp23_ = NULL;
							Number* _tmp24_ = NULL;
							Number* _tmp25_ = NULL;
							gdouble _tmp26_ = 0.0;
							gboolean _tmp27_ = FALSE;
							gboolean _tmp28_ = FALSE;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 951 "test-number.c"
								gint _tmp4_ = 0;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = theta_i;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								theta_i = _tmp4_ + 1;
#line 957 "test-number.c"
							}
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = theta_i;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 967 "test-number.c"
							}
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = ri;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							r = (gdouble) _tmp6_;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = theta_i;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							theta = ((2 * G_PI) * _tmp7_) / 10.0;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = r;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = number_new_double (_tmp8_);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = _tmp9_;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = theta;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_new_double (_tmp11_);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = number_new_polar (_tmp10_, _tmp13_, ANGLE_UNIT_RADIANS);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = _tmp14_;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp13_);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp10_);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp15_;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp16_ = r;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = theta;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp18_ = cos (_tmp17_);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							re_expected = _tmp16_ * _tmp18_;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp19_ = r;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp20_ = theta;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp21_ = sin (_tmp20_);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							im_expected = _tmp19_ * _tmp21_;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp23_ = z;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp24_ = number_real_component (_tmp23_);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp25_ = _tmp24_;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp26_ = re_expected;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp27_ = double_matches (_tmp25_, _tmp26_);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp28_ = !_tmp27_;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp25_);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp28_) {
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = TRUE;
#line 1033 "test-number.c"
							} else {
								Number* _tmp29_ = NULL;
								Number* _tmp30_ = NULL;
								Number* _tmp31_ = NULL;
								gdouble _tmp32_ = 0.0;
								gboolean _tmp33_ = FALSE;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp29_ = z;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp30_ = number_imaginary_component (_tmp29_);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp31_ = _tmp30_;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp32_ = im_expected;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp33_ = double_matches (_tmp31_, _tmp32_);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = !_tmp33_;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (_tmp31_);
#line 1054 "test-number.c"
							}
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp22_) {
#line 1058 "test-number.c"
								gdouble _tmp34_ = 0.0;
								gdouble _tmp35_ = 0.0;
								Number* _tmp36_ = NULL;
								Number* _tmp37_ = NULL;
								Number* _tmp38_ = NULL;
								gdouble _tmp39_ = 0.0;
								Number* _tmp40_ = NULL;
								Number* _tmp41_ = NULL;
								Number* _tmp42_ = NULL;
								gdouble _tmp43_ = 0.0;
								gdouble _tmp44_ = 0.0;
								gdouble _tmp45_ = 0.0;
								gchar* _tmp46_ = NULL;
								gchar* _tmp47_ = NULL;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp34_ = r;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp35_ = theta;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp36_ = z;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp37_ = number_real_component (_tmp36_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp38_ = _tmp37_;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp39_ = number_to_double (_tmp38_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp40_ = z;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp41_ = number_imaginary_component (_tmp40_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp42_ = _tmp41_;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp43_ = number_to_double (_tmp42_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp44_ = re_expected;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp45_ = im_expected;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp46_ = g_strdup_printf ("Number.polar (%f, %f) -> %f%+fi, expected %f%+fi", _tmp34_, _tmp35_, _tmp39_, _tmp43_, _tmp44_, _tmp45_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp47_ = _tmp46_;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp47_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp47_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (_tmp42_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (_tmp38_);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 1113 "test-number.c"
							}
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 1117 "test-number.c"
						}
					}
				}
			}
		}
	}
}


void test_i (void) {
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	gboolean _tmp6_ = FALSE;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp0_ = number_new_i ();
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	z = _tmp0_;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp2_ = z;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp3_ = number_real_component (_tmp2_);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp4_ = _tmp3_;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp5_ = number_to_integer (_tmp4_);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp6_ = _tmp5_ != ((gint64) 0);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_g_object_unref0 (_tmp4_);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	if (_tmp6_) {
#line 1154 "test-number.c"
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp7_ = z;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp8_ = number_imaginary_component (_tmp7_);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp9_ = _tmp8_;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp10_ = number_to_integer (_tmp9_);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp1_ = _tmp10_ != ((gint64) 1);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_g_object_unref0 (_tmp9_);
#line 1171 "test-number.c"
	} else {
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp1_ = FALSE;
#line 1175 "test-number.c"
	}
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	if (_tmp1_) {
#line 1179 "test-number.c"
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		gint64 _tmp14_ = 0LL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		gint64 _tmp18_ = 0LL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp11_ = z;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp12_ = number_real_component (_tmp11_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp13_ = _tmp12_;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp14_ = number_to_integer (_tmp13_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp15_ = z;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp16_ = number_imaginary_component (_tmp15_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp17_ = _tmp16_;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp18_ = number_to_integer (_tmp17_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp19_ = g_strdup_printf ("Number.i () -> %d%+di, expected i", (gint) _tmp14_, (gint) _tmp18_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp20_ = _tmp19_;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		fail (_tmp20_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_g_free0 (_tmp20_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_g_object_unref0 (_tmp17_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_g_object_unref0 (_tmp13_);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_g_object_unref0 (z);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		return;
#line 1222 "test-number.c"
	}
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_g_object_unref0 (z);
#line 1228 "test-number.c"
}


void test_pi (void) {
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gdouble expected = 0.0;
	Number* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp3_ = FALSE;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp0_ = number_new_pi ();
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	z = _tmp0_;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	expected = G_PI;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp1_ = z;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp2_ = expected;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp3_ = double_matches (_tmp1_, _tmp2_);
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	if (!_tmp3_) {
#line 1253 "test-number.c"
		Number* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp4_ = z;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp5_ = number_to_double (_tmp4_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp6_ = expected;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp7_ = g_strdup_printf ("Number.pi () -> %f, expected %f", _tmp5_, _tmp6_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp8_ = _tmp7_;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		fail (_tmp8_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_g_free0 (_tmp8_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_g_object_unref0 (z);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		return;
#line 1277 "test-number.c"
	}
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_g_object_unref0 (z);
#line 1283 "test-number.c"
}


void test_eulers (void) {
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gdouble expected = 0.0;
	Number* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp3_ = FALSE;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp0_ = number_new_eulers ();
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	z = _tmp0_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	expected = G_E;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp1_ = z;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp2_ = expected;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp3_ = double_matches (_tmp1_, _tmp2_);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	if (!_tmp3_) {
#line 1308 "test-number.c"
		Number* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp4_ = z;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp5_ = number_to_double (_tmp4_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp6_ = expected;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp7_ = g_strdup_printf ("Number.eulers () -> %f, expected %f", _tmp5_, _tmp6_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp8_ = _tmp7_;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		fail (_tmp8_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_g_free0 (_tmp8_);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_g_object_unref0 (z);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		return;
#line 1332 "test-number.c"
	}
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_g_object_unref0 (z);
#line 1338 "test-number.c"
}


void test_string (void) {
	{
		gint a = 0;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 1347 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 1354 "test-number.c"
				gint _tmp2_ = 0;
				gchar* s = NULL;
				gint _tmp3_ = 0;
				gchar* _tmp4_ = NULL;
				Number* z = NULL;
				const gchar* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp11_ = NULL;
				gint64 _tmp12_ = 0LL;
				gint _tmp13_ = 0;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 1368 "test-number.c"
					gint _tmp1_ = 0;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 1374 "test-number.c"
				}
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 1384 "test-number.c"
				}
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = g_strdup_printf ("%d", _tmp3_);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				s = _tmp4_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = s;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = mp_set_from_string (_tmp5_, 10);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp6_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = z;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp7_ == NULL) {
#line 1402 "test-number.c"
					const gchar* _tmp8_ = NULL;
					gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp8_ = s;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp9_ = g_strdup_printf ("mp_set_from_string (\"%s\") -> null", _tmp8_);
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp10_ = _tmp9_;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp10_);
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp10_);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (s);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 1422 "test-number.c"
				}
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = z;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = number_to_integer (_tmp11_);
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp13_ = a;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp12_ != ((gint64) _tmp13_)) {
#line 1432 "test-number.c"
					const gchar* _tmp14_ = NULL;
					Number* _tmp15_ = NULL;
					gint64 _tmp16_ = 0LL;
					gint _tmp17_ = 0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = s;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = z;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = number_to_integer (_tmp15_);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = a;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = g_strdup_printf ("mp_set_from_string (\"%s\").to_integer () -> %d, expected %d", _tmp14_, (gint) _tmp16_, _tmp17_);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp19_ = _tmp18_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp19_);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp19_);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (s);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 1461 "test-number.c"
				}
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_free0 (s);
#line 1467 "test-number.c"
			}
		}
	}
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 1473 "test-number.c"
}


void test_sgn (void) {
	{
		gint a = 0;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 1482 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 1489 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gint expected = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				gint64 _tmp10_ = 0LL;
				gint _tmp11_ = 0;
				gboolean _tmp12_ = FALSE;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 1505 "test-number.c"
					gint _tmp1_ = 0;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 1511 "test-number.c"
				}
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 1521 "test-number.c"
				}
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp4_;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = 0;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = a;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp5_ < 0) {
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					expected = -1;
#line 1537 "test-number.c"
				}
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = a;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp6_ > 0) {
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					expected = 1;
#line 1545 "test-number.c"
				}
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = z;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = number_sgn (_tmp7_);
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = _tmp8_;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = number_to_integer (_tmp9_);
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = expected;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = _tmp10_ != ((gint64) _tmp11_);
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp9_);
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp12_) {
#line 1563 "test-number.c"
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					Number* _tmp15_ = NULL;
					Number* _tmp16_ = NULL;
					gint64 _tmp17_ = 0LL;
					gint _tmp18_ = 0;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = a;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = z;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = number_sgn (_tmp14_);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = _tmp15_;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = number_to_integer (_tmp16_);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = expected;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp19_ = g_strdup_printf ("(%d).sgn () -> %d, expected %d", _tmp13_, (gint) _tmp17_, _tmp18_);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp20_ = _tmp19_;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp20_);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp20_);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (_tmp16_);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 1598 "test-number.c"
				}
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 1602 "test-number.c"
			}
		}
	}
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 1608 "test-number.c"
}


void test_invert_sign (void) {
	{
		gint a = 0;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 1617 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 1624 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gint expected = 0;
				gint _tmp5_ = 0;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gint64 _tmp9_ = 0LL;
				gint _tmp10_ = 0;
				gboolean _tmp11_ = FALSE;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 1639 "test-number.c"
					gint _tmp1_ = 0;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 1645 "test-number.c"
				}
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 1655 "test-number.c"
				}
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp4_;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = a;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = -_tmp5_;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = z;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = number_invert_sign (_tmp6_);
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = _tmp7_;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = number_to_integer (_tmp8_);
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = expected;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = _tmp9_ != ((gint64) _tmp10_);
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp8_);
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp11_) {
#line 1683 "test-number.c"
					gint _tmp12_ = 0;
					Number* _tmp13_ = NULL;
					Number* _tmp14_ = NULL;
					Number* _tmp15_ = NULL;
					gint64 _tmp16_ = 0LL;
					gint _tmp17_ = 0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp12_ = a;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = z;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = number_invert_sign (_tmp13_);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = _tmp14_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = number_to_integer (_tmp15_);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = expected;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = g_strdup_printf ("(%d).invert_sign () -> %d, expected %d", _tmp12_, (gint) _tmp16_, _tmp17_);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp19_ = _tmp18_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp19_);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp19_);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (_tmp15_);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 1718 "test-number.c"
				}
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 1722 "test-number.c"
			}
		}
	}
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 1728 "test-number.c"
}


void test_abs (void) {
	{
		gint a = 0;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 1737 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 1744 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gint expected = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				gint64 _tmp10_ = 0LL;
				gint _tmp11_ = 0;
				gboolean _tmp12_ = FALSE;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 1760 "test-number.c"
					gint _tmp1_ = 0;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 1766 "test-number.c"
				}
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 1776 "test-number.c"
				}
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp4_;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = a;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = abs (_tmp5_);
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp6_;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = z;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = number_abs (_tmp7_);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = _tmp8_;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = number_to_integer (_tmp9_);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = expected;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = _tmp10_ != ((gint64) _tmp11_);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp9_);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp12_) {
#line 1806 "test-number.c"
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					Number* _tmp15_ = NULL;
					Number* _tmp16_ = NULL;
					gint64 _tmp17_ = 0LL;
					gint _tmp18_ = 0;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = a;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = z;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = number_abs (_tmp14_);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = _tmp15_;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = number_to_integer (_tmp16_);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = expected;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp19_ = g_strdup_printf ("(%d).abs () -> %d, expected %d", _tmp13_, (gint) _tmp17_, _tmp18_);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp20_ = _tmp19_;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp20_);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp20_);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (_tmp16_);
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 1841 "test-number.c"
				}
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 1845 "test-number.c"
			}
		}
	}
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 1851 "test-number.c"
}


void test_arg (void) {
	{
		gint a = 0;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 1860 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 1867 "test-number.c"
				gint _tmp2_ = 0;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 1871 "test-number.c"
					gint _tmp1_ = 0;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 1877 "test-number.c"
				}
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 1887 "test-number.c"
				}
				{
					gint b = 0;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = -10;
#line 1893 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 1900 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gdouble expected = 0.0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							gdouble _tmp18_ = 0.0;
							gboolean _tmp19_ = FALSE;
							Number* _tmp20_ = NULL;
							Number* _tmp21_ = NULL;
							Number* _tmp22_ = NULL;
							gdouble _tmp23_ = 0.0;
							gboolean _tmp24_ = FALSE;
							gboolean _tmp25_ = FALSE;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 1926 "test-number.c"
								gint _tmp4_ = 0;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 1932 "test-number.c"
							}
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 1942 "test-number.c"
							}
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp11_);
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp13_;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = z;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = number_arg (_tmp14_, ANGLE_UNIT_RADIANS);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp15_;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp16_ = b;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = a;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp18_ = atan2 ((gdouble) _tmp16_, (gdouble) _tmp17_);
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = _tmp18_;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp20_ = z;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp21_ = number_real_component (_tmp20_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp22_ = _tmp21_;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp23_ = expected;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp24_ = double_matches (_tmp22_, _tmp23_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp25_ = !_tmp24_;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp22_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp25_) {
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp19_ = TRUE;
#line 2000 "test-number.c"
							} else {
								Number* _tmp26_ = NULL;
								Number* _tmp27_ = NULL;
								Number* _tmp28_ = NULL;
								gboolean _tmp29_ = FALSE;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp26_ = z;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp27_ = number_imaginary_component (_tmp26_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp28_ = _tmp27_;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp29_ = number_is_zero (_tmp28_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp19_ = !_tmp29_;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (_tmp28_);
#line 2018 "test-number.c"
							}
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp19_) {
#line 2022 "test-number.c"
								gint _tmp30_ = 0;
								gint _tmp31_ = 0;
								Number* _tmp32_ = NULL;
								Number* _tmp33_ = NULL;
								Number* _tmp34_ = NULL;
								gdouble _tmp35_ = 0.0;
								Number* _tmp36_ = NULL;
								Number* _tmp37_ = NULL;
								Number* _tmp38_ = NULL;
								gdouble _tmp39_ = 0.0;
								gdouble _tmp40_ = 0.0;
								gchar* _tmp41_ = NULL;
								gchar* _tmp42_ = NULL;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp30_ = a;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp31_ = b;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp32_ = z;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp33_ = number_real_component (_tmp32_);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp34_ = _tmp33_;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp35_ = number_to_double (_tmp34_);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp36_ = z;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp37_ = number_imaginary_component (_tmp36_);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp38_ = _tmp37_;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp39_ = number_to_double (_tmp38_);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp40_ = expected;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp41_ = g_strdup_printf ("(%d%+di).arg () -> %f%+fi, expected %f", _tmp30_, _tmp31_, _tmp35_, _tmp39_, _tmp40_);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp42_ = _tmp41_;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp42_);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp42_);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (_tmp38_);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (_tmp34_);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 2074 "test-number.c"
							}
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 2078 "test-number.c"
						}
					}
				}
			}
		}
	}
}


void test_conjugate (void) {
	{
		gint a = 0;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 2093 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 2100 "test-number.c"
				gint _tmp2_ = 0;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 2104 "test-number.c"
					gint _tmp1_ = 0;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 2110 "test-number.c"
				}
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 2120 "test-number.c"
				}
				{
					gint b = 0;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = -10;
#line 2126 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 2133 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gint re_expected = 0;
							gint _tmp16_ = 0;
							gint im_expected = 0;
							gint _tmp17_ = 0;
							gboolean _tmp18_ = FALSE;
							Number* _tmp19_ = NULL;
							Number* _tmp20_ = NULL;
							Number* _tmp21_ = NULL;
							gint64 _tmp22_ = 0LL;
							gint _tmp23_ = 0;
							gboolean _tmp24_ = FALSE;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 2159 "test-number.c"
								gint _tmp4_ = 0;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 2165 "test-number.c"
							}
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 2175 "test-number.c"
							}
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp11_);
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp13_;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = z;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = number_conjugate (_tmp14_);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp15_;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp16_ = a;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							re_expected = _tmp16_;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = b;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							im_expected = -_tmp17_;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp19_ = z;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp20_ = number_real_component (_tmp19_);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp21_ = _tmp20_;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp22_ = number_to_integer (_tmp21_);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp23_ = re_expected;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp24_ = _tmp22_ != ((gint64) _tmp23_);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp21_);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp24_) {
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp18_ = TRUE;
#line 2233 "test-number.c"
							} else {
								Number* _tmp25_ = NULL;
								Number* _tmp26_ = NULL;
								Number* _tmp27_ = NULL;
								gint64 _tmp28_ = 0LL;
								gint _tmp29_ = 0;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp25_ = z;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp26_ = number_imaginary_component (_tmp25_);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp27_ = _tmp26_;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp28_ = number_to_integer (_tmp27_);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp29_ = im_expected;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp18_ = _tmp28_ != ((gint64) _tmp29_);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (_tmp27_);
#line 2254 "test-number.c"
							}
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp18_) {
#line 2258 "test-number.c"
								gint _tmp30_ = 0;
								gint _tmp31_ = 0;
								Number* _tmp32_ = NULL;
								Number* _tmp33_ = NULL;
								Number* _tmp34_ = NULL;
								gint64 _tmp35_ = 0LL;
								Number* _tmp36_ = NULL;
								Number* _tmp37_ = NULL;
								Number* _tmp38_ = NULL;
								gint64 _tmp39_ = 0LL;
								gint _tmp40_ = 0;
								gint _tmp41_ = 0;
								gchar* _tmp42_ = NULL;
								gchar* _tmp43_ = NULL;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp30_ = a;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp31_ = b;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp32_ = z;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp33_ = number_real_component (_tmp32_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp34_ = _tmp33_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp35_ = number_to_integer (_tmp34_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp36_ = z;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp37_ = number_imaginary_component (_tmp36_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp38_ = _tmp37_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp39_ = number_to_integer (_tmp38_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp40_ = re_expected;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp41_ = im_expected;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp42_ = g_strdup_printf ("(%d%+di).real_component () -> %d%+di, expected %d%+di", _tmp30_, _tmp31_, (gint) _tmp35_, (gint) _tmp39_, _tmp40_, _tmp41_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp43_ = _tmp42_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp43_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp43_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (_tmp38_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (_tmp34_);
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 2313 "test-number.c"
							}
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 2317 "test-number.c"
						}
					}
				}
			}
		}
	}
}


void test_real_component (void) {
	{
		gint a = 0;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 2332 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 2339 "test-number.c"
				gint _tmp2_ = 0;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 2343 "test-number.c"
					gint _tmp1_ = 0;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 2349 "test-number.c"
				}
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 2359 "test-number.c"
				}
				{
					gint b = 0;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = -10;
#line 2365 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 2372 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							Number* _tmp15_ = NULL;
							Number* _tmp16_ = NULL;
							Number* _tmp17_ = NULL;
							gint64 _tmp18_ = 0LL;
							gint _tmp19_ = 0;
							gboolean _tmp20_ = FALSE;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 2393 "test-number.c"
								gint _tmp4_ = 0;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 2399 "test-number.c"
							}
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 2409 "test-number.c"
							}
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp11_);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp13_;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = a;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = _tmp14_;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = z;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp16_ = number_real_component (_tmp15_);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = _tmp16_;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp18_ = number_to_integer (_tmp17_);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp19_ = expected;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp20_ = _tmp18_ != ((gint64) _tmp19_);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp17_);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp20_) {
#line 2453 "test-number.c"
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								Number* _tmp23_ = NULL;
								Number* _tmp24_ = NULL;
								Number* _tmp25_ = NULL;
								gint64 _tmp26_ = 0LL;
								gint _tmp27_ = 0;
								gchar* _tmp28_ = NULL;
								gchar* _tmp29_ = NULL;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp21_ = a;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = b;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp23_ = z;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp24_ = number_real_component (_tmp23_);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp25_ = _tmp24_;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp26_ = number_to_integer (_tmp25_);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp27_ = expected;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp28_ = g_strdup_printf ("(%d+%di).real_component () -> %d, expected %d", _tmp21_, _tmp22_, (gint) _tmp26_, _tmp27_);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp29_ = _tmp28_;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp29_);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp29_);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (_tmp25_);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 2491 "test-number.c"
							}
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 2495 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 2504 "test-number.c"
}


void test_imaginary_component (void) {
	{
		gint a = 0;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 2513 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 2520 "test-number.c"
				gint _tmp2_ = 0;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 2524 "test-number.c"
					gint _tmp1_ = 0;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 2530 "test-number.c"
				}
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 2540 "test-number.c"
				}
				{
					gint b = 0;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = -10;
#line 2546 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 2553 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							Number* _tmp15_ = NULL;
							Number* _tmp16_ = NULL;
							Number* _tmp17_ = NULL;
							gint64 _tmp18_ = 0LL;
							gint _tmp19_ = 0;
							gboolean _tmp20_ = FALSE;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 2574 "test-number.c"
								gint _tmp4_ = 0;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 2580 "test-number.c"
							}
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 2590 "test-number.c"
							}
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp11_);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp13_;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = b;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = _tmp14_;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = z;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp16_ = number_imaginary_component (_tmp15_);
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = _tmp16_;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp18_ = number_to_integer (_tmp17_);
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp19_ = expected;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp20_ = _tmp18_ != ((gint64) _tmp19_);
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp17_);
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp20_) {
#line 2634 "test-number.c"
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								Number* _tmp23_ = NULL;
								Number* _tmp24_ = NULL;
								Number* _tmp25_ = NULL;
								gint64 _tmp26_ = 0LL;
								gint _tmp27_ = 0;
								gchar* _tmp28_ = NULL;
								gchar* _tmp29_ = NULL;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp21_ = a;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = b;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp23_ = z;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp24_ = number_imaginary_component (_tmp23_);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp25_ = _tmp24_;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp26_ = number_to_integer (_tmp25_);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp27_ = expected;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp28_ = g_strdup_printf ("(%d+%di).imaginary_component () -> %d, expected %d", _tmp21_, _tmp22_, (gint) _tmp26_, _tmp27_);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp29_ = _tmp28_;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp29_);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp29_);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (_tmp25_);
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 2672 "test-number.c"
							}
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 2676 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 2685 "test-number.c"
}


gboolean double_matches (Number* a, gdouble b) {
	gboolean result = FALSE;
	Number* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp0_ = a;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp1_ = number_to_double (_tmp0_);
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp2_ = double_string (_tmp1_);
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp3_ = _tmp2_;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp4_ = b;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp5_ = double_string (_tmp4_);
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp6_ = _tmp5_;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp7_ = g_strcmp0 (_tmp3_, _tmp6_) == 0;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_g_free0 (_tmp6_);
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_g_free0 (_tmp3_);
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	result = _tmp7_;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	return result;
#line 2725 "test-number.c"
}


gchar* double_string (gdouble x) {
	gchar* result = NULL;
	gchar* value = NULL;
	gdouble _tmp0_ = 0.0;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp0_ = x;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp1_ = g_strdup_printf ("%.6f", _tmp0_);
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	value = _tmp1_;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp2_ = value;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	if (g_strcmp0 (_tmp2_, "-0.000000") == 0) {
#line 2745 "test-number.c"
		gchar* _tmp3_ = NULL;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp3_ = g_strdup ("0.000000");
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		result = _tmp3_;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_g_free0 (value);
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		return result;
#line 2755 "test-number.c"
	} else {
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		result = value;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		return result;
#line 2761 "test-number.c"
	}
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_g_free0 (value);
#line 2765 "test-number.c"
}


void test_integer_component (void) {
	{
		gint ai = 0;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		ai = -100;
#line 2774 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 2781 "test-number.c"
				gint _tmp2_ = 0;
				gdouble a = 0.0;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 2799 "test-number.c"
					gint _tmp1_ = 0;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = ai;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					ai = _tmp1_ + 1;
#line 2805 "test-number.c"
				}
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = ai;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 100)) {
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 2815 "test-number.c"
				}
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = ai;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				a = _tmp3_ / 10.0;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = a;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = number_new_double (_tmp4_);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = _tmp5_;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = number_integer_component (_tmp6_);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = _tmp7_;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp6_);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp8_;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = a;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = trunc (_tmp9_);
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp10_;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = z;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = expected;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp13_) {
#line 2849 "test-number.c"
					gdouble _tmp14_ = 0.0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = a;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = z;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = number_to_double (_tmp15_);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = expected;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = g_strdup_printf ("(%f).integer_component () -> %f, expected %f", _tmp14_, _tmp16_, _tmp17_);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp19_ = _tmp18_;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp19_);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp19_);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 2876 "test-number.c"
				}
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 2880 "test-number.c"
			}
		}
	}
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 2886 "test-number.c"
}


void test_fractional_component (void) {
	{
		gint ai = 0;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		ai = -100;
#line 2895 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 2902 "test-number.c"
				gint _tmp2_ = 0;
				gdouble a = 0.0;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				gdouble _tmp11_ = 0.0;
				Number* _tmp12_ = NULL;
				gdouble _tmp13_ = 0.0;
				gboolean _tmp14_ = FALSE;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 2921 "test-number.c"
					gint _tmp1_ = 0;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = ai;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					ai = _tmp1_ + 1;
#line 2927 "test-number.c"
				}
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = ai;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 100)) {
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 2937 "test-number.c"
				}
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = ai;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				a = _tmp3_ / 10.0;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = a;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = number_new_double (_tmp4_);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = _tmp5_;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = number_fractional_component (_tmp6_);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = _tmp7_;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp6_);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp8_;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = a;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = a;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = trunc (_tmp10_);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp9_ - _tmp11_;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = z;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp13_ = expected;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp14_ = double_matches (_tmp12_, _tmp13_);
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp14_) {
#line 2973 "test-number.c"
					gdouble _tmp15_ = 0.0;
					Number* _tmp16_ = NULL;
					gdouble _tmp17_ = 0.0;
					gdouble _tmp18_ = 0.0;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = a;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = z;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = number_to_double (_tmp16_);
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = expected;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp19_ = g_strdup_printf ("(%f).fractional_component () -> %f, expected %f", _tmp15_, _tmp17_, _tmp18_);
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp20_ = _tmp19_;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp20_);
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp20_);
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 3000 "test-number.c"
				}
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 3004 "test-number.c"
			}
		}
	}
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 3010 "test-number.c"
}


void test_fractional_part (void) {
	{
		gint ai = 0;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		ai = -100;
#line 3019 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 3026 "test-number.c"
				gint _tmp2_ = 0;
				gdouble a = 0.0;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				gdouble _tmp11_ = 0.0;
				Number* _tmp12_ = NULL;
				gdouble _tmp13_ = 0.0;
				gboolean _tmp14_ = FALSE;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 3045 "test-number.c"
					gint _tmp1_ = 0;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = ai;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					ai = _tmp1_ + 1;
#line 3051 "test-number.c"
				}
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = ai;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 100)) {
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 3061 "test-number.c"
				}
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = ai;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				a = _tmp3_ / 10.0;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = a;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = number_new_double (_tmp4_);
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = _tmp5_;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = number_fractional_part (_tmp6_);
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = _tmp7_;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp6_);
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp8_;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = a;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = a;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = floor (_tmp10_);
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp9_ - _tmp11_;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = z;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp13_ = expected;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp14_ = double_matches (_tmp12_, _tmp13_);
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp14_) {
#line 3097 "test-number.c"
					gdouble _tmp15_ = 0.0;
					Number* _tmp16_ = NULL;
					gdouble _tmp17_ = 0.0;
					gdouble _tmp18_ = 0.0;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = a;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = z;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = number_to_double (_tmp16_);
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = expected;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp19_ = g_strdup_printf ("(%f).fractional_part () -> %f, expected %f", _tmp15_, _tmp17_, _tmp18_);
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp20_ = _tmp19_;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp20_);
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp20_);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 3124 "test-number.c"
				}
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 3128 "test-number.c"
			}
		}
	}
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 3134 "test-number.c"
}


void test_floor (void) {
	{
		gint ai = 0;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		ai = -100;
#line 3143 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 3150 "test-number.c"
				gint _tmp2_ = 0;
				gdouble a = 0.0;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 3168 "test-number.c"
					gint _tmp1_ = 0;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = ai;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					ai = _tmp1_ + 1;
#line 3174 "test-number.c"
				}
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = ai;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 100)) {
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 3184 "test-number.c"
				}
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = ai;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				a = _tmp3_ / 10.0;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = a;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = number_new_double (_tmp4_);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = _tmp5_;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = number_floor (_tmp6_);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = _tmp7_;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp6_);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp8_;
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = a;
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = floor (_tmp9_);
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp10_;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = z;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = expected;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp13_) {
#line 3218 "test-number.c"
					gdouble _tmp14_ = 0.0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = a;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = z;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = number_to_double (_tmp15_);
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = expected;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = g_strdup_printf ("(%f).floor () -> %f, expected %f", _tmp14_, _tmp16_, _tmp17_);
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp19_ = _tmp18_;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp19_);
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp19_);
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 3245 "test-number.c"
				}
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 3249 "test-number.c"
			}
		}
	}
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 3255 "test-number.c"
}


void test_ceiling (void) {
	{
		gint ai = 0;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		ai = -100;
#line 3264 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 3271 "test-number.c"
				gint _tmp2_ = 0;
				gdouble a = 0.0;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 3289 "test-number.c"
					gint _tmp1_ = 0;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = ai;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					ai = _tmp1_ + 1;
#line 3295 "test-number.c"
				}
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = ai;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 100)) {
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 3305 "test-number.c"
				}
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = ai;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				a = _tmp3_ / 10.0;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = a;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = number_new_double (_tmp4_);
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = _tmp5_;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = number_ceiling (_tmp6_);
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = _tmp7_;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp6_);
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp8_;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = a;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = ceil (_tmp9_);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp10_;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = z;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = expected;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp13_) {
#line 3339 "test-number.c"
					gdouble _tmp14_ = 0.0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = a;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = z;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = number_to_double (_tmp15_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = expected;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = g_strdup_printf ("(%f).ceiling () -> %f, expected %f", _tmp14_, _tmp16_, _tmp17_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp19_ = _tmp18_;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp19_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp19_);
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 3366 "test-number.c"
				}
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 3370 "test-number.c"
			}
		}
	}
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 3376 "test-number.c"
}


void test_round (void) {
	{
		gint ai = 0;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		ai = -100;
#line 3385 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 3392 "test-number.c"
				gint _tmp2_ = 0;
				gdouble a = 0.0;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 3410 "test-number.c"
					gint _tmp1_ = 0;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = ai;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					ai = _tmp1_ + 1;
#line 3416 "test-number.c"
				}
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = ai;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 100)) {
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 3426 "test-number.c"
				}
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = ai;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				a = _tmp3_ / 10.0;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = a;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = number_new_double (_tmp4_);
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = _tmp5_;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = number_round (_tmp6_);
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = _tmp7_;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp6_);
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp8_;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = a;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = round (_tmp9_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp10_;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = z;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = expected;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp13_) {
#line 3460 "test-number.c"
					gdouble _tmp14_ = 0.0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = a;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = z;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = number_to_double (_tmp15_);
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = expected;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = g_strdup_printf ("(%f).round () -> %f, expected %f", _tmp14_, _tmp16_, _tmp17_);
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp19_ = _tmp18_;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp19_);
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp19_);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 3487 "test-number.c"
				}
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 3491 "test-number.c"
			}
		}
	}
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 3497 "test-number.c"
}


void test_reciprocal (void) {
	{
		gint a = 0;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 3506 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 3513 "test-number.c"
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gint _tmp9_ = 0;
				Number* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gboolean _tmp12_ = FALSE;
				gdouble _tmp19_ = 0.0;
				Number* _tmp20_ = NULL;
				Number* _tmp21_ = NULL;
				Number* _tmp22_ = NULL;
				Number* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gboolean _tmp25_ = FALSE;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 3536 "test-number.c"
					gint _tmp1_ = 0;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 3542 "test-number.c"
				}
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 3552 "test-number.c"
				}
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp3_ == 0) {
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					continue;
#line 3560 "test-number.c"
				}
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = a;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = number_new_double ((gdouble) _tmp4_);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = _tmp5_;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = number_reciprocal (_tmp6_);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = _tmp7_;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp6_);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp8_;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = a;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = 1.0 / _tmp9_;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = z;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = expected;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = double_matches (_tmp10_, _tmp11_);
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp12_) {
#line 3588 "test-number.c"
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = a;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = z;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = number_to_double (_tmp14_);
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = expected;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = g_strdup_printf ("(%f).reciprocal () -> %f, expected %f", (gdouble) _tmp13_, _tmp15_, _tmp16_);
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = _tmp17_;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp18_);
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp18_);
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 3615 "test-number.c"
				}
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp19_ = expected;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp20_ = number_new_double (_tmp19_);
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp21_ = _tmp20_;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp22_ = number_reciprocal (_tmp21_);
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp22_;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp21_);
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp23_ = z;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp24_ = a;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp25_ = double_matches (_tmp23_, (gdouble) _tmp24_);
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp25_) {
#line 3639 "test-number.c"
					gdouble _tmp26_ = 0.0;
					Number* _tmp27_ = NULL;
					gdouble _tmp28_ = 0.0;
					gint _tmp29_ = 0;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp26_ = expected;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp27_ = z;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp28_ = number_to_double (_tmp27_);
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp29_ = a;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp30_ = g_strdup_printf ("(%f).reciprocal () -> %f, expected %f", _tmp26_, _tmp28_, (gdouble) _tmp29_);
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp31_ = _tmp30_;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp31_);
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp31_);
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 3666 "test-number.c"
				}
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 3670 "test-number.c"
			}
		}
	}
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 3676 "test-number.c"
}


void test_epowy (void) {
	{
		gint ai = 0;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		ai = -100;
#line 3685 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 3692 "test-number.c"
				gint _tmp2_ = 0;
				gdouble a = 0.0;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 3710 "test-number.c"
					gint _tmp1_ = 0;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = ai;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					ai = _tmp1_ + 1;
#line 3716 "test-number.c"
				}
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = ai;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 100)) {
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 3726 "test-number.c"
				}
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = ai;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				a = _tmp3_ / 10.0;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = a;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = number_new_double (_tmp4_);
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = _tmp5_;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = number_epowy (_tmp6_);
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = _tmp7_;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp6_);
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp8_;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = a;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = exp (_tmp9_);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp10_;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = z;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = expected;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp13_) {
#line 3760 "test-number.c"
					gdouble _tmp14_ = 0.0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = a;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = z;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = number_to_double (_tmp15_);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = expected;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = g_strdup_printf ("(%f).epowy () -> %f, expected %f", _tmp14_, _tmp16_, _tmp17_);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp19_ = _tmp18_;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp19_);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp19_);
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 3787 "test-number.c"
				}
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 3791 "test-number.c"
			}
		}
	}
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 3797 "test-number.c"
}


void test_xpowy (void) {
	{
		gint a = 0;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 3806 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 3813 "test-number.c"
				gint _tmp2_ = 0;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 3817 "test-number.c"
					gint _tmp1_ = 0;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 3823 "test-number.c"
				}
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 3833 "test-number.c"
				}
				{
					gint b = 0;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = -10;
#line 3839 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 3846 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gdouble expected = 0.0;
							gint _tmp14_ = 0;
							Number* _tmp29_ = NULL;
							gdouble _tmp30_ = 0.0;
							gboolean _tmp31_ = FALSE;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 3864 "test-number.c"
								gint _tmp4_ = 0;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 3870 "test-number.c"
							}
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 3880 "test-number.c"
							}
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_xpowy (_tmp8_, _tmp11_);
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp11_);
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp13_;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = 1.0;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = a;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp14_ == 0) {
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								expected = 0.0;
#line 3912 "test-number.c"
							} else {
								gint _tmp15_ = 0;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp15_ = b;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								if (_tmp15_ < 0) {
#line 3919 "test-number.c"
									{
										gint i = 0;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
										i = 0;
#line 3924 "test-number.c"
										{
											gboolean _tmp16_ = FALSE;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
											_tmp16_ = TRUE;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
											while (TRUE) {
#line 3931 "test-number.c"
												gint _tmp18_ = 0;
												gint _tmp19_ = 0;
												gdouble _tmp20_ = 0.0;
												gint _tmp21_ = 0;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												if (!_tmp16_) {
#line 3938 "test-number.c"
													gint _tmp17_ = 0;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													_tmp17_ = i;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													i = _tmp17_ - 1;
#line 3944 "test-number.c"
												}
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												_tmp16_ = FALSE;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												_tmp18_ = i;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												_tmp19_ = b;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												if (!(_tmp18_ > _tmp19_)) {
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													break;
#line 3956 "test-number.c"
												}
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												_tmp20_ = expected;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												_tmp21_ = a;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												expected = _tmp20_ / _tmp21_;
#line 3964 "test-number.c"
											}
										}
									}
								} else {
									gint _tmp22_ = 0;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									_tmp22_ = b;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									if (_tmp22_ > 0) {
#line 3974 "test-number.c"
										{
											gint i = 0;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
											i = 0;
#line 3979 "test-number.c"
											{
												gboolean _tmp23_ = FALSE;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												_tmp23_ = TRUE;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												while (TRUE) {
#line 3986 "test-number.c"
													gint _tmp25_ = 0;
													gint _tmp26_ = 0;
													gdouble _tmp27_ = 0.0;
													gint _tmp28_ = 0;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													if (!_tmp23_) {
#line 3993 "test-number.c"
														gint _tmp24_ = 0;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
														_tmp24_ = i;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
														i = _tmp24_ + 1;
#line 3999 "test-number.c"
													}
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													_tmp23_ = FALSE;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													_tmp25_ = i;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													_tmp26_ = b;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													if (!(_tmp25_ < _tmp26_)) {
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
														break;
#line 4011 "test-number.c"
													}
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													_tmp27_ = expected;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													_tmp28_ = a;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													expected = _tmp27_ * _tmp28_;
#line 4019 "test-number.c"
												}
											}
										}
									}
								}
							}
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp29_ = z;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp30_ = expected;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp31_ = double_matches (_tmp29_, _tmp30_);
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp31_) {
#line 4034 "test-number.c"
								gint _tmp32_ = 0;
								gint _tmp33_ = 0;
								Number* _tmp34_ = NULL;
								gdouble _tmp35_ = 0.0;
								gdouble _tmp36_ = 0.0;
								gchar* _tmp37_ = NULL;
								gchar* _tmp38_ = NULL;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp32_ = a;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp33_ = b;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp34_ = z;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp35_ = number_to_double (_tmp34_);
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp36_ = expected;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp37_ = g_strdup_printf ("(%d).xpowy (%d) -> %f, expected %f", _tmp32_, _tmp33_, _tmp35_, _tmp36_);
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp38_ = _tmp37_;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp38_);
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp38_);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 4064 "test-number.c"
							}
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 4068 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 4077 "test-number.c"
}


void test_xpowy_integer (void) {
	{
		gint a = 0;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 4086 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 4093 "test-number.c"
				gint _tmp2_ = 0;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 4097 "test-number.c"
					gint _tmp1_ = 0;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 4103 "test-number.c"
				}
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 4113 "test-number.c"
				}
				{
					gint b = 0;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = -10;
#line 4119 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 4126 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							gdouble expected = 0.0;
							gint _tmp12_ = 0;
							Number* _tmp27_ = NULL;
							gdouble _tmp28_ = 0.0;
							gboolean _tmp29_ = FALSE;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 4142 "test-number.c"
								gint _tmp4_ = 0;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 4148 "test-number.c"
							}
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 4158 "test-number.c"
							}
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_xpowy_integer (_tmp8_, (gint64) _tmp9_);
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp11_;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = 1.0;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = a;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp12_ == 0) {
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								expected = 0.0;
#line 4184 "test-number.c"
							} else {
								gint _tmp13_ = 0;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp13_ = b;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								if (_tmp13_ < 0) {
#line 4191 "test-number.c"
									{
										gint i = 0;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
										i = 0;
#line 4196 "test-number.c"
										{
											gboolean _tmp14_ = FALSE;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
											_tmp14_ = TRUE;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
											while (TRUE) {
#line 4203 "test-number.c"
												gint _tmp16_ = 0;
												gint _tmp17_ = 0;
												gdouble _tmp18_ = 0.0;
												gint _tmp19_ = 0;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												if (!_tmp14_) {
#line 4210 "test-number.c"
													gint _tmp15_ = 0;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													_tmp15_ = i;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													i = _tmp15_ - 1;
#line 4216 "test-number.c"
												}
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												_tmp14_ = FALSE;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												_tmp16_ = i;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												_tmp17_ = b;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												if (!(_tmp16_ > _tmp17_)) {
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													break;
#line 4228 "test-number.c"
												}
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												_tmp18_ = expected;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												_tmp19_ = a;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												expected = _tmp18_ / _tmp19_;
#line 4236 "test-number.c"
											}
										}
									}
								} else {
									gint _tmp20_ = 0;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									_tmp20_ = b;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									if (_tmp20_ > 0) {
#line 4246 "test-number.c"
										{
											gint i = 0;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
											i = 0;
#line 4251 "test-number.c"
											{
												gboolean _tmp21_ = FALSE;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												_tmp21_ = TRUE;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
												while (TRUE) {
#line 4258 "test-number.c"
													gint _tmp23_ = 0;
													gint _tmp24_ = 0;
													gdouble _tmp25_ = 0.0;
													gint _tmp26_ = 0;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													if (!_tmp21_) {
#line 4265 "test-number.c"
														gint _tmp22_ = 0;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
														_tmp22_ = i;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
														i = _tmp22_ + 1;
#line 4271 "test-number.c"
													}
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													_tmp21_ = FALSE;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													_tmp23_ = i;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													_tmp24_ = b;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													if (!(_tmp23_ < _tmp24_)) {
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
														break;
#line 4283 "test-number.c"
													}
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													_tmp25_ = expected;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													_tmp26_ = a;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
													expected = _tmp25_ * _tmp26_;
#line 4291 "test-number.c"
												}
											}
										}
									}
								}
							}
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp27_ = z;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp28_ = expected;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp29_ = double_matches (_tmp27_, _tmp28_);
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp29_) {
#line 4306 "test-number.c"
								gint _tmp30_ = 0;
								gint _tmp31_ = 0;
								Number* _tmp32_ = NULL;
								gdouble _tmp33_ = 0.0;
								gdouble _tmp34_ = 0.0;
								gchar* _tmp35_ = NULL;
								gchar* _tmp36_ = NULL;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp30_ = a;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp31_ = b;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp32_ = z;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp33_ = number_to_double (_tmp32_);
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp34_ = expected;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp35_ = g_strdup_printf ("(%d).xpowy_integer (%d) -> %f, expected %f", _tmp30_, _tmp31_, _tmp33_, _tmp34_);
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp36_ = _tmp35_;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp36_);
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp36_);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 4336 "test-number.c"
							}
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 4340 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 4349 "test-number.c"
}


void test_root3 (void) {
	{
		gint a = 0;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 4358 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 4365 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gdouble expected = 0.0;
				gint _tmp8_ = 0;
				gdouble _tmp9_ = 0.0;
				Number* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gboolean _tmp12_ = FALSE;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 4381 "test-number.c"
					gint _tmp1_ = 0;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 4387 "test-number.c"
				}
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 4397 "test-number.c"
				}
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_double ((gdouble) _tmp3_);
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = _tmp4_;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = number_root (_tmp5_, (gint64) 3);
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = _tmp6_;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp5_);
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp7_;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = a;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = cbrt ((gdouble) _tmp8_);
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp9_;
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = z;
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = expected;
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = double_matches (_tmp10_, _tmp11_);
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp12_) {
#line 4427 "test-number.c"
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = a;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = z;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = number_to_double (_tmp14_);
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = expected;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = g_strdup_printf ("(%f).root (3) -> %f, expected %f", (gdouble) _tmp13_, _tmp15_, _tmp16_);
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = _tmp17_;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp18_);
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp18_);
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 4454 "test-number.c"
				}
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 4458 "test-number.c"
			}
		}
	}
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 4464 "test-number.c"
}


void test_sqrt (void) {
	{
		gint a = 0;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = 0;
#line 4473 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 4480 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gdouble expected = 0.0;
				gint _tmp8_ = 0;
				gdouble _tmp9_ = 0.0;
				Number* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gboolean _tmp12_ = FALSE;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 4496 "test-number.c"
					gint _tmp1_ = 0;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 4502 "test-number.c"
				}
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 4512 "test-number.c"
				}
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_double ((gdouble) _tmp3_);
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = _tmp4_;
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = number_sqrt (_tmp5_);
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = _tmp6_;
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp5_);
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp7_;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = a;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = sqrt ((gdouble) _tmp8_);
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp9_;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = z;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = expected;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = double_matches (_tmp10_, _tmp11_);
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp12_) {
#line 4542 "test-number.c"
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = a;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = z;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = number_to_double (_tmp14_);
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = expected;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = g_strdup_printf ("(%f).sqrt () -> %f, expected %f", (gdouble) _tmp13_, _tmp15_, _tmp16_);
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = _tmp17_;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp18_);
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp18_);
#line 567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 4569 "test-number.c"
				}
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 4573 "test-number.c"
			}
		}
	}
#line 571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 4579 "test-number.c"
}


void test_ln (void) {
	{
		gint a = 0;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = 1;
#line 4588 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 4595 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gdouble expected = 0.0;
				gint _tmp8_ = 0;
				gdouble _tmp9_ = 0.0;
				Number* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gboolean _tmp12_ = FALSE;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 4611 "test-number.c"
					gint _tmp1_ = 0;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 4617 "test-number.c"
				}
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 4627 "test-number.c"
				}
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_double ((gdouble) _tmp3_);
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = _tmp4_;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = number_ln (_tmp5_);
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = _tmp6_;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp5_);
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp7_;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = a;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = log ((gdouble) _tmp8_);
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp9_;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = z;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = expected;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = double_matches (_tmp10_, _tmp11_);
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp12_) {
#line 4657 "test-number.c"
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = a;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = z;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = number_to_double (_tmp14_);
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = expected;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = g_strdup_printf ("(%f).ln () -> %f, expected %f", (gdouble) _tmp13_, _tmp15_, _tmp16_);
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = _tmp17_;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp18_);
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp18_);
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 4684 "test-number.c"
				}
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 4688 "test-number.c"
			}
		}
	}
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 4694 "test-number.c"
}


void test_logarithm2 (void) {
	{
		gint a = 0;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = 1;
#line 4703 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 4710 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gdouble expected = 0.0;
				gint _tmp8_ = 0;
				gdouble _tmp9_ = 0.0;
				Number* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gboolean _tmp12_ = FALSE;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 4726 "test-number.c"
					gint _tmp1_ = 0;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 4732 "test-number.c"
				}
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 4742 "test-number.c"
				}
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_double ((gdouble) _tmp3_);
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = _tmp4_;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = number_logarithm (_tmp5_, (gint64) 2);
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = _tmp6_;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp5_);
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp7_;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = a;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = log2 ((gdouble) _tmp8_);
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp9_;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = z;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = expected;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = double_matches (_tmp10_, _tmp11_);
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp12_) {
#line 4772 "test-number.c"
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = a;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = z;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = number_to_double (_tmp14_);
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = expected;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = g_strdup_printf ("(%f).logarithm (2) -> %f, expected %f", (gdouble) _tmp13_, _tmp15_, _tmp16_);
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = _tmp17_;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp18_);
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp18_);
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 4799 "test-number.c"
				}
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 4803 "test-number.c"
			}
		}
	}
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 4809 "test-number.c"
}


void test_logarithm10 (void) {
	{
		gint a = 0;
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = 1;
#line 4818 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 4825 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gdouble expected = 0.0;
				gint _tmp8_ = 0;
				gdouble _tmp9_ = 0.0;
				Number* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gboolean _tmp12_ = FALSE;
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 4841 "test-number.c"
					gint _tmp1_ = 0;
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 4847 "test-number.c"
				}
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 4857 "test-number.c"
				}
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_double ((gdouble) _tmp3_);
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = _tmp4_;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = number_logarithm (_tmp5_, (gint64) 10);
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = _tmp6_;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp5_);
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp7_;
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = a;
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = log10 ((gdouble) _tmp8_);
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp9_;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = z;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = expected;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = double_matches (_tmp10_, _tmp11_);
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp12_) {
#line 4887 "test-number.c"
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = a;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = z;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = number_to_double (_tmp14_);
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = expected;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = g_strdup_printf ("(%f).logarithm (10) -> %f, expected %f", (gdouble) _tmp13_, _tmp15_, _tmp16_);
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = _tmp17_;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp18_);
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp18_);
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 4914 "test-number.c"
				}
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 4918 "test-number.c"
			}
		}
	}
#line 619 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 4924 "test-number.c"
}


void test_is_zero (void) {
	{
		gint a = 0;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 4933 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 4940 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gboolean expected = FALSE;
				gint _tmp5_ = 0;
				Number* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 4952 "test-number.c"
					gint _tmp1_ = 0;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 4958 "test-number.c"
				}
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 4968 "test-number.c"
				}
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp4_;
#line 627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = a;
#line 627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp5_ == 0;
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = z;
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = number_is_zero (_tmp6_);
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = expected;
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp7_ != _tmp8_) {
#line 4988 "test-number.c"
					const gchar* _tmp9_ = NULL;
					Number* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					const gchar* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					gint _tmp14_ = 0;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp10_ = z;
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp11_ = number_is_zero (_tmp10_);
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					if (_tmp11_) {
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp9_ = "true";
#line 5005 "test-number.c"
					} else {
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp9_ = "false";
#line 5009 "test-number.c"
					}
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = expected;
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					if (_tmp13_) {
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp12_ = "true";
#line 5017 "test-number.c"
					} else {
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp12_ = "false";
#line 5021 "test-number.c"
					}
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = a;
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = g_strdup_printf ("(%d).is_zero () -> %s, expected %s", _tmp14_, _tmp9_, _tmp12_);
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = _tmp15_;
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp16_);
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp16_);
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 5037 "test-number.c"
				}
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 5041 "test-number.c"
			}
		}
	}
#line 635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 5047 "test-number.c"
}


void test_is_negative (void) {
	{
		gint a = 0;
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 5056 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 5063 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gboolean expected = FALSE;
				gint _tmp5_ = 0;
				Number* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 5075 "test-number.c"
					gint _tmp1_ = 0;
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 5081 "test-number.c"
				}
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 5091 "test-number.c"
				}
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp4_;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = a;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp5_ < 0;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = z;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = number_is_negative (_tmp6_);
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = expected;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp7_ != _tmp8_) {
#line 5111 "test-number.c"
					const gchar* _tmp9_ = NULL;
					Number* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					const gchar* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					gint _tmp14_ = 0;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp10_ = z;
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp11_ = number_is_negative (_tmp10_);
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					if (_tmp11_) {
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp9_ = "true";
#line 5128 "test-number.c"
					} else {
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp9_ = "false";
#line 5132 "test-number.c"
					}
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = expected;
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					if (_tmp13_) {
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp12_ = "true";
#line 5140 "test-number.c"
					} else {
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp12_ = "false";
#line 5144 "test-number.c"
					}
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = a;
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = g_strdup_printf ("(%d).is_negative () -> %s, expected %s", _tmp14_, _tmp9_, _tmp12_);
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = _tmp15_;
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp16_);
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp16_);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 5160 "test-number.c"
				}
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 5164 "test-number.c"
			}
		}
	}
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 5170 "test-number.c"
}


void test_is_integer (void) {
	{
		gint a = 0;
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 5179 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 5186 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gboolean expected = FALSE;
				Number* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 5197 "test-number.c"
					gint _tmp1_ = 0;
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 5203 "test-number.c"
				}
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 5213 "test-number.c"
				}
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp4_;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = TRUE;
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = z;
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = number_is_integer (_tmp5_);
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = expected;
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp6_ != _tmp7_) {
#line 5231 "test-number.c"
					const gchar* _tmp8_ = NULL;
					Number* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					const gchar* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					gint _tmp13_ = 0;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp9_ = z;
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp10_ = number_is_integer (_tmp9_);
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					if (_tmp10_) {
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp8_ = "true";
#line 5248 "test-number.c"
					} else {
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp8_ = "false";
#line 5252 "test-number.c"
					}
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp12_ = expected;
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					if (_tmp12_) {
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp11_ = "true";
#line 5260 "test-number.c"
					} else {
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp11_ = "false";
#line 5264 "test-number.c"
					}
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = a;
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = g_strdup_printf ("(%d).is_integer () -> %s, expected %s", _tmp13_, _tmp8_, _tmp11_);
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = _tmp14_;
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp15_);
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp15_);
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 5280 "test-number.c"
				}
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 5284 "test-number.c"
			}
		}
	}
#line 667 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 5290 "test-number.c"
}


void test_is_positive_integer (void) {
	{
		gint a = 0;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 5299 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 5306 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gboolean expected = FALSE;
				gint _tmp5_ = 0;
				Number* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 5318 "test-number.c"
					gint _tmp1_ = 0;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 5324 "test-number.c"
				}
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 5334 "test-number.c"
				}
#line 674 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 674 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
#line 674 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp4_;
#line 675 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = a;
#line 675 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp5_ >= 0;
#line 676 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = z;
#line 676 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = number_is_positive_integer (_tmp6_);
#line 676 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = expected;
#line 676 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp7_ != _tmp8_) {
#line 5354 "test-number.c"
					const gchar* _tmp9_ = NULL;
					Number* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					const gchar* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					gint _tmp14_ = 0;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp10_ = z;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp11_ = number_is_positive_integer (_tmp10_);
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					if (_tmp11_) {
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp9_ = "true";
#line 5371 "test-number.c"
					} else {
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp9_ = "false";
#line 5375 "test-number.c"
					}
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = expected;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					if (_tmp13_) {
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp12_ = "true";
#line 5383 "test-number.c"
					} else {
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp12_ = "false";
#line 5387 "test-number.c"
					}
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = a;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = g_strdup_printf ("(%d).is_positive_integer () -> %s, expected %s", _tmp14_, _tmp9_, _tmp12_);
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = _tmp15_;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp16_);
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp16_);
#line 679 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 679 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 5403 "test-number.c"
				}
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 5407 "test-number.c"
			}
		}
	}
#line 683 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 5413 "test-number.c"
}


void test_is_natural (void) {
	{
		gint a = 0;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 5422 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 5429 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gboolean expected = FALSE;
				gint _tmp5_ = 0;
				Number* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 5441 "test-number.c"
					gint _tmp1_ = 0;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 5447 "test-number.c"
				}
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 5457 "test-number.c"
				}
#line 690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
#line 690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp4_;
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = a;
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp5_ > 0;
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = z;
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = number_is_natural (_tmp6_);
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = expected;
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp7_ != _tmp8_) {
#line 5477 "test-number.c"
					const gchar* _tmp9_ = NULL;
					Number* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					const gchar* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					gint _tmp14_ = 0;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp10_ = z;
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp11_ = number_is_natural (_tmp10_);
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					if (_tmp11_) {
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp9_ = "true";
#line 5494 "test-number.c"
					} else {
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp9_ = "false";
#line 5498 "test-number.c"
					}
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = expected;
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					if (_tmp13_) {
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp12_ = "true";
#line 5506 "test-number.c"
					} else {
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp12_ = "false";
#line 5510 "test-number.c"
					}
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = a;
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = g_strdup_printf ("(%d).is_natural () -> %s, expected %s", _tmp14_, _tmp9_, _tmp12_);
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = _tmp15_;
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp16_);
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp16_);
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 5526 "test-number.c"
				}
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 5530 "test-number.c"
			}
		}
	}
#line 699 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 5536 "test-number.c"
}


void test_is_complex (void) {
	{
		gint a = 0;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 5545 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 5552 "test-number.c"
				gint _tmp2_ = 0;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 5556 "test-number.c"
					gint _tmp1_ = 0;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 5562 "test-number.c"
				}
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 5572 "test-number.c"
				}
				{
					gint b = 0;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = -10;
#line 5578 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 5585 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gboolean expected = FALSE;
							gint _tmp14_ = 0;
							Number* _tmp15_ = NULL;
							gboolean _tmp16_ = FALSE;
							gboolean _tmp17_ = FALSE;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 5603 "test-number.c"
								gint _tmp4_ = 0;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 5609 "test-number.c"
							}
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 5619 "test-number.c"
							}
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp11_);
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp13_;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = b;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = _tmp14_ != 0;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = z;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp16_ = number_is_complex (_tmp15_);
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = expected;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp16_ != _tmp17_) {
#line 5655 "test-number.c"
								const gchar* _tmp18_ = NULL;
								Number* _tmp19_ = NULL;
								gboolean _tmp20_ = FALSE;
								const gchar* _tmp21_ = NULL;
								gboolean _tmp22_ = FALSE;
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								gchar* _tmp25_ = NULL;
								gchar* _tmp26_ = NULL;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp19_ = z;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp20_ = number_is_complex (_tmp19_);
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								if (_tmp20_) {
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									_tmp18_ = "true";
#line 5673 "test-number.c"
								} else {
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									_tmp18_ = "false";
#line 5677 "test-number.c"
								}
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = expected;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								if (_tmp22_) {
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									_tmp21_ = "true";
#line 5685 "test-number.c"
								} else {
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									_tmp21_ = "false";
#line 5689 "test-number.c"
								}
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp23_ = a;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp24_ = b;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp25_ = g_strdup_printf ("(%d+%di).is_complex () -> %s, expected %s", _tmp23_, _tmp24_, _tmp18_, _tmp21_);
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp26_ = _tmp25_;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp26_);
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp26_);
#line 713 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 713 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 5707 "test-number.c"
							}
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 5711 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 718 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 5720 "test-number.c"
}


void test_factorial (void) {
	{
		gint a = 0;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = 0;
#line 5729 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 5736 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gint expected = 0;
				Number* _tmp11_ = NULL;
				Number* _tmp12_ = NULL;
				Number* _tmp13_ = NULL;
				gint64 _tmp14_ = 0LL;
				gint _tmp15_ = 0;
				gboolean _tmp16_ = FALSE;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 5750 "test-number.c"
					gint _tmp1_ = 0;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 5756 "test-number.c"
				}
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 5766 "test-number.c"
				}
#line 725 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 725 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
#line 725 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp4_;
#line 726 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = 1;
#line 5776 "test-number.c"
				{
					gint i = 0;
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					i = 2;
#line 5781 "test-number.c"
					{
						gboolean _tmp5_ = FALSE;
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp5_ = TRUE;
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 5788 "test-number.c"
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp5_) {
#line 5795 "test-number.c"
								gint _tmp6_ = 0;
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp6_ = i;
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								i = _tmp6_ + 1;
#line 5801 "test-number.c"
							}
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = FALSE;
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = i;
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = a;
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp7_ <= _tmp8_)) {
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 5813 "test-number.c"
							}
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = expected;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = i;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = _tmp9_ * _tmp10_;
#line 5821 "test-number.c"
						}
					}
				}
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = z;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = number_factorial (_tmp11_);
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp13_ = _tmp12_;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp14_ = number_to_integer (_tmp13_);
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp15_ = expected;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp16_ = _tmp14_ != ((gint64) _tmp15_);
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp13_);
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp16_) {
#line 5841 "test-number.c"
					gint _tmp17_ = 0;
					Number* _tmp18_ = NULL;
					Number* _tmp19_ = NULL;
					Number* _tmp20_ = NULL;
					gint64 _tmp21_ = 0LL;
					gint _tmp22_ = 0;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = a;
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = z;
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp19_ = number_factorial (_tmp18_);
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp20_ = _tmp19_;
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp21_ = number_to_integer (_tmp20_);
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp22_ = expected;
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp23_ = g_strdup_printf ("(%d).factorial () -> %lli, expected %lli", _tmp17_, _tmp21_, _tmp22_);
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp24_ = _tmp23_;
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp24_);
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp24_);
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (_tmp20_);
#line 732 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 732 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 5876 "test-number.c"
				}
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 5880 "test-number.c"
			}
		}
	}
#line 736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 5886 "test-number.c"
}


void test_add (void) {
	{
		gint a = 0;
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 5895 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 5902 "test-number.c"
				gint _tmp2_ = 0;
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 5906 "test-number.c"
					gint _tmp1_ = 0;
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 5912 "test-number.c"
				}
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 5922 "test-number.c"
				}
				{
					gint b = 0;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = -10;
#line 5928 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 5935 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Number* _tmp16_ = NULL;
							gint64 _tmp17_ = 0LL;
							gint _tmp18_ = 0;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 5954 "test-number.c"
								gint _tmp4_ = 0;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 5960 "test-number.c"
							}
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 5970 "test-number.c"
							}
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_add (_tmp8_, _tmp11_);
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp11_);
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp13_;
#line 746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = a;
#line 746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = b;
#line 746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = _tmp14_ + _tmp15_;
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp16_ = z;
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = number_to_integer (_tmp16_);
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp18_ = expected;
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp17_ != ((gint64) _tmp18_)) {
#line 6008 "test-number.c"
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp19_ = a;
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp20_ = b;
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp21_ = z;
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = number_to_integer (_tmp21_);
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp23_ = expected;
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp24_ = g_strdup_printf ("(%d).add (%d) -> %lli, expected %d", _tmp19_, _tmp20_, _tmp22_, _tmp23_);
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp25_ = _tmp24_;
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp25_);
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp25_);
#line 750 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 750 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 6038 "test-number.c"
							}
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 6042 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 755 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 6051 "test-number.c"
}


void test_subtract (void) {
	{
		gint a = 0;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 6060 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 6067 "test-number.c"
				gint _tmp2_ = 0;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 6071 "test-number.c"
					gint _tmp1_ = 0;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 6077 "test-number.c"
				}
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 6087 "test-number.c"
				}
				{
					gint b = 0;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = -10;
#line 6093 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 6100 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Number* _tmp16_ = NULL;
							gint64 _tmp17_ = 0LL;
							gint _tmp18_ = 0;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 6119 "test-number.c"
								gint _tmp4_ = 0;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 6125 "test-number.c"
							}
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 6135 "test-number.c"
							}
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_subtract (_tmp8_, _tmp11_);
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp11_);
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp13_;
#line 765 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = a;
#line 765 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = b;
#line 765 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = _tmp14_ - _tmp15_;
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp16_ = z;
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = number_to_integer (_tmp16_);
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp18_ = expected;
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp17_ != ((gint64) _tmp18_)) {
#line 6173 "test-number.c"
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
#line 768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp19_ = a;
#line 768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp20_ = b;
#line 768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp21_ = z;
#line 768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = number_to_integer (_tmp21_);
#line 768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp23_ = expected;
#line 768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp24_ = g_strdup_printf ("(%d).subtract (%d) -> %lli, expected %d", _tmp19_, _tmp20_, _tmp22_, _tmp23_);
#line 768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp25_ = _tmp24_;
#line 768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp25_);
#line 768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp25_);
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 6203 "test-number.c"
							}
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 6207 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 6216 "test-number.c"
}


void test_multiply (void) {
	{
		gint a = 0;
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 6225 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 6232 "test-number.c"
				gint _tmp2_ = 0;
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 6236 "test-number.c"
					gint _tmp1_ = 0;
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 6242 "test-number.c"
				}
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 6252 "test-number.c"
				}
				{
					gint b = 0;
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = -10;
#line 6258 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 6265 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Number* _tmp16_ = NULL;
							gint64 _tmp17_ = 0LL;
							gint _tmp18_ = 0;
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 6284 "test-number.c"
								gint _tmp4_ = 0;
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 6290 "test-number.c"
							}
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 6300 "test-number.c"
							}
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_multiply (_tmp8_, _tmp11_);
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp11_);
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp13_;
#line 784 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = a;
#line 784 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = b;
#line 784 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = _tmp14_ * _tmp15_;
#line 785 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp16_ = z;
#line 785 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = number_to_integer (_tmp16_);
#line 785 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp18_ = expected;
#line 785 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp17_ != ((gint64) _tmp18_)) {
#line 6338 "test-number.c"
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp19_ = a;
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp20_ = b;
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp21_ = z;
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = number_to_integer (_tmp21_);
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp23_ = expected;
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp24_ = g_strdup_printf ("(%d).multiply (%d) -> %lli, expected %d", _tmp19_, _tmp20_, _tmp22_, _tmp23_);
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp25_ = _tmp24_;
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp25_);
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp25_);
#line 788 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 788 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 6368 "test-number.c"
							}
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 6372 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 793 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 6381 "test-number.c"
}


void test_multiply_integer (void) {
	{
		gint a = 0;
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 6390 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 6397 "test-number.c"
				gint _tmp2_ = 0;
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 6401 "test-number.c"
					gint _tmp1_ = 0;
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 6407 "test-number.c"
				}
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 6417 "test-number.c"
				}
				{
					gint b = 0;
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = -10;
#line 6423 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 6430 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							gint expected = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							Number* _tmp14_ = NULL;
							gint64 _tmp15_ = 0LL;
							gint _tmp16_ = 0;
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 6447 "test-number.c"
								gint _tmp4_ = 0;
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 6453 "test-number.c"
							}
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 6463 "test-number.c"
							}
#line 802 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 802 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 802 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 802 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 802 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_multiply_integer (_tmp8_, (gint64) _tmp9_);
#line 802 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 802 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 802 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp11_;
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = a;
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = b;
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = _tmp12_ * _tmp13_;
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = z;
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = number_to_integer (_tmp14_);
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp16_ = expected;
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp15_ != ((gint64) _tmp16_)) {
#line 6495 "test-number.c"
								gint _tmp17_ = 0;
								gint _tmp18_ = 0;
								Number* _tmp19_ = NULL;
								gint64 _tmp20_ = 0LL;
								gint _tmp21_ = 0;
								gchar* _tmp22_ = NULL;
								gchar* _tmp23_ = NULL;
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp17_ = a;
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp18_ = b;
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp19_ = z;
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp20_ = number_to_integer (_tmp19_);
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp21_ = expected;
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = g_strdup_printf ("(%d).multiply_integer (%d) -> %lli, expected %d", _tmp17_, _tmp18_, _tmp20_, _tmp21_);
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp23_ = _tmp22_;
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp23_);
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp23_);
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 6525 "test-number.c"
							}
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 6529 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 812 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 6538 "test-number.c"
}


void test_divide (void) {
	{
		gint a = 0;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 6547 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 6554 "test-number.c"
				gint _tmp2_ = 0;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 6558 "test-number.c"
					gint _tmp1_ = 0;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 6564 "test-number.c"
				}
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 6574 "test-number.c"
				}
				{
					gint b = 0;
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = -10;
#line 6580 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 6587 "test-number.c"
							gint _tmp5_ = 0;
							gint _tmp6_ = 0;
							Number* z = NULL;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gint expected = 0;
							gint _tmp16_ = 0;
							Number* _tmp17_ = NULL;
							gint64 _tmp18_ = 0LL;
							gint _tmp19_ = 0;
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 6607 "test-number.c"
								gint _tmp4_ = 0;
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 6613 "test-number.c"
							}
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 6623 "test-number.c"
							}
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = b;
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp6_ == 0) {
#line 822 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								continue;
#line 6631 "test-number.c"
							}
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = a;
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = b;
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = number_new_integer ((gint64) (_tmp7_ * _tmp8_));
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = _tmp9_;
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = b;
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_new_integer ((gint64) _tmp11_);
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = number_divide (_tmp10_, _tmp13_);
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = _tmp14_;
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp13_);
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp10_);
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp15_;
#line 825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp16_ = a;
#line 825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = _tmp16_;
#line 826 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = z;
#line 826 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp18_ = number_to_integer (_tmp17_);
#line 826 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp19_ = expected;
#line 826 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp18_ != ((gint64) _tmp19_)) {
#line 6669 "test-number.c"
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								Number* _tmp23_ = NULL;
								gint64 _tmp24_ = 0LL;
								gint _tmp25_ = 0;
								gchar* _tmp26_ = NULL;
								gchar* _tmp27_ = NULL;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp20_ = a;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp21_ = b;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = b;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp23_ = z;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp24_ = number_to_integer (_tmp23_);
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp25_ = expected;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp26_ = g_strdup_printf ("(%d).divide (%d) -> %lli, expected %d", _tmp20_ * _tmp21_, _tmp22_, _tmp24_, _tmp25_);
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp27_ = _tmp26_;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp27_);
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp27_);
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 6702 "test-number.c"
							}
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 6706 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 834 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 6715 "test-number.c"
}


void test_divide_integer (void) {
	{
		gint a = 0;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -10;
#line 6724 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 6731 "test-number.c"
				gint _tmp2_ = 0;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 6735 "test-number.c"
					gint _tmp1_ = 0;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 6741 "test-number.c"
				}
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 6751 "test-number.c"
				}
				{
					gint b = 0;
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = -10;
#line 6757 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 6764 "test-number.c"
							gint _tmp5_ = 0;
							gint _tmp6_ = 0;
							Number* z = NULL;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							Number* _tmp15_ = NULL;
							gint64 _tmp16_ = 0LL;
							gint _tmp17_ = 0;
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 6782 "test-number.c"
								gint _tmp4_ = 0;
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 6788 "test-number.c"
							}
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 6798 "test-number.c"
							}
#line 843 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = b;
#line 843 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp6_ == 0) {
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								continue;
#line 6806 "test-number.c"
							}
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = a;
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = b;
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = number_new_integer ((gint64) (_tmp7_ * _tmp8_));
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = _tmp9_;
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = b;
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_divide_integer (_tmp10_, (gint64) _tmp11_);
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp10_);
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp13_;
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = a;
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = _tmp14_;
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = z;
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp16_ = number_to_integer (_tmp15_);
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = expected;
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp16_ != ((gint64) _tmp17_)) {
#line 6838 "test-number.c"
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp18_ = a;
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp19_ = b;
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp20_ = b;
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp21_ = z;
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = number_to_integer (_tmp21_);
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp23_ = expected;
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp24_ = g_strdup_printf ("(%d).divide_integer (%d) -> %lli, expected %d", _tmp18_ * _tmp19_, _tmp20_, _tmp22_, _tmp23_);
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp25_ = _tmp24_;
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp25_);
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp25_);
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 6871 "test-number.c"
							}
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 6875 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 6884 "test-number.c"
}


void test_modulus_divide (void) {
	{
		gint a = 0;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = 0;
#line 6893 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 6900 "test-number.c"
				gint _tmp2_ = 0;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 6904 "test-number.c"
					gint _tmp1_ = 0;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 6910 "test-number.c"
				}
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= 10)) {
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 6920 "test-number.c"
				}
				{
					gint b = 0;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = 1;
#line 6926 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 6933 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Number* _tmp16_ = NULL;
							gint64 _tmp17_ = 0LL;
							gint _tmp18_ = 0;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 6952 "test-number.c"
								gint _tmp4_ = 0;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 6958 "test-number.c"
							}
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ <= 10)) {
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 6968 "test-number.c"
							}
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_modulus_divide (_tmp8_, _tmp11_);
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp11_);
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp13_;
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = a;
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = b;
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = _tmp14_ % _tmp15_;
#line 867 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp16_ = z;
#line 867 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = number_to_integer (_tmp16_);
#line 867 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp18_ = expected;
#line 867 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp17_ != ((gint64) _tmp18_)) {
#line 7006 "test-number.c"
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp19_ = a;
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp20_ = b;
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp21_ = z;
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = number_to_integer (_tmp21_);
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp23_ = expected;
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp24_ = g_strdup_printf ("(%d).modulus_divide (%d) -> %lli, expected %d", _tmp19_, _tmp20_, _tmp22_, _tmp23_);
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp25_ = _tmp24_;
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp25_);
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp25_);
#line 870 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 870 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 7036 "test-number.c"
							}
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 7040 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 875 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 7049 "test-number.c"
}


void test_sin (void) {
	{
		gdouble a = 0.0;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -G_PI;
#line 7058 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 7065 "test-number.c"
				gdouble _tmp2_ = 0.0;
				Number* z = NULL;
				gdouble _tmp3_ = 0.0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp8_ = 0.0;
				gdouble _tmp9_ = 0.0;
				Number* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gboolean _tmp12_ = FALSE;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 7081 "test-number.c"
					gdouble _tmp1_ = 0.0;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + (G_PI / 16);
#line 7087 "test-number.c"
				}
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= G_PI)) {
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 7097 "test-number.c"
				}
#line 882 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 882 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_double (_tmp3_);
#line 882 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = _tmp4_;
#line 882 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = number_sin (_tmp5_, ANGLE_UNIT_RADIANS);
#line 882 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = _tmp6_;
#line 882 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp5_);
#line 882 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp7_;
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = a;
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = sin (_tmp8_);
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp9_;
#line 884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = z;
#line 884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = expected;
#line 884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = double_matches (_tmp10_, _tmp11_);
#line 884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp12_) {
#line 7127 "test-number.c"
					gdouble _tmp13_ = 0.0;
					Number* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = a;
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = z;
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = number_to_double (_tmp14_);
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = expected;
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = g_strdup_printf ("(%f).sin () -> %f, expected %f", _tmp13_, _tmp15_, _tmp16_);
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = _tmp17_;
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp18_);
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp18_);
#line 887 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 887 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 7154 "test-number.c"
				}
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 7158 "test-number.c"
			}
		}
	}
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 7164 "test-number.c"
}


void test_cos (void) {
	{
		gdouble a = 0.0;
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = -G_PI;
#line 7173 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 7180 "test-number.c"
				gdouble _tmp2_ = 0.0;
				Number* z = NULL;
				gdouble _tmp3_ = 0.0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp8_ = 0.0;
				gdouble _tmp9_ = 0.0;
				Number* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gboolean _tmp12_ = FALSE;
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 7196 "test-number.c"
					gdouble _tmp1_ = 0.0;
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + (G_PI / 16);
#line 7202 "test-number.c"
				}
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ <= G_PI)) {
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 7212 "test-number.c"
				}
#line 898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_double (_tmp3_);
#line 898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = _tmp4_;
#line 898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = number_cos (_tmp5_, ANGLE_UNIT_RADIANS);
#line 898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = _tmp6_;
#line 898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp5_);
#line 898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp7_;
#line 899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = a;
#line 899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = cos (_tmp8_);
#line 899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp9_;
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = z;
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = expected;
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = double_matches (_tmp10_, _tmp11_);
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp12_) {
#line 7242 "test-number.c"
					gdouble _tmp13_ = 0.0;
					Number* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
#line 902 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = a;
#line 902 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = z;
#line 902 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = number_to_double (_tmp14_);
#line 902 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = expected;
#line 902 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = g_strdup_printf ("(%f).cos () -> %f, expected %f", _tmp13_, _tmp15_, _tmp16_);
#line 902 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp18_ = _tmp17_;
#line 902 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp18_);
#line 902 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp18_);
#line 903 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 903 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 7269 "test-number.c"
				}
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 7273 "test-number.c"
			}
		}
	}
#line 907 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 7279 "test-number.c"
}


void test_and (void) {
	{
		gint a = 0;
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = 0;
#line 7288 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 7295 "test-number.c"
				gint _tmp2_ = 0;
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 7299 "test-number.c"
					gint _tmp1_ = 0;
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 7305 "test-number.c"
				}
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ < 10)) {
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 7315 "test-number.c"
				}
				{
					gint b = 0;
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = 0;
#line 7321 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 7328 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Number* _tmp16_ = NULL;
							gint64 _tmp17_ = 0LL;
							gint _tmp18_ = 0;
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 7347 "test-number.c"
								gint _tmp4_ = 0;
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 7353 "test-number.c"
							}
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ < 10)) {
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 7363 "test-number.c"
							}
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_and (_tmp8_, _tmp11_);
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp11_);
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp13_;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = a;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = b;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = _tmp14_ & _tmp15_;
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp16_ = z;
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = number_to_integer (_tmp16_);
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp18_ = expected;
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp17_ != ((gint64) _tmp18_)) {
#line 7401 "test-number.c"
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp19_ = a;
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp20_ = b;
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp21_ = z;
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = number_to_integer (_tmp21_);
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp23_ = expected;
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp24_ = g_strdup_printf ("(%d).and (%d) -> %lli, expected %d", _tmp19_, _tmp20_, _tmp22_, _tmp23_);
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp25_ = _tmp24_;
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp25_);
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp25_);
#line 921 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 921 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 7431 "test-number.c"
							}
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 7435 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 7444 "test-number.c"
}


void test_or (void) {
	{
		gint a = 0;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = 0;
#line 7453 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 7460 "test-number.c"
				gint _tmp2_ = 0;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 7464 "test-number.c"
					gint _tmp1_ = 0;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 7470 "test-number.c"
				}
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ < 10)) {
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 7480 "test-number.c"
				}
				{
					gint b = 0;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = 0;
#line 7486 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 7493 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Number* _tmp16_ = NULL;
							gint64 _tmp17_ = 0LL;
							gint _tmp18_ = 0;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 7512 "test-number.c"
								gint _tmp4_ = 0;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 7518 "test-number.c"
							}
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ < 10)) {
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 7528 "test-number.c"
							}
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_or (_tmp8_, _tmp11_);
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp11_);
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp13_;
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = a;
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = b;
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = _tmp14_ | _tmp15_;
#line 937 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp16_ = z;
#line 937 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = number_to_integer (_tmp16_);
#line 937 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp18_ = expected;
#line 937 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp17_ != ((gint64) _tmp18_)) {
#line 7566 "test-number.c"
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp19_ = a;
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp20_ = b;
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp21_ = z;
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = number_to_integer (_tmp21_);
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp23_ = expected;
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp24_ = g_strdup_printf ("(%d).or (%d) -> %lli, expected %d", _tmp19_, _tmp20_, _tmp22_, _tmp23_);
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp25_ = _tmp24_;
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp25_);
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp25_);
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 7596 "test-number.c"
							}
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 7600 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 7609 "test-number.c"
}


void test_xor (void) {
	{
		gint a = 0;
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = 0;
#line 7618 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 7625 "test-number.c"
				gint _tmp2_ = 0;
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 7629 "test-number.c"
					gint _tmp1_ = 0;
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 7635 "test-number.c"
				}
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ < 10)) {
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 7645 "test-number.c"
				}
				{
					gint b = 0;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = 0;
#line 7651 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 7658 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Number* _tmp16_ = NULL;
							gint64 _tmp17_ = 0LL;
							gint _tmp18_ = 0;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 7677 "test-number.c"
								gint _tmp4_ = 0;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 7683 "test-number.c"
							}
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ < 10)) {
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 7693 "test-number.c"
							}
#line 954 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 954 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 954 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 954 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 954 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
#line 954 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 954 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = number_xor (_tmp8_, _tmp11_);
#line 954 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = _tmp12_;
#line 954 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp11_);
#line 954 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 954 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp13_;
#line 955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = a;
#line 955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp15_ = b;
#line 955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = _tmp14_ ^ _tmp15_;
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp16_ = z;
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = number_to_integer (_tmp16_);
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp18_ = expected;
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp17_ != ((gint64) _tmp18_)) {
#line 7731 "test-number.c"
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp19_ = a;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp20_ = b;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp21_ = z;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = number_to_integer (_tmp21_);
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp23_ = expected;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp24_ = g_strdup_printf ("(%d).xor (%d) -> %lli, expected %d", _tmp19_, _tmp20_, _tmp22_, _tmp23_);
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp25_ = _tmp24_;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp25_);
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp25_);
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 7761 "test-number.c"
							}
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 7765 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 964 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 7774 "test-number.c"
}


void test_not (void) {
	{
		gint a = 0;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = 0;
#line 7783 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 7790 "test-number.c"
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gint expected = 0;
				gint _tmp8_ = 0;
				Number* _tmp9_ = NULL;
				gint64 _tmp10_ = 0LL;
				gint _tmp11_ = 0;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 7805 "test-number.c"
					gint _tmp1_ = 0;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 7811 "test-number.c"
				}
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ < 10)) {
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 7821 "test-number.c"
				}
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = _tmp4_;
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = number_not (_tmp5_, 8);
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = _tmp6_;
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp5_);
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				z = _tmp7_;
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = a;
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = (~_tmp8_) & 0xFF;
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = z;
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = number_to_integer (_tmp9_);
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = expected;
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp10_ != ((gint64) _tmp11_)) {
#line 7849 "test-number.c"
					gint _tmp12_ = 0;
					Number* _tmp13_ = NULL;
					gint64 _tmp14_ = 0LL;
					gint _tmp15_ = 0;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp12_ = a;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp13_ = z;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp14_ = number_to_integer (_tmp13_);
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp15_ = expected;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp16_ = g_strdup_printf ("(%d).not () -> %lli, expected %d", _tmp12_, _tmp14_, _tmp15_);
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp17_ = _tmp16_;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp17_);
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp17_);
#line 976 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_object_unref0 (z);
#line 976 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 7876 "test-number.c"
				}
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (z);
#line 7880 "test-number.c"
			}
		}
	}
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 7886 "test-number.c"
}


void test_shift (void) {
	{
		gint a = 0;
#line 985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = 0;
#line 7895 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 7902 "test-number.c"
				gint _tmp2_ = 0;
#line 985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 7906 "test-number.c"
					gint _tmp1_ = 0;
#line 985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 7912 "test-number.c"
				}
#line 985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ < 10)) {
#line 985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 7922 "test-number.c"
				}
				{
					gint b = 0;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					b = -10;
#line 7928 "test-number.c"
					{
						gboolean _tmp3_ = FALSE;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp3_ = TRUE;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						while (TRUE) {
#line 7935 "test-number.c"
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							gint expected = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							Number* _tmp17_ = NULL;
							gint64 _tmp18_ = 0LL;
							gint _tmp19_ = 0;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!_tmp3_) {
#line 7953 "test-number.c"
								gint _tmp4_ = 0;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp4_ = b;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								b = _tmp4_ + 1;
#line 7959 "test-number.c"
							}
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp3_ = FALSE;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp5_ = b;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (!(_tmp5_ < 10)) {
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								break;
#line 7969 "test-number.c"
							}
#line 989 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp6_ = a;
#line 989 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 989 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp8_ = _tmp7_;
#line 989 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp9_ = b;
#line 989 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp10_ = number_shift (_tmp8_, _tmp9_);
#line 989 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp11_ = _tmp10_;
#line 989 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (_tmp8_);
#line 989 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							z = _tmp11_;
#line 990 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp12_ = a;
#line 990 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp13_ = b;
#line 990 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							expected = _tmp12_ << _tmp13_;
#line 991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = b;
#line 991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp14_ < 0) {
#line 7997 "test-number.c"
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp15_ = a;
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp16_ = b;
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								expected = _tmp15_ >> (-_tmp16_);
#line 8006 "test-number.c"
							}
#line 993 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp17_ = z;
#line 993 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp18_ = number_to_integer (_tmp17_);
#line 993 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp19_ = expected;
#line 993 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							if (_tmp18_ != ((gint64) _tmp19_)) {
#line 8016 "test-number.c"
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								Number* _tmp22_ = NULL;
								gint64 _tmp23_ = 0LL;
								gint _tmp24_ = 0;
								gchar* _tmp25_ = NULL;
								gchar* _tmp26_ = NULL;
#line 995 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp20_ = a;
#line 995 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp21_ = b;
#line 995 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = z;
#line 995 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp23_ = number_to_integer (_tmp22_);
#line 995 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp24_ = expected;
#line 995 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp25_ = g_strdup_printf ("(%d).shift (%d) -> %lli, expected %d", _tmp20_, _tmp21_, _tmp23_, _tmp24_);
#line 995 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp26_ = _tmp25_;
#line 995 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								fail (_tmp26_);
#line 995 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp26_);
#line 996 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (z);
#line 996 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								return;
#line 8046 "test-number.c"
							}
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_g_object_unref0 (z);
#line 8050 "test-number.c"
						}
					}
				}
			}
		}
	}
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 8059 "test-number.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	return self ? g_object_ref (self) : NULL;
#line 8066 "test-number.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 8073 "test-number.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	g_list_free (self);
#line 8082 "test-number.c"
}


void test_factorize (void) {
	{
		gint a = 0;
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		a = 0;
#line 8091 "test-number.c"
		{
			gboolean _tmp0_ = FALSE;
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			_tmp0_ = TRUE;
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			while (TRUE) {
#line 8098 "test-number.c"
				gint _tmp2_ = 0;
				GList* factors = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				GList* _tmp6_ = NULL;
				GList* _tmp7_ = NULL;
				GList* expected = NULL;
				gint _tmp8_ = 0;
				GList* _tmp9_ = NULL;
				gboolean matches = FALSE;
				GList* _tmp10_ = NULL;
				guint _tmp11_ = 0U;
				GList* _tmp12_ = NULL;
				guint _tmp13_ = 0U;
				gboolean _tmp26_ = FALSE;
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp0_) {
#line 8117 "test-number.c"
					gint _tmp1_ = 0;
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp1_ = a;
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					a = _tmp1_ + 1;
#line 8123 "test-number.c"
				}
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp0_ = FALSE;
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp2_ = a;
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!(_tmp2_ < 100)) {
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					break;
#line 8133 "test-number.c"
				}
#line 1008 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = a;
#line 1008 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
#line 1008 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp5_ = _tmp4_;
#line 1008 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp6_ = number_factorize (_tmp5_);
#line 1008 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp7_ = _tmp6_;
#line 1008 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_object_unref0 (_tmp5_);
#line 1008 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				factors = _tmp7_;
#line 1009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp8_ = a;
#line 1009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp9_ = factorize (_tmp8_);
#line 1009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				expected = _tmp9_;
#line 1011 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				matches = FALSE;
#line 1012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp10_ = factors;
#line 1012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp11_ = g_list_length (_tmp10_);
#line 1012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp12_ = expected;
#line 1012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp13_ = g_list_length (_tmp12_);
#line 1012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (_tmp11_ == _tmp13_) {
#line 1014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					matches = TRUE;
#line 8169 "test-number.c"
					{
						gint i = 0;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						i = 0;
#line 8174 "test-number.c"
						{
							gboolean _tmp14_ = FALSE;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp14_ = TRUE;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							while (TRUE) {
#line 8181 "test-number.c"
								gint _tmp16_ = 0;
								GList* _tmp17_ = NULL;
								guint _tmp18_ = 0U;
								GList* _tmp19_ = NULL;
								gint _tmp20_ = 0;
								gconstpointer _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								GList* _tmp23_ = NULL;
								gint _tmp24_ = 0;
								gconstpointer _tmp25_ = NULL;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								if (!_tmp14_) {
#line 8194 "test-number.c"
									gint _tmp15_ = 0;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									_tmp15_ = i;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									i = _tmp15_ + 1;
#line 8200 "test-number.c"
								}
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp14_ = FALSE;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp16_ = i;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp17_ = factors;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp18_ = g_list_length (_tmp17_);
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								if (!(((guint) _tmp16_) < _tmp18_)) {
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									break;
#line 8214 "test-number.c"
								}
#line 1016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp19_ = factors;
#line 1016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp20_ = i;
#line 1016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp21_ = g_list_nth_data (_tmp19_, (guint) _tmp20_);
#line 1016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp22_ = number_to_integer ((Number*) _tmp21_);
#line 1016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp23_ = expected;
#line 1016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp24_ = i;
#line 1016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp25_ = g_list_nth_data (_tmp23_, (guint) _tmp24_);
#line 1016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								if (_tmp22_ != ((gint64) ((gint) ((gintptr) _tmp25_)))) {
#line 1017 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									matches = FALSE;
#line 8234 "test-number.c"
								}
							}
						}
					}
				}
#line 1020 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp26_ = matches;
#line 1020 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				if (!_tmp26_) {
#line 8244 "test-number.c"
					gchar* factors_string = NULL;
					gchar* _tmp27_ = NULL;
					GList* _tmp28_ = NULL;
					gchar* expected_string = NULL;
					gchar* _tmp39_ = NULL;
					GList* _tmp40_ = NULL;
					gint _tmp49_ = 0;
					const gchar* _tmp50_ = NULL;
					const gchar* _tmp51_ = NULL;
					gchar* _tmp52_ = NULL;
					gchar* _tmp53_ = NULL;
#line 1022 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp27_ = g_strdup ("");
#line 1022 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					factors_string = _tmp27_;
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp28_ = factors;
#line 8262 "test-number.c"
					{
						GList* f_collection = NULL;
						GList* f_it = NULL;
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						f_collection = _tmp28_;
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
#line 8270 "test-number.c"
							Number* _tmp29_ = NULL;
							Number* f = NULL;
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							_tmp29_ = _g_object_ref0 ((Number*) f_it->data);
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							f = _tmp29_;
#line 8277 "test-number.c"
							{
								const gchar* _tmp30_ = NULL;
								const gchar* _tmp33_ = NULL;
								Number* _tmp34_ = NULL;
								gint64 _tmp35_ = 0LL;
								gchar* _tmp36_ = NULL;
								gchar* _tmp37_ = NULL;
								gchar* _tmp38_ = NULL;
#line 1025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp30_ = factors_string;
#line 1025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								if (g_strcmp0 (_tmp30_, "") != 0) {
#line 8290 "test-number.c"
									const gchar* _tmp31_ = NULL;
									gchar* _tmp32_ = NULL;
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									_tmp31_ = factors_string;
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									_tmp32_ = g_strconcat (_tmp31_, ", ", NULL);
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									_g_free0 (factors_string);
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									factors_string = _tmp32_;
#line 8301 "test-number.c"
								}
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp33_ = factors_string;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp34_ = f;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp35_ = number_to_integer (_tmp34_);
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp36_ = g_strdup_printf ("%d", (gint) _tmp35_);
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp37_ = _tmp36_;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp38_ = g_strconcat (_tmp33_, _tmp37_, NULL);
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (factors_string);
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								factors_string = _tmp38_;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp37_);
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_object_unref0 (f);
#line 8323 "test-number.c"
							}
						}
					}
#line 1029 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp39_ = g_strdup ("");
#line 1029 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					expected_string = _tmp39_;
#line 1030 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp40_ = expected;
#line 8333 "test-number.c"
					{
						GList* f_collection = NULL;
						GList* f_it = NULL;
#line 1030 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						f_collection = _tmp40_;
#line 1030 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
#line 8341 "test-number.c"
							gint f = 0;
#line 1030 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							f = (gint) ((gintptr) f_it->data);
#line 8345 "test-number.c"
							{
								const gchar* _tmp41_ = NULL;
								const gchar* _tmp44_ = NULL;
								gint _tmp45_ = 0;
								gchar* _tmp46_ = NULL;
								gchar* _tmp47_ = NULL;
								gchar* _tmp48_ = NULL;
#line 1032 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp41_ = expected_string;
#line 1032 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								if (g_strcmp0 (_tmp41_, "") != 0) {
#line 8357 "test-number.c"
									const gchar* _tmp42_ = NULL;
									gchar* _tmp43_ = NULL;
#line 1033 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									_tmp42_ = expected_string;
#line 1033 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									_tmp43_ = g_strconcat (_tmp42_, ", ", NULL);
#line 1033 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									_g_free0 (expected_string);
#line 1033 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
									expected_string = _tmp43_;
#line 8368 "test-number.c"
								}
#line 1034 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp44_ = expected_string;
#line 1034 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp45_ = f;
#line 1034 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp46_ = g_strdup_printf ("%d", _tmp45_);
#line 1034 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp47_ = _tmp46_;
#line 1034 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_tmp48_ = g_strconcat (_tmp44_, _tmp47_, NULL);
#line 1034 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (expected_string);
#line 1034 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								expected_string = _tmp48_;
#line 1034 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
								_g_free0 (_tmp47_);
#line 8386 "test-number.c"
							}
						}
					}
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp49_ = a;
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp50_ = factors_string;
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp51_ = expected_string;
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp52_ = g_strdup_printf ("(%d).factorize () -> (%s), expected (%s)", _tmp49_, _tmp50_, _tmp51_);
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp53_ = _tmp52_;
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					fail (_tmp53_);
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (_tmp53_);
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (expected_string);
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_free0 (factors_string);
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_g_list_free0 (expected);
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					__g_list_free__g_object_unref0_0 (factors);
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					return;
#line 8414 "test-number.c"
				}
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_g_list_free0 (expected);
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				__g_list_free__g_object_unref0_0 (factors);
#line 8420 "test-number.c"
			}
		}
	}
#line 1041 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	pass (NULL);
#line 8426 "test-number.c"
}


GList* factorize (gint number) {
	GList* result = NULL;
	GList* factors = NULL;
	gint _tmp0_ = 0;
	gint n = 0;
	gint _tmp2_ = 0;
#line 1046 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	factors = NULL;
#line 1047 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp0_ = number;
#line 1047 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	if (_tmp0_ < 2) {
#line 8442 "test-number.c"
		gint _tmp1_ = 0;
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp1_ = number;
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		factors = g_list_append (factors, (gpointer) ((gintptr) _tmp1_));
#line 1050 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		result = factors;
#line 1050 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		return result;
#line 8452 "test-number.c"
	}
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp2_ = number;
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	n = _tmp2_;
#line 1054 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	while (TRUE) {
#line 8460 "test-number.c"
		{
			gint factor = 0;
#line 1056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
			factor = 2;
#line 8465 "test-number.c"
			{
				gboolean _tmp3_ = FALSE;
#line 1056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				_tmp3_ = TRUE;
#line 1056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
				while (TRUE) {
#line 8472 "test-number.c"
					gint _tmp5_ = 0;
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
#line 1056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					if (!_tmp3_) {
#line 8479 "test-number.c"
						gint _tmp4_ = 0;
#line 1056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp4_ = factor;
#line 1056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						factor = _tmp4_ + 1;
#line 8485 "test-number.c"
					}
#line 1056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp3_ = FALSE;
#line 1056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp5_ = factor;
#line 1056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp6_ = n;
#line 1056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					if (!(_tmp5_ <= _tmp6_)) {
#line 1056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						break;
#line 8497 "test-number.c"
					}
#line 1058 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp7_ = n;
#line 1058 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					_tmp8_ = factor;
#line 1058 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
					if ((_tmp7_ % _tmp8_) == 0) {
#line 8505 "test-number.c"
						gint _tmp9_ = 0;
						gint _tmp10_ = 0;
						gint _tmp11_ = 0;
						gint _tmp12_ = 0;
#line 1060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp9_ = factor;
#line 1060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						factors = g_list_append (factors, (gpointer) ((gintptr) _tmp9_));
#line 1061 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp10_ = n;
#line 1061 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp11_ = factor;
#line 1061 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						n = _tmp10_ / _tmp11_;
#line 1062 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						_tmp12_ = n;
#line 1062 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						if (_tmp12_ == 1) {
#line 1063 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							result = factors;
#line 1063 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
							return result;
#line 8528 "test-number.c"
						}
#line 1064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
						break;
#line 8532 "test-number.c"
					}
				}
			}
		}
	}
#line 1044 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_g_list_free0 (factors);
#line 8540 "test-number.c"
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp7_ = 0;
#line 1072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	setlocale (LC_ALL, "C");
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_integer ();
#line 1075 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_unsigned_integer ();
#line 1076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_fraction ();
#line 1077 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_double ();
#line 1078 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_complex ();
#line 1079 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_polar ();
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_string ();
#line 1081 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_eulers ();
#line 1082 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_i ();
#line 1083 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_pi ();
#line 1085 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_is_zero ();
#line 1086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_is_negative ();
#line 1087 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_is_integer ();
#line 1088 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_is_positive_integer ();
#line 1089 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_is_natural ();
#line 1090 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_is_complex ();
#line 1091 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_sgn ();
#line 1092 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_invert_sign ();
#line 1093 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_abs ();
#line 1094 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_arg ();
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_conjugate ();
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_real_component ();
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_imaginary_component ();
#line 1098 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_integer_component ();
#line 1099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_fractional_component ();
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_fractional_part ();
#line 1101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_floor ();
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_ceiling ();
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_round ();
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_reciprocal ();
#line 1105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_epowy ();
#line 1106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_xpowy ();
#line 1107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_xpowy_integer ();
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_root3 ();
#line 1109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_sqrt ();
#line 1110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_ln ();
#line 1111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_logarithm2 ();
#line 1112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_logarithm10 ();
#line 1113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_factorial ();
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_add ();
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_subtract ();
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_multiply ();
#line 1117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_multiply_integer ();
#line 1118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_divide ();
#line 1119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_divide_integer ();
#line 1120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_modulus_divide ();
#line 1121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_sin ();
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_cos ();
#line 1133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_and ();
#line 1134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_or ();
#line 1135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_xor ();
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_not ();
#line 1138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_shift ();
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	test_factorize ();
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp0_ = fail_count;
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	if (_tmp0_ == 0) {
#line 8662 "test-number.c"
		FILE* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp1_ = stdout;
#line 1144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp2_ = pass_count;
#line 1144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		fprintf (_tmp1_, "Passed all %i tests\n", _tmp2_);
#line 8671 "test-number.c"
	} else {
		FILE* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 1146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp3_ = stdout;
#line 1146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp4_ = fail_count;
#line 1146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp5_ = pass_count;
#line 1146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		_tmp6_ = fail_count;
#line 1146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
		fprintf (_tmp3_, "Failed %i/%d tests\n", _tmp4_, _tmp5_ + _tmp6_);
#line 8687 "test-number.c"
	}
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	_tmp7_ = fail_count;
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	result = _tmp7_;
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	return result;
#line 8695 "test-number.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 1070 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/test-number.vala"
	return _vala_main (argv, argc);
#line 8705 "test-number.c"
}



