#include <gnome.h>
#include <gtk/gtk.h>

#include "makros.h"
#include "var.h"
#include "pro.h"
#include "version.h"
#include "partie.h"
#include "disk.h"
#include "menu.h"
#include "child.h"
#include "board.h"
#include "cho1.h"
#include "ini.h"


#define PIECE_SIZE 40

static char db[120] = { [0 ... 119]= -1 };
static void * db_image[120] = { [0 ... 119]= NULL };

static void * draw_piece(int f);
static void draw_board(void);

static int play_against_computer = 1;
static int analyse_mode = 0;
static int autoplay = 0;

void
quit_cb (GtkWidget *widget, void *data)
{
  destroy_all_engines();
  gtk_main_quit ();
  return;
}

void
about_cb (GtkWidget *widget, void *data)
{
  GtkWidget *about;
  const  gchar *authors[] = {
	  "Robert Wilhelm <robert@physiol.med.tu-muenchen.de>",
          NULL
          };

  char *comments = "This  program  is  part of  the  GNOME  project. " 
" Gnome-Chess comes with ABSOLUTELY NO WARRANTY. This is free " 
"software, and you are welcome to redistribute it under the conditions "
"of the GNU General Public Licence.";

  about = gnome_about_new ( "The Gnome Chess Program", VERSION,
			    "Copyright (C) 1998",
			    authors,
			    comments,
			    NULL);
  gtk_widget_show (about);
  return;
}

void
load_cb (GtkWidget *widget, void *data)
{
  load_game();
  update_board();
  return;
}

void
save_cb (GtkWidget *widget, void *data)
{
  save_game();
  return;
}

void
takeback_cb (GtkWidget *widget, void *data)
{
  move_back();
  update_board();
  return;
}

void
forward_cb (GtkWidget *widget, void *data)
{
  move_forward();
  update_board();
  return;
}

void
first_cb (GtkWidget *widget, void *data)
{
  move_to_start();
  update_board();
  return;
}

void
last_cb (GtkWidget *widget, void *data)
{
  move_to_end();
  update_board();
  return;
}

void
new_game_cb (GtkWidget *widget, void *data)
{
  engine_write(first_chess_programm,"new\n");
  ini_game();
  gtk_clist_clear( GTK_CLIST(board.movelist));
  update_board();
  return;
}


void
two_players_cb (GtkWidget *widget, void *data)
{
  play_against_computer = 0;
  return;
}


void
two_machines_cb (GtkWidget *widget, void *data)
{
  autoplay = 1;
  return;
}

void
analyse_mode_cb (GtkWidget *widget, void *data)
{
  analyse_mode = 1;
  play_against_computer=1;
  engine_write(first_chess_programm,"analyze\n");
  return;
}

void
move_now_cb (GtkWidget *widget, void *data)
{
  engine_write(first_chess_programm,"?\n");
  return;
}

void
go_cb (GtkWidget *widget, void *data)
{
  engine_write(first_chess_programm,"go\n");
  return;
}

static int press(GnomeCanvasItem *item, GdkEvent *event, gpointer data)
{
  static double  x,y; 
  static int ff,ff1;
  static int xi,yi;
  int xt,yt;
  double new_x, new_y;

  if (data)
    {
      item = db_image[(unsigned long)data];
      if ( item == NULL) return 0;
    }

  switch (event->type)
    {
	case GDK_BUTTON_PRESS:
		switch (event->button.button) 
		  {
		  case 1:
		    xi = x = event->button.x;
		    yi = y = event->button.y;
		    gnome_canvas_item_raise_to_top (item);
		  
		    xt = x / PIECE_SIZE;
		    yt = y / PIECE_SIZE;

		    ff = A1 + xt  + 10 * (7-yt);
		    ff1 = ff;
		    break;

		  default:
		    break;
		  }
		
		break;

    case GDK_MOTION_NOTIFY:
      if ((event->motion.state & GDK_BUTTON1_MASK))
	{
	  new_x = event->motion.x;
	  new_y = event->motion.y;

	  gnome_canvas_item_move (item, new_x - x, new_y - y);
	  x = new_x;
	  y = new_y;
	}
      break;

    case GDK_BUTTON_RELEASE:
      xt = x / PIECE_SIZE;
      yt = y / PIECE_SIZE;

      ff = A1 + xt  + 10 * (7-yt);

      /* printf("move: %d %d \n",ff1,ff); */
      ff=reg_zug(ff1,ff);
      if (ff) 
	{
	  int p = feld[ff1];
	  if (play_against_computer)
	    move_to_engine(ff1,ff);
	  make_move(ff1,ff);
	  notation_update(p,ff1,ff);
	  update_board();
	}
      else 
	  gnome_canvas_item_move (item, xi - x, yi - y);
      break;
    default:
    }

  return 0;
}

GtkWidget * init_board(void)
{
  static char *titles[] ={ _("Number"),_("White"),_("Black")};
  GtkWidget *table;
  GtkWidget *scrolled_window;
  int i;

  table = gtk_table_new (2,2,FALSE);
  gtk_container_border_width (GTK_CONTAINER (table), 4);

  board.messages = gtk_text_new (FALSE, FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), board.messages, 0, 2, 1, 2);
  gtk_widget_show (board.messages);


  scrolled_window =gtk_scrolled_window_new (NULL, NULL);
  board.movelist = gtk_clist_new_with_titles(3,titles);
  //  gtk_clist_set_row_height (GTK_CLIST (board.movelist), 18);
  gtk_clist_set_selection_mode(GTK_CLIST (board.movelist),GTK_SELECTION_BROWSE);
  gtk_clist_column_titles_passive(GTK_CLIST(board.movelist));
  gtk_widget_set_usize (board.movelist, 200, -1);

  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),       
                                GTK_POLICY_AUTOMATIC,             
                                GTK_POLICY_AUTOMATIC);          

  for (i = 0; i < 3; i++)
    gtk_clist_set_column_width (GTK_CLIST (board.movelist), i, 50);

  gtk_widget_set_usize (board.movelist, 200, PIECE_SIZE * 8 );

  gtk_container_add (GTK_CONTAINER (scrolled_window), board.movelist);
  gtk_table_attach_defaults (GTK_TABLE (table), scrolled_window, 1, 2, 0, 1);
  gtk_widget_show (board.movelist);
  gtk_widget_show (scrolled_window);



  board.canvas = gnome_canvas_new ();
  gtk_widget_set_usize (board.canvas, PIECE_SIZE * 8 + 1, PIECE_SIZE * 8 + 1);
  gnome_canvas_set_scroll_region (GNOME_CANVAS (board.canvas), 0, 0, PIECE_SIZE * 8 + 1, PIECE_SIZE * 8 + 1);

  draw_board();
  update_board();

  gtk_table_attach_defaults (GTK_TABLE (table), board.canvas, 0, 1 , 0, 1);
  gtk_widget_show (board.canvas);

  gtk_widget_show (table);

  return table;
}

void update_board(void)
{

  int i,j;

  for ( i=0;i<8;i++)
    for ( j=0;j<8;j++)
      {
	int n= H8 - i * 10 - j;

	if (feld[n] != db[n])
	  {
	    if (db_image[n])
	      gtk_object_destroy (GTK_OBJECT (db_image[n]));
	    db_image[n] = draw_piece(n);
	    db[n]=feld[n];
	  }
      }
  gtk_widget_show (board.canvas);
}

static void * draw_piece(int f)
{
	GdkImlibImage *im;
	GnomeCanvasItem *image;
        GnomeCanvasGroup *root;
	double x,y;

        int i,j;

	int figur = feld[f];
	char *s;

	root = GNOME_CANVAS_GROUP (gnome_canvas_root (GNOME_CANVAS (board.canvas)));

        i= 9 - f / 10 ;
	j= f % 10 - 1;
 
        x = j * PIECE_SIZE;
	y = i * PIECE_SIZE;


	switch (figur) 
	  {
	  case LEER:  s= "";        break;
	  case WB  :  s = "P.png";  break;
	  case WS  :  s = "N.png";  break;
	  case WL  :  s = "B.png";  break;
	  case WT  :  s = "R.png";  break;
	  case WD  :  s = "Q.png";  break;
	  case WK  :  s = "K.png";  break;
	  case SB  :  s = "p.png";  break;
	  case SS  :  s = "n.png";  break;
	  case SL  :  s = "b.png";  break;
	  case ST  :  s = "r.png";  break;
	  case SD  :  s = "q.png";  break;
	  case SK  :  s = "k.png";  break;
	  default  :  abort();
	  }

	if (*s)
	  {
	    char *tmp = g_strconcat("gnome-chess/",s,NULL);
	    char *fname = gnome_unconditional_pixmap_file (tmp);
	    im = gdk_imlib_load_image (fname);
	    g_free(fname);  
	    g_free(tmp);
	    if(!im) 
	      {
		fname = g_strconcat("../Sets/",s,NULL);
		im = gdk_imlib_load_image (fname);
		g_free(fname);
	      }  
	    if(!im) 
	      {
		fprintf(stderr,"pic %s not found",s);
		abort();
	      }
	    image = gnome_canvas_item_new (root,
				       gnome_canvas_image_get_type (),
				       "image", im,
				       "x", x,
				       "y", y,
				       "width", (double) im->rgb_width,
				       "height", (double) im->rgb_height,
				       "anchor", GTK_ANCHOR_NW,
				       NULL);

	    gtk_signal_connect (GTK_OBJECT (image), "event",
				(GtkSignalFunc) press,
				NULL);

	    return image;
	  }

	return 0;
}

static void draw_background(int f)
{
	GnomeCanvasItem *image;
        GnomeCanvasGroup *root;
	double x,y;

        int i,j;

	root = GNOME_CANVAS_GROUP (gnome_canvas_root (GNOME_CANVAS (board.canvas)));

        i= 9 - f / 10 ;
	j= f % 10 - 1;
 
        x = j * PIECE_SIZE;
	y = i * PIECE_SIZE;

	image = gnome_canvas_item_new (root,
				       gnome_canvas_rect_get_type (),
				       "x1", x,
				       "y1", y,
				       "x2", x + (double) PIECE_SIZE,
				       "y2", y + (double) PIECE_SIZE,
				       "fill_color", (i+j) & 1 ? "darkgreen":"lightgreen",
              			       "outline_color", "black",
				       "width_pixels", 0,
				       NULL);

	gtk_signal_connect (GTK_OBJECT (image), "event",
			    (GtkSignalFunc) press,
			    (void *)(unsigned long) f);

}

static void draw_board(void)
{
  int i,j;

  for ( i=0;i<8;i++)
    for ( j=0;j<8;j++)
      draw_background(H8 - i * 10 - j);
}
